<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clasificacionesticket extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->model("Clasificacionesticket_model");
		#	Si no está loggeado o no tiene permisos para este módulo,
		#	regresa al login	
		$session = $this->session->userdata();
		if(!isset($session["permisos"]) || 
		   !in_array("CLASTCKT", $session["permisos"])){
			redirect(base_url());
		}
	}

	/**
	 * CARGA VISTAS DEL MÓDULO
	 * @return HTML
	 */
	public function index()
	{
		$resources = array(
			"session"       => $this->session->userdata(),
			"modulojs"      => "clasificacionesticket.js",	
		);

		$this->load->view("templates/header",$resources);
		$this->load->view("templates/sidebar",$resources);
		$this->load->view("clasificacionesticket",$resources);
		$this->load->view("templates/footer",$resources);
	}

	/**
	  * LISTADO DE CLASIFICACIONES TICKET
	  */
	public function listarClasificaciones()
	{
		#	permisos
		$permisos = $this->session->userdata("permisos");

		$draw = intval($this->input->post("draw"));
		// Registros a saltar
        $skip = $this->input->post("start");
        // Numero de registros a tomar
        $take = $this->input->post("length");
        // Columnas
        $columns = $this->input->post("columns");
        // Datos del Sort
        $order_data = $this->input->post("order")[0];
        // Nombre de la Columna a Ordenar
        $order_field = $columns[$order_data["column"]]["data"];
        // Dirección del Orden
        $order = $order_data["dir"];
        // Valor de búsqueda
        $busqueda = $this->input->post("search")["value"];
        // Total de registros
        $total =  $this->Clasificacionesticket_model->COUNT_Clasificaciones("");

        if($busqueda){
            $usuarios = $this->Clasificacionesticket_model->CNS_Clasificaciones_Match($skip, $take, $order_field, $order, $busqueda);
            $filtered_rows =  $this->Clasificacionesticket_model->COUNT_Clasificaciones($busqueda);
        }else{
            $usuarios = $this->Clasificacionesticket_model->CNS_Clasificaciones($skip, $take, $order_field, $order);
            $filtered_rows = $total;
        }

        $data = array(
            "draw" => $draw,
            "recordsTotal" =>  $total,
            "recordsFiltered" =>  $filtered_rows,
            "data" => $usuarios   
        );        
        echo json_encode($data);
	}


	/** 
 	  *	 MUESTRA FORMULARIO NUEVO / EDICIÓN	
	  */
	public function muestraFormulario(){
		#	Variables de sesión: id_usuario y rol
		$Id_Clasificacion_Ticket = $this->input->post("Id_Clasificacion_Ticket");
		
		#	Si se recibe el Id_Clasificacion_Ticket es un UPDATE
		if(is_numeric($Id_Clasificacion_Ticket)){
			$data["clasificacion"] = $this->Clasificacionesticket_model->CNS_ClasificacionByID($Id_Clasificacion_Ticket);		
		}

		# 	Clave de usuario
		$last_cve  	   = $this->Clasificacionesticket_model->CNS_LastClasificacion();
		$consecutivo   = $last_cve ? ($last_cve["Last"] + 1): 1;
		$data["Clave"] = "CLASTKT-" . str_pad($consecutivo, 2, "0", STR_PAD_LEFT);

		$this->load->view("templates/formularios/form_clasificacionticket",$data);
	}

	/**
	 * INSERTA / ACUTALIZA CLASIFICACION EN LA TABLA
	 * SI RECIBE Id_Clasificacion_Ticket => Actualiza
	 * DE LO CONTRARIO INSERTA
	 */
	public function guardaClasificacion(){
		#	Establece zona Horaria
		date_default_timezone_set("America/Mexico_City");

		#	Variables de sesión: id_usuario y rol
		$Id_Clasificacion_Ticket = $this->input->post("Id_Clasificacion_Ticket");

		#	Array de validaciones
		$rules = array(
			array("field" => "txtclave", "label" => "Clave", "rules" => "required|max_length[100]|html_escape|trim"),
			array("field" => "txtclasificacion", "label" => "Clasificación", "rules" => "required|max_length[100]|html_escape|trim"),
			array("field" => "txadescripcion", "label" => "Descripción", "rules" => "required|max_length[300]|html_escape|trim"),
			array("field" => "rdostatus", "label" => "Status", "rules" => "required|html_escape|trim|integer")
		);

		#	Carga las librerias
		$this->load->library("form_validation");
		$this->form_validation->set_rules($rules);

		#	Si cumple las validaciones		
		if ($this->form_validation->run() == FALSE) {
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}

		#	Datos a guardar
		$dataarray = array(
			"Clave"            => $this->input->post("txtclave"),
			"Nombre"           => $this->input->post("txtclasificacion"),
			"Descripcion"      => $this->input->post("txadescripcion"),
			"Status"           => intval($this->input->post("rdostatus")),
			"Usuario_Registra" => $this->session->userdata("Id_Usuario"),
			"Fecha_Actualiza"  => date("Y-m-d H:i:s"),
		);

		#	Si se recibe Id_Clasificacion_Ticket: Acutaliza en base de datos
		if(is_numeric($Id_Clasificacion_Ticket)){
			$ar = $this->Clasificacionesticket_model->UPD_Clasificacion($Id_Clasificacion_Ticket,$dataarray);
			if($ar){
				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha agregado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}else{
			#	Si no se recibe Id_Clasificacion_Ticket: Inserta en base de datos
			$dataarray["Fecha_Alta"] = date("Y-m-d H:i:s");
			$last = $this->Clasificacionesticket_model->INS_Clasificacion($dataarray);
			
			#	Si se insertó
			if($last){
				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha agregado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}
	}

	/**
	 * ELIMINA UNA CLASIFICACIÓN
	 */
	public function eliminarClasificacion(){
		#	Id_Clasificacion_Ticket para eliminar
		$Id_Clasificacion_Ticket = $this->input->post("Id_Clasificacion_Ticket");

		$delu  = $this->Clasificacionesticket_model->DEL_Clasificacion($Id_Clasificacion_Ticket);
		if($delu > 0){
			echo json_encode(array("head" => "_ok:","body" => "Excelete hemos eliminado tu registro"));
		}else{
			echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al eliminar tu registro, intentalo nuevamente"));
		}	
	}

}

/* End of file Clasificacionesticket.php */
/* Location: ./application/controllers/Clasificacionesticket.php */