<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cron extends MY_Controller {

	public function __construct()
	{
		parent::__construct();		
	}

    //Respaldo de base de datos diario
	public function backup(){
        $this->load->helper('file');
        $this->load->helper('download');
        $this->load->library('zip');

		$this->load->dbutil();
        $db_format = array('format' => 'zip', 'filename' => 'marisa_tickets_application_backup.sql');
        $backup = $this->dbutil->backup($db_format);
        $dbname = 'backup-on-'.date('Y-m-d H:i:s').'.zip';
                  // system('zip -P pass file.zip file.txt');
        // $dbname = system('zip -P Out$2017ftp '+$dbname);
        $save = 'assets/db_backup/'.$dbname;

        write_file($save,$backup);
        force_download($dbname,$backup);
	}

    public function send_notification(){    
        //Tomamos el último archivo que se guardó
        chdir("assets/db_backup");
        array_multisort(array_map('filemtime', ($files = glob("*.*"))), SORT_DESC, $files);

        // Creamos la ruta para enviar el adjunto y borrar el archivo
        $file = $_SERVER["DOCUMENT_ROOT"]."/tickets/assets/db_backup/".$files[0];

        //Envía correo a usuarios administradores // desarrollo@creeartelo.mx
        $data["nombre"]  = "Guadalupe Ulloa";
        $data["archivo"] = $files[0];

        $mensaje_admon = $this->load->view("templates/correos/noti_backup",$data,true);        
        $arraycorreo = array(
            "remitente_mail" => $mailsitio["SMTPUSER"],
            "remitente_name" => $mailsitio["NAMEREMT"],
            "destinatario"   => "desarrollo@creeartelo.mx",
            "asunto"         => "Backup de Marisa tickets",
            "mensaje"        => $mensaje_admon,
            "attach"         => $file
        );

        $res_admon = $this->enviaCorreo($arraycorreo);

        unlink($file);
    }
}

/* End of file Cron.php */
/* Location: ./application/controllers/Cron.php */