<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Missucursales extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Missucursales_model");

		#	Si no está loggeado o no tiene permisos para este módulo,
		#	regresa al login	
		$session = $this->session->userdata();
		if(!isset($session["permisos"]) || 
		   !in_array("SUCS", $session["permisos"])){
			redirect(base_url());
		}
	}
	/**
	 * CARGAS VISTAS DEL MÓDULO
	 */
	public function index()
	{
		$resources = array(
			"session"       => $this->session->userdata(),
			"modulojs"      => "missucursales.js",	
		);
        
		$this->load->view("templates/header",$resources);
		$this->load->view("templates/sidebar",$resources);
		$this->load->view("missucursales",$resources);
		$this->load->view("templates/footer",$resources);
	}

	public function generateQR($Id_Sucursal){
		#	Consulta sucursal por ID
		$sucursal = $this->Missucursales_model->CNS_SucursalByID($Id_Sucursal);
        
		#	Carga libreria
		$this->load->library("QRLib");
		#	Configuración
		$level = "L";
	    $matrixPointSize = 10;
	    
	    #	Data del QR
	    $path = "./qrsucursales/" . $sucursal["Id_Direccion"] . ".png";
	    $data = $sucursal["Sucursal"] . "?" .
	    		$sucursal["Latitud"] . "?" .
	    		$sucursal["Longitud"];


	    #	Genera QR
	    QRcode::png($data, $path, $level, $matrixPointSize, 2);    
		
		header("Content-type: image/png");
		header("Content-Disposition: attachment; filename='" . $sucursal["Sucursal"] ."_QR.png'");
	    header("Cache-Control: max-age=0"); 
	    readfile($path);
		
	}

	/**
	  * LISTADO DE SUCURSALES
	  */
	public function listarSucursales()
	{
		$draw = intval($this->input->post("draw"));
		// Registros a saltar
        $skip = $this->input->post("start");
        // Numero de registros a tomar
        $take = $this->input->post("length");
        // Columnas
        $columns = $this->input->post("columns");
        // Datos del Sort
        $order_data = $this->input->post("order")[0];
        // Nombre de la Columna a Ordenar
        $order_field = $columns[$order_data["column"]]["data"];
        // Dirección del Orden
        $order = $order_data["dir"];
        // Valor de búsqueda
        $busqueda = $this->input->post("search")["value"];
        // Total de registros
        $total =  $this->Missucursales_model->COUNT_Sucursales();

        if($busqueda){
            $tickets = $this->Missucursales_model->CNS_SucursalesMatch($skip, $take, $order_field, $order, $busqueda);
            $filtered_rows = sizeof($tickets);
        }else{
            $tickets = $this->Missucursales_model->CNS_Sucursales($skip, $take, $order_field, $order);
            $filtered_rows = $total;
        }

        $data = array(
            "draw" => $draw,
            "recordsTotal" =>  $total,
            "recordsFiltered" =>  $filtered_rows,
            "data" => $tickets   
        );        
        echo json_encode($data);
	}

	/** 
 	  *	 MUESTRA FORMULARIO NUEVO / EDICIÓN	
	  */
	public function muestraFormulario(){
		#	Recibe identificador de la dirección
		$Id_Direccion = $this->input->post("Id_Direccion");
		$data = array();
		#	Si se recibe el Id_Direccion es un UPDATE
		if(is_numeric($Id_Direccion)){
			$data["sucursal"] = $this->Missucursales_model->CNS_SucursalByID($Id_Direccion);
		}

		#	Carga vista
		$this->load->view("templates/formularios/form_sucursal",$data);
	}

	/**
	 * INSERTA / ACUTALIZA DIRECCION
	 * SI RECIBE Id_Direccion => Actualiza
	 * DE LO CONTRARIO INSERTA
	 */
	public function guardaSucursal(){
		#	Establece zona Horaria
		date_default_timezone_set("America/Mexico_City");
		#	Id_Direccion para saber si es UPDATE
		$Id_Direccion = $this->input->post("Id_Direccion");

		#	Array de validaciones
		$rules = array(
			array("field" => "txtclave", "label" => "Clave", "rules" => "required|max_length[20]|is_unique[Direcciones.Clave.$Id_Direccion]|html_escape|trim"),
			array("field" => "txtsucursal", "label" => "Sucursal", "rules" => "required|max_length[50]|html_escape|trim"),
			array("field" => "txtcalle", "label" => "Calle", "rules" => "required|max_length[100]|html_escape|trim"),
			array("field" => "txtnum_ext", "label" => "Num. Exterior", "rules" => "required|max_length[30]|html_escape|trim"),
			array("field" => "txtnum_int", "label" => "Num. Interior", "rules" => "max_length[30]|html_escape|trim"),
			array("field" => "txtcolonia", "label" => "Colonia", "rules" => "required|max_length[100]|html_escape|trim"),
			array("field" => "txtmunicipio", "label" => "Municipio", "rules" => "required|max_length[150]|html_escape|trim"),			
			array("field" => "txtestado", "label" => "Estado", "rules" => "required|max_length[150]|html_escape|trim"),
			array("field" => "txtcp", "label" => "Código Postal", "rules" => "required|integer|exact_length[5]|html_escape|trim"),
			array("field" => "emlcorreo", "label" => "Correo Electrónico", "rules" => "required|valid_email|max_length[50]|is_unique[Direcciones.Correo_Electronico.$Id_Direccion]|html_escape|trim"),
			array("field" => "txtlatitud", "label" => "Latitud", "rules" => "required|numeric|html_escape|trim"),
			array("field" => "txtlongitud", "label" => "Longitud", "rules" => "required|numeric|html_escape|trim"),
			array("field" => "rdostatus", "label" => "Status", "rules" => "required|html_escape|trim|integer"),
		);

		#	Carga las librerias
		$this->load->library("form_validation");
		$this->form_validation->set_rules($rules);

		#	Si cumple las validaciones		
		if ($this->form_validation->run() == FALSE) {
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}

		$dataarray = array(
			"Id_Empresa"         => $this->session->userdata("Id_Empresa"),
			"Clave"              => $this->input->post("txtclave"),
			"Sucursal"           => $this->input->post("txtsucursal"),
			"Calle"              => $this->input->post("txtcalle"),
			"No_Ext"             => $this->input->post("txtnum_ext"),
			"No_Int"             => $this->input->post("txtnum_int"),
			"Colonia"            => $this->input->post("txtcolonia"),
			"Municipio"          => $this->input->post("txtmunicipio"),
			"Estado"             => $this->input->post("txtestado"),
			"Codigo_Postal"      => $this->input->post("txtcp"),
			"Correo_Electronico" => $this->input->post("emlcorreo"),
			"Latitud"            => $this->input->post("txtlatitud"),
			"Longitud"           => $this->input->post("txtlongitud"),
			"Status"             => intval($this->input->post("rdostatus")),
			"Usuario_Registra"   => $this->session->userdata("Id_Usuario"),
			"Fecha_Actualiza"    => date("Y-m-d H:i:s"),
		);

		#	Si se recibe Id_Direccion: Acutaliza en base de datos
		if(is_numeric($Id_Direccion)){
			$ar = $this->Missucursales_model->UPD_Direccion($Id_Direccion,$dataarray);
			if($ar){
				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha guardado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}else{
		#	Si no se recibe Id_Direccion: Inserta en base de datos
			$dataarray["Fecha_Alta"] = date("Y-m-d H:i:s");
			$last = $this->Missucursales_model->INS_Direccion($dataarray);
			if($last){
				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha guardado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}
	}

	/**
	 * ELIMINA UNA SUCURSAL 
	 */
	public function eliminarSucursal(){
		#	Id_Direccion para saber si es UPDATE
		$Id_Direccion = $this->input->post("Id_Direccion");

		$ar = $this->Missucursales_model->DEL_Direccion($Id_Direccion);
		if($ar){
			echo json_encode(array("head" => "_ok:","body" => "Excelete hemos eliminado tu registro"));
		}else{
			echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al eliminar tu registro, intentalo nuevamente"));
		}	
	}


}

/* End of file Missucursales.php */
/* Location: ./application/controllers/Missucursales.php */