<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class App_model extends CI_Model {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	/**
	 * CONSULTA UN USUARIO ACTIVO PARA EL LOGIN
	 * @param STRING $usuario    USUARIO
	 * @param STRING $contrasena CONTRASEÑA ENCRIPTADA
	 */
	function CALL_Login($usuario, $contrasena)
	{
		$query = $this->db->query("CALL SP_Login('$usuario','$contrasena')");
		$data  = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	  *	CONSULTA LOS TICKETS DEL USUARIO
	  *	@param INT $data_array IDENTIFICADOR DEL USUARIO
	  */
	function CALL_SPCNS_TicketsUsuario($Id_Usuario)
	{
		$data = $this->db->query("CALL SPCNS_Tickets_Usuario($Id_Usuario)");
		return $data->result_array();
	}

	/**
	  *	INSERTA COORDENADAS DEL TICKET
	  *	@param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	  */
	function CALL_SPINS_Ticket_Coordenadas($data_array)
	{	
		$str    = "CALL SPINS_Ticket_Coordenadas(?,?,?,?,?)";
		$query  = $this->db->query($str,$data_array);
		$data   = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	  *	INSERTA DIAGNOSTICO DEL TICKET
	  *	@param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	  */
	function CALL_SPINS_Ticket_Diagnostico($data_array)
	{
		$str    = "CALL SPINS_Ticket_Diagnostico(?,?,?)";
		$query  = $this->db->query($str,$data_array);
		$data   = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	  *	INSERTA EVIDENCIA FOTOS
	  *	@param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	  */
	function CALL_SPINS_Evidencia_Fotos($data_array)
	{
		$str   = "CALL SPINS_Evidencia_Fotos(?, ?, ?)";
		$query = $this->db->query($str, $data_array);
		$data  = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}	

	/**
	  *	CONSULTA TIEMPOS TICKET
	  *	@param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	  */
	function CALL_SPCNS_Tiempos_Ticket($data_array)
	{
		$str   = "CALL SPCNS_Tiempos_Ticket(?,?)";
		$query = $this->db->query($str,$data_array);
		$data  = $query->result_array();
		$query->next_result();
		$query->free_result();
		return $data;
	}	

	/**
	  *	INSERTA TIEMPO TICKET
	  * @param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	  */
	function CALL_SPINS_Tiempo_Ticket($data_array)
	{
		$str   = "CALL SPINS_Tiempo_Ticket(?, ?, ?, ?)";
		$query = $this->db->query($str,$data_array);
		$data  = $query->result();

		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	  *	INSERTA TICKET FINALIZA
	  * @param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	  */
	function CALL_SPINS_Ticket_Finaliza($data_array)
	{
		$str   = "CALL SPINS_Ticket_Finaliza(?, ?, ?, ?)";
		$query = $this->db->query($str,$data_array);
		$data  = $query->result();

		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	 * ACTUALIZA EL STATUS DEL TICKET
	 * @param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	 */
	function CALL_SPUPD_Ticket_Status($data_array){
		$str    = "CALL SPUPD_Ticket_Status(?, ?)";		
		$query  = $this->db->query($str,$data_array);
		$data   = $query->result();
		$query->next_result();
		$query->free_result();
		return $data;
	}
	
	/**
	 * ACTUALIZA UBICACIÓN USUARIO
	  * @param ID $Id_Usuario IDENTIFICADOR DEL USUARIO
	 * @param ARRAY $data_array ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Ubicacion_Usuario($Id_Usuario,$data_array){
		$this->db->where("Id_Usuario", $Id_Usuario);
		$this->db->update("Ubicacion_Usuarios", $data_array);
		return $this->db->affected_rows();
	}	

	/**
	 * CONSULTA REGISTRO DE TICKETS POR SU ID
	 * @param INT $Id_Ticket IDENTIFICADOR DEL TICKET
	 */
	function CALL_SPCNS_TicketByID($Id_Ticket){
		$query = $this->db->query("CALL SPCNS_TicketByID($Id_Ticket)");
		$data  = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	 * CONSULTA LOS USUARIOS DE LA EMPRESA DE UN USUARIO A LOS QUE SE LES PUEDE REASIGNAR EL TICKET
	 * @param [INT] $Id_Usuario [IDENTIFICADOR DEL USUARIO]
	 */
	function CALL_SPCNS_Otros_Usuarios_Empresa($Id_Usuario){
		$query = $this->db->query("CALL SPCNS_Otros_Usuarios_Empresa($Id_Usuario)");
		$data  = $query->result_array();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	 * ACTUALIZA EL USUARIO ASIGNADO A UN TICKET
	 * @param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	 */
	function CALL_SPUPD_Ticket_Usuario($data_array){
		$str    = "CALL SPUPD_Ticket_Usuario(?, ?)";		
		$query  = $this->db->query($str,$data_array);
		$data   = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	 * ACTUALIZA EL COSTO EN LA TABLA FINALIDA
	 * @param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	 */
	function CALL_SPUPD_Finaliza_Ticket($data_array){
		$str    = "CALL SPUPD_Ticket_Finaliza(?, ?)";		
		$query  = $this->db->query($str,$data_array);
		$data   = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	 * ACTUALIZA EL TOKENFCM DEL USUARIO
	 * @param ARRAY $data_array ARRAY CON LOS PARAMETROS PARA EL SP
	 */
	function CALL_SPUPDA_Token_Usuario($data_array){
		$str   = "CALL SPUPD_Token_Usuario(?,?,?)";
		$query = $this->db->query($str,$data_array);
		$data  = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}

	/**
	 * ACTUALIZA UBICACIÓN USUARIO
	  * @param ID $Id_Usuario IDENTIFICADOR DEL USUARIO
	 * @param ARRAY $data_array ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function CALL_SPUPD_Ubicacion_Usuario($data_array){
		$str   = "CALL SPUPD_Ubicacion_Usuario(?,?,?,?)";
		$query = $this->db->query($str,$data_array);
		$data  = $query->row();
		$query->next_result();
		$query->free_result();
		return $data;
	}	

	/**
	 *  CONSULTA LOS CORREOS A LOS QUE SE LES DEBE ENVIAR CC DEL TICKET
	 * @param [ARRAY ASSOC] $data_array [ARRAY CON EL ID TICKET]
	 */
	function CALL_SPCNS_Usuarios_CC($data_array){
		$str   = "CALL SPCNS_Usuarios_CC(?)";
		$query = $this->db->query($str,$data_array);
		$data  = $query->result_array();
		$query->next_result();
		$query->free_result();
		return $data;
	}	


	/**
	 * CONSULTA UN TICKET POR SI NUMERO DE SEGUIMIENTO
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketByNum($Num_Seguimiento){
		$this->db->select("t.Id_Ticket,t.Id_Usuario, t.Id_Direccion, t.Num_Seguimiento, e.Razon_Social, d.Sucursal, 
						   CONCAT(ur.Nombre, ' ', ur.Apellidos) as Usuario_Reporta, c.Nombre as Clasificacion,
						   CONCAT(d.Calle,' ', d.No_Ext,' ', d.No_Int,' ', d.Colonia,' ', d.Municipio,' ', d.Estado) as Direccion, 
						   t.Descripcion,t.Observaciones, t.Fecha_Alta,s.Orden, CONCAT(u.Nombre, ' ', u.Apellidos) as Usuario");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Usuarios as ur", "t.Usuario_Registra = ur.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->where("t.Num_Seguimiento", $Num_Seguimiento);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA DIAGNOSTICO DE TICKET POR SU ID
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketDiagnostico($Id_Ticket){
		$this->db->select("Diagnostico,Material");
		$this->db->from("Ticket_Diagnostico");
		$this->db->where("Id_Ticket", $Id_Ticket);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA EVIDENCIA EN IMAGENES POR ID_TICKET
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketImagenes($Id_Ticket, $Tipo = null){
		$this->db->select("Tipo, Ruta_Imagen");
		$this->db->from("Evidencia_Fotos");
		$this->db->where("Id_Ticket", $Id_Ticket);
		
		#	Si se recibe el tipo de parametro, se filtra
		if($Tipo){
			$this->db->where("Tipo", $Tipo);	
		}
		
		$query = $this->db->get();
		return $query->result_array();
	}	

	/**
	 * CONSULTA TABLA DE FINALIZA POR SU ID
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketFinaliza($Id_Ticket){
		$this->db->select("Costo, Nombre_Supervisor, Observaciones, Fecha_Alta");
		$this->db->from("Ticket_Finaliza");
		$this->db->where("Id_Ticket", $Id_Ticket);
		
		$query = $this->db->get();
		return $query->result_array();
	}
}

/* End of file App_model.php */
/* Location: ./application/models/App_model.php */