<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Missucursales_model extends CI_Model {
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	
	/**
	  *	CUENTA EL TOTAL DE CLIENTES EN LA TABLA
	  */
	function COUNT_Sucursales(){
		$this->db->select("Id_Direccion");
		$this->db->from("Direcciones");
		return $this->db->count_all_results();
	}

	/**
	 * CONSULTA CLIENTES CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_Sucursales($Skip, $Take, $Order_Field, $Order){
		$this->db->select("Id_Direccion, Clave, Sucursal, Correo_Electronico, Status,
						   CONCAT(Calle, ' ', No_Ext, ' ', No_Int,' ',Colonia,' ',Municipio,' ',Estado) AS Direccion");
		$this->db->from("Direcciones");
		$this->db->order_by($Order_Field, $Order);
		$this->db->group_by("Id_Direccion");
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA CLIENTES CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_SucursalesMatch($Skip, $Take, $Order_Field, $Order, $Match){
		$this->db->select("Id_Direccion, Clave, Sucursal, Correo_Electronico, Status,
						   CONCAT(Calle, ' ', No_Ext, ' ', No_Int,' ',Colonia,' ',Municipio,' ',Estado) AS Direccion");
		$this->db->from("Direcciones");
		$this->db->like("CONCAT(Clave, ' ',Sucursal, ' ', Calle, ' ', No_Ext, ' ', No_Int,' ',Colonia,' ',Municipio,' ',Estado, ' ', Correo_Electronico)", $Match);
		$this->db->order_by($Order_Field, $Order);
		$this->db->group_by("Id_Direccion");
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA UNA SUCURSAL POR SI ID
	 * @param INT $Id_Direccion IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_SucursalByID($Id_Direccion){
		$this->db->select("Id_Direccion, Clave, Sucursal, Calle, No_Ext, No_Int, Colonia,
						   Municipio, Estado, Codigo_Postal, Correo_Electronico, Latitud, Longitud, Status");
		$this->db->from("Direcciones");
		$this->db->where("Id_Direccion", $Id_Direccion);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * INSERTA DIRECCION
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Direccion($datarray){
		$this->db->insert("Direcciones", $datarray);
		return $this->db->insert_id();
	}

	/**
	 * ACTUALIZA DIRECCION
	 * @param INT $Id_Direccion IDENTIFICADOR DE LA DIRECCIÓN
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Direccion($Id_Direccion,$datarray){
		$this->db->where("Id_Direccion", $Id_Direccion);
		$this->db->update("Direcciones", $datarray);
		return $this->db->affected_rows();
	}

	/**
	 * ELIMINA DIRECCIÓN POR SU ID
	 * @param INT $Id_Direccion IDENTIFICADOR DE LA DIRECCIÓN
	 */
	function DEL_Direccion($Id_Direccion){
		$this->db->where("Id_Direccion", $Id_Direccion);
		$this->db->delete("Direcciones");
		return $this->db->affected_rows();
	}
}

/* End of file Missucursales_model.php */
/* Location: ./application/models/Missucursales_model.php */

