rules_validation = {
    txtclave:{
        required: true,
        maxlength: 10
    },
    txtclasificacion:{
        required: true,
        maxlength: 100
    },
    txadescripcion:{
        required: true,
        maxlength: 300
    }
}

// INICIALIZA DATATABLE
$('#data-table').DataTable({
    processing: true,
    serverSide: true,
    order: [[0 , "asc" ]],
    language: {
      url: base_url+"assets/libs/data-tables/json/spanish.json",
    },
    responsive: {
        details: {
            display: $.fn.dataTable.Responsive.display.childRowImmediate,
            type: ''
        }
    },
    ajax: {
        url: base_url+"clasificacionesticket/listarClasificaciones",
        type: "post",
    },
    columns: [
        {data:"Clave"},
        {data:"Nombre"},
        {data:"Descripcion"},
        {data:"Status"},
        {data:"Id_Clasificacion_Ticket",render:function(data){
            return "<div class='btn-group'>\
                <button type='button' class='btn btn-sm btn-primary btn-edit-reg' title='Editar'><i class='fa fa-pencil'></i></button>\
                <input type='hidden' value='"+data+"' class='Id_Clasificacion_Ticket'/>\
                <button type='button' class='btn btn-sm btn-danger btn-delete-reg' title='Eliminar'><i class='fa fa-trash'></i></button>\
            </div>"
        },
        orderable:false},
    ]
});

// ABRE FORMULARIO NUEVO
$(document).on("click",".abre-formulario",function(){
    $("#show-listado").hide();
    $("#show-formulario").show();
    traerFormulario();
});

// LLAMA TRAER FORMULARIO (EDICIÓN)
$(document).on("click",".btn-edit-reg",function(){
    Id_Clasificacion_Ticket = $(this).next(".Id_Clasificacion_Ticket").val();
    $("#show-listado").hide();
    $("#show-formulario").show();
    traerFormulario(Id_Clasificacion_Ticket);
});

// CIERRA FORMULARIO NUEVO
$(document).on("click","#show-formulario .cierra-formulario",function(){
    $("#show-formulario").hide();
    $("#show-listado").show();
});

// REFRESCA TABLA
$(document).on("click",".refresh-table", function(){
    var table_refresh = $(this).attr("data-refresh");
    $("#"+table_refresh).DataTable().ajax.reload();
});
// muestra / oculta campos de alertas
$(document).on("change","select[name='cmbrol']",function(){
    tec = $("option:selected", this).attr("data-tec");
    (tec > 0) ? $(".tiempos").show() : $(".tiempos").hide();
});

// ENVIAR FORMULARIO
$(document).on("submit","#form-crud",function(e){
    e.preventDefault();
    form = $(this);
    if(form.valid()){
         $.ajax({
            url: form.attr("action"),
            type: "post",
            data: form.serialize(),
            dataType: "json",
            beforeSend:function(){
                $("#spinner").show();
            },
            success:function(data){
                console.log(data)
                $("#spinner").hide();
                if(data.head === "_er:"){
                    Lobibox.notify("error",{
                        position:"top center",
                        size:"mini",
                        msg:data.body
                    });
                }else if(data.head == "_ok:"){
                    $("#show-formulario").hide();
                    $("#show-listado").show();
                    Lobibox.notify("success",{
                        position:"top center",
                        size:"mini",
                        msg:data.body
                    });
                }
            }
        })
    }
});

// ELIMINAR USUARIO
$(document).on("click",".btn-delete-reg",function(){
    Id_Clasificacion_Ticket = $(this).prev(".Id_Clasificacion_Ticket").val();
    Lobibox.confirm({
        title: "Espera...",
        msg: "¿Estás seguro de eliminar este registro?",
        callback: function(lobibox, type){
            if(type =="yes"){                
                $.ajax({
                    url: base_url+"clasificacionesticket/eliminarClasificacion",
                    data: "Id_Clasificacion_Ticket="+Id_Clasificacion_Ticket,
                    type: "post",
                    dataType: "json",
                    beforeSend:function(){
                        $("#spinner").show();
                    },
                    success:function(data){
                        console.log(data)
                        lobibox.destroy();
                        $("#spinner").hide();
                        if(data.head === "_er:"){
                            Lobibox.notify("error",{
                                position:"top center",
                                size:"mini",
                                msg:data.body
                            });
                        }else if(data.head == "_ok:"){
                            Lobibox.notify("success",{
                                position:"top center",
                                size:"mini",
                                msg:data.body
                            });
                        }
                    }
                });
            }else{
                lobibox.destroy();
            }
        }
    }); 
});

// FUNCIÓN PARA MOSTRAR FORMULARIO NUEVO / EDICION
function traerFormulario(Id_Clasificacion_Ticket){
    $.ajax({
        url: base_url+"clasificacionesticket/muestraFormulario",
        data: {Id_Clasificacion_Ticket:Id_Clasificacion_Ticket,},
        type: "post",
        beforeSend:function(){
            $("#spinner").show();
        },
        success:function(html){
            $("#spinner").hide();
            $("#show-formulario .lienzo").html(html);

            //ASIGNA VALIDACIONES AL FORM
            $("#form-crud").validate({
                rules: rules_validation
            });
        }
    });
}