<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboards extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Dashboards_model");	
		#	Si no está loggeado o no tiene permisos para este módulo,
		#	regresa al login	
		$session = $this->session->userdata();
		if(!isset($session["Id_Usuario"])){
			redirect(base_url());
		}
	}

	/**
	 * CARGAS VISTAS DEL MÓDULO
	 */
	public function index(){
		$Filtro_Usuarios = $this->getArrayFiltrosTKt();

		$resources = array(
			"session" => $this->session->userdata(),
			"modulojs" => "dashboards.js",
			"countticketsa" => $this->Dashboards_model->COUNT_Tickets_Abiertos($Filtro_Usuarios),							
		);
        
		$this->load->view("templates/header",$resources);
		$this->load->view("templates/sidebar",$resources);
		$this->load->view("dashboards",$resources);
		$this->load->view("templates/footer",$resources);
	}

	/**
	 * TRAE LOS PINES DE LOS TICKETS QUE 
	 * ABIERTOS
	 */
	public function traerPinesAbiertos(){
		$Filtro_Usuarios = $this->getArrayFiltrosTKt();
		$data = $this->Dashboards_model->CNS_Tickets_Abiertos($Filtro_Usuarios);
		echo json_encode($data);
	}

	/**
	 * TRAE LOS PINES DE LOS TICKETS QUE 
	 * ESTÁN SIENDO ATENDIDOS
	 */
	public function traerPinesEnProceso(){
		$Filtro_Usuarios = $this->getArrayFiltrosTKt();
		$data = $this->Dashboards_model->CNS_Tickets_En_Proceso($Filtro_Usuarios);
		echo json_encode($data);
	}

	/**
	 * TRAE LOS PINES DE LOS TICKETS QUE 
	 * AÚN NO ESTÁN SIENDO ATENDIDOS
	 */
	public function traerPinesSinAtender(){
		$Filtro_Usuarios = $this->getArrayFiltrosTKt();
		$data = $this->Dashboards_model->CNS_Tickets_Sin_Atender($Filtro_Usuarios);
		echo json_encode($data);
	}


	/**
	 * TRAE LOS PINES DE LAS SUCURSALES ACTIVOS
	 */
	public function traerPinesSucursalesActivas(){
		$data = $this->Dashboards_model->CNS_Sucursales(1);
		echo json_encode($data);
	}

	/**
	 * TRAE LOS PINES DE LAS SUCURSALES INACTIVOS
	 */
	public function traerPinesSucursalesInactivas(){
		$data = $this->Dashboards_model->CNS_Sucursales(0);
		echo json_encode($data);
	}

	/**
	 * TRAE LOS PINES DE LOS USUARIOS ACTIVOS
	 */
	public function traerPinesUsuarios(){
		$data = $this->Dashboards_model->CNS_UbicacionUsuarios();
		echo json_encode($data);
	}

	/**
	 * REGRESA EL ARRAY CON LOS PARAMETROS PARA FILTRAR LOS TICKETS
	 * DE ACUERCO A LOS PERMISOS DE SESIÓN
	 * @return [ARRAYASSOC] [ARRAY CON LOS PARAMETROS]
	 */
	private function getArrayFiltrosTKt(){
		#	Permisos
		$permisos = $this->session->userdata()["permisos"];
		#	Parametros para filtrar tickets que el usuario registró
		if (in_array("TCKSM", $permisos)) {
		 	$Filtro_Usuarios = array(
				"Referencia" => "Registra",
				"ID"         => $this->session->userdata("Id_Usuario")
		 	);
	   #	Parametros para filtrar tickets de la empresa del usuario
		}elseif (in_array("TCKSA", $permisos)) {
			$Filtro_Usuarios = array(
				"Referencia" => "Empresa",
				"ID"         => $this->session->userdata("Id_Empresa")
		 	);
		#	Parametros para no filtrar 
		}elseif(in_array("TCKST", $permisos)) {
			$Filtro_Usuarios = array(
				"Referencia" => "NONE",
				"ID"		 => "NONE"
			);
		}

		return $Filtro_Usuarios;
	}
}

/* End of file Dashboards.php */
/* Location: ./application/controllers/Dashboards.php */