<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tickets extends MY_Controller {
	public function __construct()
	{
		parent::__construct();		
		#	Si no está loggeado o no tiene permisos para este módulo,
		#	regresa al login
		$session = $this->session->userdata();
		if(!isset($session["permisos"]) ||
		   !in_array("TCKS", $session["permisos"])){
			redirect(base_url());
		}

		#	Carga modelo
		$this->load->model("Tickets_model");
		#	Carga librerias
		$this->load->library("form_validation");
		#	Establece zona Horaria
		date_default_timezone_set("America/Mexico_City");
	}

	/**
	 * CARGAS VISTAS DEL MÓDULO TICKETS ABIERTOS
	 */
	public function index(){
		$resources = array(
			"session"        => $this->session->userdata(),
			"modulojs"      => "tickets.js",
		);

		$this->load->view("templates/header",$resources);
		$this->load->view("templates/sidebar",$resources);
		$this->load->view("tickets",$resources);
		$this->load->view("templates/footer",$resources);
	}

	/**
	 * CARGAS VISTAS DEL MÓDULO TICKETS CERRADOS
	 */
	public function cerrados(){
		$lastticket = $this->Tickets_model->CNS_LastTicket("ASC");
		$resources = array(
			"session"       => $this->session->userdata(),
			"primer_fecha"  => $lastticket ? substr($lastticket->Fecha_Alta, 0, 10) : date("Y-m-01"),
			"modulojs"      => "tickets_cerrados.js",
		);

		$this->load->view("templates/header",$resources);
		$this->load->view("templates/sidebar",$resources);
		$this->load->view("tickets_cerrados",$resources);
		$this->load->view("templates/footer",$resources);
	}

	/**
	  * LISTADO DE TICKETS
	  */
	public function listarTicketsAbiertos()
	{
		#	filtros par ala consulta
		$Filtro_Usuarios = $this->getArrayFiltrosTKt();

		$draw = intval($this->input->post("draw"));
		// Registros a saltar
        $skip = $this->input->post("start");
        // Numero de registros a tomar
        $take = $this->input->post("length");
        // Columnas
        $columns = $this->input->post("columns");
        // Datos del Sort
        $order_data = $this->input->post("order")[0];
        // Nombre de la Columna a Ordenar
        $order_field = $columns[$order_data["column"]]["data"];
        // Dirección del Orden
        $order = $order_data["dir"];
        // Valor de búsqueda
        $busqueda = $this->input->post("search")["value"];
        // Total de registros
        $total =  $this->Tickets_model->COUNT_Tickets_Abiertos($Filtro_Usuarios);

        if($busqueda){
            $tickets = $this->Tickets_model->CNS_TicketsAbiertosMatch($skip, $take, $order_field, $order, $busqueda, $Filtro_Usuarios);
            $filtered_rows = sizeof($tickets);
        }else{
            $tickets = $this->Tickets_model->CNS_TicketsAbiertos($skip, $take, $order_field, $order, $Filtro_Usuarios);
            $filtered_rows = $total;
        }

        $data = array(
            "draw" => $draw,
            "recordsTotal" =>  $total,
            "recordsFiltered" =>  $filtered_rows,
            "data" => $tickets
        );

        echo json_encode($data);
	}

	/**
	  * LISTADO DE TICKETS CERRADOS
	  */
	public function listarTicketsCerrados()
	{
		#	filtros par ala consulta
		$Filtro_Usuarios = $this->getArrayFiltrosTKt();

		$draw = intval($this->input->post("draw"));
		// Registros a saltar
        $skip = $this->input->post("start");
        // Numero de registros a tomar
        $take = $this->input->post("length");
        // Columnas
        $columns = $this->input->post("columns");
        // Datos del Sort
        $order_data = $this->input->post("order")[0];
        // Nombre de la Columna a Ordenar
        $order_field = $columns[$order_data["column"]]["data"];
        // Dirección del Orden
        $order = $order_data["dir"];
        // Valor de búsqueda
        $busqueda = $this->input->post("search")["value"];
        // Total de registros
        $total =  $this->Tickets_model->COUNT_Tickets_Cerrados($Filtro_Usuarios);

        if($busqueda){
            $tickets = $this->Tickets_model->CNS_TicketsCerradosMatch($skip, $take, $order_field, $order, $busqueda, $Filtro_Usuarios);
            $filtered_rows = sizeof($tickets);
        }else{
            $tickets = $this->Tickets_model->CNS_TicketsCerrados($skip, $take, $order_field, $order, $Filtro_Usuarios);
            $filtered_rows = $total;
        }

        $data = array(
            "draw" => $draw,
            "recordsTotal" =>  $total,
            "recordsFiltered" =>  $filtered_rows,
            "data" => $tickets
        );

         // echo "<pre>";
        // print_r($this->session->userdata());
        // echo "</pre>";
        // $this->output->enable_profiler(TRUE);

        echo json_encode($data);
	}

	/**
 	  *	 MUESTRA FORMULARIO NUEVO / EDICIÓN
	  */
	public function muestraFormulario(){
		#	Id ticket
		$Id_Ticket  = $this->input->post("Id_Ticket");

		#	Variables de sesion
		$Id_Empresa = $this->session->userdata("Id_Empresa");
		$Id_Usuario = $this->session->userdata("Id_Usuario");
		$permisos   = $this->session->userdata("permisos");

		#	Si tiene permisos para reasignar, se consultan los usuarios para
		#	recibir tickets de nivel 2(reasignados)
		#	Si no los tiene, consulta los usuarios para recibir tickets
		#	de nivel 1(directos por la empresa)
		$Clave 		= in_array("TCKSRAS", $permisos) ? "TCKSRCB2": "TCKSRCB1";
		$Id_Empresa = in_array("TCKSRAS", $permisos) ? $Id_Empresa : null;

		$data = array(
			"usuarios"        => $this->Tickets_model->CNS_Usuarios_Servicios($Clave,$Id_Empresa),
			"direcciones"     => $this->Tickets_model->CNS_Sucursales(),
			"clasificaciones" => $this->Tickets_model->CNS_Clasificaciones(),
			"permisos"		  => $permisos
		);

		#	Si se recibe el Id_Ticket es un UPDATE
		if(is_numeric($Id_Ticket)){
			$data["ticket"]      = $this->Tickets_model->CNS_TicketByID($Id_Ticket);
			$data["diagnostico"] = $this->Tickets_model->CNS_TicketDiagnostico($Id_Ticket);
			$data["finaliza"]    = $this->Tickets_model->CNS_TicketFinaliza($Id_Ticket);
		}else{
			$lastnumero = $this->Tickets_model->CNS_LastTicket("DESC",$Id_Usuario);
			$consecutivo = $lastnumero ? substr($lastnumero->Num_Seguimiento,6): 0;
			$consecutivo = $consecutivo + 1;
			$clave_user  = $this->session->userdata("Clave");
			$data["nuevo_numero"] = "PM".$clave_user."-" . str_pad($consecutivo, 5, "0", STR_PAD_LEFT);
		}

		#	Si tiene permisos de ticket nuevo o editar => carga la vista
		if(in_array("TCKSEDT", $permisos) || in_array("TCKSNVO", $permisos)){
			#	Carga vista 
			$this->load->view("templates/formularios/form_ticket",$data);
		}

		#	Si se recibe id ticket
		if(is_numeric($Id_Ticket)){
			#	si no tiene permisos de editar muestra detalle
			if(!in_array("TCKSEDT", $permisos)){
				$this->load->view("templates/ticket_detalle",$data);
			}

			#	si tiene permisos de editar el costo
			#	muestra formulario cuadrilla
			if(in_array("TCKSCT", $permisos) && $data["ticket"]["Orden"] == 5){
				$this->load->view("templates/formularios/form_cuadrilla",$data);
			}
		}

	}

	/**
	 * MUESTRA JSON DE UNA DIRECCION
	 */
	public function muestraDireccion(){
		#	Id_Direccion para consultar
		$Id_Direccion = $this->input->post("Id_Direccion");

		#	consulta
		$direccion = $this->Tickets_model->CNS_DireccionByID($Id_Direccion);
		echo json_encode($direccion);
	}

	/**
	 * INSERTA / ACUTALIZA TICKET
	 * SI RECIBE Id_Ticket => Actualiza
	 * DE LO CONTRARIO INSERTA
	 */
	public function guardaTicket(){		
		#	Permisos
		$permisos   = $this->session->userdata("permisos");

		#	Id_Ticket para saber si es UPDATE
		$Id_Ticket  = $this->input->post("Id_Ticket");

		#	Array de validaciones
		$rules = array(
			array("field" => "txtnoseguimiento", "label" => "Número de Seguimiento", "rules" => "required|max_length[20]|is_unique[Tickets.Num_Seguimiento.$Id_Ticket]|html_escape|trim"),
			array("field" => "cmbdireccion", "label" => "Dirección", "rules" => "required|integer|html_escape|trim"),
			array("field" => "txadescripcion", "label" => "Número de Seguimiento", "rules" => "required|max_length[200]|html_escape|trim"),
			array("field" => "txaobservaciones", "label" => "Número de Seguimiento", "rules" => "max_length[500]|html_escape|trim"),
			array("field" => "cmbasignado", "label" => "Usuario a asignado", "rules" => "required|integer|html_escape|trim"),
			array("field" => "cmbclasificacion", "label" => "Clasificación", "rules" => "required|integer|html_escape|trim"),
		);

		$Id_Usuario = $this->input->post("cmbasignado");
		$autoriza   = $this->input->post("rdoautoriza");

		#	Si tiene permiso para autorizar ticket, agrega la validación radio
		if(in_array("TCKSAUT", $permisos)){
			array_push($rules, array("field" => "rdoautoriza", "label" => "Autorización", "rules" => "required|integer|html_escape|trim"));
		}


		#	Si cumple las validaciones
		$this->form_validation->set_rules($rules);
		if ($this->form_validation->run() == FALSE) {
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}

		#	Array para la query
		$data = array(
				"Id_Usuario"              => $Id_Usuario,
				"Id_Clasificacion_Ticket" => $this->input->post("cmbclasificacion"),
				"Num_Seguimiento"         => $this->input->post("txtnoseguimiento"),
				"Id_Direccion"            => $this->input->post("cmbdireccion"),
				"Descripcion"             => $this->input->post("txadescripcion"),
				"Observaciones"           => $this->input->post("txaobservaciones"),
				"Fecha_Actualiza"         => date("Y-m-d H:i:s"),
			 );

		#	Si tiene permiso para autorizar ticket, agrega al array para la query
		if(in_array("TCKSAUT", $permisos)){
			$data["Id_Status_Ticket"] = $autoriza;
		}


		#	Si se cargó una imagen se procesa la subida
		if($_FILES["flefoto"]["size"] > 0){
			#	Si se recibió el Id_Ticket, se elimina la fotografía anterior
			if(is_numeric($Id_Ticket)){
				$this->borrarImagen($Id_Ticket);
			}

			#	Sube la imagen
			$res = $this->subirFoto(array(
				"upload_path" => "./ticketsfiles/",
				"name_control"	=> "flefoto",
				"max_w" => 500,
				"max_h" => 500,
			));

			if($res["head"] == "_err:"){
				echo json_encode($res);
				exit();
			}

			$data["Ruta_Imagen"] = $res["body"];
		}
		
		#	Si se recibe Id_Ticket es un insert
		#	de lo contrari es unp  update
		if(is_numeric($Id_Ticket)){
			#	Si el ticket ya se está atendiendo
			#	se quitan los campos que no se pueden editar
			$ticket = $this->Tickets_model->CNS_TicketByID($Id_Ticket);
			if($ticket["Orden"] > 2){
				unset($data["Id_Status_Ticket"]);
				unset($data["Num_Seguimiento"]);
				unset($data["Id_Usuario"]);
				unset($data["Id_Direccion"]);
			}


			$ar = $this->Tickets_model->UPD_Ticket($Id_Ticket,$data);
			if($ar > 0){
				#	Si es autorizado manda notificacion
				if($ticket["Orden"] == 2 && $ticket["Orden"] < 5){
					$datanoty = array(
						"titulo" => "Se ha modificado un ticket",
						"mensaje" => "Se ha modifcado el ticket " . $data["Num_Seguimiento"] .", revisalo en tu lista"
					);
					$oknoti = $this->sendNotificacion($Id_Usuario,$datanoty);
					if(!$oknoti){
						echo json_encode(array("head" => "_wr:","body" => "Ooops! Hubo un error al notifcar al usuario, itenta nuevamente"));
						exit();
					}
				}

				echo json_encode(array("head" => "_ok:","body" => "Excelete hemos actualizado el registro"));
				exit();
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
				exit();
			}


		}else{
			#	Se envía Fecha_Alta y Usuario_Registra si es insert
			$data["Fecha_Alta"]       = date("Y-m-d H:i:s");
			$data["Usuario_Registra"] = $this->session->userdata("Id_Usuario");

			#	Se inserta a la B.D.
			$last = $this->Tickets_model->INS_Ticket($data);
			if($last){
				#	Si es autorizado manda notificacion
				if($autoriza >= 2){
					$datanoty = array(
						"titulo" => "Nuevo Ticket",
						"mensaje" => "Se ha levantado un nuevo ticket revísalo en tu lista"
					);
					$oknoti = $this->sendNotificacion($Id_Usuario,$datanoty);
					if(!$oknoti){
						echo json_encode(array("head" => "_wr:","body" => "Ooops! Hubo un error al notifcar al usuario, itenta nuevamente"));
						exit();
					}
				}

				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha agregado exitosamente"));
				exit();

			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
				exit();
			}
		}
	}


	/**
	 * ACUTALIZA LOS DATOS PROPORCIONADOS POR LA CUADRILLA
	 * @return [type] [description]
	 */
	public function guardaTicketCuadrilla(){
		#	Establece zona Horaria
		date_default_timezone_set("America/Mexico_City");
		#	Id_Ticket
		$Id_Ticket = $this->input->post("Id_Ticket");

		#	Array de validaciones
		$rules = array(
			array("field" => "txadiagnostico", "label" => "Diagnóstico", "rules" => "required|max_length[800]|html_escape|trim"),
			array("field" => "txamaterial", "label" => "Material", "rules" => "max_length[1000]|html_escape|trim"),
			array("field" => "txaobservaciones", "label" => "Observaciones", "rules" => "max_length[500]|html_escape|trim"),
			array("field" => "nmbcosto", "label" => "Costo", "rules" => "numeric|html_escape|trim"),
		);

		$this->load->library("form_validation");
		$this->form_validation->set_rules($rules);

		#	Si cumple las validaciones
		if ($this->form_validation->run() == FALSE) {
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}

		$dataarray_t = array(
			"Id_Status_Ticket" => 6,
			"Fecha_Actualiza"  => date("Y-m-d H:i:s"),
		);

		$dataarray_d = array(
			"Diagnostico"     => $this->input->post("txadiagnostico"),
			"Material"        => $this->input->post("txamaterial"),
			"Fecha_Actualiza" => date("Y-m-d H:i:s"),
		);

		$dataarray_f = array(
			"Observaciones"   => $this->input->post("txaobservaciones"),
			"Costo"			  => $this->input->post("nmbcosto"),
			"Fecha_Actualiza" => date("Y-m-d H:i:s"),
		);

		$ar_d = $this->Tickets_model->UPD_Ticket_Diagnostico($Id_Ticket,$dataarray_d);
		$ar_f = $this->Tickets_model->UPD_Ticket_Finaliza($Id_Ticket,$dataarray_f);

		$cierra = $this->input->post("rdocierra");
		if($cierra == 1){
			$this->Tickets_model->UPD_Ticket($Id_Ticket,$dataarray_t);
			// manda pdfs
			$this->mandaPDFS($Id_Ticket);
		}

		if($ar_d > 0 && $ar_f){
			echo json_encode(array("head" => "_ok:","body" => "Excelete hemos actualizado el registro"));
		}else{
			echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
		}

	}

	public function pdf($Num_Seguimiento){
		$session = $this->session->userdata();
		if(isset($session["Id_Usuario"])){
			$ticket = $this->Tickets_model->CNS_TicketByNum($Num_Seguimiento);
			$data = array(
				"ticket"             => $ticket,
				"ticket_diagnostico" => $this->Tickets_model->CNS_TicketDiagnostico($ticket["Id_Ticket"]),
				"ticket_imagenesi"   => $this->Tickets_model->CNS_TicketImagenes($ticket["Id_Ticket"],1),
				"ticket_imagenesf"   => $this->Tickets_model->CNS_TicketImagenes($ticket["Id_Ticket"],2),
				"ticket_finaliza"	 => $this->Tickets_model->CNS_TicketFinaliza($ticket["Id_Ticket"]),
				"reporte"  		 	 => $this->Tickets_model->CNS_TicketImagenes($ticket["Id_Ticket"],3),
			);

			$head = $this->load->view("templates/docs/pdf_header_ticket", null, true);
			$html1 = $this->load->view("templates/docs/pdf_ticket_1", $data, TRUE);
			$html2 = $this->load->view("templates/docs/pdf_ticket_2", $data, TRUE);

			$this->load->library("Pdf");
			$pdf = $this->pdf->load("","Letter",12,"helvetica",15,15,35,10,9,9,"P");
			$pdf->SetHTMLHeader($head);
			$pdf->WriteHtml($html1);
			$pdf->AddPage();
			$pdf->WriteHtml($html2);

			// echo "<pre>";
			// print_r($data);
			// echo "</pre>";
			$pdf->Output();
		}
	}

	/**
	 * ELIMINA TICKET Y LOS REGISTROS RELACIONADAS EN LAS OTRAS TABLAS
	 * Evidencia_Fotos
	 * Tiempos_Ticket
	 * Ticket_Diagnostico
	 * Ticket_Coordenadas
	 * Ticket_Finaliza
	 * Tickets
	 */
	public function eliminarTicket(){
		#	Id_Ticket para eliminar
		$Id_Ticket = $this->input->post("Id_Ticket");

		#	Consulta las imagenes de evidencia
		#	para eliminar los archivos
		$evidencia = $this->Tickets_model->CNS_TicketImagenes($Id_Ticket);
		foreach ($evidencia as $ekey => $eval) {
			$rutaborrar = "./ticketsfiles/".$eval["Ruta_Imagen"];
			if(is_file($rutaborrar) && file_exists($rutaborrar)){
				unlink($rutaborrar);
			}
		}

		#	Elimina evidencia fotos
		$are = $this->Tickets_model->DEL_EvidenciaFotos($Id_Ticket);

		#	Elimina tiempos
		$art = $this->Tickets_model->DEL_TiemposTicket($Id_Ticket);

		#	Elimina evidencia fotos
		$ard = $this->Tickets_model->DEL_DiagnosticoTicket($Id_Ticket);

		#	Elimina coordenadas
		$arc = $this->Tickets_model->DEL_CoordenadasTicket($Id_Ticket);

		#	Elimina evidencia fotos
		$arf = $this->Tickets_model->DEL_FinalizaTicket($Id_Ticket);

		#	Elimina ticket
		$ar = $this->Tickets_model->DEL_Ticket($Id_Ticket);

		if($ar){
			echo json_encode(array("head" => "_ok:","body" => "Excelete hemos eliminado tu registro"));
		}else{
			echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al eliminar tu registro, intentalo nuevamente"));
		}
	}

	/**
	 * EXPORTA TICKETS A ARCHIVO DE EXCEL
	 * CON LO PARAMETROS RECIBIDOS DEL FORMULARIO
	 * */
	public function validaExcel(){
		#	Array de validaciones
		$rules = array(
			array("field" => "txtfechai", "label" => "Fecha inicial", "rules" => "required|valid_date|html_escape|trim"),
			array("field" => "txtfechaf", "label" => "Fecha final", "rules" => "required|valid_date|is_date_greather_than[txtfechai]|html_escape|trim"),
			array("field" => "chkfiltros[]", "label" => "Filtros", "rules" => "required|html_escape|trim"),
		);

		#	Carga las librerias
		$this->load->library("form_validation");
		$this->form_validation->set_rules($rules);

		#	Si cumple las validaciones
		if ($this->form_validation->run() == FALSE) {
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}

		$Fecha_Inicio = $this->input->post("txtfechai");
		$Fecha_Fin    = $this->input->post("txtfechaf");
		$Filtros 	  = $this->input->post("chkfiltros");
		$Strfiltros	  = implode("-", $Filtros);
		// $Fecha_Inicio = "2017-11-10";
		// $Fecha_Fin	  = "2018-01-10";
		// $Filtros = array("a","c");

		$result = array(
			"head"	=> "_ok:",
			"body"	=> base_url("tickets/reporte/"	.	$Fecha_Inicio	.	"/"	.	$Fecha_Fin	.	"/"	.	$Strfiltros)
		);

		echo json_encode($result);

	}

	public function reporte($Fecha_Inicio,$Fecha_Fin,$Strfiltros){
		$Filtros = explode("-", $Strfiltros);
		$Filtro_Usuarios = $this->getArrayFiltrosTKt();
		# Consulta tickets con los filtros recibidos
		$tickets = $this->Tickets_model->CNS_TicketsFiltros($Fecha_Inicio . " 00:00:00",$Fecha_Fin . " 23:59:59", $Filtros,$Filtro_Usuarios);

		#	Carga libreria de excel
		$this->load->library("PHPExcel");
		$excel = new PHPExcel();

		#	Se configuran las propiedades del archivo
		$excel->getProperties()->setCreator("Mako");
		$excel->getProperties()->setLastModifiedBy("Mako");
		$excel->getProperties()->setTitle("Tickets Mako");
		$excel->getProperties()->setSubject("Tickets Mako");
		$excel->getProperties()->setDescription("Tickets Mako");
		$hoja = $excel->getActiveSheet();

		#	Array con el formato del encabezado
		$hoja->getStyle("A1:L1")->applyFromArray(array(
				  	"fill" => array(
				  	"type" => PHPExcel_Style_Fill::FILL_SOLID,
				  	"color" => array("rgb" => "F48574")
				),
					"font" => array(
					"bold" => true,
					"color" => array("rgb" => "FFFFFF"),
					"size"	=> 13
				)
		    ));

		#	Escribe encabezados
		$hoja->SetCellValue("A1", "Fecha Alta");
		$hoja->SetCellValue("B1", "No. Seguimiento");
		$hoja->SetCellValue("C1", "Sucursal");
		$hoja->SetCellValue("D1", "Direccion");
		$hoja->SetCellValue("E1", "Clasificación");
		$hoja->SetCellValue("F1", "Descripción");
		$hoja->SetCellValue("G1", "Proveedor");
		$hoja->SetCellValue("H1", "Alerta");
		$hoja->SetCellValue("I1", "Tiempo");
		$hoja->SetCellValue("J1", "Recibió");
		$hoja->SetCellValue("K1", "Costo");
		$hoja->SetCellValue("L1", "Estatus");


		#	Se recorren los registros para escribirlos en el excel
		foreach ($tickets as $index => $val) {
			$row       = $index + 2;
			$color     = str_replace("#", "", $val["Alerta"]);

			$hoja->SetCellValue("A".$row, $val["Fecha_Alta"]);
			$hoja->SetCellValue("B".$row, $val["Num_Seguimiento"]);
			$hoja->SetCellValue("C".$row, $val["Sucursal"]);
			$hoja->SetCellValue("D".$row, $val["Direccion"]);
			$hoja->SetCellValue("E".$row, $val["Clasificacion"]);
			$hoja->SetCellValue("F".$row, $val["Descripcion"]);
			$hoja->SetCellValue("G".$row, $val["Razon_Social"] . " / " . $val["Usuario"]);
			$hoja->getStyle("H".$row)->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID);
			$hoja->getStyle("H".$row)->getFill()->getStartColor()->setRGB($color);
			$hoja->SetCellValue("I".$row, $val["Intervalo"]);
			$hoja->SetCellValue("J".$row, $val["Nombre_Supervisor"]);
			$hoja->SetCellValue("K".$row, $val["Costo"]);
			$hoja->SetCellValue("L".$row, $val["Status"]);
		}

		header('Content-type: application/vnd.ms-excel');
		header('Content-Disposition: attachment; filename="tickets.xlsx"');
        header('Cache-Control: max-age=0');


		$objWriter = new PHPExcel_Writer_Excel2007($excel);
		$objWriter->save("php://output");
	}

	/**
	 * REGRESA EL ARRAY CON LOS PARAMETROS PARA FILTRAR LOS TICKETS
	 * DE ACUERCO A LOS PERMISOS DE SESIÓN
	 * @return [ARRAYASSOC] [ARRAY CON LOS PARAMETROS]
	 */
	private function getArrayFiltrosTKt(){
		#	Permisos
		$permisos = $this->session->userdata()["permisos"];
		#	Parametros para filtrar tickets que el usuario registró
		if (in_array("TCKSM", $permisos)) {
		 	$Filtro_Usuarios = array(
				"Referencia" => "Registra",
				"ID"         => $this->session->userdata("Id_Usuario")
		 	);
	   #	Parametros para filtrar tickets de la empresa del usuario
		}elseif (in_array("TCKSA", $permisos)) {
			$Filtro_Usuarios = array(
				"Referencia" => "Empresa",
				"ID"         => $this->session->userdata("Id_Empresa")
		 	);
		#	Parametros para no filtrar
		}elseif(in_array("TCKST", $permisos)) {
			$Filtro_Usuarios = array(
				"Referencia" => "NONE",
				"ID"		 => "NONE"
			);
		}

		#	Si hay permiso para consultar tickets en todos
		#	los estados: TCKSTE => Se filtran con el Orden mayor a 0
		#	Si hay permiso para consultar solo los tickets autorizados
		#	TCKSAU => Consulta los tickets con el orden mayor a 2
		if(in_array("TCKSTE", $permisos)){
			$Filtro_Usuarios["MIN"] = 1;
		}elseif(in_array("TCKSAU", $permisos)) {
			$Filtro_Usuarios["MIN"] = 2;
		}

		#	Si hay permiso para Eliminar un ticket
		#	se envía 1, de lo contrario 0
		$Filtro_Usuarios["DEL"] = in_array("TCKTDEL", $permisos) ? 1 : 0;

		return $Filtro_Usuarios;
	}

	public function showfiltros(){
		echo "<pre>";
		print_r($this->getArrayFiltrosTKt());
		echo "</pre>";
	}
	/**
	 * MANDA UN CORREO A LOS USUARIOS CORRESPONDIENTES
	 * CON EL PDF ADJUNTO DEL TICKET
	 * @param  [INT] $Id_Ticket [ID DEL TICKET]
	 * @return [BOOLEAN]        [RESULTADO DEL ENVÍO]
	 */
	private function mandaPDFS($Id_Ticket){		
		#	Configuración email
		$mailsitio = $this->getConfiguration("MAIL");

		$data["ticket"]	= $this->Tickets_model->CNS_TicketByID($Id_Ticket);

		#	Envía correo a usuario
		$mensaje = $this->load->view("templates/correos/ticket-cerrado",$data,true);
		$arraycorreo = array(
			"remitente_mail" => $mailsitio["SMTPUSER"],
			"remitente_name" => $mailsitio["NAMEREMT"],
			"destinatario"   => $this->getCorreosTicket($Id_Ticket),
			"asunto"         => "Ticket cerrado",
			"mensaje"        => $mensaje,
		);

		// echo $mensaje;
		#	Genera pdf y lo guarda temporalmente
		$pdfattach = $this->genPdf($data["ticket"]["Num_Seguimiento"]);
		if(is_file($pdfattach)){
			$arraycorreo["attach"] = $pdfattach;
		}
		#	Envía correo
		$resmail = $this->enviaCorreo($arraycorreo);
		#	Borrar pdf
		if(is_file($pdfattach)){
			unlink($pdfattach);
		}

		return $resmail;
	}

	/**
	 * GENERA PDF Y LO GUARDA EN temppdfs
	 * @param  [type] $Num_Seguimiento [NUMERO DE SEGUIMIENTO DEL TICKET]
	 * @return [type]                  [RUTA DONDE SE GUARDÓ]
	 */
	private function genPdf($Num_Seguimiento){
		$ticket = $this->Tickets_model->CNS_TicketByNum($Num_Seguimiento);
		$data = array(
			"ticket"             => $ticket,
			"ticket_diagnostico" => $this->Tickets_model->CNS_TicketDiagnostico($ticket["Id_Ticket"]),
			"ticket_imagenesi"   => $this->Tickets_model->CNS_TicketImagenes($ticket["Id_Ticket"],1),
			"ticket_imagenesf"   => $this->Tickets_model->CNS_TicketImagenes($ticket["Id_Ticket"],2),
			"ticket_finaliza"	 => $this->Tickets_model->CNS_TicketFinaliza($ticket["Id_Ticket"]),
			"reporte"  		 	 => $this->Tickets_model->CNS_TicketImagenes($ticket["Id_Ticket"],3),
		);

		$head = $this->load->view("templates/docs/pdf_header_ticket", null, true);
		$html1 = $this->load->view("templates/docs/pdf_ticket_1", $data, TRUE);
		$html2 = $this->load->view("templates/docs/pdf_ticket_2", $data, TRUE);

		$this->load->library("Pdf");
		$pdf = $this->pdf->load("","Letter",12,"helvetica",15,15,35,10,9,9,"P");
		$pdf->SetHTMLHeader($head);
		$pdf->WriteHtml($html1);
		$pdf->AddPage();
		$pdf->WriteHtml($html2);

		$output = "./temppdfs/".$Num_Seguimiento.".pdf";
		$pdf->Output($output);
		return $output;
	}

	/**
	  *	Borra imagen de un ticket
	  */
	private function borrarImagen($Id_Ticket){
		$ticket = $this->Tickets_model->CNS_TicketByID($Id_Ticket);
		if($ticket["Ruta_Imagen"] == ""){
			return true;
			exit();
		}


		$ruta       = "./ticketsfiles/".$ticket["Ruta_Imagen"];

		$res = true;
		#	Elimina imagen
		if(file_exists($ruta)){
			if(!unlink($ruta)){
				$res = false;
			}
		}

		return $res;
	}

	/**
	 * TRAE UN ARRAY INDEXADO DE LOS CORREOS A LOS QUE
	 * SE LES DEBE ENVIAR CC DE UN TICKET
	 * @param  [INT] $Id_Ticket [IDENTIFICADOR DEL TICKET]
	 * @return [ARRAYINDEX]     [ARRAY CON LOS CORREOS]
	 */
	private function getCorreosTicket($Id_Ticket){
		$data_array = array($Id_Ticket);
		$correos = $this->Tickets_model->CALL_SPCNS_Usuarios_CC($data_array);

		$arraycorreos = array();
		foreach ($correos as $key => $value) {
			array_push($arraycorreos, $value["Usuario"]);
		}

		return $arraycorreos;
	}

	public function pruebaimgen(){
		 echo "<form action='".base_url("tickets/subemeEsta")."' method='post'  enctype='multipart/form-data'>
          <input type='file' name='fleupload' />
          <button>Enviar</button>
        </form>";

   //     phpinfo();
	}

	public function subemeEsta(){
		// echo "<pre>";
		// print_r($_FILES);
		// echo "</pre>";
		$res = $this->subirFoto(array(
			"upload_path" => "./uploads/",
			"name_control"	=> "fleupload",
			"max_w" => 500,
			"max_h" => 500,
		));

		if($res["head"] == "_err:"){
			echo json_encode($res);
		}else{
			echo json_encode(array("head" => "_ok:", "body" => "Ticket guardado"));
		}
		// echo "<pre>";
		// print_r($res);
		// echo "</pre>";
	}
}
