<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class MY_Controller extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Master_model");
	}

	public function enviaCorreo($datamail){
		#	Carga libreria email
		$this->load->library("Email");

		#	configuración SMTP de la libreria email
		$smtp = $this->getConfiguration("MAIL");
		$config = array(
				"protocol"  => "smtp",
				"smtp_host" => $smtp["SMTPHOST"],
				"smtp_user" => $smtp["SMTPUSER"],
				"smtp_pass" => $smtp["SMTPPSSW"],
				"smtp_port" => $smtp["SMTPPORT"],
				"mailtype"  => "html",
				"charset"   => "utf-8",
				"validate"  => true,
			);
    	$this->email->initialize($config);

    	#	Configuración de envío
    	$this->email->from($smtp["SMTPUSER"], $smtp["NAMEREMT"]);
		$this->email->reply_to($datamail["remitente_mail"], $datamail["remitente_name"]);
		$this->email->to($datamail["destinatario"]);
		$this->email->subject($datamail["asunto"]);
		$this->email->message($datamail["mensaje"]);
	
		if(isset($datamail["attach"])){
			$this->email->attach($datamail["attach"]);
		}

		return $this->email->send();
	}

	public function subirFoto($datacnf){
		$config = $this->getConfiguration("UPLOAD");
		#	Carga libreria UPLOAD
		$this->load->library("upload", array(
				"upload_path"   => $datacnf["upload_path"],
				"allowed_types" => $config["ALLOWTYP"],
				"max_size"      => (int) $config["MAXSIZE"],
				"max_filename"  => (int) $config["MAXFNAME"],
				"encrypt_name"  => true
			));
	
		#	Carga imagen
		if(!$this->upload->do_upload($datacnf["name_control"])){
			return array("head" => "_err:","body" => $this->image_uploadlib->display_errors(" ","\n"));
			exit();
		}

		$dataupload = $this->upload->data();		

		#	Carga libreria para la redimensión
		$this->load->library("image_lib", array(
				"image_library"	=> "gd2",
				"source_image"	=> $datacnf["upload_path"].$dataupload["file_name"],
				"width"			=> $datacnf["max_w"],
				"height"		=> $datacnf["max_h"]
			));

		#	Redimensiona
		if(!$this->image_lib->resize()){
			return array("head" => "_err:","body" => $this->image_lib->display_errors(" ","\n"));
			exit();
		}
		
		return array("head" => "_ok:", "body" => $dataupload["file_name"]);
	}

	/**
	 * TRAE LAS VARIABLES SMTP Y LAS ACOMODA EN UN ARRAY ASOCIATIVO
	 */
	public function getConfiguration($Grupo){
		$config = $this->Master_model->CNS_Configuracion($Grupo);
		$arrayconfig = array();
		foreach ($config as $key => $value) {
			$arrayconfig[$value["Abreviatura"]] = $value["Valor"];
		}

		return $arrayconfig;
	}

	/**
	 * TRAE DATA DE USUARIOS CON CIERTOS PERMISOS
	 * @param  [STRING] 			$data    DATOS A TRAER
	 * @param  [STRING] 			$seccion SECCIÓN A LA QUE TIENEN PERMISO
	 * @return [ARRAYASOC]          ARRAY DE DATOS DEL USUARIO
	 */
	public function getUsuariosConPermisos($data,$seccion){
		$res = $this->Master_model->CNS_UsuariosConPermiso($data,$seccion);
		$datau = array();
		foreach ($res as $key => $value) {
			$datau[] = $value["DATO"];
		}

		return array_unique($datau);
	}

	/**
	 * ENIVAR NOTIFICACIÓN AL USUARIO
	 * @param  INT $Id_Usuario IDENTIFICADOR DEL USUARIO 
	 *                         AL QUE SE LE ENVIARÁ LA NOTIFICACIÓN
	 * @param  ARRAY $dataarray  ARRAY ASOCIATIVO CON LAS VARIABLES 
	 *                           PARA ARMAR LA NOTIFICACIÓN
	 */
	public function sendNotificacion($Id_Usuario, $dataarray){
		#	Variables de la notificación
		$titulo = $dataarray["titulo"];
		$mensaje = $dataarray["mensaje"];

		#	Varibles de solicitud para la curl
		$path_to_fcm = "https://fcm.googleapis.com/fcm/send";
		$server_key = "AAAA6UX6Wqw:APA91bEO8bAPe1hTbT861vyYDSfoGASCtOUwH6x2uSsdxSyCR7EZ3L9lxjUSRxfTbQKxTJ_eW5vdp5z7kWrQgJuZc7nrVRScu_H5ltNNQDTHS6fnZuI-TdJ5e0_PpP3eCgamfg1ceEaw";

		#	Se obtiene el token del usuario al que se le enviará la notificación
		$usuario = $this->Master_model->CNS_UsuarioByID($Id_Usuario);
		$TokenUsuario = $usuario["TokenFCM"];

		if(!$TokenUsuario){
			return false;
			exit();
		}

		#	Encabezados del request
		$headers = array(
			"Authorization:key=" . $server_key,
			"Content-Type:application/json",
		);

		#	Cuerpo del request
		$fields = array(
			"to" => $TokenUsuario,
			"notification" => array(
				"title" => $titulo,
				"body" => $mensaje,
				"sound" => "default"
			),
			"data" => array(
				"message" => "message body",
		    	"click_action" => "PUSH_INTENT"
			),
			"priority" => "normal"
		);


		$payload = json_encode($fields);

		#	Se hace la solicitud CURL
		$ch = curl_init($path_to_fcm);
		curl_setopt($ch, CURLOPT_POST, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
		$result = curl_exec($ch);
		curl_close($ch);

		#	Se codifica el JSON para obtener ol número de exitos
		$jsond = json_decode($result);
		if($jsond->success > 0){
			return true;
		}	
	}
}