<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tickets_model extends CI_Model {
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	/**
	  * CUENTA EL TOTAL DE TICKETS ABIERTOS
	  */
	function COUNT_Tickets_Abiertos($Filtro_Usuarios = array()){
		$this->db->select("t.Id_Ticket");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->where("s.Orden <",6);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		return $this->db->count_all_results();
	}

	/**
	  * CUENTA EL TOTAL DE TICKETS CERRADOS
	  */
	function COUNT_Tickets_Cerrados($Filtro_Usuarios = array()){
		$this->db->select("t.Id_Ticket");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->where("s.Orden",6);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}
		
		return $this->db->count_all_results();
	}

	/**
	 * CONSULTA TICKETS ABIERTOS CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_TicketsAbiertos($Skip, $Take, $Order_Field, $Order, $Filtro_Usuarios){
		$this->db->select("t.Id_Ticket, t.Id_Usuario, t.Num_Seguimiento, t.Fecha_Alta, s.Orden, s.Nombre as Status, d.Sucursal,
						   IF(u.Nombre IS NULL, 'Indefinido', CONCAT(e.Razon_Social, ' - ', u.Nombre)) as Usuario,
						   CASE 
								WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) < tm.Tiempo_1 THEN '#5cb85c'
						        WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) > tm.Tiempo_2 THEN '#d9534f'
								ELSE '#f0ad4e'
						   END AS Alerta,
						   CONCAT(TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()), ' días ',
					       	    MOD(TIMESTAMPDIFF(HOUR, t.Fecha_Alta, NOW()),24), ' horas') AS Intervalo,".
					       $Filtro_Usuarios["DEL"] ." AS DEL"
					    );
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Tiempos_Usuario as tm", "u.Id_Usuario = tm.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->join("Ticket_Finaliza as f", "t.Id_Ticket = f.Id_Ticket", "left");
		$this->db->where("s.Orden <",6);
		$this->db->where("s.Orden >=", $Filtro_Usuarios["MIN"]);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		$this->db->group_by("t.Id_Ticket");
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA TICKETS ABIERTOS CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_TicketsAbiertosMatch($Skip, $Take, $Order_Field, $Order, $Match, $Filtro_Usuarios){
		$this->db->select("t.Id_Usuario, t.Num_Seguimiento, t.Fecha_Alta, s.Orden, s.Nombre as Status, d.Sucursal,
						   IF(u.Nombre IS NULL, 'Indefinido', CONCAT(e.Razon_Social, ' - ', u.Nombre)) as Usuario,
						   CASE 
								WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) < tm.Tiempo_1 THEN '#5cb85c'
						        WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) > tm.Tiempo_2 THEN '#d9534f'
								ELSE '#f0ad4e'
						    END AS Alerta,
						    CONCAT(TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()), ' días ',
					       	    MOD(TIMESTAMPDIFF(HOUR, t.Fecha_Alta, NOW()),24), ' horas') AS Intervalo,".
					       $Filtro_Usuarios["DEL"] ." AS DEL");
		$this->db->from("Tickets as t");
		$this->db->like("CONCAT(t.Fecha_Alta, ' ', u.Nombre, ' ', t.Num_Seguimiento, ' ', e.Razon_Social, ' ', d.Sucursal,'', s.Nombre)", $Match);
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Tiempos_Usuario as tm", "u.Id_Usuario = tm.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->join("Ticket_Finaliza as f", "t.Id_Ticket = f.Id_Ticket", "left");
		$this->db->where("s.Orden <",6);
		$this->db->where("s.Orden >=", $Filtro_Usuarios["MIN"]);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}
		
		$this->db->group_by("t.Id_Ticket");
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA TICKETS CERRADOS CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_TicketsCerrados($Skip, $Take, $Order_Field, $Order, $Filtro_Usuarios){
		$this->db->select("t.Id_Ticket, t.Id_Usuario, t.Num_Seguimiento, t.Fecha_Alta, s.Nombre as Status, d.Sucursal,
						   IF(u.Nombre IS NULL, 'Indefinido', CONCAT(e.Razon_Social, ' - ', u.Nombre)) as Usuario,
						   CASE 
								WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) < tm.Tiempo_1 THEN '#5cb85c'
						        WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) > tm.Tiempo_2 THEN '#d9534f'
								ELSE '#f0ad4e'
						   END AS Alerta,
						   CONCAT(TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()), ' días ',
					       	    MOD(TIMESTAMPDIFF(HOUR, t.Fecha_Alta, NOW()),24), ' horas') AS Intervalo,".
					       $Filtro_Usuarios["DEL"] ." AS DEL");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Tiempos_Usuario as tm", "u.Id_Usuario = tm.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->join("Ticket_Finaliza as f", "t.Id_Ticket = f.Id_Ticket", "left");
		$this->db->where("s.Orden",6);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		$this->db->group_by("t.Id_Ticket");
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA TICKETS CERRADOS CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_TicketsCerradosMatch($Skip, $Take, $Order_Field, $Order, $Match, $Filtro_Usuarios){
		$this->db->select("t.Id_Ticket, t.Id_Usuario, t.Num_Seguimiento, t.Fecha_Alta, s.Nombre as Status, d.Sucursal,
						   IF(u.Nombre IS NULL, 'Indefinido', CONCAT(e.Razon_Social, ' - ', u.Nombre)) as Usuario,
						   CASE 
								WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) < tm.Tiempo_1 THEN '#5cb85c'
						        WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) > tm.Tiempo_2 THEN '#d9534f'
								ELSE '#f0ad4e'
						   END AS Alerta,
						   CONCAT(TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()), ' días ',
					       	    MOD(TIMESTAMPDIFF(HOUR, t.Fecha_Alta, NOW()),24), ' horas') AS Intervalo,".
					       $Filtro_Usuarios["DEL"] ." AS DEL");
		$this->db->from("Tickets as t");
		$this->db->like("CONCAT(t.Fecha_Alta, ' ', u.Nombre, ' ', t.Num_Seguimiento, ' ', e.Razon_Social, ' ', d.Sucursal)", $Match);
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Tiempos_Usuario as tm", "u.Id_Usuario = tm.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->join("Ticket_Finaliza as f", "t.Id_Ticket = f.Id_Ticket", "left");
		$this->db->where("s.Orden",6);	

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		$this->db->group_by("t.Id_Ticket");
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA EL PRIMER/ÚLTIMO TICKET INSERTADO,
	 * SI SE RECIBE ID_USUARIO, SE FILTRAN SUS TICKETS
	 * @param STRING $Orden ORDEN DE LA CONSULTA, 
	 * @param INT $Id_Usuario identificador del usuario
	 * @return void
	 */
	function CNS_LastTicket($Orden,$Id_Usuario = null){
		$this->db->select("Num_Seguimiento,Fecha_Alta");
		$this->db->from("Tickets");
		
		if($Id_Usuario){
			$this->db->where("Usuario_Registra", $Id_Usuario);			
		}

		$this->db->order_by("Num_Seguimiento", $Orden);
		$this->db->limit(1);
		$query = $this->db->get();
		return $query->row();
	}

	/**
	 * CONSULTA UN TICKET POR SI ID
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketByID($Id_Ticket){
		$this->db->select("t.Id_Ticket,t.Id_Usuario, t.Id_Direccion, t.Num_Seguimiento, t.Ruta_Imagen, e.Razon_Social, d.Sucursal, 
						   CONCAT(ur.Nombre, ' ', ur.Apellidos) as Usuario_Reporta, c.Id_Clasificacion_Ticket, c.Nombre as Clasificacion,
						   CONCAT(d.Calle,' ', d.No_Ext,' ', d.No_Int,' ', d.Colonia,' ', d.Municipio,' ', d.Estado) as Direccion, 
						   t.Descripcion,t.Observaciones, t.Fecha_Alta, s.Orden, s.Nombre as Status_Name, CONCAT(u.Nombre, ' ', u.Apellidos) as Usuario");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Usuarios as ur", "t.Usuario_Registra = ur.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->where("t.Id_Ticket", $Id_Ticket);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA UN TICKET POR SI NUMERO DE SEGUIMIENTO
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketByNum($Num_Seguimiento){
		$this->db->select("t.Id_Ticket,t.Id_Usuario, t.Id_Direccion, t.Num_Seguimiento, e.Razon_Social, d.Sucursal, 
						   CONCAT(ur.Nombre, ' ', ur.Apellidos) as Usuario_Reporta, c.Nombre as Clasificacion,
						   CONCAT(d.Calle,' ', d.No_Ext,' ', d.No_Int,' ', d.Colonia,' ', d.Municipio,' ', d.Estado) as Direccion, 
						   t.Descripcion,t.Observaciones, t.Fecha_Alta,s.Orden, CONCAT(u.Nombre, ' ', u.Apellidos) as Usuario");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Usuarios as ur", "t.Usuario_Registra = ur.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->where("t.Num_Seguimiento", $Num_Seguimiento);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA DIAGNOSTICO DE TICKET POR SU ID
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketDiagnostico($Id_Ticket){
		$this->db->select("Diagnostico,Material");
		$this->db->from("Ticket_Diagnostico");
		$this->db->where("Id_Ticket", $Id_Ticket);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA EVIDENCIA EN IMAGENES POR ID_TICKET
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketImagenes($Id_Ticket, $Tipo = null){
		$this->db->select("Tipo, Ruta_Imagen");
		$this->db->from("Evidencia_Fotos");
		$this->db->where("Id_Ticket", $Id_Ticket);
		
		#	Si se recibe el tipo de parametro, se filtra
		if($Tipo){
			$this->db->where("Tipo", $Tipo);	
		}
		
		$query = $this->db->get();
		return $query->result_array();
	}	

	/**
	 * CONSULTA TABLA DE TIEMPOS TICKET POR SU ID
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TiemposTicket($Id_Ticket){
		$this->db->select("Orden, Tipo, Fecha, Razon");
		$this->db->from("Tiempos_Ticket");
		$this->db->order_by("Orden", "ASC");
		$this->db->where("Id_Ticket", $Id_Ticket);
		
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA TABLA DE FINALIZA POR SU ID
	 * @param INT $Id_Ticket IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_TicketFinaliza($Id_Ticket){
		$this->db->select("Costo, Nombre_Supervisor, Observaciones, Fecha_Alta");
		$this->db->from("Ticket_Finaliza");
		$this->db->where("Id_Ticket", $Id_Ticket);
		
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA LOS USUARIOS QUE SON JEFES DE CUADRILLA
	 * Y ESTÁN ACTIVOS
	 */
	function CNS_Usuarios_Servicios($Permiso, $Id_Empresa = null){
		$this->db->select("u.Id_Usuario, u.Nombre, u.Apellidos");
		$this->db->from("Usuarios as u");
		$this->db->join("Rel_Rol_Seccion AS r", "u.Rol = r.Rol", "inner");
		$this->db->where("u.Status", 1);
		$this->db->where("r.Seccion", $Permiso);
		if($Id_Empresa){
			$this->db->where("u.Id_Empresa", $Id_Empresa);
		}
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA LAS SUCURSALES DE LA EMPRESA
	 */
	function CNS_Sucursales(){
		$this->db->select("Id_Direccion, Sucursal, Calle, No_Ext, No_Int, Colonia,
						   Municipio, Estado, Codigo_Postal");
		$this->db->from("Direcciones");	
		$this->db->where("Status", 1);
		$this->db->order_by("Sucursal", "ASC");
		
		$query = $this->db->get();
		return $query->result_array();
	}
	/**
	 * CONSULTA CLASIFICACIONES DE LOS TICKETS
	 */
	function CNS_Clasificaciones(){
		$this->db->select("Id_Clasificacion_Ticket, Clave, Nombre, Descripcion");
		$this->db->from("Clasificaciones_Ticket");
		$this->db->order_by("Nombre", "ASC");
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA UN USUARIO POR SU ID
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 */
	function CNS_UsuarioByID($Id_Usuario){
		$this->db->select("u.Id_Usuario, u.Nombre, u.Usuario,u.TokenFCM, r.Nombre as Rol");
		$this->db->from("Usuarios as u");
		$this->db->join("Roles as r", "u.Rol = r.Abreviatura", "inner");
		$this->db->where("u.Id_Usuario", $Id_Usuario);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA UNA DIRECCION POR SI ID
	 * @param INT $Id_Direccion IDENTIFICADOR DEL REGISTRO
	 */
	function CNS_DireccionByID($Id_Direccion){
		$this->db->select("Id_Direccion, Sucursal, Calle, No_Ext, No_Int, Colonia,
						   Municipio, Estado, Codigo_Postal");
		$this->db->from("Direcciones");
		$this->db->where("Id_Direccion", $Id_Direccion);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA TICKETS CON FILTROS DE FECHAS Y STATUS
	 * @param [DATE] $Fecha_Inicio [RANGO INICIAL DE LA FECHAS]
	 * @param [DATE] $Fecha_Fin    [RANGO INICIAL DE LA FECHAS]
	 * @param [ARRAY] $Filtros     [ARRAY DE STATUS QUE SE VAN A CONSULTAR [a]|[c]]
	 */
	function CNS_TicketsFiltros($Fecha_Inicio,$Fecha_Fin,$Filtros,$Filtro_Usuarios)
	{
		$this->db->select("t.Id_Usuario, t.Num_Seguimiento, t.Fecha_Alta, s.Orden, c.Nombre as Clasificacion, s.Nombre as Status, e.Razon_Social, d.Sucursal,
						   t.Descripcion, f.Nombre_Supervisor, f.Costo,
    					   CONCAT(d.Calle, ' ', d.No_Ext, ' ', d.No_Int, ' ', d.Colonia, ' ', d.Estado, ' ', d.Codigo_Postal) as Direccion,
    					   IF(u.Nombre IS NULL, 'Indefinido', CONCAT(u.Nombre, ' ', u.Apellidos)) as Usuario,
    					   IF(f.Fecha_Alta IS NULL,
							 CASE 
								WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) < tm.Tiempo_1 THEN '#5cb85c'
							    WHEN TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()) > tm.Tiempo_2 THEN '#d9534f'
								ELSE '#f0ad4e'
							END,
							CASE
								WHEN TIMESTAMPDIFF(DAY, t.Fecha_Alta, f.Fecha_Alta) < tm.Tiempo_1 THEN '#5cb85c'
								WHEN TIMESTAMPDIFF(DAY, t.Fecha_Alta, f.Fecha_Alta) > tm.Tiempo_2
								THEN '#d9534f' ELSE '#f0ad4e'
							END) AS Alerta,
							IF(f.Fecha_Alta IS NULL,
								CONCAT(TIMESTAMPDIFF(DAY,t.Fecha_Alta,NOW()), ' días ',
						     	MOD(TIMESTAMPDIFF(HOUR, t.Fecha_Alta, NOW()),24), ' horas'),
						        CONCAT(TIMESTAMPDIFF(DAY,t.Fecha_Alta, f.Fecha_Alta), ' días ',
								MOD(TIMESTAMPDIFF(HOUR, t.Fecha_Alta, f.Fecha_Alta),24), ' horas')		
						    ) as Intervalo");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Clasificaciones_Ticket as c", "t.Id_Clasificacion_Ticket = c.Id_Clasificacion_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Tiempos_Usuario as tm", "u.Id_Usuario = tm.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->join("Ticket_Finaliza as f", "t.Id_Ticket = f.Id_Ticket", "left");

		$this->db->where("t.Fecha_Alta >=", $Fecha_Inicio);
		$this->db->where("t.Fecha_Alta <=", $Fecha_Fin);

		# si en el array de filtros falta alguna de las dos variables ('a' o 'c')
		# se aplican los filtros recibidos
		if(!(in_array("a", $Filtros) && in_array("c", $Filtros))){
			# filtra por tickets abiertos
			if(in_array("a", $Filtros)){
				$this->db->where("s.Orden <", 6);
			# filtra por tickets cerrados
			}elseif(in_array("c", $Filtros)){
				$this->db->where("s.Orden", 6);
			}
		}

		#	Filtros de usuarios
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		$this->db->group_by("t.Id_Ticket");
		$this->db->order_by("t.Fecha_Alta", "ASC");
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * ACTUALIZA EN TABLA TICKETS
	 * @param ID $Id_Ticket IDENTIFICADOR DEL TICKET
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Ticket($Id_Ticket, $dataarray){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->update("Tickets", $dataarray);
		return $this->db->affected_rows();
	}

	/**
	 * ACTUALIZA TICKET DIAGNOSTICO
	  * @param ID $Id_Ticket IDENTIFICADOR DEL TICKET
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Ticket_Diagnostico($Id_Ticket,$dataarray){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->update("Ticket_Diagnostico", $dataarray);
		return $this->db->affected_rows();
	}

	/**
	 * ACTUALIZA TICKET FINALIZA
	  * @param ID $Id_Ticket IDENTIFICADOR DEL TICKET
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Ticket_Finaliza($Id_Ticket,$dataarray){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->update("Ticket_Finaliza", $dataarray);
		return $this->db->affected_rows();
	}

	/**
	 * INSERTA TICKET
	 * @param ARRAY $dataarray RRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Ticket($dataarray){
		$this->db->insert("Tickets", $dataarray);
		return $this->db->insert_id();
	}

	/**
	 * ELIMINA EN TABLA Evidencia_Fotos 
	 * REGISTROS DEL TICKET
	 */
	function DEL_EvidenciaFotos($Id_Ticket){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->delete("Evidencia_Fotos");
		return $this->db->affected_rows();
	}

	/**
	 * ELIMINA EN TABLA Tiempos_Ticket 
	 * REGISTROS DEL TICKET
	 */
	function DEL_TiemposTicket($Id_Ticket){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->delete("Tiempos_Ticket");
		return $this->db->affected_rows();
	}

	/**
	 * ELIMINA EN TABLA Ticket_Diagnostico 
	 * REGISTRO DEL TICKET
	 */
	function DEL_DiagnosticoTicket($Id_Ticket){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->delete("Ticket_Diagnostico");
		return $this->db->affected_rows();
	}

	/**
	 * ELIMINA EN TABLA Ticket_Diagnostico 
	 * REGISTRO DEL TICKET
	 */
	function DEL_CoordenadasTicket($Id_Ticket){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->delete("Ticket_Coordenadas");
		return $this->db->affected_rows();
	}

	/**
	 * ELIMINA EN TABLA Ticket_Finaliza 
	 * REGISTRO DEL TICKET
	 */
	function DEL_FinalizaTicket($Id_Ticket){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->delete("Ticket_Finaliza");
		return $this->db->affected_rows();
	}	

	/**
	 * ELIMINA EN TABLA Tickets EL REGISTRO
	 */
	function DEL_Ticket($Id_Ticket){
		$this->db->where("Id_Ticket", $Id_Ticket);
		$this->db->delete("Tickets");
		return $this->db->affected_rows();
	}	

	/**
	 *  CONSULTA LOS CORREOS A LOS QUE SE LES DEBE ENVIAR CC DEL TICKET
	 * @param [ARRAY ASSOC] $data_array [ARRAY CON EL ID TICKET]
	 */
	function CALL_SPCNS_Usuarios_CC($data_array){
		$str   = "CALL SPCNS_Usuarios_CC(?)";
		$query = $this->db->query($str,$data_array);
		$data  = $query->result_array();
		$query->next_result();
		$query->free_result();
		return $data;
	}	
}
