#
# TABLE STRUCTURE FOR: Clasificaciones_Ticket
#

DROP TABLE IF EXISTS `Clasificaciones_Ticket`;

CREATE TABLE `Clasificaciones_Ticket` (
  `Id_Clasificacion_Ticket` int(11) NOT NULL AUTO_INCREMENT,
  `Id_Padre` int(11) NOT NULL,
  `Clave` varchar(10) NOT NULL,
  `Nombre` varchar(100) NOT NULL,
  `Descripcion` varchar(300) NOT NULL,
  `Status` tinyint(4) NOT NULL,
  `Usuario_Registra` int(11) NOT NULL,
  `Fecha_Alta` datetime NOT NULL,
  `Fecha_Actualiza` datetime NOT NULL,
  PRIMARY KEY (`Id_Clasificacion_Ticket`),
  UNIQUE KEY `Clasificaciones_Ticket_UN` (`Clave`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=latin1;

INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1', '0', 'CLASTKT-01', 'Pintura y recubrimientos', 'Pintura interior, exterior e impermeabilización', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:34:18');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2', '0', 'CLASTKT-02', 'Carpintería', 'Carpintería mobiliario, puertas, accesorios', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:52:18');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3', '0', 'CLASTKT-03', 'Aire acondicionado', 'Minisplits', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:52:36');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('4', '0', 'CLASTKT-04', 'Tabla roca', 'Paredes tabla roca, mantenimiento y construcción ligera', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:52:55');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('5', '0', 'CLASTKT-05', 'Aluminio', 'Puertas, ventanas y estructuras.', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:53:08');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('6', '0', 'CLASTKT-06', 'Electricidad', 'Sistema eléctrico, equilibrar voltajes, iluminación interna y externa,  decorativa, contactos y cableado.', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:53:28');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('7', '0', 'CLASTKT-07', 'Fontanería', 'Sistema hidrosanitario, instalación y mantenimiento de tuberías, conexiones y llaves', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:54:09');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('8', '0', 'CLASTKT-08', 'Albañilería', 'Trabajos de contrucción robusta, resanes, húmedad, colocación y mantenimiento de piso e inmueble en general, etc.', '1', '1', '2018-04-20 11:45:54', '2018-12-12 12:13:59');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('9', '0', 'CLASTKT-09', 'Cortinas metálicas', 'Colocación y mantenimiento de cortinas exteriores', '1', '1', '2018-04-20 11:45:54', '2018-12-12 10:54:40');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('10', '0', 'CLASTKT-10', 'Varios', 'Varios', '1', '1', '2018-04-20 11:45:54', '2018-12-12 12:21:48');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('11', '0', 'CLASTKT-11', 'Internet y Teléfono', 'Internet y Teléfono', '0', '0', '2018-04-20 11:45:54', '2018-04-20 11:45:54');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('12', '0', 'CLASTKT-12', 'Impresora', 'Impresora', '0', '0', '2018-04-20 11:45:54', '2018-04-20 11:45:54');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('13', '0', 'CLASTKT-13', 'Equipo de cómputo (Windows, monitor, CPU)', 'Equipo de cómputo (Windows, monitor, CPU)', '0', '0', '2018-04-20 11:45:54', '2018-04-20 11:45:54');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('14', '0', 'CLASTKT-14', 'Scanner', 'Scanner', '0', '0', '2018-04-20 11:45:54', '2018-04-20 11:45:54');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('15', '0', 'CLASTKT-15', 'Sistemas de Alarma', 'Mantenimiento y sustitución de equipos, configuraciones, accesorios. Conectividad con central de monitoreo', '1', '1', '2018-04-20 11:45:54', '2018-12-12 12:20:17');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('16', '0', 'CLASTKT-16', 'Acrílicos', 'Acrílicos', '0', '0', '2018-04-20 11:45:54', '2018-04-20 11:45:54');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('17', '0', 'CLASTKT-17', 'Garantía', 'Garantía', '1', '1', '2018-04-20 11:45:54', '2018-12-12 12:22:50');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('18', '0', 'CLASTKT-18', 'Cortinas para sol', 'Colocación, lavado y mantenimiento cortinas interiores', '1', '1', '2018-12-12 11:01:58', '2018-12-12 11:01:58');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('19', '0', 'CLASTKT-19', 'Refrigeración', 'Refrigeradores, congeladores y cámaras de refrigeración', '1', '1', '2018-12-12 11:08:02', '2018-12-12 11:08:02');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('20', '0', 'CLASTKT-20', 'Refrigeración Dolce Natura', 'Refrigeradores y congeladores', '1', '1', '2018-12-12 11:08:17', '2018-12-12 11:08:17');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('21', '0', 'CLASTKT-21', 'Puertas y cristales', 'Puertas, chapas, electroiman, accesorios.  Cristales de muebles', '1', '1', '2018-12-12 11:09:02', '2018-12-12 11:09:02');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('22', '0', 'CLASTKT-22', 'Anuncios luminosos', 'Instalación, mantenimiento anuncio y reloj de programación de encendido', '1', '1', '2018-12-12 12:10:48', '2018-12-12 12:10:48');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('23', '0', 'CLASTKT-23', 'Toldos', 'Instalación, mantenimiento y limpieza.', '1', '1', '2018-12-12 12:12:56', '2018-12-12 12:12:56');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('24', '0', 'CLASTKT-24', 'Banners, gráficos, señalice e imagen visual interior', 'Etiquetas de precios, viniles, fotos, anuncios de temporada, imagen en general, señalètica de puertas de cristal y del interior de la tienda.', '1', '1', '2018-12-12 12:13:26', '2018-12-12 12:13:26');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('25', '0', 'CLASTKT-25', 'Hardware', 'Impresoras, CPU, teclado, mouse, scanner, checador de huella digital, cámaras, DVR, equipo telefónico, cámaras de videovigilancia.', '1', '1', '2018-12-12 12:14:23', '2018-12-12 12:14:23');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('26', '0', 'CLASTKT-26', 'Conectividad telefonía e internet', 'Conexión de internet, lineas telefónicas, cableado, voz y datos.', '1', '1', '2018-12-12 12:15:41', '2018-12-12 12:15:41');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('27', '0', 'CLASTKT-27', 'Videovigilancia', 'Solicitud de vídeos del sistema', '1', '1', '2018-12-12 12:17:57', '2018-12-12 12:17:57');
INSERT INTO `Clasificaciones_Ticket` (`Id_Clasificacion_Ticket`, `Id_Padre`, `Clave`, `Nombre`, `Descripcion`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('28', '0', 'CLASTKT-28', 'Mantenimiento Interno', 'Instalaciones  y trabajos menores, ajustes y colocación de repisas, corchos, letreros internos, percheros, etc.', '1', '1', '2018-12-12 12:21:30', '2018-12-12 12:21:30');


#
# TABLE STRUCTURE FOR: Configuracion
#

DROP TABLE IF EXISTS `Configuracion`;

CREATE TABLE `Configuracion` (
  `Id_Configuracion` int(11) NOT NULL AUTO_INCREMENT,
  `Abreviatura` varchar(10) CHARACTER SET latin1 COLLATE latin1_bin NOT NULL,
  `Propiedad` varchar(45) NOT NULL,
  `Grupo` varchar(10) NOT NULL,
  `Valor` varchar(100) DEFAULT NULL,
  `Descripcion` varchar(300) DEFAULT NULL,
  `Usuario_Registra` int(11) NOT NULL,
  `Fecha_Alta` datetime NOT NULL,
  `Fecha_Actualiza` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`Id_Configuracion`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1;

INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1', 'SMTPHOST', 'SMTP Host', 'MAIL', 'mail.marisa.mx', 'SMTP Host', '0', '2018-04-24 10:03:53', '2018-07-12 12:57:26');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2', 'SMTPUSER', 'E-mail', 'MAIL', 'tickets@marisa.mx', 'E-mail', '0', '2018-04-24 10:03:53', '2018-07-12 12:57:22');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3', 'SMTPPSSW', 'SMTP Constraseña', 'MAIL', 'TicketsMarisa2018.', 'SMTP Constraseña', '0', '2018-04-24 10:03:53', '2018-07-12 12:57:04');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('4', 'SMTPPORT', 'SMTP Puerto', 'MAIL', '587', 'SMTP Puerto', '0', '2018-04-24 10:03:53', '2018-04-24 10:03:53');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('5', 'NAMEREMT', 'Nombre del remitente', 'MAIL', 'Marisa Tickets', 'Nombre del remitente', '0', '2018-04-24 10:03:53', '2018-04-24 10:03:53');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('6', 'CCTICKET1', 'Copia de correo ticket 1', 'CCTICKET', 'desarrollo@creeartelo.mx', 'Copia de correo ticket 1', '0', '2018-05-02 14:57:10', '2018-05-02 14:59:40');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('7', 'TOPALRT', 'Máximo de dias para las alertas', 'TOPALRT', '31', 'Máximo de dias para las alertas', '0', '2018-05-02 15:29:25', '2018-05-02 15:29:25');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('8', 'ALLOWTYP', 'Formatos', 'UPLOAD', 'jpg|jpeg|png', 'Formatos permitidos de subida', '0', '2018-04-24 10:03:53', '2018-04-24 10:03:53');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('9', 'MAXSIZE', 'Tamaño máximo', 'UPLOAD', '8192', 'Tamaño máximo de subida', '0', '2018-04-24 10:03:53', '2018-06-04 11:32:47');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('10', 'MAXFNAME', 'Tamaño máximo del nombre', 'UPLOAD', '40', 'Tamaño máximo del nombre del archivo a subir', '0', '2018-04-24 10:03:53', '2018-06-04 11:32:47');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('13', 'CCTICKET3', 'Copia de correo ticket 3', 'CCTICKET', 'serviciosmtto@pasteleriasmarisa.com.mx', 'Copia de correo ticket 3', '0', '2018-05-02 14:57:10', '2018-05-02 14:59:40');
INSERT INTO `Configuracion` (`Id_Configuracion`, `Abreviatura`, `Propiedad`, `Grupo`, `Valor`, `Descripcion`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('12', 'CCTICKET3', 'Copia de correo ticket 3', 'CCTICKET', 'mmanjarrez@creeartelo.mx', 'Copia de correo ticket 3', '0', '2018-05-02 14:57:10', '2018-05-02 14:59:40');


#
# TABLE STRUCTURE FOR: Direcciones
#

DROP TABLE IF EXISTS `Direcciones`;

CREATE TABLE `Direcciones` (
  `Id_Direccion` int(11) NOT NULL AUTO_INCREMENT,
  `Id_Empresa` int(11) NOT NULL,
  `Clave` varchar(20) NOT NULL,
  `Sucursal` varchar(50) NOT NULL,
  `Calle` varchar(100) NOT NULL,
  `No_Ext` varchar(30) NOT NULL,
  `No_Int` varchar(30) DEFAULT NULL,
  `Colonia` varchar(100) NOT NULL,
  `Municipio` varchar(150) NOT NULL,
  `Estado` varchar(150) NOT NULL,
  `Codigo_Postal` varchar(5) NOT NULL,
  `Correo_Electronico` varchar(150) NOT NULL,
  `Latitud` varchar(30) NOT NULL,
  `Longitud` varchar(30) NOT NULL,
  `Status` bit(1) NOT NULL,
  `Usuario_Registra` int(11) NOT NULL DEFAULT '0',
  `Fecha_Alta` datetime NOT NULL,
  `Fecha_Actualiza` datetime NOT NULL,
  PRIMARY KEY (`Id_Direccion`),
  UNIQUE KEY `Direcciones_UN` (`Clave`)
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=latin1;

INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1', '1', 'CHP', 'PM Chapultepec', 'Av. Chapultepec', '371', '', 'Americana', 'Guadalajara', 'Jalisco', '44160', 'chapultepec@pasteleriasmarisa.com.mx', '20.670243', '-103.36825299999998', '1', '1', '2018-02-20 16:02:08', '2018-12-10 16:45:23');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2', '1', 'CHA', 'PM Chapalita', 'Av Guadalupe', '845', 'A', 'Chapalita', 'Zapopan', 'Jalisco', '44510', 'chapalita@pasteleriasmarisa.com.mx', '20.666139', '-103.40071210000002', '1', '1', '2018-02-20 16:03:05', '2018-12-10 16:45:52');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3', '1', 'GOL', 'PM Golfo de Cortés', 'Golfo de Cortés', '4182', '2', 'Monraz', 'Guadalajara', 'Jalisco', '44670', 'golfo@pasteleriasmarisa.com.mx', '20.68174568422679', '-103.395885235582', '1', '1', '2018-02-25 14:43:55', '2018-12-10 17:07:12');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('4', '1', 'AME', 'PM Américas', 'Av. Américas', '538', '', 'Ladrón de Guevara', 'Guadalajara', 'Jalisco', '44680', 'americas@pasteleriasmarisa.com.mx', '20.68651876482317', '-103.37305741609043', '1', '1', '2018-05-15 09:09:03', '2018-12-10 17:04:34');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('5', '1', 'ARC', 'PM Arcos', 'Av. De los Arcos', '660', 'L1', 'Jardines del Bosque', 'Guadalajara', 'Jalisco', '44520', 'arcos@pasteleriasmarisa.com.mx', '20.6673996', '-103.3847419', '1', '1', '2018-05-15 12:14:42', '2018-12-10 17:04:45');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('6', '1', 'AVI', 'PM Ávila Camacho', 'Av. Ávila Camacho', '2093', 'A', 'Country Club', 'Guadalajara', 'Jalisco', '44637', 'avila@pasteleriasmarisa.com.mx', '20.6528405', '-103.2562794', '1', '1', '2018-05-15 12:16:46', '2018-12-10 17:05:25');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('7', '1', 'CAZ', 'PM Calzada', 'Av. Circunvalación', '154', '1', 'Independencia Oriente', 'Guadalajara', 'Jalisco', '44241', 'calzada@pasteleriasmarisa.com.mx', '20.695945', '-103.32817319999998', '1', '1', '2018-05-15 12:20:34', '2018-12-10 17:05:35');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('8', '1', 'CEN', 'PM Centro', 'Galeana', '144', '', 'Centro', 'Guadalajara', 'Jalisco', '44100', 'centro@pasteleriasmarisa.com.mx', '20.6744367', '-103.34889720000001', '1', '1', '2018-05-15 12:22:44', '2018-12-10 17:05:43');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('9', '1', 'COL', 'PM Colón', 'Av. López Mateos', '1193', '', 'Providencia', 'Guadalajara', 'Jalisco', '44630', 'colon@pasteleriasmarisa.com.mx', '20.6954044', '-103.37378469999999', '1', '1', '2018-05-15 12:26:29', '2018-12-10 17:06:29');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('10', '1', 'EXO', 'PM Expo', 'Av Diamante', '2544', 'L2', 'Bosques de la Victoria', 'Guadalajara', 'Jalisco', '44540', 'expo@pasteleriasmarisa.com.mx', '20.64800709999999', '-103.39002979999998', '1', '1', '2018-05-15 12:28:36', '2018-12-10 17:07:04');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('11', '1', 'IND', 'PM Independencia', 'Calzada Independencia Norte', '2955', '', 'Lomas de Independencia', 'Guadalajara', 'Jalisco', '44240', 'independencia@pasteleriasmarisa.com.mx', '20.7126801', '-103.32224810000002', '1', '1', '2018-05-15 12:31:35', '2018-12-10 17:07:29');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('12', '1', 'JUA', 'PM Juan Pablo II', 'Av. Juan Pablo II', '3205', '6', 'Barranca de la Hacienda de Oblatos', 'Guadalajara', 'Jalisco', '44729', 'juanpablo@pasteleriasmarisa.com.mx', '20.7030697', '-103.2833579', '1', '1', '2018-05-15 12:38:22', '2018-12-10 17:07:46');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('13', '1', 'LAZ', 'PM Lázaro Cárdenas', 'Av. Lázaro Cárdenas', '2385', 'L4', 'Las Torres', 'Guadalajara', 'Jalisco', '44920', 'lazaro@pasteleriasmarisa.com.mx', '20.656558', '-103.379208', '1', '1', '2018-05-15 12:40:29', '2018-12-10 17:08:18');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('14', '1', 'OBL', 'PM Oblatos', 'Av. Circunvalación', '2353', '', 'Oblatos', 'Guadalajara', 'Jalisco', '44210', 'oblatos@pasteleriasmarisa.com.mx', '20.6893974', '-103.29718630000002', '1', '1', '2018-05-15 12:42:27', '2018-12-10 17:08:55');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('15', '1', 'OLI', 'PM Olímpica', 'Av. Fernando Méndez Velázquez', '1710', 'L3', 'Ciudad Universitaria', 'Guadalajara', 'Jalisco', '44430', 'olimpica@pasteleriasmarisa.com.mx', '20.6534613', '-103.32478049999997', '1', '1', '2018-05-15 12:52:13', '2018-12-10 17:09:30');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('16', '1', 'PRO', 'PM Providencia', 'Av. Montevideo', '3204', 'A', 'Providencia', 'Guadalajara', 'Jalisco', '44639', 'providencia@pasteleriasmarisa.com.mx', '20.6965', '-103.3897935', '1', '1', '2018-05-15 12:53:38', '2018-12-10 17:10:00');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('17', '1', 'REV', 'PM Revolución', 'Av. Revolución', '2238', '', 'Lómas del Paradero', 'Guadalajara', 'Jalisco', '44840', 'revolucion@pasteleriasmarisa.com.mx', '20.6509292', '-103.31075120000003', '1', '1', '2018-05-15 12:54:59', '2018-12-10 17:10:15');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('18', '1', 'ROS', 'PM Las Rosas', 'Av. López Mateos', '1917', 'L1', 'Chapalita', 'Guadalajara', 'Jalisco', '44510', 'lasrosas@pasteleriasmarisa.com.mx', '20.65913289561017', '-103.39728866911162', '1', '1', '2018-05-15 13:11:47', '2018-12-10 17:08:11');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('19', '1', 'TRA', 'PM Tránsito', 'Av. División del Norte', '1008', '', 'Tránsito', 'Guadalajara', 'Jalisco', '44228', 'transito@pasteleriasmarisa.com.mx', '20.705696334451382', '-103.34757577829771', '1', '1', '2018-05-15 13:21:29', '2018-12-10 17:15:58');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('20', '1', 'AJI', 'PM Ajijic', 'Blvd. Chapala-Jocotepec', '57', '2', 'Ajijic', 'Ajijic', 'Jalisco', '45920', 'ajijic@pasteleriasmarisa.com.mx', '20.2998674', '-103.25599720000002', '1', '1', '2018-05-15 13:24:02', '2018-12-10 17:04:14');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('21', '1', 'TED', 'PM Tepatitlán', 'Circuito Interior SS Juan Pablo II', '325', 'A11', 'La Gloria', 'Tepatitlán', 'Jalisco', '47670', 'tepa2@pasteleriasmarisa.com.mx', '20.8092676', '-102.7770471', '1', '1', '2018-05-15 13:26:03', '2018-12-10 17:15:06');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('22', '1', 'TEA', 'PM Tepatitlán Centro', 'Samartín', '146', '', 'Centro', 'Tepatitlán', 'Jalisco', '47600', 'tepa@pasteleriasmarisa.com.mx', '20.815705', '-102.76107000000002', '1', '1', '2018-05-15 13:26:51', '2018-12-10 17:14:41');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('23', '1', 'MAN', 'PM Manantial', 'Av. López Mateos', '5560', 'L15', 'Manantial', 'Tlajomulco de Zuñiga', 'Jalisco', '45645', 'manantial@pasteleriasmarisa.com.mx', '20.5652546', '-103.46023000000002', '1', '1', '2018-05-15 13:28:37', '2018-12-10 17:08:34');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('24', '1', 'OJU', 'PM 8 de Julio', 'Av. Prolongación 8 de Julio', '2067', '24C', 'San Sebastianito', 'Tlaquepaque', 'Jalisco', '45610', '8julio@pasteleriasmarisa.com.mx', '20.5847154', '-103.3859885', '1', '1', '2018-05-15 13:31:06', '2018-12-10 17:03:32');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('25', '1', 'ADO', 'PM Adolf Horn', 'Av. Adolf Horn', '3', '', 'Toluquilla', 'Tlaquepaque', 'Jalisco', '45610', 'adolf@pasteleriasmarisa.com.mx', '20.5724458', '-103.36455940000002', '1', '1', '2018-05-15 13:36:32', '2018-12-10 17:03:54');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('26', '1', 'ALA', 'PM Álamo', 'Niños Héroes', '705', 'L5', 'Quintas Álamo', 'Tlaquepaque', 'Jalisco', '45560', 'alamo@pasteleriasmarisa.com.mx', '20.62700989999999', '-103.31986979999999', '1', '1', '2018-05-15 13:38:05', '2018-12-10 17:04:25');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('27', '1', 'RCO', 'PM Real a Colima', 'Prol. Cristóba Colón', '6034', '', 'Santa María Tequepexpan', 'Tlaquepaque', 'Jalisco', '45601', 'realcolima@pasteleriasmarisa.com.mx', '20.6005695', '-103.40386799999999', '1', '1', '2018-05-15 13:39:50', '2018-12-10 17:10:08');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('28', '1', 'CON', 'PM Conchitas', 'Av. Conchitas', '4629', '', 'Lomas de la Victoria', 'Tlaquepaque', 'Jalisco', '45588', 'conchitas@pasteleriasmarisa.com.mx', '20.633607', '-103.3996598', '1', '1', '2018-05-15 13:41:47', '2018-12-10 17:06:45');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('29', '1', 'RIO', 'PM Rio Nilo', 'Av. Patria', '34', 'L5', 'La Soledad', 'Tlaquepaque', 'Jalisco', '45525', 'rionilo@pasteleriasmarisa.com.mx', '20.637918376965295', '-103.28402077852161', '1', '1', '2018-05-15 13:57:43', '2018-12-10 17:10:23');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('30', '1', 'TLA', 'PM Tlaquepaque', 'Av. Juárez', '149', '', 'Centro', 'Tlaquepaque', 'Jalisco', '45500', 'tlaquepaque@pasteleriasmarisa.com.mx', '20.638335941278257', '-103.31253668216772', '1', '1', '2018-05-15 14:01:33', '2018-12-10 17:15:23');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('31', '1', 'TON', 'PM Tonalá', 'Av. Tonaltecas', '375', '12A', 'Centro', 'Tonalá', 'Jalisco', '45400', 'tonala@pasteleriasmarisa.com.mx', '20.63268397943938', '-103.2447570623986', '1', '1', '2018-05-15 14:06:36', '2018-12-10 17:15:49');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('32', '1', 'ACU', 'PM Acueducto', 'Av. Acueducto', '3901', 'A', 'Real San Bernardo', 'Zapopan', 'Jalisco', '45110', 'acueducto@pasteleriasmarisa.com.mx', '20.70688514624279', '-103.40523114171617', '1', '1', '2018-05-15 14:09:03', '2018-12-10 17:03:42');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('33', '1', 'AVC', 'PM Aviación', 'Av. Aviación', '2197', 'L3', 'San Juan de Ocotán', 'Zapopan', 'Jalisco', '45019', 'aviacion@pasteleriasmarisa.com.mx', '20.724155697321475', '-103.45424488157994', '1', '1', '2018-05-15 14:48:20', '2018-12-10 17:05:09');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('34', '1', 'CAL', 'PM La Calma', 'Av. López Mateos', '5040', '5', 'La Calma', 'Zapopan', 'Jalisco', '45070', 'lacalma@pasteleriasmarisa.com.mx', '20.633791690073235', '-103.4146001139838', '1', '1', '2018-05-15 14:52:40', '2018-12-10 17:07:54');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('35', '1', 'CIM', 'PM La Cima', 'Av. Juan Gil Preciado', '1600', 'L5', 'Arcos de Zapopan 3ra sección', 'Zapopan', 'Jalisco', '45130', 'cima@pasteleriasmarisa.com.mx', '20.747268737513654', '-103.4147862274433', '1', '1', '2018-05-15 14:56:58', '2018-12-10 17:08:02');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('36', '1', 'PM-CSOL', 'PM Ciudad del Sol', 'Quetzalcóatl', '595', '', 'Ciudad del Sol', 'Zapopan', 'Jalisco', '45050', 'ciudadsol@pasteleriasmarisa.com.mx', '20.649917041206585', '-103.40520793678797', '0', '43', '2018-05-15 14:58:50', '2018-09-11 17:47:32');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('37', '1', 'CLU', 'PM Clouthier', 'Av. Manuel J. Clouthier', '326', 'A', 'Lomas de Zapopan', 'Zapopan', 'Jalisco', '45038', 'clouthier@pasteleriasmarisa.com.mx', '20.669119500797304', '-103.41828739459896', '1', '1', '2018-05-15 15:02:17', '2018-12-10 17:06:20');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('38', '1', 'COR', 'PM Coral', 'Coral', '3219', 'A', 'Residencial Victoria', 'Zapopan', 'Jalisco', '45089', 'coral@pasteleriasmarisa.com.mx', '20.642213882508532', '-103.39934900151184', '1', '1', '2018-05-15 15:04:10', '2018-12-10 17:06:55');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('39', '1', 'GUA', 'PM Guadalupe', 'Av. Guadalupe', '6180', 'B', 'Residencial Plaza Guadalupe', 'Zapopan', 'Jalisco', '45030', 'guadalupe@pasteleriasmarisa.com.mx', '20.659026234531765', '-103.43805270416033', '1', '1', '2018-05-15 15:08:24', '2018-12-10 17:07:20');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('40', '1', 'LOM', 'PM Lomas Altas', 'Paseo Lomas Altas', '292', 'B', 'Lomas del Valle', 'Zapopan', 'Jalisco', '45129', 'lomasaltas@pasteleriasmarisa.com.mx', '20.687096940976218', '-103.41074101744385', '1', '1', '2018-05-15 15:10:46', '2018-12-10 17:08:26');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('41', '1', 'NAC', 'PM Naciones Unidas', 'Av. Naciones Unidas', '5428', '1', 'Vallarta Universidad', 'Zapopan', 'Jalisco', '45110', 'nacionesunidas@pasteleriasmarisa.com.mx', '20.687959055080945', '-103.42607379321936', '1', '1', '2018-05-15 15:13:14', '2018-12-10 17:08:47');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('42', '1', 'PAT', 'PM Patria', 'Av. Patria', '2974', 'C', 'El Coli Urbano', 'Zapopan', 'Jalisco', '45070', 'patria@pasteleriasmarisa.com.mx', '20.639381255029058', '-103.419933336788', '1', '1', '2018-05-15 15:18:10', '2018-12-10 17:09:41');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('43', '1', 'PPA', 'PM Plaza Patria', 'Av. Patria', '1950', 'L A6', 'Jacarandas', 'Zapopan', 'Jalisco', '45160', 'plazapatria@pasteleriasmarisa.com.mx', '20.71286253673479', '-103.37882535824906', '1', '1', '2018-05-15 15:22:19', '2018-12-10 17:09:51');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('44', '1', 'SAN', 'PM San Isidro', 'Prol. Rio Blanco', '29', '11', 'Rinconada de los Sauces', 'Zapopan', 'Jalisco', '45130', 'sanisidro@pasteleriasmarisa.com.mx', '20.752561681139237', '-103.38394838216772', '1', '1', '2018-05-15 15:25:15', '2018-12-10 17:10:33');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('45', '1', 'TEC', 'PM Technology Park', 'Carretera a Nogales', '4760', 'L16', 'Guadalajara Techonolgy Park', 'Zapopan', 'Jalisco', '45203', 'technology@pasteleriasmarisa.com.mx', '20.720971438017983', '-103.4909448830332', '1', '1', '2018-05-15 15:35:21', '2018-12-10 17:10:50');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('46', '1', 'TEP', 'PM Tepeyac', 'Av. Tepeyac', '4685', '', 'Prados Tepeyac', 'Zapopan', 'Jalisco', '45050', 'tepeyac@pasteleriasmarisa.com.mx', '20.65699027907681', '-103.4185113159212', '1', '1', '2018-05-15 15:37:18', '2018-12-10 17:15:14');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('47', '1', 'UNI', 'PM Universidad', 'Av. Patria', '720', '', 'Jardines Universidad', 'Zapopan', 'Jalisco', '45110', 'universidad@pasteleriasmarisa.com.mx', '20.68940977556979', '-103.41826821624443', '1', '1', '2018-05-15 15:40:05', '2018-12-10 17:16:06');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('48', '1', 'VTA', 'PM Vallarta', 'Calzada Central', '6039', '2', 'Ciudad Granja', 'Zapopan', 'Jalisco', '45010', 'vallarta@pasteleriasmarisa.com.mx', '20.68489891370068', '-103.4428710720988', '1', '1', '2018-05-15 15:42:29', '2018-12-10 17:16:14');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('49', '1', 'VAL', 'PM Valle Real', 'Av. Santa Margarita', '4140', '7', 'Novaterra', 'Zapopan', 'Jalisco', '45019', 'vallereal@pasteleriasmarisa.com.mx', '20.729818218956726', '-103.43513091563273', '1', '1', '2018-05-15 15:54:39', '2018-12-10 17:16:24');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('50', '1', 'DIG', 'DN San Ignacio', 'Av. San Ingacio', '93', '7', 'Jardín de San Ignacio', 'Zapopan', 'Jalisco', '45040', 'dolcesanignacio@pasteleriasmarisa.com.mx', '20.667375182328833', '-103.4047696036701', '1', '1', '2018-05-15 16:43:29', '2018-12-10 17:00:16');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('51', '1', 'DCSOL', 'DN Ciudad del Sol', 'Quetazlcóatl', '595', '', 'Ciudad del Sol', 'Zapopan', 'Jalisco', '45050', 'dolcesol@pasteleriasmarisa.com.mx', '20.64980649713137', '-103.40528847513991', '0', '1', '2018-05-15 16:45:24', '2018-12-10 16:55:06');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('52', '1', 'DGO', 'DN Golfo de Cortés', 'Golfo de Cortés', '4176', '3', 'Monraz', 'Zapopan', 'Jalisco', '44670', 'dolcegolfo@pasteleriasmarisa.com.mx', '20.681709710956525', '-103.3958558276127', '1', '1', '2018-05-15 16:48:00', '2018-12-10 16:47:38');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('53', '1', 'DCA', 'DN La Calma', 'Av. López Mateos', '5054', '', 'La Calma', 'Zapopan', 'Jalisco', '45070', 'dolcecalma@pasteleriasmarisa.com.mx', '20.633736994168967', '-103.41463656440067', '1', '1', '2018-05-15 16:49:49', '2018-12-10 16:48:36');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('54', '1', 'DCI', 'DN La Cima', 'Av. Juan Gil Preciado', '1600', 'A7', 'Arcos de Zapopan', 'Zapopan', 'Jalisco', '45130', 'dolcecima@pasteleriasmarisa.com.mx', '20.747173027068733', '-103.41472210734025', '1', '1', '2018-05-15 16:51:27', '2018-12-10 16:51:51');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('55', '1', 'DGP', 'DN Gran Plaza', 'Av. Vallarta', '3959', 'R13', 'Don Bosco Vallarta', 'Zapopan', 'Jalisco', '44540', 'dolcegranplaza@pasteleriasmarisa.com.mx', '20.673826804196967', '-103.40492734844474', '1', '1', '2018-05-15 16:53:57', '2018-12-10 16:47:59');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('56', '1', 'DMA', 'DN Manantial', 'Av. López Mateos', '5560', '', 'Manantial', 'Tlajomulco de Zuñiga', 'Jalisco', '45645', 'dolcemanantial@pasteleriasmarisa.com.mx', '20.565340632051356', '-103.46016005304978', '1', '1', '2018-05-15 16:56:01', '2018-12-10 16:52:02');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('57', '1', 'DOL', 'DN Olímpica', 'Av. Fernando Méndez Velázquez', '1710', 'L4', 'Ciudad Universitaria', 'Guadalajara', 'Jalisco', '44430', 'dolceolimpica@pasteleriasmarisa.com.mx', '20.653406252466194', '-103.3245788898551', '1', '1', '2018-05-15 16:58:09', '2018-12-10 16:52:18');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('58', '1', 'DGA', 'DN Galerías', 'Av. Rafael Sanzio', '150', 'FF-17', 'Camichines Vallarta', 'Zapopan', 'Jalisco', '45030', 'dolcegalerias@pasteleriasmarisa.com.mx', '20.676614592494698', '-103.43176357175827', '1', '1', '2018-05-15 17:00:04', '2018-12-10 16:47:15');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('59', '1', 'DPP', 'DN Plaza Patria', 'Av. Patria', '1950', 'L A6', 'Jacarandas', 'Zapopan', 'Jalisco', '45160', 'dolceplazapatria@pasteleriasmarisa.com.mx', '20.712829015698684', '-103.37903050797172', '1', '1', '2018-05-15 17:01:52', '2018-12-10 16:56:09');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('60', '1', 'DST', 'DN Santa Tere', 'Juan Álvarez', '1571', '', 'Santa Tere', 'Guadalajara', 'Jalisco', '44600', 'dolcepstatere@pasteleriasmarisa.com.mx', '20.684832127326825', '-103.3686895671359', '0', '1', '2018-05-15 17:03:33', '2018-12-10 17:00:25');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('61', '1', 'DVA', 'DN Valle Real', 'Santa Margarita', '4140', '3B', 'Novaterra', 'Zapopan', 'Jalisco', '45019', 'dolcevalle@pasteleriasmarisa.com.mx', '20.729792550725794', '-103.43490572451952', '1', '1', '2018-05-15 17:05:52', '2018-12-10 17:00:45');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('62', '1', 'STA', 'TL Santa Tere', 'Juan Álvarez', '1571', '', 'Santa Teresita', 'Guadalajara', 'Jalisco', '44600', 'santatere@pasteleriasmarisa.com.mx', '20.684877687207422', '-103.36866395772404', '1', '1', '2018-05-17 10:02:59', '2018-12-10 17:16:57');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('63', '1', 'ABA', 'Expendio Abastos', 'Calle 1', '120', '', 'Comercial Abastos', 'Guadalajara', 'Jalisco', '44530', 'abastos@pasteleriasmarisa.com.mx', '20.657250217755813', '-103.3808063179344', '1', '1', '2018-05-17 10:06:31', '2018-12-10 17:00:56');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('64', '1', 'EXP', 'Expendio Mercado del Mar', 'Prol. Pino Suárez', '1127', '', 'El Vigía', 'Zapopan', 'Jalisco', '45145', 'expendio@pasteleriasmarisa.com.mx', '20.732476779058857', '-103.38985340894163', '1', '1', '2018-05-17 10:09:57', '2018-12-10 17:01:25');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('65', '1', 'PTA', 'PLANTA', 'Prol. Pino Suárez', '1039', '20', 'Parque Industrial Belenes Norte', 'Zapopan', 'Jalisco', '45145', 'mmanjarrez@creeartelo.mx', '20.737599087371887', '-103.38960664571226', '1', '1', '2018-05-18 19:53:22', '2018-12-10 17:03:22');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('66', '1', 'TES', 'TL Tesistán', 'Hidalgo', '100', '', 'San Francisco', 'Tesistán', 'Jalisco', '45200', 'tesistan@tialola.com.mx', '20.79922626499459', '-103.47894834578932', '1', '1', '2018-06-02 10:41:08', '2018-12-10 17:17:04');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('67', '1', 'MAG', 'TL-StaMargarita', 'Av Sta Margarita', '3028', '2', 'La Mora, Santa Margarita 1ra Sección', 'Zapopan', 'Jalisco', '45130', 'santamago@tialola.com.mx', '20.730635515204757', '-103.41788249314726', '1', '1', '2018-06-02 11:31:16', '2018-12-10 17:17:28');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('68', '1', 'COP', 'TL-Copernico', 'Av. Enrique Ladrón de Guevara', '4000', '', 'Paseos del Sol', 'Zapopan', 'Jalisco', '45079', 'copernico@tialola.com.mx', '20.63480876958091', '-103.42666404546202', '1', '1', '2018-06-02 11:40:35', '2018-12-10 17:17:17');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('69', '1', 'ATE', 'Expendio Atemajac', 'Av. Federalismo Norte', '2372', '', 'Fabrica de Atemajac', 'Guadalajara', 'Jalisco', '44218', 'atemajac@pasteleriasmarisa.com.mx', '20.714449491270795', '-103.3457578927368', '1', '1', '2018-07-11 11:50:53', '2018-12-10 17:01:08');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('70', '1', 'DGU', 'DN Guadalupe', 'Av guadalupe', '618', 'local A', 'residencial guadalupe', 'zapopan', 'jalisco', '45030', 'dolceguadalupe@dolcenatura.com', '20.65901457097984', '-103.4383852988571', '1', '1', '2018-09-11 17:59:36', '2018-12-10 16:49:37');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('75', '1', 'DBU', 'DN Bugambilias', 'Blv Bugambilias, Plaza bugambilias', '2299', 'Local C38B', 'A un costado de Dominos Piza', 'Zapopan', 'Jalisco', '45238', 'dolcebugambilias@dolcenatura.com', '20.600350872842142', '-103.44793078280333', '1', '43', '2018-12-17 12:23:13', '2018-12-17 12:23:13');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('71', '1', 'BOS', 'TL San juan Bosco', 'Castellanos y Tapia', '473', '', 'San Juan Bosco', 'Guadalajara', 'Jalisco', '44729', 'sjbosco@tialola.com.mx', '20.676220786606844', '-103.31459796011887', '1', '1', '2018-11-07 16:13:31', '2018-12-10 17:16:42');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('72', '1', 'DPS', 'DN Plaza del Sol', 'Centro Comercial Plaza del Sol', 'LOPEZ MATEOS # 2375', 'Local 9,10,11 Zona H', 'Ciudad del Sol', 'Zapopan', 'Jalisco', '15050', 'dolceplazasol@dolcenatura.com', '20.650150548037924', '-103.40198507679065', '1', '1', '2018-11-07 16:38:01', '2018-12-10 16:55:36');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('73', '1', 'ANI', 'PM Santa Anita', 'Centro Comercial Plaza Roble', 'Ramon Corona # 750', 'Local 8', 'Santa Anita', 'Zapopan', 'Jalisco', '45640', 'santaanita@pasteleriasmarisa.com.mx', '20.556520448893526', '-103.45841396837005', '1', '1', '2018-11-07 17:11:17', '2018-12-10 17:10:42');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('74', '1', 'BUG', 'PM Marisa Bugambilias', 'Blv. bugambilias ,Plaza Bugambilias', '2299', 'Local C38B a un Costado de GNC', 'Bugambilias', 'Zapopan', 'Jalisco', '45238', 'bugambilias@pasteleriasmarisa.com.mx', '20.60034585143896', '-103.44809707976225', '1', '1', '2018-11-15 11:08:29', '2018-12-10 17:09:18');
INSERT INTO `Direcciones` (`Id_Direccion`, `Id_Empresa`, `Clave`, `Sucursal`, `Calle`, `No_Ext`, `No_Int`, `Colonia`, `Municipio`, `Estado`, `Codigo_Postal`, `Correo_Electronico`, `Latitud`, `Longitud`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('76', '1', 'DPA', 'DN Plaza Patria Planta Alta', 'Av. Patria', '1950', 'PG2', 'Jacarandas', 'Zapopan', 'Jalisco', '45144', 'dolcepatriapa@dolcenatura.com', '20.7125399', '-103.37858499999999', '1', '1', '2018-12-27 16:09:40', '2018-12-27 16:09:40');


#
# TABLE STRUCTURE FOR: Empresas
#

DROP TABLE IF EXISTS `Empresas`;

CREATE TABLE `Empresas` (
  `Id_Empresa` int(11) NOT NULL AUTO_INCREMENT,
  `Codigo` varchar(20) NOT NULL,
  `Razon_Social` varchar(200) NOT NULL,
  `Logo` varchar(50) DEFAULT NULL,
  `Status` bit(1) NOT NULL,
  `Usuario_Registra` int(11) NOT NULL DEFAULT '0',
  `Fecha_Alta` datetime NOT NULL,
  `Fecha_Actualiza` datetime NOT NULL,
  PRIMARY KEY (`Id_Empresa`),
  UNIQUE KEY `Codigo_UNIQUE` (`Codigo`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=latin1;

INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1', 'EM-001', 'PASTELERÍAS MARISA', NULL, '1', '0', '2018-02-19 15:24:24', '2018-02-19 15:24:24');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('6', 'PV-003', 'ARCACRILICOS', NULL, '1', '1', '2018-05-18 16:17:09', '2018-05-30 10:35:24');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3', 'PV-002', 'MANTENIMIENTO BARBA', NULL, '1', '43', '2018-05-16 10:37:59', '2018-11-09 12:52:49');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('21', 'PV-016', 'Mantenimiento Marisa', NULL, '1', '43', '2018-12-17 11:59:32', '2019-01-14 10:00:27');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('8', 'PV-005', 'SOLUCIONES LIMPIEZA', NULL, '1', '1', '2018-05-21 18:40:32', '2018-05-30 10:33:30');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('9', 'PV-006', 'SOPORTE TERMICO AA', NULL, '1', '1', '2018-05-21 18:45:47', '2018-07-23 13:45:52');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('10', 'PV-007', 'RAMIREZ CANALES ACRILICOS', NULL, '1', '43', '2018-05-23 11:05:38', '2018-08-20 09:49:55');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('11', 'PV-008', 'REFRIGERACIÓN SOLIS', NULL, '1', '1', '2018-05-23 18:21:49', '2018-05-30 10:32:29');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('12', 'PV-009', 'ARTEPLASTIC_Anunicios', NULL, '1', '43', '2018-05-29 14:25:49', '2018-08-17 09:30:36');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('13', 'PV-010', 'Refrigeración Hernández', NULL, '1', '1', '2018-05-30 10:29:05', '2018-05-30 10:30:50');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('14', 'PV-011', 'Grupo Pretorian S.A. de C.V.', NULL, '1', '1', '2018-06-27 17:48:47', '2018-08-03 12:21:30');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('15', 'Pv-012', 'Ricaasa', NULL, '1', '44', '2018-07-18 10:44:55', '2018-11-16 10:22:41');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('17', 'PV-14', 'Pruebas 2', NULL, '1', '1', '2018-10-30 20:27:30', '2018-10-30 20:33:33');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('18', 'PV-015', 'Mantenimiento García de Quevedo', NULL, '1', '43', '2018-11-06 14:01:59', '2018-11-15 12:20:11');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('19', 'EM-002', 'MARISA SISTEMAS', NULL, '1', '0', '2018-02-19 15:24:24', '2018-02-19 15:24:24');
INSERT INTO `Empresas` (`Id_Empresa`, `Codigo`, `Razon_Social`, `Logo`, `Status`, `Usuario_Registra`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('22', 'PV-017', 'Diseño Marisa', NULL, '1', '43', '2018-12-17 12:01:50', '2018-12-17 14:50:32');


#
# TABLE STRUCTURE FOR: Evidencia_Fotos
#

DROP TABLE IF EXISTS `Evidencia_Fotos`;

CREATE TABLE `Evidencia_Fotos` (
  `Id_Evidencia_Foto` int(11) NOT NULL AUTO_INCREMENT,
  `Id_Ticket` int(11) NOT NULL,
  `Tipo` tinyint(4) NOT NULL,
  `Ruta_Imagen` varchar(50) NOT NULL,
  `Fecha_Alta` datetime NOT NULL,
  `Fecha_Actualiza` datetime NOT NULL,
  PRIMARY KEY (`Id_Evidencia_Foto`)
) ENGINE=MyISAM AUTO_INCREMENT=5370 DEFAULT CHARSET=latin1;

INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1', '10', '1', '6d5371b61bf536f8da785f5b46e25a7c.jpg', '2018-05-21 11:12:20', '2018-05-21 11:12:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2', '10', '2', 'cdd4e084d97f725fecdb83b27e774d08.jpg', '2018-05-21 11:12:44', '2018-05-21 11:12:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3', '10', '3', '806747b4492f86caab89ffbf90a02c38.jpg', '2018-05-21 11:13:26', '2018-05-21 11:13:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('4', '9', '1', '830b324ab250c6d5e5107c81db012c76.jpg', '2018-05-21 11:33:23', '2018-05-21 11:33:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('5', '9', '2', 'aad9430f35ebce22158b0dd09321e0de.jpg', '2018-05-21 11:33:40', '2018-05-21 11:33:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('6', '9', '3', '16736d73bfc5aded7e97968fd2ba99b8.jpg', '2018-05-21 11:34:13', '2018-05-21 11:34:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('7', '26', '1', '25d2abca9cc35164dead6aa8c19a1d7e.jpg', '2018-05-21 11:57:44', '2018-05-21 11:57:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('8', '26', '2', '6ccccacde90ddca674a9fa4b77b9d03d.jpg', '2018-05-21 11:57:58', '2018-05-21 11:57:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('9', '26', '3', '3ec6163c7a1ad87767bdacacb0e6c974.jpg', '2018-05-21 11:58:53', '2018-05-21 11:58:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('10', '31', '1', '3056db8dc2ff3dfaccc04e37f113a728.jpg', '2018-05-21 12:59:22', '2018-05-21 12:59:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('11', '31', '2', 'c17a8c99de4f4567f7009c04a0612849.jpg', '2018-05-21 12:59:37', '2018-05-21 12:59:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('12', '31', '3', 'd647352d2d20a6e60eb07bcffaf2bb3a.jpg', '2018-05-21 12:59:56', '2018-05-21 12:59:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('13', '34', '1', 'ff707ceceae5c81f21b5b10684450c6b.jpg', '2018-05-21 13:00:55', '2018-05-21 13:00:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('14', '34', '2', 'e2079d0d370951d01d0546fdcc2135b4.jpg', '2018-05-21 13:01:07', '2018-05-21 13:01:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('15', '34', '3', '7f3f08454e0cbac5ac68117d1024d17f.jpg', '2018-05-21 13:01:31', '2018-05-21 13:01:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('16', '58', '1', '9de916777322c0efc5b1f395b589ba7a.jpg', '2018-05-21 13:10:46', '2018-05-21 13:10:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('17', '58', '2', '5cda7ae8c04a840bf865482061656b89.jpg', '2018-05-21 13:11:04', '2018-05-21 13:11:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('18', '58', '3', 'f73807563809c15994b02b87b85e5619.jpg', '2018-05-21 13:12:01', '2018-05-21 13:12:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('19', '66', '1', '06698dc5b7b17472d22121be11535e6f.jpg', '2018-05-22 21:20:08', '2018-05-22 21:20:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('20', '66', '2', '7032ca765870640d37f790efc1aa49a1.jpg', '2018-05-22 21:20:26', '2018-05-22 21:20:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('21', '66', '3', 'db8b35f86e97f82e1384b5f93e67be6f.jpg', '2018-05-22 21:21:09', '2018-05-22 21:21:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('22', '2', '1', '5a92fbf8efae1facfb8eaacbf5479513.jpg', '2018-05-23 09:46:14', '2018-05-23 09:46:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('23', '2', '2', 'b5a9ff997924e58e085c77857cf9611f.jpg', '2018-05-23 09:46:42', '2018-05-23 09:46:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('24', '2', '3', '8c0b15e91e18dff8d73d12d25d7522b6.jpg', '2018-05-23 09:47:19', '2018-05-23 09:47:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('25', '3', '1', 'd70a8af1314259ecab773e188539bbbb.jpg', '2018-05-23 09:48:34', '2018-05-23 09:48:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('26', '3', '2', 'b300ab9b665913b7a254fc1c172f9627.jpg', '2018-05-23 09:48:48', '2018-05-23 09:48:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('27', '3', '3', 'a96d27203971b4e7f2804197a57ff0f8.jpg', '2018-05-23 09:49:12', '2018-05-23 09:49:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('28', '22', '1', '728e1a2dbb9ba332f79266002e1692fc.jpg', '2018-05-23 10:35:34', '2018-05-23 10:35:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('29', '22', '2', 'bee403973a5231d9fdd26e72ac98bdb8.jpg', '2018-05-23 10:35:45', '2018-05-23 10:35:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('30', '22', '3', '829933116dfe345e7e667e740c30b5f5.jpg', '2018-05-23 10:36:12', '2018-05-23 10:36:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('31', '23', '1', 'c8fd9c2568b3f97492e810c2c8bd82f5.jpg', '2018-05-23 10:37:18', '2018-05-23 10:37:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('32', '23', '2', '35ee1e393cfcf502eb00445ded447eab.jpg', '2018-05-23 10:37:33', '2018-05-23 10:37:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('33', '23', '3', 'db00d0addcbcbdb22a0a28d08338d0ed.jpg', '2018-05-23 10:38:01', '2018-05-23 10:38:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('34', '50', '1', '0c0e2f9c4836d2da290b34c6e9a0bfc7.jpg', '2018-05-23 10:39:53', '2018-05-23 10:39:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('35', '50', '2', 'f2ad5d8b4df0d721e676d9e796ad983c.jpg', '2018-05-23 10:40:04', '2018-05-23 10:40:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('36', '50', '3', '8d892351eb34da33212bb03ba32359fc.jpg', '2018-05-23 10:40:28', '2018-05-23 10:40:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('37', '14', '1', '69f1f255689e3f47b9affce31167d895.jpg', '2018-05-23 10:44:45', '2018-05-23 10:44:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('38', '14', '2', '1ee6f6a4c0bb7b1611b973f50c009540.jpg', '2018-05-23 10:44:58', '2018-05-23 10:44:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('39', '14', '3', '89e4034067d0970cb5e93420a1dacb74.jpg', '2018-05-23 10:45:36', '2018-05-23 10:45:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('40', '6', '1', '547ae4711607a6e72558447102ed791b.jpg', '2018-05-23 10:51:09', '2018-05-23 10:51:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('41', '6', '2', '5c6a28e3153ee8e0ac78c0ce8b52d048.jpg', '2018-05-23 10:51:22', '2018-05-23 10:51:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('42', '6', '3', '7cda1d0cfab6ff3ac088a4c81ca57c47.jpg', '2018-05-23 10:51:49', '2018-05-23 10:51:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('43', '4', '1', '207fcb63156c1b546279f4ef04831347.jpg', '2018-05-23 10:53:20', '2018-05-23 10:53:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('44', '4', '2', 'eeb0784a0037e0ed6f10eff44f950960.jpg', '2018-05-23 10:54:02', '2018-05-23 10:54:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('45', '4', '3', '183a46b9ea6e953b0436b5a70d247447.jpg', '2018-05-23 10:55:13', '2018-05-23 10:55:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('46', '20', '1', '9a13fa4809e99787783b58af9622b139.jpg', '2018-05-23 11:12:53', '2018-05-23 11:12:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('47', '20', '2', '57b0b19baefe3bb3026a2129c8a8ef87.jpg', '2018-05-23 11:13:07', '2018-05-23 11:13:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('48', '20', '3', '78911328c238b0198e8ce414998ba70e.jpg', '2018-05-23 11:13:48', '2018-05-23 11:13:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('49', '33', '1', '04d26f129bcf2ae1d7be0c715004db00.jpg', '2018-05-23 11:15:13', '2018-05-23 11:15:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('50', '33', '2', '5150933d8d0af4a031f5155911afb6aa.jpg', '2018-05-23 11:15:26', '2018-05-23 11:15:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('51', '33', '3', '0af8ef1ac6d97e107077877de737ca15.jpg', '2018-05-23 11:15:47', '2018-05-23 11:15:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('52', '16', '1', '2b5f70d3b921444b6e21e9320e7323f3.jpg', '2018-05-23 11:17:16', '2018-05-23 11:17:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('53', '16', '2', '6cf44adc1586d48951e9886748994848.jpg', '2018-05-23 11:17:35', '2018-05-23 11:17:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('54', '16', '3', '1f5326ac86cf95f2578e19bb1aa15c0b.jpg', '2018-05-23 11:18:56', '2018-05-23 11:18:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('55', '12', '1', 'f09adcfb5b74bc7a1e8f129f6b7cc856.jpg', '2018-05-23 12:04:03', '2018-05-23 12:04:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('56', '12', '2', 'dfc20afe82aad9b0601314218884ef36.jpg', '2018-05-23 12:04:12', '2018-05-23 12:04:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('57', '12', '3', 'b0d943210e230886607b8fd583fd2ba2.jpg', '2018-05-23 12:04:47', '2018-05-23 12:04:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('58', '19', '1', '7be907c129e3bc5059a9e34819b9b0f6.jpg', '2018-05-23 12:06:26', '2018-05-23 12:06:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('59', '19', '2', '880f6ae2816b7d97f8acc8f5f6960165.jpg', '2018-05-23 12:06:34', '2018-05-23 12:06:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('60', '19', '3', '83ec514b7da07c20653818d1120e17bf.jpg', '2018-05-23 12:07:05', '2018-05-23 12:07:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('61', '19', '3', '81d7450ca5e706c26c4e73267d513d2c.jpg', '2018-05-23 12:07:05', '2018-05-23 12:07:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('62', '8', '1', 'e0efddde95849c22e0a3b0bfa175e410.jpg', '2018-05-23 12:16:12', '2018-05-23 12:16:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('63', '8', '2', 'e2a8e5a782049ff0b9ad927451f23620.jpg', '2018-05-23 12:16:25', '2018-05-23 12:16:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('64', '8', '3', 'b05ea9fc853620280469d439cf3aeb29.jpg', '2018-05-23 12:16:49', '2018-05-23 12:16:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('65', '71', '1', '91145b9719f09280c0bc8fecc61ce4dc.jpg', '2018-05-23 17:57:21', '2018-05-23 17:57:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('66', '71', '2', '0f06756e371bd04fa01e010e34d257ff.jpg', '2018-05-23 18:01:21', '2018-05-23 18:01:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('67', '71', '3', '197b185ce9f5e6c351d4cc051530db6a.jpg', '2018-05-23 18:04:24', '2018-05-23 18:04:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('68', '39', '1', '45c681aa88a046111e506c14791525db.jpg', '2018-05-24 12:33:25', '2018-05-24 12:33:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('69', '39', '2', 'bc15f167771df927745fd5042f4f741f.jpg', '2018-05-24 12:33:39', '2018-05-24 12:33:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('70', '39', '3', '07f1d2c90a722365c1c4a09868d50e6e.jpg', '2018-05-24 12:34:39', '2018-05-24 12:34:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('71', '40', '1', '3815736bc33e5e7da051568ac85acb03.jpg', '2018-05-24 12:37:07', '2018-05-24 12:37:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('72', '40', '2', 'a87a3f1dfccdc5a956554b71f1d2d991.jpg', '2018-05-24 12:37:37', '2018-05-24 12:37:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('73', '40', '3', 'ee104e44e081d3e385d012a4cab3691a.jpg', '2018-05-24 12:38:23', '2018-05-24 12:38:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('74', '42', '1', 'ed42b3efef88dcc80d0c80a5b21cb0c1.jpg', '2018-05-24 12:41:41', '2018-05-24 12:41:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('75', '42', '2', '9dc2973f06dd21050d75072c4b21895a.jpg', '2018-05-24 12:44:48', '2018-05-24 12:44:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('76', '42', '3', 'fbf298cc7c6027c54ae027a0f73aec78.jpg', '2018-05-24 12:45:24', '2018-05-24 12:45:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('77', '43', '1', '7b4584ed1e712e82f92417f93cd8a466.jpg', '2018-05-24 13:17:11', '2018-05-24 13:17:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('78', '43', '2', 'cb92cde328f8e0202bf9d569312544e5.jpg', '2018-05-24 13:18:23', '2018-05-24 13:18:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('79', '43', '2', 'd56e23c7b512983f5c5e45379173da33.jpg', '2018-05-24 13:18:23', '2018-05-24 13:18:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('80', '43', '3', '43bd5bf678c0482ea1fa2506f6293979.jpg', '2018-05-24 13:19:33', '2018-05-24 13:19:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('81', '29', '1', 'f0a3cc2fd240d3b8a74a445dddb19d92.jpg', '2018-05-24 13:32:04', '2018-05-24 13:32:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('82', '29', '2', '781a1855eac1491b38c1e21204aaba8f.jpg', '2018-05-24 13:33:39', '2018-05-24 13:33:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('83', '29', '3', '81e04aa0e6cd12733527971e83077a33.jpg', '2018-05-24 13:33:59', '2018-05-24 13:33:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('84', '32', '1', 'fc315070a19038d39d25d231e8a375c0.jpg', '2018-05-24 13:35:50', '2018-05-24 13:35:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('85', '32', '2', '81c22d16ce8882e9a0d343fd22e42014.jpg', '2018-05-24 13:36:02', '2018-05-24 13:36:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('86', '32', '3', '7cb5f93dd8bf5c0905d428b0a708cea2.jpg', '2018-05-24 13:38:13', '2018-05-24 13:38:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('87', '13', '1', '98688e2e0ccadddc8be9887da5ac392b.jpg', '2018-05-24 15:34:44', '2018-05-24 15:34:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('88', '13', '2', 'b330761ca0067c2565702f5673be92bd.jpg', '2018-05-24 15:35:11', '2018-05-24 15:35:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('89', '13', '3', '143586be32c21d723a9ea4cd1b19cc87.jpg', '2018-05-24 15:37:14', '2018-05-24 15:37:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('90', '69', '1', '0eb43350bc50766e2abf04e6d990815e.jpg', '2018-05-24 16:59:15', '2018-05-24 16:59:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('91', '69', '2', '5f01a5f0ed4746d4a0addb3e0b75e23e.jpg', '2018-05-24 16:59:27', '2018-05-24 16:59:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('92', '69', '3', '22d3176e1496c03f0ca35f21926bec42.jpg', '2018-05-24 17:01:13', '2018-05-24 17:01:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('93', '5', '1', 'b3f8659dd27d069fe2d2f0146d6068f7.jpg', '2018-05-25 12:08:37', '2018-05-25 12:08:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('94', '5', '2', 'a52959a00008717c9fcc8b818a57f93c.jpg', '2018-05-25 12:09:51', '2018-05-25 12:09:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('95', '5', '3', '013a89e71e49a2d98c76f77f9ce778b2.jpg', '2018-05-25 12:10:43', '2018-05-25 12:10:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('96', '7', '1', '159abd27a9b0f43ef788037e66e03715.jpg', '2018-05-25 12:16:14', '2018-05-25 12:16:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('97', '7', '2', '90b3eae87cd35f0695cb98bb9f1f4a9c.jpg', '2018-05-25 12:17:29', '2018-05-25 12:17:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('98', '7', '3', 'f989aa1695d3de782bbccb0931f830b3.jpg', '2018-05-25 12:18:20', '2018-05-25 12:18:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('99', '61', '1', '08594c410c22f4df7d5f1ff07a053583.jpg', '2018-05-25 12:28:37', '2018-05-25 12:28:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('100', '61', '2', '7f35a6078091a42e8d8ea6be4180387a.jpg', '2018-05-25 12:28:54', '2018-05-25 12:28:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('101', '61', '3', 'f74d73cc6c63ede73370bf7394f803ad.jpg', '2018-05-25 12:29:15', '2018-05-25 12:29:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('102', '72', '1', '5448793538eae6eded9d74480f89f4da.jpg', '2018-05-25 12:32:23', '2018-05-25 12:32:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('103', '72', '2', '16ac86d9674dc3f143e0e6283d8d5fcd.jpg', '2018-05-25 12:34:55', '2018-05-25 12:34:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('104', '72', '2', 'e3d290439284f304bdaafbb5ba6d8bd4.jpg', '2018-05-25 12:34:55', '2018-05-25 12:34:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('105', '72', '2', '056b8d69ce376348d0ed1214f438eeda.jpg', '2018-05-25 12:34:55', '2018-05-25 12:34:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('106', '72', '3', '9faeb26457d6d05aed19f93f0d6ab035.jpg', '2018-05-25 12:36:01', '2018-05-25 12:36:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('107', '15', '1', '8adc7966310868656a7f2a532570bc06.jpg', '2018-05-25 12:40:15', '2018-05-25 12:40:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('108', '15', '2', 'bdc1e02e6d3d4141fe5aba90e6ba0544.jpg', '2018-05-25 12:40:40', '2018-05-25 12:40:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('109', '15', '3', 'e9aa8c3e1aa31a61c139d8681f03f707.jpg', '2018-05-25 12:41:05', '2018-05-25 12:41:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('110', '48', '1', '651d5454461e620a406c3f249b219eea.jpg', '2018-05-26 11:15:43', '2018-05-26 11:15:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('111', '48', '2', 'df7f9a8ceebf73df178c6d6d8a29087e.jpg', '2018-05-26 11:16:22', '2018-05-26 11:16:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('112', '48', '3', '63a9a4d901a4ae82c46400306e59f959.jpg', '2018-05-26 11:16:52', '2018-05-26 11:16:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('113', '18', '1', 'd5ceb9d52e9dd88f0cd4b7d8c44082e6.jpg', '2018-05-26 11:23:19', '2018-05-26 11:23:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('114', '18', '2', '6eb46e0c81a876924137d03176aca1dc.jpg', '2018-05-26 11:24:00', '2018-05-26 11:24:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('115', '18', '3', '4fc001d1ede4dd78d6e9e98ab4064512.jpg', '2018-05-26 11:24:28', '2018-05-26 11:24:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('116', '54', '1', '4c390f1a9d69c59fb4388c8320219703.jpg', '2018-05-26 11:30:20', '2018-05-26 11:30:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('117', '54', '2', 'f824fd9231da0a17cb069aef0cdd0920.jpg', '2018-05-26 11:30:32', '2018-05-26 11:30:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('118', '54', '3', '7ed826742aebd181d4fccaf15e42902a.jpg', '2018-05-26 11:31:04', '2018-05-26 11:31:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('119', '59', '1', '4649d025c0c6e44a639eda3083f92391.jpg', '2018-05-26 11:32:27', '2018-05-26 11:32:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('120', '59', '2', '5c5f4cd520debb61431799cbd3536fd6.jpg', '2018-05-26 11:32:37', '2018-05-26 11:32:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('121', '59', '3', '3db52003db3213dd8f9999bb479d7f3a.jpg', '2018-05-26 11:33:01', '2018-05-26 11:33:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('122', '49', '1', '1e6054ee63df89a693027c31b0a5f1fc.jpg', '2018-05-26 11:36:03', '2018-05-26 11:36:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('123', '49', '1', '71321ddffd6ba823564da70b8c206ffd.jpg', '2018-05-26 11:36:03', '2018-05-26 11:36:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('124', '49', '1', 'd6c1d620be0f29c598a03d3cd2f7b5f4.jpg', '2018-05-26 11:36:03', '2018-05-26 11:36:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('125', '49', '2', '388a915ab8d3cac6d31adf32cb2464bc.jpg', '2018-05-26 11:37:17', '2018-05-26 11:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('126', '49', '2', '03e9706aa947dd3ea09144c5f1078307.jpg', '2018-05-26 11:37:17', '2018-05-26 11:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('127', '49', '2', '5eec82b41e808959b96bcd95e1df26e4.jpg', '2018-05-26 11:37:17', '2018-05-26 11:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('128', '49', '3', 'f5600f2dd054397ab8188e3e43d288d9.jpg', '2018-05-26 11:38:15', '2018-05-26 11:38:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('129', '82', '1', '755bc6a6fd8697f910f136f69d9cff8c.jpg', '2018-05-28 12:56:57', '2018-05-28 12:56:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('130', '60', '1', 'a9a8e098a9ad5da2c8aacaeec29d0ad3.jpg', '2018-05-28 12:58:13', '2018-05-28 12:58:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('131', '60', '2', 'b265ab7b379e15358476d217eabb5551.jpg', '2018-05-28 12:58:35', '2018-05-28 12:58:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('132', '60', '3', '307e5ac1c0e4573ee27bbfe41823ded8.jpg', '2018-05-28 12:59:19', '2018-05-28 12:59:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('133', '82', '2', '06500d044d277ca1ffb7014c38ca1741.jpg', '2018-05-28 13:07:21', '2018-05-28 13:07:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('134', '82', '2', 'ff4fefcd667f74ba23d2961cba56b70a.jpg', '2018-05-28 13:07:21', '2018-05-28 13:07:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('135', '82', '2', 'a7c697e1fd2f2d1c88d086edaad601da.jpg', '2018-05-28 13:07:21', '2018-05-28 13:07:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('136', '82', '3', '2da0a7140c0e0c3e131cedf2ac3c8e90.jpg', '2018-05-28 13:57:15', '2018-05-28 13:57:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('137', '41', '1', 'ed493c855c9b51fef67dbddb432b0509.jpg', '2018-05-28 22:34:50', '2018-05-28 22:34:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('138', '41', '2', 'e51fe0f8d7a2b8ceb9531d5bec15d0a9.jpg', '2018-05-28 22:36:24', '2018-05-28 22:36:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('139', '41', '3', '4b0471397c081f0ada8cba363b5a66e7.jpg', '2018-05-28 22:37:35', '2018-05-28 22:37:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('140', '17', '1', '336f7da9219bdf59bd9c174309b36297.jpg', '2018-05-28 22:46:31', '2018-05-28 22:46:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('141', '17', '2', '3ff2a329731b0e65d16bde05a5ba0028.jpg', '2018-05-28 22:47:01', '2018-05-28 22:47:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('142', '17', '3', 'ff5be230cf1ab2a60ad0ee96d063ed68.jpg', '2018-05-28 22:47:50', '2018-05-28 22:47:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('143', '62', '1', 'ddc44f526e6c477796f0716f1b02aec2.jpg', '2018-05-28 22:50:21', '2018-05-28 22:50:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('144', '62', '2', '888fc52c51fac42344b8eba863441f07.jpg', '2018-05-28 22:50:55', '2018-05-28 22:50:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('145', '62', '3', 'ab60e1cd4727d9f473b8911b89152612.jpg', '2018-05-28 22:51:30', '2018-05-28 22:51:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('146', '126', '1', 'c89ac31735251be47dd150b986ef8351.jpg', '2018-05-29 01:21:19', '2018-05-29 01:21:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('147', '126', '2', 'fe3993b766f59526d2b227ee1499cef7.jpg', '2018-05-29 01:21:31', '2018-05-29 01:21:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('148', '126', '3', '29a7c340f852206a97cc85215b233707.jpg', '2018-05-29 01:21:49', '2018-05-29 01:21:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('149', '56', '1', 'e8855fd1a3927b7faf2b986bad93e6a8.jpg', '2018-05-29 10:28:43', '2018-05-29 10:28:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('150', '56', '2', '2ca6f69ce3e92341b3006d24812ee6d7.jpg', '2018-05-29 10:28:58', '2018-05-29 10:28:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('151', '56', '3', '18b7bf9e2aa256bc10b9e49605b2b6a2.jpg', '2018-05-29 10:29:23', '2018-05-29 10:29:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('152', '24', '1', 'bb4af3afcf30224331b4ce80f39f0bfa.jpg', '2018-05-29 10:32:43', '2018-05-29 10:32:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('153', '24', '2', '5b28358cc6408c486d753cc39efd0c77.jpg', '2018-05-29 10:33:53', '2018-05-29 10:33:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('154', '24', '2', '9ecca09aa22aaec72ab7e73d55c548dc.jpg', '2018-05-29 10:33:53', '2018-05-29 10:33:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('155', '24', '2', '96dc51f56b96f413f8e1838407635aba.jpg', '2018-05-29 10:33:53', '2018-05-29 10:33:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('156', '24', '3', '8deb6e896b5b3db8c29a313bcfbf6d67.jpg', '2018-05-29 10:34:21', '2018-05-29 10:34:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('157', '74', '1', 'e9a9aea846c15fa0d2bd7ce7ccb40877.jpg', '2018-05-29 12:37:30', '2018-05-29 12:37:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('158', '74', '2', '41f90f1f793d861ba575d377c71d5065.jpg', '2018-05-29 12:37:58', '2018-05-29 12:37:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('159', '74', '3', 'c2fd5691fd58e1352ce91ce6e82733d3.jpg', '2018-05-29 12:40:10', '2018-05-29 12:40:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('160', '75', '1', '651db2c3a721dc55516bf56b1341dca7.jpg', '2018-05-29 12:44:45', '2018-05-29 12:44:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('161', '75', '2', 'bdb0691e76a2ce8e77f011633d2f1a85.jpg', '2018-05-29 12:45:01', '2018-05-29 12:45:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('162', '75', '3', 'f61c4a6943905fea51969b50c8be6acf.jpg', '2018-05-29 12:45:43', '2018-05-29 12:45:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('163', '76', '1', 'd91c02e2d0f5a4e32038ef62b2342aae.jpg', '2018-05-29 12:51:10', '2018-05-29 12:51:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('164', '76', '2', 'f9a412554fb5300e0aef9f0a063c1544.jpg', '2018-05-29 12:51:19', '2018-05-29 12:51:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('165', '76', '3', 'cc4ca344a3c7b3507b20b89460529966.jpg', '2018-05-29 12:51:49', '2018-05-29 12:51:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('166', '81', '1', 'b2d4b3679a378d29a7661d3180dea6f3.jpg', '2018-05-29 13:21:14', '2018-05-29 13:21:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('167', '81', '1', '70f06b63a67d3d306e29a0406629c1e2.jpg', '2018-05-29 13:21:14', '2018-05-29 13:21:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('168', '81', '1', '2d9eae20614e13f673e9ac66460156ce.jpg', '2018-05-29 13:21:14', '2018-05-29 13:21:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('169', '81', '1', '983c82bba59824193698515c8a427e60.jpg', '2018-05-29 13:21:14', '2018-05-29 13:21:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('170', '81', '2', 'f1844b1c31d8f599eed083d786930214.jpg', '2018-05-29 16:24:58', '2018-05-29 16:24:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('171', '81', '2', '9ddf3faf47062b9673a5200f91865687.jpg', '2018-05-29 16:24:58', '2018-05-29 16:24:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('172', '81', '2', '6843fbb9cac6dbf7567f0bf19a499299.jpg', '2018-05-29 16:24:58', '2018-05-29 16:24:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('173', '81', '2', '3eea40619ebe0f46709e715bf40ea818.jpg', '2018-05-29 16:24:58', '2018-05-29 16:24:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('174', '81', '2', '3f58677e310b6cebb25408e04ad97601.jpg', '2018-05-29 16:24:58', '2018-05-29 16:24:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('175', '81', '2', '90dda8265bff6293be7608c8f9358a90.jpg', '2018-05-29 16:24:58', '2018-05-29 16:24:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('176', '81', '3', '6b971d078c02965ac623e7a208c97cfc.jpg', '2018-05-29 16:39:19', '2018-05-29 16:39:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('177', '35', '1', '82e2d91e4fc6ec16da65dae5ec10aaf4.jpg', '2018-05-29 18:08:23', '2018-05-29 18:08:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('178', '35', '2', 'c1dcac7a6e999b2e158809384cd082aa.jpg', '2018-05-29 18:09:06', '2018-05-29 18:09:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('179', '35', '3', '7c26c7941063415a5058ad19bdc095ed.jpg', '2018-05-29 18:09:37', '2018-05-29 18:09:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('180', '36', '1', 'efb484fba99477fb9d6c4479f982bbd6.jpg', '2018-05-29 18:10:19', '2018-05-29 18:10:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('181', '36', '2', 'dd80c47ae9894c9fd29f81bdb53cf9e2.jpg', '2018-05-29 18:10:34', '2018-05-29 18:10:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('182', '36', '3', '799f0372640b13e4d2994621bd68dec9.jpg', '2018-05-29 18:10:57', '2018-05-29 18:10:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('183', '37', '1', '4d994b06277ba67f2119e91c8fc6a256.jpg', '2018-05-29 18:11:59', '2018-05-29 18:11:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('184', '37', '2', '81cb900345679702d0534213f5211208.jpg', '2018-05-29 18:12:18', '2018-05-29 18:12:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('185', '37', '3', 'a8aa16048ac93c4e539d554832696515.jpg', '2018-05-29 18:12:46', '2018-05-29 18:12:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('186', '44', '1', '7fc4a9f0f6a2844f89baeecea8fddd1c.jpg', '2018-05-29 18:15:42', '2018-05-29 18:15:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('187', '44', '2', '750d098b358bd4cfeb19cd4ee053a5dd.jpg', '2018-05-29 18:18:47', '2018-05-29 18:18:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('188', '44', '3', 'bb6a73909f28722b41f81fd4c34816d6.jpg', '2018-05-29 18:19:41', '2018-05-29 18:19:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('189', '46', '1', '115dab0914826b1e2d3f498afa88c948.jpg', '2018-05-29 18:21:39', '2018-05-29 18:21:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('190', '46', '2', '422267f1104f5788147fd991e3e52173.jpg', '2018-05-29 18:22:05', '2018-05-29 18:22:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('191', '46', '3', '8a101ef16592a74d4fdd582b876c1d40.jpg', '2018-05-29 18:22:26', '2018-05-29 18:22:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('192', '30', '1', 'a49ab69079e4abbbce0d3d3ffd79f2ce.jpg', '2018-05-29 18:23:35', '2018-05-29 18:23:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('193', '30', '2', '7d61ef6e52cbf174dc83543a756f3cb9.jpg', '2018-05-29 18:24:01', '2018-05-29 18:24:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('194', '30', '3', '9c012fb9ba001575d574e04788b8d531.jpg', '2018-05-29 18:24:20', '2018-05-29 18:24:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('195', '137', '1', 'd7fa06050ad4a42e63509562be6bcee5.jpg', '2018-05-30 10:06:17', '2018-05-30 10:06:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('196', '137', '1', 'f4e2623f053dca28175dfec4ff0f6ee0.jpg', '2018-05-30 10:06:17', '2018-05-30 10:06:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('197', '137', '2', '52f3050834652e21fb61d66d7d05c102.jpg', '2018-05-30 10:12:12', '2018-05-30 10:12:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('198', '137', '2', '86d5005b1748005ccae43ed2b3b48539.jpg', '2018-05-30 10:12:12', '2018-05-30 10:12:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('199', '137', '2', '02ac2194c0b660dadcac3145db3b01cd.jpg', '2018-05-30 10:12:12', '2018-05-30 10:12:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('200', '137', '3', 'c5300f65d0d3fbd87adc6d1d0e4ef05c.jpg', '2018-05-30 10:30:16', '2018-05-30 10:30:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('201', '193', '1', 'a16faf3424d6dd5980b33ef1cd2fa1fb.jpg', '2018-05-30 13:37:19', '2018-05-30 13:37:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('202', '193', '1', 'd344a7ac9faae4db8e172c21d51529e9.jpg', '2018-05-30 13:37:19', '2018-05-30 13:37:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('203', '193', '1', 'a02d6cd73be7d198c488762ac2291cf0.jpg', '2018-05-30 13:37:20', '2018-05-30 13:37:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('204', '193', '1', 'c3330ed6161b2c4d2a856b094a2b8b53.jpg', '2018-05-30 13:37:20', '2018-05-30 13:37:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('205', '193', '1', 'add5f2e0324cc569e69f1cf1cddc5c89.jpg', '2018-05-30 13:37:24', '2018-05-30 13:37:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('206', '193', '1', '84d105b1dfa4cc3067fd985c51cb63ac.jpg', '2018-05-30 13:37:24', '2018-05-30 13:37:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('207', '193', '2', '61f88a20b3b2c77c3f24647e6737ab8a.jpg', '2018-05-30 13:38:28', '2018-05-30 13:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('208', '193', '2', '4d7d47e345eaae04b97205042ea79441.jpg', '2018-05-30 13:38:28', '2018-05-30 13:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('209', '193', '3', '87c524cd772927cd75336f3710ae50d6.jpg', '2018-05-30 13:39:21', '2018-05-30 13:39:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('210', '191', '1', '092c4727cf0e8ec40e5cb80bf21e59d1.jpg', '2018-05-30 13:42:08', '2018-05-30 13:42:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('211', '191', '1', '83be6cbfd0d97d2f778a48b83a8b199c.jpg', '2018-05-30 13:42:08', '2018-05-30 13:42:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('212', '191', '2', '6c67687fe85c68347e49e53f81462c3c.jpg', '2018-05-30 14:19:31', '2018-05-30 14:19:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('213', '191', '2', 'b282856a659cc233b2a33e203382629e.jpg', '2018-05-30 14:19:31', '2018-05-30 14:19:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('214', '191', '2', '0dd54b7bd7a70a8a5b66d8b87c25c808.jpg', '2018-05-30 14:19:31', '2018-05-30 14:19:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('215', '191', '2', 'ae4d4f0447f26e15f88a5a8f183adca6.jpg', '2018-05-30 14:19:31', '2018-05-30 14:19:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('216', '191', '2', 'ee68711bfac0cc38f076094e71a629cd.jpg', '2018-05-30 14:19:31', '2018-05-30 14:19:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('217', '191', '3', '84c332a25124da4bda723008b769799f.jpg', '2018-05-30 14:50:37', '2018-05-30 14:50:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('218', '197', '1', '8736157de798bdc664a92c3ae3ee8416.jpg', '2018-05-31 10:39:40', '2018-05-31 10:39:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('219', '197', '1', '8e4c343e7b3ab3b5b56e5497c785a930.jpg', '2018-05-31 10:39:40', '2018-05-31 10:39:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('220', '197', '2', '93ece48c84da21533d1f7a9fe729ded9.jpg', '2018-05-31 10:40:52', '2018-05-31 10:40:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('221', '197', '2', '07e977691ba2541bfec88406ae1aa424.jpg', '2018-05-31 10:40:52', '2018-05-31 10:40:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('222', '197', '2', '9a77ee6c750b2760335332f328a94072.jpg', '2018-05-31 10:40:52', '2018-05-31 10:40:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('223', '197', '3', 'd621635e85a1099be4004247aec7c7ab.jpg', '2018-05-31 11:00:59', '2018-05-31 11:00:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('224', '200', '1', 'c0ad4b8385e59d9e6f5d0271c21d8b31.jpg', '2018-05-31 11:18:12', '2018-05-31 11:18:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('225', '200', '2', 'd6afd38a744fd34e7b08447b3d19f986.jpg', '2018-05-31 11:21:53', '2018-05-31 11:21:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('226', '200', '3', '5e2d360f2ae917b41e58da9aa79081c4.jpg', '2018-05-31 11:23:21', '2018-05-31 11:23:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('227', '90', '1', '2b8811f5c09dc0b4cf2a8591b468ac59.jpg', '2018-05-31 11:39:57', '2018-05-31 11:39:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('228', '90', '1', '7cdba197256c897fee16b88a9c944c60.jpg', '2018-05-31 11:39:57', '2018-05-31 11:39:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('229', '90', '2', '8d232164a2bb0518ab1985d44c92b056.jpg', '2018-05-31 11:45:33', '2018-05-31 11:45:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('230', '90', '2', '803c9a1071c7ca81a713527c91615b5a.jpg', '2018-05-31 11:45:33', '2018-05-31 11:45:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('231', '127', '1', 'f4e89e537efa7193aa5b093306d17a64.jpg', '2018-05-31 12:22:40', '2018-05-31 12:22:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('232', '127', '1', '5f84de620c71cdfb527fb3372c864dc1.jpg', '2018-05-31 12:22:40', '2018-05-31 12:22:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('233', '127', '1', 'dd5672e9bc97e2cbb94896b661caa350.jpg', '2018-05-31 12:22:40', '2018-05-31 12:22:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('234', '127', '2', '3dd4562138bbc4d360de7f48dd39879e.jpg', '2018-05-31 12:24:52', '2018-05-31 12:24:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('235', '127', '2', '4e77e578cc6538ab6d63c81e4462ef2d.jpg', '2018-05-31 12:24:52', '2018-05-31 12:24:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('236', '127', '2', '54d7a181ddc60e90012120d9b8a4380e.jpg', '2018-05-31 12:24:52', '2018-05-31 12:24:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('237', '127', '3', 'f2286391f6b9b0cd3750c7eb069865d2.jpg', '2018-05-31 12:42:26', '2018-05-31 12:42:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('238', '132', '1', 'ae57a544f42c7cd04016f6dd171bdf44.jpg', '2018-06-01 10:24:31', '2018-06-01 10:24:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('239', '132', '1', '6c4f5e020624d7652a6d72ffd81698b6.jpg', '2018-06-01 10:24:31', '2018-06-01 10:24:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('240', '132', '2', 'e33b609bc69a1dd4321d640b0d1afcfe.jpg', '2018-06-01 10:28:51', '2018-06-01 10:28:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('241', '132', '2', '460f4baaf663edda64e3e2ec154b6a7d.jpg', '2018-06-01 10:28:51', '2018-06-01 10:28:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('242', '132', '2', 'f3beabd221b4f81b77a28a7a6694031e.jpg', '2018-06-01 10:28:51', '2018-06-01 10:28:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('243', '132', '3', 'a432d02de73d5b95a3c3c5e487857e5e.jpg', '2018-06-01 10:34:04', '2018-06-01 10:34:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('244', '55', '1', '12638d64caa2e756c0ebf329d4cbb479.jpg', '2018-06-01 12:53:32', '2018-06-01 12:53:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('245', '86', '1', '5efde2acb8e40a1be4ed88ca69b5fa61.jpg', '2018-06-04 10:43:38', '2018-06-04 10:43:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('246', '86', '1', '8073d4b8984701e511ad6656d30c55d0.jpg', '2018-06-04 10:43:38', '2018-06-04 10:43:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('247', '86', '2', '26d86c968275cb949d19a404d6da90be.jpg', '2018-06-04 10:48:19', '2018-06-04 10:48:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('248', '86', '2', 'c7f2ecc5de98e65f5f64e54cac8ce810.jpg', '2018-06-04 10:48:19', '2018-06-04 10:48:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('249', '86', '2', 'eba7a1dd5c02858ed6eb15eeaf7db134.jpg', '2018-06-04 10:48:19', '2018-06-04 10:48:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('250', '86', '2', '4dde9307a277025d1026400f106eef9e.jpg', '2018-06-04 10:48:19', '2018-06-04 10:48:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('251', '86', '3', '1c8a5b7aa7b7f680e47a7e89384959bf.jpg', '2018-06-04 10:58:41', '2018-06-04 10:58:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('252', '109', '1', '0c138d11a8bf4ce395abc6236ceeaa19.jpg', '2018-06-04 11:00:14', '2018-06-04 11:00:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('253', '109', '2', '7b4091e3fdf2283de0696f25b0608e07.jpg', '2018-06-04 11:00:33', '2018-06-04 11:00:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('254', '109', '3', '34b2d33aac7c434d6ff98cdeb57624ae.jpg', '2018-06-04 11:01:23', '2018-06-04 11:01:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('255', '212', '1', 'f40b9eda9ebd69a1f7d84c1c69f3c7ef.jpg', '2018-06-04 11:46:33', '2018-06-04 11:46:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('256', '212', '1', '6b6073a3fc5b3b5da1f804ce2370715f.jpg', '2018-06-04 11:46:33', '2018-06-04 11:46:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('257', '87', '1', 'dba23d86505672415421f514f56e480d.jpg', '2018-06-04 12:49:10', '2018-06-04 12:49:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('258', '87', '1', '48b7bc620556558cb801f7ed8b8d3cc3.jpg', '2018-06-04 12:49:10', '2018-06-04 12:49:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('259', '87', '2', '98ba26c29e632b70effc0048cb0dcd7c.jpg', '2018-06-04 12:49:45', '2018-06-04 12:49:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('260', '87', '3', '146bc9ee851cbce0973c3aabeb56973b.jpg', '2018-06-04 12:52:48', '2018-06-04 12:52:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('261', '212', '2', 'e70f2b4ce98723cc9b15ccd47bf68d51.jpg', '2018-06-04 13:18:26', '2018-06-04 13:18:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('262', '212', '2', '606cdd02dfc9b0efd31fad3abd6b238b.jpg', '2018-06-04 13:18:26', '2018-06-04 13:18:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('263', '212', '2', 'bbce1d9d2e330407f306b850c299e17a.jpg', '2018-06-04 13:18:26', '2018-06-04 13:18:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('264', '212', '3', 'e93aba592384f9e10f3d8f34e0635000.jpg', '2018-06-04 13:19:11', '2018-06-04 13:19:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('265', '217', '1', 'e561cb02e793fd22942b02f2f2ab0f5c.jpg', '2018-06-04 14:15:32', '2018-06-04 14:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('266', '217', '1', '1ec344171292d7e93f0a2799f508b6ec.jpg', '2018-06-04 14:15:32', '2018-06-04 14:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('267', '217', '1', '25cfb3c6148646031cd69704bdfe6de7.jpg', '2018-06-04 14:15:32', '2018-06-04 14:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('268', '217', '1', '6a7ec7b3f30c024ccec66e53f5069a4d.jpg', '2018-06-04 14:15:32', '2018-06-04 14:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('269', '217', '2', '613471c5b18e0b4906c2253a85335757.jpg', '2018-06-04 14:16:53', '2018-06-04 14:16:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('270', '217', '2', '1a989ad11ecaf99e34cdbb9309d82afa.jpg', '2018-06-04 14:16:53', '2018-06-04 14:16:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('271', '217', '2', '267c7eaef7b6af76b46897517cf55b35.jpg', '2018-06-04 14:16:53', '2018-06-04 14:16:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('272', '217', '2', '302c61d80f71a9a6a477d206d0b29eb5.jpg', '2018-06-04 14:16:53', '2018-06-04 14:16:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('273', '217', '3', 'dd224c889616774df0b1e570e32e1308.jpg', '2018-06-04 14:27:52', '2018-06-04 14:27:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('274', '112', '1', 'd497b80b6bba3401233fb167c80462ea.jpg', '2018-06-04 14:52:51', '2018-06-04 14:52:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('275', '112', '2', '50d3270354096362850b0825238c3c67.jpg', '2018-06-04 14:53:00', '2018-06-04 14:53:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('276', '112', '3', 'ed2c5623e7c2c6b4b141ac3f389bfb2b.jpg', '2018-06-04 14:53:38', '2018-06-04 14:53:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('277', '227', '1', '28c4ad93a00174e346027e9162dbdb95.jpg', '2018-06-05 10:02:45', '2018-06-05 10:02:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('278', '227', '1', '623d5f12e569b0de56c0b825a13f1795.jpg', '2018-06-05 10:02:45', '2018-06-05 10:02:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('279', '227', '2', 'd5a3591e409e7b96f9277148f992bf13.jpg', '2018-06-05 10:03:35', '2018-06-05 10:03:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('280', '227', '2', '0295774e210c9f07ec8dd17d28b36262.jpg', '2018-06-05 10:03:35', '2018-06-05 10:03:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('281', '227', '2', 'd202aca6473e2a5c46f34d6dc0a12f60.jpg', '2018-06-05 10:03:35', '2018-06-05 10:03:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('282', '227', '2', '66a04f6ff5029d40ec2c69b8ee43543e.jpg', '2018-06-05 10:03:35', '2018-06-05 10:03:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('283', '227', '3', 'd41ccda5b2e20f2ef7fbea9425fa07e7.jpg', '2018-06-05 10:08:43', '2018-06-05 10:08:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('284', '198', '1', '9352211bed5cf674afd86bc3bac78878.jpg', '2018-06-05 12:21:40', '2018-06-05 12:21:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('285', '198', '2', '4757c45e1a97b682b7c5167cd798976b.jpg', '2018-06-05 12:21:55', '2018-06-05 12:21:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('286', '198', '2', 'fb7e5d9440764b6edf6c6bc79a49585e.jpg', '2018-06-05 12:21:55', '2018-06-05 12:21:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('287', '198', '3', 'daf3ff20c387ee9e5efd156f37ef1358.jpg', '2018-06-05 12:24:26', '2018-06-05 12:24:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('288', '228', '1', '998f870be8d6019c543e5cb528649b19.jpg', '2018-06-05 14:38:34', '2018-06-05 14:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('289', '228', '1', 'f03d4982decbdc1aa13cfde9591eea32.jpg', '2018-06-05 14:38:34', '2018-06-05 14:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('290', '228', '1', 'efc435097465cb12d21e405780c3abe2.jpg', '2018-06-05 14:38:34', '2018-06-05 14:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('291', '228', '1', '6c6da5045bde2ff51111290aef33e3e3.jpg', '2018-06-05 14:38:34', '2018-06-05 14:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('292', '228', '2', 'd03b5644eabec812643b7fb1af261583.jpg', '2018-06-05 14:39:45', '2018-06-05 14:39:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('293', '228', '3', '8971ef769b3aa48aa08b08fee8c4956b.jpg', '2018-06-05 14:40:12', '2018-06-05 14:40:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('294', '70', '1', 'b017a02975b027977ef2466638415c4f.jpg', '2018-06-05 15:57:28', '2018-06-05 15:57:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('295', '176', '1', 'd5ddafe94ede2f7d554462c4cfbebe5c.jpg', '2018-06-07 14:01:04', '2018-06-07 14:01:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('296', '176', '2', 'ecd0322635f611ea64747a7f56170c8a.jpg', '2018-06-07 14:01:25', '2018-06-07 14:01:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('297', '176', '3', '8848cd0c3cf0d19256196cef3688b55f.jpg', '2018-06-07 14:02:13', '2018-06-07 14:02:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('298', '177', '1', 'c7adda6e0a179c85a42625acae0f4398.jpg', '2018-06-07 14:03:41', '2018-06-07 14:03:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('299', '177', '1', '70d7219fb1e6e6562ee9b48828873296.jpg', '2018-06-07 14:03:41', '2018-06-07 14:03:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('300', '177', '1', 'f71a56800caf6563b017e847b245de45.jpg', '2018-06-07 14:03:41', '2018-06-07 14:03:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('301', '177', '1', '4c678ca237dbf7696e53634bc157d238.jpg', '2018-06-07 14:03:41', '2018-06-07 14:03:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('302', '177', '1', '7a3e4606398e188a45eff17b57f0e626.jpg', '2018-06-07 14:03:41', '2018-06-07 14:03:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('303', '177', '2', '32c7eea4056a5437780ac969a15fa5f2.jpg', '2018-06-07 14:04:04', '2018-06-07 14:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('304', '177', '2', '9ac747b25341ceefc3518b32c2194747.jpg', '2018-06-07 14:04:04', '2018-06-07 14:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('305', '177', '3', 'f5227146d1c493b499be92e5202ca007.jpg', '2018-06-07 14:04:35', '2018-06-07 14:04:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('306', '178', '1', '848e0db724d9482a03863d2cb377cf0f.jpg', '2018-06-07 15:22:10', '2018-06-07 15:22:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('307', '178', '1', '4b83b596993234cd42bf7903d897b702.jpg', '2018-06-07 15:22:10', '2018-06-07 15:22:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('308', '178', '2', '64a2a4c3e495e851896d78b75ef5d996.jpg', '2018-06-07 15:22:29', '2018-06-07 15:22:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('309', '178', '2', '386d67913c8d3c4c7d2aa6e9d65fc44a.jpg', '2018-06-07 15:22:29', '2018-06-07 15:22:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('310', '178', '3', 'f2d8fc6e514ce7112a2fcc5fc06d0c0d.jpg', '2018-06-07 15:22:52', '2018-06-07 15:22:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('311', '190', '1', '9b9496e093567a06513382e10d554c57.jpg', '2018-06-08 10:02:06', '2018-06-08 10:02:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('312', '190', '2', 'ef5d2e000c79f6b15e9bc5c7caacbf61.jpg', '2018-06-08 10:03:23', '2018-06-08 10:03:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('313', '190', '3', '2acb5a2ffbd1efb3d36ec9e68d174a31.jpg', '2018-06-08 10:07:07', '2018-06-08 10:07:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('314', '245', '1', '128aa72e028813f4765aeace609bb7b2.jpg', '2018-06-08 11:09:20', '2018-06-08 11:09:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('315', '245', '2', '2e1c46e23f8a1372783a7e810fc9abe8.jpg', '2018-06-08 11:09:38', '2018-06-08 11:09:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('316', '245', '2', '38902def74a8132761dc9022ec932041.jpg', '2018-06-08 11:09:38', '2018-06-08 11:09:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('317', '245', '2', 'c534fe518620a4775e782eb18f2a9cf2.jpg', '2018-06-08 11:09:38', '2018-06-08 11:09:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('318', '245', '3', 'ad81df72963f58ccd46b2a421b57fcfb.jpg', '2018-06-08 11:11:24', '2018-06-08 11:11:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('319', '70', '2', '24f0f453b7e9fc153d0f878faf869e28.jpg', '2018-06-08 12:18:01', '2018-06-08 12:18:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('320', '70', '3', '1bfab8582901a7e73bcc7a60af90380e.jpg', '2018-06-08 12:19:32', '2018-06-08 12:19:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('321', '175', '1', '8ec8fb51b14e39034f4bd8d168942201.jpg', '2018-06-08 13:53:43', '2018-06-08 13:53:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('322', '175', '1', '326a3cb58fb3e17b4796ee36e19d394d.jpg', '2018-06-08 13:53:43', '2018-06-08 13:53:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('323', '175', '2', 'f0b20fb9d8a32293b32cd9684cedb6a9.jpg', '2018-06-08 13:53:58', '2018-06-08 13:53:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('324', '175', '2', '5d1db9a9b23af1583117923c6c7a88ec.jpg', '2018-06-08 13:53:58', '2018-06-08 13:53:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('325', '175', '3', '92c0e41a592c4181827296bc4f9c25e0.jpg', '2018-06-08 13:54:43', '2018-06-08 13:54:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('326', '115', '1', 'd699670a5953c271edf988a08fd96757.jpg', '2018-06-08 13:55:47', '2018-06-08 13:55:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('327', '115', '1', 'd34ed05ab2eeaae354d1d63d676ae7c2.jpg', '2018-06-08 13:55:47', '2018-06-08 13:55:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('328', '115', '2', '8650fb5eda390a4e35b3a226719dfefd.jpg', '2018-06-08 13:55:54', '2018-06-08 13:55:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('329', '115', '3', '8c273da7de2b542b23f019190d4ede0e.jpg', '2018-06-08 13:59:55', '2018-06-08 13:59:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('330', '250', '1', '32ea6372f5fc412a73de742eb82d5a94.jpg', '2018-06-11 11:15:06', '2018-06-11 11:15:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('331', '250', '2', 'a33f18d2d7e7e603d1427c01cf5b2e21.jpg', '2018-06-11 11:15:32', '2018-06-11 11:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('332', '250', '2', 'a2888a2b5ed839c447bd73be1d4e17e2.jpg', '2018-06-11 11:15:32', '2018-06-11 11:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('333', '250', '2', '15916f560086abca5c886a1c3b655112.jpg', '2018-06-11 11:15:32', '2018-06-11 11:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('334', '251', '1', 'fee24510e3087a48e7b36238b59b3cf1.jpg', '2018-06-11 11:17:15', '2018-06-11 11:17:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('335', '251', '2', 'c19e0a30a8da58a8549288a768aa1671.jpg', '2018-06-11 11:17:41', '2018-06-11 11:17:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('336', '251', '2', '14ac5e00a6dec9e359e29b3657c3f3dc.jpg', '2018-06-11 11:17:41', '2018-06-11 11:17:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('337', '251', '2', '9f9ca2fd0307a5646c8776f20f2e0b0e.jpg', '2018-06-11 11:17:41', '2018-06-11 11:17:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('338', '251', '3', '286d4ae7c507b8a38417e686edee32e5.jpg', '2018-06-11 11:22:24', '2018-06-11 11:22:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('339', '250', '3', 'aa65e7d6d54057708c7d9a32e706535b.jpg', '2018-06-11 11:22:59', '2018-06-11 11:22:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('340', '252', '1', 'cca6c31bf49dbdb1b906ee1968313891.jpg', '2018-06-11 11:57:25', '2018-06-11 11:57:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('341', '252', '2', '2eeb1721c3244357d624160c1a028b8f.jpg', '2018-06-11 11:57:54', '2018-06-11 11:57:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('342', '252', '2', 'e7b198de17c9fb3177f5b08bb11a2820.jpg', '2018-06-11 11:57:54', '2018-06-11 11:57:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('343', '252', '2', '8c5b70ef7b21d00f51298bf235be173f.jpg', '2018-06-11 11:57:54', '2018-06-11 11:57:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('344', '252', '3', '5125391ef6fda9f08d0bf1321c08c99a.jpg', '2018-06-11 12:01:03', '2018-06-11 12:01:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('345', '68', '1', '6c246a71c2e34074e26faee1219d3b1a.jpg', '2018-06-11 13:36:40', '2018-06-11 13:36:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('346', '68', '2', 'b4f92d36196bc935a5d44f705caae244.jpg', '2018-06-11 13:37:04', '2018-06-11 13:37:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('347', '68', '3', '3e6b015eb89b0b8bdcb1b4c295a7e222.jpg', '2018-06-11 13:37:57', '2018-06-11 13:37:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('348', '106', '1', 'c38be46bb6f14428da9512532666c2a5.jpg', '2018-06-12 12:34:04', '2018-06-12 12:34:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('349', '106', '1', '2361c8ff8fe817d69d6649e4a29149da.jpg', '2018-06-12 12:34:04', '2018-06-12 12:34:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('350', '106', '1', '19c531595b30bf74bff7beef296b8971.jpg', '2018-06-12 12:34:04', '2018-06-12 12:34:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('351', '106', '1', 'e7dc5926e3e7a1d41337b9571c1eb769.jpg', '2018-06-12 12:34:04', '2018-06-12 12:34:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('352', '106', '1', 'e3457f267e8afb75f2a2a786a6d6e054.jpg', '2018-06-12 12:34:04', '2018-06-12 12:34:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('353', '106', '1', '8d43ec35c68c391f56b285a9ca1af7ac.jpg', '2018-06-12 12:34:04', '2018-06-12 12:34:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('354', '106', '2', '8b6de72f0677b3201b0ea8b77a5db2df.jpg', '2018-06-12 12:35:07', '2018-06-12 12:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('355', '106', '2', '48cd633861a5206076a42bfd0f1def1c.jpg', '2018-06-12 12:35:07', '2018-06-12 12:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('356', '106', '2', 'af7cbf9e67093734fa48c7c4090e4814.jpg', '2018-06-12 12:35:07', '2018-06-12 12:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('357', '106', '2', 'fc8752de6dd259a757d758597b44eb9f.jpg', '2018-06-12 12:35:07', '2018-06-12 12:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('358', '106', '2', '587bd83b220da8f18e48c5fd151408af.jpg', '2018-06-12 12:35:07', '2018-06-12 12:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('359', '106', '3', '6d6b5bffe90efa37969f68650074347d.jpg', '2018-06-12 12:36:38', '2018-06-12 12:36:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('360', '272', '1', '6a386fe61406336d0709826e2e29d5bc.jpg', '2018-06-12 14:35:31', '2018-06-12 14:35:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('361', '272', '2', '17aafa6f9d73cd78d10b112a3f0221c0.jpg', '2018-06-12 14:36:07', '2018-06-12 14:36:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('362', '272', '2', 'ca342c8f340269fe075352804ae4166d.jpg', '2018-06-12 14:36:07', '2018-06-12 14:36:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('363', '272', '2', 'a3c50dc8ec54896212c4610abb8d3796.jpg', '2018-06-12 14:36:07', '2018-06-12 14:36:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('364', '272', '2', 'a1a1268ae13737d2d106b84a820e3603.jpg', '2018-06-12 14:36:07', '2018-06-12 14:36:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('365', '272', '2', 'ae1ad7159186b176422ba938ff60a330.jpg', '2018-06-12 14:36:07', '2018-06-12 14:36:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('366', '272', '3', '37dc51e5fbf7c9daed7bc492cc9cf51c.jpg', '2018-06-12 14:36:57', '2018-06-12 14:36:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('367', '138', '1', 'edbcf5817a5e365e29446d14f7e5fdce.jpg', '2018-06-12 16:36:26', '2018-06-12 16:36:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('368', '138', '2', 'd0dd7e2ef091f2069d31a387859db0a9.jpg', '2018-06-12 16:36:50', '2018-06-12 16:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('369', '138', '2', 'aac99c21442e49c4557c602c2ff7d9ec.jpg', '2018-06-12 16:36:50', '2018-06-12 16:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('370', '138', '3', 'fce17458ad8b9cd6aade8b6ae4f964c5.jpg', '2018-06-12 16:38:52', '2018-06-12 16:38:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('371', '240', '1', 'da6d66f702e92dc71117fd8ca615767c.jpg', '2018-06-12 21:29:36', '2018-06-12 21:29:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('372', '240', '2', 'ab8a19ae0ecca88018490a7f880a8913.jpg', '2018-06-12 21:32:15', '2018-06-12 21:32:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('373', '240', '3', 'fba4448bac0825b566f39834b3cd50b8.jpg', '2018-06-12 21:32:45', '2018-06-12 21:32:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('374', '113', '1', 'a51bdf4d1a4691dc43e7825c13f63fd7.jpg', '2018-06-12 21:33:57', '2018-06-12 21:33:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('375', '113', '2', '372e3b2faf98a4956dc3e59ab1ef7828.jpg', '2018-06-12 21:34:07', '2018-06-12 21:34:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('376', '113', '3', 'c0f66fc1e87f92dfec0df35b3f274f50.jpg', '2018-06-12 21:34:29', '2018-06-12 21:34:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('377', '139', '1', '163a50ea72ad8600e51ccf62368c0b86.jpg', '2018-06-13 10:16:57', '2018-06-13 10:16:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('378', '139', '1', 'efc6138f506861684084a3ae588265a9.jpg', '2018-06-13 10:16:57', '2018-06-13 10:16:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('379', '139', '2', 'b8cebb77dcfa430dce66a2160771b358.jpg', '2018-06-13 10:17:33', '2018-06-13 10:17:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('380', '139', '3', 'afeabf9323b8d86f4480d22d3aa3ed02.jpg', '2018-06-13 10:25:44', '2018-06-13 10:25:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('381', '140', '1', 'ddae862892cc5e14cae2b5bba6ed4bbc.jpg', '2018-06-13 10:44:39', '2018-06-13 10:44:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('382', '140', '1', '51f4b7fc8cc07c2e6901d9d93b51af4e.jpg', '2018-06-13 10:44:39', '2018-06-13 10:44:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('383', '140', '2', '452faa94780891718e7d5af2ae1ead87.jpg', '2018-06-13 10:45:39', '2018-06-13 10:45:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('384', '140', '3', 'a4fa89ca7437303e3e1f542c53093149.jpg', '2018-06-13 10:51:51', '2018-06-13 10:51:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('385', '121', '1', 'ee3da768c45960380ca15d78533d65a2.jpg', '2018-06-13 11:15:05', '2018-06-13 11:15:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('386', '121', '2', '59e638b7431fbd7d06c80c083c2b1708.jpg', '2018-06-13 11:15:28', '2018-06-13 11:15:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('387', '121', '3', '8692243fcd9de2af759b3c821ef50c53.jpg', '2018-06-13 11:20:52', '2018-06-13 11:20:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('388', '247', '1', 'f7fdc5c473497a6d502ff65d96e01e17.jpg', '2018-06-13 17:14:20', '2018-06-13 17:14:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('389', '247', '2', 'e7c932b35a7730b4e1b42047863f144b.jpg', '2018-06-13 17:15:02', '2018-06-13 17:15:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('390', '247', '2', '2193515313a699133aae9f7bf1ba33b0.jpg', '2018-06-13 17:15:02', '2018-06-13 17:15:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('391', '247', '2', 'cee374305e804991ab6e7b915f99752d.jpg', '2018-06-13 17:15:02', '2018-06-13 17:15:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('392', '283', '1', '1efd62b6dffb115f6dbcb7251e7d811d.jpg', '2018-06-13 17:17:24', '2018-06-13 17:17:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('393', '283', '2', 'e7c5ebfec16fbae93c9ccbf07359d96e.jpg', '2018-06-13 17:18:08', '2018-06-13 17:18:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('394', '283', '2', '2ebd70e1e6812790c0b79c987220389e.jpg', '2018-06-13 17:18:08', '2018-06-13 17:18:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('395', '283', '2', '69c80e808efe731ca0feced7e90cd408.jpg', '2018-06-13 17:18:08', '2018-06-13 17:18:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('396', '283', '2', '6bc832c942c50e30451ee5dcd9677f3f.jpg', '2018-06-13 17:18:08', '2018-06-13 17:18:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('397', '237', '1', 'f38b7d23c5a604cc2c1d1f002339d235.jpg', '2018-06-13 17:22:53', '2018-06-13 17:22:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('398', '237', '2', '058e628f14ae2991948a9d8c50032bee.jpg', '2018-06-13 17:23:16', '2018-06-13 17:23:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('399', '237', '2', 'ef6d81c9b068c5281a59d5dbe6030ff9.jpg', '2018-06-13 17:23:16', '2018-06-13 17:23:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('400', '237', '2', '9eb3aec8d662ed71e12edded568c2020.jpg', '2018-06-13 17:23:16', '2018-06-13 17:23:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('401', '237', '3', '97d478fe5d0957cba2b2ce295b5f25e9.jpg', '2018-06-13 17:26:29', '2018-06-13 17:26:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('402', '247', '3', '93606004da2609910da90ce442c1f1b0.jpg', '2018-06-13 17:27:06', '2018-06-13 17:27:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('403', '283', '3', '93ebcc36a29cc52924ace16b37db296a.jpg', '2018-06-13 17:28:00', '2018-06-13 17:28:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('404', '116', '1', '8ce0a627c38c44381a631a904153f4ec.jpg', '2018-06-14 10:54:25', '2018-06-14 10:54:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('405', '116', '2', '0c2ec541cc56d52df2cc8fa0d9e6cf04.jpg', '2018-06-14 10:54:45', '2018-06-14 10:54:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('406', '116', '3', '8112a2e811849831a540c314c9089e72.jpg', '2018-06-14 11:00:11', '2018-06-14 11:00:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('407', '143', '1', 'a35fb94277d1e12109e8f8c01c886c7d.jpg', '2018-06-14 11:17:35', '2018-06-14 11:17:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('408', '143', '1', '06d66df65a62bbba1aff9c502e2e39af.jpg', '2018-06-14 11:17:35', '2018-06-14 11:17:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('409', '143', '1', 'e70ac9f3d0706078a9211eea38587fa7.jpg', '2018-06-14 11:17:35', '2018-06-14 11:17:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('410', '143', '1', 'c86e2595bb63397905a9de866a7442b3.jpg', '2018-06-14 11:17:35', '2018-06-14 11:17:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('411', '143', '2', 'be054f04513af0dbeeafff4b8e009f69.jpg', '2018-06-14 11:17:56', '2018-06-14 11:17:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('412', '143', '2', 'ac8ceae635086e0bf5b3721c27a168e7.jpg', '2018-06-14 11:17:56', '2018-06-14 11:17:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('413', '143', '3', 'd175a84e58c1fb41e671f708b9b8e48c.jpg', '2018-06-14 11:20:15', '2018-06-14 11:20:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('414', '142', '1', '2ba02008512aa3d0293f6fdff13d62a7.jpg', '2018-06-14 11:36:50', '2018-06-14 11:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('415', '142', '1', '05a16a4dc09b51c71a39b33ca41189eb.jpg', '2018-06-14 11:36:50', '2018-06-14 11:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('416', '142', '1', 'efeeb8aff23df8ed52a125b4c93273d8.jpg', '2018-06-14 11:36:50', '2018-06-14 11:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('417', '142', '1', '3f6d1b1387bee7544a9943addff91613.jpg', '2018-06-14 11:36:50', '2018-06-14 11:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('418', '142', '1', '20ad8ed1eacfbfd3f63841e5c4446fe9.jpg', '2018-06-14 11:36:50', '2018-06-14 11:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('419', '142', '1', '67c55def3ae973c3e6b493fca006cfa0.jpg', '2018-06-14 11:36:50', '2018-06-14 11:36:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('420', '142', '2', '2e2a02bae9184dd8215195fccd8c08af.jpg', '2018-06-14 11:37:57', '2018-06-14 11:37:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('421', '142', '2', '287b4d7a06469d8c16a6889f60702dfd.jpg', '2018-06-14 11:37:57', '2018-06-14 11:37:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('422', '142', '2', 'd4ac9246d7be49314c594e072095bfce.jpg', '2018-06-14 11:37:57', '2018-06-14 11:37:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('423', '142', '3', '14ef2eff59c3fb26bb3a9b52d5b83b3a.jpg', '2018-06-14 11:39:17', '2018-06-14 11:39:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('424', '208', '1', '79aec5a8201dfcb9b80a810f90e6b89e.jpg', '2018-06-15 12:40:43', '2018-06-15 12:40:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('425', '208', '2', 'e1a4c5d71f137321149f5dcdb4309ff5.jpg', '2018-06-15 12:43:22', '2018-06-15 12:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('426', '208', '2', 'a1803b8afced439090c30743e51f9765.jpg', '2018-06-15 12:43:22', '2018-06-15 12:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('427', '208', '2', 'e10fd7a619c4542f73fbbd057bafa9ed.jpg', '2018-06-15 12:43:22', '2018-06-15 12:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('428', '208', '2', 'c3d0a56cd1ba4f304fc624b3fb4645e7.jpg', '2018-06-15 12:43:22', '2018-06-15 12:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('429', '208', '3', '02efb1de415ede666487c6880064134b.jpg', '2018-06-15 12:48:39', '2018-06-15 12:48:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('430', '55', '2', '825f21ba47500807a9c45a94f619e5db.jpg', '2018-06-15 14:38:59', '2018-06-15 14:38:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('431', '55', '3', '6886aaed79c4efb15ff765c255e262fc.jpg', '2018-06-15 14:40:22', '2018-06-15 14:40:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('432', '255', '1', '75c1b382eeced28adc0ea32a79633207.jpg', '2018-06-15 17:34:17', '2018-06-15 17:34:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('433', '255', '1', '7043287ee4ba9855469892dcd170824b.jpg', '2018-06-15 17:34:17', '2018-06-15 17:34:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('434', '255', '1', '7ace2b4e35f0f1dbb9306b36f1b982f3.jpg', '2018-06-15 17:34:17', '2018-06-15 17:34:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('435', '255', '1', 'b2363ce905b7d780068bcd8a6d07a511.jpg', '2018-06-15 17:34:17', '2018-06-15 17:34:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('436', '255', '1', 'b462244546eb916c052e2d985624bfcd.jpg', '2018-06-15 17:34:17', '2018-06-15 17:34:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('437', '255', '1', 'e1013e4823f6bdd6f0c6185b166c4121.jpg', '2018-06-15 17:34:17', '2018-06-15 17:34:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('438', '255', '2', '167fba14e978146ca69b0100aa5439cf.jpg', '2018-06-15 17:35:01', '2018-06-15 17:35:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('439', '255', '2', 'b24e760396456102ba929a24b64d5258.jpg', '2018-06-15 17:35:01', '2018-06-15 17:35:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('440', '255', '2', 'b2422d0941a19689b3b68ebf1a519007.jpg', '2018-06-15 17:35:02', '2018-06-15 17:35:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('441', '255', '3', '7c02d424ca2ad7eb5cf8471e71bd7f27.jpg', '2018-06-15 17:38:09', '2018-06-15 17:38:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('442', '206', '1', '343710c9867979ea18dcc159301c336d.jpg', '2018-06-15 17:54:24', '2018-06-15 17:54:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('443', '206', '2', '3222292d0b31b3f3bf7ee13cb0186eaf.jpg', '2018-06-15 17:55:09', '2018-06-15 17:55:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('444', '206', '3', '857d23fa20b5668ca29bf7250e0e94c6.jpg', '2018-06-15 17:56:38', '2018-06-15 17:56:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('445', '114', '1', '0701cee7c1100fb2bd30e4c324d7e42d.jpg', '2018-06-18 11:16:25', '2018-06-18 11:16:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('446', '114', '2', '9c77f53940aa39bc1a4a42738fe79094.jpg', '2018-06-18 11:16:43', '2018-06-18 11:16:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('447', '114', '3', '8fd45a39ae9689509736542eb4071390.jpg', '2018-06-18 11:17:23', '2018-06-18 11:17:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('448', '218', '1', '2f3bacccc526f816d0a564973e6fb519.jpg', '2018-06-18 11:29:41', '2018-06-18 11:29:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('449', '218', '2', '2db8c4c5462c46f32c625ec6ae1c214a.jpg', '2018-06-18 11:29:54', '2018-06-18 11:29:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('450', '218', '3', '475cf0161775e405985ef5cbadbf65c8.jpg', '2018-06-18 11:30:21', '2018-06-18 11:30:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('451', '269', '1', '866632dd9cf2b8a7a77abe31eeb72c9c.jpg', '2018-06-18 11:31:23', '2018-06-18 11:31:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('452', '269', '2', '860d706ca3e8f81584ffce49b378a408.jpg', '2018-06-18 11:31:50', '2018-06-18 11:31:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('453', '269', '3', '75309be4b60e39a304e25cebcc0b3f35.jpg', '2018-06-18 11:32:44', '2018-06-18 11:32:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('454', '181', '1', 'ac6d576662bb05d4123968e73c0a2eab.jpg', '2018-06-18 11:37:10', '2018-06-18 11:37:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('455', '181', '2', '88486016c569178a1a6f40a15093432c.jpg', '2018-06-18 11:37:24', '2018-06-18 11:37:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('456', '181', '3', '54c3b5304084a84e85f7ea4e01e2e711.jpg', '2018-06-18 11:37:52', '2018-06-18 11:37:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('457', '185', '1', 'b25b09222289fdaada254672f46f4b40.jpg', '2018-06-18 11:41:31', '2018-06-18 11:41:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('458', '185', '2', '39d7cfc257c3cab0a5b92e99a2a9a2c5.jpg', '2018-06-18 11:41:48', '2018-06-18 11:41:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('459', '185', '3', 'b2ee203204da900ecd591f6dce274f3b.jpg', '2018-06-18 11:42:14', '2018-06-18 11:42:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('460', '226', '1', 'd662fca2931eb1dd77ad6bc965343ea1.jpg', '2018-06-18 12:25:49', '2018-06-18 12:25:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('461', '226', '2', 'b7cce89cce5a87357df896f2ee0017dc.jpg', '2018-06-18 12:26:07', '2018-06-18 12:26:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('462', '226', '3', '0022ad48bf7e8ff4856734bd0ce80989.jpg', '2018-06-18 12:26:30', '2018-06-18 12:26:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('463', '205', '1', '9a8482f099ffcc8db5d338d7f6f72b31.jpg', '2018-06-18 12:30:47', '2018-06-18 12:30:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('464', '205', '2', 'b4780f820d4caed9539e11e541f65ce3.jpg', '2018-06-18 12:31:02', '2018-06-18 12:31:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('465', '205', '3', '7e1ed2563e12eaacc1a4577a9b8ad13b.jpg', '2018-06-18 12:31:26', '2018-06-18 12:31:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('466', '125', '1', '3a7e1953007b99c8835be5f4030d1833.jpg', '2018-06-18 12:34:03', '2018-06-18 12:34:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('467', '125', '2', '10c83a3a48373b536526872c3beab119.jpg', '2018-06-18 12:34:15', '2018-06-18 12:34:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('468', '125', '3', '7bf67acc1e3a0e72eb2df21308f16897.jpg', '2018-06-18 12:34:33', '2018-06-18 12:34:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('469', '108', '1', 'd28f587329ae2108fef17f0a11f43792.jpg', '2018-06-18 12:37:06', '2018-06-18 12:37:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('470', '108', '2', '7267ca8d406d9680e5dabcd826e160cb.jpg', '2018-06-18 12:37:17', '2018-06-18 12:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('471', '108', '3', 'ea29c6f9cc2bef39e6104c398346d1af.jpg', '2018-06-18 12:37:37', '2018-06-18 12:37:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('472', '124', '1', 'b9778a84a22f73d2c30ddbd2655ad6ff.jpg', '2018-06-18 12:41:07', '2018-06-18 12:41:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('473', '124', '2', '7aabb78c7f50100b533aac6902e067a6.jpg', '2018-06-18 12:41:21', '2018-06-18 12:41:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('474', '124', '3', '4744a4d8d764b22670928851be64ae00.jpg', '2018-06-18 12:41:40', '2018-06-18 12:41:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('475', '51', '1', 'c3a90747b5ed86d845454d3c8fb0faa4.jpg', '2018-06-18 12:44:44', '2018-06-18 12:44:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('476', '51', '1', '382a5cbf07484b8014a816db7a85dca2.jpg', '2018-06-18 12:44:44', '2018-06-18 12:44:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('477', '51', '2', '30840270b4a9cef861de42e8c6384f94.jpg', '2018-06-18 12:44:54', '2018-06-18 12:44:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('478', '51', '3', 'def68c5aafadab7129bff5cb9392e8b0.jpg', '2018-06-18 12:45:40', '2018-06-18 12:45:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('479', '63', '1', 'eebdd1f50f1a2e13d1f09d9a58b9e390.jpg', '2018-06-18 13:20:24', '2018-06-18 13:20:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('480', '63', '2', '303e388534142e321ad787683e4bac5e.jpg', '2018-06-18 13:20:38', '2018-06-18 13:20:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('481', '63', '3', '5c3771b1a33cbbf617bb5ab0499a1c3d.jpg', '2018-06-18 13:21:04', '2018-06-18 13:21:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('482', '246', '1', '8d93b3f91f023cd04962ea62155810fa.jpg', '2018-06-18 13:23:17', '2018-06-18 13:23:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('483', '246', '2', '59b0849bed4f401c8c3b9126539a86b7.jpg', '2018-06-18 13:23:41', '2018-06-18 13:23:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('484', '246', '3', '623e5ec86a17e566f20563862ed66592.jpg', '2018-06-18 13:24:13', '2018-06-18 13:24:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('485', '194', '1', '7066fa4df1f9385ac88e04051f5750db.jpg', '2018-06-18 13:29:07', '2018-06-18 13:29:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('486', '194', '2', '3fd266ad1640cbe021fc3a9d68c1961f.jpg', '2018-06-18 13:29:21', '2018-06-18 13:29:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('487', '194', '3', 'a82384f3dc58c9afc8dcf62006124ca9.jpg', '2018-06-18 13:29:48', '2018-06-18 13:29:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('488', '89', '1', 'a3c46a2fddb2779605405e902dcc3c75.jpg', '2018-06-18 13:34:49', '2018-06-18 13:34:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('489', '89', '1', '7ee99540a7cc61a007b5faa12b0440ae.jpg', '2018-06-18 13:34:49', '2018-06-18 13:34:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('490', '89', '2', 'db4af4e6d8e564a6f3651971bd0b481b.jpg', '2018-06-18 13:35:03', '2018-06-18 13:35:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('491', '89', '3', '1589292374d32f5afad2523ade540f2e.jpg', '2018-06-18 13:35:24', '2018-06-18 13:35:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('492', '73', '1', 'cd4b6bee83e43fbc17b428ac932b83df.jpg', '2018-06-18 13:38:38', '2018-06-18 13:38:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('493', '73', '2', '9f74b1fdae71e26737902cc99f39f876.jpg', '2018-06-18 13:38:51', '2018-06-18 13:38:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('494', '73', '3', '777449dc188e1d0b839365ee09b743e0.jpg', '2018-06-18 13:39:13', '2018-06-18 13:39:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('495', '201', '1', '53b4c68c0e6c7c095fcef4302ad7d714.jpg', '2018-06-18 13:47:42', '2018-06-18 13:47:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('496', '201', '2', 'abf899b8eb86c972551a969b28bde9ba.jpg', '2018-06-18 13:47:53', '2018-06-18 13:47:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('497', '201', '3', 'b988ecaae19ff9b828d8cf4be605a432.jpg', '2018-06-18 13:48:15', '2018-06-18 13:48:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('498', '202', '1', 'ee247da5e05d8bd1140a1399b5abacc9.jpg', '2018-06-18 13:54:10', '2018-06-18 13:54:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('499', '202', '2', 'ab235c1445865a0b2d1deff32880efd9.jpg', '2018-06-18 13:54:21', '2018-06-18 13:54:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('500', '202', '3', '977842b7bd73686f0d3d3357aba41eca.jpg', '2018-06-18 13:54:39', '2018-06-18 13:54:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('501', '111', '1', 'd8ffc945ba23c1a8bd21171ad57c0c2a.jpg', '2018-06-18 14:00:06', '2018-06-18 14:00:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('502', '111', '2', 'aaa5c6bf1940185f28c04830ac1c6534.jpg', '2018-06-18 14:00:19', '2018-06-18 14:00:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('503', '111', '3', '55a6e5d183dc35e6c446a0f2b5ab4d9c.jpg', '2018-06-18 14:00:46', '2018-06-18 14:00:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('504', '85', '1', '142b436478af980a91f5830bdd151417.jpg', '2018-06-18 14:05:14', '2018-06-18 14:05:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('505', '85', '2', '7531db0f0bfabea7767eab75141c6717.jpg', '2018-06-18 14:05:28', '2018-06-18 14:05:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('506', '85', '3', 'cc6b89d1dcf29e82e2715298892266c6.jpg', '2018-06-18 14:05:44', '2018-06-18 14:05:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('507', '210', '1', '5d189dbae9d97176adb9334b2e542e0a.jpg', '2018-06-18 14:09:08', '2018-06-18 14:09:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('508', '210', '2', '5e5b6fdb8caf5ae1460619cb8793f290.jpg', '2018-06-18 14:09:21', '2018-06-18 14:09:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('509', '210', '3', '01c39bab17bbe204c9f1bacd2bfd924c.jpg', '2018-06-18 14:09:44', '2018-06-18 14:09:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('510', '220', '1', 'db64fbb66d3150926ec0df1ee574ee0e.jpg', '2018-06-18 14:23:55', '2018-06-18 14:23:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('511', '220', '2', '7eae13e2070c70c94edaa6ec3a3e4c1b.jpg', '2018-06-18 14:24:10', '2018-06-18 14:24:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('512', '220', '3', 'd1f91570bf312d5e8a535d187d26e1a5.jpg', '2018-06-18 14:24:37', '2018-06-18 14:24:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('513', '211', '1', 'bfa2608dd636967b850f1f55b43b6454.jpg', '2018-06-18 14:32:19', '2018-06-18 14:32:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('514', '211', '2', 'a6a4cbdef02b66a9260a45dfabe35870.jpg', '2018-06-18 14:32:32', '2018-06-18 14:32:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('515', '211', '3', '2176c5ea5a600b143d5270c22fc7bda7.jpg', '2018-06-18 14:33:00', '2018-06-18 14:33:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('516', '216', '1', 'abdd7a1f4926053db6ccf454313b4249.jpg', '2018-06-18 14:35:05', '2018-06-18 14:35:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('517', '216', '2', 'e0a4c14556ca6df10f2069ce65fefbe3.jpg', '2018-06-18 14:35:17', '2018-06-18 14:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('518', '216', '3', '7571da820c523bcf68b8653df375b920.jpg', '2018-06-18 14:35:39', '2018-06-18 14:35:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('519', '188', '1', 'cfb0725e34d4cd51f4665c16a0aeaeb9.jpg', '2018-06-18 14:42:17', '2018-06-18 14:42:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('520', '188', '2', 'ccfa56efa5103d11509c0857172bcbbe.jpg', '2018-06-18 14:42:32', '2018-06-18 14:42:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('521', '188', '3', '06420f35de3247e88781ed009f5c6092.jpg', '2018-06-18 14:43:10', '2018-06-18 14:43:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('522', '297', '1', '8025a99a5ae659854a5ebb789d7e9f87.jpg', '2018-06-19 11:31:45', '2018-06-19 11:31:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('523', '297', '2', '5c2de2b461fec7cbf1af123273ee90a1.jpg', '2018-06-19 11:32:10', '2018-06-19 11:32:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('524', '297', '3', '8ae6f1e0e1ff4f8c5d7a7d8cd390da7d.jpg', '2018-06-19 11:33:21', '2018-06-19 11:33:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('525', '225', '1', '579385a66c88d358a8c864659307e5fd.jpg', '2018-06-19 11:45:06', '2018-06-19 11:45:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('526', '225', '2', '47a1d514fe6ebd17ecc9655ac1221365.jpg', '2018-06-19 11:45:16', '2018-06-19 11:45:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('527', '225', '3', 'f0d5b7a52c5549291af6b57b846c7a4c.jpg', '2018-06-19 11:45:46', '2018-06-19 11:45:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('528', '238', '1', 'b96fcdc21ca1736b37ffa3a22857d65b.jpg', '2018-06-20 11:57:11', '2018-06-20 11:57:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('529', '238', '1', '86f5e8550e556440a623365256c160b1.jpg', '2018-06-20 11:57:12', '2018-06-20 11:57:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('530', '238', '1', 'aa933bdeb67908821fab21e9d7ab7e80.jpg', '2018-06-20 11:57:12', '2018-06-20 11:57:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('531', '238', '2', '8a5e312da868ff3ac97c729d331c00de.jpg', '2018-06-20 11:57:59', '2018-06-20 11:57:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('532', '238', '2', '8385a045e8afbebb07a1cb5c40f2683e.jpg', '2018-06-20 11:57:59', '2018-06-20 11:57:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('533', '238', '2', 'c0905bb952e5f01d6420b92365e99e4b.jpg', '2018-06-20 11:57:59', '2018-06-20 11:57:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('534', '238', '3', '4091d03a27ab5160de3136c547b967d4.jpg', '2018-06-20 12:00:44', '2018-06-20 12:00:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('535', '141', '1', '6d42fda44a6a1af4ea869fa5306329b8.jpg', '2018-06-21 10:13:13', '2018-06-21 10:13:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('536', '141', '1', 'dd551a11a33b551e90bdcafd7a30090c.jpg', '2018-06-21 10:13:13', '2018-06-21 10:13:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('537', '141', '1', '340157124a28e0c65d5e143a253b5f06.jpg', '2018-06-21 10:13:13', '2018-06-21 10:13:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('538', '141', '2', '25d2465e57ecc70c0e1adea802bdc282.jpg', '2018-06-21 10:13:30', '2018-06-21 10:13:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('539', '141', '2', '783adc8795b37cc1e800b70f108f39fc.jpg', '2018-06-21 10:13:30', '2018-06-21 10:13:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('540', '141', '3', '66c069e48905d9a00ae8005ed90ce727.jpg', '2018-06-21 10:14:21', '2018-06-21 10:14:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('541', '207', '1', '95fc7b8da276101423e09c5c94c4c070.jpg', '2018-06-21 10:39:45', '2018-06-21 10:39:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('542', '207', '2', '7a74ee90833d13649aa6ef16c7811ed8.jpg', '2018-06-21 10:40:07', '2018-06-21 10:40:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('543', '207', '3', '3a1c9d80759b919f0b2868d2d1471056.jpg', '2018-06-21 10:43:16', '2018-06-21 10:43:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('544', '314', '1', '01015cf9469d84a5ca2a0a0268434ab7.jpg', '2018-06-21 17:37:14', '2018-06-21 17:37:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('545', '314', '2', 'fdcbad6afe02c0f0bd203c8bdc99a33d.jpg', '2018-06-21 17:37:54', '2018-06-21 17:37:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('546', '314', '2', '0eb6fb5e8dd81db038ced4bd6f0c7871.jpg', '2018-06-21 17:37:54', '2018-06-21 17:37:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('547', '314', '2', 'a7b37b9931ca2160b4e08d2eb312926b.jpg', '2018-06-21 17:37:54', '2018-06-21 17:37:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('548', '314', '2', 'f4c0758175157c1fd689aefa98142d73.jpg', '2018-06-21 17:37:54', '2018-06-21 17:37:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('549', '314', '3', '56e57fadbd6d0d0da107ff34b883cefe.jpg', '2018-06-21 17:42:32', '2018-06-21 17:42:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('550', '266', '1', '24f64822c7d75b907d2748ae79ce13c4.jpg', '2018-06-22 18:32:18', '2018-06-22 18:32:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('551', '266', '1', '67d25da1c57b263548ba9836efbf006d.jpg', '2018-06-22 18:32:18', '2018-06-22 18:32:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('552', '266', '2', 'faeeb8df5452866565f9a446212eb33a.jpg', '2018-06-22 18:32:40', '2018-06-22 18:32:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('553', '266', '2', '70ca8f75df8e4c410dcb8c0cb6ab94cb.jpg', '2018-06-22 18:32:40', '2018-06-22 18:32:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('554', '266', '3', '023d8a972daa8364b9165be9e9416a4c.jpg', '2018-06-22 18:41:29', '2018-06-22 18:41:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('555', '213', '1', 'c007af4d299bb6727b8ef6ac283e0fba.jpg', '2018-06-22 18:50:50', '2018-06-22 18:50:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('556', '213', '1', '4ad8e17436d19361c84b70d60c8bffd3.jpg', '2018-06-22 18:50:50', '2018-06-22 18:50:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('557', '213', '1', '934f0512fa460524cb652f159cf086e5.jpg', '2018-06-22 18:50:50', '2018-06-22 18:50:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('558', '213', '1', '57be253a1b4c265b954e68993ae3f3cb.jpg', '2018-06-22 18:50:50', '2018-06-22 18:50:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('559', '213', '1', '1da1834ef5ff2fd505ab0f7ba905bfaf.jpg', '2018-06-22 18:50:50', '2018-06-22 18:50:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('560', '213', '2', '3e430140d4e300b3ae0037109fb4bf48.jpg', '2018-06-22 18:51:10', '2018-06-22 18:51:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('561', '213', '2', '97062e91f0c104c80347745dfb5728b4.jpg', '2018-06-22 18:51:10', '2018-06-22 18:51:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('562', '213', '3', 'c7b74224b8e4308612f3aefce743004b.jpg', '2018-06-22 18:52:13', '2018-06-22 18:52:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('563', '289', '1', '611757be852da7b1ae11ad49b8864c44.jpg', '2018-06-25 10:20:49', '2018-06-25 10:20:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('564', '289', '2', 'bcf79e6cbe98860896967aaa7bf66e5e.jpg', '2018-06-25 10:21:50', '2018-06-25 10:21:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('565', '289', '3', '1dd8d7edcd7a972b9673a0a548e85f9f.jpg', '2018-06-25 10:22:17', '2018-06-25 10:22:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('566', '253', '1', '0b041e279f0755f33fa67fe16d3be6c5.jpg', '2018-06-25 10:27:05', '2018-06-25 10:27:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('567', '253', '2', 'aa200793a3c8a1571b94916dfee94ecc.jpg', '2018-06-25 10:27:26', '2018-06-25 10:27:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('568', '253', '3', 'c68a888d723e6ba151fcf29d2bd5c2bd.jpg', '2018-06-25 10:27:50', '2018-06-25 10:27:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('569', '293', '1', 'c9139149f9a7a549c12699d1476a929c.jpg', '2018-06-25 10:34:38', '2018-06-25 10:34:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('570', '293', '2', 'e4e4d64ed02c643f1aae956e4947c740.jpg', '2018-06-25 10:35:21', '2018-06-25 10:35:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('571', '293', '3', '29d95694827a9b298436879f151ce731.jpg', '2018-06-25 10:36:00', '2018-06-25 10:36:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('572', '167', '1', 'ea49778549ce725c0f750123c722e4e1.jpg', '2018-06-25 11:49:04', '2018-06-25 11:49:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('573', '167', '2', '75fbfae2f7143a765295eba08acfd73f.jpg', '2018-06-25 11:49:53', '2018-06-25 11:49:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('574', '167', '3', '872d640ca128af687baf526a27bb717e.jpg', '2018-06-25 11:50:15', '2018-06-25 11:50:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('575', '166', '1', 'bdd9bd9105e9dd75cea1bbb2e548fb27.jpg', '2018-06-25 11:53:13', '2018-06-25 11:53:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('576', '166', '2', '70f87af794fab7fe80c6554925cf2a4b.jpg', '2018-06-25 11:53:32', '2018-06-25 11:53:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('577', '166', '3', '0f1688350b6b04c17bb16c78aad50695.jpg', '2018-06-25 11:53:56', '2018-06-25 11:53:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('578', '96', '1', 'e9f9449767b50f2d986ac90fb87ea9a1.jpg', '2018-06-25 14:03:29', '2018-06-25 14:03:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('579', '96', '2', 'f3ba4363d789adf8423651bf8b86d74b.jpg', '2018-06-25 14:04:26', '2018-06-25 14:04:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('580', '96', '3', 'df332031e01c6333f0b4eb8d82ae03aa.jpg', '2018-06-25 14:05:03', '2018-06-25 14:05:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('581', '100', '1', '123d59fa042b508f5d9f826a49aeadb8.jpg', '2018-06-25 14:06:19', '2018-06-25 14:06:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('582', '100', '2', '4ebcd72f53d3760fee6ae79643594855.jpg', '2018-06-25 14:06:38', '2018-06-25 14:06:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('583', '100', '3', '784f683152e9e9b1cf29f07dc868b5c9.jpg', '2018-06-25 14:07:15', '2018-06-25 14:07:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('584', '288', '1', '209efce6d33e75f3b5ae9af9c4d7042c.jpg', '2018-06-25 14:12:55', '2018-06-25 14:12:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('585', '288', '2', 'ef8147014e9ab08933296329f1a2c8fe.jpg', '2018-06-25 14:13:18', '2018-06-25 14:13:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('586', '288', '3', 'a2a7e6fdd2c205ad46fc8eb402e22621.jpg', '2018-06-25 14:14:02', '2018-06-25 14:14:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('587', '288', '3', 'b79892418ca70a90e1b92e032cc7a985.jpg', '2018-06-25 14:14:02', '2018-06-25 14:14:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('588', '94', '1', 'f4e55c1e0d2f35645c523f1ed4168173.jpg', '2018-06-25 14:23:49', '2018-06-25 14:23:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('589', '94', '2', '3eef59680a36dd925e66108c173391f6.jpg', '2018-06-25 14:24:57', '2018-06-25 14:24:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('590', '94', '3', 'd0c07411da2b6dbb75018838b8eb5a5e.jpg', '2018-06-25 14:25:38', '2018-06-25 14:25:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('591', '93', '1', '8bd5c7194cd7fc9d3630e04248d3b844.jpg', '2018-06-25 14:30:19', '2018-06-25 14:30:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('592', '93', '2', '74727d02ede7b68a31915254dcf462e1.jpg', '2018-06-25 14:30:52', '2018-06-25 14:30:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('593', '93', '3', '81a081c68fbedb5f31dff5c357f99540.jpg', '2018-06-25 14:31:33', '2018-06-25 14:31:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('594', '92', '1', '96a0fd8fc1a95e4af1c74cba998f64db.jpg', '2018-06-25 14:33:04', '2018-06-25 14:33:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('595', '92', '2', 'eaaadfc54cf10597b32137990703b8ea.jpg', '2018-06-25 14:33:21', '2018-06-25 14:33:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('596', '92', '3', '25054b7f83610b94af186126f75925f3.jpg', '2018-06-25 14:33:57', '2018-06-25 14:33:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('597', '95', '1', '5675c5a142da81981fa57fe91e709b7e.jpg', '2018-06-25 14:35:09', '2018-06-25 14:35:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('598', '95', '2', 'a02477e95b0b13dac64597a19f151aef.jpg', '2018-06-25 14:35:21', '2018-06-25 14:35:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('599', '95', '3', '467698a6f1c8adab3dfed4bf3321a086.jpg', '2018-06-25 14:35:41', '2018-06-25 14:35:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('600', '233', '1', '18c7d9a97ebc6401af3ce31d8273d0ad.jpg', '2018-06-25 14:37:31', '2018-06-25 14:37:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('601', '233', '2', '5ea76c6f42e24a60dbb45910c843906d.jpg', '2018-06-25 14:37:48', '2018-06-25 14:37:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('602', '233', '3', '732911b26e44784577b654c1de6aeed5.jpg', '2018-06-25 14:38:22', '2018-06-25 14:38:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('603', '103', '1', 'b248a7c5ecc1eb5a31924201d259164c.jpg', '2018-06-25 14:47:20', '2018-06-25 14:47:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('604', '103', '2', '4943b398f64e20e33bea553928d7c88a.jpg', '2018-06-25 14:47:47', '2018-06-25 14:47:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('605', '103', '3', '6a58700508757fa3c3750d396e960f7f.jpg', '2018-06-25 14:48:22', '2018-06-25 14:48:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('606', '104', '1', '3781184b4d88c9e7c222c9904ac1fa1e.jpg', '2018-06-25 14:49:33', '2018-06-25 14:49:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('607', '104', '2', '1dfc303ec95282fce23466ed74f3dbc5.jpg', '2018-06-25 14:50:05', '2018-06-25 14:50:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('608', '104', '3', 'c88b867a58f1ec1d592467b3f049175c.jpg', '2018-06-25 14:52:09', '2018-06-25 14:52:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('609', '102', '1', '8e6ea09f72f3071587aed6ab9d39904e.jpg', '2018-06-25 14:54:41', '2018-06-25 14:54:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('610', '102', '2', '4946b611b357045eafb9fe4e2bcbdf79.jpg', '2018-06-25 14:55:40', '2018-06-25 14:55:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('611', '102', '3', '7e41d454bd89fa3d44c6a0ee67092fd2.jpg', '2018-06-25 14:56:15', '2018-06-25 14:56:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('612', '98', '1', '82563690d75cdd82f1c3c1fcfbb282af.jpg', '2018-06-25 15:12:33', '2018-06-25 15:12:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('613', '98', '2', 'e0a2af95197ef7c2e0743f9b8dd7c6d8.jpg', '2018-06-25 15:12:48', '2018-06-25 15:12:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('614', '98', '3', '9e2687c1967d1b8ff1ed0d8027ff6f96.jpg', '2018-06-25 15:13:15', '2018-06-25 15:13:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('615', '204', '1', '19f8f39d1b64f5a41b935e94f21f1579.jpg', '2018-06-27 11:59:10', '2018-06-27 11:59:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('616', '204', '1', '9347d8243db30ee58fea36a0bc55ee7d.jpg', '2018-06-27 11:59:10', '2018-06-27 11:59:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('617', '204', '2', '06f7a9cdaea0170c07de341bbb2ff701.jpg', '2018-06-27 12:32:58', '2018-06-27 12:32:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('618', '204', '2', '4cc12f72bd2e001da4ece4f4e95acab9.jpg', '2018-06-27 12:32:58', '2018-06-27 12:32:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('619', '204', '2', '2c7ab042b39b969da7aa49508fb9d631.jpg', '2018-06-27 12:32:58', '2018-06-27 12:32:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('620', '204', '2', 'cce4ea70acc5c05e1d4fe361f2b3e0a8.jpg', '2018-06-27 12:32:58', '2018-06-27 12:32:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('621', '204', '2', '088c48895087e715a7b0dbe8591c5240.jpg', '2018-06-27 12:32:58', '2018-06-27 12:32:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('622', '204', '3', '8f56be45d9801e17046ecc1b642c86db.jpg', '2018-06-27 12:39:23', '2018-06-27 12:39:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('623', '354', '1', '29da6b84d8800ffbb3d5d3c36914b936.jpg', '2018-06-27 18:07:23', '2018-06-27 18:07:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('624', '354', '1', 'f5e36601fe498a769381660bd832caaa.jpg', '2018-06-27 18:07:23', '2018-06-27 18:07:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('625', '354', '2', '82d2543644d8c550f4e8d7558cbe0a72.jpg', '2018-06-27 18:07:38', '2018-06-27 18:07:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('626', '354', '3', '1c281ab41f5414db3cb56166225232fa.jpg', '2018-06-27 18:08:47', '2018-06-27 18:08:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('627', '355', '1', '66de715ed30ad4ebcfd6fe75da3cf751.jpg', '2018-06-27 18:28:36', '2018-06-27 18:28:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('628', '355', '2', '0a4784e9f950f8e35369691d4a850a9e.jpg', '2018-06-27 18:28:47', '2018-06-27 18:28:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('629', '355', '3', '1a93e0da3ff31378d5448ea3a7b7722b.jpg', '2018-06-27 18:29:22', '2018-06-27 18:29:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('630', '303', '1', 'e97c2f6ad587b618a45e64b47b5f2f46.jpg', '2018-06-28 11:55:12', '2018-06-28 11:55:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('631', '303', '1', 'c032bdfaa63a2b8a5c4b0e8fde49c31f.jpg', '2018-06-28 11:55:12', '2018-06-28 11:55:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('632', '303', '2', '27e052a44636845c18a3d5ec3436fee0.jpg', '2018-06-28 11:55:41', '2018-06-28 11:55:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('633', '303', '2', '8dd722aed472383e20c518862afe6e87.jpg', '2018-06-28 11:55:41', '2018-06-28 11:55:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('634', '303', '2', '96eaaeca2c7d93fc69cdf1b326ebb4dc.jpg', '2018-06-28 11:55:41', '2018-06-28 11:55:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('635', '303', '3', 'd4e47d521c8a233e95834a9e75e819ab.jpg', '2018-06-28 11:56:44', '2018-06-28 11:56:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('636', '351', '1', '26283ba70a289563044d1bd46ff2e730.jpg', '2018-06-29 08:59:22', '2018-06-29 08:59:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('637', '351', '2', 'd5a1e62f073166e4c19ad2e3008d9347.jpg', '2018-06-29 08:59:43', '2018-06-29 08:59:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('638', '351', '2', 'e15f4f1aa6ca7fed2c623346936bc9c0.jpg', '2018-06-29 08:59:43', '2018-06-29 08:59:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('639', '351', '2', 'a0391f5f9139f4c86f2767afd44694a3.jpg', '2018-06-29 08:59:43', '2018-06-29 08:59:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('640', '351', '2', '494fb3fd158f64d9346ca72328f01ffa.jpg', '2018-06-29 08:59:43', '2018-06-29 08:59:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('641', '351', '3', 'a41f0a51c037e8a3f2c93699bf68ba08.jpg', '2018-06-29 09:02:19', '2018-06-29 09:02:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('642', '361', '1', 'ced1a00260d838e8d5e691443d6dff22.jpg', '2018-06-29 09:42:47', '2018-06-29 09:42:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('643', '361', '2', '292866bc42d7817196595fc6662d23f2.jpg', '2018-06-29 09:43:05', '2018-06-29 09:43:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('644', '361', '2', '7c26f21f9f1f2b1765b691114047889b.jpg', '2018-06-29 09:43:05', '2018-06-29 09:43:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('645', '361', '2', 'a88cb02994e6e72ebbd92ff5b81832a0.jpg', '2018-06-29 09:43:05', '2018-06-29 09:43:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('646', '361', '2', '76d0059ad25b23f616a9ff8b34b56c81.jpg', '2018-06-29 09:43:05', '2018-06-29 09:43:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('647', '361', '3', '2cdcb12d2e0b8d6a55cb6b5fc7a42be6.jpg', '2018-06-29 09:47:07', '2018-06-29 09:47:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('648', '232', '1', '756baf3fb1146307e46b27020b1a7b88.jpg', '2018-06-29 11:31:53', '2018-06-29 11:31:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('649', '232', '2', '1191b2d0b68ff8c20b3723c24084f935.jpg', '2018-06-29 11:32:03', '2018-06-29 11:32:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('650', '232', '3', '9c87a16ecf5be8e8b18d7d35a5c72ad0.jpg', '2018-06-29 11:35:21', '2018-06-29 11:35:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('651', '144', '1', '83a5ddde6e505aa9ab98b000efc82de4.jpg', '2018-06-29 11:39:43', '2018-06-29 11:39:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('652', '144', '2', '37dc4387b99d7b6bab907e26487ec8b0.jpg', '2018-06-29 11:39:50', '2018-06-29 11:39:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('653', '144', '3', '2f84bcaecae1b726c507d8d295c6d7c5.jpg', '2018-06-29 11:46:28', '2018-06-29 11:46:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('654', '101', '1', 'd0bb62cff41a093c83635464eddf5d60.jpg', '2018-07-03 09:09:56', '2018-07-03 09:09:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('655', '101', '2', '949b2e6659ed0201d96a5b9fb72d4055.jpg', '2018-07-03 09:10:16', '2018-07-03 09:10:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('656', '101', '3', '5e18a63c09a07c01e4cd9dd06aba6fb0.jpg', '2018-07-03 09:10:45', '2018-07-03 09:10:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('657', '260', '1', 'fcb453e03eb128e41336abd8c063799f.jpg', '2018-07-03 09:24:20', '2018-07-03 09:24:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('658', '260', '2', '89c1f25514ef173aa52114ffb6dec2cc.jpg', '2018-07-03 09:24:48', '2018-07-03 09:24:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('659', '260', '3', 'afe0794104863df9e512c01c166bcdde.jpg', '2018-07-03 09:25:08', '2018-07-03 09:25:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('660', '302', '1', '62708f37beb1b6c58b5ec402aeeeaf34.jpg', '2018-07-03 09:33:12', '2018-07-03 09:33:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('661', '302', '2', '4f94cc072147fb2a79cfcc573512237c.jpg', '2018-07-03 09:33:37', '2018-07-03 09:33:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('662', '302', '3', 'ebd3f3e425877e26c966fe7916da16ac.jpg', '2018-07-03 09:34:03', '2018-07-03 09:34:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('663', '97', '1', 'ed3a1febceef1addf75fb22aaf90a83a.jpg', '2018-07-03 09:37:12', '2018-07-03 09:37:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('664', '97', '2', 'dfa63c47feac1bdb871fb16403d0a266.jpg', '2018-07-03 09:37:45', '2018-07-03 09:37:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('665', '97', '3', 'bee77156f4b3288e8c77072cb73ba2bc.jpg', '2018-07-03 09:38:05', '2018-07-03 09:38:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('666', '196', '1', '5cf4410bb42d1fd95f8d9d24fcacfdd2.jpg', '2018-07-03 10:31:35', '2018-07-03 10:31:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('667', '196', '2', 'd52a8436efd68769794a93875d87c96f.jpg', '2018-07-03 10:33:11', '2018-07-03 10:33:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('668', '196', '3', 'ea31d951c964ddb7f1471892c1315ee2.jpg', '2018-07-03 10:33:54', '2018-07-03 10:33:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('669', '268', '1', '88eb6ca1404d538093fe9fb2cea39170.jpg', '2018-07-03 11:12:05', '2018-07-03 11:12:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('670', '268', '2', '73420b094ea2719003a3b47820be13f2.jpg', '2018-07-03 11:12:46', '2018-07-03 11:12:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('671', '268', '3', 'e56c48742690b30b0f68666800dbf95d.jpg', '2018-07-03 11:13:18', '2018-07-03 11:13:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('672', '315', '1', '92afbec74130fdbb11c6cd1dc018ce11.jpg', '2018-07-03 11:16:09', '2018-07-03 11:16:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('673', '315', '2', '3f6f670aef59abe526eb1996214ca3ce.jpg', '2018-07-03 11:16:25', '2018-07-03 11:16:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('674', '315', '3', '9dddc96466723311cab7ebf4bdb591e5.jpg', '2018-07-03 11:17:00', '2018-07-03 11:17:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('675', '316', '1', '2a115915a202c927021b92388618eaac.jpg', '2018-07-03 11:19:24', '2018-07-03 11:19:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('676', '316', '2', '149903f158469dabf2a2b6f793ca89f5.jpg', '2018-07-03 11:19:39', '2018-07-03 11:19:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('677', '316', '3', 'ddce73d3fda62369b98a965280700bc9.jpg', '2018-07-03 11:19:54', '2018-07-03 11:19:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('678', '300', '1', '6cc2deb2bdee1aa31ed88ade514189db.jpg', '2018-07-03 11:22:53', '2018-07-03 11:22:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('679', '300', '2', '4d2d9d470ab9abd3377e8a3242109317.jpg', '2018-07-03 11:23:05', '2018-07-03 11:23:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('680', '300', '3', 'a496826718043a1759c8e62d1523bd99.jpg', '2018-07-03 11:23:30', '2018-07-03 11:23:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('681', '256', '1', '71c4d4e396b834e2f9a1777839af22bd.jpg', '2018-07-03 11:30:30', '2018-07-03 11:30:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('682', '256', '2', 'a213ceda5b877a14f7691a4e02ea8217.jpg', '2018-07-03 11:30:48', '2018-07-03 11:30:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('683', '256', '3', '46b9f4de9f90559c5b6ff557bc20b6f7.jpg', '2018-07-03 11:31:12', '2018-07-03 11:31:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('684', '172', '1', 'de87cb4c958a0e9a458534984a1a9c5b.jpg', '2018-07-03 11:33:18', '2018-07-03 11:33:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('685', '172', '2', '95f13dc79659ec077754ee704a07960c.jpg', '2018-07-03 11:33:35', '2018-07-03 11:33:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('686', '172', '3', '5d30de251d6a73da93816ff63d67740d.jpg', '2018-07-03 11:33:55', '2018-07-03 11:33:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('687', '344', '1', '262ce8684e4e44bf380d1f9ecc898f37.jpg', '2018-07-03 11:52:08', '2018-07-03 11:52:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('688', '344', '1', '73a86751384bf3d9b7fff700c5a6a242.jpg', '2018-07-03 11:52:08', '2018-07-03 11:52:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('689', '344', '1', '4888974c0a5036f307c1ce723a604556.jpg', '2018-07-03 11:52:08', '2018-07-03 11:52:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('690', '344', '2', '35f5c809ee4d0649e00a90ff1ddcc715.jpg', '2018-07-03 11:53:12', '2018-07-03 11:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('691', '344', '2', 'f8c16f0c5f1f277a0a4c0f2ce5efd649.jpg', '2018-07-03 11:53:12', '2018-07-03 11:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('692', '344', '2', '20d77c81b248cca6aabbdc57709f1ae6.jpg', '2018-07-03 11:53:12', '2018-07-03 11:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('693', '344', '2', '5fdd9ca76dc5c066e1999fd498420248.jpg', '2018-07-03 11:53:12', '2018-07-03 11:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('694', '344', '2', '25b9e44f43358102fdee7b116c6501ef.jpg', '2018-07-03 11:53:12', '2018-07-03 11:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('695', '344', '2', '4673d486e2472002a490fb36c5eb11e0.jpg', '2018-07-03 11:53:12', '2018-07-03 11:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('696', '344', '3', 'acf1403b2d87b5ca1be1550af42fda4e.jpg', '2018-07-03 11:54:14', '2018-07-03 11:54:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('697', '367', '1', '1d2ae33103912bd8aa32f1d51af14df9.jpg', '2018-07-03 14:38:45', '2018-07-03 14:38:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('698', '367', '2', '9639cde24b413da611bf6637435ed4b5.jpg', '2018-07-03 14:39:00', '2018-07-03 14:39:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('699', '367', '3', 'c07b6c2f8d793930442faef447c7313e.jpg', '2018-07-03 14:40:29', '2018-07-03 14:40:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('700', '353', '1', 'dcee5b490ba54d49c46dbddc63cb6b5c.jpg', '2018-07-03 21:58:28', '2018-07-03 21:58:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('701', '353', '2', '5132ddecb1e36b8b3e829332c5c02b0a.jpg', '2018-07-03 21:59:15', '2018-07-03 21:59:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('702', '353', '3', 'af988607541d944fdeefd71af50c0654.jpg', '2018-07-03 22:00:25', '2018-07-03 22:00:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('703', '371', '1', 'a8a64bfa80edea65d34eacdeaf4b279a.jpg', '2018-07-04 11:10:12', '2018-07-04 11:10:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('704', '371', '2', '2885a66bec7876e54c002068991a864e.jpg', '2018-07-04 11:11:14', '2018-07-04 11:11:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('705', '371', '3', '14d582426ed05e984be59bd6fbf22942.jpg', '2018-07-04 11:11:51', '2018-07-04 11:11:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('706', '327', '1', '89e3f49b8718c7e42319a8e3616d6b16.jpg', '2018-07-04 11:14:43', '2018-07-04 11:14:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('707', '327', '1', '4fde19e40c6f7ec9ca452e2bd52cf303.jpg', '2018-07-04 11:14:43', '2018-07-04 11:14:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('708', '327', '2', 'eb64761075012faee8d24a3ca2780a9d.jpg', '2018-07-04 11:15:14', '2018-07-04 11:15:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('709', '327', '2', 'edc9aa801d0159dd6966b0e05921045d.jpg', '2018-07-04 11:15:14', '2018-07-04 11:15:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('710', '327', '2', '666138189c961473098ff78d61d97997.jpg', '2018-07-04 11:15:14', '2018-07-04 11:15:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('711', '327', '3', '3dd1e50e08d76aeff3c421a4b7632b45.jpg', '2018-07-04 11:16:46', '2018-07-04 11:16:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('712', '275', '1', '852ff476b44a1d4c957ddbfd4a36734b.jpg', '2018-07-04 14:07:56', '2018-07-04 14:07:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('713', '275', '2', '7b005588de729f2bc2fea4de36e68822.jpg', '2018-07-04 14:08:48', '2018-07-04 14:08:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('714', '275', '3', 'a9fe1e1074c62273a86ce0179b75dad3.jpg', '2018-07-04 14:09:53', '2018-07-04 14:09:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('715', '274', '1', '3f0f6c2a9a0678f5cddef15fc7044da3.jpg', '2018-07-04 14:17:52', '2018-07-04 14:17:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('716', '274', '2', '106830febe0231902c73eddade604f96.jpg', '2018-07-04 14:18:25', '2018-07-04 14:18:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('717', '274', '3', 'acdd61f125da603214a5c785d0762108.jpg', '2018-07-04 14:18:56', '2018-07-04 14:18:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('718', '273', '1', '82cbbd532f6d399b74d4f14e43e66cb5.jpg', '2018-07-04 14:22:48', '2018-07-04 14:22:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('719', '273', '2', '492978d3f516d1abc138545abb0cd1f0.jpg', '2018-07-04 14:23:09', '2018-07-04 14:23:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('720', '273', '3', 'c9325b61ec4cbda2c66820b2862d7d7a.jpg', '2018-07-04 14:23:37', '2018-07-04 14:23:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('721', '298', '1', '82074795c3391e710b06f11142cb19fa.jpg', '2018-07-04 14:28:18', '2018-07-04 14:28:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('722', '298', '2', 'cbed5ed4f00390d07580590db44214d1.jpg', '2018-07-04 14:28:28', '2018-07-04 14:28:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('723', '298', '3', 'ea08334482ac4609ff831f5a8db6c793.jpg', '2018-07-04 14:28:44', '2018-07-04 14:28:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('724', '295', '1', '0b2cc5b36d5ddd8b5738cba42279b696.jpg', '2018-07-04 14:31:52', '2018-07-04 14:31:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('725', '295', '2', '8e9b8f46cc3300518f5bd19746023366.jpg', '2018-07-04 14:32:17', '2018-07-04 14:32:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('726', '295', '3', 'e0dc65df5f7f9da2583e90bbaba23c77.jpg', '2018-07-04 14:34:10', '2018-07-04 14:34:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('727', '296', '1', '8f25f2b69e2d4f130a949c470220b941.jpg', '2018-07-04 14:35:18', '2018-07-04 14:35:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('728', '296', '2', '4d0d5216b37a2a108513e37fbb3eec3d.jpg', '2018-07-04 14:35:29', '2018-07-04 14:35:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('729', '296', '3', '72f50e636a8a028119ad92c15fbdcb59.jpg', '2018-07-04 14:35:48', '2018-07-04 14:35:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('730', '162', '1', 'cce83d2298c97b046398fe9e25d0637f.jpg', '2018-07-04 14:38:33', '2018-07-04 14:38:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('731', '162', '2', 'f59a733f7f3e73cf5810a6841bb08419.jpg', '2018-07-04 14:38:45', '2018-07-04 14:38:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('732', '162', '3', 'ba2e8ca8cb0457e5fb15fc066f81abd5.jpg', '2018-07-04 14:39:05', '2018-07-04 14:39:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('733', '161', '1', '5a43baee53fb8a4fc77bd0ce1ab79245.jpg', '2018-07-04 15:15:08', '2018-07-04 15:15:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('734', '161', '2', 'b3be5eedf8572061038d28ce77dfd6e4.jpg', '2018-07-04 15:15:22', '2018-07-04 15:15:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('735', '161', '3', '6ca1c1ad596b1cf6ebf70fbcbe7f0e71.jpg', '2018-07-04 15:15:43', '2018-07-04 15:15:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('736', '159', '1', '0a3aa86317bd483a146f5826d0ba5a05.jpg', '2018-07-04 15:17:49', '2018-07-04 15:17:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('737', '159', '2', '25fdb4c77ab4cdc52e92bc4526181cb1.jpg', '2018-07-04 15:18:03', '2018-07-04 15:18:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('738', '159', '3', 'a87c9a18161a8e1224a776e6f4edbcdb.jpg', '2018-07-04 15:18:22', '2018-07-04 15:18:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('739', '157', '1', 'be4c9fa7c3c40ae38a4695a0a1041d6b.jpg', '2018-07-04 15:57:12', '2018-07-04 15:57:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('740', '157', '2', '8d292cea14b93c3bc124bacafc6fc251.jpg', '2018-07-04 15:57:49', '2018-07-04 15:57:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('741', '157', '3', '281b806625eb966242764c57b983c034.jpg', '2018-07-04 15:58:11', '2018-07-04 15:58:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('742', '163', '1', 'bf88ddcde5bf400a15e260aa53229e63.jpg', '2018-07-04 16:02:44', '2018-07-04 16:02:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('743', '163', '2', 'c36baaa5f623ed6f78a21fa31efb33fc.jpg', '2018-07-04 16:03:01', '2018-07-04 16:03:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('744', '163', '3', '867bb19cc0a633b3522688314825ce0b.jpg', '2018-07-04 16:03:24', '2018-07-04 16:03:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('777', '387', '2', 'bcee615ffdd02f807f1ce9bae321f0d5.jpg', '2018-07-06 17:22:31', '2018-07-06 17:22:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('776', '387', '2', 'ca6bd6178628b80d3b27d2ac464b3b28.jpg', '2018-07-06 17:22:31', '2018-07-06 17:22:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('775', '387', '2', 'c7ab315200cf61855954b8e3604fc568.jpg', '2018-07-06 17:22:31', '2018-07-06 17:22:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('774', '387', '1', 'aad9ff2c97a17b866bbd1b1daf1fd799.jpg', '2018-07-06 17:17:37', '2018-07-06 17:17:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('749', '277', '1', 'ab2367cbfea16bb2c38e477245e7104c.jpg', '2018-07-05 08:28:51', '2018-07-05 08:28:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('750', '277', '2', 'd6abd7a2fa398e7ece9e0961b67bd3de.jpg', '2018-07-05 08:29:06', '2018-07-05 08:29:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('751', '277', '3', '69e38d166f143ef15c775c980a9ad425.jpg', '2018-07-05 08:29:29', '2018-07-05 08:29:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('752', '276', '1', '6f0576713cd80cccf5a8819a284edbe6.jpg', '2018-07-05 08:32:14', '2018-07-05 08:32:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('753', '276', '2', 'd416fc6b75539ee03efd92f1164eb31e.jpg', '2018-07-05 08:32:28', '2018-07-05 08:32:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('754', '276', '3', 'a707836b2fb4de762689f87adbdc2495.jpg', '2018-07-05 08:32:49', '2018-07-05 08:32:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('755', '370', '1', '629c12dabc534e658fd2fa49931ec982.jpg', '2018-07-05 11:18:48', '2018-07-05 11:18:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('756', '370', '1', '5457437698bbf2a5084da9e10ced6d75.jpg', '2018-07-05 11:18:48', '2018-07-05 11:18:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('757', '370', '2', 'cdfb0e711d28e7731dd5793bc51b1b9f.jpg', '2018-07-05 11:28:29', '2018-07-05 11:28:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('758', '370', '2', '48d2c451784967e3fb06bfd06bb52225.jpg', '2018-07-05 11:28:29', '2018-07-05 11:28:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('759', '370', '2', '75667e948902f980ce770ca291501525.jpg', '2018-07-05 11:28:29', '2018-07-05 11:28:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('760', '370', '2', 'a3372e145e400320eebc834d94171d35.jpg', '2018-07-05 11:28:29', '2018-07-05 11:28:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('761', '370', '3', 'f451a2f5cbd56b86cd97040e586e947c.jpg', '2018-07-05 11:36:25', '2018-07-05 11:36:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('762', '373', '1', 'fcaa9ea9bdc4ae43a2b40e0894607e2e.jpg', '2018-07-05 14:02:49', '2018-07-05 14:02:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('763', '373', '2', '4d93ed539b4a134d056f0a96f92d69f6.jpg', '2018-07-05 14:03:20', '2018-07-05 14:03:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('764', '373', '2', '6c1ab26481f89847aa182be154949c70.jpg', '2018-07-05 14:03:20', '2018-07-05 14:03:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('765', '373', '2', '50ee6c1a62bf54fade3cbb300f2f27ba.jpg', '2018-07-05 14:03:20', '2018-07-05 14:03:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('766', '373', '3', '0d19d14390229d3e71a57d63fef56b03.jpg', '2018-07-05 14:06:54', '2018-07-05 14:06:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('767', '360', '1', 'a6e46bbc27b6896245f2075e11df20b9.jpg', '2018-07-05 14:28:29', '2018-07-05 14:28:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('768', '360', '1', 'efeeedce66c24d2c4b84f4292fc69696.jpg', '2018-07-05 14:28:29', '2018-07-05 14:28:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('769', '360', '2', '425874bf73d8ee3e9fe956e6585faa80.jpg', '2018-07-05 14:29:49', '2018-07-05 14:29:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('770', '360', '2', 'bec7faf9218f2cb6f9cde17890935d4a.jpg', '2018-07-05 14:29:49', '2018-07-05 14:29:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('771', '360', '2', '7e24cdc06441cb03502633a0d2df7328.jpg', '2018-07-05 14:29:49', '2018-07-05 14:29:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('772', '360', '2', '55e08df861168577a67bae6905cac10a.jpg', '2018-07-05 14:29:49', '2018-07-05 14:29:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('773', '360', '2', 'b53c3d37da365038195b0e222f103a2f.jpg', '2018-07-05 14:29:49', '2018-07-05 14:29:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('778', '360', '3', 'f31c049f98a230e43b448c5ec228a606.jpg', '2018-07-06 17:24:55', '2018-07-06 17:24:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('779', '387', '3', 'e2fe857c7fe376ac5586d1c61cdbdc43.jpg', '2018-07-06 17:27:56', '2018-07-06 17:27:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('780', '391', '1', '8f402edb455ff2fbf6190b280654411a.jpg', '2018-07-06 23:18:46', '2018-07-06 23:18:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('781', '53', '1', '2bccba42cc59ececd8827a424128a7ca.jpg', '2018-07-09 09:24:25', '2018-07-09 09:24:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('782', '53', '1', 'b5057f2657b02b3b59ba18fbcd5e9d86.jpg', '2018-07-09 09:24:25', '2018-07-09 09:24:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('783', '53', '2', '402bf3a8d1739aaaebbea68c75c3411c.jpg', '2018-07-09 09:24:38', '2018-07-09 09:24:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('784', '53', '3', '4c7318718b2921c3295f2170abb4db22.jpg', '2018-07-09 09:25:26', '2018-07-09 09:25:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('785', '67', '1', 'fbc07f18b5122005f5855b35b73e4fc7.jpg', '2018-07-09 10:58:57', '2018-07-09 10:58:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('786', '67', '2', '42fb9cadea06efd9b8d3a120ae3df93d.jpg', '2018-07-09 11:00:55', '2018-07-09 11:00:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('787', '389', '1', '0b87863b6bb255213aa5745b1edff7dc.jpg', '2018-07-09 12:40:36', '2018-07-09 12:40:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('788', '389', '2', '5d7f2b5774e4da1a612d9e84fd3d1ff4.jpg', '2018-07-09 12:48:01', '2018-07-09 12:48:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('789', '389', '2', '7900592cbb354871343c3e77926cc8bf.jpg', '2018-07-09 12:48:01', '2018-07-09 12:48:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('790', '389', '2', '301299e77dee35aab151212e79ef97a2.jpg', '2018-07-09 12:48:01', '2018-07-09 12:48:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('791', '389', '3', 'c577d70ccab684af8c8352ccbe2ab2a1.jpg', '2018-07-09 12:52:16', '2018-07-09 12:52:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('792', '304', '1', '123b433d6f09a7661455062924118241.jpg', '2018-07-09 13:31:47', '2018-07-09 13:31:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('793', '304', '1', '6448198bf9c893767e8a8ce97acd47a1.jpg', '2018-07-09 13:31:47', '2018-07-09 13:31:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('794', '304', '2', 'e4dbd457ce385fd1c4721788358e6251.jpg', '2018-07-09 13:32:08', '2018-07-09 13:32:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('795', '304', '3', 'e9e0305825fd8e7a693100e39e0f7e46.jpg', '2018-07-09 13:34:51', '2018-07-09 13:34:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('796', '386', '1', '66b9eb421bd7eaeade98b4bdea133234.jpg', '2018-07-09 13:38:02', '2018-07-09 13:38:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('797', '386', '1', '08ae9d99ee8a7575fc116c0d2d991e25.jpg', '2018-07-09 13:38:02', '2018-07-09 13:38:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('798', '386', '2', '9982f13adde7dd99e4891825a79d42bf.jpg', '2018-07-09 13:38:08', '2018-07-09 13:38:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('799', '386', '3', 'dba538e835ca17478eaaac427fa5a58e.jpg', '2018-07-09 13:40:25', '2018-07-09 13:40:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('800', '236', '1', '5cf649c232bc56cf4f5da9bf4fcf5c8f.jpg', '2018-07-10 11:42:17', '2018-07-10 11:42:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('801', '236', '1', '59b28d09dfe1c624375785c0a75cc346.jpg', '2018-07-10 11:42:17', '2018-07-10 11:42:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('802', '236', '2', 'f8339393e6e7b786cb2aa1a5139e6b5d.jpg', '2018-07-10 11:42:58', '2018-07-10 11:42:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('803', '236', '2', 'ac01629276ac72ff7e15060d35de4061.jpg', '2018-07-10 11:42:58', '2018-07-10 11:42:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('804', '236', '2', 'ca69d00ae08fc5f8b4d847726d54115d.jpg', '2018-07-10 11:42:58', '2018-07-10 11:42:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('805', '236', '2', '021831afdadd0fdc89db77ae6c3ca124.jpg', '2018-07-10 11:42:58', '2018-07-10 11:42:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('806', '236', '3', '708309507e10137dba2db3ee811ad096.jpg', '2018-07-10 11:47:14', '2018-07-10 11:47:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('807', '374', '1', '3130476c1d5f2c591933229363a572c8.jpg', '2018-07-10 13:53:12', '2018-07-10 13:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('808', '374', '2', '3beed82464b3f1923652942871fad821.jpg', '2018-07-10 13:53:39', '2018-07-10 13:53:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('809', '305', '1', '0d6ce3f8ad23cf9514c0ea9357d262e5.jpg', '2018-07-11 11:38:42', '2018-07-11 11:38:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('810', '305', '2', '08148df8f8a24074936c4a1e0e99fd47.jpg', '2018-07-11 11:39:04', '2018-07-11 11:39:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('811', '305', '3', '92baacfac80356f6dfd81f44e1d5f420.jpg', '2018-07-11 11:39:28', '2018-07-11 11:39:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('812', '307', '1', '42a5ad190351f5f7c72806294a7e2a48.jpg', '2018-07-11 11:45:48', '2018-07-11 11:45:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('813', '307', '2', '7e69d1393d74c55fb327a2df43b61689.jpg', '2018-07-11 11:46:32', '2018-07-11 11:46:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('814', '307', '3', 'c73067fa734dd8046288f45195a85b19.jpg', '2018-07-11 11:47:06', '2018-07-11 11:47:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('815', '308', '1', '505645f7e4d3f66fd24a2d35c94e19fa.jpg', '2018-07-11 11:50:31', '2018-07-11 11:50:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('816', '308', '2', '9c8493f29397f69299cd2c3d730dfd78.jpg', '2018-07-11 11:50:46', '2018-07-11 11:50:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('817', '308', '3', '67ffdf9819429035db1476fe3dbf7aaf.jpg', '2018-07-11 11:51:06', '2018-07-11 11:51:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('818', '309', '1', 'dfd5484986e7e7ff2d92d87fce9547fb.jpg', '2018-07-11 11:53:07', '2018-07-11 11:53:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('819', '309', '2', '6bf8f9042c92cfa3f23f5d3dd0a17b39.jpg', '2018-07-11 11:53:29', '2018-07-11 11:53:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('820', '309', '3', 'ce903276fbca0194a12535321dd474a7.jpg', '2018-07-11 11:53:49', '2018-07-11 11:53:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('821', '310', '1', 'd45b88ce4af06f8e10b9012edfb20875.jpg', '2018-07-11 11:56:34', '2018-07-11 11:56:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('822', '310', '2', 'eda2fe164e8b575539a66f3da38b08c5.jpg', '2018-07-11 11:56:58', '2018-07-11 11:56:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('823', '310', '3', '9e097555e711bd9e4ee3bf9db8d503f4.jpg', '2018-07-11 11:57:32', '2018-07-11 11:57:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('824', '262', '1', 'b858717095279cc58f103451c7bcb92f.jpg', '2018-07-11 12:11:07', '2018-07-11 12:11:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('825', '262', '2', 'c1854f76c77bd9b550aab26335c1e0cf.jpg', '2018-07-11 12:11:21', '2018-07-11 12:11:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('826', '262', '3', 'e9e80152f903e8776000d1a39aa52469.jpg', '2018-07-11 12:11:44', '2018-07-11 12:11:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('827', '265', '1', '42ea572cc7d2b0facb987be05bd81542.jpg', '2018-07-11 12:13:56', '2018-07-11 12:13:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('828', '265', '2', '6abcee9c0b4b6ecf1c1875aa3bbe719d.jpg', '2018-07-11 12:14:06', '2018-07-11 12:14:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('829', '265', '3', 'cdfe59c501cb181a49e7c3f1936a2651.jpg', '2018-07-11 12:14:49', '2018-07-11 12:14:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('830', '65', '1', '8a9e1b2a731865a75c61c6c32bf0a023.jpg', '2018-07-11 12:21:35', '2018-07-11 12:21:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('831', '65', '2', '97acd3185cf74752f8e179a1b33506d8.jpg', '2018-07-11 12:22:01', '2018-07-11 12:22:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('832', '65', '3', '029c972fe85a0d402dbeb826f30dd749.jpg', '2018-07-11 12:22:42', '2018-07-11 12:22:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('833', '267', '1', 'effaad543b857297b934562bfb0cda38.jpg', '2018-07-11 12:51:58', '2018-07-11 12:51:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('834', '267', '1', '8bb4e7bd11960d1ab33c06a8af9971f7.jpg', '2018-07-11 12:51:58', '2018-07-11 12:51:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('835', '267', '2', '6056103f64ace120af67269f8093829b.jpg', '2018-07-11 12:53:08', '2018-07-11 12:53:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('836', '267', '2', '074678017a66c1fa83231d9cfedbc673.jpg', '2018-07-11 12:53:08', '2018-07-11 12:53:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('837', '267', '2', 'abe4736b9c3593f7972db3de74baa4f4.jpg', '2018-07-11 12:53:08', '2018-07-11 12:53:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('838', '267', '3', '73e232bc19ca6bacaf72442c693fd096.jpg', '2018-07-11 12:57:29', '2018-07-11 12:57:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('839', '223', '1', 'a74b3208a56c7a56e98ae14c2a789d11.jpg', '2018-07-12 08:32:59', '2018-07-12 08:32:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('840', '223', '2', '2dfd76bd69640a988ea09d86147631d5.jpg', '2018-07-12 08:33:39', '2018-07-12 08:33:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('841', '223', '3', 'f3b79107723876d8d6c6ec87bf8da1c3.jpg', '2018-07-12 08:34:02', '2018-07-12 08:34:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('842', '146', '1', '78a8f956ecba02b3dd8be8b21b981cb2.jpg', '2018-07-12 09:09:24', '2018-07-12 09:09:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('843', '146', '2', 'aa0a810786b9320f961568cedc6155ac.jpg', '2018-07-12 09:09:50', '2018-07-12 09:09:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('844', '146', '3', '8b3e4858b4ef68da08b2c90d93991a2a.jpg', '2018-07-12 09:10:25', '2018-07-12 09:10:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('845', '147', '1', 'dcd7d99b40ecf6d0faf3eaad7729aefc.jpg', '2018-07-12 09:11:31', '2018-07-12 09:11:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('846', '147', '2', 'c23d8b2dfa8c95209ae66f1c2c148234.jpg', '2018-07-12 09:11:52', '2018-07-12 09:11:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('847', '147', '3', 'c746c7ab91fdfe20e8371fae997a51a7.jpg', '2018-07-12 09:12:15', '2018-07-12 09:12:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('848', '148', '1', '539735c364e7585db09f0dbd5a8f449b.jpg', '2018-07-12 09:13:56', '2018-07-12 09:13:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('849', '148', '2', '05fe091a7a05fc546cd145bcd85a424b.jpg', '2018-07-12 09:14:18', '2018-07-12 09:14:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('850', '148', '3', 'a7362cef37d6c080f56ca4a11c383978.jpg', '2018-07-12 09:14:42', '2018-07-12 09:14:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('851', '149', '1', '012a8c030567b04d089092587b9ca9fa.jpg', '2018-07-12 09:16:18', '2018-07-12 09:16:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('852', '149', '2', '8eb6ebe89c4fbe7ea74950e3de62a92e.jpg', '2018-07-12 09:16:35', '2018-07-12 09:16:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('853', '149', '3', '454058fab88e59b0f01c0009ad4fc327.jpg', '2018-07-12 09:16:56', '2018-07-12 09:16:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('854', '171', '1', 'f8adfe9c46f8a5c305a24d5acac6aa15.jpg', '2018-07-12 09:54:27', '2018-07-12 09:54:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('855', '171', '2', '6b981418b38e5eae08630cf4a864aa7b.jpg', '2018-07-12 09:54:48', '2018-07-12 09:54:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('856', '171', '3', 'f0732ce1fbee863a97f54005ab799e8d.jpg', '2018-07-12 09:55:24', '2018-07-12 09:55:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('857', '270', '1', '88ded13593aec13911ac085aeae464f9.jpg', '2018-07-12 09:58:37', '2018-07-12 09:58:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('858', '270', '2', '6d39f3f0bb2e807dddf516f9cbd9ae3b.jpg', '2018-07-12 09:58:58', '2018-07-12 09:58:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('859', '270', '3', '42b118a5df8cd50f3bad744692fa89f8.jpg', '2018-07-12 09:59:31', '2018-07-12 09:59:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('860', '234', '1', '0b90edd4209c72a2f50a57a77cae9098.jpg', '2018-07-12 10:01:54', '2018-07-12 10:01:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('861', '234', '2', '8e21a78f8009fe35f43bbb4595e6bf8b.jpg', '2018-07-12 10:02:08', '2018-07-12 10:02:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('862', '234', '3', '0ed00d8176294af402f7b3bf0b3c66a7.jpg', '2018-07-12 10:02:37', '2018-07-12 10:02:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('863', '154', '1', '99eec4dda150c3b415ac4b4af03b88c2.jpg', '2018-07-12 10:07:30', '2018-07-12 10:07:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('864', '154', '2', '91f49ea0658d07df3ae245ff8f4d3a0e.jpg', '2018-07-12 10:07:44', '2018-07-12 10:07:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('865', '154', '3', '6114549fdb034cd993ba8d6819108199.jpg', '2018-07-12 10:08:24', '2018-07-12 10:08:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('866', '184', '1', '102c4a9f53edbef288f56104c9c7ab49.jpg', '2018-07-12 10:12:23', '2018-07-12 10:12:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('867', '184', '2', '055d88cd163a45c0cb51520d84fee251.jpg', '2018-07-12 10:12:29', '2018-07-12 10:12:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('868', '184', '3', '6b0ddc9f25ea48abe8285b47da9578bd.jpg', '2018-07-12 10:12:51', '2018-07-12 10:12:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('869', '258', '1', 'a04ecfcfbca21ea56f7b00afd4a94b34.jpg', '2018-07-12 10:13:48', '2018-07-12 10:13:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('870', '258', '2', '63b81e6138a56f8935485340cd531918.jpg', '2018-07-12 10:14:04', '2018-07-12 10:14:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('871', '258', '3', '7cc3402c7db111109c02b533fc8f43f5.jpg', '2018-07-12 10:14:29', '2018-07-12 10:14:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('872', '182', '1', 'e097d6af1fcc0f1f3f11d5ed7948908a.jpg', '2018-07-12 10:17:10', '2018-07-12 10:17:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('873', '182', '2', '958ba89f7f78da73c6292627b2841ef5.jpg', '2018-07-12 10:17:22', '2018-07-12 10:17:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('874', '182', '3', 'e7701bb9cc3828ef39014a96293cc3b4.jpg', '2018-07-12 10:17:47', '2018-07-12 10:17:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('875', '328', '1', 'e3f7700ee580561986fadbbad8e8efa2.jpg', '2018-07-12 10:20:16', '2018-07-12 10:20:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('876', '328', '2', 'b573525c14b50fbb124ed1274e186707.jpg', '2018-07-12 10:20:27', '2018-07-12 10:20:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('877', '328', '3', '7f8a0c2b9f28f1ae93f3df56c4a694d5.jpg', '2018-07-12 10:20:50', '2018-07-12 10:20:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('878', '337', '1', '4a25cca558155f7edb68d32ffa21429f.jpg', '2018-07-12 10:49:45', '2018-07-12 10:49:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('879', '337', '2', 'e095baf6084c1bece71cb87e3df0d9e2.jpg', '2018-07-12 10:50:01', '2018-07-12 10:50:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('880', '337', '3', '84fdefd51f514dbc910776ad606a497b.jpg', '2018-07-12 10:50:43', '2018-07-12 10:50:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('881', '338', '1', '276237a3c8fcdbe90a292c674428473a.jpg', '2018-07-12 10:54:13', '2018-07-12 10:54:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('882', '338', '2', '466e228a560c5e1715dcfeeee7e97ce4.jpg', '2018-07-12 10:54:33', '2018-07-12 10:54:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('883', '338', '3', '28ca11d350af262d0a24d8a4461ee8b7.jpg', '2018-07-12 10:54:49', '2018-07-12 10:54:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('884', '339', '1', '47e1ec43e8360a65b4003d2d408157c2.jpg', '2018-07-12 10:56:01', '2018-07-12 10:56:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('885', '339', '2', '2adb225d5755764d1367511629cd7370.jpg', '2018-07-12 10:56:09', '2018-07-12 10:56:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('886', '339', '3', 'd3b8b0456ad0d078476034a79a749605.jpg', '2018-07-12 10:56:20', '2018-07-12 10:56:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('887', '349', '1', '2ff1c64c2ff35c25b5fa28984ea00842.jpg', '2018-07-12 10:57:25', '2018-07-12 10:57:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('888', '349', '2', '187e5026cc8ef91a8d6a08ab471bfaed.jpg', '2018-07-12 10:57:52', '2018-07-12 10:57:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('889', '349', '3', '5ff828b509d6c79180691496c597ff22.jpg', '2018-07-12 10:58:07', '2018-07-12 10:58:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('890', '320', '1', 'bac8f51dc4aba9d8593afd8935f84ca4.jpg', '2018-07-12 11:06:36', '2018-07-12 11:06:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('891', '320', '2', 'a961a5ec76fc9c759371af735542dfbc.jpg', '2018-07-12 11:06:54', '2018-07-12 11:06:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('892', '320', '3', '600af56f681b32c1a80f352e4f29b882.jpg', '2018-07-12 11:07:22', '2018-07-12 11:07:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('893', '299', '1', '55dca92b9368dd7aa66d71b7d051a91c.jpg', '2018-07-12 11:11:29', '2018-07-12 11:11:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('894', '299', '2', '46cbb905c532189f06bfe26cab7cfd4a.jpg', '2018-07-12 11:11:54', '2018-07-12 11:11:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('895', '299', '3', '7dce36bb4708e729dbc37d0fb5f2d714.jpg', '2018-07-12 11:12:31', '2018-07-12 11:12:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('896', '368', '1', 'e4ee65fac9454211c734ea353b88114a.jpg', '2018-07-12 11:14:25', '2018-07-12 11:14:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('897', '368', '2', '764fb32cbde378054ce7aba40f90130f.jpg', '2018-07-12 11:14:45', '2018-07-12 11:14:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('898', '368', '3', '60fb38a6f9ff73c815da5d4eaec6f930.jpg', '2018-07-12 11:15:20', '2018-07-12 11:15:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('899', '357', '1', '5debfbf07790f986d8c29708455d4711.jpg', '2018-07-12 11:20:43', '2018-07-12 11:20:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('900', '357', '2', 'c23634fdda51513a7b875253f57cb609.jpg', '2018-07-12 11:21:02', '2018-07-12 11:21:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('901', '357', '3', '4cab0686fb86f058b7326f3cc51bf730.jpg', '2018-07-12 11:21:29', '2018-07-12 11:21:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('902', '385', '1', '1f1e4dc031858cf8f5485be5d70d1f47.jpg', '2018-07-12 11:25:10', '2018-07-12 11:25:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('903', '385', '2', '5b9aa1e1abe0ffbb629690f0f2435170.jpg', '2018-07-12 11:25:25', '2018-07-12 11:25:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('904', '385', '3', 'dadda42689768fe4113be6cb5fa705e5.jpg', '2018-07-12 11:25:50', '2018-07-12 11:25:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('905', '249', '1', '0bd75fcae5a68e3663db8306ed21dbc0.jpg', '2018-07-12 11:32:38', '2018-07-12 11:32:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('906', '249', '2', 'e7dd5d856a0290060be18a2930496781.jpg', '2018-07-12 11:34:06', '2018-07-12 11:34:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('907', '249', '3', '3c2b587b29cbb55d861d8ca805dfe0fb.jpg', '2018-07-12 11:34:51', '2018-07-12 11:34:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('908', '248', '1', '8aa4f71603e92698bb92bdad31876d45.jpg', '2018-07-12 11:37:53', '2018-07-12 11:37:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('909', '248', '2', 'f3ca9401d2bf07a52d8ecb47d33ba19f.jpg', '2018-07-12 11:38:17', '2018-07-12 11:38:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('910', '248', '3', 'cb6679496490093638cf3137f8e87880.jpg', '2018-07-12 11:38:49', '2018-07-12 11:38:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('911', '350', '1', '813aef826286343b84b3426e57d87814.jpg', '2018-07-12 11:41:00', '2018-07-12 11:41:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('912', '350', '2', 'a769e709a6c3e564110595ca9c8b84ee.jpg', '2018-07-12 11:41:07', '2018-07-12 11:41:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('913', '120', '1', '133e7a784be3c9daaf11fcdfaf73a107.jpg', '2018-07-12 11:42:33', '2018-07-12 11:42:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('914', '120', '2', 'e344acf5faf8892ca09afbcc47896f05.jpg', '2018-07-12 11:42:42', '2018-07-12 11:42:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('915', '120', '3', '6ae1429d2432cff5615f1a08f4f3ec5e.jpg', '2018-07-12 11:43:00', '2018-07-12 11:43:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('916', '119', '1', 'c2f230c43abb255ff02ef99055c26a58.jpg', '2018-07-12 11:44:32', '2018-07-12 11:44:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('917', '119', '2', '13542ee89097e4d1dd51afec27f656e6.jpg', '2018-07-12 11:45:09', '2018-07-12 11:45:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('918', '119', '2', 'd2e03b36e05620d4aac248afb39b8496.jpg', '2018-07-12 11:45:09', '2018-07-12 11:45:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('919', '119', '3', '1134a1d6b7823e25d399709604362efb.jpg', '2018-07-12 11:45:32', '2018-07-12 11:45:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('920', '174', '1', 'ffbe2d5d082bd750bfd3bfc4e3c67730.jpg', '2018-07-12 12:19:26', '2018-07-12 12:19:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('921', '174', '1', 'be66fcefd7749f33265e466c2ed9084b.jpg', '2018-07-12 12:19:26', '2018-07-12 12:19:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('922', '174', '2', '718931889ad931a6bf2d4b4151204633.jpg', '2018-07-12 12:20:19', '2018-07-12 12:20:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('923', '174', '2', 'd4698bd210e35d507fd620fc17b3b7c6.jpg', '2018-07-12 12:20:19', '2018-07-12 12:20:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('924', '174', '2', '26d8c0757a27622ba05a1b0370746429.jpg', '2018-07-12 12:20:19', '2018-07-12 12:20:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('925', '174', '2', '586cc33317263ebb50f5ab69336b16f5.jpg', '2018-07-12 12:20:19', '2018-07-12 12:20:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('926', '174', '2', '3b10464b057b4786be55ac91d6fbd023.jpg', '2018-07-12 12:20:19', '2018-07-12 12:20:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('927', '174', '3', '9e1fbe8f341850fc84e1c67ad945f5da.jpg', '2018-07-12 13:02:06', '2018-07-12 13:02:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('928', '209', '1', '8909b57eb012ed1baed7d64d34b11f73.jpg', '2018-07-13 11:24:13', '2018-07-13 11:24:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('929', '209', '1', '79d81b29689c71668ba5b808f67bf480.jpg', '2018-07-13 11:24:13', '2018-07-13 11:24:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('930', '209', '2', '6d0643b34256f156afc4c73eb37ba2f0.jpg', '2018-07-13 11:24:31', '2018-07-13 11:24:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('931', '209', '2', '6e3e01167aaafc7a92bd43895df0734c.jpg', '2018-07-13 11:24:31', '2018-07-13 11:24:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('932', '209', '2', '4d723226e4297c22537529dc1b23cc35.jpg', '2018-07-13 11:24:31', '2018-07-13 11:24:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('933', '209', '3', 'a085fd6d3b1760835640e08159456708.jpg', '2018-07-13 11:25:55', '2018-07-13 11:25:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('934', '348', '1', 'e646bd5b1afeca590f77d9b72fbc4b15.jpg', '2018-07-14 11:31:38', '2018-07-14 11:31:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('935', '348', '1', '92563e1e05837a64244bd69dfa752a68.jpg', '2018-07-14 11:31:38', '2018-07-14 11:31:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('936', '348', '2', '0db9cd971a45fc88a1e1eaa1a9b50e42.jpg', '2018-07-14 11:31:52', '2018-07-14 11:31:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('937', '348', '2', 'b91cbeb9ca80ac4df139fae9622f1c05.jpg', '2018-07-14 11:31:52', '2018-07-14 11:31:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('938', '348', '2', '7f96f17da5c3ae51f2f257f32197f8ea.jpg', '2018-07-14 11:31:52', '2018-07-14 11:31:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('939', '348', '3', '2ec8cc877dca23e6bcca71fa69ef0a0c.jpg', '2018-07-14 11:32:53', '2018-07-14 11:32:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('940', '343', '1', '172a284becb26e3332fc9c587a6a5c20.jpg', '2018-07-16 11:58:21', '2018-07-16 11:58:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('941', '343', '2', '5a5ae4ad7438f4ded08ecffc91243263.jpg', '2018-07-16 11:59:14', '2018-07-16 11:59:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('942', '343', '3', '9ed67e689ac6c21379ecb837a7604472.jpg', '2018-07-16 11:59:41', '2018-07-16 11:59:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('943', '369', '1', 'f656e6e7bfc2217c1d405aa24444b1f1.jpg', '2018-07-16 12:00:36', '2018-07-16 12:00:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('944', '369', '2', '945c551815dc96cbc9570774c13f0a78.jpg', '2018-07-16 12:01:02', '2018-07-16 12:01:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('945', '369', '3', '8be7ab9ef6ed6858544325048ab1a4ed.jpg', '2018-07-16 12:01:25', '2018-07-16 12:01:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('946', '413', '1', 'd67e00c2574f0762fb1a9851d7adeba4.jpg', '2018-07-16 12:03:45', '2018-07-16 12:03:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('947', '413', '2', 'e0a0fc69d693872186046cf69d382459.jpg', '2018-07-16 12:03:53', '2018-07-16 12:03:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('948', '413', '3', 'e4b17d3f0cec12022a4206959f00148d.jpg', '2018-07-16 12:05:14', '2018-07-16 12:05:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('949', '406', '1', '789115394abbb2ca3d6744eb2156597d.jpg', '2018-07-16 12:08:40', '2018-07-16 12:08:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('950', '406', '2', '72c7a3b7c381b79f35f82a9dabe8b8c9.jpg', '2018-07-16 12:08:53', '2018-07-16 12:08:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('951', '406', '2', 'f109a0d6a067475f3f9f16a2a188c8aa.jpg', '2018-07-16 12:08:53', '2018-07-16 12:08:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('952', '406', '3', '53f98cc8009107d8a1564de23f154d1d.jpg', '2018-07-16 12:10:42', '2018-07-16 12:10:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('953', '330', '1', '32a59262d5a109fe76a21f59755ddb6b.jpg', '2018-07-16 12:14:34', '2018-07-16 12:14:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('954', '330', '2', 'c073a43e66b55aef01607d23dc2796cd.jpg', '2018-07-16 12:16:18', '2018-07-16 12:16:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('955', '330', '3', 'a06220e6a20506c634d3b365d248c646.jpg', '2018-07-16 12:16:45', '2018-07-16 12:16:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('956', '433', '1', '589e6368289cdeba8b56197c69532c9a.jpg', '2018-07-16 12:55:53', '2018-07-16 12:55:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('957', '433', '2', '9a8cb3056e5beac5fd86ee1f59234a87.jpg', '2018-07-16 12:57:42', '2018-07-16 12:57:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('958', '433', '3', 'b6e6c6d394cab85640c11e9063f2ca79.jpg', '2018-07-16 12:58:03', '2018-07-16 12:58:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('959', '347', '1', 'a903f5ba76787d03f6e3c3fe8163d160.jpg', '2018-07-16 13:06:00', '2018-07-16 13:06:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('960', '347', '2', '224a7d3a03f5b94c02539d4479a9e253.jpg', '2018-07-16 13:06:20', '2018-07-16 13:06:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('961', '347', '3', '4bf2c9ce01bc73a6f195d71b7764ba10.jpg', '2018-07-16 13:07:21', '2018-07-16 13:07:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('962', '435', '1', '25dc8c0318ddc71cb77872841fe2b4f1.jpg', '2018-07-16 13:11:07', '2018-07-16 13:11:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('963', '435', '2', 'f2b8f258035a7bcff049d08d3d8e2c8d.jpg', '2018-07-16 13:11:38', '2018-07-16 13:11:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('964', '435', '3', 'ce1872d724cfdedd14f3dc7ef72221e8.jpg', '2018-07-16 13:12:06', '2018-07-16 13:12:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('965', '434', '1', 'e041f01bece99488ebd0aec009503a28.jpg', '2018-07-16 13:16:23', '2018-07-16 13:16:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('966', '434', '2', '5464ed995700b50b7c3906dc39555c45.jpg', '2018-07-16 13:16:44', '2018-07-16 13:16:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('967', '434', '3', 'd45af52edc1dc9c508b502c5e2fdc24b.jpg', '2018-07-16 13:17:14', '2018-07-16 13:17:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('968', '448', '1', '0393a4165a8ea971904c1ef431f9c3fd.jpg', '2018-07-16 13:29:59', '2018-07-16 13:29:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('969', '448', '2', 'afc1f544add7893996303defab675ee4.jpg', '2018-07-16 13:30:56', '2018-07-16 13:30:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('970', '448', '2', 'e2f6a25d1f30f1ab708a52491bc08d30.jpg', '2018-07-16 13:30:56', '2018-07-16 13:30:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('971', '448', '2', '6a94eb0c32254b55bbc284a85c1f4822.jpg', '2018-07-16 13:30:56', '2018-07-16 13:30:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('972', '448', '3', 'e4ce51bdd6dc0632d51efb95b138918d.jpg', '2018-07-16 13:31:53', '2018-07-16 13:31:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('973', '282', '1', '3917370d2091f67678b81cfde466efbd.jpg', '2018-07-16 16:25:06', '2018-07-16 16:25:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('974', '282', '2', '46cb070e660308c5786718e7edb3f8bd.jpg', '2018-07-16 16:25:47', '2018-07-16 16:25:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('975', '282', '2', '7599db8c811b257a71c6dcc8fdd8b10f.jpg', '2018-07-16 16:25:47', '2018-07-16 16:25:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('976', '282', '2', 'c6614f5c8a96e6811aebeb001d6fac8d.jpg', '2018-07-16 16:25:47', '2018-07-16 16:25:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('977', '282', '3', 'c8fedb32c50febf03a829bc753da1470.jpg', '2018-07-16 16:26:13', '2018-07-16 16:26:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('978', '375', '1', '963d4d9b8fbeb0445fad09a8f0eff139.jpg', '2018-07-16 16:29:37', '2018-07-16 16:29:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('979', '375', '2', 'c6278ca7e8a4efde814236944c99ccfb.jpg', '2018-07-16 16:30:18', '2018-07-16 16:30:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('980', '375', '3', '8cbb6228cc8efa40d5d0793a09ce03fc.jpg', '2018-07-16 16:30:40', '2018-07-16 16:30:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('981', '403', '1', '133418084ccb9115e69aa28d81e29255.jpg', '2018-07-16 16:33:56', '2018-07-16 16:33:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('982', '403', '2', 'dd6d9c2b657878f50cec89b9c545a22a.jpg', '2018-07-16 16:34:39', '2018-07-16 16:34:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('983', '403', '2', '2a5f8c38fe5ec4bc0494683df0402445.jpg', '2018-07-16 16:34:39', '2018-07-16 16:34:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('984', '403', '3', '09b417fc8634abca3fb11b72b9e97701.jpg', '2018-07-16 16:35:07', '2018-07-16 16:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('985', '318', '1', '1431a082e8cb0eb7d8ccffb336397dd7.jpg', '2018-07-17 12:15:13', '2018-07-17 12:15:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('986', '318', '1', 'ac0802f25d4d624584794257d8945eff.jpg', '2018-07-17 12:15:13', '2018-07-17 12:15:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('987', '318', '2', '30d4299fe1afd9499022ea1d902578ad.jpg', '2018-07-17 12:16:03', '2018-07-17 12:16:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('988', '318', '2', '8a42684aeee14e7b4fc3b469767209a9.jpg', '2018-07-17 12:16:03', '2018-07-17 12:16:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('989', '318', '2', 'ad5307170b01862e6eb579d380e658fa.jpg', '2018-07-17 12:16:03', '2018-07-17 12:16:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('990', '318', '2', '4c7c94db413a50514de912bc9d4c7cb9.jpg', '2018-07-17 12:16:03', '2018-07-17 12:16:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('991', '318', '2', '9aea3d7f5302333fe9969debb5c4a600.jpg', '2018-07-17 12:16:03', '2018-07-17 12:16:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('992', '318', '3', 'ee7fa8b08894a4785b5faa5757206546.jpg', '2018-07-17 12:20:18', '2018-07-17 12:20:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('993', '395', '1', '397ed465cc59f837f0e5a137860afc6c.jpg', '2018-07-17 12:56:39', '2018-07-17 12:56:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('994', '395', '2', 'a3134a2c18e720c36189ef4b38cb4181.jpg', '2018-07-17 13:05:55', '2018-07-17 13:05:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('995', '395', '3', 'e465467e6b1780eb1dfaf4ff2a506f78.jpg', '2018-07-17 13:06:28', '2018-07-17 13:06:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('996', '372', '1', '5f64b6a2da5f4f950aeb85e720b43841.jpg', '2018-07-17 13:14:20', '2018-07-17 13:14:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('997', '372', '2', '2c189d13f85fc59724dfba2e2897d1f0.jpg', '2018-07-17 13:16:52', '2018-07-17 13:16:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('998', '372', '2', '7889345fa855f1c69b0c6f7676c935bf.jpg', '2018-07-17 13:16:52', '2018-07-17 13:16:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('999', '372', '3', '26f4723d14b37ab39d2df41ab16ce19b.jpg', '2018-07-17 13:17:26', '2018-07-17 13:17:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1000', '372', '3', '584ae92253fbc0b800d34417b3bb80ef.jpg', '2018-07-17 13:17:26', '2018-07-17 13:17:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1001', '416', '1', 'd3f2e41bee4ad3598531d274e28dd4be.jpg', '2018-07-17 13:21:55', '2018-07-17 13:21:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1002', '416', '2', '6b7011c736d0eb94df159e8003acbe8b.jpg', '2018-07-17 13:25:54', '2018-07-17 13:25:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1003', '416', '2', '65033c95985863c34a8b6595f591bbe6.jpg', '2018-07-17 13:25:54', '2018-07-17 13:25:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1004', '416', '3', 'f46c5e96e81ba13fc031404a2f5fdb61.jpg', '2018-07-17 13:26:21', '2018-07-17 13:26:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1005', '380', '1', '95d001235d2f553711fd58f433c6df83.jpg', '2018-07-17 13:30:52', '2018-07-17 13:30:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1006', '380', '2', '18a264761c7fc36b73cc2df67d69bad1.jpg', '2018-07-17 13:31:56', '2018-07-17 13:31:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1007', '380', '3', '01363420622029d9e7374202b3299b8a.jpg', '2018-07-17 13:32:15', '2018-07-17 13:32:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1008', '382', '1', 'bac0cc8c27dd0d9820026058871569f0.jpg', '2018-07-17 13:33:44', '2018-07-17 13:33:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1009', '382', '2', '580556ab3e88dc6b79293f0b07da538f.jpg', '2018-07-17 13:34:09', '2018-07-17 13:34:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1010', '382', '3', '7cc821a176d227d8cf056ba12c777fbf.jpg', '2018-07-17 13:34:41', '2018-07-17 13:34:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1011', '301', '1', '3c4d09e74a380a4e663d6f5654b43411.jpg', '2018-07-17 14:31:42', '2018-07-17 14:31:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1012', '301', '2', '2a36af361185e0b81d7fe3644bf2198b.jpg', '2018-07-17 14:34:36', '2018-07-17 14:34:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1013', '301', '3', 'a775445776270fa0e43edc7089d8a71f.jpg', '2018-07-17 14:35:03', '2018-07-17 14:35:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1014', '377', '1', '17560b15b2afbfb42721a216150a21d3.jpg', '2018-07-17 14:36:33', '2018-07-17 14:36:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1015', '377', '2', 'f870fa1617cbbc92b9d71e418f09f93e.jpg', '2018-07-17 14:36:57', '2018-07-17 14:36:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1016', '377', '3', 'f04fd67fdd0b5a28648394f3abf2e184.jpg', '2018-07-17 14:37:16', '2018-07-17 14:37:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1017', '409', '1', '6e2a99b38ebb0b138d77c9455f82dcde.jpg', '2018-07-17 14:38:05', '2018-07-17 14:38:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1018', '409', '2', 'bdefbc4d2ce925f3694e408ec44e620c.jpg', '2018-07-17 14:38:31', '2018-07-17 14:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1019', '409', '3', '28547818826e50e63ac2e5f688286f29.jpg', '2018-07-17 14:38:53', '2018-07-17 14:38:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1020', '401', '1', 'e5137285c9b714d406eac322ea4596cf.jpg', '2018-07-17 14:44:39', '2018-07-17 14:44:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1021', '401', '2', '27649357777ca546b99b8a6d7d638549.jpg', '2018-07-17 14:45:24', '2018-07-17 14:45:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1022', '401', '2', 'da5bc7d69a9026499451ae2d9fa790aa.jpg', '2018-07-17 14:45:24', '2018-07-17 14:45:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1023', '401', '2', '5ed5376255201cc1d598a281f18757f5.jpg', '2018-07-17 14:45:24', '2018-07-17 14:45:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1024', '401', '3', 'c10fe0f090b3530aca2e717a7fd42d5e.jpg', '2018-07-17 14:46:07', '2018-07-17 14:46:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1025', '446', '1', '9407d5dabc3f1b4854d8594c4897ed7a.jpg', '2018-07-17 14:49:55', '2018-07-17 14:49:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1026', '446', '2', '5a94e66aeb229e709aecc2b3b6eb01a0.jpg', '2018-07-17 14:50:16', '2018-07-17 14:50:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1027', '446', '3', 'ecde8f2f9534159aa9573d13fb8030b4.jpg', '2018-07-17 14:51:16', '2018-07-17 14:51:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1028', '447', '1', 'e85060432409de6b05cee1cb29119e08.jpg', '2018-07-17 14:54:17', '2018-07-17 14:54:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1029', '447', '2', '8bf134aa30013098555187060cd68c77.jpg', '2018-07-17 14:54:34', '2018-07-17 14:54:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1030', '447', '3', 'a1f3e7570ba98e7f9f05825614efb117.jpg', '2018-07-17 14:55:07', '2018-07-17 14:55:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1031', '281', '1', 'ba6f4b668546d59805cd997c638e7cf9.jpg', '2018-07-17 14:58:04', '2018-07-17 14:58:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1032', '281', '2', 'd5559cb6072e213bd7c5f9c90b8880b9.jpg', '2018-07-17 15:00:01', '2018-07-17 15:00:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1033', '281', '3', '6cd47e8772cbe2c14050eb14399071cf.jpg', '2018-07-17 15:00:24', '2018-07-17 15:00:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1034', '279', '1', 'e1d8609a53cdcee3eaf893f68144f3cf.jpg', '2018-07-17 15:01:26', '2018-07-17 15:01:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1035', '279', '2', 'f20236f82b29d5fb8d5fd9d48f129871.jpg', '2018-07-17 15:01:39', '2018-07-17 15:01:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1036', '279', '3', 'b45c60345a10b99775da08db74281fd7.jpg', '2018-07-17 15:01:58', '2018-07-17 15:01:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1037', '411', '1', '61ed605d8b27b11055151a3d85575403.jpg', '2018-07-17 15:13:47', '2018-07-17 15:13:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1038', '411', '2', '8c6c6f60d31d6b211e869fb7b9943047.jpg', '2018-07-17 15:16:37', '2018-07-17 15:16:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1039', '411', '3', 'd7cd9f362dbc9e9946ca76b12ae0cacb.jpg', '2018-07-17 15:16:58', '2018-07-17 15:16:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1040', '412', '1', 'f829a0655d8927da96804ed1b7d0154a.jpg', '2018-07-17 15:17:47', '2018-07-17 15:17:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1041', '412', '2', 'ff4fbce9d9bca0d12d21077534261aff.jpg', '2018-07-17 15:18:48', '2018-07-17 15:18:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1042', '412', '2', '32bd7183f4ce2402502207c5bb4ddfa9.jpg', '2018-07-17 15:18:48', '2018-07-17 15:18:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1043', '412', '2', '446fa575977fc12cb39ee388d77baf75.jpg', '2018-07-17 15:18:48', '2018-07-17 15:18:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1044', '412', '2', '19769273a3a1f3f5eb7b66a9e20f0736.jpg', '2018-07-17 15:18:48', '2018-07-17 15:18:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1045', '412', '2', 'b4cdb048e20b256478fb529997b3c160.jpg', '2018-07-17 15:18:48', '2018-07-17 15:18:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1046', '412', '3', '7ab6a730bf883ad3b702ef46a99028f6.jpg', '2018-07-17 15:19:20', '2018-07-17 15:19:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1047', '449', '1', 'd2e04a7a854e928db4758d89fde88fc1.jpg', '2018-07-17 15:19:52', '2018-07-17 15:19:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1048', '449', '2', '2cedfda94ac27de149bd03a14705a2ac.jpg', '2018-07-17 15:20:15', '2018-07-17 15:20:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1049', '449', '3', 'e86590b61f4ada5998ea69a3c6dcbfc2.jpg', '2018-07-17 15:20:34', '2018-07-17 15:20:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1050', '376', '1', '43989538f4f84fa5ce28008dd34d569a.jpg', '2018-07-17 17:21:05', '2018-07-17 17:21:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1051', '376', '2', '0e26f6c2edc103a313a234f9d2899c2f.jpg', '2018-07-17 17:21:51', '2018-07-17 17:21:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1052', '376', '3', '9ae1d880f7929bcb50b58554f9932bcd.jpg', '2018-07-17 17:22:29', '2018-07-17 17:22:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1053', '199', '1', 'e700bc24eaa59567395f1aa81bc34956.jpg', '2018-07-19 11:18:31', '2018-07-19 11:18:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1054', '199', '1', '2a490ed1a0838785948853e7c29965c1.jpg', '2018-07-19 11:18:31', '2018-07-19 11:18:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1055', '199', '2', '87db9a452df53cfb27e70795ba8164ef.jpg', '2018-07-19 12:12:36', '2018-07-19 12:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1056', '199', '2', '9bf850fb0b2b499d24937e57ebd6ae02.jpg', '2018-07-19 12:12:36', '2018-07-19 12:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1057', '199', '2', '53334e2bcf29e97bff0de6a7848b63d4.jpg', '2018-07-19 12:12:36', '2018-07-19 12:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1058', '199', '2', '17e41ff6fdab783bbc99bd4d313b15e7.jpg', '2018-07-19 12:12:36', '2018-07-19 12:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1059', '199', '3', '4b1e19f3a0202a5f98e8dd22ebff444d.jpg', '2018-07-19 12:15:35', '2018-07-19 12:15:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1060', '456', '1', '2f86df53b5b926ee01476704830f02f9.jpg', '2018-07-19 12:23:31', '2018-07-19 12:23:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1061', '456', '1', '6013950fd6f1d26feac3c260ae390695.jpg', '2018-07-19 12:23:31', '2018-07-19 12:23:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1062', '456', '2', '03b16b1bada319743b8e05cbc202a2ae.jpg', '2018-07-19 12:24:09', '2018-07-19 12:24:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1063', '456', '2', 'b0c6096c81f53619fcf32f2ed4724c27.jpg', '2018-07-19 12:24:09', '2018-07-19 12:24:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1064', '456', '2', '62edd95f8d24348ddaf284c4c648e4d4.jpg', '2018-07-19 12:24:09', '2018-07-19 12:24:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1065', '456', '2', 'be6847b1296c8800b070f5093896b6a8.jpg', '2018-07-19 12:24:09', '2018-07-19 12:24:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1066', '456', '2', '5373cb1bf559614439a106293f835121.jpg', '2018-07-19 12:24:09', '2018-07-19 12:24:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1067', '456', '3', 'fd0f382614f3ebe41743141967187735.jpg', '2018-07-19 12:25:52', '2018-07-19 12:25:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1068', '441', '1', '9227828cc0daffc1e283b6073707548c.jpg', '2018-07-19 12:27:02', '2018-07-19 12:27:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1069', '441', '1', 'e9687e9267e4396c6f32238b8e777c8f.jpg', '2018-07-19 12:27:02', '2018-07-19 12:27:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1070', '441', '2', '18ebad2db6a83217bd96f33630d23c88.jpg', '2018-07-19 12:27:38', '2018-07-19 12:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1071', '441', '2', '569520aa28a6dd21ce01aff1982c0b23.jpg', '2018-07-19 12:27:38', '2018-07-19 12:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1072', '441', '2', '5af9f0a543273b0d6bb7667f7b456383.jpg', '2018-07-19 12:27:38', '2018-07-19 12:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1073', '441', '2', 'cd7caac6c7db3eaa2a21328f6c658705.jpg', '2018-07-19 12:27:38', '2018-07-19 12:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1074', '441', '3', '504b0e9504185f5bd702b0548d0c84ab.jpg', '2018-07-19 12:28:39', '2018-07-19 12:28:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1075', '471', '1', '2014ee2d20b9f347964c1f51fbab2dbb.jpg', '2018-07-19 13:38:56', '2018-07-19 13:38:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1076', '471', '2', '07b73aeeb3ed58ac122a036a6075aece.jpg', '2018-07-19 13:39:21', '2018-07-19 13:39:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1077', '471', '2', '34e240a9e0f2be789e2e1c0e04332f06.jpg', '2018-07-19 13:39:21', '2018-07-19 13:39:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1078', '471', '3', '319b203d48c0e9ae85959e01cc2fa809.jpg', '2018-07-19 13:40:17', '2018-07-19 13:40:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1079', '404', '2', 'a4aa8ca1017209a95f10611185a09bf3.jpg', '2018-07-20 09:31:02', '2018-07-20 09:31:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1080', '404', '3', 'fddb042db1ebe29ca0c51fc5ac60337f.jpg', '2018-07-20 09:31:49', '2018-07-20 09:31:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1081', '485', '1', '7df35e528c5133f66ae9079a86b9a777.jpg', '2018-07-20 12:37:14', '2018-07-20 12:37:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1082', '485', '2', '2c0fe5dd58b314fae53f7ed89fa57481.jpg', '2018-07-20 12:37:43', '2018-07-20 12:37:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1083', '485', '3', '5f4219cbc8df9a6820815b1fd6ded2b7.jpg', '2018-07-20 12:38:38', '2018-07-20 12:38:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1084', '187', '2', 'c1f4bd4aa21932798465774dccd7ce8e.jpg', '2018-07-20 15:40:24', '2018-07-20 15:40:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1085', '187', '2', 'e66a4bfbdc8d9fbfd0d8aa1da7f245dd.jpg', '2018-07-20 15:40:24', '2018-07-20 15:40:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1086', '187', '3', 'd767d6246ab6fab3c3c2fc9b555af5a8.jpg', '2018-07-20 15:40:47', '2018-07-20 15:40:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1087', '450', '2', 'a9f0ef9cccb5b3982b10a5732ed91b47.jpg', '2018-07-20 15:43:50', '2018-07-20 15:43:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1088', '450', '3', '171b3d2fc5d96aea87e2c040e919e909.jpg', '2018-07-20 15:44:11', '2018-07-20 15:44:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1089', '261', '2', 'e6fca4c83baf5f53070bca37d91112e6.jpg', '2018-07-20 15:49:12', '2018-07-20 15:49:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1090', '261', '3', '7bde0cecfbb540dea8abada20043f010.jpg', '2018-07-20 15:49:39', '2018-07-20 15:49:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1091', '263', '2', '92958a2dfe74d57436ede97ad78582c9.jpg', '2018-07-20 16:05:57', '2018-07-20 16:05:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1092', '263', '3', '5d666a374b49547f5b64cef1b827ae6d.jpg', '2018-07-20 16:06:20', '2018-07-20 16:06:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1093', '264', '2', 'd751486555ab84b69402dbd062f18d29.jpg', '2018-07-20 16:08:22', '2018-07-20 16:08:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1094', '264', '3', '0570a37935b3c14b81124eaf16853018.jpg', '2018-07-20 16:08:37', '2018-07-20 16:08:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1095', '397', '2', '070336c5bcbe1836a7a548ab084a92cc.jpg', '2018-07-20 16:09:18', '2018-07-20 16:09:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1096', '397', '3', '1b51600b9f2f7b50f8d22e07fcd5de16.jpg', '2018-07-20 16:09:35', '2018-07-20 16:09:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1097', '290', '2', 'eef66e0c40408bc322361e7164401878.jpg', '2018-07-20 16:16:22', '2018-07-20 16:16:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1098', '290', '3', '57d31632d378b51a497cd1be38cda0d3.jpg', '2018-07-20 16:16:48', '2018-07-20 16:16:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1099', '493', '1', '080e4f8d672247d3a976b1a0fecfa3e8.jpg', '2018-07-21 16:33:06', '2018-07-21 16:33:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1100', '493', '1', '5a936401a55c4ef2272d9b788320ed54.jpg', '2018-07-21 16:33:06', '2018-07-21 16:33:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1101', '493', '2', '0c0f1273ff23592a8a725e958cbbe6ba.jpg', '2018-07-21 16:33:29', '2018-07-21 16:33:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1102', '493', '2', '0b0e7b8d768b045d6900a777d644268e.jpg', '2018-07-21 16:33:29', '2018-07-21 16:33:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1103', '493', '2', '0f423e78bff3a34353c83f59a88bf1a9.jpg', '2018-07-21 16:33:29', '2018-07-21 16:33:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1104', '493', '2', '304ec5d18790356f7d04f6e3675730f4.jpg', '2018-07-21 16:33:29', '2018-07-21 16:33:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1105', '493', '3', '5cc0db228ea39880b8476b7af90e7896.jpg', '2018-07-21 16:36:14', '2018-07-21 16:36:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1106', '396', '1', 'faa4abbb067053733713e70e19865dfe.jpg', '2018-07-23 16:57:22', '2018-07-23 16:57:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1107', '396', '2', '7f42c4213ab07482950be4594e8c4815.jpg', '2018-07-23 16:57:34', '2018-07-23 16:57:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1108', '396', '3', '0610943ca000a239b55823e7a0e5a085.jpg', '2018-07-23 16:59:24', '2018-07-23 16:59:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1109', '453', '1', 'b7d6dc1d929ed9019f5e457257811e22.jpg', '2018-07-23 17:12:36', '2018-07-23 17:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1110', '453', '1', '6bd038da850bf164a5c45912ff9520d4.jpg', '2018-07-23 17:12:36', '2018-07-23 17:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1111', '453', '1', 'c55c201b8bc3f26268498c7bf0bc4338.jpg', '2018-07-23 17:12:36', '2018-07-23 17:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1112', '453', '1', '54f70c0bc664f8a38cb1942ed4a7d483.jpg', '2018-07-23 17:12:36', '2018-07-23 17:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1113', '453', '1', '7e6d75bca27d86927307db3397f524cc.jpg', '2018-07-23 17:12:36', '2018-07-23 17:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1114', '453', '1', '0d68cb98c565b2798fc689a0b6c47d7a.jpg', '2018-07-23 17:12:36', '2018-07-23 17:12:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1115', '453', '2', 'b11f2b10106f4e72611bfa9bc609ad96.jpg', '2018-07-23 17:13:08', '2018-07-23 17:13:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1116', '453', '2', '3eb93d5ae55db94e75735bdcb30d65f0.jpg', '2018-07-23 17:13:08', '2018-07-23 17:13:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1117', '453', '2', '80d530df3a2b2b855cc0b1af3ac10982.jpg', '2018-07-23 17:13:08', '2018-07-23 17:13:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1118', '453', '3', 'f2ae5c76a625d6810c5c0cf966ca633b.jpg', '2018-07-23 17:14:52', '2018-07-23 17:14:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1119', '474', '1', 'a90fa7a7bc9f0c30583075ed993d1169.jpg', '2018-07-23 17:27:01', '2018-07-23 17:27:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1120', '474', '1', 'db7dbe7ecf9be2475a1bee4c7ba61a71.jpg', '2018-07-23 17:27:01', '2018-07-23 17:27:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1121', '474', '1', 'a808ba474c69d8c1532634687d394d8b.jpg', '2018-07-23 17:27:01', '2018-07-23 17:27:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1122', '474', '1', 'c0dabf039ac2e26c805c872b3e4a35b0.jpg', '2018-07-23 17:27:01', '2018-07-23 17:27:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1123', '474', '1', 'a2d24686ede08e1ffa83639a53fbdd92.jpg', '2018-07-23 17:27:01', '2018-07-23 17:27:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1124', '474', '1', '7ce2de5fb0ec406c037fbe81732b16f9.jpg', '2018-07-23 17:27:01', '2018-07-23 17:27:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1125', '474', '2', '8d6b3439199ee9d07cf2e56750d359a5.jpg', '2018-07-23 17:27:38', '2018-07-23 17:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1126', '474', '2', 'c390e23a0df722f3489ac5c8a345674d.jpg', '2018-07-23 17:27:38', '2018-07-23 17:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1127', '474', '2', 'f3162d37d511c716d28c798d5ea2668a.jpg', '2018-07-23 17:27:38', '2018-07-23 17:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1128', '474', '2', 'bc9239ee41520ca56967c7cd4d10fb76.jpg', '2018-07-23 17:27:38', '2018-07-23 17:27:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1129', '474', '3', '450141dea67f3272a9f70f453818f7e0.jpg', '2018-07-23 17:28:35', '2018-07-23 17:28:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1130', '502', '1', '4ad9645c1985a68726fec5ab92fa97a2.jpg', '2018-07-24 16:31:35', '2018-07-24 16:31:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1131', '502', '2', 'a57cc1a33da68095753053ec25b35cc1.jpg', '2018-07-24 16:31:52', '2018-07-24 16:31:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1132', '502', '3', '2fad03e3364b188081dca8af396ca504.jpg', '2018-07-24 16:33:22', '2018-07-24 16:33:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1133', '424', '1', 'c556d0d05a1401a75bff8ec2cbb6d28f.jpg', '2018-07-24 16:47:38', '2018-07-24 16:47:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1134', '424', '2', 'b36a99945fab473d0e1eac6407d1d623.jpg', '2018-07-24 16:47:51', '2018-07-24 16:47:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1135', '424', '3', '5286b688f059dcc28e97c1043fba6fab.jpg', '2018-07-24 16:49:05', '2018-07-24 16:49:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1136', '366', '2', '93fdefa0846ddf70979688f83f5bc414.jpg', '2018-07-25 14:37:18', '2018-07-25 14:37:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1137', '366', '3', '0cc46335d1942642cbf622161c354be1.jpg', '2018-07-25 14:37:42', '2018-07-25 14:37:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1138', '341', '2', '511af92a08522270fc9b0804cfd35cc0.jpg', '2018-07-25 19:17:06', '2018-07-25 19:17:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1139', '341', '2', '585b1bc247acf19a977940d002f59715.jpg', '2018-07-25 19:17:06', '2018-07-25 19:17:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1140', '341', '3', '9f78fe5f127ae98671ff397f6adbbdb6.jpg', '2018-07-25 19:17:50', '2018-07-25 19:17:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1141', '153', '2', 'd0c1790651dbe8193537bfea71eaa9a3.jpg', '2018-07-26 12:01:43', '2018-07-26 12:01:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1142', '153', '3', '1598379ca705c730d681b78ad3e86dc5.jpg', '2018-07-26 12:02:59', '2018-07-26 12:02:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1143', '495', '2', '7f4394fe099ee6694a800243641cbb20.jpg', '2018-07-26 12:17:12', '2018-07-26 12:17:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1144', '495', '3', '4718a95949ccb6824d6bf19f04256e79.jpg', '2018-07-26 12:17:37', '2018-07-26 12:17:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1145', '321', '2', 'e289349de5d781aed766d3215e904c44.jpg', '2018-07-26 12:24:46', '2018-07-26 12:24:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1146', '321', '3', 'c59886e7b7488883592323c333b89004.jpg', '2018-07-26 12:26:16', '2018-07-26 12:26:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1147', '364', '2', 'd464fc1df134d033aaf306560998966c.jpg', '2018-07-26 12:27:03', '2018-07-26 12:27:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1148', '364', '3', '258c802674735a87265373d92de4bddb.jpg', '2018-07-26 12:27:50', '2018-07-26 12:27:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1149', '173', '2', '7c37a408867e5ea9557c89a78e139141.jpg', '2018-07-26 12:29:51', '2018-07-26 12:29:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1150', '173', '3', 'fb5588027714012e15545420df4d4901.jpg', '2018-07-26 12:30:36', '2018-07-26 12:30:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1151', '530', '2', 'de456eebd7cba5f2e975e266cc31beb9.jpg', '2018-07-26 12:34:26', '2018-07-26 12:34:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1152', '530', '2', '9d9e729feda19de8d3b8942354673a39.jpg', '2018-07-26 12:34:26', '2018-07-26 12:34:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1153', '530', '3', '00536baa7e797e5c8419018fee6fba3c.jpg', '2018-07-26 12:34:58', '2018-07-26 12:34:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1154', '356', '2', 'cc83414a954ecdbe0b342c464b3d6294.jpg', '2018-07-26 12:41:14', '2018-07-26 12:41:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1155', '356', '3', '88e3d5c759c4fff2ec3eb1d2649d1afc.jpg', '2018-07-26 12:41:31', '2018-07-26 12:41:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1156', '257', '2', 'a2b5d9af11d97b596bac0f808e644f26.jpg', '2018-07-26 12:50:57', '2018-07-26 12:50:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1157', '257', '3', '32da5ec534b3e10b0e2027c4cfbfa4d0.jpg', '2018-07-26 12:51:28', '2018-07-26 12:51:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1158', '398', '2', 'b69b774bf3d64430ec398e54782194c3.jpg', '2018-07-26 12:53:32', '2018-07-26 12:53:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1159', '398', '3', '56ac5c63a64a75f08cbe911fb5c3d89d.jpg', '2018-07-26 12:53:50', '2018-07-26 12:53:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1160', '432', '2', '9112906b7dd368f5e2bc0aace55d1d56.jpg', '2018-07-26 12:55:20', '2018-07-26 12:55:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1161', '432', '3', '5265f7fb0aebfab834936f6d527bd295.jpg', '2018-07-26 12:55:34', '2018-07-26 12:55:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1162', '384', '2', 'a413c5466629658d594c43f0fa83565d.jpg', '2018-07-26 12:57:23', '2018-07-26 12:57:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1163', '384', '3', '7358e0de869170b162cf2e259f0e754d.jpg', '2018-07-26 12:57:46', '2018-07-26 12:57:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1164', '392', '2', 'd22330afb03985c34dc1e4f23a60780d.jpg', '2018-07-26 13:02:39', '2018-07-26 13:02:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1165', '392', '3', '2d45a6a48d5766a7b0a03557b0d07b5e.jpg', '2018-07-26 13:03:04', '2018-07-26 13:03:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1166', '394', '2', '821f504d3453ffcc79c80b9c60251d39.jpg', '2018-07-26 13:08:28', '2018-07-26 13:08:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1167', '394', '3', 'd8f84d4fb2fcd47677c82c72aba1896d.jpg', '2018-07-26 13:08:51', '2018-07-26 13:08:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1168', '481', '2', '4fdd46d8dee35c10fb1570ff96c7b0f7.jpg', '2018-07-26 13:13:25', '2018-07-26 13:13:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1169', '481', '2', 'f8a503e6ee59e29d4cb615bd6358ae02.jpg', '2018-07-26 13:13:25', '2018-07-26 13:13:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1170', '481', '3', 'c08b1d451599fa8ce3cbd7d95b147282.jpg', '2018-07-26 13:13:47', '2018-07-26 13:13:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1171', '313', '2', 'ec3193b1786f723ab08418db1e601478.jpg', '2018-07-26 13:19:27', '2018-07-26 13:19:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1172', '313', '3', '2b2ede554babbcbe6a15c56f06ca3dde.jpg', '2018-07-26 13:19:46', '2018-07-26 13:19:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1173', '455', '2', '88971c4846e0b454842c303005d6cdca.jpg', '2018-07-26 13:20:38', '2018-07-26 13:20:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1174', '455', '3', 'bd5a1dfcd600540fd6438225bbdabfaa.jpg', '2018-07-26 13:20:54', '2018-07-26 13:20:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1175', '278', '2', 'e8b7ace6105231575b7f53b45f6e7efc.jpg', '2018-07-26 13:23:17', '2018-07-26 13:23:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1176', '278', '3', '2aa5da268e2eb3bf31434ef21c15a05b.jpg', '2018-07-26 13:23:48', '2018-07-26 13:23:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1177', '458', '2', 'f85921750a3be4c615737578cac53916.jpg', '2018-07-26 13:33:11', '2018-07-26 13:33:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1178', '458', '2', '65e5b02888ef9554bfdb524fb6b9f8d2.jpg', '2018-07-26 13:33:11', '2018-07-26 13:33:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1179', '458', '3', '350c06c321a6c25391e757809d9f5505.jpg', '2018-07-26 13:33:40', '2018-07-26 13:33:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1180', '489', '2', 'f9a4200c428653030ed27235258002ff.jpg', '2018-07-26 13:37:55', '2018-07-26 13:37:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1181', '489', '3', '168ee6c2a8424daf997483ab64e5acd7.jpg', '2018-07-26 13:38:19', '2018-07-26 13:38:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1182', '165', '2', '6140613324f0e75d797ea5dff0c2d05d.jpg', '2018-07-26 13:51:34', '2018-07-26 13:51:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1183', '165', '3', '5e5efc2ee52c02289538bfd84477c5df.jpg', '2018-07-26 13:51:51', '2018-07-26 13:51:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1184', '165', '3', '90869739a23ba50db93374ec8d7db4d5.jpg', '2018-07-26 13:51:53', '2018-07-26 13:51:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1185', '513', '1', '52d59766fde9c8b35aebce7b2e668b68.jpg', '2018-07-26 16:55:17', '2018-07-26 16:55:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1186', '513', '1', 'be5e996f024c06e6f02e35779997b383.jpg', '2018-07-26 16:55:17', '2018-07-26 16:55:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1187', '513', '1', 'bed177c68908778244f36f0ee7e946e2.jpg', '2018-07-26 16:55:17', '2018-07-26 16:55:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1188', '513', '1', '0dc1102262aeaef6ada8139a75c498c3.jpg', '2018-07-26 16:55:17', '2018-07-26 16:55:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1189', '513', '2', 'b5022e0fda31a809757083150be9cc6c.jpg', '2018-07-26 16:55:41', '2018-07-26 16:55:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1190', '513', '2', 'a9b2ff597191b1bb25a7fcdecc796b23.jpg', '2018-07-26 16:55:41', '2018-07-26 16:55:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1191', '513', '2', '9cb4a38aaa30f2f29cca5c7f081ccb67.jpg', '2018-07-26 16:55:44', '2018-07-26 16:55:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1192', '513', '2', '411e0b834af34a4de352a5b19a356ef2.jpg', '2018-07-26 16:55:44', '2018-07-26 16:55:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1193', '513', '3', 'f8442e535646282965ebfa760bb9ba7f.jpg', '2018-07-26 16:56:22', '2018-07-26 16:56:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1194', '517', '1', '110d2ea16f9112d1c99430259fece785.jpg', '2018-07-27 11:18:53', '2018-07-27 11:18:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1195', '517', '1', '4e1f41535bf27204a303b4c3b0b6008b.jpg', '2018-07-27 11:18:53', '2018-07-27 11:18:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1196', '517', '2', '5d1aac1a05b87fc98666114806531c3b.jpg', '2018-07-27 11:19:12', '2018-07-27 11:19:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1197', '517', '2', '02f678502ec0bbcdcfc240c3594582f6.jpg', '2018-07-27 11:19:12', '2018-07-27 11:19:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1198', '517', '3', 'f668bb1c786e7cc5ed67aa414189f603.jpg', '2018-07-27 11:20:30', '2018-07-27 11:20:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1199', '91', '2', 'd3412c4aa469a12bee79825d11e408d3.jpg', '2018-07-27 12:24:45', '2018-07-27 12:24:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1200', '91', '3', '4f4064d69c47c43b080b02c3a1a99e2d.jpg', '2018-07-27 12:25:20', '2018-07-27 12:25:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1201', '415', '1', '013ba1a5ef102a518d5c96db93ffd17b.jpg', '2018-07-28 11:55:26', '2018-07-28 11:55:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1202', '415', '2', '37d27335c9a6689e04f0a8d738607d9a.jpg', '2018-07-28 11:55:54', '2018-07-28 11:55:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1203', '415', '2', '2a212efb3b6c6e32fa5cea572ecedb2d.jpg', '2018-07-28 11:55:54', '2018-07-28 11:55:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1204', '415', '2', 'e2243c238b1bac149f3e556771c989fb.jpg', '2018-07-28 11:55:54', '2018-07-28 11:55:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1205', '484', '1', '07cdf26d9917525f69d935dede1737bf.jpg', '2018-07-28 12:02:49', '2018-07-28 12:02:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1206', '484', '2', '69ea8ddc36caf43c9575f3ccb382df6f.jpg', '2018-07-28 12:03:04', '2018-07-28 12:03:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1207', '484', '2', '1eb75c1b110cb200e2e544c5b77c722d.jpg', '2018-07-28 12:03:04', '2018-07-28 12:03:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1208', '484', '2', 'df2eab18a80b56fc38045d7aba185c84.jpg', '2018-07-28 12:03:04', '2018-07-28 12:03:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1209', '484', '3', 'bf60ffb4dcbd8cb7f3330c3b6a237a50.jpg', '2018-07-28 12:03:55', '2018-07-28 12:03:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1210', '415', '3', 'f8123e19f473a3d86956b68e467b1f67.jpg', '2018-07-28 12:05:54', '2018-07-28 12:05:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1211', '505', '1', '66481b8b70bfc6384cf20b2243e7788e.jpg', '2018-07-28 12:09:32', '2018-07-28 12:09:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1212', '505', '2', '538672d87b437a8a3653004011e9b071.jpg', '2018-07-28 12:09:50', '2018-07-28 12:09:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1213', '505', '2', 'e8be419ada78ad2eb4114cad7f0424e8.jpg', '2018-07-28 12:09:50', '2018-07-28 12:09:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1214', '505', '2', 'f096cae1b2df6c471ff0525e4c27f272.jpg', '2018-07-28 12:09:50', '2018-07-28 12:09:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1215', '505', '2', '07d4284a38da723e4a9904ed6b6254e4.jpg', '2018-07-28 12:09:50', '2018-07-28 12:09:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1216', '505', '3', '12411196f1d50a0bac438ea999512829.jpg', '2018-07-28 12:10:21', '2018-07-28 12:10:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1217', '514', '1', 'ad1d735265de8a886925025df2d6c9c0.jpg', '2018-07-28 12:12:07', '2018-07-28 12:12:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1218', '514', '2', 'bbef8e84b1831e1712e177244430b79c.jpg', '2018-07-28 12:12:46', '2018-07-28 12:12:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1219', '514', '2', '4b97ae67d5a8a3fab34d0d7b17dfa107.jpg', '2018-07-28 12:12:46', '2018-07-28 12:12:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1220', '514', '2', 'd7d4e4e1d3a73527e13bce2190b5cbc9.jpg', '2018-07-28 12:12:46', '2018-07-28 12:12:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1221', '514', '2', '247bbfd73556b190f547fe8c790c578f.jpg', '2018-07-28 12:12:46', '2018-07-28 12:12:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1222', '514', '3', '1d6afa81475c4b077163b6484a45f87f.jpg', '2018-07-28 12:13:33', '2018-07-28 12:13:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1223', '511', '1', 'ce0f0d616d30be71e213533a56a225c7.jpg', '2018-07-28 12:14:12', '2018-07-28 12:14:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1224', '511', '2', 'ee9512834c05112b742dafdbbdd530de.jpg', '2018-07-28 12:14:39', '2018-07-28 12:14:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1225', '511', '2', '1e9a6eb1d004b18ae238d9984454eb15.jpg', '2018-07-28 12:14:39', '2018-07-28 12:14:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1226', '511', '2', '88db051d7104157a7c1b1352f053bd9e.jpg', '2018-07-28 12:14:39', '2018-07-28 12:14:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1227', '511', '3', '6c2f58fbf153eda8963080499fb63586.jpg', '2018-07-28 12:15:22', '2018-07-28 12:15:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1228', '129', '1', '59584c481a6fecad4b8389b0fcc8f9a7.jpg', '2018-07-30 11:58:33', '2018-07-30 11:58:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1229', '129', '1', 'cfaebd5b6af483f53e8a5c5e59cd2fe3.jpg', '2018-07-30 11:58:33', '2018-07-30 11:58:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1230', '129', '2', 'e9b59b7e7f8c4449a6d12379ca4b33e6.jpg', '2018-07-30 11:59:02', '2018-07-30 11:59:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1231', '129', '2', '36d517b539c847539bd6ce57d42f9f62.jpg', '2018-07-30 11:59:02', '2018-07-30 11:59:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1232', '129', '2', 'ae2c87773106bd356cad96d698dc5aaa.jpg', '2018-07-30 11:59:02', '2018-07-30 11:59:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1233', '129', '2', '7a033393d7d1a0c194307b0158eadf50.jpg', '2018-07-30 11:59:02', '2018-07-30 11:59:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1234', '129', '3', 'ca52c07ba9f78decadf85de219e252dd.jpg', '2018-07-30 12:01:59', '2018-07-30 12:01:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1235', '556', '1', 'b55de52fae3e2268af33bea36be263a4.jpg', '2018-07-30 12:03:52', '2018-07-30 12:03:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1236', '556', '1', '34c4e284ab15cb8cff03a899ffe244ac.jpg', '2018-07-30 12:03:52', '2018-07-30 12:03:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1237', '556', '2', '5ca80687e5f3a2f9fc997eb9a3e4a471.jpg', '2018-07-30 12:04:39', '2018-07-30 12:04:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1238', '556', '2', '15d4d010596c57e474a83f371cfd2a01.jpg', '2018-07-30 12:04:39', '2018-07-30 12:04:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1239', '556', '2', '3bdf4e26df6e339914a9b62cc4fceaee.jpg', '2018-07-30 12:04:39', '2018-07-30 12:04:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1240', '556', '2', 'fa31879326379502f2f8a6c280f248ab.jpg', '2018-07-30 12:04:39', '2018-07-30 12:04:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1241', '556', '3', 'a77c599d092b46a6e87f0c6eb097b7d6.jpg', '2018-07-30 12:05:13', '2018-07-30 12:05:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1242', '473', '1', 'c201c223ab80593791e17599d4264fe1.jpg', '2018-07-30 12:21:58', '2018-07-30 12:21:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1243', '473', '2', '33ec3a049581fd57415758dd1d2ec91a.jpg', '2018-07-30 12:22:28', '2018-07-30 12:22:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1244', '473', '2', '04838c2e337b43f2b9d9a55ed48e0c2d.jpg', '2018-07-30 12:22:28', '2018-07-30 12:22:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1245', '473', '2', 'c5a3e2494d941359f61dcf9028a6d2ae.jpg', '2018-07-30 12:22:28', '2018-07-30 12:22:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1246', '473', '2', '125a61c86880474f4da4a00835b4ddbf.jpg', '2018-07-30 12:22:28', '2018-07-30 12:22:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1247', '473', '2', 'dcd77d503e1d962fefc9fc06d26b5f80.jpg', '2018-07-30 12:22:28', '2018-07-30 12:22:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1248', '473', '3', 'd24758bd615ed7e450e3a944694e0034.jpg', '2018-07-30 12:22:48', '2018-07-30 12:22:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1249', '510', '1', '54f831187bb9a28f6daf579ced8df72c.jpg', '2018-07-31 11:09:46', '2018-07-31 11:09:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1250', '510', '1', '5a0be1dcfc79d7f40b3a2abf1a0d79fa.jpg', '2018-07-31 11:09:46', '2018-07-31 11:09:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1251', '510', '2', '3d8aefb17bc2c69a0b93c85c5700dcb8.jpg', '2018-07-31 11:10:09', '2018-07-31 11:10:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1252', '510', '2', 'e22c11a9750d0df723bda456867a7231.jpg', '2018-07-31 11:10:09', '2018-07-31 11:10:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1253', '510', '2', '84e29905eb68f0bdaa30b7243855dba2.jpg', '2018-07-31 11:10:09', '2018-07-31 11:10:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1254', '510', '3', '2a04ee350419450ecc9438878c51186d.jpg', '2018-07-31 11:13:11', '2018-07-31 11:13:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1255', '512', '1', 'b1da042e650824306a6143cd7a0d1edb.jpg', '2018-07-31 11:32:47', '2018-07-31 11:32:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1256', '512', '2', '3e619d9f8fceebc34e096653c3469ad5.jpg', '2018-07-31 11:32:56', '2018-07-31 11:32:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1257', '512', '3', 'ecdd59ed64f2ffbde037de9f8cae3b1c.jpg', '2018-07-31 11:33:49', '2018-07-31 11:33:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1258', '508', '1', '6c131aa15ad178164489be3455770687.jpg', '2018-07-31 11:49:44', '2018-07-31 11:49:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1259', '508', '1', '01f5694e67392f1f6725841218be249b.jpg', '2018-07-31 11:49:44', '2018-07-31 11:49:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1260', '508', '2', 'b96234e3e07627458075e006d50057d3.jpg', '2018-07-31 11:50:01', '2018-07-31 11:50:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1261', '508', '2', 'bdbbaa282b8867e27deacb7eaeeea57f.jpg', '2018-07-31 11:50:01', '2018-07-31 11:50:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1262', '508', '3', 'a31e81209cb77393506f6e0281f1b1cd.jpg', '2018-07-31 11:51:11', '2018-07-31 11:51:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1263', '584', '1', 'a917810e38c135eb6b32a4d23fe45a35.jpg', '2018-07-31 14:36:05', '2018-07-31 14:36:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1264', '584', '1', '743e94abdc4a0bcd203be850e6599e8b.jpg', '2018-07-31 14:36:05', '2018-07-31 14:36:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1265', '584', '2', 'a35a6ac337bf9930f261215e819fd02e.jpg', '2018-07-31 14:36:30', '2018-07-31 14:36:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1266', '584', '3', '19395ef41676ca3df19186a34f91053a.jpg', '2018-07-31 14:41:28', '2018-07-31 14:41:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1267', '559', '1', '8d620ccd07b3bd73b36b88c704d727d8.jpg', '2018-08-01 10:19:33', '2018-08-01 10:19:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1268', '559', '2', '7fc41013c6086554706fbb71ee96adee.jpg', '2018-08-01 10:19:45', '2018-08-01 10:19:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1269', '559', '3', '5f22ec5eb133d271bc4fcb789b901525.jpg', '2018-08-01 10:21:43', '2018-08-01 10:21:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1270', '500', '1', 'cb53d76a88b47f4a7ae12621039038e4.jpg', '2018-08-01 11:07:03', '2018-08-01 11:07:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1271', '500', '2', 'cad8e3fd090abeb3b775d0bc90129369.jpg', '2018-08-01 11:07:22', '2018-08-01 11:07:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1272', '500', '3', 'd5ac9bbb73b4de812836a730c2f5ff11.jpg', '2018-08-01 11:07:48', '2018-08-01 11:07:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1273', '498', '1', '7ee0eb008a68a90f54da17eee0e7e4ad.jpg', '2018-08-01 11:09:25', '2018-08-01 11:09:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1274', '498', '2', 'd8a631d46df24569a03ff2b460bf2640.jpg', '2018-08-01 11:09:36', '2018-08-01 11:09:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1275', '498', '3', '94fea7e7a441949795a86a7f5567504d.jpg', '2018-08-01 11:10:01', '2018-08-01 11:10:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1276', '497', '1', '06b1b0d6a28823707d7050b702b7b985.jpg', '2018-08-01 11:10:40', '2018-08-01 11:10:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1277', '497', '2', '8f0827b1f07c506e04e55e3483d9dbd4.jpg', '2018-08-01 11:10:57', '2018-08-01 11:10:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1278', '497', '3', 'd49f525720abaa508b85328b6e556f86.jpg', '2018-08-01 11:22:23', '2018-08-01 11:22:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1279', '578', '1', 'a3a733a7755398bf831febbb2fd08e7d.jpg', '2018-08-01 11:23:44', '2018-08-01 11:23:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1280', '578', '2', 'a4e6d1cc8a7876d7d1262342d15220ec.jpg', '2018-08-01 11:23:53', '2018-08-01 11:23:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1281', '578', '3', 'bd0d637efc9099cc04eb6bdea3155d6d.jpg', '2018-08-01 11:24:50', '2018-08-01 11:24:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1282', '553', '1', 'b0c5b54557ce943c5a3edfcf2417bb07.jpg', '2018-08-01 11:48:58', '2018-08-01 11:48:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1283', '553', '1', 'ae9c25053effab0140cafdbfac3fb36a.jpg', '2018-08-01 11:48:58', '2018-08-01 11:48:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1284', '553', '1', 'b668a2e64c6e2b1e62dbc893bd10d283.jpg', '2018-08-01 11:48:58', '2018-08-01 11:48:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1285', '553', '2', '1172e4fc0ac99cdf1d7b0d14ba12c1e8.jpg', '2018-08-01 11:49:31', '2018-08-01 11:49:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1286', '553', '2', 'cfbf58dd4baf21ee1db5e63e099d0b1e.jpg', '2018-08-01 11:49:31', '2018-08-01 11:49:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1287', '553', '2', 'b8c035dbbf08d8ff322d2ba965f8d45e.jpg', '2018-08-01 11:49:31', '2018-08-01 11:49:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1288', '553', '2', '19122ed1ed770bf6c66e744fedd00291.jpg', '2018-08-01 11:49:31', '2018-08-01 11:49:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1289', '553', '2', '7b9004d3a3e5cddae9620c79329c2851.jpg', '2018-08-01 11:49:31', '2018-08-01 11:49:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1290', '553', '3', '58e8eba99ce858a80920abfd087ebc48.jpg', '2018-08-01 11:53:26', '2018-08-01 11:53:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1291', '589', '1', '71ca792c29872a833fb0aa97ed5bf85c.jpg', '2018-08-01 13:30:44', '2018-08-01 13:30:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1292', '589', '1', '2e47c91b3ecc0cd33d960744e76be2f9.jpg', '2018-08-01 13:30:44', '2018-08-01 13:30:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1293', '589', '2', '214be387faa1377d0cef5541024d1924.jpg', '2018-08-01 13:31:15', '2018-08-01 13:31:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1294', '589', '2', '6b2caa98e45c0d3fadf7211d5556e261.jpg', '2018-08-01 13:31:15', '2018-08-01 13:31:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1295', '589', '2', 'b74dec1ed7577ab7a730dd324dfeac3f.jpg', '2018-08-01 13:31:15', '2018-08-01 13:31:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1296', '589', '2', 'b83a481f34cc7976475ef625787d1a06.jpg', '2018-08-01 13:31:15', '2018-08-01 13:31:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1297', '589', '3', '2d15bf82c3c30ad7ccd4628816add1a3.jpg', '2018-08-01 13:32:36', '2018-08-01 13:32:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1298', '587', '1', 'a342e3e0e9dcecf50b6e8c57450aeab4.jpg', '2018-08-01 17:06:38', '2018-08-01 17:06:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1299', '587', '1', 'c10ea26aa8cba3dea285a4a14814a0c7.jpg', '2018-08-01 17:06:38', '2018-08-01 17:06:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1300', '587', '1', 'ff1ebaff68a2f65bca102e3588a70ec1.jpg', '2018-08-01 17:06:38', '2018-08-01 17:06:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1301', '587', '2', '848c7ea13ed2f8415df3a2f4cca41df9.jpg', '2018-08-01 17:07:10', '2018-08-01 17:07:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1302', '587', '2', 'c8e204343a5b4b4aa97ed566f5569d24.jpg', '2018-08-01 17:07:10', '2018-08-01 17:07:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1303', '587', '2', 'd4aa5a141a762737eb0db387752d66ba.jpg', '2018-08-01 17:07:10', '2018-08-01 17:07:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1304', '587', '2', '8ad4e2adb520c2c76431fcf20f7e52a0.jpg', '2018-08-01 17:07:10', '2018-08-01 17:07:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1305', '587', '3', 'b39a0b9d89d18477b9abdd590bd6351c.jpg', '2018-08-01 17:19:46', '2018-08-01 17:19:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1306', '587', '3', '6e0836c45391fb923782381494c10215.jpg', '2018-08-01 17:19:51', '2018-08-01 17:19:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1307', '588', '1', '4901dc044dbf8514c4ab3a77b73e518d.jpg', '2018-08-02 08:33:48', '2018-08-02 08:33:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1308', '588', '1', '140247130f7da76a5789be139be849d7.jpg', '2018-08-02 08:33:48', '2018-08-02 08:33:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1309', '588', '2', 'd4f1dfd5ce63cbf0f81afd72f5d7eeed.jpg', '2018-08-02 08:34:01', '2018-08-02 08:34:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1310', '588', '3', 'efe61492c2eed101248767c78fd47438.jpg', '2018-08-02 08:35:15', '2018-08-02 08:35:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1311', '590', '1', '3eafa0c73add30dfbe384e09446cda81.jpg', '2018-08-02 09:42:52', '2018-08-02 09:42:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1312', '590', '1', '9f20c335943257a0133c2134bb44e57c.jpg', '2018-08-02 09:42:52', '2018-08-02 09:42:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1313', '590', '2', '906bba72ceaf468e60f7db2709b0b1b3.jpg', '2018-08-02 09:43:22', '2018-08-02 09:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1314', '590', '2', 'c6fef8530e9023c3a4356b5f423083af.jpg', '2018-08-02 09:43:22', '2018-08-02 09:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1315', '590', '2', '808978c0bc8b3b8ba9ad8ffdd99dc2f7.jpg', '2018-08-02 09:43:22', '2018-08-02 09:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1316', '590', '2', '2e9e3abc84eba89858fc80879997f1d7.jpg', '2018-08-02 09:43:22', '2018-08-02 09:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1317', '590', '3', '657e88c0986c605f36aa9c1c071b10d9.jpg', '2018-08-02 09:46:04', '2018-08-02 09:46:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1318', '564', '1', '0f8e735e2f95c9a2dea02cb714da3277.jpg', '2018-08-02 10:45:08', '2018-08-02 10:45:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1319', '564', '1', 'ba503feb2c3000339656c36857d3c127.jpg', '2018-08-02 10:45:08', '2018-08-02 10:45:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1320', '564', '1', '43be96d386f372a734bf7f1bd3828929.jpg', '2018-08-02 10:45:08', '2018-08-02 10:45:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1321', '564', '2', '26b4e32e42eda1cc83e97307110aa250.jpg', '2018-08-02 10:45:33', '2018-08-02 10:45:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1322', '564', '2', 'cc8e390f3ac04fad2072493611a0ff6b.jpg', '2018-08-02 10:45:33', '2018-08-02 10:45:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1323', '564', '2', 'e611552f675ace613b1589fdb6b977a8.jpg', '2018-08-02 10:45:33', '2018-08-02 10:45:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1324', '564', '3', 'e105a7c85bf088df1721da5b54e7d13c.jpg', '2018-08-02 10:47:12', '2018-08-02 10:47:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1325', '576', '1', '8b66dfba1594041205e311c329f0f588.jpg', '2018-08-02 11:05:04', '2018-08-02 11:05:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1326', '576', '1', 'e485a3b677752eac1e8fef67c5754577.jpg', '2018-08-02 11:05:04', '2018-08-02 11:05:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1327', '576', '1', '564e3876233634ae195903f1e171255d.jpg', '2018-08-02 11:05:04', '2018-08-02 11:05:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1328', '576', '1', '6ede5c974fd7f48c239490aedfaa21ef.jpg', '2018-08-02 11:05:04', '2018-08-02 11:05:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1329', '576', '1', 'bf86bcec085ae77e4712e91bd82cbbb1.jpg', '2018-08-02 11:05:04', '2018-08-02 11:05:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1330', '576', '1', 'dd0bd1ad127884298aa5278ad835dcee.jpg', '2018-08-02 11:05:04', '2018-08-02 11:05:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1331', '576', '2', 'c0679e0822b19629022b8b3e950483de.jpg', '2018-08-02 11:06:17', '2018-08-02 11:06:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1332', '576', '2', '724e19bd4affd53269ff07ac4bc0a024.jpg', '2018-08-02 11:06:17', '2018-08-02 11:06:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1333', '576', '2', 'a52ed1b29f0725070215f43e46cecf89.jpg', '2018-08-02 11:06:17', '2018-08-02 11:06:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1334', '576', '2', '4d4f2e628ecfb84bd4855005cd7b98ee.jpg', '2018-08-02 11:06:17', '2018-08-02 11:06:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1335', '576', '3', '460d83e76712df1e1b3f89c7ae675603.jpg', '2018-08-02 11:07:08', '2018-08-02 11:07:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1336', '567', '1', '3b5d3082108c41eae40d14ee6a4e69fe.jpg', '2018-08-02 11:16:01', '2018-08-02 11:16:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1337', '567', '1', '70420d1ab747b3ba98ee8b8629ee4a18.jpg', '2018-08-02 11:16:01', '2018-08-02 11:16:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1338', '567', '2', '654edeca70cd8143747044a940b9b9f5.jpg', '2018-08-02 11:16:28', '2018-08-02 11:16:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1339', '567', '3', 'dd476ab69ee067ef93e98437d34d89f7.jpg', '2018-08-02 11:18:14', '2018-08-02 11:18:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1340', '579', '1', 'c0ea5ac20a502d4e106fc416f3c9c568.jpg', '2018-08-02 11:26:51', '2018-08-02 11:26:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1341', '579', '2', 'b46649942c072fbd2093cb802c5fd86e.jpg', '2018-08-02 11:27:04', '2018-08-02 11:27:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1342', '579', '3', 'c6f790072f2a3d6af1d41b99c22f3b80.jpg', '2018-08-02 11:29:13', '2018-08-02 11:29:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1343', '374', '3', 'e64a74fab92033b7015c673ca637086a.jpg', '2018-08-02 15:08:24', '2018-08-02 15:08:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1344', '537', '1', '92b080a2a74ca867740c00bde8e768ca.jpg', '2018-08-02 15:09:11', '2018-08-02 15:09:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1345', '537', '2', '7b96bf5312ba465e9c4bf39604d94fb9.jpg', '2018-08-02 15:09:20', '2018-08-02 15:09:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1346', '537', '3', '0fc5074cf2838c9fdb10181f83fe0577.jpg', '2018-08-02 15:09:53', '2018-08-02 15:09:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1347', '602', '1', '99c8bb639d12194ab88282ef8301f0ba.jpg', '2018-08-03 12:52:05', '2018-08-03 12:52:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1348', '602', '2', 'e94136d48c45238193f1a4df4a2e6e59.jpg', '2018-08-03 12:52:26', '2018-08-03 12:52:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1349', '602', '3', 'e7727ff5efffb6e8880e390453104747.jpg', '2018-08-03 12:53:15', '2018-08-03 12:53:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1350', '438', '1', '0017243a9e4b3217d51e559913949cd2.jpg', '2018-08-03 15:19:52', '2018-08-03 15:19:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1351', '438', '2', 'c402d59c3a8badc687cb95291f44010f.jpg', '2018-08-03 15:20:07', '2018-08-03 15:20:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1352', '438', '3', 'cd715b9308893a51b87c70eb4acb287c.jpg', '2018-08-03 15:21:27', '2018-08-03 15:21:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1353', '221', '1', 'a7c2ad4cabf54dda1bd370a3714868c6.jpg', '2018-08-03 15:27:53', '2018-08-03 15:27:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1354', '221', '2', '66ebf25d66e333cdb351eaf5190c17c0.jpg', '2018-08-03 15:28:04', '2018-08-03 15:28:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1355', '221', '3', 'f2b272fb99b28093d1006b75bb58b7d8.jpg', '2018-08-03 15:28:42', '2018-08-03 15:28:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1356', '461', '1', '096790714434531f5875a49dcfdb2d24.jpg', '2018-08-03 15:31:35', '2018-08-03 15:31:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1357', '461', '2', 'f94c4f02a4aa8cef3e137c05577f3ecf.jpg', '2018-08-03 15:31:48', '2018-08-03 15:31:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1358', '461', '3', 'c0940af2408ad16dd48329124c3829e2.jpg', '2018-08-03 15:33:05', '2018-08-03 15:33:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1359', '496', '1', '79e5ae6981fdaef1bf1049348c447d91.jpg', '2018-08-03 15:35:00', '2018-08-03 15:35:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1360', '496', '2', '59203a0206cdc7a531c522dca5081310.jpg', '2018-08-03 15:35:15', '2018-08-03 15:35:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1361', '496', '3', '47726d49c848a793c3346b7f91f7c8f5.jpg', '2018-08-03 15:36:21', '2018-08-03 15:36:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1362', '596', '1', 'cc71595088412908e2637c83d7be94f8.jpg', '2018-08-06 08:56:27', '2018-08-06 08:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1363', '596', '1', 'e9e7ba82a15ea19c3d49900efbb6161a.jpg', '2018-08-06 08:56:27', '2018-08-06 08:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1364', '596', '1', '8351ee8922dffac215a783ae0fa09b21.jpg', '2018-08-06 08:56:27', '2018-08-06 08:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1365', '596', '1', 'b5ee52366732f60b508854abe1814e69.jpg', '2018-08-06 08:56:27', '2018-08-06 08:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1366', '596', '1', '72f82ce1e27d3a1b41f0cf80f54e7bc8.jpg', '2018-08-06 08:56:27', '2018-08-06 08:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1367', '596', '2', 'ee87277d503134be571df373bfca20eb.jpg', '2018-08-06 08:58:41', '2018-08-06 08:58:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1368', '596', '2', '5d35f88f0229354f7f0989befc07177c.jpg', '2018-08-06 08:58:41', '2018-08-06 08:58:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1369', '596', '2', '1dec741a2ec2922a0333c0908697b990.jpg', '2018-08-06 08:58:41', '2018-08-06 08:58:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1370', '601', '1', '2df4581c3b46feb3012d5509a44ff2d7.jpg', '2018-08-06 10:07:07', '2018-08-06 10:07:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1371', '601', '2', 'e5d74bebdcdc8b9a3b031ae68a22b618.jpg', '2018-08-06 10:07:20', '2018-08-06 10:07:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1372', '601', '2', '0176e2a9e43b11837ee3fc98914cf4c2.jpg', '2018-08-06 10:07:20', '2018-08-06 10:07:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1373', '601', '3', '5102eaa5ef3434f375f1c12cb2b4e0f7.jpg', '2018-08-06 10:08:07', '2018-08-06 10:08:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1374', '487', '1', 'e153ba390ed8031cbe11823dda17413d.jpg', '2018-08-06 10:43:47', '2018-08-06 10:43:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1375', '487', '1', '95c0aef96c9444281490944a5f75f370.jpg', '2018-08-06 10:43:47', '2018-08-06 10:43:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1376', '487', '1', '908d27c5af2b249106eea62c5deaa331.jpg', '2018-08-06 10:43:47', '2018-08-06 10:43:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1377', '487', '2', 'd21b059a96e363db3d198bd6e8cd7920.jpg', '2018-08-06 10:44:46', '2018-08-06 10:44:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1378', '487', '2', '6daa2aea20aac29cde8a26c1b5ab07bd.jpg', '2018-08-06 10:44:46', '2018-08-06 10:44:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1379', '487', '2', 'c326553c4ee4b2b3cc8cac57cf59f6c1.jpg', '2018-08-06 10:44:46', '2018-08-06 10:44:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1380', '487', '2', '73ea6d8322a803de792e9ce479abec9b.jpg', '2018-08-06 10:44:46', '2018-08-06 10:44:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1381', '487', '3', '8201b5bca4d23abb7aab7e0d13642b3c.jpg', '2018-08-06 10:46:08', '2018-08-06 10:46:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1382', '428', '1', '1d324b025ee49b36946d1c9c28ea64ed.jpg', '2018-08-06 10:49:59', '2018-08-06 10:49:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1383', '428', '1', '5670fda73df2be69488cb3385adf8723.jpg', '2018-08-06 10:49:59', '2018-08-06 10:49:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1384', '428', '2', '11f3195293d70a9e72009ff2857bd6cc.jpg', '2018-08-06 10:50:25', '2018-08-06 10:50:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1385', '428', '2', '1e4559c7ac93d095e1cab2a150b7f924.jpg', '2018-08-06 10:50:25', '2018-08-06 10:50:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1386', '428', '3', 'c2d6a2d8de61e81386137b62ff2ea083.jpg', '2018-08-06 10:51:27', '2018-08-06 10:51:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1387', '583', '1', '4478eaae1a0b72a396b0e513ca0994d7.jpg', '2018-08-06 10:58:00', '2018-08-06 10:58:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1388', '583', '2', 'b03a369e4a5f070c9d2e75c2a89e2ac4.jpg', '2018-08-06 10:58:18', '2018-08-06 10:58:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1389', '613', '1', 'e54b908e7f1fc9c4ab2005c880b73e82.jpg', '2018-08-06 10:59:41', '2018-08-06 10:59:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1390', '613', '2', '88435e002347ca9d063138c6473babf0.jpg', '2018-08-06 10:59:56', '2018-08-06 10:59:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1391', '613', '3', 'cd0313a3dec343cfbba9db6740be2d0a.jpg', '2018-08-06 11:01:17', '2018-08-06 11:01:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1392', '583', '3', '8f8f0218dfa1331c27089f3dee7d919d.jpg', '2018-08-06 11:02:56', '2018-08-06 11:02:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1393', '606', '1', 'aaa09f472ffa7cc3d0aeba0862089b55.jpg', '2018-08-06 11:53:46', '2018-08-06 11:53:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1394', '606', '1', '2afcc316d9518d47d8baea4de2f67a12.jpg', '2018-08-06 11:53:46', '2018-08-06 11:53:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1395', '606', '1', 'a3b92ca0f343f9e30a60999e5d362e23.jpg', '2018-08-06 11:53:46', '2018-08-06 11:53:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1396', '606', '2', '27239a2c53b810b1bca6a9dbed07106c.jpg', '2018-08-06 11:54:20', '2018-08-06 11:54:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1397', '606', '2', '2b1c973df1391a86d74771ba3d22a2d7.jpg', '2018-08-06 11:54:20', '2018-08-06 11:54:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1398', '606', '2', '52e35489799d7ef017003ade1453757f.jpg', '2018-08-06 11:54:20', '2018-08-06 11:54:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1399', '606', '3', '87c035436ad614bad40d0666fa7d9918.jpg', '2018-08-06 11:57:33', '2018-08-06 11:57:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1400', '615', '1', '2a4c263b4f9d04bbcccb074c459efa76.jpg', '2018-08-06 11:58:00', '2018-08-06 11:58:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1401', '615', '2', '1e79686aace41899e6a58a426f992755.jpg', '2018-08-06 11:58:16', '2018-08-06 11:58:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1402', '615', '2', '3b218c867fdc0821312e4f75b31c6f1f.jpg', '2018-08-06 11:58:16', '2018-08-06 11:58:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1403', '615', '2', '55637cd470ff068f6583e514ccb291e4.jpg', '2018-08-06 11:58:16', '2018-08-06 11:58:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1404', '615', '3', 'd1326469432336702244c41137c2794b.jpg', '2018-08-06 11:58:43', '2018-08-06 11:58:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1405', '542', '1', '6f9d596290b7f6a7328b778e58bd1aca.jpg', '2018-08-06 18:55:14', '2018-08-06 18:55:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1406', '625', '1', '3bf36ca24049bdc0a8aa649d64f2ae67.jpg', '2018-08-07 09:55:21', '2018-08-07 09:55:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1407', '625', '1', '32c640eb1427aa7e9c97ed8486f7b4eb.jpg', '2018-08-07 09:55:21', '2018-08-07 09:55:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1408', '625', '2', 'bfe05aae7f9fd45acb776c14c91eb152.jpg', '2018-08-07 09:55:42', '2018-08-07 09:55:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1409', '625', '2', 'd4a802475527b8fcba2637ea29f0fb44.jpg', '2018-08-07 09:55:42', '2018-08-07 09:55:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1410', '625', '2', '2f6c51e2b968ef5e1fa89337e41639d8.jpg', '2018-08-07 09:55:42', '2018-08-07 09:55:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1411', '625', '2', '6d6b28652a42dac215a5c4eac6e2c04f.jpg', '2018-08-07 09:55:42', '2018-08-07 09:55:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1412', '625', '3', 'c97915cc00c54611341574e3e0f9cd17.jpg', '2018-08-07 10:00:03', '2018-08-07 10:00:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1413', '626', '1', 'fead7ef9c2048e470cf6c4063a97da2f.jpg', '2018-08-07 10:00:26', '2018-08-07 10:00:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1414', '626', '2', '918871d2da5e16b761ea26f11848cc08.jpg', '2018-08-07 10:00:43', '2018-08-07 10:00:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1415', '626', '2', '01c0ba3fa01fa54f61355385b6bede47.jpg', '2018-08-07 10:00:43', '2018-08-07 10:00:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1416', '626', '2', 'ef74a1ba4637669c570c4f73aa641e92.jpg', '2018-08-07 10:00:43', '2018-08-07 10:00:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1417', '626', '2', '54f3c0551f2066ee65beaec9eb505574.jpg', '2018-08-07 10:00:43', '2018-08-07 10:00:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1418', '626', '3', '3588654b5b459fc376fe0575c6ba736f.jpg', '2018-08-07 10:01:06', '2018-08-07 10:01:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1419', '542', '2', '152e95979fa754e72bcfba9e2baeca36.jpg', '2018-08-07 11:30:13', '2018-08-07 11:30:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1420', '542', '3', '76fa3f6cadbe1e855ad318778f8234a2.jpg', '2018-08-07 11:34:17', '2018-08-07 11:34:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1421', '622', '1', '881e361fa587f4d06370343236c5a032.jpg', '2018-08-07 11:36:15', '2018-08-07 11:36:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1422', '622', '2', '00c7cd8bec4240a8ee935f5fb2555f2c.jpg', '2018-08-07 11:36:30', '2018-08-07 11:36:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1423', '622', '3', '5fc654886b624130ff29fd804366a771.jpg', '2018-08-07 11:49:30', '2018-08-07 11:49:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1424', '577', '1', '3d15819ecd407ae4b357e85724d47b45.jpg', '2018-08-07 11:51:57', '2018-08-07 11:51:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1425', '577', '2', 'dc4a99ad1eec6db3675970b50580c4f5.jpg', '2018-08-07 11:52:49', '2018-08-07 11:52:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1426', '577', '2', '499df3d29cfcd168d283ee0af8d6af84.jpg', '2018-08-07 11:52:49', '2018-08-07 11:52:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1427', '577', '2', 'b37e802c18253c6139ecc400dea4baca.jpg', '2018-08-07 11:52:49', '2018-08-07 11:52:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1428', '577', '3', '503b68f8b6d5d74630aa903204ba5d77.jpg', '2018-08-07 11:58:10', '2018-08-07 11:58:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1429', '627', '1', 'a8b15affea9a28011aa8ff2c3b97536f.jpg', '2018-08-07 11:58:38', '2018-08-07 11:58:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1430', '627', '2', '897ffd8d7ca50602a6448dcf6ea9a37e.jpg', '2018-08-07 11:59:20', '2018-08-07 11:59:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1431', '627', '2', '54e29c82ef48a034d44e40b677a9e780.jpg', '2018-08-07 11:59:20', '2018-08-07 11:59:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1432', '627', '2', '50b8d43e719783abcaeefc5354552205.jpg', '2018-08-07 11:59:20', '2018-08-07 11:59:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1433', '627', '2', '46e39a6240607be154501d62d892d2b3.jpg', '2018-08-07 11:59:20', '2018-08-07 11:59:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1434', '627', '3', '60e9df231c2bd8253953012fe99d9855.jpg', '2018-08-07 11:59:44', '2018-08-07 11:59:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1435', '614', '1', '1da6d0834614b7b890f4b092dac084f7.jpg', '2018-08-07 12:36:44', '2018-08-07 12:36:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1436', '614', '1', 'f5b6c45ae60a8e8022ebf1cff27b9f9b.jpg', '2018-08-07 12:36:44', '2018-08-07 12:36:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1437', '614', '2', '88b1bbb28b04d5f88e336253c18ed78a.jpg', '2018-08-07 12:38:48', '2018-08-07 12:38:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1438', '614', '2', 'b49fd6cd73acebf5634ac981596c0e2d.jpg', '2018-08-07 12:38:48', '2018-08-07 12:38:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1439', '614', '2', '4e2b66296bef036c00b99508b659bb1c.jpg', '2018-08-07 12:38:48', '2018-08-07 12:38:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1440', '614', '2', '711e82ea0a7731f53f8e4f41b80e81c8.jpg', '2018-08-07 12:38:48', '2018-08-07 12:38:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1441', '614', '3', 'afe5e8e9870366b72c2cf3d7a17eed32.jpg', '2018-08-07 12:40:53', '2018-08-07 12:40:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1442', '623', '1', 'a1aea36e8e3d2b553f8044b3d51eb803.jpg', '2018-08-07 16:21:14', '2018-08-07 16:21:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1443', '623', '1', '043f264b7d1556af4866fbd3884fa4d8.jpg', '2018-08-07 16:21:14', '2018-08-07 16:21:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1444', '623', '2', '47329c8080d9eb10ec4d611657f1b334.jpg', '2018-08-07 16:21:36', '2018-08-07 16:21:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1445', '623', '2', '4de59c7a7de5836f7a466a8322ff7d35.jpg', '2018-08-07 16:21:36', '2018-08-07 16:21:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1446', '623', '2', 'e8b042b022eedc635f183e1e40a52ccd.jpg', '2018-08-07 16:21:36', '2018-08-07 16:21:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1447', '623', '2', 'c90a713342ea3ff640bdbfa58a8bccee.jpg', '2018-08-07 16:21:36', '2018-08-07 16:21:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1448', '623', '3', 'ff51c4dc2ec4fdb34728c78f38e53336.jpg', '2018-08-07 16:26:45', '2018-08-07 16:26:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1449', '442', '1', '13c336e22d88406fd5398cfe7f1d18a2.jpg', '2018-08-08 11:54:19', '2018-08-08 11:54:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1450', '442', '2', 'e87bc527b896ae0db1465df73d178265.jpg', '2018-08-08 11:54:30', '2018-08-08 11:54:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1451', '442', '3', '605bee6223b5a208cf94b71820f0ee97.jpg', '2018-08-08 11:55:28', '2018-08-08 11:55:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1452', '442', '3', '45c337eb6988666827fda686b02dcb74.jpg', '2018-08-08 11:55:32', '2018-08-08 11:55:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1453', '472', '1', '793cbdb32ca01c7624a23f4740ef4174.jpg', '2018-08-08 13:45:41', '2018-08-08 13:45:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1454', '472', '2', 'b12badcadbccd660cae73cee34aba2de.jpg', '2018-08-08 13:45:54', '2018-08-08 13:45:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1455', '472', '3', '67c9820741a217bd3faaf1b46652b044.jpg', '2018-08-08 13:46:34', '2018-08-08 13:46:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1456', '527', '1', '2f04ddd7762a756604a1375bc61b5e33.jpg', '2018-08-08 14:04:42', '2018-08-08 14:04:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1457', '527', '2', 'f665222716bd82d2693942afcf8bed80.jpg', '2018-08-08 14:05:07', '2018-08-08 14:05:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1458', '527', '3', '8085645873b19c89e3419c6f0efd0db6.jpg', '2018-08-08 14:07:26', '2018-08-08 14:07:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1459', '645', '1', '4694f2207b2c6188bdd95020a9fb15ee.jpg', '2018-08-08 15:48:48', '2018-08-08 15:48:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1460', '645', '1', '4c1861a56bc7b3434b5e122a9435d3cb.jpg', '2018-08-08 15:48:48', '2018-08-08 15:48:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1461', '645', '1', '535abd037662de893e5ab25009c25ede.jpg', '2018-08-08 15:48:48', '2018-08-08 15:48:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1462', '645', '1', '4bcda952d9d14d04da17cdefd8b8bc63.jpg', '2018-08-08 15:48:48', '2018-08-08 15:48:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1463', '645', '2', '692bf214e63eb52438ab33cd03b6dc84.jpg', '2018-08-08 15:49:34', '2018-08-08 15:49:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1464', '645', '2', '3e395c1f42677003eeadaf87b5939a54.jpg', '2018-08-08 15:49:34', '2018-08-08 15:49:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1465', '645', '2', '346d49755725716f2e6167a068f35762.jpg', '2018-08-08 15:49:34', '2018-08-08 15:49:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1466', '645', '2', 'fb3dac5c57878fc3cad92a713b61b567.jpg', '2018-08-08 15:49:34', '2018-08-08 15:49:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1467', '645', '2', '7ae2473eff4366821bad0c48e979a5f6.jpg', '2018-08-08 15:49:34', '2018-08-08 15:49:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1468', '645', '3', '5e97a460640cb7b288b514aea7bbd619.jpg', '2018-08-08 15:51:33', '2018-08-08 15:51:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1469', '655', '1', 'bf4f50c34835ff02b71f7dd061473eec.jpg', '2018-08-09 10:33:50', '2018-08-09 10:33:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1470', '655', '2', '3946708621c3ab53f4ce5b35ba6f6bff.jpg', '2018-08-09 10:34:07', '2018-08-09 10:34:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1471', '655', '3', '697d21b5e51ec3881b882695367f16f3.jpg', '2018-08-09 10:34:38', '2018-08-09 10:34:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1472', '538', '1', 'd0e63d12cf10e4f48cf741e8dbebd2d9.jpg', '2018-08-09 10:38:12', '2018-08-09 10:38:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1473', '538', '2', '5d3051bfc819fffe9638cf84d36e3689.jpg', '2018-08-09 10:38:48', '2018-08-09 10:38:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1474', '538', '3', '6dda99b78719829a943529294e5c3bf0.jpg', '2018-08-09 10:39:37', '2018-08-09 10:39:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1475', '604', '2', '335524bb33f2812192822639f5e72567.jpg', '2018-08-09 10:55:48', '2018-08-09 10:55:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1476', '604', '3', '38715ccaa493f494db70efa83712a162.jpg', '2018-08-09 10:56:16', '2018-08-09 10:56:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1477', '618', '1', '81733dcb92795806f027ce94e73a1157.jpg', '2018-08-09 10:56:27', '2018-08-09 10:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1478', '618', '1', 'b341667f965e14d34481bd648cf6ca04.jpg', '2018-08-09 10:56:27', '2018-08-09 10:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1479', '618', '1', '4a74de8eaa0673b746778dbc756a58df.jpg', '2018-08-09 10:56:27', '2018-08-09 10:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1480', '618', '1', '4f7590b801bd046e5b274b7510e14d87.jpg', '2018-08-09 10:56:27', '2018-08-09 10:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1481', '618', '1', '1fd71873e94d217166a89ab032fece16.jpg', '2018-08-09 10:56:27', '2018-08-09 10:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1482', '618', '1', '1893deb5ce4aa269c5a0d9c86d2c3af5.jpg', '2018-08-09 10:56:27', '2018-08-09 10:56:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1483', '618', '2', '7578737c47ed7930e315d0e3b4985957.jpg', '2018-08-09 10:57:10', '2018-08-09 10:57:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1484', '618', '2', 'a1ebcc8fabc9b654362252ee12467aa6.jpg', '2018-08-09 10:57:10', '2018-08-09 10:57:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1485', '618', '2', '5016d6a6ab49797d5dcf53783eb63b57.jpg', '2018-08-09 10:57:10', '2018-08-09 10:57:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1486', '618', '2', '8a5a85d909ad2ecb70bd2d900b1c1f76.jpg', '2018-08-09 10:57:10', '2018-08-09 10:57:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1487', '618', '2', 'a8f9d4935b5aea9ac5c28b094aca5c32.jpg', '2018-08-09 10:57:10', '2018-08-09 10:57:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1488', '618', '3', 'b19ab7442a8ed46222f01888fe4deecd.jpg', '2018-08-09 10:58:10', '2018-08-09 10:58:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1489', '557', '2', '7f9a8925fa0fcb408a79e3329e65fb8a.jpg', '2018-08-09 10:59:30', '2018-08-09 10:59:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1490', '557', '2', 'f81fd297b0710fc4caafcaa44bda94be.jpg', '2018-08-09 10:59:30', '2018-08-09 10:59:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1491', '557', '3', 'b4227d917e98656268912c4dde89cd3c.jpg', '2018-08-09 11:00:22', '2018-08-09 11:00:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1492', '535', '2', '86c629ca01f50b5637cccc81a8f18918.jpg', '2018-08-09 11:03:11', '2018-08-09 11:03:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1493', '535', '3', '75a97adde48fba4bbf3ae4681a674e38.jpg', '2018-08-09 11:03:48', '2018-08-09 11:03:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1494', '591', '2', '37d45ae9c756b66bf56eae91a9f51997.jpg', '2018-08-09 11:08:04', '2018-08-09 11:08:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1495', '591', '2', '3a07935a27739dfab25846b766c8ca68.jpg', '2018-08-09 11:08:04', '2018-08-09 11:08:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1496', '591', '3', 'e29aacabfc327413c93db41dff66fd86.jpg', '2018-08-09 11:08:28', '2018-08-09 11:08:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1497', '592', '2', '40e8e554023d0254503598b59b7ba056.jpg', '2018-08-09 11:09:25', '2018-08-09 11:09:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1498', '617', '1', 'e2c35cbb3fd2d19bce3426f04a814a6a.jpg', '2018-08-09 11:09:30', '2018-08-09 11:09:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1499', '617', '1', '12bc470a64527b9a1c6b5c20d33cb1ce.jpg', '2018-08-09 11:09:30', '2018-08-09 11:09:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1500', '617', '1', 'b95a2a475b7a9197d7e9fb60891359f7.jpg', '2018-08-09 11:09:30', '2018-08-09 11:09:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1501', '592', '3', '0b9db6cb4d0c99d56060a2f242a3a9f6.jpg', '2018-08-09 11:09:40', '2018-08-09 11:09:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1502', '617', '2', '72f27f7b12de07159f4d9148ccbcf367.jpg', '2018-08-09 11:09:53', '2018-08-09 11:09:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1503', '617', '3', 'af2691d28c000ac66901270d24facb2c.jpg', '2018-08-09 11:10:43', '2018-08-09 11:10:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1504', '501', '2', '16e51bf3292e0569c171425699c2d310.jpg', '2018-08-09 11:25:45', '2018-08-09 11:25:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1505', '501', '2', '970f345f2cb58e59c1916e2519136c42.jpg', '2018-08-09 11:25:45', '2018-08-09 11:25:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1506', '501', '3', 'e1602724d873a79094d02625d60cc05f.jpg', '2018-08-09 11:26:29', '2018-08-09 11:26:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1507', '523', '2', '340a1cbe08283da9e54f6be2bb93f0e7.jpg', '2018-08-09 11:35:52', '2018-08-09 11:35:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1508', '523', '3', '0782f69d07c8413770ebe83db77c312f.jpg', '2018-08-09 11:36:08', '2018-08-09 11:36:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1509', '550', '2', '3c0475aafb87709f480116600163293b.jpg', '2018-08-09 11:37:19', '2018-08-09 11:37:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1510', '550', '3', '8247ffe73e7f5bdfc9391a0c79f61ae5.jpg', '2018-08-09 11:37:40', '2018-08-09 11:37:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1511', '651', '1', '922391176becce789f566db71a8e2772.jpg', '2018-08-09 11:47:33', '2018-08-09 11:47:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1512', '651', '1', '6497efc5048c737e385351a3bac7b503.jpg', '2018-08-09 11:47:33', '2018-08-09 11:47:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1513', '651', '1', 'f8e99990cd9ff0d37a89eb383b902d7d.jpg', '2018-08-09 11:47:33', '2018-08-09 11:47:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1514', '651', '2', 'de6a3c39a2cfe56521d2ad2c3a53b62c.jpg', '2018-08-09 11:48:21', '2018-08-09 11:48:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1515', '651', '2', '502b687cb1b670d4acc46c83b3da95e8.jpg', '2018-08-09 11:48:21', '2018-08-09 11:48:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1516', '651', '2', 'b2cfea950d4b6fd085c239cc0be4e5a9.jpg', '2018-08-09 11:48:21', '2018-08-09 11:48:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1517', '488', '2', 'efcd82ea411c97baf9500922749d59b2.jpg', '2018-08-09 11:52:14', '2018-08-09 11:52:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1518', '488', '3', '4c68d80a15a4e35ad58f9b4586e5c67e.jpg', '2018-08-09 11:52:45', '2018-08-09 11:52:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1519', '393', '2', '7ac8e2764bb7d2a273823cb065d1490e.jpg', '2018-08-09 11:53:59', '2018-08-09 11:53:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1520', '393', '3', 'ff6eedae7c315270dae75b82b05e83c4.jpg', '2018-08-09 11:54:22', '2018-08-09 11:54:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1521', '541', '2', '1f6f3f26500c5fb3ac84785228ee651e.jpg', '2018-08-09 11:54:51', '2018-08-09 11:54:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1522', '541', '3', '66688261d0e482caace0733aee62b87a.jpg', '2018-08-09 11:55:10', '2018-08-09 11:55:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1523', '651', '3', '01fe6b3c515b8db99bb5c89947e1eaed.jpg', '2018-08-09 11:56:59', '2018-08-09 11:56:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1524', '451', '2', 'dda5cfd53ce16fba563ec2ebe129476e.jpg', '2018-08-09 12:09:05', '2018-08-09 12:09:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1525', '451', '3', '4f2f17baa2bd1625a6bb6c4b1696a14e.jpg', '2018-08-09 12:09:20', '2018-08-09 12:09:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1526', '332', '2', 'e33727e1ef1e09c63a51a6a431213e19.jpg', '2018-08-09 12:13:07', '2018-08-09 12:13:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1527', '332', '2', '1ff6facc513b01434fcb6d7c54e2c662.jpg', '2018-08-09 12:13:07', '2018-08-09 12:13:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1528', '332', '3', 'd7ba38c3741072c4fafd5ba3669d9477.jpg', '2018-08-09 12:13:38', '2018-08-09 12:13:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1529', '333', '2', 'a947b27e1a6a528e6c4f2ec926d9f076.jpg', '2018-08-09 12:14:30', '2018-08-09 12:14:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1530', '333', '3', '13a08a77a79264efb19d147ea19b1ee8.jpg', '2018-08-09 12:14:49', '2018-08-09 12:14:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1531', '656', '2', '3ac91f27341cf82fd95cbd4059954cac.jpg', '2018-08-09 12:17:45', '2018-08-09 12:17:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1532', '656', '3', 'bc940f73dd09caa4c409cb4ab19b49bb.jpg', '2018-08-09 12:18:08', '2018-08-09 12:18:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1533', '479', '2', '8efd0faaa990b685f4bb74fac09719e3.jpg', '2018-08-09 12:27:00', '2018-08-09 12:27:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1534', '479', '3', '2876f77d33dec64dc073c13dffa68d71.jpg', '2018-08-09 12:27:24', '2018-08-09 12:27:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1535', '294', '2', 'ca1c9ba4cf0db6ca1bb0fb12d7a3ab01.jpg', '2018-08-09 12:37:58', '2018-08-09 12:37:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1536', '294', '3', '6406ca639634ec89dd730cb112aeffce.jpg', '2018-08-09 12:38:20', '2018-08-09 12:38:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1537', '460', '2', '5e4d43913d953cf8ff977e4fa832d8ba.jpg', '2018-08-09 12:44:18', '2018-08-09 12:44:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1538', '460', '3', '6b6c20dc70e39af9388caabfb04a6ac4.jpg', '2018-08-09 12:44:40', '2018-08-09 12:44:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1539', '539', '2', '9d4f508002447aec6a6003e889f282b3.jpg', '2018-08-09 12:46:22', '2018-08-09 12:46:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1540', '539', '3', '103840bb9c1e10a246290bc4cb3290ec.jpg', '2018-08-09 12:46:50', '2018-08-09 12:46:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1541', '551', '2', '7f1963488fdb1976cb517e949d0cdda0.jpg', '2018-08-09 12:48:47', '2018-08-09 12:48:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1542', '551', '3', '0136ba3e27632595d6e7c0345342796c.jpg', '2018-08-09 12:49:07', '2018-08-09 12:49:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1543', '554', '2', '239635b68a345a33c41626c14efbc9e2.jpg', '2018-08-09 12:50:53', '2018-08-09 12:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1544', '554', '2', 'f021d45ecf03ab0339842bc841f7988b.jpg', '2018-08-09 12:50:53', '2018-08-09 12:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1545', '554', '2', 'ca21846fc23e3ead4fecc30c9090bbe4.jpg', '2018-08-09 12:50:53', '2018-08-09 12:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1546', '554', '2', 'e57524814266d03a0542caae0ab8d92a.jpg', '2018-08-09 12:50:53', '2018-08-09 12:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1547', '554', '2', '731e9929e09c6b7080a30bacaf5f41e8.jpg', '2018-08-09 12:50:53', '2018-08-09 12:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1548', '554', '3', 'b579f6d34710c4ca28ef67016ad1a21b.jpg', '2018-08-09 12:51:08', '2018-08-09 12:51:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1549', '560', '2', '096dd1601e259756ad1347d8ebd7fdb2.jpg', '2018-08-09 12:56:24', '2018-08-09 12:56:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1550', '560', '3', '361f02aa5b1f858b0fa0458e982086ca.jpg', '2018-08-09 12:56:43', '2018-08-09 12:56:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1551', '123', '2', 'dd96d7aa8cd8da457284c16a806a0783.jpg', '2018-08-10 09:44:46', '2018-08-10 09:44:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1552', '123', '3', '3c9a47471d25ce4dd110409bba964abe.jpg', '2018-08-10 09:45:18', '2018-08-10 09:45:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1553', '88', '2', '7a1f9f26e3584bb27ecde7dfb838ceee.jpg', '2018-08-10 09:51:10', '2018-08-10 09:51:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1554', '88', '3', 'f8d720f475f113a91eab741faa1348e4.jpg', '2018-08-10 09:51:34', '2018-08-10 09:51:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1555', '365', '2', '8199146e233be6c4b478138a8b5c742d.jpg', '2018-08-10 09:56:48', '2018-08-10 09:56:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1556', '365', '3', '2f8ebdfcfe7a4e16e770ad8c84b6004f.jpg', '2018-08-10 09:57:10', '2018-08-10 09:57:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1557', '203', '2', 'b228e0b0f9acb4063922abbb0dabfab4.jpg', '2018-08-10 10:01:51', '2018-08-10 10:01:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1558', '203', '3', '3b625a0a2a05bc4b8cab602d9e926aa7.jpg', '2018-08-10 10:02:13', '2018-08-10 10:02:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1559', '241', '2', 'da2651c09d75cfb723ae96a2368c8622.jpg', '2018-08-10 10:37:30', '2018-08-10 10:37:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1560', '241', '3', 'efd32c95e61656b866db60381b8c2367.jpg', '2018-08-10 10:37:54', '2018-08-10 10:37:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1561', '680', '1', 'c599fc291c1b7806d5e312fd6f638860.jpg', '2018-08-10 10:44:54', '2018-08-10 10:44:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1562', '680', '1', 'd09c559d2b97336e618090d7602fddd1.jpg', '2018-08-10 10:44:54', '2018-08-10 10:44:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1563', '680', '2', 'ea6ec67ddfd042bfa1632286cd8ed3c7.jpg', '2018-08-10 10:45:40', '2018-08-10 10:45:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1564', '680', '2', '9b3b953f2ef6f7364106139453dcef54.jpg', '2018-08-10 10:45:40', '2018-08-10 10:45:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1565', '342', '1', 'e4a984e9d0e328a7022f02082fdb2809.jpg', '2018-08-10 10:47:36', '2018-08-10 10:47:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1566', '342', '1', '36a2255e094471b79988b88448323a20.jpg', '2018-08-10 10:47:36', '2018-08-10 10:47:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1567', '680', '3', 'e7113136ff889d08a853f7efd8ed9df2.jpg', '2018-08-10 10:47:38', '2018-08-10 10:47:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1568', '342', '2', '3b62055fb2751a7eae174f233250437b.jpg', '2018-08-10 10:48:20', '2018-08-10 10:48:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1569', '342', '2', '37c4a5bb50545113ace5b26e42c72751.jpg', '2018-08-10 10:48:20', '2018-08-10 10:48:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1570', '342', '3', '7ea1fcb3efa3fb247d6dbe1988e006a0.jpg', '2018-08-10 10:49:07', '2018-08-10 10:49:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1571', '525', '1', '462d98feda309d3ec8ce1219e6a9ffce.jpg', '2018-08-10 11:56:52', '2018-08-10 11:56:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1572', '525', '2', 'a1a57d2fb3e495e1d0f8a9c8bc06006c.jpg', '2018-08-10 11:57:00', '2018-08-10 11:57:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1573', '525', '3', 'd69455fd29b370762608f9ea5985379a.jpg', '2018-08-10 11:58:38', '2018-08-10 11:58:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1574', '628', '1', '017a4c36bb5b6ad93a773f850a28a991.jpg', '2018-08-10 15:17:40', '2018-08-10 15:17:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1575', '628', '2', 'b132b3971d5ccd2d7da9a8057f87d3c9.jpg', '2018-08-10 15:18:27', '2018-08-10 15:18:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1576', '628', '2', 'afe86aafbb6e23ff509fd5dd7166d673.jpg', '2018-08-10 15:18:27', '2018-08-10 15:18:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1577', '628', '2', 'a1976be49e29c8c7283d1dab7bdd0d20.jpg', '2018-08-10 15:18:27', '2018-08-10 15:18:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1578', '628', '2', 'e4064aa8acd52fd6d12cabd8f1a6af39.jpg', '2018-08-10 15:18:27', '2018-08-10 15:18:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1579', '628', '2', '2ebb917d6ac75cdcf02db8742ac5ea0b.jpg', '2018-08-10 15:18:27', '2018-08-10 15:18:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1580', '628', '2', '89720fa2bd5135c57145e800f7090850.jpg', '2018-08-10 15:18:27', '2018-08-10 15:18:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1581', '629', '1', '052fe3547a968d098e80f70569b8e528.jpg', '2018-08-10 15:19:13', '2018-08-10 15:19:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1582', '629', '1', 'c9871c685791c5eeae2ddd2f59e687d7.jpg', '2018-08-10 15:19:13', '2018-08-10 15:19:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1583', '629', '2', 'b5cd963355e6a1c73ced5c0319b2dd30.jpg', '2018-08-10 15:20:02', '2018-08-10 15:20:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1584', '629', '2', '41192c60b37c655af637dc4825396cb4.jpg', '2018-08-10 15:20:02', '2018-08-10 15:20:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1585', '629', '2', 'd923356bb802bd1011957136036fb23b.jpg', '2018-08-10 15:20:02', '2018-08-10 15:20:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1586', '629', '2', '8ff937670e357dfa682aa67709dded9c.jpg', '2018-08-10 15:20:02', '2018-08-10 15:20:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1587', '629', '2', '27ef128dc689b4525531fe63276d025f.jpg', '2018-08-10 15:20:02', '2018-08-10 15:20:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1588', '629', '2', '4ae4804f00e6a5158e4f03e5c4ca42f3.jpg', '2018-08-10 15:20:02', '2018-08-10 15:20:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1589', '628', '3', '7025497b298c8285fb6d7ca03ead98c4.jpg', '2018-08-10 15:23:54', '2018-08-10 15:23:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1590', '629', '3', 'a496cd9fa98c85a53923c756507314a9.jpg', '2018-08-10 15:24:29', '2018-08-10 15:24:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1591', '699', '1', 'cb10ad0949563210cf63b1e5d32be7f9.jpg', '2018-08-10 15:52:12', '2018-08-10 15:52:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1592', '699', '2', '43e3bf001328ce04b896da955052adef.jpg', '2018-08-10 15:52:30', '2018-08-10 15:52:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1593', '699', '2', '47c182b3b59e78ef124d2920a5f2b87c.jpg', '2018-08-10 15:52:30', '2018-08-10 15:52:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1594', '699', '2', 'cd4b321e234e3e33412ad83c415178bf.jpg', '2018-08-10 15:52:30', '2018-08-10 15:52:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1595', '699', '2', 'c31715442717cf97954226cbed10bf0a.jpg', '2018-08-10 15:52:30', '2018-08-10 15:52:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1596', '699', '3', 'bb6b0a9e34aab820b6176c8d268f9a78.jpg', '2018-08-10 15:55:09', '2018-08-10 15:55:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1597', '528', '2', '393175d1e098cabadc7d4ad27f7dd3d7.jpg', '2018-08-11 10:59:02', '2018-08-11 10:59:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1598', '528', '2', '1004cac3717d634ee7f50a96483ac548.jpg', '2018-08-11 10:59:02', '2018-08-11 10:59:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1599', '528', '3', '3832ab24f3e42250b319a43a752fb25c.jpg', '2018-08-11 10:59:59', '2018-08-11 10:59:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1600', '697', '1', 'e5524b73f365b839c6fa2fc32b9ca03d.jpg', '2018-08-11 11:14:29', '2018-08-11 11:14:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1601', '697', '1', 'bc40ca1c43ea9fe8e96e94f3dfb522ac.jpg', '2018-08-11 11:14:29', '2018-08-11 11:14:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1602', '697', '2', 'e24f59880516e9d9ef8261efc54e4d7e.jpg', '2018-08-11 11:14:58', '2018-08-11 11:14:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1603', '697', '2', '17b376ecc77461319ac9a0c0dc3e2429.jpg', '2018-08-11 11:14:58', '2018-08-11 11:14:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1604', '697', '2', 'c1f73a50c2455391f54f4bc98686b9c5.jpg', '2018-08-11 11:14:58', '2018-08-11 11:14:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1605', '689', '1', '0d2e559afd59a984183af8d72e49a8c2.jpg', '2018-08-11 11:15:39', '2018-08-11 11:15:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1606', '689', '2', 'db3e074495bbabdd04a14b3db6eb0bd5.jpg', '2018-08-11 11:15:52', '2018-08-11 11:15:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1607', '689', '2', '84df59afd2ca2b56e888a344303ef7cd.jpg', '2018-08-11 11:15:52', '2018-08-11 11:15:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1608', '689', '2', 'd42954a0bb4699dda695bf917180c8de.jpg', '2018-08-11 11:15:52', '2018-08-11 11:15:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1609', '692', '1', '0ca1a00bbbab142992f37a3ef6210e36.jpg', '2018-08-11 11:16:48', '2018-08-11 11:16:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1610', '692', '1', '942d152db7593b92c50737bc93cf7a70.jpg', '2018-08-11 11:16:48', '2018-08-11 11:16:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1611', '692', '2', 'a2c545e924945617edac691603fe4e89.jpg', '2018-08-11 11:17:30', '2018-08-11 11:17:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1612', '692', '2', 'a47d3a3f6af6a48b162625d1bb473baf.jpg', '2018-08-11 11:17:30', '2018-08-11 11:17:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1613', '692', '2', '4d1ed8edbc48bcd8ceda50ffd4540e93.jpg', '2018-08-11 11:17:30', '2018-08-11 11:17:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1614', '692', '2', 'd998a9e0834a094923ca0b42766f0d3f.jpg', '2018-08-11 11:17:30', '2018-08-11 11:17:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1615', '692', '2', '6d2ee816516a29f18999326047a8f6a9.jpg', '2018-08-11 11:17:30', '2018-08-11 11:17:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1616', '692', '2', '90bcc8e2689c3321a7386219d4313bd9.jpg', '2018-08-11 11:17:30', '2018-08-11 11:17:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1617', '692', '3', '44ac5766ea105102c0135d9ae0a48812.jpg', '2018-08-11 11:21:31', '2018-08-11 11:21:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1618', '697', '3', '2684194a941f30f741e75010b547252f.jpg', '2018-08-11 11:22:01', '2018-08-11 11:22:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1619', '689', '3', 'e62d71a38b91b828b41cdc5897906e71.jpg', '2018-08-11 11:22:29', '2018-08-11 11:22:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1620', '706', '1', 'e7334ba87a9815e1e6fca889ed607905.jpg', '2018-08-13 11:16:37', '2018-08-13 11:16:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1621', '706', '1', 'd8b4588579934a5646e4bfea290d924c.jpg', '2018-08-13 11:16:37', '2018-08-13 11:16:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1622', '706', '2', 'e4d9b977fcfdbe74faa66a4d22b89ddc.jpg', '2018-08-13 11:17:07', '2018-08-13 11:17:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1623', '706', '2', '506e5a35fccdaff5fe8dd6e5cf68e487.jpg', '2018-08-13 11:17:07', '2018-08-13 11:17:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1624', '706', '2', 'b7cedbe981e9dd591300d5766937b36e.jpg', '2018-08-13 11:17:07', '2018-08-13 11:17:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1625', '706', '2', 'b00efb7be06cf551d2d2058566018141.jpg', '2018-08-13 11:17:07', '2018-08-13 11:17:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1626', '706', '3', '0f5664f45fbeb1399ba9d508101b099b.jpg', '2018-08-13 11:18:43', '2018-08-13 11:18:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1627', '533', '1', 'a145d09f26b5f812f7a29233d0ce5e50.jpg', '2018-08-13 11:20:56', '2018-08-13 11:20:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1628', '533', '1', '1bbf2af68952936fa3d219a1f2f6e52e.jpg', '2018-08-13 11:20:56', '2018-08-13 11:20:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1629', '533', '2', 'b96d47b7cf7fd7a3bb2c0d30ff9d171f.jpg', '2018-08-13 11:21:27', '2018-08-13 11:21:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1630', '533', '2', 'fec6707b5e5e5423350856349258cff4.jpg', '2018-08-13 11:21:27', '2018-08-13 11:21:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1631', '533', '2', 'b8f33ac9993e3c5a27c57e00dcb18c77.jpg', '2018-08-13 11:21:27', '2018-08-13 11:21:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1632', '533', '2', 'aad38b8be871069465f620a138cfd6c9.jpg', '2018-08-13 11:21:27', '2018-08-13 11:21:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1633', '533', '2', 'e44263ad649c4f1da87a1c3c6b328c1a.jpg', '2018-08-13 11:21:27', '2018-08-13 11:21:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1634', '533', '2', '642e427d0d0349e5dd59af3314230d46.jpg', '2018-08-13 11:21:27', '2018-08-13 11:21:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1635', '533', '3', '29555ea224b2da75436991a94fe57b0e.jpg', '2018-08-13 11:22:12', '2018-08-13 11:22:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1636', '647', '1', '81c6240b1e4f9b2a19b07b7054d383a3.jpg', '2018-08-13 11:30:50', '2018-08-13 11:30:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1637', '647', '1', '46ef54dcfb67ef659799dac6f5689c16.jpg', '2018-08-13 11:30:50', '2018-08-13 11:30:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1638', '647', '1', 'f5bb498fc3a4e22aafcb9d86ece4d741.jpg', '2018-08-13 11:30:50', '2018-08-13 11:30:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1639', '647', '2', 'e5ebf64e312533972dfb479e4bcd3c7e.jpg', '2018-08-13 11:31:07', '2018-08-13 11:31:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1640', '647', '2', '9c644af38b120c1a0caec6bb76a15a0e.jpg', '2018-08-13 11:31:07', '2018-08-13 11:31:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1641', '647', '3', 'c06e965835b20d8170f69677088cf746.jpg', '2018-08-13 11:32:11', '2018-08-13 11:32:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1642', '638', '1', 'c198ea6f52790d7fbdcd1ce1fafdf186.jpg', '2018-08-13 11:39:33', '2018-08-13 11:39:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1643', '638', '1', 'dff925885ac9db6d50b4b06f2b18e8d2.jpg', '2018-08-13 11:39:33', '2018-08-13 11:39:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1644', '638', '1', 'b6b1cd596b13f73ee127d7a8e27511ce.jpg', '2018-08-13 11:39:33', '2018-08-13 11:39:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1645', '638', '1', 'cb0d4b62ebfdeee7ed6eff12d39d06eb.jpg', '2018-08-13 11:39:33', '2018-08-13 11:39:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1646', '638', '1', '85dd415fd8cb86113af4aa0fea3aa89e.jpg', '2018-08-13 11:39:33', '2018-08-13 11:39:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1647', '638', '2', '933ce4c37ea896010aa6d3ede830d308.jpg', '2018-08-13 11:40:13', '2018-08-13 11:40:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1648', '638', '2', '446fbb94c237d4cba21aa969cf107db4.jpg', '2018-08-13 11:40:13', '2018-08-13 11:40:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1649', '638', '2', '3037256093b4f149f762c559c3a16fdd.jpg', '2018-08-13 11:40:13', '2018-08-13 11:40:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1650', '638', '3', '90371e6cf783de7acb0ec79e088c0c05.jpg', '2018-08-13 11:40:58', '2018-08-13 11:40:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1651', '575', '2', 'e5ffbdca2aaf4dcce49fcafe39aebd62.jpg', '2018-08-13 17:15:42', '2018-08-13 17:15:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1652', '575', '3', '3c5dc68eeab7a9999074f2dd76ed22ad.jpg', '2018-08-13 17:16:09', '2018-08-13 17:16:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1653', '405', '2', '4455201903fecc0e84347b989e187892.jpg', '2018-08-13 17:34:02', '2018-08-13 17:34:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1654', '405', '2', 'a9b894f05ef5a02a4d385188024d2dad.jpg', '2018-08-13 17:34:02', '2018-08-13 17:34:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1655', '405', '3', 'a1f8fa565986a1b56a03878bf6d6f713.jpg', '2018-08-13 17:34:28', '2018-08-13 17:34:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1656', '405', '3', '374b925d7975652582c119398af07a65.jpg', '2018-08-13 17:34:31', '2018-08-13 17:34:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1657', '516', '2', 'f53b5730176c2a2226b7bba469745c58.jpg', '2018-08-13 17:42:41', '2018-08-13 17:42:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1658', '516', '3', 'bd5fa5c8171949214b6e3bf99b65c422.jpg', '2018-08-13 17:43:06', '2018-08-13 17:43:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1659', '563', '2', '581539c620893e22738994d6e27f5d39.jpg', '2018-08-13 17:44:00', '2018-08-13 17:44:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1660', '563', '3', 'a347134e7b89528cec791d87e30e9c18.jpg', '2018-08-13 17:44:17', '2018-08-13 17:44:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1661', '531', '2', '624f7ab6a28e5dc5626633f0df940b07.jpg', '2018-08-13 17:50:02', '2018-08-13 17:50:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1662', '531', '3', '8d13c522490190d2d623a841d41b987a.jpg', '2018-08-13 17:50:34', '2018-08-13 17:50:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1663', '621', '2', '3df5f9e4af085c422fda8460961213b1.jpg', '2018-08-13 17:51:24', '2018-08-13 17:51:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1664', '621', '3', 'e1a717a95dc8ac09f8a202142304ed55.jpg', '2018-08-13 17:52:04', '2018-08-13 17:52:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1665', '499', '2', '9c7470cffc7e7974574d196d3f15d44c.jpg', '2018-08-13 18:01:42', '2018-08-13 18:01:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1666', '499', '3', '45cd01de96d090069b45912d5f7e4338.jpg', '2018-08-13 18:01:59', '2018-08-13 18:01:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1667', '593', '2', '072bd7a0c0aea962cd10e9538bc2f582.jpg', '2018-08-13 18:03:26', '2018-08-13 18:03:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1668', '593', '2', 'b1a0fc94d0fc9422c6d7774605f41849.jpg', '2018-08-13 18:03:26', '2018-08-13 18:03:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1669', '593', '2', '1ccb7e3b3e2ae8010bbff1d6047f042f.jpg', '2018-08-13 18:03:26', '2018-08-13 18:03:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1670', '593', '3', '3ff7bfa5ff2e9fb9a9d2e44f0cf56795.jpg', '2018-08-13 18:03:46', '2018-08-13 18:03:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1671', '439', '2', '532b35902a4abb87e9ea8e8b059bfe52.jpg', '2018-08-13 18:05:21', '2018-08-13 18:05:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1672', '439', '3', 'bf99d886d1f5c918b1c7bbda6ca9d83a.jpg', '2018-08-13 18:05:44', '2018-08-13 18:05:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1673', '79', '1', 'c2021eca7d1bcbc0c1c9f6f37504bba9.jpg', '2018-08-14 13:10:35', '2018-08-14 13:10:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1674', '79', '2', '28fa4bdbe8e1aa90b2dd8e42fadf197e.jpg', '2018-08-14 13:10:43', '2018-08-14 13:10:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1675', '79', '3', '9d2d49e16124f25e29eac0dd77804f83.jpg', '2018-08-14 13:10:56', '2018-08-14 13:10:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1676', '597', '1', '60e6d636ed0570bba2b12912857385eb.jpg', '2018-08-14 13:11:47', '2018-08-14 13:11:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1677', '597', '2', '026b6a5a2335b0f4d7082e0ed2d20ef5.jpg', '2018-08-14 13:12:13', '2018-08-14 13:12:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1678', '597', '3', 'c88477012c56a09b77d9b8f631edb8b5.jpg', '2018-08-14 13:12:35', '2018-08-14 13:12:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1679', '454', '1', '54015b1d38d4c832ebc9f723017132af.jpg', '2018-08-14 13:56:05', '2018-08-14 13:56:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1680', '454', '1', '679a5cea2de110aaf68fe4550fa5fdba.jpg', '2018-08-14 13:56:05', '2018-08-14 13:56:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1681', '454', '1', '1bda4e1a9a7235b9b87a657b8f46d02d.jpg', '2018-08-14 13:56:05', '2018-08-14 13:56:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1682', '454', '2', '9bceee7763da4bb1383e7c3b63590edd.jpg', '2018-08-14 13:56:47', '2018-08-14 13:56:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1683', '454', '2', 'd2b15d977e5fcc8121edb79cecb1433c.jpg', '2018-08-14 13:56:47', '2018-08-14 13:56:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1684', '454', '2', 'dbb047a8ef3fd30fb0e7edaeff10707c.jpg', '2018-08-14 13:56:47', '2018-08-14 13:56:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1685', '454', '2', '0d767bc858a8a5f2c54746aa282cbd64.jpg', '2018-08-14 13:56:47', '2018-08-14 13:56:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1686', '454', '2', 'dae00fc3880b1883ac6b74e78e290977.jpg', '2018-08-14 13:56:47', '2018-08-14 13:56:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1687', '454', '2', '3d328f8b024236bf36a8169cfd45448c.jpg', '2018-08-14 13:56:47', '2018-08-14 13:56:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1688', '454', '3', '3cdaaf652b15cb41110ab775165fa3e6.jpg', '2018-08-14 13:59:39', '2018-08-14 13:59:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1689', '730', '1', '90061b743f62f1265cfd0416697e2d5e.jpg', '2018-08-14 16:35:25', '2018-08-14 16:35:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1690', '730', '1', '29fbc61d2c1b2bd1b8e3f350dcf3bc7e.jpg', '2018-08-14 16:35:25', '2018-08-14 16:35:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1691', '730', '1', 'e087e9b27a9b22e6c5e1d412e7bc57b2.jpg', '2018-08-14 16:35:25', '2018-08-14 16:35:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1692', '730', '2', '7b8c68c38a68bb88edbd8b36b0a624bc.jpg', '2018-08-14 16:35:46', '2018-08-14 16:35:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1693', '730', '2', '3f893ebcde9d8239aa73d4798cf66f68.jpg', '2018-08-14 16:35:46', '2018-08-14 16:35:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1694', '730', '3', '9cf4c07ea858406ea206edbffedc5ff2.jpg', '2018-08-14 16:37:45', '2018-08-14 16:37:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1695', '664', '1', 'd9f72d9663eaf1819c1193fb8f1d22f9.jpg', '2018-08-15 14:18:56', '2018-08-15 14:18:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1696', '664', '2', 'ba59930f60aeab3e5dce303639a6ee56.jpg', '2018-08-15 14:19:03', '2018-08-15 14:19:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1697', '664', '3', 'c6af0447923f9f8a21d16f09221a745b.jpg', '2018-08-15 14:19:22', '2018-08-15 14:19:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1698', '586', '1', 'de1041f9e88270fc4c0a0bcd7495f806.jpg', '2018-08-15 14:22:12', '2018-08-15 14:22:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1699', '586', '2', '906169d08682d0dc631e056d94839f09.jpg', '2018-08-15 14:50:27', '2018-08-15 14:50:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1700', '586', '3', '0a52155ce8423437ef8910e8e5b337ed.jpg', '2018-08-15 14:51:07', '2018-08-15 14:51:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1701', '388', '2', '63918edba7cee1fda35d27574fe3d78f.jpg', '2018-08-16 10:16:59', '2018-08-16 10:16:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1702', '388', '2', '33c3656e4d60e9cf911ac42bf481d3bb.jpg', '2018-08-16 10:16:59', '2018-08-16 10:16:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1703', '388', '3', 'd4aadd5a9d407c4a40abd93c1d0273ff.jpg', '2018-08-16 10:17:36', '2018-08-16 10:17:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1704', '725', '1', '124d8b39b532d992d5994b8c622fde53.jpg', '2018-08-16 11:16:32', '2018-08-16 11:16:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1705', '725', '2', '841cb81d28514c6c8d81e413e852fdd9.jpg', '2018-08-16 11:17:08', '2018-08-16 11:17:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1706', '725', '2', '9e91c07aaf73b7bae15b0dff772942d5.jpg', '2018-08-16 11:17:08', '2018-08-16 11:17:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1707', '725', '2', 'f512ead0f5681c222fc09b7106b9ca89.jpg', '2018-08-16 11:17:08', '2018-08-16 11:17:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1708', '725', '2', '7c390a7f7830182ce95e9f9fbbdf395e.jpg', '2018-08-16 11:17:08', '2018-08-16 11:17:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1709', '725', '3', '7edee1976d79dca0ef947b622e7d85f0.jpg', '2018-08-16 11:19:23', '2018-08-16 11:19:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1710', '743', '2', '99aa9b8e6a568f092b799b17ee7cc898.jpg', '2018-08-16 11:40:13', '2018-08-16 11:40:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1711', '312', '1', 'ced882f425320ec36bb1d7442e82d10a.jpg', '2018-08-16 12:36:39', '2018-08-16 12:36:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1712', '312', '1', '51791be637f0defe6f2ff8271952fdcd.jpg', '2018-08-16 12:36:39', '2018-08-16 12:36:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1713', '312', '2', '436fcd8474271046c17e32c927d5de73.jpg', '2018-08-16 12:37:10', '2018-08-16 12:37:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1714', '312', '2', '799434dbf19c5a3846a3aaa93558ba4f.jpg', '2018-08-16 12:37:10', '2018-08-16 12:37:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1715', '312', '2', '28764a6d3dd3269816b78838392fe6a7.jpg', '2018-08-16 12:37:10', '2018-08-16 12:37:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1716', '312', '2', '3cf32a5648d15ac9dfab8aec36a816c7.jpg', '2018-08-16 12:37:10', '2018-08-16 12:37:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1717', '744', '1', 'a7da1a386f76d334ce2d4d34bc8ad860.jpg', '2018-08-16 12:37:56', '2018-08-16 12:37:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1718', '744', '1', 'f55fb4a4d84fc466dfd229698943eb9d.jpg', '2018-08-16 12:37:56', '2018-08-16 12:37:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1719', '744', '2', '7d2095ee074db85070fe9dc376777230.jpg', '2018-08-16 12:38:31', '2018-08-16 12:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1720', '744', '2', 'df375411e5faea9ee99111f125d2ddec.jpg', '2018-08-16 12:38:31', '2018-08-16 12:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1721', '744', '2', '12e8a66a9b6d020a213f5a97c29f3acf.jpg', '2018-08-16 12:38:31', '2018-08-16 12:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1722', '744', '2', '06815dbdba3ad59fc3b722d1cde83810.jpg', '2018-08-16 12:38:31', '2018-08-16 12:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1723', '312', '3', 'b90c4dd0aec781cc402da6fa0d49ec24.jpg', '2018-08-16 12:43:09', '2018-08-16 12:43:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1724', '744', '3', '394f925f1f6232bae7df0487fd463b36.jpg', '2018-08-16 12:43:41', '2018-08-16 12:43:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1725', '317', '2', '1f9cecb68b402fb8f3afbdd2f7099d4c.jpg', '2018-08-16 13:15:05', '2018-08-16 13:15:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1726', '317', '3', '268eadbeed031df6ea08d327a3e54339.jpg', '2018-08-16 13:15:24', '2018-08-16 13:15:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1727', '532', '2', '21bd98c3e1fa2994c6e5edce696660da.jpg', '2018-08-16 13:31:37', '2018-08-16 13:31:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1728', '532', '3', 'eac4edc6e33886cb0917d548643de9b2.jpg', '2018-08-16 13:31:58', '2018-08-16 13:31:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1729', '480', '2', '3c81c6be00bb1490bfde4c3dee6693a7.jpg', '2018-08-16 13:37:01', '2018-08-16 13:37:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1730', '480', '3', 'dae275d62275f4b5d905f246d8f19adb.jpg', '2018-08-16 13:37:16', '2018-08-16 13:37:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1731', '549', '2', 'b84e1175c18f6733ef4c67ee29a3e686.jpg', '2018-08-16 13:38:03', '2018-08-16 13:38:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1732', '549', '3', '6d117f17bae4a61dd15962a03bd284e6.jpg', '2018-08-16 13:38:20', '2018-08-16 13:38:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1733', '603', '2', '593588ce4776c96d004a9b6b25506a17.jpg', '2018-08-16 13:39:52', '2018-08-16 13:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1734', '603', '3', '36bb9c8fc2165eafd8a82d47ef85652d.jpg', '2018-08-16 13:40:17', '2018-08-16 13:40:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1735', '605', '2', 'c2f0bc3f1a3304698d41b878ad6ef2f1.jpg', '2018-08-16 13:45:47', '2018-08-16 13:45:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1736', '605', '3', '1137138f25955916ed2358efd1318393.jpg', '2018-08-16 13:46:09', '2018-08-16 13:46:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1737', '748', '1', 'b5e1841b9d139f447aec8b615c2cc4bf.jpg', '2018-08-16 13:47:29', '2018-08-16 13:47:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1738', '748', '2', '52ac857afad2580d39b71fb6a7c3aef7.jpg', '2018-08-16 13:47:44', '2018-08-16 13:47:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1739', '748', '2', '6ef2408771df99de7af66253982e7f2e.jpg', '2018-08-16 13:47:44', '2018-08-16 13:47:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1740', '748', '2', 'ff670b3e2077ae4fcaec191192ab497d.jpg', '2018-08-16 13:47:44', '2018-08-16 13:47:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1741', '748', '3', '9d303abf65e73b3b85fc640e8ca25dc6.jpg', '2018-08-16 13:49:27', '2018-08-16 13:49:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1742', '452', '2', '9da523fdea1066892978322e0bdca2a9.jpg', '2018-08-16 14:07:46', '2018-08-16 14:07:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1743', '452', '3', '5102e8f09d3a96faf16c741ab18faded.jpg', '2018-08-16 14:08:16', '2018-08-16 14:08:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1744', '410', '2', '3d8bd4018bc1decb06cbf4600a731e6b.jpg', '2018-08-16 14:25:19', '2018-08-16 14:25:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1745', '410', '2', '2f43aff0db1c3fb9be4ab184120a09a6.jpg', '2018-08-16 14:25:19', '2018-08-16 14:25:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1746', '410', '3', '901079f396e985e58853b9d5288dbc71.jpg', '2018-08-16 14:25:48', '2018-08-16 14:25:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1747', '426', '2', '6cfc7dfff7ad366320150672a0ddc547.jpg', '2018-08-16 14:27:23', '2018-08-16 14:27:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1748', '426', '3', '9a4b5875050bc3136da21e05e0c9a63f.jpg', '2018-08-16 14:27:50', '2018-08-16 14:27:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1749', '741', '2', 'd7a2cad5390051015a47dd236899b8f6.jpg', '2018-08-16 14:28:45', '2018-08-16 14:28:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1750', '741', '3', '5192875c281715da2c2e11eafd280d0d.jpg', '2018-08-16 14:29:06', '2018-08-16 14:29:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1751', '619', '2', '4613119273333949065b487347b64fbd.jpg', '2018-08-17 10:39:19', '2018-08-17 10:39:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1752', '619', '3', 'fda56d143bd6399410a018f86104944e.jpg', '2018-08-17 10:39:40', '2018-08-17 10:39:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1753', '345', '2', '62fc51d533f7f8996d3d5a6cbb207e9a.jpg', '2018-08-17 10:48:30', '2018-08-17 10:48:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1754', '345', '3', 'f0f396b631103461c3fcf9fcf22fea68.jpg', '2018-08-17 10:48:52', '2018-08-17 10:48:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1755', '758', '2', '474e670a8a170f052e3c141769959fe9.jpg', '2018-08-17 10:53:35', '2018-08-17 10:53:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1756', '758', '3', 'a495862401ef939c95d75ab3de9d2b4f.jpg', '2018-08-17 10:53:57', '2018-08-17 10:53:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1757', '760', '2', '97581ea51107239ad47a8f860b62950e.jpg', '2018-08-17 10:58:02', '2018-08-17 10:58:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1758', '760', '3', '6971fbc02fdb997ade84846600c957a2.jpg', '2018-08-17 10:58:47', '2018-08-17 10:58:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1759', '759', '2', '47520394d333acd80139dc0dd27b38da.jpg', '2018-08-17 11:01:09', '2018-08-17 11:01:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1760', '759', '3', 'f042ddea9cd6c033ad0bf3a5c6a8775a.jpg', '2018-08-17 11:01:37', '2018-08-17 11:01:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1761', '630', '2', '903d7cb3b4aaf1466a64ab834940253a.jpg', '2018-08-17 11:16:52', '2018-08-17 11:16:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1762', '630', '3', 'f110646905059c83dbc5ddfe61ff85ec.jpg', '2018-08-17 11:17:10', '2018-08-17 11:17:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1763', '765', '2', '6d9c479b3ef618a55fdb5ff8d0d07d7d.jpg', '2018-08-17 11:21:11', '2018-08-17 11:21:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1764', '765', '3', 'e17082e947838ac1c526b5c6b102ce6b.jpg', '2018-08-17 11:21:28', '2018-08-17 11:21:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1765', '761', '1', 'cdb9dcb6984d541352b7e9c7dac00c7d.jpg', '2018-08-17 11:43:26', '2018-08-17 11:43:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1766', '745', '2', 'dd0f7fb14875c884d0c9dcd8bbf73307.jpg', '2018-08-17 11:46:55', '2018-08-17 11:46:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1767', '757', '1', '7472213c9f273b81e7eb35fcd2043fc5.jpg', '2018-08-17 11:47:07', '2018-08-17 11:47:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1768', '757', '1', '4de87fc736f4f43ed09e5931589ec5d9.jpg', '2018-08-17 11:47:07', '2018-08-17 11:47:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1769', '745', '3', '889b3867c1292c561e9a7b694b47c625.jpg', '2018-08-17 11:47:32', '2018-08-17 11:47:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1770', '716', '2', '786a8b17d29f3ffefa3579b0bc70f47a.jpg', '2018-08-17 11:49:52', '2018-08-17 11:49:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1771', '716', '3', 'dda2be911da278f27b88313013c14040.jpg', '2018-08-17 11:50:28', '2018-08-17 11:50:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1772', '761', '2', '5c34c462ed6d8f264ce1be9c3c370a95.jpg', '2018-08-17 11:54:10', '2018-08-17 11:54:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1773', '761', '3', '65d310497bb6741681ca267cdb4598ca.jpg', '2018-08-17 11:54:29', '2018-08-17 11:54:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1774', '764', '2', 'ea51628349ffeb96f587f6f50695f32f.jpg', '2018-08-17 11:59:53', '2018-08-17 11:59:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1775', '764', '3', 'e5aeff9c1297494690a8974f86a279a7.jpg', '2018-08-17 12:00:28', '2018-08-17 12:00:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1776', '762', '2', '74798d84df86689d6ef1c7a2c41c2438.jpg', '2018-08-17 12:06:58', '2018-08-17 12:06:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1777', '762', '3', 'e9f1fc4108331071b43a3181e7408688.jpg', '2018-08-17 12:07:24', '2018-08-17 12:07:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1778', '763', '2', 'd265c2dbb5f117008abdf60022a46a4a.jpg', '2018-08-17 12:08:49', '2018-08-17 12:08:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1779', '763', '3', 'f97df534c7db1d9f3c941fb520e1cf8f.jpg', '2018-08-17 12:09:19', '2018-08-17 12:09:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1780', '643', '2', '8aa9d4ce39597ed3b149c348bc3a03fb.jpg', '2018-08-17 12:16:58', '2018-08-17 12:16:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1781', '643', '3', '2f134571348c66e13eaf871a8ccc0da6.jpg', '2018-08-17 12:17:23', '2018-08-17 12:17:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1782', '642', '2', '1cdbd279e7e7baf5f173231879c81f26.jpg', '2018-08-17 12:18:45', '2018-08-17 12:18:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1783', '642', '3', '120a4beebc4d415042a390f318bdfb8a.jpg', '2018-08-17 12:19:39', '2018-08-17 12:19:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1784', '698', '2', '33753f35e5181c8fc7e5ed85233eb285.jpg', '2018-08-17 12:23:54', '2018-08-17 12:23:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1785', '698', '2', 'ee820c4fb2f41f598dcd0527d82dfbeb.jpg', '2018-08-17 12:23:54', '2018-08-17 12:23:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1786', '698', '3', 'd1f3c4bcde574a12fc36fa3fa77f5446.jpg', '2018-08-17 12:24:13', '2018-08-17 12:24:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1787', '710', '1', 'e7fb9f24d92468953f2104792f96d93b.jpg', '2018-08-17 12:35:23', '2018-08-17 12:35:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1788', '710', '2', '7861ef42948eec30c6c71ef7985ae1f5.jpg', '2018-08-17 12:35:58', '2018-08-17 12:35:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1789', '710', '3', '39da2e0e17d726e337a8eac84d0006ae.jpg', '2018-08-17 12:37:45', '2018-08-17 12:37:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1790', '710', '3', '5a16acb199c0a9e0fb4a713c18c83364.jpg', '2018-08-17 12:37:47', '2018-08-17 12:37:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1791', '709', '1', 'ed462e1474c987ae5e7e0000fd40836e.jpg', '2018-08-17 12:47:12', '2018-08-17 12:47:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1792', '709', '2', '5ace87accbabc489d173d00132a861d0.jpg', '2018-08-17 12:47:24', '2018-08-17 12:47:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1793', '709', '3', '51ca5b94697ffb32d899136ad509625f.jpg', '2018-08-17 12:48:12', '2018-08-17 12:48:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1794', '757', '2', 'f2d1369a3e73914c1ad0312e6136ea73.jpg', '2018-08-17 17:07:24', '2018-08-17 17:07:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1795', '757', '3', 'f7c618a190a68b0d5bba404d6ca37106.jpg', '2018-08-17 17:08:19', '2018-08-17 17:08:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1796', '766', '1', 'ee908f2d1caabc7cacae7ae5f92119ca.jpg', '2018-08-17 17:12:41', '2018-08-17 17:12:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1797', '766', '1', '10b5ed6f93056174a129d6f84e3a696a.jpg', '2018-08-17 17:12:41', '2018-08-17 17:12:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1798', '766', '2', '1c1f3dae7f914a496ae29dafffabe8ad.jpg', '2018-08-17 17:13:09', '2018-08-17 17:13:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1799', '766', '2', '01f4ae1ef2ce1e15769029d3f1b91d93.jpg', '2018-08-17 17:13:09', '2018-08-17 17:13:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1800', '766', '3', 'a6681f315a1a13426fe10bc8c3a0a22f.jpg', '2018-08-17 17:14:22', '2018-08-17 17:14:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1801', '736', '1', 'ea262e895bdf6227ed8d9cd2217ebf22.jpg', '2018-08-18 09:43:45', '2018-08-18 09:43:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1802', '736', '1', '9094548f16aaa03fbeebf7c29a10d5fb.jpg', '2018-08-18 09:43:45', '2018-08-18 09:43:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1803', '736', '1', '4bca7865e508a9f5c9e8de3a980eaa35.jpg', '2018-08-18 09:43:45', '2018-08-18 09:43:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1804', '736', '1', '9fbe04b83eac9f9b6dc8c38557d41060.jpg', '2018-08-18 09:43:46', '2018-08-18 09:43:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1805', '736', '1', '5a68fcb7daa0101b92f8df04d66f699d.jpg', '2018-08-18 09:43:46', '2018-08-18 09:43:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1806', '736', '1', 'd84273e871eb3b38a54eefcc5b453a06.jpg', '2018-08-18 09:43:46', '2018-08-18 09:43:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1807', '736', '2', 'a8900d16f68f474d71ed8d3b9f790db4.jpg', '2018-08-18 09:44:37', '2018-08-18 09:44:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1808', '736', '2', '0557734d8593e2ff94b7bf1891a4be19.jpg', '2018-08-18 09:44:37', '2018-08-18 09:44:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1809', '736', '2', 'ae189ccba471c3a317e585121994b13e.jpg', '2018-08-18 09:44:37', '2018-08-18 09:44:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1810', '736', '2', 'f5521f5cd9244413c4918369759e7f35.jpg', '2018-08-18 09:44:37', '2018-08-18 09:44:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1811', '736', '3', '8ac2e04ede47d32d2f2bfb2a8f161e43.jpg', '2018-08-18 09:51:03', '2018-08-18 09:51:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1812', '476', '2', '56f86a29c5fbaaecfc216f7d168209ea.jpg', '2018-08-20 13:00:40', '2018-08-20 13:00:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1813', '476', '3', 'e5559408316fbb8dc9a7590c3a696e4b.jpg', '2018-08-20 13:00:54', '2018-08-20 13:00:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1814', '649', '2', '3b8ba7f20cac120ee9b61c31e8969f53.jpg', '2018-08-20 13:02:21', '2018-08-20 13:02:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1815', '649', '3', 'd6b7c49f1e733a3c9ef1211038e56aba.jpg', '2018-08-20 13:02:32', '2018-08-20 13:02:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1816', '477', '2', '5f4e42c196411e632e167632b3ee70c3.jpg', '2018-08-20 13:03:03', '2018-08-20 13:03:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1817', '477', '3', '0d17977e2a76da9a3bec7f5f297dced4.jpg', '2018-08-20 13:03:12', '2018-08-20 13:03:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1818', '284', '2', '2076144a747a3574c8ad613ed060a91c.jpg', '2018-08-20 13:03:57', '2018-08-20 13:03:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1819', '284', '3', 'a1a05a2d25329f2c12db77c4b1f22747.jpg', '2018-08-20 13:04:07', '2018-08-20 13:04:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1820', '547', '2', '4a96309f4bb64db2a95313ef86bf370e.jpg', '2018-08-20 13:04:53', '2018-08-20 13:04:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1821', '547', '3', 'c9f0b9dc77e44e8771f28ef6c3517f9e.jpg', '2018-08-20 13:05:05', '2018-08-20 13:05:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1822', '475', '2', 'f250bdc27e391fe65d2171346fafa7ec.jpg', '2018-08-20 13:09:35', '2018-08-20 13:09:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1823', '475', '3', '3707853fdd04d5604c6212d20ba0aa43.jpg', '2018-08-20 13:09:46', '2018-08-20 13:09:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1824', '624', '2', '9ba0217e913bcb81ecca56c7dc963ef4.jpg', '2018-08-20 13:10:23', '2018-08-20 13:10:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1825', '624', '3', 'e16d60b73c7d25e7eaf1007065af6edc.jpg', '2018-08-20 13:10:32', '2018-08-20 13:10:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1826', '128', '2', 'a0f19656cd0db0802f464b4940a50880.jpg', '2018-08-20 13:11:05', '2018-08-20 13:11:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1827', '128', '3', '1224f2ffc80fff054b1b209c0bfad3a2.jpg', '2018-08-20 13:11:17', '2018-08-20 13:11:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1828', '329', '2', '252c97fa75750fd9e487ceb66400d0ab.jpg', '2018-08-20 13:13:23', '2018-08-20 13:13:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1829', '329', '3', '1163aa176744658f3537b37b3c9268b3.jpg', '2018-08-20 13:13:37', '2018-08-20 13:13:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1830', '714', '2', 'd9d4fc9ae9a1983c1717529808ec062d.jpg', '2018-08-20 13:17:24', '2018-08-20 13:17:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1831', '714', '2', 'b48bbd30b15e9437b012bb3ef90d3377.jpg', '2018-08-20 13:17:28', '2018-08-20 13:17:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1832', '714', '3', 'c67da124a002a69a0976f10239eef591.jpg', '2018-08-20 13:17:39', '2018-08-20 13:17:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1833', '326', '2', '6c314bebc9d7bcb5bf6e7ce8c3652afc.jpg', '2018-08-20 13:23:31', '2018-08-20 13:23:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1834', '326', '3', '8bf3d1354be4e4a33b97b099d04126f1.jpg', '2018-08-20 13:23:41', '2018-08-20 13:23:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1835', '440', '2', '50b076854a121aee609a93a12d7461d0.jpg', '2018-08-20 13:24:16', '2018-08-20 13:24:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1836', '440', '3', '3865eb5b3fcf1a2439a49a63a8e8c9c6.jpg', '2018-08-20 13:24:30', '2018-08-20 13:24:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1837', '581', '2', '52fb809e3173add8d4aca11fd21b4efd.jpg', '2018-08-20 13:26:11', '2018-08-20 13:26:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1838', '581', '3', '42963ac9952b3d57c1628ea7995ca442.jpg', '2018-08-20 13:26:24', '2018-08-20 13:26:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1839', '555', '2', 'a5eb8adb1bd9943bd1f1665ea4bf7a4c.jpg', '2018-08-20 13:27:42', '2018-08-20 13:27:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1840', '555', '3', '64b0d0319c6b7128458867fc6e5211d6.jpg', '2018-08-20 13:27:55', '2018-08-20 13:27:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1841', '571', '2', 'f8671ba207768e4bb32ee714703b3aea.jpg', '2018-08-20 13:29:28', '2018-08-20 13:29:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1842', '571', '3', 'b553ed7a6725f4773b3ced8765fad8d1.jpg', '2018-08-20 13:29:40', '2018-08-20 13:29:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1843', '286', '2', 'e66d4cadc6d669f2816b74d22f9e17d0.jpg', '2018-08-20 13:30:13', '2018-08-20 13:30:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1844', '286', '3', 'cb68578fbe1e605a53731e5d09301c7f.jpg', '2018-08-20 13:30:24', '2018-08-20 13:30:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1845', '285', '2', 'f1d760510f2abc928fb84e6f13ed2c3a.jpg', '2018-08-20 13:31:21', '2018-08-20 13:31:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1846', '285', '3', '06ef7a65e9a5ece561f18b0a448f43e3.jpg', '2018-08-20 13:31:34', '2018-08-20 13:31:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1847', '169', '2', '3d715eb3eb0a06ecff3a86eb0af0efd2.jpg', '2018-08-20 13:32:22', '2018-08-20 13:32:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1848', '169', '3', '1eeb1c67d4d309724ef22223996409db.jpg', '2018-08-20 13:32:31', '2018-08-20 13:32:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1849', '170', '2', 'ef9bb469036c2c209ec6814208748ecf.jpg', '2018-08-20 13:33:02', '2018-08-20 13:33:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1850', '170', '3', 'edaee640fd278598effa7b0eff18fbd6.jpg', '2018-08-20 13:33:12', '2018-08-20 13:33:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1851', '183', '2', '500aed16fa4f01f1b2f4ecc55097c4f5.jpg', '2018-08-20 13:33:36', '2018-08-20 13:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1852', '183', '3', '62bcd71b3901d2305f97a06f2819aeb2.jpg', '2018-08-20 13:34:07', '2018-08-20 13:34:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1853', '459', '2', '99a02efc0f2b23b7e0485fde9bc69c7e.jpg', '2018-08-20 13:34:54', '2018-08-20 13:34:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1854', '459', '3', 'e7bb762961b963d415bdb7fa0cfb7a05.jpg', '2018-08-20 13:35:03', '2018-08-20 13:35:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1855', '620', '2', 'd4e88476ece895d03425a914a87174d0.jpg', '2018-08-20 14:24:09', '2018-08-20 14:24:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1856', '620', '3', 'c82fd41b381e827abf288792f9bdd9e3.jpg', '2018-08-20 14:25:12', '2018-08-20 14:25:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1857', '733', '2', '6e9d032289977fe8269808c42f66e69a.jpg', '2018-08-20 14:32:47', '2018-08-20 14:32:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1858', '733', '2', '949cf7e429573e625948db6ea05bb8db.jpg', '2018-08-20 14:32:47', '2018-08-20 14:32:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1859', '733', '3', 'a9cde2e4bea2843bf1a2ea10c7158b3f.jpg', '2018-08-20 14:33:13', '2018-08-20 14:33:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1860', '724', '2', 'b72ea06e20e2bad53ccf74aa9518ef1d.jpg', '2018-08-20 14:38:41', '2018-08-20 14:38:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1861', '724', '3', 'acd45c626de3d3d4fd506db89445726d.jpg', '2018-08-20 14:38:57', '2018-08-20 14:38:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1862', '668', '2', '5f6128cb07cf2b10cabd6771b9521645.jpg', '2018-08-20 14:44:31', '2018-08-20 14:44:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1863', '668', '2', '788ba59a8891e2177c6c371cf89292f6.jpg', '2018-08-20 14:44:31', '2018-08-20 14:44:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1864', '668', '2', '627e732efbde5fd1245ac8c827b6b3c7.jpg', '2018-08-20 14:44:31', '2018-08-20 14:44:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1865', '668', '3', '6d95346e192ee08a07921bdcabb3d895.jpg', '2018-08-20 14:45:31', '2018-08-20 14:45:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1866', '783', '1', '328cb23251b75a362f8f9b56da502440.jpg', '2018-08-21 10:01:16', '2018-08-21 10:01:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1867', '783', '2', 'f6c126fef07a4e0ab626d21ac7b2f8ce.jpg', '2018-08-21 10:01:25', '2018-08-21 10:01:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1868', '783', '3', 'e836d30f97a9a594956b931bb820a65c.jpg', '2018-08-21 10:01:41', '2018-08-21 10:01:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1869', '774', '1', '778220585b08419229cc86cbd9bf60e3.jpg', '2018-08-21 10:02:58', '2018-08-21 10:02:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1870', '774', '2', 'e51d749c6a1c1cc583388fc00da898a8.jpg', '2018-08-21 10:03:06', '2018-08-21 10:03:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1871', '774', '3', '7d7bc4956e5dbf3c5cbad350b1970d06.jpg', '2018-08-21 10:03:20', '2018-08-21 10:03:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1872', '750', '1', '733edee0dba27d6fbe9bf1caee29784b.jpg', '2018-08-21 10:04:41', '2018-08-21 10:04:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1873', '750', '1', 'ae883d9344af5a7e811323359d901d86.jpg', '2018-08-21 10:04:41', '2018-08-21 10:04:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1874', '750', '1', '5e0798c922054bc18f9bea0ba5144090.jpg', '2018-08-21 10:04:41', '2018-08-21 10:04:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1875', '750', '2', '11796f816f735f3713d167fcc89ccdaf.jpg', '2018-08-21 10:04:56', '2018-08-21 10:04:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1876', '750', '2', '23caecf9e675cc5d76d3a260ec27c17b.jpg', '2018-08-21 10:04:56', '2018-08-21 10:04:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1877', '750', '2', 'b9a82f018d64f59105a3294ce374fb70.jpg', '2018-08-21 10:04:56', '2018-08-21 10:04:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1878', '750', '3', '843b23865de1c80ebdc41ee14cd34c8a.jpg', '2018-08-21 10:05:10', '2018-08-21 10:05:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1879', '756', '1', '374f2d36124a3d6d9db344d9037d5fd2.jpg', '2018-08-21 10:05:59', '2018-08-21 10:05:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1880', '756', '2', 'b557308dd12cdc0d5bf07e4d40f5db23.jpg', '2018-08-21 10:06:06', '2018-08-21 10:06:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1881', '756', '3', '2cf00b238eaf5c754ae6956ac2ac0be1.jpg', '2018-08-21 10:06:20', '2018-08-21 10:06:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1882', '743', '3', '7586b590c45edb163997501bea85deae.jpg', '2018-08-21 10:07:56', '2018-08-21 10:07:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1883', '781', '1', '1b3218b0b721f3aa5e8c2462e6ec6623.jpg', '2018-08-21 12:22:26', '2018-08-21 12:22:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1884', '781', '1', 'ca78aa0c3fca5d04936109f572922393.jpg', '2018-08-21 12:22:26', '2018-08-21 12:22:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1885', '781', '1', '4d8a021328f7e6e23edcdd8979504e7d.jpg', '2018-08-21 12:22:26', '2018-08-21 12:22:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1886', '781', '2', '86c0d5a5971d02f9d3a2a5e4d09b6259.jpg', '2018-08-21 12:22:51', '2018-08-21 12:22:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1887', '781', '2', '7498db3434bb952cd8068084223d97a2.jpg', '2018-08-21 12:22:51', '2018-08-21 12:22:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1888', '781', '2', '8a79176e2b874be20feb45545e7e15fe.jpg', '2018-08-21 12:22:51', '2018-08-21 12:22:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1889', '781', '2', '2aa1c1e5c10fb9cab33dacd7c6432aea.jpg', '2018-08-21 12:22:51', '2018-08-21 12:22:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1890', '781', '2', '06d45ecaebdd0b3b789221f562ed0810.jpg', '2018-08-21 12:22:51', '2018-08-21 12:22:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1891', '781', '3', '4236f6fbc23dd5ab35897e9e072351a6.jpg', '2018-08-21 12:23:45', '2018-08-21 12:23:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1892', '779', '1', 'afb58826bbd1fd68928b56dd84395478.jpg', '2018-08-21 14:57:15', '2018-08-21 14:57:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1893', '779', '2', 'f4bfd54af7a793c3a8fb0e5e441f8a28.jpg', '2018-08-21 14:57:42', '2018-08-21 14:57:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1894', '779', '3', '14da8ad5d8830c1298258f52c4ea0842.jpg', '2018-08-21 14:58:16', '2018-08-21 14:58:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1895', '780', '1', '867ccd106573d86137027486ee98f837.jpg', '2018-08-21 15:03:26', '2018-08-21 15:03:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1896', '780', '2', '43b498b6a9f3dd9c18efbdd842e01ae2.jpg', '2018-08-21 15:03:33', '2018-08-21 15:03:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1897', '780', '3', '3e8ab7a60ee3b525676e677ccabd9476.jpg', '2018-08-21 15:05:27', '2018-08-21 15:05:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1898', '708', '1', 'bb51e6726c182b99d54f8c52b4c4ee7a.jpg', '2018-08-21 15:09:48', '2018-08-21 15:09:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1899', '708', '2', '8996d24cbb3e6f166857e3dc1928ad7c.jpg', '2018-08-21 15:09:54', '2018-08-21 15:09:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1900', '708', '3', '31b47581fddc88729e8146c7f444f1ed.jpg', '2018-08-21 15:10:08', '2018-08-21 15:10:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1901', '648', '1', '1c62b9a80e7fe432301080ac9a4d0938.jpg', '2018-08-21 15:11:29', '2018-08-21 15:11:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1902', '648', '1', '618262fb5c3cb7b0eb8fd160becacf68.jpg', '2018-08-21 15:11:29', '2018-08-21 15:11:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1903', '648', '2', 'ef9e8c3d51d7d6d277ec1cfc3f518e34.jpg', '2018-08-21 15:11:40', '2018-08-21 15:11:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1904', '648', '2', '4bf63d865aa66393a6186fed7f14d8ac.jpg', '2018-08-21 15:11:40', '2018-08-21 15:11:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1905', '648', '3', 'd136e700402c2ece50a2c1926ca610e7.jpg', '2018-08-21 15:19:19', '2018-08-21 15:19:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1906', '785', '1', 'a1ebe034e5dda65634f027bc93bcfde7.jpg', '2018-08-21 17:22:54', '2018-08-21 17:22:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1907', '785', '2', '70bc64b84a8121dca9ded2a5d77b334d.jpg', '2018-08-21 17:23:04', '2018-08-21 17:23:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1908', '785', '3', 'f1a341efaba4fea6af96510c89f42eee.jpg', '2018-08-21 17:23:20', '2018-08-21 17:23:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1909', '610', '1', 'db03e07f2301f5cebc6ce53aac2a6937.jpg', '2018-08-22 13:17:13', '2018-08-22 13:17:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1910', '610', '1', 'b86d923cb428b1c6ba8710ef5d70ed0e.jpg', '2018-08-22 13:17:13', '2018-08-22 13:17:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1911', '610', '2', '507d6988b2973b882f8fab3dfd8b6721.jpg', '2018-08-22 13:18:03', '2018-08-22 13:18:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1912', '610', '2', '3764af2416dd510a92a2deca327df97b.jpg', '2018-08-22 13:18:03', '2018-08-22 13:18:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1913', '610', '2', 'c16deb986e097a6ffb20c2ed66f04e86.jpg', '2018-08-22 13:18:03', '2018-08-22 13:18:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1914', '610', '2', 'f8199d66a05ace730dc1f1db2c0874c4.jpg', '2018-08-22 13:18:03', '2018-08-22 13:18:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1915', '610', '2', '38376535ec96023f04d0448a935e73db.jpg', '2018-08-22 13:18:03', '2018-08-22 13:18:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1916', '610', '3', '7ed8673c0a7156bf1d66db484a2b84de.jpg', '2018-08-22 13:20:19', '2018-08-22 13:20:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1917', '790', '1', '38cc52768fb40e401c9caa41d9fa9d86.jpg', '2018-08-22 13:21:52', '2018-08-22 13:21:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1918', '790', '2', 'b528587684cdea21e0ab598812ab2d5c.jpg', '2018-08-22 13:22:38', '2018-08-22 13:22:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1919', '790', '2', 'a9a6887c1508b1cb4322faae0234f82e.jpg', '2018-08-22 13:22:38', '2018-08-22 13:22:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1920', '790', '2', 'ca7e018fa2bf69ce6dd55d75c08e4323.jpg', '2018-08-22 13:22:38', '2018-08-22 13:22:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1921', '790', '2', 'c33c60b51fb46a91a856f4259c26e9fd.jpg', '2018-08-22 13:22:38', '2018-08-22 13:22:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1922', '790', '2', 'a002828f20f07012033a15cac4a9fc96.jpg', '2018-08-22 13:22:38', '2018-08-22 13:22:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1923', '790', '2', 'da9ec57f5469d6748c30b1edc7771ce2.jpg', '2018-08-22 13:22:38', '2018-08-22 13:22:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1924', '790', '3', '4682e6d6fa9b885bbe608ad4add1199a.jpg', '2018-08-22 13:23:15', '2018-08-22 13:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1925', '635', '1', 'e180d53f4707d1febed7016690e9ac90.jpg', '2018-08-23 11:01:34', '2018-08-23 11:01:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1926', '635', '1', 'b6c4ed4609491618d5f2fc5b1e50ddd3.jpg', '2018-08-23 11:01:34', '2018-08-23 11:01:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1927', '635', '1', '5a43260286fc2663a0e5f18cea0bc293.jpg', '2018-08-23 11:01:34', '2018-08-23 11:01:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1928', '635', '2', '0d852659a40de63ae7eeb6bee162e2fd.jpg', '2018-08-23 11:02:36', '2018-08-23 11:02:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1929', '635', '2', '7fcb9ec20e236a8e07f2f8deefbae212.jpg', '2018-08-23 11:02:36', '2018-08-23 11:02:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1930', '635', '2', 'fccd9cb3154872a98ea8f1aaa790fd3a.jpg', '2018-08-23 11:02:36', '2018-08-23 11:02:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1931', '635', '2', '8e30585d46f0296001b68afe015d0146.jpg', '2018-08-23 11:02:36', '2018-08-23 11:02:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1932', '635', '2', '4c697e39f7e266bbdec3876c42e0a079.jpg', '2018-08-23 11:02:36', '2018-08-23 11:02:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1933', '635', '2', 'd190c0c125595f6da4413520c02a0ac1.jpg', '2018-08-23 11:02:36', '2018-08-23 11:02:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1934', '635', '3', 'dcc953be6126e00820524fa53ddba99b.jpg', '2018-08-23 11:04:52', '2018-08-23 11:04:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1935', '595', '2', '614876d4c23d683e85db2f52f0e18a97.jpg', '2018-08-23 12:26:41', '2018-08-23 12:26:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1936', '595', '3', 'b51c6d5b8f66470ad5fd1d7288ec03ca.jpg', '2018-08-23 12:27:09', '2018-08-23 12:27:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1937', '789', '1', 'ae6bb7a11b5d48045c5988e4e2743f01.jpg', '2018-08-23 12:55:11', '2018-08-23 12:55:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1938', '789', '2', '0289837d137155d63091b86d5b91a90d.jpg', '2018-08-23 12:55:25', '2018-08-23 12:55:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1939', '789', '2', 'e1adea63376b373a0d5a661d44a6f790.jpg', '2018-08-23 12:55:25', '2018-08-23 12:55:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1940', '789', '2', 'e544b24fe36ba2615431c2c005f4c230.jpg', '2018-08-23 12:55:25', '2018-08-23 12:55:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1941', '789', '3', '9aafdc415cbe97340bbb16c74969f40f.jpg', '2018-08-23 13:00:52', '2018-08-23 13:00:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1942', '713', '2', 'ff5ea8d4dc52b27940b052f1c4801f3c.jpg', '2018-08-23 13:59:48', '2018-08-23 13:59:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1943', '713', '3', '06ce5c93506ff64901b67512ab83a36c.jpg', '2018-08-23 13:59:58', '2018-08-23 13:59:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1944', '799', '1', '3116a7e1f162915e404420fa69d0db09.jpg', '2018-08-23 19:58:28', '2018-08-23 19:58:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1945', '799', '2', '32cc082610daff533352049ef926abd3.jpg', '2018-08-23 19:58:58', '2018-08-23 19:58:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1946', '799', '2', '8eb720f07501184499768f98d772d380.jpg', '2018-08-23 19:58:58', '2018-08-23 19:58:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1947', '799', '2', 'f3a5963c27e64e5afb71a9ebe50cfef1.jpg', '2018-08-23 19:58:58', '2018-08-23 19:58:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1948', '799', '2', '20fa54e11f0b0fbc46891deb39a5f3e1.jpg', '2018-08-23 19:58:58', '2018-08-23 19:58:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1949', '799', '2', 'f36a82a40b42fa54e9509d64d902e2ac.jpg', '2018-08-23 19:58:58', '2018-08-23 19:58:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1950', '799', '3', '62cfabb6621e4e0f229316bc8b7af541.jpg', '2018-08-23 20:01:46', '2018-08-23 20:01:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1951', '777', '1', '2112cc59443467ea50aaccd28fe021c9.jpg', '2018-08-24 13:35:35', '2018-08-24 13:35:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1952', '777', '2', '906830c28ea799e948ac5a9638379edb.jpg', '2018-08-24 13:35:47', '2018-08-24 13:35:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1953', '777', '3', '7e5b951fe882141ee2cee8da79e1a1b1.jpg', '2018-08-24 13:36:25', '2018-08-24 13:36:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1954', '803', '1', '6654389ef3b826cd3212115df11fb41e.jpg', '2018-08-25 10:41:09', '2018-08-25 10:41:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1955', '803', '1', 'c0967e0a25d7255549f2da94487e26a8.jpg', '2018-08-25 10:41:09', '2018-08-25 10:41:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1956', '803', '2', 'da0060eda45ceb979db22e62d9343ee8.jpg', '2018-08-25 10:41:21', '2018-08-25 10:41:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1957', '803', '2', 'c5cd30ed9c7fb82e682876ed05abd70a.jpg', '2018-08-25 10:41:21', '2018-08-25 10:41:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1958', '803', '2', '5ba63b70bdac29fb859f9afc42cae10c.jpg', '2018-08-25 10:41:21', '2018-08-25 10:41:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1959', '803', '3', 'c7e49ecb83c77a71411f0f13beea996b.jpg', '2018-08-25 10:42:13', '2018-08-25 10:42:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1960', '767', '2', '51ac750ac425c93cc6bf2c6f6bcb380d.jpg', '2018-08-27 11:56:37', '2018-08-27 11:56:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1961', '767', '3', '08e009259d8f16c34565b5dd553960cc.jpg', '2018-08-27 11:57:07', '2018-08-27 11:57:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1962', '570', '2', '6c7e6463728b8c157d2e1964a7c1a4de.jpg', '2018-08-27 12:20:40', '2018-08-27 12:20:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1963', '570', '3', 'a78effee226b7c5ea88e031842599747.jpg', '2018-08-27 12:21:01', '2018-08-27 12:21:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1964', '574', '2', '93e67ca685f665c885247caf54593ef8.jpg', '2018-08-27 12:25:48', '2018-08-27 12:25:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1965', '574', '3', 'e844f8b5aa903d416313f57549ca2ba9.jpg', '2018-08-27 12:26:11', '2018-08-27 12:26:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1966', '540', '2', 'cf42c6d1bbf5f05ba9e167225852739d.jpg', '2018-08-27 13:20:09', '2018-08-27 13:20:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1967', '540', '3', '493ed3402c2fa6c6776bc4e23e4c3af7.jpg', '2018-08-27 13:20:54', '2018-08-27 13:20:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1968', '746', '2', '6f753124343f286d69fa5df6c3a834ae.jpg', '2018-08-27 13:27:34', '2018-08-27 13:27:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1969', '746', '3', '79cfd3b67eb3a25e87f10c873a02396e.jpg', '2018-08-27 13:28:12', '2018-08-27 13:28:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1970', '543', '2', '06348e65b52f3de5d3c543753e47bf76.jpg', '2018-08-27 13:29:37', '2018-08-27 13:29:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1971', '543', '3', '97490a3eb98dd1aa1bc2fe3362a9b523.jpg', '2018-08-27 13:29:53', '2018-08-27 13:29:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1972', '718', '2', '607ca44fe51210de96166e1bec7bb800.jpg', '2018-08-27 13:32:37', '2018-08-27 13:32:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1973', '718', '3', '3c75ef475b635f67c6349006c18cb193.jpg', '2018-08-27 13:32:59', '2018-08-27 13:32:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1974', '747', '2', '796c3a9372486329e1075ae9c220211d.jpg', '2018-08-27 13:34:26', '2018-08-27 13:34:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1975', '747', '3', '170287633711613f24d15075c9b5772e.jpg', '2018-08-27 13:34:54', '2018-08-27 13:34:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1976', '742', '2', 'e1439c95a05cefaeb90c1517466f9f25.jpg', '2018-08-27 13:44:09', '2018-08-27 13:44:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1977', '742', '2', 'ad8dcf9afbbca9fb80afc312506f689d.jpg', '2018-08-27 13:44:09', '2018-08-27 13:44:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1978', '742', '3', '8f5bfdbcc4fc7cef31017729ceadca80.jpg', '2018-08-27 13:44:35', '2018-08-27 13:44:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1979', '573', '2', 'f515011d9805af9c62e1e692e2e7a790.jpg', '2018-08-27 14:01:29', '2018-08-27 14:01:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1980', '573', '3', '60d7e1c5966f250ba7f53126e8d5b90d.jpg', '2018-08-27 14:01:46', '2018-08-27 14:01:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1981', '633', '2', 'c8d3f638e97b6f024d3a32adc49f32a3.jpg', '2018-08-27 14:03:26', '2018-08-27 14:03:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1982', '633', '3', '274f829b500aba983b9a6ca304cba5ee.jpg', '2018-08-27 14:03:43', '2018-08-27 14:03:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1983', '794', '2', '3c0bd57e0f3ede08001588ad494482fa.jpg', '2018-08-27 14:05:10', '2018-08-27 14:05:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1984', '794', '2', 'f1cd9df2cda4230810b1b3a7f7f7b9f9.jpg', '2018-08-27 14:05:10', '2018-08-27 14:05:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1985', '794', '3', '9cedf98b2c37af7f6b702e06a81c5b94.jpg', '2018-08-27 14:05:30', '2018-08-27 14:05:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1986', '770', '2', '109d551e0e934cec3699f807dcb70231.jpg', '2018-08-27 14:15:00', '2018-08-27 14:15:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1987', '770', '3', '712eaf33ffab890906d92f979bfce4f0.jpg', '2018-08-27 14:15:22', '2018-08-27 14:15:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1988', '611', '2', '0de046c9c03a8a5d117c72d3ed967cb7.jpg', '2018-08-27 14:20:47', '2018-08-27 14:20:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1989', '611', '3', '838c70a1189ea903f3f7660ee4425852.jpg', '2018-08-27 14:21:16', '2018-08-27 14:21:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1990', '810', '2', 'b708eae301e607115faaac4ba833688d.jpg', '2018-08-27 14:33:26', '2018-08-27 14:33:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1991', '810', '2', 'fb33a4d55eac5758c2986863075648e4.jpg', '2018-08-27 14:33:26', '2018-08-27 14:33:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1992', '810', '3', '8959104ac98cc8f828472b56d4c727e8.jpg', '2018-08-27 14:33:46', '2018-08-27 14:33:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1993', '811', '2', '0a2122cbc8f8696cab7d0e036ca51aa6.jpg', '2018-08-27 14:36:37', '2018-08-27 14:36:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1994', '811', '3', '4c5bec0b3f1607a6559a6e1978e5e61a.jpg', '2018-08-27 14:37:04', '2018-08-27 14:37:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1995', '812', '2', 'e1d148498882232681fb2470d31ecbb2.jpg', '2018-08-27 14:39:09', '2018-08-27 14:39:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1996', '812', '3', 'f0f81daeaf3f55bac9177d6ac100807b.jpg', '2018-08-27 14:39:29', '2018-08-27 14:39:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1997', '478', '2', 'eb8dd7aa8152969d25546055ae8674ef.jpg', '2018-08-28 11:12:27', '2018-08-28 11:12:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1998', '478', '3', '49f1bc06ac42a7aca0bf5481cbdbedfe.jpg', '2018-08-28 11:15:35', '2018-08-28 11:15:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('1999', '521', '2', '8b04c57bafb899b7218cf3976d69706e.jpg', '2018-08-28 11:18:05', '2018-08-28 11:18:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2000', '521', '3', '89bbf624f47975a76a894356cf8d18b6.jpg', '2018-08-28 11:18:25', '2018-08-28 11:18:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2001', '306', '2', '3076a188d964eac4debdbd001b3cb623.jpg', '2018-08-28 11:23:35', '2018-08-28 11:23:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2002', '306', '3', 'f9158a5fe9a5df7a9ed82e6f56524fd1.jpg', '2018-08-28 11:23:48', '2018-08-28 11:23:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2003', '719', '2', '585baa3d7dd43f98fa11c5732ce4ef59.jpg', '2018-08-28 11:30:49', '2018-08-28 11:30:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2004', '719', '3', 'fa3f09c5888d17b057a2c28b3928131d.jpg', '2018-08-28 11:31:48', '2018-08-28 11:31:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2005', '331', '2', '00e53dab0923d3bcbe5408cf3768dbe9.jpg', '2018-08-28 11:48:53', '2018-08-28 11:48:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2006', '331', '3', '2ef121d1280ecb399cd60015e77a908f.jpg', '2018-08-28 11:49:19', '2018-08-28 11:49:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2007', '334', '2', 'be9f6b92f90923dc03da0c3b38e0d3fe.jpg', '2018-08-28 11:50:36', '2018-08-28 11:50:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2008', '334', '3', '08e68e6cba6083140cfb5917b45dc883.jpg', '2018-08-28 11:50:58', '2018-08-28 11:50:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2009', '335', '2', '869404b5a08fa8b724963125124f1d20.jpg', '2018-08-28 11:52:22', '2018-08-28 11:52:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2010', '335', '3', 'f3bf9f388fbb76c56151697f2b4a3a35.jpg', '2018-08-28 11:52:46', '2018-08-28 11:52:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2011', '711', '2', '5ea761e741ebadbd0f59894a2c318971.jpg', '2018-08-28 11:54:04', '2018-08-28 11:54:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2012', '711', '3', '7d421bf7ed719685c80cc7a1931a5ed1.jpg', '2018-08-28 11:54:34', '2018-08-28 11:54:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2013', '712', '2', '950368a210430352b08310df1c3062c7.jpg', '2018-08-28 11:56:09', '2018-08-28 11:56:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2014', '712', '3', '3f12bc4dab698127bf42480b0c0b0184.jpg', '2018-08-28 11:56:30', '2018-08-28 11:56:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2015', '665', '2', 'f4d4ffc4e0cf23ebbaf2dd7d23179ba2.jpg', '2018-08-28 12:07:32', '2018-08-28 12:07:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2016', '665', '3', '1f27df6ae0260488ea1e0891740bd3a0.jpg', '2018-08-28 12:07:57', '2018-08-28 12:07:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2017', '666', '2', '5b53e6fb353cee3149d6b209721a2146.jpg', '2018-08-28 12:09:47', '2018-08-28 12:09:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2018', '666', '3', '15328bae005afe821b5870be4efb8b64.jpg', '2018-08-28 12:10:08', '2018-08-28 12:10:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2019', '819', '2', '569d02e3e2954648acc2147b6ea69b47.jpg', '2018-08-28 12:12:18', '2018-08-28 12:12:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2020', '819', '3', '16ba034cca6fd61138d848c963ff4e86.jpg', '2018-08-28 12:13:05', '2018-08-28 12:13:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2021', '792', '2', '9b536b69b790a9476cb1332ed876a280.jpg', '2018-08-28 12:15:14', '2018-08-28 12:15:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2022', '792', '2', 'ca283f90a9b58f440f579b99dcf4a514.jpg', '2018-08-28 12:15:14', '2018-08-28 12:15:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2023', '792', '3', '551ccb75235d33d5397df899397476ce.jpg', '2018-08-28 12:15:43', '2018-08-28 12:15:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2024', '778', '2', 'bf72a9bfe3457f4eb206400b13a50291.jpg', '2018-08-28 12:46:14', '2018-08-28 12:46:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2025', '778', '2', '3f481e01ce968e97f87e78cebe64895c.jpg', '2018-08-28 12:46:14', '2018-08-28 12:46:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2026', '778', '2', '53221ec99ebb86c0d3fca0d74f0bab15.jpg', '2018-08-28 12:46:14', '2018-08-28 12:46:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2027', '778', '3', 'db81dda6e111e2be2f2417ba1ead3ebc.jpg', '2018-08-28 12:46:32', '2018-08-28 12:46:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2028', '804', '2', 'e16bac35272e89e0f96b7ccda161e024.jpg', '2018-08-28 12:50:50', '2018-08-28 12:50:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2029', '804', '3', '702013dd81fcfc9ed79ce400fdfe83b8.jpg', '2018-08-28 12:51:07', '2018-08-28 12:51:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2030', '222', '2', '89c9a9859484c9099500f021a4d50752.jpg', '2018-08-28 13:09:00', '2018-08-28 13:09:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2031', '222', '2', '9226b27dbb095cfcca6a6a4c3ead1084.jpg', '2018-08-28 13:09:00', '2018-08-28 13:09:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2032', '222', '2', '2892b922b79fab59c8b2fda6a04d6cda.jpg', '2018-08-28 13:09:00', '2018-08-28 13:09:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2033', '222', '3', '7718c0aac2cb4bec0c1690b187a0863c.jpg', '2018-08-28 13:17:07', '2018-08-28 13:17:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2034', '776', '1', 'be943ee1439581d1c9836bec7c9b37c9.jpg', '2018-08-28 13:46:47', '2018-08-28 13:46:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2035', '776', '1', '8c52dbc436bc1bb38e320b337b6cc7c3.jpg', '2018-08-28 13:46:47', '2018-08-28 13:46:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2036', '776', '2', '3360691a266afd24d3a561c4e0e616a8.jpg', '2018-08-28 13:47:14', '2018-08-28 13:47:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2037', '776', '3', 'cc7194eee23c5ec0419da1ee2ffd8a1d.jpg', '2018-08-28 13:49:07', '2018-08-28 13:49:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2038', '816', '1', 'bc5047b80afaf695134d1dd515da8df7.jpg', '2018-08-29 08:32:40', '2018-08-29 08:32:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2039', '816', '1', '944c538d388ce3da7d61df357e654617.jpg', '2018-08-29 08:32:40', '2018-08-29 08:32:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2040', '816', '2', '7fc408d64acb180fd7228508897ce663.jpg', '2018-08-29 08:32:59', '2018-08-29 08:32:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2041', '816', '3', 'b935a55d1bd6bfee01bebb57bb16d222.jpg', '2018-08-29 08:34:34', '2018-08-29 08:34:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2042', '520', '2', '23ea7a5f0a88ee98497d39deee174b24.jpg', '2018-08-30 09:29:19', '2018-08-30 09:29:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2043', '520', '3', '5b26e67eea5644420c2f853b5a1b3f3d.jpg', '2018-08-30 09:29:31', '2018-08-30 09:29:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2044', '558', '2', 'cc72548218884e163becf94666865ee9.jpg', '2018-08-30 09:36:57', '2018-08-30 09:36:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2045', '558', '3', '3732624ed6cc75354b0320a1247b1534.jpg', '2018-08-30 09:37:27', '2018-08-30 09:37:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2046', '509', '2', '475aa64b5d90e05181d1accca05cf0eb.jpg', '2018-08-30 09:52:10', '2018-08-30 09:52:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2047', '509', '3', '41c7efd979848da0fd4e6eb3d64ef8ee.jpg', '2018-08-30 09:52:46', '2018-08-30 09:52:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2048', '807', '1', '1f0f2d1e96bd75cd913e3427d55f5fc6.jpg', '2018-08-30 10:37:08', '2018-08-30 10:37:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2049', '807', '2', '12195dd94bb0ffe843482f4e2dd4285d.jpg', '2018-08-30 10:37:21', '2018-08-30 10:37:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2050', '807', '3', 'a4c8ec3687d332514b9bcb0977e8fbe8.jpg', '2018-08-30 10:38:14', '2018-08-30 10:38:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2051', '430', '1', 'a7a5631c06d80894e4f3239231a04be4.jpg', '2018-08-30 10:51:13', '2018-08-30 10:51:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2052', '430', '2', '5eb6c7923d60b8d05470829a5ce67ab8.jpg', '2018-08-30 10:51:23', '2018-08-30 10:51:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2053', '430', '3', '6dca5e36bc18292e8a012387edaf3e0d.jpg', '2018-08-30 10:52:58', '2018-08-30 10:52:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2054', '691', '1', '6f174ded5cc4c2dc77b3d6da9bafaa7d.jpg', '2018-08-30 11:09:10', '2018-08-30 11:09:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2055', '691', '2', '60d3f467f1ee7d6234d5b074afc86dbb.jpg', '2018-08-30 11:09:23', '2018-08-30 11:09:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2056', '691', '2', '298e71653611772799a30de2f13b056d.jpg', '2018-08-30 11:09:23', '2018-08-30 11:09:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2057', '691', '3', '1c0fa0a288a4fc06b5b05846fa5ea0b4.jpg', '2018-08-30 11:10:12', '2018-08-30 11:10:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2058', '494', '1', '58863d0c5e36082a89bf59797bd89341.jpg', '2018-08-30 11:12:38', '2018-08-30 11:12:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2059', '494', '2', '5c49bfe34ea5f9a4b9960283e8825dd3.jpg', '2018-08-30 11:13:07', '2018-08-30 11:13:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2060', '494', '3', '4746849078d07cdec514823f8223f0c7.jpg', '2018-08-30 11:15:25', '2018-08-30 11:15:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2061', '399', '2', '46d8f5b2a68539bc696d7303746e63d3.jpg', '2018-08-30 11:17:12', '2018-08-30 11:17:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2062', '399', '3', '38ec8f0e934b0f4134ac979b2c0be3ca.jpg', '2018-08-30 11:17:58', '2018-08-30 11:17:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2063', '831', '1', 'ce2580a4d70cef808801df35d6a93f35.jpg', '2018-08-30 12:28:27', '2018-08-30 12:28:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2064', '831', '2', '3d506fc89bb421e21c610dcb87ea3d3d.jpg', '2018-08-30 12:28:46', '2018-08-30 12:28:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2065', '831', '3', '1dcc6ea38e7273a52a3a995d76cd8b4c.jpg', '2018-08-30 12:29:26', '2018-08-30 12:29:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2066', '831', '3', '20dd2e361a7fbce93a05ac52e4d6ac71.jpg', '2018-08-30 12:29:30', '2018-08-30 12:29:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2067', '823', '1', '1a9a8f2efe476e20103d59a80f01e6f9.jpg', '2018-08-30 14:24:44', '2018-08-30 14:24:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2068', '823', '2', 'ea5059fed776f6ce875f399ba83fb564.jpg', '2018-08-30 14:25:12', '2018-08-30 14:25:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2069', '823', '2', '5772735bff734cf55cc9cff3145e6ca7.jpg', '2018-08-30 14:25:12', '2018-08-30 14:25:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2070', '823', '2', '15c63b2bc12f2fa68b230a3a1808a38d.jpg', '2018-08-30 14:25:12', '2018-08-30 14:25:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2071', '823', '2', '9e2c8c73c17173fe8e341f9089042180.jpg', '2018-08-30 14:25:12', '2018-08-30 14:25:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2072', '823', '3', '0809e89dfcb245607559be7681b4c12a.jpg', '2018-08-30 14:26:36', '2018-08-30 14:26:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2073', '800', '1', 'd99e3fb53feb194abd5667e086366175.jpg', '2018-08-30 14:27:29', '2018-08-30 14:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2074', '800', '1', 'df388e4ab76d7699c810a47f1a466d38.jpg', '2018-08-30 14:27:29', '2018-08-30 14:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2075', '800', '2', '9fd85ec102cf6cada866a8bad6337180.jpg', '2018-08-30 14:28:08', '2018-08-30 14:28:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2076', '800', '2', '695409be213ba86c38dfea13f51d4fd2.jpg', '2018-08-30 14:28:08', '2018-08-30 14:28:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2077', '800', '2', 'a320470c12041caaa2728d2e6775fa56.jpg', '2018-08-30 14:28:08', '2018-08-30 14:28:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2078', '800', '2', '1b84eb1cfe0a783417dadba90828f983.jpg', '2018-08-30 14:28:08', '2018-08-30 14:28:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2079', '800', '2', '23be3931024eb853006452193f6969e1.jpg', '2018-08-30 14:28:08', '2018-08-30 14:28:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2080', '800', '2', 'bc7bcd5db0eba14838889d905e63c0d0.jpg', '2018-08-30 14:28:08', '2018-08-30 14:28:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2081', '800', '3', '30f93588c0d3b2a217e282d489dd884b.jpg', '2018-08-30 14:29:05', '2018-08-30 14:29:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2082', '836', '2', 'ad900afd2e5b10ec7259e12ef6855486.jpg', '2018-08-31 11:13:38', '2018-08-31 11:13:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2083', '836', '3', '124a0140d00be7e35a05a723ae0ff258.jpg', '2018-08-31 11:13:59', '2018-08-31 11:13:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2084', '737', '2', 'fe86ccc6a1ec874c238ec168733a8d55.jpg', '2018-08-31 11:15:33', '2018-08-31 11:15:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2085', '737', '3', 'dfb0e3a9867b1da3cc835495b26bf801.jpg', '2018-08-31 11:15:44', '2018-08-31 11:15:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2086', '639', '2', 'c6614d60e663c1875a5e8dcd79354563.jpg', '2018-08-31 11:20:20', '2018-08-31 11:20:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2087', '639', '3', 'd1c4f7cc1c11705c4489f8dfe1016d51.jpg', '2018-08-31 11:20:41', '2018-08-31 11:20:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2088', '685', '2', '0722ce60a950380585c0cd0cb5f0e078.jpg', '2018-08-31 11:24:22', '2018-08-31 11:24:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2089', '685', '3', '2e22ad10ac79a4e2228c26554d563410.jpg', '2018-08-31 11:24:47', '2018-08-31 11:24:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2090', '684', '2', '6fdee36d53d05a2fc6dff5aaf848b2b9.jpg', '2018-08-31 13:12:37', '2018-08-31 13:12:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2091', '684', '2', '90df9ad629e428b72d4282183a250e17.jpg', '2018-08-31 13:12:37', '2018-08-31 13:12:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2092', '684', '2', 'b891d7c8ea362ae5c7778c16657ba017.jpg', '2018-08-31 13:12:37', '2018-08-31 13:12:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2093', '684', '3', '4a34245e9950a29eb50ffc745a1eec6b.jpg', '2018-08-31 13:12:54', '2018-08-31 13:12:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2094', '607', '1', '990448a008635ec9ebe119e31315165f.jpg', '2018-08-31 13:20:20', '2018-08-31 13:20:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2095', '607', '2', '7058624aa36e760e7ceab49325b785b0.jpg', '2018-08-31 13:20:32', '2018-08-31 13:20:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2096', '607', '3', '021e9f11c17a377a5636dce09baaa845.jpg', '2018-08-31 13:21:05', '2018-08-31 13:21:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2097', '822', '1', 'dde93b7c184a402edc6b7a5e27bba63c.jpg', '2018-08-31 14:35:46', '2018-08-31 14:35:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2098', '822', '1', '6ca90c8ccab6119e586a2604324c7e7f.jpg', '2018-08-31 14:35:46', '2018-08-31 14:35:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2099', '822', '1', '49ef33779832c0fee0c512d61da69092.jpg', '2018-08-31 14:35:46', '2018-08-31 14:35:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2100', '822', '1', '5b5d618e10f5be2a1f5577c8df646ebc.jpg', '2018-08-31 14:35:46', '2018-08-31 14:35:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2101', '822', '2', 'f87dae63b543a3e967fc00fdb2c7b3b0.jpg', '2018-08-31 14:37:18', '2018-08-31 14:37:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2102', '822', '2', 'f4873ee2f320363d48da9d017f0a6e40.jpg', '2018-08-31 14:37:18', '2018-08-31 14:37:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2103', '822', '2', 'f901cac420c35dd999dd2d2d28857532.jpg', '2018-08-31 14:37:18', '2018-08-31 14:37:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2104', '822', '2', 'd28fd75e7c1bf955f14397cf576c1373.jpg', '2018-08-31 14:37:23', '2018-08-31 14:37:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2105', '822', '2', '353d88f8f6bd27abf35e7c49d841795a.jpg', '2018-08-31 14:37:23', '2018-08-31 14:37:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2106', '822', '2', 'c39bc8039d9618f9752d8a0396035ae5.jpg', '2018-08-31 14:37:23', '2018-08-31 14:37:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2107', '822', '3', 'ba487302fc61421275f34b088c827f97.jpg', '2018-08-31 14:39:58', '2018-08-31 14:39:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2108', '846', '1', 'bfd8e398af68a607d5f1bf7a65d59230.jpg', '2018-09-03 10:42:31', '2018-09-03 10:42:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2109', '846', '1', 'e27286118d0820dbce4f4b9b3f1926c2.jpg', '2018-09-03 10:42:31', '2018-09-03 10:42:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2110', '846', '2', '45acbeba1ca1ffafa334837eca91c8f9.jpg', '2018-09-03 10:43:07', '2018-09-03 10:43:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2111', '846', '2', '6ac93a550ef34d8ffbfd8a26323e05bc.jpg', '2018-09-03 10:43:07', '2018-09-03 10:43:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2112', '846', '2', '531b759e53ff645fe5091452d2d4cfc3.jpg', '2018-09-03 10:43:07', '2018-09-03 10:43:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2113', '846', '2', '5c39c0557dbec38685aafa529e568b4d.jpg', '2018-09-03 10:43:07', '2018-09-03 10:43:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2114', '846', '2', '550d872be9595107fb2f75d5d89e8132.jpg', '2018-09-03 10:43:07', '2018-09-03 10:43:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2115', '846', '2', '53370c28117baf8554cbf93a7f47313d.jpg', '2018-09-03 10:43:07', '2018-09-03 10:43:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2116', '846', '3', '36caf5e6e045578e8a7782b62a3bd80a.jpg', '2018-09-03 10:45:59', '2018-09-03 10:45:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2117', '835', '1', 'e80ea6b098df0127f10a42db09cbdf00.jpg', '2018-09-03 12:11:18', '2018-09-03 12:11:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2118', '835', '2', '1192be69495b459931322569d2d17e2b.jpg', '2018-09-03 12:11:31', '2018-09-03 12:11:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2119', '835', '2', 'db1f897baef67de43328bb6514118f55.jpg', '2018-09-03 12:11:31', '2018-09-03 12:11:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2120', '835', '3', 'f3907046d4926b2e020d68b6ed4f711c.jpg', '2018-09-03 12:12:45', '2018-09-03 12:12:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2121', '818', '1', '8edf489ac66dbbe647e357c9fdb0b35b.jpg', '2018-09-03 12:57:46', '2018-09-03 12:57:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2122', '818', '1', 'de3c48c2674592b30b213d93b6f6b8e5.jpg', '2018-09-03 12:57:46', '2018-09-03 12:57:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2123', '818', '1', '3b3ba95eb6e9cd13bae130cc74880185.jpg', '2018-09-03 12:57:46', '2018-09-03 12:57:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2124', '818', '1', '06615035a983d4ed23a6daa88ffc89f1.jpg', '2018-09-03 12:57:46', '2018-09-03 12:57:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2125', '818', '2', '52944544962adafab12b6aa29b6c83cc.jpg', '2018-09-03 12:58:34', '2018-09-03 12:58:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2126', '818', '2', '705449ddea2c90a128554b46181df672.jpg', '2018-09-03 12:58:34', '2018-09-03 12:58:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2127', '818', '2', '9a9b3665204a27e8fd29be253b03ebde.jpg', '2018-09-03 12:58:34', '2018-09-03 12:58:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2128', '818', '2', '9db2eb81d9612d0b0e2afc12e52e1496.jpg', '2018-09-03 12:58:34', '2018-09-03 12:58:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2129', '818', '2', '32f1f601d24838fd292d949d451870d7.jpg', '2018-09-03 12:58:34', '2018-09-03 12:58:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2130', '818', '2', '36b1e23a16919da814416fe1554d3a44.jpg', '2018-09-03 12:58:34', '2018-09-03 12:58:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2131', '818', '3', '913a90393cf37ef9fded778450791b1a.jpg', '2018-09-03 13:00:09', '2018-09-03 13:00:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2132', '848', '1', '2d41a97468b7030a483fbdc0f59b0cd0.jpg', '2018-09-03 18:54:46', '2018-09-03 18:54:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2133', '848', '2', '067d51cdde3eb5336b68baa64e11bc6c.jpg', '2018-09-03 18:55:20', '2018-09-03 18:55:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2134', '848', '3', 'f9e0d11ed091d9c0d1992e3ffc370ba5.jpg', '2018-09-03 18:56:16', '2018-09-03 18:56:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2135', '729', '2', 'a146b67cbc221e719e8619b314226864.jpg', '2018-09-04 13:28:25', '2018-09-04 13:28:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2136', '729', '3', '617bbd10c5c8b15d3dc55be09c63182d.jpg', '2018-09-04 13:29:09', '2018-09-04 13:29:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2137', '728', '2', 'b3d4bbd681e6ced20a46b892a704e5d1.jpg', '2018-09-04 13:33:41', '2018-09-04 13:33:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2138', '728', '3', 'e0f710cef13378ef4a20b9356a6496ff.jpg', '2018-09-04 13:34:02', '2018-09-04 13:34:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2139', '843', '2', '6f0d8aa16017acfd234644daa0c6652f.jpg', '2018-09-04 13:37:12', '2018-09-04 13:37:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2140', '843', '3', '82eefeb1371e4e0d3f2eb57e4383f639.jpg', '2018-09-04 13:37:43', '2018-09-04 13:37:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2141', '844', '2', '1c8235f0b3800a0aefcf781b119c048a.jpg', '2018-09-04 13:40:54', '2018-09-04 13:40:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2142', '844', '3', '34153e7ab2f61cb252df722b585a9412.jpg', '2018-09-04 13:41:12', '2018-09-04 13:41:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2143', '678', '2', '2428d8bfd9374da31df18fe1bd31ab6e.jpg', '2018-09-04 13:48:35', '2018-09-04 13:48:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2144', '678', '3', '83bdec510986cdd4ba4f1f325ff85895.jpg', '2018-09-04 13:48:58', '2018-09-04 13:48:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2145', '675', '2', 'feb88ea27010f1f4544be015792542ff.jpg', '2018-09-04 13:50:04', '2018-09-04 13:50:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2146', '675', '3', 'b16f87ab3d252a14f201a17e4260307c.jpg', '2018-09-04 13:50:22', '2018-09-04 13:50:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2147', '674', '2', '36eed3280373590a137e24115e1cde81.jpg', '2018-09-04 13:51:32', '2018-09-04 13:51:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2148', '674', '3', '594951076b9945907ff5fb11eccfbfe9.jpg', '2018-09-04 13:51:56', '2018-09-04 13:51:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2149', '676', '2', 'd3d230e47e06745b63d5e40917f0f5d7.jpg', '2018-09-04 13:53:23', '2018-09-04 13:53:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2150', '676', '3', 'a3e342c74c286f94b5531d7ee480c2ae.jpg', '2018-09-04 13:53:51', '2018-09-04 13:53:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2151', '735', '2', '8fd62911e819315b69ef0d1712f77999.jpg', '2018-09-04 13:59:33', '2018-09-04 13:59:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2152', '735', '3', 'f93208c31453a7c29e0b1f129f845cc8.jpg', '2018-09-04 13:59:53', '2018-09-04 13:59:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2153', '768', '2', '06275abc979d91e0d96c4caf2f9ce82b.jpg', '2018-09-04 14:01:26', '2018-09-04 14:01:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2154', '768', '3', 'e04af5209def473c75bc56f94b1e2b96.jpg', '2018-09-04 14:01:44', '2018-09-04 14:01:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2155', '566', '2', 'eee674867ee941e7c0e562a2f9fbaf83.jpg', '2018-09-04 17:04:50', '2018-09-04 17:04:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2156', '566', '2', '1d902dda00ccde3523e16ca948d7bd3b.jpg', '2018-09-04 17:04:50', '2018-09-04 17:04:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2157', '566', '2', 'cef7f88458470a93ea57cdec437fa4bf.jpg', '2018-09-04 17:04:50', '2018-09-04 17:04:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2158', '566', '3', 'c864494da9567f35140a2b0105330acc.jpg', '2018-09-04 17:05:07', '2018-09-04 17:05:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2159', '561', '2', 'a424d4c97789fb2a6633da1fa254140b.jpg', '2018-09-04 18:03:40', '2018-09-04 18:03:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2160', '561', '3', '9fba8c3ec27a96018e16165d90af8aec.jpg', '2018-09-04 18:04:01', '2018-09-04 18:04:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2161', '598', '2', '7e4af70e6c99bc41584a77c15ad71bf5.jpg', '2018-09-05 09:35:45', '2018-09-05 09:35:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2162', '598', '3', '2a637be36f5371bb49519a2b38c6a880.jpg', '2018-09-05 09:36:03', '2018-09-05 09:36:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2163', '599', '2', 'e1d577a305adaca977e1de1b3bf139f1.jpg', '2018-09-05 09:37:32', '2018-09-05 09:37:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2164', '599', '3', 'fa6c4d87f039df7ae70f6bc6800d1ed5.jpg', '2018-09-05 09:37:50', '2018-09-05 09:37:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2165', '771', '2', 'cf98de97c51fdad32dca94211506df47.jpg', '2018-09-05 09:38:49', '2018-09-05 09:38:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2166', '771', '3', '41e699d7411ce85c2e408a17db660fd2.jpg', '2018-09-05 09:39:10', '2018-09-05 09:39:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2167', '585', '2', '839c17e0dba824dd780ae9b6a010b492.jpg', '2018-09-05 09:42:04', '2018-09-05 09:42:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2168', '585', '3', 'c7385f1916caed0cd41f08bf951528dd.jpg', '2018-09-05 09:42:34', '2018-09-05 09:42:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2169', '659', '2', 'df2bb9563d01460daaf8df04b31294cb.jpg', '2018-09-05 10:34:02', '2018-09-05 10:34:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2170', '659', '3', '5a94ad3b3472b6e8a1b9baa48133e8e3.jpg', '2018-09-05 10:34:29', '2018-09-05 10:34:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2171', '753', '2', 'fea1c1b44a7a3724eecbb89bac1e5a78.jpg', '2018-09-05 10:44:13', '2018-09-05 10:44:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2172', '753', '3', 'aa712798be934c602f70f63387c94e22.jpg', '2018-09-05 10:44:32', '2018-09-05 10:44:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2173', '755', '2', '9e1f8acf52b628bb7a4b6737395abecb.jpg', '2018-09-05 10:47:10', '2018-09-05 10:47:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2174', '755', '3', 'dc04326fe15f723711e8b6cfe5e611b3.jpg', '2018-09-05 10:47:30', '2018-09-05 10:47:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2175', '616', '2', 'e4964b2e314771f0eeacca579346ff07.jpg', '2018-09-05 10:51:43', '2018-09-05 10:51:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2176', '616', '3', '82794ce66530485d260259e0009cc588.jpg', '2018-09-05 10:52:07', '2018-09-05 10:52:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2177', '731', '2', '6118ddbcda807ad70158e19fff3f3906.jpg', '2018-09-05 10:53:58', '2018-09-05 10:53:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2178', '731', '3', 'd69416185d2fdca2ab933309fc127348.jpg', '2018-09-05 10:54:15', '2018-09-05 10:54:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2179', '634', '2', '77226fd6a2609c4b2be51f544ef400de.jpg', '2018-09-05 12:44:45', '2018-09-05 12:44:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2180', '634', '3', '6cd976257570b89b26e66b83a70bd7d8.jpg', '2018-09-05 12:45:03', '2018-09-05 12:45:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2181', '734', '2', 'bc3b7474d2961195f5a942745da8b5fc.jpg', '2018-09-05 12:50:28', '2018-09-05 12:50:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2182', '734', '3', '4e01e65fdd4a2ec3038f8078be60ab3a.jpg', '2018-09-05 12:50:49', '2018-09-05 12:50:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2183', '548', '2', '1bf9225e413baaf9472a9fcdae7255db.jpg', '2018-09-05 12:56:22', '2018-09-05 12:56:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2184', '548', '3', '346064fb3be4a21282981d9ada9072af.jpg', '2018-09-05 12:57:01', '2018-09-05 12:57:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2185', '669', '2', '3b41cd7ab315a84b6cd13053351a087a.jpg', '2018-09-05 13:06:09', '2018-09-05 13:06:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2186', '669', '3', '9a691b460bc1bd018197f8237ad265b9.jpg', '2018-09-05 13:06:27', '2018-09-05 13:06:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2187', '671', '2', '5b649733b6d83cdfccb1d3466ce4b9e5.jpg', '2018-09-05 13:07:27', '2018-09-05 13:07:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2188', '671', '3', 'a2219f73a2cbcc530a5f6287967e4ac4.jpg', '2018-09-05 13:07:43', '2018-09-05 13:07:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2189', '672', '2', '7fdec1b23fe53264d82d39dfc1ea4742.jpg', '2018-09-05 13:08:57', '2018-09-05 13:08:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2190', '672', '3', '262e698576e03182e5cf5fde831cfea5.jpg', '2018-09-05 13:09:17', '2018-09-05 13:09:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2191', '663', '2', 'e99b1d350e8d3caad71685620d34eb45.jpg', '2018-09-05 13:23:05', '2018-09-05 13:23:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2192', '663', '3', 'acfff6855de4db289f85074275fb309f.jpg', '2018-09-05 13:23:24', '2018-09-05 13:23:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2193', '660', '2', '1afce0fa983b1e087fb65a26f08bb7a2.jpg', '2018-09-05 13:26:24', '2018-09-05 13:26:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2194', '660', '3', '20cd949891696549e9d5accbba7748a6.jpg', '2018-09-05 13:26:44', '2018-09-05 13:26:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2195', '740', '2', '8b2992baae923f1670ff7961f6f16d20.jpg', '2018-09-05 13:38:06', '2018-09-05 13:38:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2196', '740', '3', '57d9f500de1a01d6dfba336e7150b951.jpg', '2018-09-05 13:38:21', '2018-09-05 13:38:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2197', '311', '2', '383c41e751e9cf48b37159fb3326796f.jpg', '2018-09-05 13:47:26', '2018-09-05 13:47:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2198', '311', '2', '29b70dbc779aae6ba912479bbd85aab5.jpg', '2018-09-05 13:47:26', '2018-09-05 13:47:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2199', '311', '3', '8cd0dc92daf37779320adfc1bcacd9b1.jpg', '2018-09-05 13:47:47', '2018-09-05 13:47:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2200', '359', '2', '9aaf33945908f965c0074115d3493f09.jpg', '2018-09-05 13:54:33', '2018-09-05 13:54:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2201', '359', '3', '9356830dc4eb1280ddfa90e46f874b09.jpg', '2018-09-05 13:54:48', '2018-09-05 13:54:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2202', '526', '2', '927817da0fad107fe8d59dacdd65927d.jpg', '2018-09-05 13:59:36', '2018-09-05 13:59:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2203', '526', '3', 'ef81ec166fd370e91fc1547d12e93c27.jpg', '2018-09-05 13:59:51', '2018-09-05 13:59:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2204', '867', '2', '142ab23eb2bbf7a80dd01c961a3d8b5f.jpg', '2018-09-07 10:09:32', '2018-09-07 10:09:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2205', '867', '3', '2269775c91a32f3aeaa38444c1419496.jpg', '2018-09-07 10:09:56', '2018-09-07 10:09:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2206', '720', '2', 'a04636d40d892aa11f45f7bce369052d.jpg', '2018-09-07 10:22:27', '2018-09-07 10:22:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2207', '720', '2', '66e54f9c6201b5610c8773b44331ccb3.jpg', '2018-09-07 10:22:27', '2018-09-07 10:22:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2208', '720', '3', 'bf63d746a9ac92ad317856931edd3ad6.jpg', '2018-09-07 10:22:50', '2018-09-07 10:22:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2209', '866', '2', '14d16c983df4b94212b684cbaa9fd104.jpg', '2018-09-07 10:23:45', '2018-09-07 10:23:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2210', '866', '3', '6194410459ade0fadb14ee8a9ca3f4d9.jpg', '2018-09-07 10:24:03', '2018-09-07 10:24:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2211', '860', '2', '4b13bb5e580ff04e9796c8581894cd14.jpg', '2018-09-07 10:42:34', '2018-09-07 10:42:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2212', '860', '2', '75c10873aaef2b51e49228a91de08984.jpg', '2018-09-07 10:42:34', '2018-09-07 10:42:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2213', '860', '3', '3dbecc9dc7e4473a6a3e2374e1beda7f.jpg', '2018-09-07 10:43:02', '2018-09-07 10:43:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2214', '834', '1', '968cb486a623fe5199067369242e8fb9.jpg', '2018-09-07 12:03:44', '2018-09-07 12:03:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2215', '834', '1', 'ab7d58b9d43b449a7742f4bd508c7fd5.jpg', '2018-09-07 12:03:44', '2018-09-07 12:03:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2216', '834', '1', '303050012ec158d372c777a4f47b55e8.jpg', '2018-09-07 12:03:44', '2018-09-07 12:03:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2217', '834', '2', '5685f2edd7be91aee34ed9a6bb30e99a.jpg', '2018-09-07 12:04:04', '2018-09-07 12:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2218', '834', '2', '6d22b406e1d6dfa2afac20331a3a91ba.jpg', '2018-09-07 12:04:04', '2018-09-07 12:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2219', '834', '2', '3d1c9048c36b1f551e20c2ec6bca457b.jpg', '2018-09-07 12:04:04', '2018-09-07 12:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2220', '834', '3', '9e7893e2f5a96a838e106f94cf8d7e7a.jpg', '2018-09-07 12:04:59', '2018-09-07 12:04:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2221', '569', '2', '570cb7e298f425ae779514c30e583a47.jpg', '2018-09-07 12:05:15', '2018-09-07 12:05:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2222', '569', '3', '77a079ba6a9ebe3626d514d684478cd4.jpg', '2018-09-07 12:05:38', '2018-09-07 12:05:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2223', '336', '2', '1218ce2e8f97cd6cee8c91ca237831d9.jpg', '2018-09-07 12:07:29', '2018-09-07 12:07:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2224', '336', '3', '07cdc4fb8c383d218f3114c472e03ef8.jpg', '2018-09-07 12:07:41', '2018-09-07 12:07:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2225', '861', '1', 'be8b59a560c69c4bc7bc38bffef04089.jpg', '2018-09-07 12:16:32', '2018-09-07 12:16:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2226', '861', '1', '1ef8553b904c10c7298e26032ef26fdc.jpg', '2018-09-07 12:16:32', '2018-09-07 12:16:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2227', '861', '1', '203e0782bdbefe221ca618e121562d06.jpg', '2018-09-07 12:16:32', '2018-09-07 12:16:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2228', '861', '1', 'a31a9bd488befc9c5e5d95b6e87c3a4e.jpg', '2018-09-07 12:16:32', '2018-09-07 12:16:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2229', '861', '2', '2b255636025dcc8d8e3e4b4869f62324.jpg', '2018-09-07 12:17:12', '2018-09-07 12:17:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2230', '861', '2', 'a044d4395a70af125cfff471ba6279e8.jpg', '2018-09-07 12:17:12', '2018-09-07 12:17:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2231', '861', '2', 'acb59e2f27475659b14f792ff75a9b92.jpg', '2018-09-07 12:17:12', '2018-09-07 12:17:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2232', '861', '3', 'cdb39b61c1f1d162c8d7594cc45b46cc.jpg', '2018-09-07 12:18:40', '2018-09-07 12:18:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2233', '507', '2', '5b026f3fa73ee7077b0fc24910d3e300.jpg', '2018-09-07 14:33:39', '2018-09-07 14:33:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2234', '507', '3', '554a37903f8636a2c870cb80e9f1b252.jpg', '2018-09-07 14:33:50', '2018-09-07 14:33:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2235', '702', '2', '7856301ea2610132c048ee45d4ae47b2.jpg', '2018-09-07 14:35:41', '2018-09-07 14:35:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2236', '702', '3', '292cf461d77189c7416ea7b528e3584c.jpg', '2018-09-07 14:36:06', '2018-09-07 14:36:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2237', '703', '2', 'b8c94fb8c04b1f956ddd6ecb0389729f.jpg', '2018-09-07 14:36:51', '2018-09-07 14:36:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2238', '703', '3', 'b0a204c05d58e5737e9c032261495751.jpg', '2018-09-07 14:37:23', '2018-09-07 14:37:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2239', '705', '2', '2bffb33a493e622433883f041d7a4dcc.jpg', '2018-09-07 14:38:17', '2018-09-07 14:38:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2240', '705', '3', 'fd44e015280d166a4b85c6497854342c.jpg', '2018-09-07 14:38:28', '2018-09-07 14:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2241', '874', '1', 'f9467d36d6124bca7fc48a0bc8166045.jpg', '2018-09-10 09:37:56', '2018-09-10 09:37:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2242', '874', '1', '905e462ae12fce808857ee54cee65680.jpg', '2018-09-10 09:37:56', '2018-09-10 09:37:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2243', '874', '2', '431c8777f122589fc7a388e91e2bd123.jpg', '2018-09-10 09:38:28', '2018-09-10 09:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2244', '874', '2', '0039b4218d0927ac06ad0b7410da29ab.jpg', '2018-09-10 09:38:28', '2018-09-10 09:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2245', '874', '2', '429c4e0776f0bbaf4a3f8ae3ecf63adc.jpg', '2018-09-10 09:38:28', '2018-09-10 09:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2246', '874', '2', '6e66702a70385a8c9ecafc32015aa4a6.jpg', '2018-09-10 09:38:28', '2018-09-10 09:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2247', '874', '2', '92050b2cfcef8aa9fe96586d079cdcf4.jpg', '2018-09-10 09:38:28', '2018-09-10 09:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2248', '874', '3', '6e82150e668cdebe4dce8beea7d05c53.jpg', '2018-09-10 09:39:27', '2018-09-10 09:39:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2249', '880', '1', '07de87ee84b0dd6bd3e6d0bc1b17daaa.jpg', '2018-09-10 11:24:51', '2018-09-10 11:24:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2250', '880', '2', '1afbda4a591dfca4b3bf436672fd9a67.jpg', '2018-09-10 11:25:00', '2018-09-10 11:25:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2251', '880', '3', 'a44f595c50d445bebdf180609c1374c8.jpg', '2018-09-10 11:25:17', '2018-09-10 11:25:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2252', '847', '1', '85da4b2d041fa938694db102522011fd.jpg', '2018-09-10 11:38:31', '2018-09-10 11:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2253', '847', '1', '36acc4924572803d3dd7d25f335aedd6.jpg', '2018-09-10 11:38:31', '2018-09-10 11:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2254', '847', '2', '8e77b96a66f71bf4e82e07b02a663d8a.jpg', '2018-09-10 11:39:05', '2018-09-10 11:39:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2255', '847', '2', 'c21949258b60998d8ff45ee5cad91e27.jpg', '2018-09-10 11:39:05', '2018-09-10 11:39:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2256', '847', '2', 'c079516e93cd0b06297c85d8a54a2e67.jpg', '2018-09-10 11:39:05', '2018-09-10 11:39:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2257', '847', '2', '880438dc4585340338b6ddcd92039c7f.jpg', '2018-09-10 11:39:05', '2018-09-10 11:39:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2258', '847', '3', '50948a7091f86eff1f29157ad7e46172.jpg', '2018-09-10 11:41:15', '2018-09-10 11:41:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2259', '641', '2', '7b26580ab432011ca5cf83a9541b73d4.jpg', '2018-09-10 12:52:02', '2018-09-10 12:52:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2260', '641', '3', '2d39f796913d8d5f505f09860d413d19.jpg', '2018-09-10 12:52:15', '2018-09-10 12:52:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2261', '727', '2', 'c0e815a0b2eb2b645a892bce498c3a1f.jpg', '2018-09-10 12:52:50', '2018-09-10 12:52:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2262', '727', '3', '309f9982cb6c33cdef1e6171d29f6b47.jpg', '2018-09-10 12:53:09', '2018-09-10 12:53:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2263', '534', '2', '96fef78c1790bf0438dcdb183c58ec93.jpg', '2018-09-10 12:54:00', '2018-09-10 12:54:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2264', '534', '3', '541aa2ad750516a944d5905f71df20bb.jpg', '2018-09-10 12:54:08', '2018-09-10 12:54:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2265', '732', '2', 'c018d9774b946c4bb98681c3bfd58e86.jpg', '2018-09-10 12:55:59', '2018-09-10 12:55:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2266', '732', '3', '245ca4ad4162988e632b462fd5f4b329.jpg', '2018-09-10 12:56:16', '2018-09-10 12:56:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2267', '469', '2', 'c06ac0819166e3004fbdb9d41612141c.jpg', '2018-09-10 12:58:01', '2018-09-10 12:58:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2268', '469', '3', '7dd47d4f7ff555fdc8cfebb5380326ae.jpg', '2018-09-10 12:58:20', '2018-09-10 12:58:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2269', '110', '2', 'cf59dcbe18849ede08265ac47937d919.jpg', '2018-09-10 12:59:15', '2018-09-10 12:59:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2270', '110', '3', 'e3d5adfbe07231cb817b70561912ae87.jpg', '2018-09-10 12:59:38', '2018-09-10 12:59:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2271', '609', '2', 'fba7692e9aa7e1c8a87a61e7f2a1dd2c.jpg', '2018-09-10 13:15:44', '2018-09-10 13:15:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2272', '609', '3', 'a64d3e387a886a900e7b697a875f7068.jpg', '2018-09-10 13:15:52', '2018-09-10 13:15:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2273', '707', '2', '56ca658a523d7da70e164db300ce9968.jpg', '2018-09-10 13:17:37', '2018-09-10 13:17:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2274', '707', '3', 'a88542183b7a6bca27aa45db624d8041.jpg', '2018-09-10 13:19:30', '2018-09-10 13:19:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2275', '726', '2', '2f75856891cd688ec2b13872aa3f4d64.jpg', '2018-09-10 13:29:21', '2018-09-10 13:29:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2276', '726', '3', 'aa523b12592e63403fab44d90daed0ba.jpg', '2018-09-10 13:29:43', '2018-09-10 13:29:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2277', '877', '1', '3af969b7ccfc3276b7927fb000955cd9.jpg', '2018-09-10 13:30:31', '2018-09-10 13:30:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2278', '877', '2', '58d7e37f2c16f233a4d95c2d47fc6f2b.jpg', '2018-09-10 13:31:21', '2018-09-10 13:31:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2279', '877', '3', '05f01fe8ad5fbb53e87fe6bd98aa0279.jpg', '2018-09-10 13:32:17', '2018-09-10 13:32:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2280', '882', '1', '52b010ec832c7e69a8ecb7ee1972fc21.jpg', '2018-09-10 16:13:49', '2018-09-10 16:13:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2281', '882', '2', '1433ee07334a3c4c63936c0c1c8bcdc8.jpg', '2018-09-10 16:14:07', '2018-09-10 16:14:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2282', '882', '2', 'bd423b2d41396279899cf66fb5b37fd3.jpg', '2018-09-10 16:14:07', '2018-09-10 16:14:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2283', '882', '2', '9f5be11c116ff750857153a4c5ab5bc2.jpg', '2018-09-10 16:14:07', '2018-09-10 16:14:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2284', '882', '2', '81a3e666eca165cab92ce973cd90d7c2.jpg', '2018-09-10 16:14:07', '2018-09-10 16:14:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2285', '882', '3', '511a580e10207ba562041c6934409b97.jpg', '2018-09-10 16:17:02', '2018-09-10 16:17:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2286', '856', '1', '330affc48045cd33085ab288cedc545d.jpg', '2018-09-10 16:20:21', '2018-09-10 16:20:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2287', '856', '1', '8db03cf7507df74e9189341f0cf0bc1c.jpg', '2018-09-10 16:20:21', '2018-09-10 16:20:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2288', '856', '2', '90d5df6d7114e8401cc3161fed7053f1.jpg', '2018-09-10 16:20:56', '2018-09-10 16:20:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2289', '856', '2', 'ca0b17a5d2c091259be03633b9078c58.jpg', '2018-09-10 16:20:56', '2018-09-10 16:20:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2290', '856', '2', '8d2a0ee78dae0f23022b8cb323ba7997.jpg', '2018-09-10 16:20:56', '2018-09-10 16:20:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2291', '856', '2', 'a2cdf8ecaad325811c5a596fc748670e.jpg', '2018-09-10 16:20:56', '2018-09-10 16:20:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2292', '856', '3', '617f1bfcd9c96296ba55c3e0086d8cf8.jpg', '2018-09-10 16:21:52', '2018-09-10 16:21:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2293', '889', '1', 'bef9e52985e04440d06431cb3a07f40f.jpg', '2018-09-10 16:25:56', '2018-09-10 16:25:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2294', '889', '1', 'e45fa2794ab85fc0520539c4b437ce0e.jpg', '2018-09-10 16:26:02', '2018-09-10 16:26:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2295', '840', '1', '203c3a6c2473209621c6e411954bc3b3.jpg', '2018-09-12 10:55:08', '2018-09-12 10:55:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2296', '840', '1', '2736a09e7699ec4838cb8c789f43e946.jpg', '2018-09-12 10:55:08', '2018-09-12 10:55:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2297', '840', '2', 'b087a41aba5e3ad482ca91cb4cfd1ea0.jpg', '2018-09-12 10:55:24', '2018-09-12 10:55:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2298', '840', '2', 'd062df9ff5802af017f5c68de316099d.jpg', '2018-09-12 10:55:24', '2018-09-12 10:55:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2299', '840', '3', '846d3e443fcca7cf6337c86e92532b6a.jpg', '2018-09-12 10:57:32', '2018-09-12 10:57:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2300', '854', '1', '764d9753527990dc19b8d995d0367ff7.jpg', '2018-09-12 11:17:34', '2018-09-12 11:17:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2301', '854', '2', '8d3a774dd160100d5fb18a407a22236a.jpg', '2018-09-12 11:17:45', '2018-09-12 11:17:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2302', '854', '3', '92fb2628c8734c4f296d4a40f1a64b97.jpg', '2018-09-12 12:13:15', '2018-09-12 12:13:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2303', '881', '1', 'ab3646b672f7455a110d06805f47b9b3.jpg', '2018-09-12 12:35:15', '2018-09-12 12:35:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2304', '881', '2', '4eac39be499b8ac3dcc6c83bdb145f98.jpg', '2018-09-12 12:35:25', '2018-09-12 12:35:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2305', '881', '3', 'd31371284c3d0c6b950e5b428d032663.jpg', '2018-09-12 12:36:55', '2018-09-12 12:36:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2306', '890', '1', 'a9e41f7c935449a022d6f32fc2fffe4d.jpg', '2018-09-12 13:12:52', '2018-09-12 13:12:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2307', '890', '1', '85bbe06a52914aa104a214065934a1f0.jpg', '2018-09-12 13:12:52', '2018-09-12 13:12:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2308', '890', '1', '484103d5177ebb72c12ea365f8fbe428.jpg', '2018-09-12 13:12:57', '2018-09-12 13:12:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2309', '890', '1', '438495cc92f41b746e78a843f1eb6481.jpg', '2018-09-12 13:12:57', '2018-09-12 13:12:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2310', '890', '2', '4561d6dd751dc3e7a2ee50164511545d.jpg', '2018-09-12 13:13:06', '2018-09-12 13:13:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2311', '890', '3', '43850d693874a7b182fa6f1955f078b3.jpg', '2018-09-12 13:14:08', '2018-09-12 13:14:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2312', '909', '1', '8881bde31cc747d9af05851f133e8b1c.jpg', '2018-09-13 10:22:26', '2018-09-13 10:22:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2313', '909', '1', '61f3f30afb40d563117bca93b276dfbd.jpg', '2018-09-13 10:22:26', '2018-09-13 10:22:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2314', '909', '2', '3a7759f860ddb4afad054f6f4bbed82f.jpg', '2018-09-13 10:22:45', '2018-09-13 10:22:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2315', '909', '2', 'c1794d99d352fc4c3ab3072707fe5cf3.jpg', '2018-09-13 10:22:45', '2018-09-13 10:22:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2316', '909', '2', '98286414ab3906b76d48bed67878a3dc.jpg', '2018-09-13 10:22:45', '2018-09-13 10:22:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2317', '909', '2', '15906c9757d0dfeaa7421695316ec56e.jpg', '2018-09-13 10:22:45', '2018-09-13 10:22:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2318', '909', '3', '286886065d7c05d84410bff043f75732.jpg', '2018-09-13 10:23:12', '2018-09-13 10:23:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2319', '893', '1', 'e85c77a1a8276a68d631f918d091da34.jpg', '2018-09-13 12:14:46', '2018-09-13 12:14:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2320', '893', '1', '694782eb135c779fc7745ae17f250f90.jpg', '2018-09-13 12:14:46', '2018-09-13 12:14:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2321', '893', '1', '613d0c2904e61a98def71fc5504c8c78.jpg', '2018-09-13 12:14:46', '2018-09-13 12:14:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2322', '893', '1', 'e738560bc2c0f59a164b7d3b464a45e3.jpg', '2018-09-13 12:14:46', '2018-09-13 12:14:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2323', '893', '2', '7e9debb24c9edf0031e3c49dec3f7f6d.jpg', '2018-09-13 12:15:07', '2018-09-13 12:15:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2324', '893', '2', '9dd5ae981e70a34f2377b54c0b774c29.jpg', '2018-09-13 12:15:07', '2018-09-13 12:15:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2325', '893', '2', '87ca91b82388466e67dc765173efbd6f.jpg', '2018-09-13 12:15:07', '2018-09-13 12:15:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2326', '893', '3', '08ca576d2391ce9b3396a219df6fc49c.jpg', '2018-09-13 12:18:18', '2018-09-13 12:18:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2327', '465', '1', 'b8e59ba756f3302080f69f7d3dfaa584.jpg', '2018-09-13 13:13:11', '2018-09-13 13:13:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2328', '465', '2', 'dd2ad995f9a6de5db747f370677c1fd0.jpg', '2018-09-13 13:13:21', '2018-09-13 13:13:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2329', '465', '3', '201837f23e408e176f3ae3757b97cd60.jpg', '2018-09-13 13:13:51', '2018-09-13 13:13:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2330', '830', '1', 'fac4502b3a279df99c3505366468e208.jpg', '2018-09-13 17:57:50', '2018-09-13 17:57:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2331', '830', '2', '0eeb7b45e30d0fb3e8b1973b50e7859d.jpg', '2018-09-13 17:57:58', '2018-09-13 17:57:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2332', '830', '3', '2a21bfe493cf62aa716296ba2fc1a135.jpg', '2018-09-13 17:58:38', '2018-09-13 17:58:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2333', '814', '2', '1f734a493433fb070a6fafa1a4c0f48d.jpg', '2018-09-14 09:20:49', '2018-09-14 09:20:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2334', '814', '3', '8c56eb2e3199e9321b11c0b7f2cab601.jpg', '2018-09-14 09:21:37', '2018-09-14 09:21:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2335', '865', '2', '920a3249ccaffaf5135edd2b4d6727e3.jpg', '2018-09-14 09:23:16', '2018-09-14 09:23:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2336', '865', '3', '1946347daa77fecab344d0003d6e5da7.jpg', '2018-09-14 09:23:29', '2018-09-14 09:23:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2337', '845', '2', 'a57fa14e4e3c6905cbd32e3c2ec38e75.jpg', '2018-09-14 09:29:34', '2018-09-14 09:29:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2338', '845', '3', '6672773f7a4a3dbf7713e437a131afe2.jpg', '2018-09-14 09:29:53', '2018-09-14 09:29:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2339', '658', '2', 'a8eaca9ef5f493abb042de04cbe8b8e0.jpg', '2018-09-14 09:39:11', '2018-09-14 09:39:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2340', '658', '3', '4ef28da69a73890cc655b811270a8cce.jpg', '2018-09-14 09:39:30', '2018-09-14 09:39:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2341', '769', '2', '6fa91c4784584b5950558d428d111061.jpg', '2018-09-14 09:40:47', '2018-09-14 09:40:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2342', '769', '3', 'cfe898388c451454fad4248fc857e109.jpg', '2018-09-14 09:41:05', '2018-09-14 09:41:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2343', '773', '2', '8eb56021e65faf9b01d651f22fb70bb0.jpg', '2018-09-14 09:42:11', '2018-09-14 09:42:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2344', '773', '3', '7ff3310164fbc6300c092ebee46ec3f6.jpg', '2018-09-14 09:42:25', '2018-09-14 09:42:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2345', '662', '2', '6702b1de753048d5b10fd868d4088251.jpg', '2018-09-14 09:43:22', '2018-09-14 09:43:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2346', '662', '3', 'a104a4a98e18ebb2bc59effa2284a74f.jpg', '2018-09-14 09:43:40', '2018-09-14 09:43:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2347', '637', '2', '182a89dca52e518f6daf9b3fba44d522.jpg', '2018-09-14 09:51:09', '2018-09-14 09:51:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2348', '637', '2', '6dcdf8235265afccbf10ea5a64287c5a.jpg', '2018-09-14 09:51:09', '2018-09-14 09:51:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2349', '637', '3', '6d614482e5966e207631af6419419610.jpg', '2018-09-14 09:51:45', '2018-09-14 09:51:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2350', '873', '2', '51d7a94cf969ddc7eb1557617e0127de.jpg', '2018-09-14 09:56:53', '2018-09-14 09:56:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2351', '873', '3', '2f6049aff1444a5ed1a3d7edd910128f.jpg', '2018-09-14 09:57:18', '2018-09-14 09:57:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2352', '927', '1', '4c7045f3ca09c4f7c461afcb81cb332c.jpg', '2018-09-14 09:59:41', '2018-09-14 09:59:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2353', '927', '1', '7e67df10ef3a64ff562c261d06529427.jpg', '2018-09-14 09:59:41', '2018-09-14 09:59:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2354', '927', '2', '1491a1ec1f2d4db795c8681c3b03c480.jpg', '2018-09-14 10:00:14', '2018-09-14 10:00:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2355', '927', '2', '1b003eaea9b1bf97fd1ccc72ba843ff5.jpg', '2018-09-14 10:00:14', '2018-09-14 10:00:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2356', '927', '2', 'f7f1490e4cca35f60f18211ff9cb59ff.jpg', '2018-09-14 10:00:14', '2018-09-14 10:00:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2357', '927', '2', 'c68cb48f6bffe1aa0d0314c6437d5cc8.jpg', '2018-09-14 10:00:14', '2018-09-14 10:00:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2358', '927', '3', 'e2087a29267e71f052ddb835c49edf08.jpg', '2018-09-14 10:02:21', '2018-09-14 10:02:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2359', '929', '2', 'd136c74db598059dd73fbe0d01226ebd.jpg', '2018-09-14 10:02:47', '2018-09-14 10:02:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2360', '929', '3', 'bf599f9e2905a5d57d8fe6cfd1b23a36.jpg', '2018-09-14 10:03:06', '2018-09-14 10:03:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2361', '904', '1', 'f8866e5eea98a0c8063e28f76e3b74c9.jpg', '2018-09-14 10:08:58', '2018-09-14 10:08:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2362', '904', '2', 'eeb6f23d76c229892d91d60778a21766.jpg', '2018-09-14 10:09:07', '2018-09-14 10:09:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2363', '904', '3', 'd868537b3720def7b15fe1b37e2da762.jpg', '2018-09-14 10:09:36', '2018-09-14 10:09:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2364', '853', '1', '88cfd0741ee30c6935f24198fe74eb65.jpg', '2018-09-14 10:11:38', '2018-09-14 10:11:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2365', '853', '2', '558fafbce693251ef294700fde15d285.jpg', '2018-09-14 10:11:51', '2018-09-14 10:11:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2366', '853', '3', '0785d3437034e1918b541716b76eaa60.jpg', '2018-09-14 10:12:07', '2018-09-14 10:12:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2367', '793', '1', 'd89134871bab2767dd846519da2a4078.jpg', '2018-09-14 10:20:11', '2018-09-14 10:20:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2368', '793', '2', '9fcbb38f1a53599f3e178f1b1e1b79c6.jpg', '2018-09-14 10:20:16', '2018-09-14 10:20:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2369', '793', '3', '01c81a14258f31ff89dd42f76826b2c1.jpg', '2018-09-14 10:20:42', '2018-09-14 10:20:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2370', '850', '1', 'df5b00b5c611712ae98b4be3be84e7aa.jpg', '2018-09-14 10:21:29', '2018-09-14 10:21:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2371', '850', '2', 'f925e48d85e7ed8a5a39527d1bec1bb4.jpg', '2018-09-14 10:21:34', '2018-09-14 10:21:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2372', '850', '3', '37507a95e629dd75d6983750d925ebd0.jpg', '2018-09-14 10:22:04', '2018-09-14 10:22:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2373', '838', '1', 'ffa4f5403b5b47c59d30ce72fb8136c4.jpg', '2018-09-14 10:24:12', '2018-09-14 10:24:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2374', '838', '2', '92a38045b37471dd49b8f008cb9924d1.jpg', '2018-09-14 10:24:20', '2018-09-14 10:24:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2375', '838', '3', 'ebf527e808ef84c58b29ccc6c638869a.jpg', '2018-09-14 10:24:49', '2018-09-14 10:24:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2376', '839', '1', '681c5e16a85c2ceb6c5a185e91b44e36.jpg', '2018-09-14 11:27:21', '2018-09-14 11:27:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2377', '839', '2', '324bb4ce8ce2949095b14efe15570be6.jpg', '2018-09-14 11:27:26', '2018-09-14 11:27:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2378', '839', '3', '2646423acd76e176c68af34cfe2be961.jpg', '2018-09-14 11:27:39', '2018-09-14 11:27:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2379', '443', '1', '9eb4d87e1b757f291c58d7bc08b257bd.jpg', '2018-09-14 12:51:39', '2018-09-14 12:51:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2380', '443', '2', '9b1604ae371bdc7b64ff9e57b822badf.jpg', '2018-09-14 12:51:52', '2018-09-14 12:51:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2381', '443', '3', '20786bf5c17bf0947dc906e66108fecc.jpg', '2018-09-14 12:52:32', '2018-09-14 12:52:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2382', '895', '1', '9135c367b8accf5102bfe28e2623dd7f.jpg', '2018-09-14 13:15:14', '2018-09-14 13:15:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2383', '895', '1', '7b07eaaf0dada412c4a9e81f64052329.jpg', '2018-09-14 13:15:14', '2018-09-14 13:15:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2384', '895', '2', 'c0d87801463ab9eeba0b8443295e3524.jpg', '2018-09-14 13:16:22', '2018-09-14 13:16:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2385', '895', '2', '2f82f0a570487204ed6d11a2ae7a2f5a.jpg', '2018-09-14 13:16:22', '2018-09-14 13:16:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2386', '895', '3', 'b84612499367ccfee055bef0074f9c4c.jpg', '2018-09-14 13:17:17', '2018-09-14 13:17:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2387', '930', '1', 'd67c4080626116ff15134ed7d68cf070.jpg', '2018-09-14 14:10:21', '2018-09-14 14:10:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2388', '930', '2', '700828b2f0fd8e0ab4f8556f699fc795.jpg', '2018-09-14 14:10:43', '2018-09-14 14:10:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2389', '930', '2', '8a2473a141d41492c894e29d72dd4408.jpg', '2018-09-14 14:10:43', '2018-09-14 14:10:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2390', '930', '2', 'c4d02c0badcac10caa98b009494b89d7.jpg', '2018-09-14 14:10:43', '2018-09-14 14:10:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2391', '930', '2', '4c75a3e4383076673d99c968bf0d02d8.jpg', '2018-09-14 14:10:43', '2018-09-14 14:10:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2392', '930', '3', '0b4b78dd30941ffc2e458e0b99dce067.jpg', '2018-09-14 14:11:33', '2018-09-14 14:11:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2393', '902', '1', '5a0db7941d687a5fd1cb42d8c8e1cf2c.jpg', '2018-09-14 14:20:20', '2018-09-14 14:20:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2394', '902', '1', 'e547b2de06e471116f83d59ef25576e9.jpg', '2018-09-14 14:20:20', '2018-09-14 14:20:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2395', '902', '2', 'a72a0b1a10253856c6fe6bcfa8619411.jpg', '2018-09-14 14:20:35', '2018-09-14 14:20:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2396', '902', '2', '459987d5e3329f23c0e6d4877af0684d.jpg', '2018-09-14 14:20:35', '2018-09-14 14:20:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2397', '902', '3', '3cf8d4fd397f5c6576d964296b4204b1.jpg', '2018-09-14 14:20:49', '2018-09-14 14:20:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2398', '832', '1', 'cd9042061cd23b3001693b3f8c18ffca.jpg', '2018-09-14 14:21:44', '2018-09-14 14:21:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2399', '832', '2', 'cfd8aeef45ca03ea1b33cf480ad12420.jpg', '2018-09-14 14:21:50', '2018-09-14 14:21:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2400', '832', '3', 'e1280f231be25a9204fd0c0d24171efc.jpg', '2018-09-14 14:22:03', '2018-09-14 14:22:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2401', '820', '2', '4a154401cf59da9ebc405bf1982eac15.jpg', '2018-09-14 16:26:08', '2018-09-14 16:26:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2402', '820', '3', 'ab92d8e563a99f7efca09ac94ca30251.jpg', '2018-09-14 16:26:39', '2018-09-14 16:26:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2403', '695', '2', '36c7f5c4ae9dd18d2744ee618c887b95.jpg', '2018-09-14 16:33:36', '2018-09-14 16:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2404', '695', '3', '7d1edd8447a78fa2f7ed6e255bfed768.jpg', '2018-09-14 16:33:47', '2018-09-14 16:33:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2405', '545', '2', '30944c2a7bf02bc338967adc41ebe10b.jpg', '2018-09-14 16:36:02', '2018-09-14 16:36:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2406', '545', '3', 'cc9353350e5454c08963fd6a5a960c01.jpg', '2018-09-14 16:36:32', '2018-09-14 16:36:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2407', '122', '2', 'e44172bcd0a2b1b3a1493ae9f6e2e046.jpg', '2018-09-14 16:40:33', '2018-09-14 16:40:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2408', '122', '3', '7ec2cfa3920ccd23d5cd7bb1948a76a1.jpg', '2018-09-14 16:41:33', '2018-09-14 16:41:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2409', '868', '2', 'a46e3b01ed60ede1ddcb4780e0d853a8.jpg', '2018-09-14 16:43:59', '2018-09-14 16:43:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2410', '868', '2', '3a6ad53bc1c16f958682770b796e0cfb.jpg', '2018-09-14 16:43:59', '2018-09-14 16:43:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2411', '868', '2', '9809b11b182baa1ebd4737ff3ff3de73.jpg', '2018-09-14 16:43:59', '2018-09-14 16:43:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2412', '868', '3', '7874577484f247e3f12ebbde09e9d9b6.jpg', '2018-09-14 16:44:16', '2018-09-14 16:44:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2413', '546', '2', 'e3606928a3e3973b60ef61652ded8f85.jpg', '2018-09-14 16:56:47', '2018-09-14 16:56:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2414', '546', '3', '48b59a1028532ccaf04ee324b531a97b.jpg', '2018-09-14 16:57:13', '2018-09-14 16:57:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2415', '751', '2', 'cea4e5a14a7d99e8f5d717e0a6857e3b.jpg', '2018-09-14 16:58:02', '2018-09-14 16:58:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2416', '751', '3', '4a3b238a3ee9fb34fcd90f52994120b2.jpg', '2018-09-14 16:58:20', '2018-09-14 16:58:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2417', '892', '1', 'fd69b6aa16b5000a9363b8c1792dff05.jpg', '2018-09-14 18:29:20', '2018-09-14 18:29:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2418', '892', '2', '8cf5cc1e4c37de24f591e1ba18d2e2e9.jpg', '2018-09-14 18:29:28', '2018-09-14 18:29:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2419', '892', '3', 'afacbbc9be9d41ce00189d26846fbe8e.jpg', '2018-09-14 18:30:29', '2018-09-14 18:30:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2420', '27', '2', '2ac59d06edc0ac4ef011911281c5f33a.jpg', '2018-09-14 22:58:56', '2018-09-14 22:58:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2421', '27', '3', 'dd9c7c076fc76e054ab1e0bb986c7541.jpg', '2018-09-14 22:59:13', '2018-09-14 22:59:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2422', '25', '2', '173c39b509c0cf85fad748fc05e2f752.jpg', '2018-09-14 23:00:24', '2018-09-14 23:00:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2423', '25', '3', '6576c4b5a2949ec3c7de5268e00008be.jpg', '2018-09-14 23:00:32', '2018-09-14 23:00:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2424', '28', '2', 'eb37875f05d1551db6e1cb132e8739bc.jpg', '2018-09-14 23:02:46', '2018-09-14 23:02:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2425', '28', '3', '34d71b85fd410eca05262f4c49ef4a5d.jpg', '2018-09-14 23:02:59', '2018-09-14 23:02:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2426', '323', '2', 'be3680ff0d97c5b5e95c5d5aa16cf054.jpg', '2018-09-14 23:08:14', '2018-09-14 23:08:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2427', '323', '2', '2db2a3182c94ad5e4d03dbbfe486fe6a.jpg', '2018-09-14 23:08:14', '2018-09-14 23:08:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2428', '323', '2', '44f87da090db431b1d06094bc0144af3.jpg', '2018-09-14 23:08:14', '2018-09-14 23:08:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2429', '323', '3', '4bee2a2ea74889e98e64f86c8475d5ee.jpg', '2018-09-14 23:08:40', '2018-09-14 23:08:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2430', '519', '2', '96fdc409dbb770550bfce462b220eda4.jpg', '2018-09-14 23:10:30', '2018-09-14 23:10:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2431', '519', '3', '585c1310103fd5527ffdfd2c30d0e961.jpg', '2018-09-14 23:11:18', '2018-09-14 23:11:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2432', '536', '2', '9d98f7a16e542a71a6c29421e18f2004.jpg', '2018-09-14 23:20:54', '2018-09-14 23:20:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2433', '536', '3', 'e34cd9307fb101288201501a52e75f77.jpg', '2018-09-14 23:21:17', '2018-09-14 23:21:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2434', '646', '2', '6790242d7ceb0473c78fdc506a6985cf.jpg', '2018-09-14 23:30:17', '2018-09-14 23:30:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2435', '646', '2', '75370c1be3f7de6937ce919309ccbd30.jpg', '2018-09-14 23:30:17', '2018-09-14 23:30:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2436', '646', '2', '3b0a82a7cb040501fa07ff26e264b7db.jpg', '2018-09-14 23:30:17', '2018-09-14 23:30:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2437', '646', '2', '908c39334900e40dcbdf6fd87a865ffa.jpg', '2018-09-14 23:30:17', '2018-09-14 23:30:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2438', '646', '2', '177bb28edb760cfe1581097b3cf22f71.jpg', '2018-09-14 23:30:17', '2018-09-14 23:30:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2439', '646', '3', '94d8d9f487777e1cede2a959f4ad93c8.jpg', '2018-09-14 23:31:07', '2018-09-14 23:31:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2440', '721', '2', 'aac32ba0e78db580e9d53422db7b30b7.jpg', '2018-09-14 23:32:23', '2018-09-14 23:32:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2441', '721', '3', '109944e6f585c79af632aeda52c598de.jpg', '2018-09-14 23:32:40', '2018-09-14 23:32:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2442', '825', '2', '5d449db1af376d6ff872560a54a91403.jpg', '2018-09-14 23:37:33', '2018-09-14 23:37:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2443', '825', '3', '153f32521fb600b835e4f16da4b14564.jpg', '2018-09-14 23:38:05', '2018-09-14 23:38:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2444', '841', '2', 'ec749c2e20d5bdbfb0474e34ee6838c2.jpg', '2018-09-14 23:39:18', '2018-09-14 23:39:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2445', '841', '3', '434f1037c585b9c1f0dacb10db4205e6.jpg', '2018-09-14 23:39:29', '2018-09-14 23:39:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2446', '650', '2', '4171ec48c310451d45eca5488e199964.jpg', '2018-09-14 23:40:49', '2018-09-14 23:40:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2447', '650', '3', 'd7d5415a2dc9fdb4472337dc00207217.jpg', '2018-09-14 23:41:22', '2018-09-14 23:41:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2448', '379', '2', '8d14ec0bf7a4a63abf98752c4045dfd6.jpg', '2018-09-15 00:19:45', '2018-09-15 00:19:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2449', '379', '3', '47c1ebe753f089d1d2eec523cf5f3d29.jpg', '2018-09-15 00:19:54', '2018-09-15 00:19:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2450', '562', '2', '11109604f77e07e16558e1da0a63326a.jpg', '2018-09-15 00:22:35', '2018-09-15 00:22:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2451', '562', '3', '5d9c7135bd00396b1942e33c8a18a296.jpg', '2018-09-15 00:22:53', '2018-09-15 00:22:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2452', '608', '2', '62030e72219e6a22d3f1191799f6433e.jpg', '2018-09-15 00:23:56', '2018-09-15 00:23:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2453', '608', '3', '26f08b52d17d9d287066c07b753268c2.jpg', '2018-09-15 00:24:05', '2018-09-15 00:24:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2454', '806', '2', '8f96bf2a8f41be9922ab4859f813b188.jpg', '2018-09-15 00:32:52', '2018-09-15 00:32:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2455', '806', '3', 'aedff1906e39089175c4887943a0d52b.jpg', '2018-09-15 00:33:13', '2018-09-15 00:33:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2456', '667', '2', '3130ee3b3007daee9fbbc504ced77d81.jpg', '2018-09-15 00:42:00', '2018-09-15 00:42:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2457', '667', '3', 'a17c55b5090bce26acaf9a9d60487855.jpg', '2018-09-15 00:42:21', '2018-09-15 00:42:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2458', '933', '1', '54f20c7ee12158f424ddfcbab2f5e607.jpg', '2018-09-15 10:21:49', '2018-09-15 10:21:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2459', '933', '1', '59a1ecd48200ca0766c3f339e94cf881.jpg', '2018-09-15 10:21:49', '2018-09-15 10:21:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2460', '933', '2', '60ff39f0a3504c8fe6add18e22fa2c60.jpg', '2018-09-15 10:22:06', '2018-09-15 10:22:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2461', '933', '3', 'f1f7d02c877cc1d17a4fa60b4fd66ed2.jpg', '2018-09-15 10:25:50', '2018-09-15 10:25:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2462', '878', '1', '276903fc8d8f9c20926a669834c983eb.jpg', '2018-09-17 10:56:33', '2018-09-17 10:56:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2463', '878', '1', '9cac08c6100998c30268512a4f34166d.jpg', '2018-09-17 10:56:33', '2018-09-17 10:56:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2464', '878', '1', 'dd4680cd15d87a721237dfb38b99c1b8.jpg', '2018-09-17 10:56:33', '2018-09-17 10:56:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2465', '878', '1', 'aa3fd4bb90bfe4ecf389506fa4fba83c.jpg', '2018-09-17 10:56:33', '2018-09-17 10:56:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2466', '878', '1', '708e4c268891c69d0a26bb85581d8678.jpg', '2018-09-17 10:56:33', '2018-09-17 10:56:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2467', '878', '1', '00fbc7138c02951cdf1df6e034a20b22.jpg', '2018-09-17 10:56:33', '2018-09-17 10:56:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2468', '878', '2', 'b29adc984f1c945d62c10a43e7dbdbd2.jpg', '2018-09-17 10:57:08', '2018-09-17 10:57:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2469', '878', '2', '0a051d2256111d597b209d8662419247.jpg', '2018-09-17 10:57:08', '2018-09-17 10:57:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2470', '878', '2', 'ad02ddf40a89c52b2efd25c490680cf3.jpg', '2018-09-17 10:57:08', '2018-09-17 10:57:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2471', '878', '2', 'efc15736bbb6ca2b6dd0f7b85a39e3b1.jpg', '2018-09-17 10:57:08', '2018-09-17 10:57:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2472', '878', '2', 'af71b1eb37c6e86f0d9a9874e79387e8.jpg', '2018-09-17 10:57:08', '2018-09-17 10:57:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2473', '878', '3', '3ed2e2615775025586dc1d5877f17ad0.jpg', '2018-09-17 10:58:22', '2018-09-17 10:58:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2474', '21', '2', '4c123086b1e06b898d6f378cf062f691.jpg', '2018-09-17 12:09:11', '2018-09-17 12:09:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2475', '21', '3', '22e9ae3a41a94f94469e8d89a2e19331.jpg', '2018-09-17 12:09:22', '2018-09-17 12:09:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2476', '879', '2', '8510e0f905336a28b79327c68724a3f2.jpg', '2018-09-17 12:24:26', '2018-09-17 12:24:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2477', '879', '3', 'ed1ebc8d50c0c56e010e8e778bb27ae7.jpg', '2018-09-17 12:24:58', '2018-09-17 12:24:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2478', '875', '2', 'e6aeada78a999a0bd8bddad8e4cad592.jpg', '2018-09-17 12:27:04', '2018-09-17 12:27:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2479', '875', '3', '841c60b9f4d36d01fc0a433b2f20711b.jpg', '2018-09-17 12:27:13', '2018-09-17 12:27:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2480', '235', '1', '4258e5c71e0ff88449c027b66c847558.jpg', '2018-09-17 12:42:50', '2018-09-17 12:42:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2481', '235', '1', '776951f272a7ae74f204aa223afb650a.jpg', '2018-09-17 12:42:50', '2018-09-17 12:42:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2482', '235', '2', 'e0372d8841a5c626967e8b1a013adabe.jpg', '2018-09-17 12:43:28', '2018-09-17 12:43:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2483', '235', '2', '8670c60f809fe16f64dca394c67f9208.jpg', '2018-09-17 12:43:28', '2018-09-17 12:43:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2484', '235', '2', '28fb8b946c33a20ca21d156e508c513d.jpg', '2018-09-17 12:43:28', '2018-09-17 12:43:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2485', '235', '2', '0f8a768d9c492aac39b89feb9a258fa8.jpg', '2018-09-17 12:43:28', '2018-09-17 12:43:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2486', '235', '2', '489c37b89ada0ffc2e8aca3631aee65c.jpg', '2018-09-17 12:43:28', '2018-09-17 12:43:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2487', '235', '2', '9b17a5a839e61ba735aa1901f98b5f13.jpg', '2018-09-17 12:43:28', '2018-09-17 12:43:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2488', '235', '3', 'aa4c9ef2d38291a3aa2baeb8756cf0d0.jpg', '2018-09-17 12:47:45', '2018-09-17 12:47:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2489', '912', '1', 'ff3060c73cad21377f6b040d3e6037fe.jpg', '2018-09-17 12:49:42', '2018-09-17 12:49:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2490', '912', '2', '765a3e850026372105f63ce2733c2927.jpg', '2018-09-17 12:50:03', '2018-09-17 12:50:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2491', '912', '2', 'cfa680d9b945b541db69cb774ad2e338.jpg', '2018-09-17 12:50:03', '2018-09-17 12:50:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2492', '912', '2', '372ae665cd730e1b3cfff0d7a235790a.jpg', '2018-09-17 12:50:03', '2018-09-17 12:50:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2493', '912', '3', '5d58ab73229e1e2a172d3f1a318e7ecc.jpg', '2018-09-17 12:50:45', '2018-09-17 12:50:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2494', '802', '2', '2baa1213fac2032120f8e28be6c6281b.jpg', '2018-09-17 13:21:13', '2018-09-17 13:21:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2495', '802', '3', '7b1e652f92c7607a5bfdd024d3884688.jpg', '2018-09-17 13:21:51', '2018-09-17 13:21:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2496', '833', '2', '5de759d9f56147a124c147f5a8de84a7.jpg', '2018-09-17 13:24:23', '2018-09-17 13:24:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2497', '833', '3', '6767e1b76331af40db251098136fe49e.jpg', '2018-09-17 13:24:52', '2018-09-17 13:24:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2498', '942', '2', '745df1941ef1980ab98094f3a8fb16ec.jpg', '2018-09-17 13:26:56', '2018-09-17 13:26:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2499', '942', '3', '134bf13ed5fe74b514b3dae66215307a.jpg', '2018-09-17 13:27:16', '2018-09-17 13:27:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2500', '944', '2', '259e1965a21cdc5b7c7532e455b1da08.jpg', '2018-09-17 13:34:42', '2018-09-17 13:34:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2501', '944', '2', '0eabd182aef26de00bcaa224bfb98965.jpg', '2018-09-17 13:34:42', '2018-09-17 13:34:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2502', '944', '2', 'f093aa128cb8ee51d05a67fca4e38d88.jpg', '2018-09-17 13:34:42', '2018-09-17 13:34:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2503', '944', '3', 'b6c25f84a0bb41354977b4fdae64b8dd.jpg', '2018-09-17 13:35:14', '2018-09-17 13:35:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2504', '805', '2', 'efddaa51827b4b62337aa3e0d35467df.jpg', '2018-09-17 16:35:37', '2018-09-17 16:35:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2505', '805', '3', 'e7c565e5c94188b6fd205ec094458101.jpg', '2018-09-17 16:36:52', '2018-09-17 16:36:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2506', '871', '2', 'b25779b7c0ed7e1b7ceeeded79d3f5b2.jpg', '2018-09-17 16:51:14', '2018-09-17 16:51:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2507', '871', '2', 'ce77c66164d9b040b4dd4de03a7cf585.jpg', '2018-09-17 16:51:14', '2018-09-17 16:51:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2508', '871', '3', 'bb32b6f52d9e82da0a7364a1cae8bfe8.jpg', '2018-09-17 16:51:57', '2018-09-17 16:51:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2509', '826', '2', '48a38a0dac6a8800333b957e209677e1.jpg', '2018-09-17 16:58:18', '2018-09-17 16:58:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2510', '826', '3', '61c8f15be3d8ae6492c65d9dc4b5ffca.jpg', '2018-09-17 16:58:41', '2018-09-17 16:58:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2511', '798', '2', 'd5e472724a3bf8407cd6392537e904e9.jpg', '2018-09-17 17:02:39', '2018-09-17 17:02:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2512', '798', '3', '77a1fb150b0b80c912cb9e91b654e629.jpg', '2018-09-17 17:03:07', '2018-09-17 17:03:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2513', '870', '2', 'cceab8c65c2f464c1e46b05b76f91507.jpg', '2018-09-17 17:03:56', '2018-09-17 17:03:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2514', '870', '3', '284e0b48bf9986733ac7d8cbc5d61065.jpg', '2018-09-17 17:04:20', '2018-09-17 17:04:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2515', '544', '2', '17ec86eb6e8a9bfc0234fde46159038f.jpg', '2018-09-17 17:11:37', '2018-09-17 17:11:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2516', '544', '2', 'e54a4b3fff17a8d6dc57fc52fe5f31fd.jpg', '2018-09-17 17:11:37', '2018-09-17 17:11:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2517', '544', '3', '915a8e00ba5b6111ece2014445d63b2b.jpg', '2018-09-17 17:12:13', '2018-09-17 17:12:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2518', '696', '2', '19b16dedab4d2b1dbdb93181ed7ad251.jpg', '2018-09-17 17:14:38', '2018-09-17 17:14:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2519', '696', '2', '7d5130ac915122ad9241521b0e8ad8bd.jpg', '2018-09-17 17:14:38', '2018-09-17 17:14:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2520', '696', '2', '82805ee685900fc49a9babf7105f9fd8.jpg', '2018-09-17 17:14:38', '2018-09-17 17:14:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2521', '696', '2', '46a95d82da2509f0e548fd1af8418eca.jpg', '2018-09-17 17:14:38', '2018-09-17 17:14:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2522', '696', '3', 'b58179c7afa4c48d1693bd941dcd5f17.jpg', '2018-09-17 17:14:57', '2018-09-17 17:14:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2523', '910', '2', 'b3cf9c839a8477efa8feb516fda1bee5.jpg', '2018-09-17 17:18:22', '2018-09-17 17:18:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2524', '910', '3', '4f18c23393a3df952ef6da62555ba922.jpg', '2018-09-17 17:18:47', '2018-09-17 17:18:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2525', '45', '2', 'f5d899c4c7834570f1e33f1bedb5ab74.jpg', '2018-09-17 17:24:41', '2018-09-17 17:24:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2526', '45', '3', '409930736fb5c8242c2efa9262fb0faf.jpg', '2018-09-17 17:25:08', '2018-09-17 17:25:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2527', '694', '2', '73f826cfbc988498424e2d290dae759a.jpg', '2018-09-17 17:26:43', '2018-09-17 17:26:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2528', '694', '3', '8e61a9f502f0eb58ee5706441fb00a3f.jpg', '2018-09-17 17:26:54', '2018-09-17 17:26:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2529', '931', '2', 'b4b9223a81b5cc357b7aab5f889dd670.jpg', '2018-09-17 17:30:12', '2018-09-17 17:30:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2530', '931', '2', '592ef1de738b07c9fbba616718afd5e3.jpg', '2018-09-17 17:30:13', '2018-09-17 17:30:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2531', '931', '3', 'a8b6ddd6208ea05f368e52d81708fd65.jpg', '2018-09-17 17:30:40', '2018-09-17 17:30:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2532', '631', '2', '78833ba53d02459ed630c1353b05aa4e.jpg', '2018-09-17 18:23:15', '2018-09-17 18:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2533', '631', '3', 'd840327beb20ed946d75b82cc7f156f2.jpg', '2018-09-17 18:24:48', '2018-09-17 18:24:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2534', '670', '2', '1e23a7fe8c8a14cdc2d913bcb6e74c18.jpg', '2018-09-17 18:27:35', '2018-09-17 18:27:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2535', '670', '3', '77f058504ed437708c1b3e039a0d7508.jpg', '2018-09-17 18:28:22', '2018-09-17 18:28:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2536', '632', '2', 'ee9ce227714ea1afe0d357805865bea9.jpg', '2018-09-17 18:31:31', '2018-09-17 18:31:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2537', '632', '3', 'a6cbc601adf98c9cd8465ab407b379f2.jpg', '2018-09-17 18:31:46', '2018-09-17 18:31:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2538', '657', '2', 'd881372eaea6635e0e48672a789eb44e.jpg', '2018-09-17 18:34:41', '2018-09-17 18:34:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2539', '657', '2', '6fdab3c66622ce78395be31ab491418f.jpg', '2018-09-17 18:34:41', '2018-09-17 18:34:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2540', '657', '2', 'eac68dc584e109442a4c58c98c6df9d1.jpg', '2018-09-17 18:34:41', '2018-09-17 18:34:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2541', '657', '2', 'f662931186db7e5877c891756aa9f412.jpg', '2018-09-17 18:34:41', '2018-09-17 18:34:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2542', '657', '3', '03d161773cca624c09a1eab7cab897b5.jpg', '2018-09-17 18:35:40', '2018-09-17 18:35:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2543', '427', '2', 'f300cbf115da0d01feb19cd0de15a00b.jpg', '2018-09-17 18:39:32', '2018-09-17 18:39:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2544', '427', '2', '6a8e91223636e49b718a74e85564966a.jpg', '2018-09-17 18:39:32', '2018-09-17 18:39:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2545', '427', '2', 'a7bdee1af6a6de8cc424858a31e950ff.jpg', '2018-09-17 18:39:32', '2018-09-17 18:39:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2546', '427', '3', '4799e4cec286a3a3b65cf642b33a06c6.jpg', '2018-09-17 18:39:59', '2018-09-17 18:39:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2547', '951', '2', '9f950baf8f651afdde84a6e4a32655a5.jpg', '2018-09-17 18:42:15', '2018-09-17 18:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2548', '951', '2', '56f6b0375b7e7a187d20342ea7fda9f2.jpg', '2018-09-17 18:42:15', '2018-09-17 18:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2549', '951', '2', '3c3e761d9588752d6ed81bbabfc2b7bc.jpg', '2018-09-17 18:42:15', '2018-09-17 18:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2550', '951', '2', '6e0b9e553ae597538e28e7bb47016bd8.jpg', '2018-09-17 18:42:15', '2018-09-17 18:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2551', '951', '3', '955faaea618bcc8ed86fb3bd047145ba.jpg', '2018-09-17 18:42:34', '2018-09-17 18:42:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2552', '953', '2', '16e5420dd6d923aaac48006361b57640.jpg', '2018-09-17 19:02:29', '2018-09-17 19:02:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2553', '953', '2', 'f3dfa64ca3ac76f4e6795a9f334a3210.jpg', '2018-09-17 19:02:29', '2018-09-17 19:02:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2554', '953', '2', 'c893a79c8097498650ce8e03b79e1f97.jpg', '2018-09-17 19:02:29', '2018-09-17 19:02:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2555', '953', '2', 'e8fadbff2d0b70ffc859273d61095ddf.jpg', '2018-09-17 19:02:29', '2018-09-17 19:02:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2556', '953', '3', '9f3250613b4df33358b9596d8fd1f92f.jpg', '2018-09-17 19:03:23', '2018-09-17 19:03:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2557', '704', '2', '2d6b65c2ec77384fd9adf1973388ca90.jpg', '2018-09-18 11:44:02', '2018-09-18 11:44:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2558', '704', '3', '960a9704567ea710bc7214e2227f51bd.jpg', '2018-09-18 11:44:10', '2018-09-18 11:44:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2559', '701', '2', '09cf83e6bdf2c00f9de0c8726adc8372.jpg', '2018-09-18 11:44:39', '2018-09-18 11:44:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2560', '701', '3', '822c7db9ef6bdd9cb4352551c7f60b28.jpg', '2018-09-18 11:44:50', '2018-09-18 11:44:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2561', '918', '2', '105cc1a91a64028c7617283490a6bf6f.jpg', '2018-09-18 11:49:39', '2018-09-18 11:49:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2562', '918', '3', '4386b20fd7fe34434fef4415b50c1ae7.jpg', '2018-09-18 11:50:00', '2018-09-18 11:50:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2563', '932', '1', 'b78347e7293afc46e19a208fd0b0037a.jpg', '2018-09-19 10:42:15', '2018-09-19 10:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2564', '932', '1', '0d62cf1fd7ff7450c11b796e5801f2f5.jpg', '2018-09-19 10:42:15', '2018-09-19 10:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2565', '932', '1', '87451b94476b74f22cfbd967894274f0.jpg', '2018-09-19 10:42:15', '2018-09-19 10:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2566', '932', '1', 'e233effab06b3e7516e71d76c47ac150.jpg', '2018-09-19 10:42:15', '2018-09-19 10:42:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2567', '932', '2', '4c614ab1f16e38102bd27cd684aa3196.jpg', '2018-09-19 10:42:42', '2018-09-19 10:42:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2568', '932', '2', '91f5e18599a515e6e8995ca3b3a405b4.jpg', '2018-09-19 10:42:42', '2018-09-19 10:42:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2569', '932', '2', 'd0599a22e97175762619d838e5cb53e3.jpg', '2018-09-19 10:42:42', '2018-09-19 10:42:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2570', '932', '3', '5a427ddd3d0942d5a70a739bca170b81.jpg', '2018-09-19 10:43:35', '2018-09-19 10:43:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2571', '965', '1', 'a8a6df3419ae9cb9954fbf325a30a5d5.jpg', '2018-09-19 15:10:09', '2018-09-19 15:10:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2572', '965', '1', 'd99e056abfb6a73dd651b3a851284cbc.jpg', '2018-09-19 15:10:09', '2018-09-19 15:10:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2573', '965', '2', '1ebb6231e1df69acd49d6a7ca7db3cf8.jpg', '2018-09-19 15:10:24', '2018-09-19 15:10:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2574', '965', '2', '8f46e1ed24a017fb19590f819e720b23.jpg', '2018-09-19 15:10:24', '2018-09-19 15:10:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2575', '965', '3', '6cae6f68e01bbf83b0b5df84d1ae3651.jpg', '2018-09-19 15:10:37', '2018-09-19 15:10:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2576', '939', '1', '607de48b3c774bb15bf68ccfaa065492.jpg', '2018-09-19 15:28:11', '2018-09-19 15:28:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2577', '939', '2', '3bbf0f4cd95bd60296e734cbcfa09371.jpg', '2018-09-19 15:28:19', '2018-09-19 15:28:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2578', '939', '3', 'f7858887a3e2f282bef3590d404484a6.jpg', '2018-09-19 15:28:35', '2018-09-19 15:28:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2579', '968', '1', '5e401a83acdd285cb06dabc008d25c2c.jpg', '2018-09-19 16:32:35', '2018-09-19 16:32:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2580', '968', '1', 'a6cd4c268028c0aef8484c9ac5e75f8d.jpg', '2018-09-19 16:32:35', '2018-09-19 16:32:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2581', '968', '2', 'dd9d7013e6ae4a9fd859905697e8827b.jpg', '2018-09-19 16:33:17', '2018-09-19 16:33:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2582', '968', '2', '97545eaf1fa83fa7a0e2c3a702888c3f.jpg', '2018-09-19 16:33:17', '2018-09-19 16:33:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2583', '968', '2', '1acdd41157b3a490e1e9ccb47b6aa5ad.jpg', '2018-09-19 16:33:17', '2018-09-19 16:33:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2584', '968', '2', 'f22ed57c660d06abb44f6a311c6cc9db.jpg', '2018-09-19 16:33:17', '2018-09-19 16:33:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2585', '968', '3', '40577ecdc6c2896fbc36adb52124a108.jpg', '2018-09-19 16:36:09', '2018-09-19 16:36:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2586', '77', '2', '8f9f3ac6f4dd8ce9c7bc043c140bcef6.jpg', '2018-09-20 10:13:53', '2018-09-20 10:13:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2587', '77', '3', '499ca518407df26696210d4e94bede59.jpg', '2018-09-20 10:15:35', '2018-09-20 10:15:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2588', '189', '2', '06329458c2a2542f1228f273af49d4ec.jpg', '2018-09-20 10:22:25', '2018-09-20 10:22:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2589', '189', '3', 'e8d588136742e2c9d97966b24869da02.jpg', '2018-09-20 10:22:47', '2018-09-20 10:22:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2590', '457', '2', '63cf3064b5621fdacb89ef93c8ac3ba2.jpg', '2018-09-20 10:24:24', '2018-09-20 10:24:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2591', '457', '2', '15aa2636c4bdfd71472ee7f559370b1f.jpg', '2018-09-20 10:24:24', '2018-09-20 10:24:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2592', '457', '3', 'e1b811e328db8458b2cc8a8d034e32d3.jpg', '2018-09-20 10:24:55', '2018-09-20 10:24:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2593', '791', '2', '1ad76f2d597518dcabc4e292c2136c99.jpg', '2018-09-20 10:33:36', '2018-09-20 10:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2594', '791', '2', '8e898d6935828098fdce3bb84a3ce4c6.jpg', '2018-09-20 10:33:36', '2018-09-20 10:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2595', '791', '2', '60090ab1061fe79e475b4d954ce0de80.jpg', '2018-09-20 10:33:36', '2018-09-20 10:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2596', '791', '2', 'dd58209599420b3c1f18c18229c8d91d.jpg', '2018-09-20 10:33:39', '2018-09-20 10:33:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2597', '791', '2', '177d70ec6d869edea3cbd1dde3a81839.jpg', '2018-09-20 10:33:39', '2018-09-20 10:33:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2598', '791', '2', '67316787dd5a0e78a2955f9efb4aa37b.jpg', '2018-09-20 10:33:39', '2018-09-20 10:33:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2599', '791', '3', 'd9ace55306db9dfdb46da2e3f1e88a57.jpg', '2018-09-20 10:34:02', '2018-09-20 10:34:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2600', '470', '2', 'a281de9ff4d7ca2dbbc14fa69868de0a.jpg', '2018-09-20 10:41:27', '2018-09-20 10:41:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2601', '470', '3', '3e7c91ed4959052e3e0f77d3beb9a1ba.jpg', '2018-09-20 10:41:44', '2018-09-20 10:41:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2602', '64', '2', '27b7b66ae98777601fabb1eb28617ddd.jpg', '2018-09-20 10:51:56', '2018-09-20 10:51:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2603', '64', '3', 'fc99989194d3301b0927e62a21e19a82.jpg', '2018-09-20 10:52:21', '2018-09-20 10:52:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2604', '504', '2', 'f4fdc38c3ce584d6fd38ce9a42b1e867.jpg', '2018-09-20 10:56:54', '2018-09-20 10:56:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2605', '504', '3', '2bf5621629ee91f822a7e04d06f853ff.jpg', '2018-09-20 10:57:05', '2018-09-20 10:57:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2606', '568', '2', 'c9639afb998c85504e95bb20083c224f.jpg', '2018-09-20 10:58:45', '2018-09-20 10:58:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2607', '568', '3', 'd7d5ebcfa5aa9ee025225f3ee1a9a87e.jpg', '2018-09-20 10:58:56', '2018-09-20 10:58:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2608', '417', '2', '1be12c797f3f2ff92a81be0845e91a96.jpg', '2018-09-20 11:08:17', '2018-09-20 11:08:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2609', '417', '3', '7dbc8a7910cdb0e24294e6f03c42c2ac.jpg', '2018-09-20 11:08:27', '2018-09-20 11:08:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2610', '936', '2', 'ee44b0f6cc90375d7fb8a27639cb1d34.jpg', '2018-09-20 11:19:25', '2018-09-20 11:19:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2611', '936', '3', '512692433109a823f11ac411038731ad.jpg', '2018-09-20 11:19:41', '2018-09-20 11:19:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2612', '957', '1', '465789468cd61fb1afaa77d9479649ee.jpg', '2018-09-20 11:27:29', '2018-09-20 11:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2613', '957', '1', '62cb48e4fdce5fe02e95bdb177a92ed3.jpg', '2018-09-20 11:27:29', '2018-09-20 11:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2614', '957', '1', '9420b268a792c9a115f601c049f49b45.jpg', '2018-09-20 11:27:29', '2018-09-20 11:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2615', '957', '1', '05a58792a2b2484470de7a9953689065.jpg', '2018-09-20 11:27:29', '2018-09-20 11:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2616', '957', '1', '7aa8f39dba68f553cdcdc3ed1bf19605.jpg', '2018-09-20 11:27:29', '2018-09-20 11:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2617', '957', '1', '492015255c021a0af789b5e7af6130fb.jpg', '2018-09-20 11:27:29', '2018-09-20 11:27:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2618', '957', '2', '421f782f6bf88042b5530256a1ad9bea.jpg', '2018-09-20 11:28:00', '2018-09-20 11:28:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2619', '957', '2', 'be944726b67eb9ae37ad639cca43dac6.jpg', '2018-09-20 11:28:00', '2018-09-20 11:28:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2620', '957', '2', '47d2d130a950f83d2ec6363041f3d0bd.jpg', '2018-09-20 11:28:00', '2018-09-20 11:28:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2621', '957', '3', '4068093aabb60682c55c9d5ca13d7f46.jpg', '2018-09-20 11:29:32', '2018-09-20 11:29:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2622', '784', '2', 'fcbc0c76d49db26b943a334645204764.jpg', '2018-09-20 12:02:07', '2018-09-20 12:02:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2623', '784', '3', '566b5cb96a753179fa692b684a2b6d79.jpg', '2018-09-20 12:02:14', '2018-09-20 12:02:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2624', '287', '2', '1bd52f865e9ee4e32d3a05b752e961ea.jpg', '2018-09-20 12:08:14', '2018-09-20 12:08:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2625', '287', '3', '33f170e80d2c0e94a7fa19ef586f0272.jpg', '2018-09-20 12:08:24', '2018-09-20 12:08:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2626', '906', '2', 'b6a4d536927edf05abeacd34ad6746d5.jpg', '2018-09-20 12:26:39', '2018-09-20 12:26:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2627', '906', '3', 'cee3dabb3523b9132d73bbfa24f4e985.jpg', '2018-09-20 12:26:59', '2018-09-20 12:26:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2628', '821', '2', '6a0c91a484235606804cd160684d9178.jpg', '2018-09-20 12:28:28', '2018-09-20 12:28:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2629', '821', '3', '9c8fe952be01a3658a27ba96876f5d33.jpg', '2018-09-20 12:28:55', '2018-09-20 12:28:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2630', '490', '2', 'f2414862f02309bf9a4c9794e3549cdd.jpg', '2018-09-20 12:35:07', '2018-09-20 12:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2631', '490', '3', '9ec32a47eaf633f14c0cb1a4daad1d76.jpg', '2018-09-20 12:36:06', '2018-09-20 12:36:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2632', '914', '2', '5700cdade740e165b6c6c89754442f1d.jpg', '2018-09-20 12:38:30', '2018-09-20 12:38:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2633', '914', '3', '23602bc445f6a76626bf8ffabdf0541f.jpg', '2018-09-20 12:38:51', '2018-09-20 12:38:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2634', '883', '2', 'ff134833e4ed01ad5da0421d1f79dffc.jpg', '2018-09-20 12:42:29', '2018-09-20 12:42:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2635', '883', '3', '4338ddcc98bec1757824ce0da8e21d5f.jpg', '2018-09-20 12:42:55', '2018-09-20 12:42:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2636', '795', '2', '091d6a0de570db7c18f17b4996cb22b7.jpg', '2018-09-20 12:45:43', '2018-09-20 12:45:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2637', '795', '3', '55dfed64daf209b7a9f24509e095ba75.jpg', '2018-09-20 12:46:06', '2018-09-20 12:46:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2638', '872', '2', '08f5710cf57dcece5b8e4bbe5eaf0bbf.jpg', '2018-09-20 12:49:14', '2018-09-20 12:49:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2639', '872', '3', '64d64ade19fce4aceb977cf03eaf61e1.jpg', '2018-09-20 12:49:25', '2018-09-20 12:49:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2640', '903', '2', 'eb7ac0245d1544f9c9c2ba5aa54e7ea0.jpg', '2018-09-20 12:51:47', '2018-09-20 12:51:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2641', '903', '3', '33c9887382f6d610ac3a0685bc357cf0.jpg', '2018-09-20 12:52:57', '2018-09-20 12:52:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2642', '809', '2', '3308e4d7c8ce372481d7ea2738e5d120.jpg', '2018-09-20 15:51:24', '2018-09-20 15:51:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2643', '809', '3', 'bf46488904f488aef9e30a125d1f5605.jpg', '2018-09-20 15:51:46', '2018-09-20 15:51:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2644', '934', '1', '24df594d761bbfb37db72e930457215d.jpg', '2018-09-20 17:14:18', '2018-09-20 17:14:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2645', '934', '2', 'a8ee5d776a2a6d82f757b49480907a6f.jpg', '2018-09-20 17:14:23', '2018-09-20 17:14:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2646', '934', '3', '8f13785977f9a2a73251039578cb4ed4.jpg', '2018-09-20 17:14:40', '2018-09-20 17:14:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2647', '963', '1', 'e5a168bd2340bf65c4a3d47a3de33961.jpg', '2018-09-20 17:15:42', '2018-09-20 17:15:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2648', '963', '2', 'cfa5599a86a429af3a88e52ae40347f3.jpg', '2018-09-20 17:15:46', '2018-09-20 17:15:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2649', '975', '1', '3eb950763bd46100fbbce8cf2d8cbbe0.jpg', '2018-09-20 17:15:59', '2018-09-20 17:15:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2650', '963', '3', 'a0a85d33b80586b0780fc2da9d682884.jpg', '2018-09-20 17:16:11', '2018-09-20 17:16:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2651', '975', '2', 'f1846ca2461fdbbe55283438a7b72dd6.jpg', '2018-09-20 17:16:13', '2018-09-20 17:16:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2652', '975', '2', '1d74decabaf50f39bd60adfef6cdb0f1.jpg', '2018-09-20 17:16:13', '2018-09-20 17:16:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2653', '975', '2', 'ecde6be7aef50fec0f8a716c30e48536.jpg', '2018-09-20 17:16:13', '2018-09-20 17:16:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2654', '948', '1', '93a77715a3760acc701487007afe8da8.jpg', '2018-09-20 17:16:48', '2018-09-20 17:16:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2655', '948', '2', 'dc1b65bc02e083795bae30cd3a9c9392.jpg', '2018-09-20 17:16:53', '2018-09-20 17:16:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2656', '948', '3', '9530fb0afb7b32f517cbfb39526da5b5.jpg', '2018-09-20 17:17:10', '2018-09-20 17:17:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2657', '975', '3', 'f05b3b7e22e48aff6d1bddb9465ea137.jpg', '2018-09-20 17:20:02', '2018-09-20 17:20:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2658', '964', '1', '83f78af6345179f3009eebd56d10a1e7.jpg', '2018-09-21 12:41:46', '2018-09-21 12:41:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2659', '964', '2', '67457ee12c7235c23ee60693c2b975d4.jpg', '2018-09-21 12:42:09', '2018-09-21 12:42:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2660', '964', '2', 'fbca9fe962eecbf04d752927325877e7.jpg', '2018-09-21 12:42:09', '2018-09-21 12:42:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2661', '964', '2', 'ed2c82e79954ca1abf340dd427c30e2a.jpg', '2018-09-21 12:42:09', '2018-09-21 12:42:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2662', '964', '3', '4e629fca5b2e1e1f546f5b479f5660be.jpg', '2018-09-21 12:46:24', '2018-09-21 12:46:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2663', '982', '1', 'cc0975141f2cddf7f61b5560afcc3ff9.jpg', '2018-09-21 17:13:41', '2018-09-21 17:13:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2664', '982', '1', 'ec4d4c1ba0da574800468ab4d1a87c9f.jpg', '2018-09-21 17:13:41', '2018-09-21 17:13:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2665', '982', '2', '35795b94be19a77afe78745ac1e8419d.jpg', '2018-09-21 17:14:19', '2018-09-21 17:14:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2666', '982', '2', 'ca96385e92e57b08a9546f65cb9b7119.jpg', '2018-09-21 17:14:19', '2018-09-21 17:14:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2667', '982', '2', 'ec912e966083b6e7c4cb64f015bb78e2.jpg', '2018-09-21 17:14:19', '2018-09-21 17:14:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2668', '982', '2', '363db8a55b782dcab06308f0483a5c86.jpg', '2018-09-21 17:14:19', '2018-09-21 17:14:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2669', '982', '2', 'd9934b15ba9d077f9c8876d1757c6ba5.jpg', '2018-09-21 17:14:19', '2018-09-21 17:14:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2670', '982', '2', 'fb674c37ac517eb7afd24d8e6d39562b.jpg', '2018-09-21 17:14:19', '2018-09-21 17:14:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2671', '982', '3', '20c38b804b195aa1ec87bb93c503f045.jpg', '2018-09-21 17:18:04', '2018-09-21 17:18:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2672', '990', '1', 'afed5bac20a73c9a02facd8efe473804.jpg', '2018-09-24 10:54:34', '2018-09-24 10:54:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2673', '990', '1', '24c188d0245d7e5938721726ef128d86.jpg', '2018-09-24 10:54:34', '2018-09-24 10:54:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2674', '990', '1', '7ce129a7852b469ad1df99d38e3400a6.jpg', '2018-09-24 10:54:34', '2018-09-24 10:54:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2675', '990', '2', 'bf12f107c8f0f5aed2dfce7db9147728.jpg', '2018-09-24 10:54:57', '2018-09-24 10:54:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2676', '990', '2', '89a0925e879497c5184869d4137deb5d.jpg', '2018-09-24 10:54:57', '2018-09-24 10:54:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2677', '990', '2', 'abe4faef318d972400515d5f54bb439b.jpg', '2018-09-24 10:54:57', '2018-09-24 10:54:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2678', '990', '2', '69810df830e01b352841f57eef6fb29a.jpg', '2018-09-24 10:54:57', '2018-09-24 10:54:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2679', '990', '2', 'a261abaf411f9fbaa355d7cbe6eaff60.jpg', '2018-09-24 10:54:57', '2018-09-24 10:54:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2680', '990', '2', '638381b06981833c673fcd3e73ac22f1.jpg', '2018-09-24 10:54:57', '2018-09-24 10:54:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2681', '990', '3', 'ca28dcec23eff9b9bfaeff71bb9e3ad1.jpg', '2018-09-24 10:59:09', '2018-09-24 10:59:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2682', '969', '1', '7133f12bbd03cf13e9e7ba327030db65.jpg', '2018-09-25 13:15:55', '2018-09-25 13:15:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2683', '969', '1', 'b573e1646edf9013b507aad5aa9aebef.jpg', '2018-09-25 13:15:55', '2018-09-25 13:15:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2684', '969', '1', '22cb1134befcdb807a69faf655e28858.jpg', '2018-09-25 13:15:55', '2018-09-25 13:15:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2685', '969', '1', '0cecac3203338cde8e05be6544a0ef0a.jpg', '2018-09-25 13:15:55', '2018-09-25 13:15:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2686', '969', '2', '935129035defd1014a1ebb22df744864.jpg', '2018-09-25 13:16:20', '2018-09-25 13:16:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2687', '969', '2', '89c2b13906d6834aa781a58005921edb.jpg', '2018-09-25 13:16:20', '2018-09-25 13:16:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2688', '969', '2', '7be2d93386ac4add73798695c1ec7d58.jpg', '2018-09-25 13:16:20', '2018-09-25 13:16:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2689', '969', '3', '874f66e0865301d74707ba7b4c3937a3.jpg', '2018-09-25 13:17:14', '2018-09-25 13:17:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2690', '947', '2', 'f192a56839d2243f287afd63ca8fa65d.jpg', '2018-09-26 10:29:51', '2018-09-26 10:29:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2691', '947', '2', '4851c83ec128071f02a9452e9fedb096.jpg', '2018-09-26 10:29:51', '2018-09-26 10:29:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2692', '947', '3', '3c7f0d0a2717f6eb580a36e644b69065.jpg', '2018-09-26 10:30:10', '2018-09-26 10:30:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2693', '905', '2', '7621efa585c9a7b585bbbad3ef6f8384.jpg', '2018-09-26 10:34:55', '2018-09-26 10:34:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2694', '905', '3', '0e65cc625dd72263b1515e63e5813f20.jpg', '2018-09-26 10:35:17', '2018-09-26 10:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2695', '898', '2', '7383016beb31211a7ec49b805e9c8541.jpg', '2018-09-26 10:39:32', '2018-09-26 10:39:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2696', '898', '2', 'e184f7961aa02bb34833a5388daa512e.jpg', '2018-09-26 10:39:32', '2018-09-26 10:39:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2697', '898', '2', 'b24173b4d5e3fa67e95af69ac919a8b3.jpg', '2018-09-26 10:39:32', '2018-09-26 10:39:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2698', '898', '3', 'ae4ad077f50f942dc84341dc4a692c49.jpg', '2018-09-26 10:39:51', '2018-09-26 10:39:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2699', '900', '2', '236a1c48aee0f74b8639a6f6e39f626f.jpg', '2018-09-26 10:42:29', '2018-09-26 10:42:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2700', '900', '2', '86699842ef86b19d9f7bf84f0b883507.jpg', '2018-09-26 10:42:29', '2018-09-26 10:42:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2701', '900', '3', 'd39a06e4af2e01e844166f8e5e493f75.jpg', '2018-09-26 10:42:49', '2018-09-26 10:42:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2702', '899', '2', '85466fa07182a89cc2b67ca47c807ecd.jpg', '2018-09-26 10:44:56', '2018-09-26 10:44:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2703', '899', '3', 'fd8079b215d30a3719a1f5f964030d79.jpg', '2018-09-26 10:45:11', '2018-09-26 10:45:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2704', '677', '2', 'a59368a58e47fda4c1fa120f58c560b6.jpg', '2018-09-26 10:52:54', '2018-09-26 10:52:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2705', '677', '3', '53366232db4fb18764e7092339a7d413.jpg', '2018-09-26 10:53:03', '2018-09-26 10:53:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2706', '924', '2', 'dbfbb348f8ec6217c84250a1fd4ece96.jpg', '2018-09-26 10:55:12', '2018-09-26 10:55:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2707', '924', '3', '312932fde3f7285f7eb03b3e01bbce64.jpg', '2018-09-26 10:55:30', '2018-09-26 10:55:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2708', '901', '2', '20f0fba87a43c6dcdc74534b95aa6be9.jpg', '2018-09-26 10:56:35', '2018-09-26 10:56:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2709', '901', '3', '104522f429f4a05190c4ca7d9af6a666.jpg', '2018-09-26 10:56:56', '2018-09-26 10:56:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2710', '901', '3', '87738c6791de4649ea06f0c139d46b43.jpg', '2018-09-26 10:57:00', '2018-09-26 10:57:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2711', '923', '2', 'e3492c9c7cbfc6955ee12e4322b078a0.jpg', '2018-09-26 10:57:53', '2018-09-26 10:57:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2712', '923', '3', 'b35da5e23ba70461358de292fad8984d.jpg', '2018-09-26 10:58:11', '2018-09-26 10:58:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2713', '940', '2', '84f0c92755abdadd85d75261018f09bd.jpg', '2018-09-26 11:11:13', '2018-09-26 11:11:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2714', '940', '3', '2a0ebe165504962729730cdaf661ad35.jpg', '2018-09-26 11:11:44', '2018-09-26 11:11:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2715', '1001', '2', '54934489cc1a4c47f9144a9f71335677.jpg', '2018-09-26 11:13:52', '2018-09-26 11:13:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2716', '1001', '3', '96d6e265cc40e1c036d667d2b60daa5d.jpg', '2018-09-26 11:14:13', '2018-09-26 11:14:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2717', '1000', '1', '3d0c65fea4ac0e6fd5e77bba8e7d9523.jpg', '2018-09-26 12:18:39', '2018-09-26 12:18:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2718', '1000', '1', 'ed668110035c73045c3e47d88ee58025.jpg', '2018-09-26 12:18:39', '2018-09-26 12:18:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2719', '1000', '1', '4a28f4baac5b1d08669b467e24c2ace0.jpg', '2018-09-26 12:18:39', '2018-09-26 12:18:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2720', '1000', '2', '7ba0e290f677a019c49da8a54eeb53f0.jpg', '2018-09-26 12:20:43', '2018-09-26 12:20:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2721', '1000', '2', '4f07a655733fbe19dce786e60d380577.jpg', '2018-09-26 12:20:43', '2018-09-26 12:20:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2722', '1000', '2', '7be7b5f07d9ce4f681b6e5ef9ec51c6c.jpg', '2018-09-26 12:20:43', '2018-09-26 12:20:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2723', '1000', '2', '653adf0cd0932b192eac5c85c7dc5ceb.jpg', '2018-09-26 12:20:43', '2018-09-26 12:20:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2724', '1000', '2', 'b5108544155fbd5a0cf1c430fb7d3b56.jpg', '2018-09-26 12:20:43', '2018-09-26 12:20:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2725', '1000', '3', '1efd05167bbd8eece85b1a29d74886f8.jpg', '2018-09-26 12:24:23', '2018-09-26 12:24:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2726', '754', '2', 'c0ed153d084e22d96a1a5c465ad136a4.jpg', '2018-09-26 12:40:05', '2018-09-26 12:40:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2727', '754', '3', '7a1b31dbc426f105e5178ca69d5d1bb1.jpg', '2018-09-26 12:40:30', '2018-09-26 12:40:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2728', '851', '2', '1db9fb72133e37d35a1e4b121dd1b944.jpg', '2018-09-26 12:41:50', '2018-09-26 12:41:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2729', '851', '3', '50c3749116b97b8f439aee57cc2a16f2.jpg', '2018-09-26 12:42:10', '2018-09-26 12:42:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2730', '954', '2', 'a4fef0b40256bf32c276bb90215ca186.jpg', '2018-09-26 12:56:03', '2018-09-26 12:56:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2731', '954', '3', '9508b57a4ff6d71da4661762c3bd145e.jpg', '2018-09-26 12:56:16', '2018-09-26 12:56:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2732', '952', '2', '10ca1fc8798cb004008564d553d8e324.jpg', '2018-09-26 12:59:00', '2018-09-26 12:59:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2733', '952', '2', '2720483f6e685785ec8246df3c83551e.jpg', '2018-09-26 12:59:00', '2018-09-26 12:59:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2734', '952', '2', '0130babe0219b30e142225bb31938aa0.jpg', '2018-09-26 12:59:00', '2018-09-26 12:59:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2735', '952', '3', '5b17fc3532a1cbaa874e798a3dffdc3d.jpg', '2018-09-26 12:59:15', '2018-09-26 12:59:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2736', '324', '2', '227f95450c816f172011610ad00a2324.jpg', '2018-09-26 13:00:38', '2018-09-26 13:00:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2737', '324', '3', 'b62e592e5d71753c8c454c3ea8835792.jpg', '2018-09-26 13:00:53', '2018-09-26 13:00:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2738', '917', '2', '1cf826eea3dd1395d04bbfb524391bfd.jpg', '2018-09-26 13:56:17', '2018-09-26 13:56:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2739', '917', '3', '1f3c3930da95a8a2ab53db26969d773b.jpg', '2018-09-26 13:56:39', '2018-09-26 13:56:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2740', '916', '2', 'd5ce695101285367cced235b1483dd70.jpg', '2018-09-26 13:57:31', '2018-09-26 13:57:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2741', '916', '3', 'f102101de1236364792538e4dd39795f.jpg', '2018-09-26 13:57:50', '2018-09-26 13:57:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2742', '1003', '2', '730c6a10d3c7415025485685c6a9088c.jpg', '2018-09-26 16:26:38', '2018-09-26 16:26:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2743', '1003', '2', 'ad852bef0b4c1be2cda4ccbe0eb847fd.jpg', '2018-09-26 16:26:38', '2018-09-26 16:26:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2744', '1003', '3', '98a514919ff58a411edd58898165963c.jpg', '2018-09-26 16:26:56', '2018-09-26 16:26:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2745', '1004', '1', '40171b4f09dacb818b7dbecd244b2f54.jpg', '2018-09-26 18:01:59', '2018-09-26 18:01:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2746', '1004', '1', '9078b4786620d71c8ce0b882deb44ba2.jpg', '2018-09-26 18:01:59', '2018-09-26 18:01:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2747', '1004', '2', '9578842b0d8235dab0018135f780fbe1.jpg', '2018-09-26 18:02:26', '2018-09-26 18:02:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2748', '1004', '2', 'f308bfef962f901f0d02bf3198afd616.jpg', '2018-09-26 18:02:26', '2018-09-26 18:02:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2749', '1004', '2', 'ccdebef75cc18e1b71d458f520108906.jpg', '2018-09-26 18:02:26', '2018-09-26 18:02:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2750', '1004', '2', '2aafbc260ebe05fc8132cead4b7cf19d.jpg', '2018-09-26 18:02:26', '2018-09-26 18:02:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2751', '1004', '2', 'e680d0df1c80d0be20fa34c41c15eb4b.jpg', '2018-09-26 18:02:26', '2018-09-26 18:02:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2752', '1004', '2', 'de35a2e8321c7187a59c8d997d88f3ca.jpg', '2018-09-26 18:02:26', '2018-09-26 18:02:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2753', '1004', '3', '12fb66a372656dd98ae4976f6dcee1f8.jpg', '2018-09-26 18:05:23', '2018-09-26 18:05:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2754', '67', '3', '0b0762f3214504f0c5461fbbcd42ed96.jpg', '2018-09-27 10:40:02', '2018-09-27 10:40:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2755', '986', '1', '71ffe4048fed26cb59df5674c3e84864.jpg', '2018-09-27 12:49:41', '2018-09-27 12:49:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2756', '986', '1', '684b2f83458ca385a35ab09ae1be17f1.jpg', '2018-09-27 12:49:41', '2018-09-27 12:49:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2757', '986', '2', '4583872fdcdefbe2baf34116f65acf3c.jpg', '2018-09-27 12:49:59', '2018-09-27 12:49:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2758', '986', '2', '633b03bd781182c756a1ba8a91a25b17.jpg', '2018-09-27 12:49:59', '2018-09-27 12:49:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2759', '986', '2', 'd27dff77d0f56e20fe860ff147effef3.jpg', '2018-09-27 12:49:59', '2018-09-27 12:49:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2760', '986', '2', '9e0e008dd92c3be8a03805afeb97cf18.jpg', '2018-09-27 12:49:59', '2018-09-27 12:49:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2761', '986', '3', 'c1b91d1d856634e2417254c2c1c466d9.jpg', '2018-09-27 12:50:40', '2018-09-27 12:50:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2762', '992', '1', '1f1a6bcda2583360774e1bcb4c1b282d.jpg', '2018-09-27 13:42:21', '2018-09-27 13:42:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2763', '992', '2', 'a27898a04dd7e650b3ea56c45ffe72d7.jpg', '2018-09-27 13:42:57', '2018-09-27 13:42:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2764', '992', '2', '50d92902db057eb945c4ae4ab2a2b710.jpg', '2018-09-27 13:42:57', '2018-09-27 13:42:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2765', '992', '3', '9e84968d9b336c750f0bbeeecb648ee9.jpg', '2018-09-27 13:43:42', '2018-09-27 13:43:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2766', '715', '2', 'c77860bfa01390b3af5299fe5979c556.jpg', '2018-09-28 11:29:26', '2018-09-28 11:29:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2767', '715', '3', '8ffd651e2dc19bbe1cae9d26784ddf68.jpg', '2018-09-28 11:29:55', '2018-09-28 11:29:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2768', '938', '2', '8f1c001431064e0de128731c25e6b954.jpg', '2018-09-28 11:38:46', '2018-09-28 11:38:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2769', '938', '2', '3708d9bbb617ff111878bd669be80518.jpg', '2018-09-28 11:38:46', '2018-09-28 11:38:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2770', '938', '3', '39ee4216729626b43a62c42f5ecf04e0.jpg', '2018-09-28 11:39:15', '2018-09-28 11:39:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2771', '693', '2', '1472c5d136bf7143773cf7af51f43408.jpg', '2018-09-28 11:43:25', '2018-09-28 11:43:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2772', '693', '3', 'c1222ceb7edac63db6eab2b6d0c03539.jpg', '2018-09-28 11:43:36', '2018-09-28 11:43:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2773', '749', '1', 'a179f2cf84766f28917b5db208396ad9.jpg', '2018-09-28 12:35:51', '2018-09-28 12:35:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2774', '749', '2', 'eb3caa31e40b6422860a2976b1e9a75f.jpg', '2018-09-28 12:36:11', '2018-09-28 12:36:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2775', '749', '3', 'fc210b12487b4aee8d88e02025efae1b.jpg', '2018-09-28 12:36:37', '2018-09-28 12:36:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2776', '690', '1', '26301fd01b5b39ecc6ee5a341f1286bb.jpg', '2018-09-28 12:37:23', '2018-09-28 12:37:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2777', '690', '2', '59ce1cb96f444eb3884d11f2c4a34eb7.jpg', '2018-09-28 12:37:35', '2018-09-28 12:37:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2778', '690', '2', '9e57e0ada383261758c7c6bc4988f8cf.jpg', '2018-09-28 12:37:35', '2018-09-28 12:37:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2779', '690', '3', 'aac4299988d6d56973cb8aaeb8ae4431.jpg', '2018-09-28 12:37:56', '2018-09-28 12:37:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2780', '468', '1', 'f305afc04d75cd3e749c1502134b7230.jpg', '2018-09-28 12:38:31', '2018-09-28 12:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2781', '468', '2', '64ed5c360f9c01c0bc78d84f863d0e28.jpg', '2018-09-28 12:38:38', '2018-09-28 12:38:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2782', '468', '3', 'b8ab03fd6024b1a611a13be319204f98.jpg', '2018-09-28 12:38:57', '2018-09-28 12:38:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2783', '467', '1', '56d731b96d62546908cda8bd7e95b4ea.jpg', '2018-09-28 12:48:11', '2018-09-28 12:48:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2784', '467', '2', 'fc55211b948a0d760c941fffe654ed03.jpg', '2018-09-28 12:48:25', '2018-09-28 12:48:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2785', '467', '3', '51a69448d097001b150fe1a423436704.jpg', '2018-09-28 12:48:46', '2018-09-28 12:48:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2786', '466', '1', '769966d8a16f906926180ad964a8548c.jpg', '2018-09-28 12:49:04', '2018-09-28 12:49:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2787', '466', '2', '0c176166a7d5f03dcc15f5110cc44362.jpg', '2018-09-28 12:49:16', '2018-09-28 12:49:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2788', '466', '2', 'e9b383fedef2304e11172fbd52259ac4.jpg', '2018-09-28 12:49:16', '2018-09-28 12:49:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2789', '466', '3', '0cf31c181f62d444f96c6a2b081ec09c.jpg', '2018-09-28 12:49:37', '2018-09-28 12:49:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2790', '897', '1', '99db54e6183955b0c232318f09d8f54e.jpg', '2018-09-28 13:37:49', '2018-09-28 13:37:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2791', '897', '1', '5067f79a8584d1149ff5129380830175.jpg', '2018-09-28 13:37:49', '2018-09-28 13:37:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2792', '897', '2', 'c7843aa8b113906b47141c803bf842b9.jpg', '2018-09-28 13:38:28', '2018-09-28 13:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2793', '897', '2', '92ce20302be79b4d79129f12dfd6b362.jpg', '2018-09-28 13:38:28', '2018-09-28 13:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2794', '897', '2', 'd06a790935878a1e3b8662212f33a9a0.jpg', '2018-09-28 13:38:28', '2018-09-28 13:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2795', '897', '2', '7c985c3375e7115e5fbe659da41838e6.jpg', '2018-09-28 13:38:28', '2018-09-28 13:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2796', '897', '2', 'bd9e12119f0c0246b7739e3628636238.jpg', '2018-09-28 13:38:28', '2018-09-28 13:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2797', '897', '3', '7dabe8df2b2e84a61ca5826d274978e8.jpg', '2018-09-28 13:39:20', '2018-09-28 13:39:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2798', '998', '1', 'e8287c5a0567a41572cded7d3f8e77c6.jpg', '2018-09-28 13:40:35', '2018-09-28 13:40:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2799', '998', '1', '582ca1c3081197aafd6302faf6712c0a.jpg', '2018-09-28 13:40:35', '2018-09-28 13:40:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2800', '998', '2', 'd0c6c8a60077f31495102949968cc6a2.jpg', '2018-09-28 13:41:15', '2018-09-28 13:41:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2801', '998', '2', '41078df587735729ad70e505281d716d.jpg', '2018-09-28 13:41:15', '2018-09-28 13:41:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2802', '998', '2', '5a9b367bb5586c1da85276dd790a3e4b.jpg', '2018-09-28 13:41:15', '2018-09-28 13:41:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2803', '998', '3', 'fc346c7a0bf7f70988553b41d65f66de.jpg', '2018-09-28 13:42:20', '2018-09-28 13:42:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2804', '889', '2', '70edf27ed29c83afaefa14000dfece03.jpg', '2018-09-29 09:36:26', '2018-09-29 09:36:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2805', '889', '3', '69896eb7c3b01a9e223999ddda556c6b.jpg', '2018-09-29 09:37:32', '2018-09-29 09:37:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2806', '1032', '1', '3dfb213dae3142a54a6e73a79ae81477.jpg', '2018-09-29 09:53:15', '2018-09-29 09:53:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2807', '1032', '2', '0a2086b9b0ff9a7011311d8f82bcf440.jpg', '2018-09-29 09:53:32', '2018-09-29 09:53:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2808', '1032', '3', '7557148da66e9940ef4c6a78de2f8aa5.jpg', '2018-09-29 10:46:05', '2018-09-29 10:46:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2809', '813', '1', 'c92feea75249724b9c33dd95912a7e18.jpg', '2018-10-01 09:50:25', '2018-10-01 09:50:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2810', '813', '2', '6050ac6bcd2540456107108390cf35b1.jpg', '2018-10-01 09:50:40', '2018-10-01 09:50:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2811', '813', '2', 'e9f4535c3fdf4e2a331e7dab4296701e.jpg', '2018-10-01 09:50:40', '2018-10-01 09:50:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2812', '813', '3', '41ce8fbb7cea7f80efac6d1c2a6dc3cc.jpg', '2018-10-01 09:55:46', '2018-10-01 09:55:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2813', '862', '1', '9c07f90132fb309b7bca7eddabae8ff5.jpg', '2018-10-01 10:02:35', '2018-10-01 10:02:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2814', '862', '2', '00cf9ad42a9e6bc252818e4a73bd1809.jpg', '2018-10-01 10:02:49', '2018-10-01 10:02:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2815', '862', '2', 'd61d7e7601282149b793e00bebdb59fe.jpg', '2018-10-01 10:02:49', '2018-10-01 10:02:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2816', '862', '3', '7ca3b0b2da5751e74eea7c980023b6be.jpg', '2018-10-01 10:03:27', '2018-10-01 10:03:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2817', '1033', '1', '75f0e08f5fd581ffc86e3a7b4f449998.jpg', '2018-10-01 13:28:10', '2018-10-01 13:28:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2818', '1033', '1', '87ccfd7cd3ef1e1efeb0c1349be5b688.jpg', '2018-10-01 13:28:10', '2018-10-01 13:28:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2819', '1033', '2', '148118411218f313a0af0e0aafbfcdb5.jpg', '2018-10-01 13:28:50', '2018-10-01 13:28:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2820', '1033', '2', '95f83f94aea9d88318ca90e109a28acb.jpg', '2018-10-01 13:28:50', '2018-10-01 13:28:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2821', '1033', '2', 'e8e7eb7f74f076d9f2211cd3ab95422f.jpg', '2018-10-01 13:28:50', '2018-10-01 13:28:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2822', '1033', '2', '9fbdf61526004c93c108de8b31ab4dd9.jpg', '2018-10-01 13:28:50', '2018-10-01 13:28:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2823', '1033', '3', 'c14e84edb40b734c6d0ef138869be92c.jpg', '2018-10-01 13:29:28', '2018-10-01 13:29:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2824', '989', '1', '4c29f463fa1db325ba5ab74b086d24f9.jpg', '2018-10-01 14:38:11', '2018-10-01 14:38:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2825', '989', '2', '77bb0f3f9eb12dee905993a7c207bfa8.jpg', '2018-10-01 14:46:05', '2018-10-01 14:46:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2826', '989', '3', '0eb6bd4bd9235d7d03cac46ee38be364.jpg', '2018-10-01 14:46:33', '2018-10-01 14:46:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2827', '988', '1', '2c0edb8b734d49458b2ac4056b4699bd.jpg', '2018-10-01 14:48:42', '2018-10-01 14:48:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2828', '988', '2', '7712f14dc88696755f16fbf31ff4c1b6.jpg', '2018-10-01 14:48:51', '2018-10-01 14:48:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2829', '988', '3', '3a58ee96f06afff54861c34cc09f9bb4.jpg', '2018-10-01 14:49:34', '2018-10-01 14:49:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2830', '996', '2', 'ee0a57e115bd1dc31db49717cd25e4d4.jpg', '2018-10-01 15:23:34', '2018-10-01 15:23:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2831', '996', '3', 'ca743aa6287ab6753fc3cb0d03a3592e.jpg', '2018-10-01 15:24:23', '2018-10-01 15:24:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2832', '941', '2', 'df82e46c29d2d7528b8d7ed70564bd40.jpg', '2018-10-01 15:25:25', '2018-10-01 15:25:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2833', '941', '3', '6a65270b87c38867c63d23428c40ada6.jpg', '2018-10-01 15:25:55', '2018-10-01 15:25:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2834', '1012', '1', '16dd7b14887495e03948bfcecf8ebdd1.jpg', '2018-10-01 18:12:53', '2018-10-01 18:12:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2835', '1012', '2', '70fc993c356445d8cfe3157a62ba52c5.jpg', '2018-10-01 18:13:25', '2018-10-01 18:13:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2836', '1012', '3', '33bd318857faf670cc49d753a87eaf80.jpg', '2018-10-01 18:14:54', '2018-10-01 18:14:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2837', '1034', '1', '190c925c213e5a2daa8e38c060be309c.jpg', '2018-10-01 18:16:20', '2018-10-01 18:16:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2838', '1034', '2', 'a1cf95161e84a720fa1dda6059cedac4.jpg', '2018-10-01 18:16:47', '2018-10-01 18:16:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2839', '962', '1', '749dc4a0cad8b759bc9dbd3104ee4018.jpg', '2018-10-02 11:59:19', '2018-10-02 11:59:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2840', '962', '2', 'd6b6601b6228012f907f9cbc6eeacb10.jpg', '2018-10-02 11:59:30', '2018-10-02 11:59:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2841', '962', '3', '3fedb16005bf98e922e24e386886c344.jpg', '2018-10-02 12:01:17', '2018-10-02 12:01:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2842', '815', '2', '80fb705e8971f0cd67bf7dc6bc45eee9.jpg', '2018-10-02 13:59:39', '2018-10-02 13:59:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2843', '815', '3', 'dd9e9adebe92497096f12aed5a41fd75.jpg', '2018-10-02 13:59:54', '2018-10-02 13:59:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2844', '970', '2', 'edf4d1a9d6df00139cee6d7395e474a8.jpg', '2018-10-02 14:02:23', '2018-10-02 14:02:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2845', '970', '3', '9a248b43195531ec819b85d8219753a9.jpg', '2018-10-02 14:02:35', '2018-10-02 14:02:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2846', '1036', '1', '852c5574db43dc18f53910ff5a7a0dea.jpg', '2018-10-02 14:03:19', '2018-10-02 14:03:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2847', '1036', '1', '680033b73a52a0d8fc347d35db46b690.jpg', '2018-10-02 14:03:19', '2018-10-02 14:03:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2848', '1036', '2', '8e348658599f7fd8a4d8948abc54f026.jpg', '2018-10-02 14:04:11', '2018-10-02 14:04:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2849', '1036', '3', '8bf2a380b657ed3cf43946198bb6b365.jpg', '2018-10-02 14:10:41', '2018-10-02 14:10:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2850', '950', '2', 'ca532a039cd0e2565f9bfcfacb22fd4d.jpg', '2018-10-02 14:51:36', '2018-10-02 14:51:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2851', '950', '3', '95c4fee0735c1776e1d0a1ab9b278ae7.jpg', '2018-10-02 14:52:01', '2018-10-02 14:52:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2852', '949', '2', '943a419c7e4f6076ab845866161bb1b2.jpg', '2018-10-02 14:52:31', '2018-10-02 14:52:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2853', '949', '3', 'b7ed97849943874855a23627264e6ad9.jpg', '2018-10-02 14:52:51', '2018-10-02 14:52:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2854', '1034', '3', 'ae94958ac7e68024c6f4c56acf4e54da.jpg', '2018-10-03 12:14:23', '2018-10-03 12:14:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2855', '1026', '2', '960b0670386c1bca688b0261b658612f.jpg', '2018-10-03 12:37:12', '2018-10-03 12:37:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2856', '1026', '3', '5bb513e45874d80d0d5d71e229dad6a2.jpg', '2018-10-03 12:37:21', '2018-10-03 12:37:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2857', '1040', '2', '27300a271d45f909c9084bca6640b5c0.jpg', '2018-10-03 12:39:45', '2018-10-03 12:39:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2858', '1040', '3', '5dbb594b0ba6983293cab50436634d77.jpg', '2018-10-03 12:40:23', '2018-10-03 12:40:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2859', '921', '2', '6a85a88acd8d961aef2b8c61216a8fb2.jpg', '2018-10-03 13:10:27', '2018-10-03 13:10:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2860', '921', '3', 'a33f221c47661667e2c3cf80098e5818.jpg', '2018-10-03 13:10:59', '2018-10-03 13:10:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2861', '971', '2', '565fd97c08f0d2b9f2398e0b9804f5e0.jpg', '2018-10-03 13:14:25', '2018-10-03 13:14:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2862', '971', '2', 'd77bfde4edd6fb1068066ba1330e9995.jpg', '2018-10-03 13:14:25', '2018-10-03 13:14:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2863', '971', '3', 'febb6b2c575da0047c21c91b2e9095a5.jpg', '2018-10-03 13:14:45', '2018-10-03 13:14:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2864', '1035', '2', '457f03d7cd7c5a577de054bc6fb9de82.jpg', '2018-10-03 13:23:44', '2018-10-03 13:23:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2865', '1035', '3', '00a5741abaf3cf417869205597bb9d71.jpg', '2018-10-03 13:24:14', '2018-10-03 13:24:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2866', '894', '2', '82b570d4619c80152d98a6aa613aeeb2.jpg', '2018-10-03 13:27:45', '2018-10-03 13:27:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2867', '894', '2', 'fc7c91bc96cd97874eef1ee79998a026.jpg', '2018-10-03 13:27:45', '2018-10-03 13:27:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2868', '894', '3', 'f4ce94491dce066bca38d10043b93cb2.jpg', '2018-10-03 13:28:08', '2018-10-03 13:28:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2869', '1024', '2', 'cbbe82280153431fdb40ab917552833a.jpg', '2018-10-03 13:32:57', '2018-10-03 13:32:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2870', '1024', '3', '001c69a544b33a1b4e0d6ad9209d8d77.jpg', '2018-10-03 13:33:20', '2018-10-03 13:33:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2871', '925', '2', 'b3cdc4108db220e670e611cab182d774.jpg', '2018-10-03 13:38:07', '2018-10-03 13:38:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2872', '925', '3', '4b368d7d097220739a36c278cf929af5.jpg', '2018-10-03 13:38:26', '2018-10-03 13:38:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2873', '855', '2', '11554bcb727a54202f9e4d640350250a.jpg', '2018-10-03 13:38:55', '2018-10-03 13:38:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2874', '855', '3', 'e9c574ab0ec7fa3ec11c96b370691470.jpg', '2018-10-03 13:39:20', '2018-10-03 13:39:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2875', '186', '2', '88503b6ab3f1e2e9bcea20a58db614d1.jpg', '2018-10-03 13:41:57', '2018-10-03 13:41:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2876', '186', '3', '71e692aeb9859f43e365e4d08a1e42f7.jpg', '2018-10-03 13:42:06', '2018-10-03 13:42:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2877', '1005', '2', '4d063e089e10562cd3d3657fea4c7e2e.jpg', '2018-10-03 13:49:24', '2018-10-03 13:49:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2878', '1005', '3', '850b3fb1094053b308c8d905d0c98d79.jpg', '2018-10-03 13:49:50', '2018-10-03 13:49:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2879', '999', '2', '52895ba736dabc724a844bdc48c61ee7.jpg', '2018-10-03 13:51:00', '2018-10-03 13:51:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2880', '999', '3', '567555c7970436c0fc468f54f484e833.jpg', '2018-10-03 13:51:18', '2018-10-03 13:51:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2881', '980', '2', '47e8d3cf47bb060a3fc5e1c4e8598cdf.jpg', '2018-10-03 13:56:55', '2018-10-03 13:56:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2882', '980', '2', '5bb93a3f49965588a28e359de1c856db.jpg', '2018-10-03 13:56:55', '2018-10-03 13:56:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2883', '980', '3', '1694a0c444759f02d9753c3bfc8c671e.jpg', '2018-10-03 13:57:18', '2018-10-03 13:57:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2884', '358', '2', '7bca45e1350e18fe6fc31701f36c1709.jpg', '2018-10-03 13:58:57', '2018-10-03 13:58:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2885', '358', '3', 'd1602fd7e1066254f813184919395add.jpg', '2018-10-03 13:59:14', '2018-10-03 13:59:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2886', '1008', '2', '10f29868a0bd2f66e02b6c6541a40451.jpg', '2018-10-03 14:05:38', '2018-10-03 14:05:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2887', '1008', '3', 'd9fa398dc69021386a127da319b1975d.jpg', '2018-10-03 14:05:52', '2018-10-03 14:05:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2888', '681', '2', '0f29c152eb405fa3cdea47576a01b804.jpg', '2018-10-03 14:11:20', '2018-10-03 14:11:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2889', '681', '2', 'a5d6545a2b1e7d31c95532684f860d49.jpg', '2018-10-03 14:11:20', '2018-10-03 14:11:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2890', '681', '2', '0dbff3c9db521a754575b3997f403996.jpg', '2018-10-03 14:11:20', '2018-10-03 14:11:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2891', '681', '3', '0ee228fdff45ed0948d5311c04d6a468.jpg', '2018-10-03 14:11:35', '2018-10-03 14:11:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2892', '391', '2', '1f96b338d6f8e1f8dc2fb7ae36b647d1.jpg', '2018-10-03 14:14:03', '2018-10-03 14:14:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2893', '391', '3', '7f7a3ea52885dec500fd489404c2d954.jpg', '2018-10-03 14:14:16', '2018-10-03 14:14:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2894', '390', '2', '40c48f373d3c31879b3d52cf74cca803.jpg', '2018-10-03 14:17:36', '2018-10-03 14:17:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2895', '390', '3', '5ffa60a698218defac1ff41eb434d9cd.jpg', '2018-10-03 14:17:49', '2018-10-03 14:17:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2896', '857', '2', '4d2b1bddad1b4effc0cf8e48cd8a9ae9.jpg', '2018-10-03 14:19:48', '2018-10-03 14:19:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2897', '857', '3', 'cb06435f85d3c8c71295a77b0433cc09.jpg', '2018-10-03 14:20:04', '2018-10-03 14:20:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2898', '152', '2', '9e486a300e426edb795cd200947c6b4d.jpg', '2018-10-03 14:22:58', '2018-10-03 14:22:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2899', '152', '3', '2110c2eb34d7b5bb4a2e4704509d9843.jpg', '2018-10-03 14:23:13', '2018-10-03 14:23:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2900', '151', '2', '20cfc98ff1c6c0bd879b1d26533210a2.jpg', '2018-10-03 14:31:49', '2018-10-03 14:31:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2901', '151', '3', '28f7c58c1a8a90e127421156c7a59320.jpg', '2018-10-03 14:32:06', '2018-10-03 14:32:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2902', '160', '2', '4c03381374bd4d4255db1e1dec3efeff.jpg', '2018-10-03 14:34:53', '2018-10-03 14:34:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2903', '160', '3', '8036cf703909c9a1c657103f90d4b0c0.jpg', '2018-10-03 14:35:07', '2018-10-03 14:35:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2904', '688', '2', '51ddbbe60261e5c96537e609c445cdf3.jpg', '2018-10-03 14:37:23', '2018-10-03 14:37:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2905', '688', '3', '46d39f2b25b6877d2e653bf3d45a566c.jpg', '2018-10-03 14:37:36', '2018-10-03 14:37:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2906', '1038', '1', 'd55400e964a778ed9c54a985a15d3d09.jpg', '2018-10-03 16:46:36', '2018-10-03 16:46:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2907', '1038', '1', 'ded42164c1c38b6447fc09e28c6a5726.jpg', '2018-10-03 16:46:36', '2018-10-03 16:46:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2908', '1038', '1', '8af8e3776422eb593536db4175b23c4a.jpg', '2018-10-03 16:46:36', '2018-10-03 16:46:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2909', '1038', '1', 'dfc00b467eab407b648dd12c925398ae.jpg', '2018-10-03 16:46:36', '2018-10-03 16:46:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2910', '1038', '2', '4efbe5f85edadafb79b2dab1c5d377e0.jpg', '2018-10-03 16:47:28', '2018-10-03 16:47:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2911', '1038', '2', '7aadb32bbbce03e7b0b9268233a88db0.jpg', '2018-10-03 16:48:15', '2018-10-03 16:48:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2912', '1038', '2', '6dc31b80739aa164efa55edf3cee03e8.jpg', '2018-10-03 16:48:15', '2018-10-03 16:48:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2913', '1038', '3', '652b48de8f8b49a9fb7dde0af280c11c.jpg', '2018-10-03 16:50:13', '2018-10-03 16:50:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2914', '1038', '3', 'cbb9077fa4fb4f2cc15172a8fcfc86e4.jpg', '2018-10-03 16:50:13', '2018-10-03 16:50:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2915', '1015', '1', '5768daf180953cad05a37ec0956a8c71.jpg', '2018-10-03 17:10:07', '2018-10-03 17:10:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2916', '1015', '1', '73065f742acf4b038588115962584066.jpg', '2018-10-03 17:10:07', '2018-10-03 17:10:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2917', '1015', '2', 'c3d335ff071a697cb300fe7b5f02c7e4.jpg', '2018-10-03 17:10:45', '2018-10-03 17:10:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2918', '1015', '2', '475079393387fe824a08038a2bca3318.jpg', '2018-10-03 17:10:45', '2018-10-03 17:10:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2919', '1015', '2', '3c9776d4dc99077068d1caa2833a5d2a.jpg', '2018-10-03 17:10:45', '2018-10-03 17:10:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2920', '1029', '1', '1c562aaeb738bd8615ec1f577532d4d9.jpg', '2018-10-03 17:11:57', '2018-10-03 17:11:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2921', '1029', '1', '4ddf001c8429514698c485c622eacced.jpg', '2018-10-03 17:11:57', '2018-10-03 17:11:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2922', '1029', '2', '8b14ca4fae2ee9b99f99a62a0f0721e9.jpg', '2018-10-03 17:12:08', '2018-10-03 17:12:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2923', '1029', '2', '3c7dea57a75a4c8d9681260ae501f373.jpg', '2018-10-03 17:12:08', '2018-10-03 17:12:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2924', '1029', '2', 'ab33718fc1ad6f2c5d1401b39b8d7839.jpg', '2018-10-03 17:12:08', '2018-10-03 17:12:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2925', '1015', '3', '43692bc96564206140d95e1ea113676a.jpg', '2018-10-03 17:16:22', '2018-10-03 17:16:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2926', '1029', '3', '7768452ffc413038fb0b882db084546a.jpg', '2018-10-03 17:17:08', '2018-10-03 17:17:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2927', '1028', '1', 'd0972679a5a122a2770103409f2a08be.jpg', '2018-10-03 17:49:17', '2018-10-03 17:49:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2928', '1028', '2', '59bf90614d21db7e5bc7a70e9bdbdb4d.jpg', '2018-10-03 17:49:37', '2018-10-03 17:49:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2929', '1028', '2', 'de7ee5b9fef94707d51b5e0ab2ca6ebc.jpg', '2018-10-03 17:49:37', '2018-10-03 17:49:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2930', '1028', '2', 'af2d3ddd7364fb1dd3dc7de32f3c3f4c.jpg', '2018-10-03 17:49:37', '2018-10-03 17:49:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2931', '1028', '2', '90f7efbb6982f687d68644cedcbe6855.jpg', '2018-10-03 17:49:37', '2018-10-03 17:49:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2932', '1028', '3', '204828dd79a4422e0900a9fa5b86b168.jpg', '2018-10-03 17:53:12', '2018-10-03 17:53:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2933', '797', '1', '28d06e22716de96bef7d87843569701f.jpg', '2018-10-04 12:01:39', '2018-10-04 12:01:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2934', '797', '1', 'e5da6548734155ec8a854f0291090763.jpg', '2018-10-04 12:01:39', '2018-10-04 12:01:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2935', '797', '1', 'abc17acb1857227f45401207cd434073.jpg', '2018-10-04 12:01:39', '2018-10-04 12:01:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2936', '797', '1', 'b5a75a54183a6388eda5567bdd891006.jpg', '2018-10-04 12:01:39', '2018-10-04 12:01:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2937', '1056', '1', '63ba79fe7abd3724494ca39ae34880ff.jpg', '2018-10-04 12:02:20', '2018-10-04 12:02:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2938', '797', '2', '99a46d1be9fa9bf94c244312b8740656.jpg', '2018-10-04 12:02:30', '2018-10-04 12:02:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2939', '797', '2', 'efb4dc9f188a5c017c0876aeff1ab0e5.jpg', '2018-10-04 12:02:30', '2018-10-04 12:02:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2940', '797', '2', '17f6b043acc836a313059ac65dcc4d8a.jpg', '2018-10-04 12:02:30', '2018-10-04 12:02:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2941', '797', '2', '1312cb67b091caa5cd038a73246fd977.jpg', '2018-10-04 12:02:30', '2018-10-04 12:02:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2942', '797', '2', 'dab041f48bd1e3d91cba301ac2ce56b6.jpg', '2018-10-04 12:02:30', '2018-10-04 12:02:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2943', '797', '2', '294f96e3f9117d357eb0883b76efd908.jpg', '2018-10-04 12:02:30', '2018-10-04 12:02:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2944', '1056', '2', 'e7ed26ae9447470c2bbefae7aa35ebe8.jpg', '2018-10-04 12:02:45', '2018-10-04 12:02:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2945', '1056', '3', '8909ec930cf31651ef505366a217693f.jpg', '2018-10-04 12:03:20', '2018-10-04 12:03:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2946', '797', '3', '6eba1b8af48e6c2bc0c47e3a99f30c46.jpg', '2018-10-04 12:03:39', '2018-10-04 12:03:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2947', '1061', '1', '47fea5f257d1128c71e74e814d64bc87.jpg', '2018-10-04 16:31:42', '2018-10-04 16:31:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2948', '1061', '2', 'cac6d19e6979ffa648fb83699484fd03.jpg', '2018-10-04 16:31:56', '2018-10-04 16:31:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2949', '1061', '2', '4ef23188b20a9d4582e6805609f8d758.jpg', '2018-10-04 16:31:56', '2018-10-04 16:31:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2950', '1061', '2', '7926abc305e08f53e79acf227919c190.jpg', '2018-10-04 16:31:56', '2018-10-04 16:31:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2951', '1061', '3', '18c4658d8955b3479ad2bad09a6271b2.jpg', '2018-10-04 16:34:10', '2018-10-04 16:34:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2952', '1066', '1', '26a758c52332e36ad44947b9172adb16.jpg', '2018-10-04 17:53:13', '2018-10-04 17:53:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2953', '1066', '2', 'ae1cdd29be5d7a9a495c08affa3986de.jpg', '2018-10-04 17:54:13', '2018-10-04 17:54:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2954', '1066', '2', '6eb18b216b3a19f25858bc6ba0c38541.jpg', '2018-10-04 17:54:13', '2018-10-04 17:54:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2955', '1066', '2', '849ef638a3cd7db4c5bf26245c5c2fad.jpg', '2018-10-04 17:54:13', '2018-10-04 17:54:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2956', '1066', '3', '6c731e66939f7e1e8bb2c95f7c1d0076.jpg', '2018-10-04 17:55:21', '2018-10-04 17:55:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2957', '1067', '1', '2635e98f4afd70fdeaa002dfcc5ce8ab.jpg', '2018-10-05 10:45:54', '2018-10-05 10:45:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2958', '1067', '2', '5f47f8ab5a1316f02b26fabdfab109a2.jpg', '2018-10-05 10:46:33', '2018-10-05 10:46:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2959', '1067', '2', '73afd05ec7390e80866d260ed154323d.jpg', '2018-10-05 10:46:33', '2018-10-05 10:46:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2960', '1067', '3', 'e5874e85f36c847ae277d04ee15217ba.jpg', '2018-10-05 10:47:29', '2018-10-05 10:47:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2961', '1027', '2', '5a3bc2d8eb8224085266546349523854.jpg', '2018-10-05 11:14:43', '2018-10-05 11:14:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2962', '1027', '2', '0c2b1d98c86b906f92373fe907586972.jpg', '2018-10-05 11:14:43', '2018-10-05 11:14:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2963', '1027', '3', '4e3a969120438a629204c3c17fbc2278.jpg', '2018-10-05 11:15:12', '2018-10-05 11:15:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2964', '967', '2', '0fc9e20c0c840c8a125276181d4cdaea.jpg', '2018-10-05 11:19:29', '2018-10-05 11:19:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2965', '967', '3', '784d74e3c745c1396230c3e08944806b.jpg', '2018-10-05 11:21:42', '2018-10-05 11:21:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2966', '926', '1', '428f448424d87801419f1ebbdd6ae271.jpg', '2018-10-08 11:42:21', '2018-10-08 11:42:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2967', '926', '2', '6fe907fcd6c00da985ce97c4fef8397e.jpg', '2018-10-08 11:42:34', '2018-10-08 11:42:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2968', '926', '2', 'bbd0db5532d191de576f5f98ff097f37.jpg', '2018-10-08 11:42:34', '2018-10-08 11:42:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2969', '926', '3', '4727d98f3d1fa8ac59cde169eeb7ff52.jpg', '2018-10-08 11:44:45', '2018-10-08 11:44:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2970', '926', '3', '172fd1fbb2f1048b26c0e495b3944ed8.jpg', '2018-10-08 11:45:16', '2018-10-08 11:45:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2971', '1037', '1', '54019ca5fa41b767c907f3c2fcb70d80.jpg', '2018-10-08 12:48:19', '2018-10-08 12:48:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2972', '1037', '2', '1ac7a256edfa6c3e89e6175ae724bd65.jpg', '2018-10-08 12:48:35', '2018-10-08 12:48:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2973', '1037', '3', '5282096af233062edbda266b59335d75.jpg', '2018-10-08 13:02:34', '2018-10-08 13:02:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2974', '1069', '1', 'd432d9d315690e365f3ab8b0c288f4eb.jpg', '2018-10-08 16:17:31', '2018-10-08 16:17:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2975', '1069', '2', 'd3b46e275986509f750d29ae7316653e.jpg', '2018-10-08 16:17:45', '2018-10-08 16:17:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2976', '1069', '3', '6470b71397fe0c960259b75f534cde09.jpg', '2018-10-08 16:18:27', '2018-10-08 16:18:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2977', '1068', '1', '05bd53828e336993c409abed84c34f10.jpg', '2018-10-08 16:19:56', '2018-10-08 16:19:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2978', '1068', '2', '94baf54b2e5c597fb056447bb0891b57.jpg', '2018-10-08 16:20:06', '2018-10-08 16:20:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2979', '1068', '3', 'f24ac31f649f427cdac89364e2d083f5.jpg', '2018-10-08 16:20:57', '2018-10-08 16:20:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2980', '1087', '1', '7f617097fd50d9b840a1cdd788d0e661.jpg', '2018-10-09 09:59:40', '2018-10-09 09:59:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2981', '1087', '1', '616178409132b954864cc77bf65af231.jpg', '2018-10-09 09:59:40', '2018-10-09 09:59:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2982', '1087', '1', 'fbdf4f72fe44ac29d9f9bc8e4e686c36.jpg', '2018-10-09 09:59:40', '2018-10-09 09:59:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2983', '1087', '1', '190c7775e54fb295c8fc789f9f6fc628.jpg', '2018-10-09 09:59:40', '2018-10-09 09:59:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2984', '1087', '2', '1a1a2527275dacc6eed2d25184b91242.jpg', '2018-10-09 10:00:46', '2018-10-09 10:00:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2985', '1087', '2', '10ae3220d2c78f3fd59ea6866ea4c78c.jpg', '2018-10-09 10:00:46', '2018-10-09 10:00:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2986', '1087', '2', 'ad1f741b930439377212f301e2aada9d.jpg', '2018-10-09 10:00:46', '2018-10-09 10:00:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2987', '1087', '2', 'ab44dd43d06baad156a7a6670f46dc23.jpg', '2018-10-09 10:00:46', '2018-10-09 10:00:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2988', '1087', '2', '79941e65e48d60335987c0eff2603524.jpg', '2018-10-09 10:00:46', '2018-10-09 10:00:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2989', '1087', '2', '80bfb54110e7a742616a2cdffe39819a.jpg', '2018-10-09 10:00:46', '2018-10-09 10:00:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2990', '1087', '3', 'e44e05f495a12c6fbf6a492bdcb08a2e.jpg', '2018-10-09 10:01:57', '2018-10-09 10:01:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2991', '1090', '1', '8797fa8b53dcba845b444515175a811c.jpg', '2018-10-09 11:07:25', '2018-10-09 11:07:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2992', '1090', '2', '2537dc886a631494a640c0627793dea8.jpg', '2018-10-09 11:07:40', '2018-10-09 11:07:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2993', '1090', '2', '93e44f7bcc4be7fa2c4fe712a6597563.jpg', '2018-10-09 11:07:40', '2018-10-09 11:07:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2994', '1090', '2', '84f49d5fa834b9f554cd876e3f23530e.jpg', '2018-10-09 11:07:40', '2018-10-09 11:07:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2995', '1090', '3', 'ff9b428e5a646738def31683664817c5.jpg', '2018-10-09 11:11:06', '2018-10-09 11:11:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2996', '1084', '1', '83ad073455c2525d471f3ede33b06816.jpg', '2018-10-09 11:33:11', '2018-10-09 11:33:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2997', '1084', '2', 'd3391f7ccaebbeb6616264374c6d0cc2.jpg', '2018-10-09 11:33:40', '2018-10-09 11:33:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2998', '1084', '2', 'beadc0af795a0355e9bb7a682291cc5f.jpg', '2018-10-09 11:33:41', '2018-10-09 11:33:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('2999', '1084', '2', 'be9a890235a15e6b73a456f8e725c789.jpg', '2018-10-09 11:33:41', '2018-10-09 11:33:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3000', '1084', '3', '2c957fb381ffe7aafe661608afca443b.jpg', '2018-10-09 11:34:54', '2018-10-09 11:34:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3001', '1091', '1', '004a0e76087114ce6eac72dd05112c86.jpg', '2018-10-09 13:43:17', '2018-10-09 13:43:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3002', '1091', '2', 'e9f4b8432c8130b9c6182738be3d67ef.jpg', '2018-10-09 13:43:49', '2018-10-09 13:43:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3003', '1091', '3', '6ef4e959c471c39562b067e91f020a0d.jpg', '2018-10-09 13:44:28', '2018-10-09 13:44:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3004', '1102', '2', 'beea7ce5eccc4389c6b1b6940199026a.jpg', '2018-10-10 16:35:22', '2018-10-10 16:35:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3005', '1102', '3', '8e27381ccfd676ef77cb47837ac8d22a.jpg', '2018-10-10 16:37:39', '2018-10-10 16:37:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3006', '1098', '1', '563fcbff772b1c4076c40906d35d2a97.jpg', '2018-10-11 12:19:21', '2018-10-11 12:19:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3007', '1098', '1', 'a9dac0e56bcd90977716b62c265be86c.jpg', '2018-10-11 12:19:21', '2018-10-11 12:19:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3008', '1098', '1', 'e7ddddaab5e58080e7b7f7d152468277.jpg', '2018-10-11 12:19:21', '2018-10-11 12:19:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3009', '1098', '2', 'f521700b4cdffb66cdca383cc86ea337.jpg', '2018-10-11 12:20:26', '2018-10-11 12:20:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3010', '1098', '2', 'b0822c731a31914b35ae5a1d2621c714.jpg', '2018-10-11 12:20:26', '2018-10-11 12:20:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3011', '1098', '2', '24c9ded3016c2553e8ada2d90d5f7919.jpg', '2018-10-11 12:20:26', '2018-10-11 12:20:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3012', '1098', '2', 'add63622e0dc56b8c878aadc5d60abdc.jpg', '2018-10-11 12:20:26', '2018-10-11 12:20:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3013', '1098', '2', '755d98d37e16fe6f0f1688e0c585d145.jpg', '2018-10-11 12:20:26', '2018-10-11 12:20:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3014', '1098', '2', '0e74817ba5699e09bb124635424a05e8.jpg', '2018-10-11 12:20:26', '2018-10-11 12:20:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3015', '1098', '3', 'ce7832b774488fb2acfc698af52d8930.jpg', '2018-10-11 12:28:57', '2018-10-11 12:28:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3016', '1076', '1', '856f3505e6c440200ef1f973e185a7d9.jpg', '2018-10-11 13:07:48', '2018-10-11 13:07:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3017', '1076', '1', '4ba600281123129afd70042c2d14704a.jpg', '2018-10-11 13:07:48', '2018-10-11 13:07:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3018', '1076', '1', '33a5a39d95a009c0168193517b891d8a.jpg', '2018-10-11 13:07:48', '2018-10-11 13:07:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3019', '1076', '2', '4ccad6e66653c5821168ba1c56cfe29f.jpg', '2018-10-11 13:08:17', '2018-10-11 13:08:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3020', '1076', '2', '13928fc289a39571b8366ce93544e5ad.jpg', '2018-10-11 13:08:17', '2018-10-11 13:08:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3021', '1076', '2', 'bd47f419ac8b114ce96647e59e75e0e2.jpg', '2018-10-11 13:08:17', '2018-10-11 13:08:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3022', '1076', '2', '279cfa1384fbe9f492fb1ee7b91bbcdf.jpg', '2018-10-11 13:08:17', '2018-10-11 13:08:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3023', '1076', '3', '7a06a016d26bec0908d40cd8e334ac0c.jpg', '2018-10-11 13:09:03', '2018-10-11 13:09:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3024', '1095', '1', '29e846f71ff095b28f9591fcc6b862d3.jpg', '2018-10-12 17:31:23', '2018-10-12 17:31:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3025', '1095', '2', 'b48452394890c65940d30da0385a3055.jpg', '2018-10-12 17:31:35', '2018-10-12 17:31:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3026', '1095', '3', '462dd3ae6f331cce62ce177830b53a32.jpg', '2018-10-12 17:32:28', '2018-10-12 17:32:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3027', '1078', '1', '458b0f4a245a1e7b89a89f765b2c5d32.jpg', '2018-10-12 17:33:52', '2018-10-12 17:33:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3028', '1078', '2', 'a4f4fb98f3c0994dddc01a6db48cc5db.jpg', '2018-10-12 17:34:40', '2018-10-12 17:34:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3029', '1078', '3', 'b5b717ff6238e491ad56ef871cde7720.jpg', '2018-10-12 17:35:05', '2018-10-12 17:35:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3030', '1114', '1', '898ae14315d9af16141bf5660b19a0fa.jpg', '2018-10-13 09:17:39', '2018-10-13 09:17:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3031', '1114', '2', '2cacf3483de22d3823d644be2b62334d.jpg', '2018-10-13 09:18:11', '2018-10-13 09:18:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3032', '1114', '2', '3f4a4ed49a8232122d368d05e6088caf.jpg', '2018-10-13 09:18:11', '2018-10-13 09:18:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3033', '1114', '2', '9b7ae7d60d43f46fcfd7b04a2af21d81.jpg', '2018-10-13 09:18:11', '2018-10-13 09:18:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3034', '1114', '2', '5486d23189d361164a7ff27e1bd1298d.jpg', '2018-10-13 09:18:11', '2018-10-13 09:18:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3035', '1114', '3', '70233d01085880da2d096a4ef487b963.jpg', '2018-10-13 09:22:12', '2018-10-13 09:22:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3036', '1130', '1', '1a04fe73a74478e71939c3636b93c5ce.jpg', '2018-10-13 11:51:29', '2018-10-13 11:51:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3037', '1130', '1', '710218fbe506020e554ba01433574c30.jpg', '2018-10-13 11:51:29', '2018-10-13 11:51:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3038', '1130', '1', '5972b5cfd982b52fa24b7e9f7369e0dd.jpg', '2018-10-13 11:51:29', '2018-10-13 11:51:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3039', '1130', '2', '7d207d83a168561764efd1d7a127cdac.jpg', '2018-10-13 11:51:57', '2018-10-13 11:51:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3040', '1130', '2', '8ace43a2a734338625dffe5d252131db.jpg', '2018-10-13 11:51:57', '2018-10-13 11:51:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3041', '1130', '2', 'b0b40c04c57ed06eb5418fa773810dcd.jpg', '2018-10-13 11:51:57', '2018-10-13 11:51:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3042', '1130', '2', '80c0db81651d07fadd8ca9e7dd595524.jpg', '2018-10-13 11:51:57', '2018-10-13 11:51:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3043', '1130', '2', '1d984d2921d5327f3f0eadb65884139c.jpg', '2018-10-13 11:51:57', '2018-10-13 11:51:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3044', '1130', '3', '9731afc196e43d15569ec11b333ce749.jpg', '2018-10-13 11:56:54', '2018-10-13 11:56:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3045', '1086', '1', '4c137c55e954a15328f7ca7d23bac8c5.jpg', '2018-10-13 12:42:50', '2018-10-13 12:42:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3046', '1086', '2', '6df3ee74bc794a570a66e54f46934112.jpg', '2018-10-13 12:43:09', '2018-10-13 12:43:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3047', '1086', '2', 'c913f7ffdc9b517e59f5d4d2449bd088.jpg', '2018-10-13 12:43:09', '2018-10-13 12:43:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3048', '1086', '3', '6b2c49b360b00cd34e35726a15fd93da.jpg', '2018-10-13 12:46:33', '2018-10-13 12:46:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3049', '1013', '1', 'c5bee6d2b03ec7a1858ad7ec21723adf.jpg', '2018-10-13 17:18:20', '2018-10-13 17:18:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3050', '1013', '2', '2f493c737f6c17338c5264b14eda58b7.jpg', '2018-10-13 17:18:37', '2018-10-13 17:18:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3051', '1013', '3', '64e9cf2d36fcd6707699a6d71b3ab3a5.jpg', '2018-10-13 17:19:22', '2018-10-13 17:19:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3052', '1073', '1', 'dd28d23ce2583f42fab3656638e4f613.jpg', '2018-10-15 10:57:58', '2018-10-15 10:57:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3053', '1073', '2', '75845e0b74d41221614a75e8b1f38018.jpg', '2018-10-15 10:58:25', '2018-10-15 10:58:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3054', '1073', '2', '1677e4c8ac5bacacad3927700a6b1c2b.jpg', '2018-10-15 10:58:25', '2018-10-15 10:58:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3055', '1073', '2', '72ecf13977df8c71a9ddf7affe8c5265.jpg', '2018-10-15 10:58:25', '2018-10-15 10:58:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3056', '1073', '3', 'd7fb6ab23002cc1917ff1067aad7b831.jpg', '2018-10-15 10:59:15', '2018-10-15 10:59:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3057', '1030', '1', '8dd83163c392786920757599477bd084.jpg', '2018-10-15 11:35:12', '2018-10-15 11:35:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3058', '1030', '1', '4358d2ef54e0175bdd8a4fb5cbfb2c13.jpg', '2018-10-15 11:35:12', '2018-10-15 11:35:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3059', '1030', '2', 'b5132c31ccb6e4defd6d5e0f3d596b17.jpg', '2018-10-15 11:52:45', '2018-10-15 11:52:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3060', '1030', '2', '7a72c5e76f1b8a791f98940991147363.jpg', '2018-10-15 11:52:45', '2018-10-15 11:52:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3061', '1030', '2', '9b9ec35ebd196ac4e84e34139a1f2c1d.jpg', '2018-10-15 11:52:45', '2018-10-15 11:52:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3062', '1030', '2', '37fdfb1d3ee875326c1d024604882c54.jpg', '2018-10-15 11:52:45', '2018-10-15 11:52:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3063', '1030', '2', '330790d1bc2e71cf4f9e84616c5c86dd.jpg', '2018-10-15 11:52:45', '2018-10-15 11:52:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3064', '1030', '3', 'd4c015dfcbc312801bc84df99fa4b19f.jpg', '2018-10-15 11:54:32', '2018-10-15 11:54:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3065', '935', '2', 'f9190d14a558faf58a24040020691575.jpg', '2018-10-16 09:58:46', '2018-10-16 09:58:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3066', '935', '3', '51501e435a639f35556df3a589d536da.jpg', '2018-10-16 09:59:15', '2018-10-16 09:59:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3067', '858', '2', 'aa0990b1a095a07d4304c964abdc2bca.jpg', '2018-10-16 10:00:24', '2018-10-16 10:00:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3068', '858', '3', 'b9855cb3fba9a2babefe7c35fc6834d8.jpg', '2018-10-16 10:00:42', '2018-10-16 10:00:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3069', '1129', '1', '01c5e7f5fda5d79261825eb5659dd6b7.jpg', '2018-10-16 10:54:11', '2018-10-16 10:54:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3070', '1129', '2', '491f69cb943e78693e81c1f52c8fda20.jpg', '2018-10-16 10:54:33', '2018-10-16 10:54:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3071', '1129', '3', '8dc6e34ae4acf4b0a02319e7afbb337c.jpg', '2018-10-16 10:55:08', '2018-10-16 10:55:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3072', '1122', '1', '8126b20228221d1023b806e50a719331.jpg', '2018-10-16 10:58:28', '2018-10-16 10:58:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3073', '1122', '1', '11ce040736416fae33e4fc6a799139a0.jpg', '2018-10-16 10:58:29', '2018-10-16 10:58:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3074', '1122', '2', 'af9861f05e793967b3a19c8ee458e18d.jpg', '2018-10-16 10:58:40', '2018-10-16 10:58:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3075', '1122', '3', 'c2d67912eceb131f262ae5eb1ec7e522.jpg', '2018-10-16 11:01:13', '2018-10-16 11:01:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3076', '1122', '3', 'db684c7e7137abc3376e88f7f392eb00.jpg', '2018-10-16 11:02:15', '2018-10-16 11:02:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3077', '1053', '2', '967d51552245bf442da21cc5260cbdaf.jpg', '2018-10-16 11:49:17', '2018-10-16 11:49:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3078', '1053', '3', '76bd347508eaefabfb73ce9f54af4e13.jpg', '2018-10-16 11:49:35', '2018-10-16 11:49:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3079', '524', '2', '198f62dad51d9c82a9ea356d2ad1ad12.jpg', '2018-10-16 11:57:21', '2018-10-16 11:57:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3080', '524', '3', 'a85c558e9f3038c67361c82705cc10cd.jpg', '2018-10-16 11:57:39', '2018-10-16 11:57:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3081', '1058', '2', '9c67c096b47ac9c658324c4f9eac0780.jpg', '2018-10-16 12:02:55', '2018-10-16 12:02:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3082', '1058', '3', 'a8ec303136a9edbf365fb817e607a436.jpg', '2018-10-16 12:03:16', '2018-10-16 12:03:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3083', '1043', '2', '52666441f96a1b0ac3ed85ce5b643c2f.jpg', '2018-10-16 12:10:25', '2018-10-16 12:10:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3084', '1043', '3', '212ee250d071b1dac0b2b8ce563f23d6.jpg', '2018-10-16 12:11:20', '2018-10-16 12:11:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3085', '1139', '1', 'd07282e005b182732264f1f387fd44d1.jpg', '2018-10-16 13:07:35', '2018-10-16 13:07:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3086', '1139', '1', '6128d15ffe11889cbadb979eafc6541b.jpg', '2018-10-16 13:07:35', '2018-10-16 13:07:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3087', '1139', '2', 'cafe3b1ae391554a2244fe0a8ef4fbfc.jpg', '2018-10-16 13:08:25', '2018-10-16 13:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3088', '1139', '2', '684cb51723e37d61eb3e9818cd887fdf.jpg', '2018-10-16 13:08:25', '2018-10-16 13:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3089', '1139', '2', '7a18ebbacf668f6c21e15c0ee3ddac08.jpg', '2018-10-16 13:08:25', '2018-10-16 13:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3090', '1139', '2', '6126ae5c47dc3e458416b93869bcf531.jpg', '2018-10-16 13:08:25', '2018-10-16 13:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3091', '1139', '2', '4ea8db7b8b547776e400d15cc71ccc8d.jpg', '2018-10-16 13:08:25', '2018-10-16 13:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3092', '1139', '3', 'f48296ffaeb9afed7c077fbe8addf113.jpg', '2018-10-16 13:12:46', '2018-10-16 13:12:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3093', '1052', '2', '23454de7d06849d604482e5320fad590.jpg', '2018-10-16 17:58:41', '2018-10-16 17:58:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3094', '1052', '3', 'f604068c2f4500d2c2b7247d06075e32.jpg', '2018-10-16 17:58:55', '2018-10-16 17:58:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3095', '1020', '2', '3e3a59133701ff295f9ecd3d667dacea.jpg', '2018-10-16 18:19:40', '2018-10-16 18:19:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3096', '1020', '3', 'c2b03a25a0d7a71a29c438a9d3762612.jpg', '2018-10-16 18:19:56', '2018-10-16 18:19:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3097', '1018', '2', '3bd6bf4a6e2e81e169c0604e846d8665.jpg', '2018-10-16 18:35:58', '2018-10-16 18:35:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3098', '1018', '3', '7c311b737db74729088e439c5bda0c90.jpg', '2018-10-16 18:36:13', '2018-10-16 18:36:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3099', '1016', '2', '2101b5154bc9887e75c7d64d409c532f.jpg', '2018-10-16 18:37:57', '2018-10-16 18:37:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3100', '1016', '3', 'a8354d0133b3fe1eed8821bbba7a2f18.jpg', '2018-10-16 18:38:44', '2018-10-16 18:38:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3101', '1017', '2', '5905f6be4aa06fde411905c945c48780.jpg', '2018-10-16 18:40:09', '2018-10-16 18:40:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3102', '1017', '3', 'c0f7d83812767abea525faceaf6a58dd.jpg', '2018-10-16 18:40:26', '2018-10-16 18:40:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3103', '1022', '2', 'a3781ebc7a100d22be126e542b3e3521.jpg', '2018-10-16 18:41:43', '2018-10-16 18:41:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3104', '1022', '3', '0b2711ef7b637af86df026804bc1c050.jpg', '2018-10-16 18:41:55', '2018-10-16 18:41:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3105', '1116', '1', '504801bf2c11c8daf9456a804a374267.jpg', '2018-10-16 18:42:47', '2018-10-16 18:42:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3106', '1116', '1', '1a54cd0e873c78c5a7c56aae1b84204b.jpg', '2018-10-16 18:42:47', '2018-10-16 18:42:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3107', '1116', '2', 'eb0b9023b88269b9a01fd5a8b6ec6ce5.jpg', '2018-10-16 18:43:05', '2018-10-16 18:43:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3108', '1116', '2', '0349de08c85aaf627962c023589ad6e7.jpg', '2018-10-16 18:43:05', '2018-10-16 18:43:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3109', '1023', '2', '32c76bf885002514503c58d458b747f3.jpg', '2018-10-16 18:43:27', '2018-10-16 18:43:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3110', '1023', '3', 'd7eabe9b3ca830c0e9e1a502d78a7950.jpg', '2018-10-16 18:43:37', '2018-10-16 18:43:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3111', '1014', '2', '33f3370f58e3900b4c899323305b0379.jpg', '2018-10-16 18:44:59', '2018-10-16 18:44:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3112', '1014', '3', '0eb57a81797b6cce57247c5256947da9.jpg', '2018-10-16 18:45:09', '2018-10-16 18:45:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3113', '1116', '3', '9b606df549b365b457a0d3cf85dd192b.jpg', '2018-10-16 18:45:17', '2018-10-16 18:45:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3114', '1021', '2', 'f53cfc8fd040bbc2ea237e27f1645ef2.jpg', '2018-10-16 18:47:19', '2018-10-16 18:47:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3115', '1021', '2', '4891d6ccc25769e15d61090038165ba1.jpg', '2018-10-16 18:47:19', '2018-10-16 18:47:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3116', '1021', '2', '685629dc71f7f2a42cffb515e90033e9.jpg', '2018-10-16 18:47:19', '2018-10-16 18:47:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3117', '1021', '3', '990f2355a743102d0f695fa0b7d323f9.jpg', '2018-10-16 18:47:40', '2018-10-16 18:47:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3118', '1062', '2', '1a07dcb78255e84a8e2918a7a29469f8.jpg', '2018-10-16 18:49:23', '2018-10-16 18:49:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3119', '1062', '2', '991c9de85f73a82e71d82562bada0ea7.jpg', '2018-10-16 18:49:23', '2018-10-16 18:49:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3120', '1062', '3', 'beb2e6349ff29af5445d2e777ba76d21.jpg', '2018-10-16 18:49:48', '2018-10-16 18:49:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3121', '1031', '2', '2f778b6095c9798a2cf99e24ced2a903.jpg', '2018-10-16 18:51:31', '2018-10-16 18:51:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3122', '1115', '1', '49a3c0b488ac43e48a044ac11a16ab2c.jpg', '2018-10-16 18:51:35', '2018-10-16 18:51:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3123', '1115', '1', 'aa27c4e843563c95d64b13643a0679e9.jpg', '2018-10-16 18:51:35', '2018-10-16 18:51:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3124', '1115', '2', 'b9c9d5564f8b19ae2e51fc063c89070b.jpg', '2018-10-16 18:51:46', '2018-10-16 18:51:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3125', '1031', '3', 'bda20bc17f969b7b231fb8f3bbb134be.jpg', '2018-10-16 18:52:37', '2018-10-16 18:52:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3126', '1142', '1', '16d81d8015d4a196c45f5933fe307f37.jpg', '2018-10-17 09:48:15', '2018-10-17 09:48:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3127', '1142', '1', 'c7f422a33b4eda186420c7c90978edd2.jpg', '2018-10-17 09:48:15', '2018-10-17 09:48:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3128', '1142', '1', 'd65e00575a377e5def6c0c319e94eaa7.jpg', '2018-10-17 09:48:15', '2018-10-17 09:48:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3129', '1142', '2', '2e711662bce2475a9ad922bb92f90ebf.jpg', '2018-10-17 09:48:51', '2018-10-17 09:48:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3130', '1142', '2', '36b50ba458a5238682eac408c09eb80f.jpg', '2018-10-17 09:48:51', '2018-10-17 09:48:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3131', '1142', '2', '1cbcfd223f9154c92bdb430469d49a04.jpg', '2018-10-17 09:48:51', '2018-10-17 09:48:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3132', '1142', '2', 'eb93d2553298c4a2df4e093b64e80c88.jpg', '2018-10-17 09:48:51', '2018-10-17 09:48:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3133', '1142', '2', '786134f6978113315076629c1e6441fd.jpg', '2018-10-17 09:48:51', '2018-10-17 09:48:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3134', '1142', '3', '332b169701cccab48fea699ae4c29e32.jpg', '2018-10-17 09:50:34', '2018-10-17 09:50:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3135', '1115', '3', 'd6f721a4fdb9bdae953373fb0619d181.jpg', '2018-10-17 10:46:10', '2018-10-17 10:46:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3136', '1149', '1', 'a3773cdcfd455c9d2e319f207849231f.jpg', '2018-10-17 13:03:20', '2018-10-17 13:03:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3137', '1149', '2', 'b9ab99cf68d9f5ddc90bb3141662ccf0.jpg', '2018-10-17 13:03:39', '2018-10-17 13:03:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3138', '1149', '3', '75d35cd9b70588d281704fe2f44abfbd.jpg', '2018-10-17 13:03:54', '2018-10-17 13:03:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3139', '1118', '1', '4e97130ccddc9a74605e757a3c20da98.jpg', '2018-10-17 13:17:39', '2018-10-17 13:17:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3140', '1118', '2', '803d4db80f7f3055530fa138101f1af1.jpg', '2018-10-17 13:17:45', '2018-10-17 13:17:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3141', '1118', '3', '958c905edb252ef5193640563b889133.jpg', '2018-10-17 13:18:53', '2018-10-17 13:18:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3142', '1147', '1', '60f1138674402366954cb382e0969607.jpg', '2018-10-17 13:28:45', '2018-10-17 13:28:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3143', '1147', '2', 'f76ed44f6c4d99626ba968e7c9c2652a.jpg', '2018-10-17 13:29:31', '2018-10-17 13:29:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3144', '1147', '3', 'e44bb2dec07e95e6af377eac0ff9fb74.jpg', '2018-10-17 13:31:35', '2018-10-17 13:31:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3145', '1150', '1', '6a849115aaa6bb9e044cd6dde1cafe9b.jpg', '2018-10-17 14:24:12', '2018-10-17 14:24:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3146', '1150', '1', '4c5c47a2eee1655b48f1bf5285a3fba8.jpg', '2018-10-17 14:24:12', '2018-10-17 14:24:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3147', '1150', '2', '063b33b6963b3ad56f90105a61508e6e.jpg', '2018-10-17 14:25:23', '2018-10-17 14:25:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3148', '1150', '2', '92896817c6fc344ee8593f19caf71880.jpg', '2018-10-17 14:25:23', '2018-10-17 14:25:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3149', '1150', '2', '4ed0d657be6e699c94b3b08b51b44b69.jpg', '2018-10-17 14:25:23', '2018-10-17 14:25:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3150', '1150', '3', '8d15cc164a6c7d57b8607d74cf083977.jpg', '2018-10-17 14:26:38', '2018-10-17 14:26:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3151', '1151', '1', '534c65e31784c61510f5b142f2d603e1.jpg', '2018-10-17 15:07:46', '2018-10-17 15:07:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3152', '1151', '1', 'a9afd4fade8633e6e920a1f1442045c6.jpg', '2018-10-17 15:07:46', '2018-10-17 15:07:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3153', '1151', '1', 'e2adc85fa9958fdec54d35917c4fb69e.jpg', '2018-10-17 15:07:46', '2018-10-17 15:07:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3154', '1151', '1', '6c240409a7ed0f4b387477baea874df5.jpg', '2018-10-17 15:07:46', '2018-10-17 15:07:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3155', '1151', '1', 'cd95dfa387e796ceba912afbdd4ee1f3.jpg', '2018-10-17 15:07:46', '2018-10-17 15:07:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3156', '1151', '2', '7f4ad30864cbcc4107de99ee7d4f6711.jpg', '2018-10-17 15:09:15', '2018-10-17 15:09:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3157', '1151', '2', '5d53feb4fe6b9aef682ad228e073703f.jpg', '2018-10-17 15:09:15', '2018-10-17 15:09:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3158', '1151', '2', 'cf68567440dce4f4d683852fb43b4021.jpg', '2018-10-17 15:09:15', '2018-10-17 15:09:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3159', '1151', '2', '37fa257749c1ef0eb3f9d66efe7cb86f.jpg', '2018-10-17 15:09:15', '2018-10-17 15:09:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3160', '1151', '2', '12a35ed62a140738c67881c66170c4c9.jpg', '2018-10-17 15:09:15', '2018-10-17 15:09:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3161', '1151', '3', 'def59e11a70f392890c2cbf763f414ed.jpg', '2018-10-17 15:10:14', '2018-10-17 15:10:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3162', '1134', '1', 'f9769c4c5b0238c4b5e6a6bcef1cb6f8.jpg', '2018-10-18 12:46:03', '2018-10-18 12:46:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3163', '1134', '2', '498d981699632d78fec2857254777909.jpg', '2018-10-18 12:46:10', '2018-10-18 12:46:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3164', '1134', '3', 'cbfa6bbe5a4e2a3c9ec941808ea292d6.jpg', '2018-10-18 12:46:38', '2018-10-18 12:46:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3165', '1143', '2', '83d4d3b6ef0891d4396cbe0f1387edcd.jpg', '2018-10-19 18:09:15', '2018-10-19 18:09:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3166', '1143', '3', 'e8d56f9f0351d19dd64b02ae0f7f4471.jpg', '2018-10-19 18:11:43', '2018-10-19 18:11:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3167', '1191', '1', '24b2e56f59bad9950d75f3af21f3b667.jpg', '2018-10-23 10:07:29', '2018-10-23 10:07:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3168', '1191', '2', '677841ed32924172f0bec190ba576bd0.jpg', '2018-10-23 10:07:51', '2018-10-23 10:07:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3169', '1191', '2', 'a6f2c63c1d1994a494c36088c0812bfc.jpg', '2018-10-23 10:07:51', '2018-10-23 10:07:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3170', '1191', '3', '97dcb6a78c11d839f0f42b3634121ad2.jpg', '2018-10-23 10:38:30', '2018-10-23 10:38:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3171', '956', '2', 'c907ea83f8edb18608fd1f4b301ba799.jpg', '2018-10-23 13:40:14', '2018-10-23 13:40:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3172', '956', '2', '606e31ee088d7bdeef2c7471401f534f.jpg', '2018-10-23 13:40:14', '2018-10-23 13:40:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3173', '956', '2', 'bcf2131b3b7407d52057594428c5d0ea.jpg', '2018-10-23 13:40:14', '2018-10-23 13:40:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3174', '956', '3', '618ffe65e752425701bd9c26b32be17f.jpg', '2018-10-23 13:40:44', '2018-10-23 13:40:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3175', '1179', '1', 'f54bc958f4f775aec3483615a0e288d0.jpg', '2018-10-23 14:52:21', '2018-10-23 14:52:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3176', '1179', '2', '1b2de9dac7a0b04430a716bf7094e618.jpg', '2018-10-23 14:52:30', '2018-10-23 14:52:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3177', '1179', '3', '1cecea2a4e807458068f8a73badbe36f.jpg', '2018-10-23 14:59:14', '2018-10-23 14:59:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3178', '421', '2', '9b6b66411e2d00cf014c5519abfd9685.jpg', '2018-10-23 17:21:44', '2018-10-23 17:21:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3179', '421', '3', '4afdb4ab14f82c2b17598edd2ed291b8.jpg', '2018-10-23 17:21:53', '2018-10-23 17:21:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3180', '1108', '2', 'b3f6c0cbd3f27c9d7712bf5c66ccc5a6.jpg', '2018-10-23 17:26:06', '2018-10-23 17:26:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3181', '1108', '3', '35189cb41ccb55b5e903d67007bf538b.jpg', '2018-10-23 17:26:28', '2018-10-23 17:26:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3182', '960', '2', '7d867c745cd288473cef29f0d59c8c1f.jpg', '2018-10-23 17:40:55', '2018-10-23 17:40:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3183', '960', '3', '5c020169818a58c9bbd09c44cd58037a.jpg', '2018-10-23 17:41:45', '2018-10-23 17:41:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3184', '1002', '2', '25a039a513068f6074dd066bf892214b.jpg', '2018-10-23 17:42:49', '2018-10-23 17:42:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3185', '1002', '3', '2460cfa8c65f5e7bfcfdf93dd0be3afe.jpg', '2018-10-23 17:43:13', '2018-10-23 17:43:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3186', '738', '2', '3038318773880c30d62748bd20a44648.jpg', '2018-10-23 17:54:01', '2018-10-23 17:54:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3187', '738', '2', '80c8745a73dfd10ec3b1c09d5144ef8b.jpg', '2018-10-23 17:54:01', '2018-10-23 17:54:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3188', '738', '3', 'b74c0f416c22b5f220e201f4a66df60b.jpg', '2018-10-23 17:54:44', '2018-10-23 17:54:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3189', '1137', '2', '1b4910495bb6bdd185720e666948820c.jpg', '2018-10-23 18:02:23', '2018-10-23 18:02:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3190', '1137', '3', '44065ef748a875bebc602356cd0db4a3.jpg', '2018-10-23 18:03:28', '2018-10-23 18:03:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3191', '1141', '2', '66ac0ef6b00af0a10e25a4faf7962c66.jpg', '2018-10-23 18:05:21', '2018-10-23 18:05:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3192', '1141', '3', '154abdd068649e60d651ddb1e57318dd.jpg', '2018-10-23 18:05:37', '2018-10-23 18:05:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3193', '1138', '2', '166152a98eb2115a0243d830b4a46efb.jpg', '2018-10-23 19:22:31', '2018-10-23 19:22:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3194', '1138', '3', 'a656973c884f857399171f0fcb4e4945.jpg', '2018-10-23 19:23:04', '2018-10-23 19:23:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3195', '1136', '2', '9e3bda6239a337747f08e4abe2edafbb.jpg', '2018-10-23 19:25:21', '2018-10-23 19:25:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3196', '1136', '3', 'd07679f18d9c4999dff3f887f8ad4d9c.jpg', '2018-10-23 19:25:37', '2018-10-23 19:25:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3197', '1121', '2', '916b0e464dcdc0bec05c04c06d18eb66.jpg', '2018-10-23 19:26:30', '2018-10-23 19:26:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3198', '1121', '3', '8dd91b03a6d0552a56508c4e1c38b8f5.jpg', '2018-10-23 19:26:49', '2018-10-23 19:26:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3199', '788', '2', '76c7e55de0468c44ec91f8649d4ea907.jpg', '2018-10-23 19:53:09', '2018-10-23 19:53:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3200', '788', '3', 'a97a1ae61df312931bfd59ba0278b698.jpg', '2018-10-23 19:53:18', '2018-10-23 19:53:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3201', '782', '2', '04d95bf79c4fede556d9c1a8a58bdebf.jpg', '2018-10-23 20:06:15', '2018-10-23 20:06:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3202', '782', '3', '0e54b1fc40666c9802f428326af7d7d2.jpg', '2018-10-23 20:06:24', '2018-10-23 20:06:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3203', '787', '2', '8a39bbdd0f043258ce15ef60825cbabe.jpg', '2018-10-23 20:08:24', '2018-10-23 20:08:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3204', '787', '3', '60b53db1d3abba18d1ff28c6ba2e794a.jpg', '2018-10-23 20:08:38', '2018-10-23 20:08:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3205', '1059', '2', '215647fc05e98e3e54b8dfd31691d0fe.jpg', '2018-10-23 20:11:41', '2018-10-23 20:11:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3206', '1059', '3', 'f35f047b69d4cf4252a7ad3bf0030f30.jpg', '2018-10-23 20:12:16', '2018-10-23 20:12:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3207', '1057', '2', '1aeac1823339ecbfcb998c31ae7e54e6.jpg', '2018-10-23 20:13:16', '2018-10-23 20:13:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3208', '1057', '3', '0099b9c86a8f2dbead9d45f71152d856.jpg', '2018-10-23 20:13:32', '2018-10-23 20:13:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3209', '1103', '2', '7cd7a9696b8e0249a75c802b7cd3c084.jpg', '2018-10-23 20:14:21', '2018-10-23 20:14:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3210', '1103', '3', '37ed0aea751e1aeaff1c4a0443cd2090.jpg', '2018-10-23 20:14:37', '2018-10-23 20:14:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3211', '1103', '3', '9be8f31fc10127f4da07989eef0fcdde.jpg', '2018-10-23 20:14:39', '2018-10-23 20:14:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3212', '786', '2', 'a5b739b51fc6485b00f3404577371cbb.jpg', '2018-10-23 20:16:15', '2018-10-23 20:16:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3213', '786', '2', '743e8d61b3d50cd7e4b17ec229fac692.jpg', '2018-10-23 20:16:15', '2018-10-23 20:16:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3214', '786', '3', '7f85e6d4bac340ae84b8fc9344a47b8a.jpg', '2018-10-23 20:16:30', '2018-10-23 20:16:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3215', '1197', '2', 'e285c2d60438b43f12cf8f114182d66c.jpg', '2018-10-23 20:17:46', '2018-10-23 20:17:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3216', '1197', '3', 'e3c6222a3299becdba46f6b050a505ce.jpg', '2018-10-23 20:18:01', '2018-10-23 20:18:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3217', '1198', '2', '45b41a2aba4513e9fdf9582390336319.jpg', '2018-10-23 20:20:06', '2018-10-23 20:20:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3218', '1198', '3', '8922b3cc42e8efa5317b36e6b09ca865.jpg', '2018-10-23 20:20:21', '2018-10-23 20:20:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3219', '1093', '2', '83111c649e6153264eae8b991041db63.jpg', '2018-10-23 20:23:32', '2018-10-23 20:23:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3220', '1093', '3', '921b3be6daeb85960973fc5e19dc9e09.jpg', '2018-10-23 20:23:45', '2018-10-23 20:23:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3221', '1072', '2', 'cf141695dd8ab7bfadfd8fa84c12bbcd.jpg', '2018-10-24 00:03:30', '2018-10-24 00:03:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3222', '1072', '3', 'bdd6d1e4889ffd78b2de9c0a0b73f82b.jpg', '2018-10-24 00:03:54', '2018-10-24 00:03:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3223', '1074', '2', 'f3ae60cf1b44061181732e640742481f.jpg', '2018-10-24 00:05:04', '2018-10-24 00:05:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3224', '1074', '3', 'c324de714cc2f6f53df9b2affe093774.jpg', '2018-10-24 00:05:17', '2018-10-24 00:05:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3225', '640', '2', '3a20ab48229f7411f7cb25f3f17e440c.jpg', '2018-10-24 00:06:15', '2018-10-24 00:06:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3226', '640', '3', 'c6edc7e95bf15664fbe712cb3c32c751.jpg', '2018-10-24 00:06:31', '2018-10-24 00:06:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3227', '961', '2', '57d6e2e18af8c8655e418418d059311f.jpg', '2018-10-24 00:10:15', '2018-10-24 00:10:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3228', '961', '3', '5c3277e128216eeca848e17780b61d3a.jpg', '2018-10-24 00:10:24', '2018-10-24 00:10:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3229', '1051', '2', '5be873296aaf1fba323c3c40dc35d034.jpg', '2018-10-24 00:11:34', '2018-10-24 00:11:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3230', '1051', '3', '7c9ff27ff2dbb2a4f196095745975d0a.jpg', '2018-10-24 00:11:51', '2018-10-24 00:11:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3231', '1104', '2', 'c90c5c39ae37fde25fb7e031fab4595a.jpg', '2018-10-24 00:20:46', '2018-10-24 00:20:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3232', '1104', '2', '757d454a0f776b742852aba32e9b5999.jpg', '2018-10-24 00:20:46', '2018-10-24 00:20:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3233', '1104', '3', '7a7e4b7d68d883205eed5a5bd380cb94.jpg', '2018-10-24 00:21:03', '2018-10-24 00:21:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3234', '1111', '2', 'b39783bbc8024b44540150886c71c5cb.jpg', '2018-10-24 00:22:13', '2018-10-24 00:22:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3235', '1111', '2', '909c7730c6f2b50caa9f448e5ef9e6cd.jpg', '2018-10-24 00:22:13', '2018-10-24 00:22:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3236', '1111', '3', '3ec9f5a8308e94ae25aeba18ee2d28c5.jpg', '2018-10-24 00:22:34', '2018-10-24 00:22:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3237', '1063', '2', '96d3eb2084b846219f7e928b60fb8fcc.jpg', '2018-10-24 00:24:55', '2018-10-24 00:24:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3238', '1063', '3', '7effce0056869944ff6ed65634f49c44.jpg', '2018-10-24 00:25:03', '2018-10-24 00:25:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3239', '1047', '2', '8c3a9aeb20e7b1ecfe1a6b209276c532.jpg', '2018-10-24 00:33:38', '2018-10-24 00:33:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3240', '1047', '3', '1dde3e4bb5d94bf41f3b6067a20c5633.jpg', '2018-10-24 00:33:56', '2018-10-24 00:33:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3241', '1048', '2', '65e53616390a4dcc83e922420fea4495.jpg', '2018-10-24 00:35:01', '2018-10-24 00:35:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3242', '1048', '3', '76db0687522e721dd2a64feea92f861e.jpg', '2018-10-24 00:35:16', '2018-10-24 00:35:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3243', '492', '2', '7c778ffbe9c066808f881f62e01944d8.jpg', '2018-10-24 00:38:15', '2018-10-24 00:38:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3244', '492', '3', 'e5f8c7ad43c66ff5de9540d1825dc7f1.jpg', '2018-10-24 00:38:32', '2018-10-24 00:38:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3245', '943', '2', '7210db799f3b334447f52607de523af4.jpg', '2018-10-24 00:49:40', '2018-10-24 00:49:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3246', '943', '3', 'd01e5f636b2dd41f307f11737b968366.jpg', '2018-10-24 00:49:55', '2018-10-24 00:49:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3247', '1096', '2', 'a371eb4c6230d5183c346a9ae79479c3.jpg', '2018-10-24 00:53:57', '2018-10-24 00:53:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3248', '1096', '3', '81bf3f98ea632a43db346c6f3e6764dc.jpg', '2018-10-24 00:54:12', '2018-10-24 00:54:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3249', '1046', '2', 'ada76d6c0b78d10abaa67ec7501e0238.jpg', '2018-10-24 00:57:44', '2018-10-24 00:57:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3250', '1046', '3', '20e4c85f6b1049f4370fd14b661a8dfb.jpg', '2018-10-24 00:57:59', '2018-10-24 00:57:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3251', '978', '2', '1bf9e6caedf4f6ea797db7b26de38e4f.jpg', '2018-10-24 01:04:46', '2018-10-24 01:04:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3252', '978', '2', '471d4a82353390f961c0841f59ea4167.jpg', '2018-10-24 01:04:46', '2018-10-24 01:04:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3253', '978', '3', '45aa20b7a0e052cd19edd00c613ceb2c.jpg', '2018-10-24 01:05:09', '2018-10-24 01:05:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3254', '972', '2', '1608e604646a60ca23a8c983f2049aac.jpg', '2018-10-24 01:07:25', '2018-10-24 01:07:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3255', '972', '3', '147a14bc79e6ff71e33e009cf8b609b8.jpg', '2018-10-24 01:07:36', '2018-10-24 01:07:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3256', '722', '2', '5c18cbdce26835f4d02551664eefb7cb.jpg', '2018-10-24 01:11:59', '2018-10-24 01:11:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3257', '722', '3', 'a8024c989d1cd49d6d7f9e715e84d19c.jpg', '2018-10-24 01:12:16', '2018-10-24 01:12:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3258', '937', '2', 'de72f7bade3ee57215c252f19251cbc3.jpg', '2018-10-24 01:14:36', '2018-10-24 01:14:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3259', '937', '3', 'e26c4737bc35547e4830cc25db3d20de.jpg', '2018-10-24 01:14:45', '2018-10-24 01:14:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3260', '973', '2', 'f66876fe6c540c9f9ccaaa57a4db13fa.jpg', '2018-10-24 01:15:40', '2018-10-24 01:15:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3261', '973', '3', '8bffa76cd0b039c1e23a0e32e94c5550.jpg', '2018-10-24 01:15:55', '2018-10-24 01:15:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3262', '179', '2', 'fcca64fb990ab1c6ad164b49f75c99f2.jpg', '2018-10-24 01:18:30', '2018-10-24 01:18:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3263', '179', '3', 'dd40a4ab911aefefef926a718fe63164.jpg', '2018-10-24 01:18:38', '2018-10-24 01:18:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3264', '180', '2', 'f2a3c55cf266022be9abdf7158e17110.jpg', '2018-10-24 01:19:07', '2018-10-24 01:19:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3265', '180', '3', '7ea22dfc9fc99dced94a089815de6917.jpg', '2018-10-24 01:19:17', '2018-10-24 01:19:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3266', '987', '2', '50967547fd98d2c962c9f0fb22414c2c.jpg', '2018-10-24 01:22:07', '2018-10-24 01:22:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3267', '987', '3', '7cdbde2485b8310c944caea2a9b8a36c.jpg', '2018-10-24 01:22:41', '2018-10-24 01:22:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3268', '1064', '2', 'f86111dbb8d2bdeb9925b90aa18653ae.jpg', '2018-10-24 01:23:21', '2018-10-24 01:23:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3269', '1064', '3', 'c87e20e4bdb1a8e7ff103c1674fbd8a0.jpg', '2018-10-24 01:23:31', '2018-10-24 01:23:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3270', '1182', '1', '067c89718674a5edd0e03dda671ab91f.jpg', '2018-10-24 11:40:22', '2018-10-24 11:40:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3271', '1182', '2', '1c2fa7ae04bf629bfff65e0a98d14e1f.jpg', '2018-10-24 11:40:35', '2018-10-24 11:40:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3272', '1182', '3', '049fd87ccb5295e445d8ff2746384190.jpg', '2018-10-24 11:41:31', '2018-10-24 11:41:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3273', '1174', '1', 'e3af611cc4735eca149223621e2b049a.jpg', '2018-10-24 11:43:11', '2018-10-24 11:43:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3274', '1174', '2', 'e19a940ab6e4fdb9d46e7a26de3a288a.jpg', '2018-10-24 11:43:24', '2018-10-24 11:43:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3275', '1174', '3', 'a410d6e2ccad7d94225fa67b4f561226.jpg', '2018-10-24 11:43:58', '2018-10-24 11:43:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3276', '1173', '1', '81df70f700179653ab59828af63b4b20.jpg', '2018-10-24 11:44:55', '2018-10-24 11:44:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3277', '1173', '2', '2fdd56e69b617ad0092fb70d4e9b7f0d.jpg', '2018-10-24 11:45:03', '2018-10-24 11:45:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3278', '1173', '3', '90b3aa232d756b2d2a04215fa9363cf1.jpg', '2018-10-24 11:45:37', '2018-10-24 11:45:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3279', '1159', '1', 'cb2d79d3f4a1239574946ea83a33c97c.jpg', '2018-10-24 11:46:30', '2018-10-24 11:46:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3280', '1159', '2', '4dd031ab23a4dc8f987a87632e06c87b.jpg', '2018-10-24 11:46:41', '2018-10-24 11:46:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3281', '1159', '3', '83a4e8f878ef0a8e4fd96b40a8501578.jpg', '2018-10-24 11:47:14', '2018-10-24 11:47:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3282', '1205', '1', 'ba779ca774dc904efc044bf3f22d1f59.jpg', '2018-10-24 12:50:19', '2018-10-24 12:50:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3283', '1205', '2', 'e73650c957ae587569cbf7d6beaa1f61.jpg', '2018-10-24 12:50:27', '2018-10-24 12:50:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3284', '1205', '3', 'eebc991962d1eaddaa0dc7cadedb9f6e.jpg', '2018-10-24 12:51:21', '2018-10-24 12:51:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3285', '1189', '1', '7ad278b7850d60a17059ab4e6f4bbc64.jpg', '2018-10-24 16:37:27', '2018-10-24 16:37:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3286', '1189', '1', '2f8b0414dffbc229e1f1593ab34169cf.jpg', '2018-10-24 16:37:27', '2018-10-24 16:37:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3287', '1189', '1', 'b6a2936d6f7840e7f6bd7aa0ae8f1f53.jpg', '2018-10-24 16:37:27', '2018-10-24 16:37:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3288', '1189', '1', '57f0e6133d978c323b994ae5b0f969a7.jpg', '2018-10-24 16:37:27', '2018-10-24 16:37:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3289', '1189', '1', '0c546037f4b41b4c841688a1e766f9b1.jpg', '2018-10-24 16:37:27', '2018-10-24 16:37:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3290', '1189', '1', '474ddddebdb08c958c80e103d31b00c3.jpg', '2018-10-24 16:37:27', '2018-10-24 16:37:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3291', '1189', '2', 'f609526d5b7c9407d9d94d4c04da0b36.jpg', '2018-10-24 16:38:34', '2018-10-24 16:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3292', '1189', '2', '15f752fadc11939339f5e92ba5554f9d.jpg', '2018-10-24 16:38:34', '2018-10-24 16:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3293', '1189', '2', '9701a881c07ff45af45100c93a878c19.jpg', '2018-10-24 16:38:34', '2018-10-24 16:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3294', '1189', '2', '9b0a1ca2cc8c7f4d342f0de73994fce2.jpg', '2018-10-24 16:38:34', '2018-10-24 16:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3295', '1189', '2', 'e108b854c4f2c5480e0a27dabed0efab.jpg', '2018-10-24 16:38:34', '2018-10-24 16:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3296', '1189', '2', '7a64a38bf33bdeaf958a50c8f34dfc00.jpg', '2018-10-24 16:38:34', '2018-10-24 16:38:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3297', '1189', '3', '915321c5465201c747f1cec10ee50952.jpg', '2018-10-24 16:40:00', '2018-10-24 16:40:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3298', '1166', '1', '6677f616c306be15b7749a782bf0f6c2.jpg', '2018-10-24 17:02:32', '2018-10-24 17:02:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3299', '1166', '1', '8149c19bf563d5a744b346454944f079.jpg', '2018-10-24 17:02:32', '2018-10-24 17:02:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3300', '1166', '1', '63cc57423bd94c142ad1d862852126c3.jpg', '2018-10-24 17:02:32', '2018-10-24 17:02:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3301', '1166', '2', '60f24d7ef443f1c5c3e006211a58e8d7.jpg', '2018-10-24 17:02:54', '2018-10-24 17:02:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3302', '1166', '2', '0ecbb25698e8b82e87466f650261af24.jpg', '2018-10-24 17:02:54', '2018-10-24 17:02:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3303', '1166', '2', '2c87ba9f6d0d5caeacbf4fe4fdf86c80.jpg', '2018-10-24 17:02:54', '2018-10-24 17:02:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3304', '1166', '3', '4e994349cca97a09359130358f0d50c1.jpg', '2018-10-24 17:05:09', '2018-10-24 17:05:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3305', '1209', '1', 'b8115b59fd27d8f0e42aeb20618045c4.jpg', '2018-10-24 19:57:54', '2018-10-24 19:57:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3306', '1209', '2', '356451eb33297f092f0a2a3b2925ad84.jpg', '2018-10-24 19:58:11', '2018-10-24 19:58:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3307', '1209', '2', 'bec3bceea64bb38848feff69af804c7c.jpg', '2018-10-24 19:58:11', '2018-10-24 19:58:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3308', '1209', '2', '61ac8ef7507a91a67d43e5d2edc50fa1.jpg', '2018-10-24 19:58:11', '2018-10-24 19:58:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3309', '1209', '3', '4ff9f915ca65f47fcb65254eaaa9cde3.jpg', '2018-10-24 19:59:39', '2018-10-24 19:59:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3310', '1212', '2', 'd3acf77a694fd51279978e64f33db0b4.jpg', '2018-10-24 20:10:50', '2018-10-24 20:10:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3311', '1212', '3', '51e22cd57ea1672ab5dfba0ee7b04c19.jpg', '2018-10-24 20:11:47', '2018-10-24 20:11:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3312', '1207', '1', '619067f5413952477a9cff21f76febf7.jpg', '2018-10-26 12:17:21', '2018-10-26 12:17:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3313', '1207', '1', '3a47941c8f445510d9717fc41d6cd37b.jpg', '2018-10-26 12:17:21', '2018-10-26 12:17:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3314', '1207', '1', '4eb2b9701e7ed3674a6549d91686f76e.jpg', '2018-10-26 12:17:21', '2018-10-26 12:17:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3315', '1207', '1', 'a8686fbb0fb70a16b3b372fecf7fbec7.jpg', '2018-10-26 12:17:21', '2018-10-26 12:17:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3316', '1207', '2', '90995e75ee6028f764379def34e864d4.jpg', '2018-10-26 12:18:04', '2018-10-26 12:18:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3317', '1207', '2', '366b28b66250836b8e01151393942516.jpg', '2018-10-26 12:18:04', '2018-10-26 12:18:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3318', '1207', '2', '8463d1ad780a81e51147784b803f4da6.jpg', '2018-10-26 12:18:04', '2018-10-26 12:18:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3319', '1207', '2', 'de40be9c2035405026c0e37efb8808c6.jpg', '2018-10-26 12:18:04', '2018-10-26 12:18:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3320', '1207', '2', '2045d1601f156228bc101911113fcb1b.jpg', '2018-10-26 12:18:04', '2018-10-26 12:18:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3321', '1207', '2', '219681ebb9f08ff12cb0d6a8093b942e.jpg', '2018-10-26 12:18:04', '2018-10-26 12:18:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3322', '1207', '3', '4acdb2648385989e15cbfbcc85705f75.jpg', '2018-10-26 12:22:40', '2018-10-26 12:22:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3323', '1222', '1', '33a9d76d6830bed26733af47293da7b9.jpg', '2018-10-26 16:51:42', '2018-10-26 16:51:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3324', '1222', '2', '44b1aa60e968418c69378828f91ea920.jpg', '2018-10-26 16:51:55', '2018-10-26 16:51:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3325', '1222', '3', '7cdd26d178fc3a73be3cd9ca8747bd55.jpg', '2018-10-26 16:53:20', '2018-10-26 16:53:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3326', '1181', '1', 'c827cdb3a64aad6eccc176c125214838.jpg', '2018-10-26 16:56:24', '2018-10-26 16:56:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3327', '1181', '2', '34c1d490c2a42f22e170bf417b7441c5.jpg', '2018-10-26 16:56:36', '2018-10-26 16:56:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3328', '1181', '3', '2be8c9470404ea14d33d5a23a785b62a.jpg', '2018-10-26 16:58:07', '2018-10-26 16:58:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3329', '1133', '1', '8a9ef5e005cae64f1eac4ca069bc1b23.jpg', '2018-10-27 12:19:35', '2018-10-27 12:19:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3330', '1133', '2', 'b89c90ff8e2258761d2897b63cabeff5.jpg', '2018-10-27 12:19:50', '2018-10-27 12:19:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3331', '1133', '3', '42bee1cca3755040dd72fc56facc7ab0.jpg', '2018-10-27 12:20:29', '2018-10-27 12:20:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3332', '1124', '1', 'fe1dc4627ff5e8fd86679dbfec1f2f9b.jpg', '2018-10-29 09:55:11', '2018-10-29 09:55:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3333', '1124', '1', '5e4dd1343332add670646531d04a67ed.jpg', '2018-10-29 09:55:11', '2018-10-29 09:55:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3334', '1124', '2', '409e341331e33ff38a90e213eef39b26.jpg', '2018-10-29 09:55:44', '2018-10-29 09:55:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3335', '1124', '3', 'e32c6970442810d259f57ff0ff48dc4c.jpg', '2018-10-29 09:57:10', '2018-10-29 09:57:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3336', '1231', '1', 'e2fbe5da584288f2ede963666e7b2838.jpg', '2018-10-29 16:43:31', '2018-10-29 16:43:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3337', '1231', '2', 'ee640f0b980c9ff4b61eca62c5d720a8.jpg', '2018-10-29 16:43:58', '2018-10-29 16:43:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3338', '1231', '3', '37b724051c3ac42a6760810923240498.jpg', '2018-10-29 16:44:23', '2018-10-29 16:44:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3339', '1215', '1', 'aa0c737a245bde6d5e0ea8108e96cd9e.jpg', '2018-10-29 17:06:09', '2018-10-29 17:06:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3340', '1215', '2', '479ede74955fda3fe69d69a6d434bdff.jpg', '2018-10-29 17:06:19', '2018-10-29 17:06:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3341', '1215', '2', 'aae54b86b70dac25d4c332259955540c.jpg', '2018-10-29 17:06:19', '2018-10-29 17:06:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3342', '1215', '3', 'b0e01d50364cef52e6f7630d7ea40ec5.jpg', '2018-10-29 17:07:36', '2018-10-29 17:07:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3343', '1242', '1', 'ed626b36732d2a7ebb30ceafc3a46a3a.jpg', '2018-10-30 14:37:20', '2018-10-30 14:37:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3344', '1242', '2', 'f1655c36b4e0c408c50a43d0ec6e4b04.jpg', '2018-10-30 14:37:36', '2018-10-30 14:37:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3345', '1242', '3', 'fd17c8d786e63ce39c21cd24727839ee.jpg', '2018-10-30 14:37:56', '2018-10-30 14:37:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3346', '1248', '1', '73b50938625ae5c84d0e397df4d266f5.jpg', '2018-10-30 20:39:06', '2018-10-30 20:39:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3347', '1248', '2', '800443c14ab790bf9f7920afc8bb59fb.jpg', '2018-10-30 20:39:40', '2018-10-30 20:39:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3348', '1248', '3', 'dfe88234d51867a37df1e610c4db134a.jpg', '2018-10-30 20:40:22', '2018-10-30 20:40:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3349', '1249', '1', '31d2457edb1cc2cdb2e7130d5f08f157.jpg', '2018-10-30 21:16:36', '2018-10-30 21:16:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3350', '1249', '2', 'b0b816c72416e606c7a88bb1b7bd39ea.jpg', '2018-10-30 21:16:57', '2018-10-30 21:16:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3351', '1249', '3', '12fe20d558924043f16534fc8f66c2bc.jpg', '2018-10-30 21:17:18', '2018-10-30 21:17:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3352', '1208', '1', '519ad2ccde82665c87bc191c026c9778.jpg', '2018-11-01 11:53:38', '2018-11-01 11:53:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3353', '1208', '1', '78dd6101aaf2869387894fc2370349ab.jpg', '2018-11-01 11:53:38', '2018-11-01 11:53:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3354', '1208', '1', '2f10edfa669c9ae54cba68acbc162842.jpg', '2018-11-01 11:53:38', '2018-11-01 11:53:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3355', '1208', '1', '74487c054838373cb61e1dbab1b335ed.jpg', '2018-11-01 11:53:38', '2018-11-01 11:53:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3356', '1208', '2', '0891ba90fd339182b111df044151716a.jpg', '2018-11-01 11:54:19', '2018-11-01 11:54:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3357', '1208', '2', '8a3349365f45833421efb6c72466ac4d.jpg', '2018-11-01 11:54:19', '2018-11-01 11:54:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3358', '1208', '2', '34052a6477795e066f262a5b1cc04424.jpg', '2018-11-01 11:54:19', '2018-11-01 11:54:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3359', '1208', '2', '64f97e1bc72dbe02021b2c9a9bc54c61.jpg', '2018-11-01 11:54:19', '2018-11-01 11:54:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3360', '1208', '3', '19b5906c348057836d8cae6fc85e64e2.jpg', '2018-11-01 11:55:45', '2018-11-01 11:55:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3361', '1237', '1', '0390389aaae0bf37d9da8184f44e5058.jpg', '2018-11-01 14:23:29', '2018-11-01 14:23:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3362', '1237', '2', 'a7d3d86be1072810362913672ac5bccb.jpg', '2018-11-01 14:27:43', '2018-11-01 14:27:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3363', '1237', '3', 'dc9accd51b3d9c8f1f21ceda53dbd501.jpg', '2018-11-01 14:28:10', '2018-11-01 14:28:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3364', '1223', '1', 'bfb9f21158cbbea24b0538d7338bbb84.jpg', '2018-11-01 14:31:37', '2018-11-01 14:31:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3365', '1223', '2', '67f0d36ecf98f21d704a3da32b70e6a2.jpg', '2018-11-01 14:32:00', '2018-11-01 14:32:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3366', '1223', '3', '9f16c53223d0a699b73d0d8eaff3bd90.jpg', '2018-11-01 14:32:53', '2018-11-01 14:32:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3367', '1278', '1', '64b8bb8d6694f5a7cf353b0709abe5c5.jpg', '2018-11-02 10:59:39', '2018-11-02 10:59:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3368', '1278', '2', 'e8a1e2a721379aa9091b5ca5ba3afe79.jpg', '2018-11-02 10:59:55', '2018-11-02 10:59:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3369', '1278', '3', 'e9e66171b4cbd5d26795663dbac101af.jpg', '2018-11-02 11:01:32', '2018-11-02 11:01:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3370', '1263', '1', '3dc766e8c8593c08a738db4e9c76dcb3.jpg', '2018-11-02 11:03:06', '2018-11-02 11:03:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3371', '1263', '2', '8467d98333a1111708847ff70d757341.jpg', '2018-11-02 11:03:16', '2018-11-02 11:03:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3372', '1263', '3', '7ef8fd6885bb408f0c6572820daa927a.jpg', '2018-11-02 11:03:52', '2018-11-02 11:03:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3373', '1206', '2', 'dc1e8eaf8b1aa53ce2ae7760394bea05.jpg', '2018-11-02 14:17:59', '2018-11-02 14:17:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3374', '1206', '3', '7ab68e1fde8f3dd38c1896260d26d04f.jpg', '2018-11-02 14:18:33', '2018-11-02 14:18:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3375', '1265', '1', '1090db8dffe1f14ea3dc47814005648f.jpg', '2018-11-03 11:36:35', '2018-11-03 11:36:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3376', '1265', '2', 'd748dbc8d42d83927ab9302fe57deb34.jpg', '2018-11-03 11:37:26', '2018-11-03 11:37:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3377', '1265', '3', '1a3515816a68d67a026b54c90da571d1.jpg', '2018-11-03 11:38:28', '2018-11-03 11:38:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3378', '1236', '1', 'c64fb027063d76515cff8edf59f73d8f.jpg', '2018-11-03 11:44:57', '2018-11-03 11:44:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3379', '1236', '2', 'f74c4c4f16fac10f7848a5e348e6214a.jpg', '2018-11-03 11:45:56', '2018-11-03 11:45:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3380', '1236', '2', 'd068173dd62b05c4d537d896cdcef680.jpg', '2018-11-03 11:45:56', '2018-11-03 11:45:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3381', '1236', '3', 'bf3dedede3cdc2d0a56b71bb444423f1.jpg', '2018-11-03 11:47:12', '2018-11-03 11:47:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3382', '1193', '1', '694970eaac87d67a06d7cdb26bbb6f79.jpg', '2018-11-03 11:49:15', '2018-11-03 11:49:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3383', '1193', '2', '4d0e8e00d7c90aa41c77a980d2ab2699.jpg', '2018-11-03 11:49:49', '2018-11-03 11:49:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3384', '1193', '3', '6daad0cf631f7e2d15e2d3f9359fa5b7.jpg', '2018-11-03 11:52:46', '2018-11-03 11:52:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3385', '1233', '1', '682614c8e4b50070061f284d64824c35.jpg', '2018-11-05 09:36:45', '2018-11-05 09:36:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3386', '1233', '1', '4b271893885acb136de4242a6b52664b.jpg', '2018-11-05 09:36:45', '2018-11-05 09:36:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3387', '1233', '2', '8ca9112bcea6bd89e3dd9696ec337399.jpg', '2018-11-05 09:37:17', '2018-11-05 09:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3388', '1233', '2', '027266a324acc963b0839f01d81b055c.jpg', '2018-11-05 09:37:17', '2018-11-05 09:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3389', '1233', '2', 'ca69b7857b5bc4c773e518e0ce0809f9.jpg', '2018-11-05 09:37:17', '2018-11-05 09:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3390', '1233', '2', '1baeabc781acba216347aa4c08c152e3.jpg', '2018-11-05 09:37:17', '2018-11-05 09:37:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3391', '1233', '3', '3d7b873a49d57a5e9cc49631eb522f3e.jpg', '2018-11-05 09:38:31', '2018-11-05 09:38:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3392', '1255', '1', '25fcc19554643fdd79b0015f61b136a1.jpg', '2018-11-05 09:46:05', '2018-11-05 09:46:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3393', '1255', '1', '3bfb1dc2c699daa28eaeeb08eadb122c.jpg', '2018-11-05 09:46:05', '2018-11-05 09:46:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3394', '1255', '1', '0e0ca34a5ef28835270cca95c4fbce92.jpg', '2018-11-05 09:46:05', '2018-11-05 09:46:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3395', '1255', '2', 'd8aa1465a0e874a208f1176f3d13b104.jpg', '2018-11-05 09:46:30', '2018-11-05 09:46:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3396', '1255', '2', '19cd83dc2771fb7c6d755205d254a7f8.jpg', '2018-11-05 09:46:30', '2018-11-05 09:46:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3397', '1255', '2', 'ac7a54ba9976cf850dab8b72c751e861.jpg', '2018-11-05 09:46:30', '2018-11-05 09:46:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3398', '1255', '2', 'e64f15d9f8c3a12385af4802d7224a70.jpg', '2018-11-05 09:46:30', '2018-11-05 09:46:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3399', '1255', '3', 'c758cb91e6383e80e7588e78041596b3.jpg', '2018-11-05 09:48:34', '2018-11-05 09:48:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3400', '1256', '1', 'd8c77691801b1d18405daabc95bdf325.jpg', '2018-11-05 10:18:45', '2018-11-05 10:18:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3401', '1256', '1', '648e53c9a4a308ab60cbe6ac8a435e78.jpg', '2018-11-05 10:18:45', '2018-11-05 10:18:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3402', '1256', '1', '430badbbcecdcb8dce33659c7451847a.jpg', '2018-11-05 10:18:45', '2018-11-05 10:18:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3403', '1256', '2', '2c48f7d2a012ac27741d5da564b3dd3c.jpg', '2018-11-05 10:19:12', '2018-11-05 10:19:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3404', '1256', '2', '413340663673bb1d0b3b0cc032b921db.jpg', '2018-11-05 10:19:12', '2018-11-05 10:19:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3405', '1256', '2', '88c8b9e7751d068bad9a676fd0b05565.jpg', '2018-11-05 10:19:12', '2018-11-05 10:19:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3406', '1256', '2', '629bef40c22699161e9c5f0f809de0ee.jpg', '2018-11-05 10:19:12', '2018-11-05 10:19:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3407', '1256', '2', '488407d512ddae0b643d8f9960bdbaeb.jpg', '2018-11-05 10:19:12', '2018-11-05 10:19:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3408', '1256', '3', 'c2370416f5c133a9c45d95b61c71878e.jpg', '2018-11-05 10:19:48', '2018-11-05 10:19:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3409', '1254', '1', '20200b586499ab32c1ba5cd5e952056d.jpg', '2018-11-05 11:31:13', '2018-11-05 11:31:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3410', '1254', '1', 'd5d0b6b80acc359d953fe79651972168.jpg', '2018-11-05 11:31:13', '2018-11-05 11:31:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3411', '1254', '1', 'b6e3dc38a0f7994b6341b29466390bc6.jpg', '2018-11-05 11:31:13', '2018-11-05 11:31:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3412', '1254', '1', '16907e4612a70aa0f118a4a02438221e.jpg', '2018-11-05 11:31:13', '2018-11-05 11:31:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3413', '1254', '2', '1c4692d03fda38c42562caea9aa6db72.jpg', '2018-11-05 11:31:55', '2018-11-05 11:31:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3414', '1254', '2', 'ee1b3311c95f01b8f17c3686fbab0c7e.jpg', '2018-11-05 11:31:55', '2018-11-05 11:31:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3415', '1254', '2', '409a7be2570fd052e12c2da55df692ca.jpg', '2018-11-05 11:31:55', '2018-11-05 11:31:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3416', '1254', '2', '4492804d2cb9c3fc7453d400c48ddf77.jpg', '2018-11-05 11:31:55', '2018-11-05 11:31:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3417', '1254', '2', '6cbcd91c5d02133074cdccbea6858e29.jpg', '2018-11-05 11:31:55', '2018-11-05 11:31:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3418', '1254', '3', 'adf97e5d69f3c9b9b76d092e1d852d41.jpg', '2018-11-05 11:32:35', '2018-11-05 11:32:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3419', '1266', '1', '89cf1faf81b5eb8147c65e7318203cea.jpg', '2018-11-06 12:30:38', '2018-11-06 12:30:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3420', '1266', '2', '8f73fb368e58633caa96be1e5e02d683.jpg', '2018-11-06 12:30:59', '2018-11-06 12:30:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3421', '1282', '1', 'c659632791230bfb350747a79c107342.jpg', '2018-11-06 12:34:37', '2018-11-06 12:34:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3422', '1282', '2', 'ac637d28a94789abd4660c6361ecdcf8.jpg', '2018-11-06 12:34:51', '2018-11-06 12:34:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3423', '1282', '3', 'd46409e08071d5776b0ba9038dfc0d80.jpg', '2018-11-06 12:35:30', '2018-11-06 12:35:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3424', '1281', '1', '3b17938bb0c125093a82be0b187b5810.jpg', '2018-11-06 12:36:41', '2018-11-06 12:36:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3425', '1281', '2', 'ad01f2158bd9a48b92b8e155077deee1.jpg', '2018-11-06 12:36:54', '2018-11-06 12:36:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3426', '1281', '3', 'a1538d3273d77447cff751e3831ef967.jpg', '2018-11-06 12:37:30', '2018-11-06 12:37:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3427', '1269', '1', 'e89a71e5e93f8fbe174665de08de086d.jpg', '2018-11-06 12:42:17', '2018-11-06 12:42:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3428', '1269', '2', '7d6adc48503fe0628f7acc963b21f7d2.jpg', '2018-11-06 12:42:39', '2018-11-06 12:42:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3429', '1269', '3', '9f3fffd3dc15bffed314b5adfcffa409.jpg', '2018-11-06 12:43:28', '2018-11-06 12:43:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3430', '1201', '1', '90107ff537b041e600db8bd3b205ccfb.jpg', '2018-11-06 12:44:27', '2018-11-06 12:44:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3431', '1201', '2', 'c5a016aaf716852003c15d3ac0b5ae55.jpg', '2018-11-06 12:45:03', '2018-11-06 12:45:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3432', '1201', '2', '101deebc5baf01bb24429ce29f3d70f2.jpg', '2018-11-06 12:45:03', '2018-11-06 12:45:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3433', '1201', '2', 'a9706e8a5a81b86f7100ce61198e7594.jpg', '2018-11-06 12:45:03', '2018-11-06 12:45:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3434', '1201', '2', '90d8be5ed36dc78bb3ae691a539fbefe.jpg', '2018-11-06 12:45:03', '2018-11-06 12:45:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3435', '1201', '2', 'b15ffc4dddeffc0d273cecba66a7e113.jpg', '2018-11-06 12:45:03', '2018-11-06 12:45:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3436', '1201', '3', 'c62bf21a878532c8bd73c2eb801ff93a.jpg', '2018-11-06 12:47:54', '2018-11-06 12:47:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3437', '1196', '1', '8b67c3ce80f7f327cb075ea98a975e97.jpg', '2018-11-06 14:30:46', '2018-11-06 14:30:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3438', '1196', '2', 'b904ba20588dc931a790596d811f497f.jpg', '2018-11-06 14:31:44', '2018-11-06 14:31:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3439', '1196', '2', '0288667de207463dee10facb73dd38b0.jpg', '2018-11-06 14:31:44', '2018-11-06 14:31:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3440', '1196', '2', '789c885051172b677e41f35682dee3b5.jpg', '2018-11-06 14:31:44', '2018-11-06 14:31:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3441', '1196', '2', 'cccef2b9e8f076a44239b573ca57dc1e.jpg', '2018-11-06 14:31:44', '2018-11-06 14:31:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3442', '1196', '3', '11d17b546adf82c92719ed15f1738d20.jpg', '2018-11-06 14:32:20', '2018-11-06 14:32:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3443', '1252', '1', 'ee69783fcde76dbdb41ccd2f2b55bdc6.jpg', '2018-11-06 14:33:18', '2018-11-06 14:33:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3444', '1252', '1', '2f1f0adb10038453954c9494c07d9a24.jpg', '2018-11-06 14:33:18', '2018-11-06 14:33:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3445', '1252', '2', '40da47bd3d9344f8ba67cd5670ebbfc7.jpg', '2018-11-06 14:33:36', '2018-11-06 14:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3446', '1252', '2', '48099983b0e052d1cdcb35d5112a7524.jpg', '2018-11-06 14:33:36', '2018-11-06 14:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3447', '1252', '2', 'c66d1f975e211f1a320cabc8425bcba6.jpg', '2018-11-06 14:33:36', '2018-11-06 14:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3448', '1252', '2', 'a8038b7fd615a4f7640bbe236e335b08.jpg', '2018-11-06 14:33:36', '2018-11-06 14:33:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3449', '1252', '3', '77609cdab2613f5812b16cf6f3ec4ce2.jpg', '2018-11-06 14:34:01', '2018-11-06 14:34:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3450', '1246', '1', '684c743d792465a3ef1de2818c774108.jpg', '2018-11-06 15:59:59', '2018-11-06 15:59:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3451', '1246', '2', 'c56b17219e80abc8ffe869008df19ccf.jpg', '2018-11-06 16:00:26', '2018-11-06 16:00:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3452', '1246', '3', '520b211e39432f64f7faaaa5c9d9a6dc.jpg', '2018-11-06 16:01:02', '2018-11-06 16:01:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3453', '1308', '1', '41b1bbbb1966dac23603a3e47fbb3fc5.jpg', '2018-11-06 18:44:24', '2018-11-06 18:44:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3454', '1308', '2', '09c3dcfb40d4be04760fe192efa2df40.jpg', '2018-11-06 18:44:44', '2018-11-06 18:44:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3455', '1308', '3', 'b498bdc84d3c9a01e68aad4306caceb6.jpg', '2018-11-06 18:45:40', '2018-11-06 18:45:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3456', '1292', '1', 'cf219847bc6ecb30dd2427dc1fdfcee5.jpg', '2018-11-07 09:56:30', '2018-11-07 09:56:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3457', '1292', '1', 'cbf335940deddb872d88cd00fc65a57e.jpg', '2018-11-07 09:56:30', '2018-11-07 09:56:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3458', '1292', '1', '4a8f895cd59defd174adc508b2bfd0d9.jpg', '2018-11-07 09:56:30', '2018-11-07 09:56:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3459', '1292', '2', '0d5a6a0663f5ff0d43b03e51d7b724f1.jpg', '2018-11-07 09:56:55', '2018-11-07 09:56:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3460', '1292', '2', '84625720aaec6629e99eea52683ae539.jpg', '2018-11-07 09:56:55', '2018-11-07 09:56:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3461', '1292', '2', '440b773b8b417f661d01ba23dbf48fcd.jpg', '2018-11-07 09:56:55', '2018-11-07 09:56:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3462', '1292', '3', '129cfa83f8d7954961f55869c10e8aa7.jpg', '2018-11-07 10:00:45', '2018-11-07 10:00:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3463', '1101', '1', '6e85c92ee22a0003f60ff253b831f58a.jpg', '2018-11-07 10:22:45', '2018-11-07 10:22:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3464', '1101', '1', '282cd0e2c5e2f3f0d2f0897809731668.jpg', '2018-11-07 10:22:45', '2018-11-07 10:22:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3465', '1101', '2', '218d8ca5de38ee5f794c6de678b77417.jpg', '2018-11-07 10:28:50', '2018-11-07 10:28:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3466', '1101', '3', 'd6287ad9bdeaa7fa165fa0f73d72d119.jpg', '2018-11-07 10:31:23', '2018-11-07 10:31:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3467', '1262', '1', 'b185e80d0cfb38fc83c80eb349a8f7b7.jpg', '2018-11-07 11:04:04', '2018-11-07 11:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3468', '1262', '1', '11198fb6c791d33bca3da7ecc2c8fe38.jpg', '2018-11-07 11:04:04', '2018-11-07 11:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3469', '1262', '1', 'df8eef6aa581cfdccf920aa1747611d6.jpg', '2018-11-07 11:04:04', '2018-11-07 11:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3470', '1262', '1', '0e665071e5276c8a9d365269f67b35dc.jpg', '2018-11-07 11:04:04', '2018-11-07 11:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3471', '1262', '1', 'e4b49a295a503d1a44f942ca9e81ee52.jpg', '2018-11-07 11:04:04', '2018-11-07 11:04:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3472', '1262', '2', 'a7c865b5aa44ffbb5176ab6120d79d86.jpg', '2018-11-07 11:04:21', '2018-11-07 11:04:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3473', '1262', '3', 'a0ac579f2cec9662830dcba21f649bc3.jpg', '2018-11-07 11:05:17', '2018-11-07 11:05:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3474', '1358', '1', 'cc352fbf007b81bba99c008ae25e3044.jpg', '2018-11-08 09:58:30', '2018-11-08 09:58:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3475', '1358', '2', 'c9ecf77824a648cae252765245aa9ec2.jpg', '2018-11-08 09:59:04', '2018-11-08 09:59:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3476', '1358', '2', '69c0d60265276025f00273a15f451aad.jpg', '2018-11-08 09:59:04', '2018-11-08 09:59:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3477', '1358', '2', 'ec727952e0ff7bfaf3933e47fdb61fea.jpg', '2018-11-08 09:59:04', '2018-11-08 09:59:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3478', '1358', '2', '3d8ac3517bb158ff6167ab8fbb5b5b91.jpg', '2018-11-08 09:59:04', '2018-11-08 09:59:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3479', '1358', '3', '74a853a9a1a4e623cc933966a15e6d45.jpg', '2018-11-08 10:00:31', '2018-11-08 10:00:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3480', '959', '2', '62a4f48b0952538ae8afb6d117b98477.jpg', '2018-11-08 13:48:04', '2018-11-08 13:48:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3481', '959', '3', 'ee27cb771790a1cf98c7c7d7b8a2010b.jpg', '2018-11-08 13:48:38', '2018-11-08 13:48:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3482', '983', '2', 'a33ebedcdcb8269dec63d8a7e90697c3.jpg', '2018-11-08 13:51:48', '2018-11-08 13:51:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3483', '983', '3', '31e9b0f662d383ec955babf63ea71956.jpg', '2018-11-08 13:52:09', '2018-11-08 13:52:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3484', '864', '2', '468c917f1cffda2ef37e6bb570dadd88.jpg', '2018-11-08 13:59:02', '2018-11-08 13:59:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3485', '864', '3', '443ff21a0120d5f7a3a2cbe76c6f3e2e.jpg', '2018-11-08 13:59:27', '2018-11-08 13:59:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3486', '1100', '2', 'd0cb9d0f8acbdee7e527940be66e2482.jpg', '2018-11-08 14:14:40', '2018-11-08 14:14:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3487', '1100', '3', 'e6b9f952352846a92e56aa2ffc8ad2b2.jpg', '2018-11-08 14:15:28', '2018-11-08 14:15:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3488', '1183', '2', 'f9180a255140d00f6e4dcc9905540937.jpg', '2018-11-08 14:16:45', '2018-11-08 14:16:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3489', '1183', '3', 'c1d44e405724ab9335c0bf775eb90fd9.jpg', '2018-11-08 14:17:22', '2018-11-08 14:17:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3490', '1229', '1', 'bd3ab78c4ef3af9ab3791cbd6f2a276a.jpg', '2018-11-08 14:22:07', '2018-11-08 14:22:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3491', '1229', '2', 'b0ea0e46a2af8b8b1b2ec648ef042ee4.jpg', '2018-11-08 14:22:21', '2018-11-08 14:22:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3492', '1229', '3', '3f32bb053115f90d1c97f10f53a64d94.jpg', '2018-11-08 14:22:42', '2018-11-08 14:22:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3493', '1294', '1', '66f774ef91b0d1f087e720fa8ff65199.jpg', '2018-11-08 16:53:45', '2018-11-08 16:53:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3494', '1294', '1', '9797ae74af213b6cc4a3f747cb62a0d9.jpg', '2018-11-08 16:53:45', '2018-11-08 16:53:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3495', '1294', '1', '16faea52d2446b119ceb76f8bb986b2e.jpg', '2018-11-08 16:53:45', '2018-11-08 16:53:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3496', '1294', '1', '20b1d4fa1cf5aca8a209cc41cea63ae1.jpg', '2018-11-08 16:53:45', '2018-11-08 16:53:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3497', '1294', '1', 'b6d855410bb39a27a73bfdc152981b70.jpg', '2018-11-08 16:53:45', '2018-11-08 16:53:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3498', '1294', '1', '6d61eea5028fb80946c5e375414883d9.jpg', '2018-11-08 16:53:45', '2018-11-08 16:53:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3499', '1294', '2', 'abf0801bb7867eccb8be380c88c2a2ca.jpg', '2018-11-08 16:54:11', '2018-11-08 16:54:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3500', '1294', '2', 'b8a36c27e1abc8ca01b84d6c37bc9783.jpg', '2018-11-08 16:54:11', '2018-11-08 16:54:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3501', '1294', '2', '8a7d7cb1215ea7353707562a84a616f0.jpg', '2018-11-08 16:54:11', '2018-11-08 16:54:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3502', '1294', '3', '50c27526087d5e75bb563f0471370013.jpg', '2018-11-08 16:55:48', '2018-11-08 16:55:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3503', '1365', '1', '2ba0e3c367c504235a7e102327331bc8.jpg', '2018-11-09 11:09:31', '2018-11-09 11:09:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3504', '1365', '1', '956437453a1869310a57d953286a0a06.jpg', '2018-11-09 11:09:31', '2018-11-09 11:09:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3505', '1365', '2', '585dfe97b5baea35b9ead77443e11aef.jpg', '2018-11-09 11:09:56', '2018-11-09 11:09:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3506', '1365', '2', '15717b63b52f626e16c2c4e926d2a577.jpg', '2018-11-09 11:09:56', '2018-11-09 11:09:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3507', '1365', '2', '659ad3685dd5273056f759faf86d3f45.jpg', '2018-11-09 11:09:56', '2018-11-09 11:09:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3508', '1365', '3', '2f9075a01f110c547dd9752782a22765.jpg', '2018-11-09 11:12:52', '2018-11-09 11:12:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3509', '1354', '1', '8f2a892d967085158b2dbc88647986d2.jpg', '2018-11-09 11:43:35', '2018-11-09 11:43:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3510', '1354', '1', 'c30defc3e6e8b97bba5d0ee384573633.jpg', '2018-11-09 11:43:35', '2018-11-09 11:43:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3511', '1354', '1', '19dd915f269426a5417c8453dbc2207e.jpg', '2018-11-09 11:43:35', '2018-11-09 11:43:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3512', '1354', '2', 'a20d26c4bd4e84be2be11aa59c4398c4.jpg', '2018-11-09 11:43:57', '2018-11-09 11:43:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3513', '1354', '2', '52dabf907f881d715b99f7c48924748d.jpg', '2018-11-09 11:43:57', '2018-11-09 11:43:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3514', '1354', '2', 'd10a99ca59703be72aa8727e16f2ea33.jpg', '2018-11-09 11:43:57', '2018-11-09 11:43:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3515', '1354', '2', '3d5c2a4077e0d0f59e4f188a1f3b6e4f.jpg', '2018-11-09 11:43:57', '2018-11-09 11:43:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3516', '1354', '3', 'cf848d11219e3837dc1541061dbd4ea8.jpg', '2018-11-09 11:45:58', '2018-11-09 11:45:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3517', '1353', '1', '1fd7f59b0deafc2055a22da326b805d1.jpg', '2018-11-09 12:15:34', '2018-11-09 12:15:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3518', '1353', '1', '329e20c5904ff40f93c5ee6efa317b05.jpg', '2018-11-09 12:15:34', '2018-11-09 12:15:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3519', '1353', '2', '6fb1923212121054a715da629adb209c.jpg', '2018-11-09 12:15:58', '2018-11-09 12:15:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3520', '1353', '2', '39ba9a337d2e1c075e22b38f38add0f4.jpg', '2018-11-09 12:15:58', '2018-11-09 12:15:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3521', '1353', '2', 'dd26c52fae91ec38a188ed5029e8db87.jpg', '2018-11-09 12:15:58', '2018-11-09 12:15:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3522', '1353', '3', 'a1ffb93a4f25751508bbf57e61a0bed9.jpg', '2018-11-09 12:17:22', '2018-11-09 12:17:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3523', '1080', '1', '544f9bb05bb8b188eb451d04e7f9b56f.jpg', '2018-11-09 12:18:05', '2018-11-09 12:18:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3524', '1080', '1', 'e298475838e4f4e7d2f71cd04274d0db.jpg', '2018-11-09 12:18:05', '2018-11-09 12:18:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3525', '1080', '1', '32d2c84c189d2897e0d6496c1fad27a3.jpg', '2018-11-09 12:18:05', '2018-11-09 12:18:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3526', '1080', '2', 'c28f1fd9b446e25e0debf9835082c9f9.jpg', '2018-11-09 12:18:29', '2018-11-09 12:18:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3527', '1080', '2', '7cb1541c487d9f0ae09278430abeb2f6.jpg', '2018-11-09 12:18:29', '2018-11-09 12:18:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3528', '1080', '2', '97827436358c7d05b73619ca8e262f79.jpg', '2018-11-09 12:18:29', '2018-11-09 12:18:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3529', '1080', '3', '94b81cba7f3ae55f1418c17323b51832.jpg', '2018-11-09 12:18:56', '2018-11-09 12:18:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3530', '1080', '3', '7be3f2ff13d02cbc9126de3b306aee5e.jpg', '2018-11-09 12:18:58', '2018-11-09 12:18:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3531', '1363', '1', 'fc4b42d17424aed1abb631b258f9951f.jpg', '2018-11-09 13:18:20', '2018-11-09 13:18:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3532', '1363', '1', '9c83a79140bce209912a602380f56140.jpg', '2018-11-09 13:18:20', '2018-11-09 13:18:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3533', '1363', '2', '75b11efffdfffc395e5f96492ef458e2.jpg', '2018-11-09 13:18:50', '2018-11-09 13:18:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3534', '1363', '2', 'b7b790cba6f1f72955064ba0276eeaab.jpg', '2018-11-09 13:18:50', '2018-11-09 13:18:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3535', '1363', '2', 'cc47c61ec3d81d083159c37161f76ca7.jpg', '2018-11-09 13:18:50', '2018-11-09 13:18:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3536', '1363', '2', '45b2886c68248ccdfa275be39d43fef6.jpg', '2018-11-09 13:18:50', '2018-11-09 13:18:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3537', '1363', '3', 'e6c4d688418a066b29cc200a6a9bd413.jpg', '2018-11-09 13:19:49', '2018-11-09 13:19:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3538', '1367', '1', '3b4748fac63569d0265165b81daab624.jpg', '2018-11-09 13:21:38', '2018-11-09 13:21:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3539', '1367', '2', '1916c389a9e5cf6dbf932afd270d6ebe.jpg', '2018-11-09 13:21:52', '2018-11-09 13:21:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3540', '1367', '2', '5ef37801d625b2f7626484787560717f.jpg', '2018-11-09 13:21:52', '2018-11-09 13:21:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3541', '1367', '2', '85ea284b1006d4e0162d61f6db976b68.jpg', '2018-11-09 13:21:52', '2018-11-09 13:21:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3542', '1367', '3', 'ae9d9528a0b0b6f03e672cfbdcc66f8c.jpg', '2018-11-09 13:23:06', '2018-11-09 13:23:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3543', '1357', '1', '81a721a43812e581a32ab62824fbf7b0.jpg', '2018-11-09 13:23:15', '2018-11-09 13:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3544', '1357', '1', '799c1c0843216c53228306b6e1262e37.jpg', '2018-11-09 13:23:15', '2018-11-09 13:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3545', '1357', '1', '5d97245bb3936c5d08f938f0a716784a.jpg', '2018-11-09 13:23:15', '2018-11-09 13:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3546', '1357', '1', '6e152b2b6f364701ec6cd301e2995542.jpg', '2018-11-09 13:23:15', '2018-11-09 13:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3547', '1357', '1', '45f1adba5962a5632e3a696067e232d1.jpg', '2018-11-09 13:23:15', '2018-11-09 13:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3548', '1357', '1', 'c5c153baa30f6d7568bf3ed41b2a0e34.jpg', '2018-11-09 13:23:15', '2018-11-09 13:23:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3549', '1347', '1', '3a2ba5ffd5afc1d075e91cd9223b8edb.jpg', '2018-11-09 13:23:41', '2018-11-09 13:23:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3550', '1347', '2', '5eb575b262369c63543e33764408598e.jpg', '2018-11-09 13:23:50', '2018-11-09 13:23:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3551', '1347', '2', '61ab17b15c45a6308048b435f4b09c05.jpg', '2018-11-09 13:23:50', '2018-11-09 13:23:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3552', '1357', '2', '64e8c0cdc897a06f6cfd5188de9db2dc.jpg', '2018-11-09 13:23:56', '2018-11-09 13:23:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3553', '1357', '2', 'bba803a814cbe5302ebf9fb3610d465f.jpg', '2018-11-09 13:23:56', '2018-11-09 13:23:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3554', '1357', '2', '657572dbea1426206fd5476f24addeff.jpg', '2018-11-09 13:23:56', '2018-11-09 13:23:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3555', '1357', '2', 'ac76900793bd56db87e3d173ed37b325.jpg', '2018-11-09 13:23:56', '2018-11-09 13:23:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3556', '1347', '3', 'eff3fb6f9f9cecc3d670855655dab00b.jpg', '2018-11-09 13:24:49', '2018-11-09 13:24:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3557', '1357', '3', '9f9c1ed4753efec12f957844c1dd062e.jpg', '2018-11-09 13:24:59', '2018-11-09 13:24:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3558', '1348', '1', '6e65c4a3d99b01e76ce9658b318e54a9.jpg', '2018-11-09 13:25:25', '2018-11-09 13:25:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3559', '1348', '2', '8c00ae4207c177ac578e7920fe20a753.jpg', '2018-11-09 13:25:30', '2018-11-09 13:25:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3560', '1348', '3', 'b96f6eff01922567e5f60b23c49c5e0d.jpg', '2018-11-09 13:25:46', '2018-11-09 13:25:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3561', '1250', '2', '7762ec5f8ca0bcc8879b6cf168bee5d0.jpg', '2018-11-12 09:57:57', '2018-11-12 09:57:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3562', '1250', '3', 'afe1dcbd03591a56169552364601568b.jpg', '2018-11-12 09:58:29', '2018-11-12 09:58:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3563', '1251', '2', '0e1a398a917ae44aa1d389378a5ad1c4.jpg', '2018-11-12 09:59:39', '2018-11-12 09:59:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3564', '1251', '3', '4ddb8e56a31da6f38d67bfd6e47b7418.jpg', '2018-11-12 09:59:57', '2018-11-12 09:59:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3565', '945', '2', 'd0dd254e5a1a11d89e26ab579d316bdc.jpg', '2018-11-12 10:04:27', '2018-11-12 10:04:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3566', '945', '3', '18279033815474914c035c807bc90950.jpg', '2018-11-12 10:04:46', '2018-11-12 10:04:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3567', '636', '2', '6a583b64b63180c0a055e7ccf21533ee.jpg', '2018-11-12 10:28:04', '2018-11-12 10:28:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3568', '636', '3', '8988fd876f7b66d100331ce378392c52.jpg', '2018-11-12 10:28:36', '2018-11-12 10:28:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3569', '981', '2', '92616117de13f5203a3bdeebce34c413.jpg', '2018-11-12 10:29:53', '2018-11-12 10:29:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3570', '981', '3', '5a40b640d76a848e9fa83181c4a359be.jpg', '2018-11-12 10:30:27', '2018-11-12 10:30:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3571', '1128', '2', '61f69948e6731feecb06ebb70aa53977.jpg', '2018-11-12 10:38:20', '2018-11-12 10:38:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3572', '1128', '3', '7555a4ed7d7a070feecd0cf4bac884c4.jpg', '2018-11-12 10:38:50', '2018-11-12 10:38:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3573', '1126', '2', 'b207d606b89c16f1aaa7549e6bd66faf.jpg', '2018-11-12 10:46:09', '2018-11-12 10:46:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3574', '1126', '3', 'a9f516c1e379b7eecc60b9498ed40efd.jpg', '2018-11-12 10:46:42', '2018-11-12 10:46:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3575', '775', '2', 'f6ee51bfd7c72897067fda0f8dc8720f.jpg', '2018-11-12 10:55:09', '2018-11-12 10:55:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3576', '775', '3', '65d9157ef03bf01f1ee535fd4768b067.jpg', '2018-11-12 10:55:32', '2018-11-12 10:55:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3577', '1219', '2', '76d862768b33de8821df8ecb8573cf14.jpg', '2018-11-12 10:56:54', '2018-11-12 10:56:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3578', '1219', '3', 'ad5347b72ccf6d2f0d073d0553229de8.jpg', '2018-11-12 10:57:13', '2018-11-12 10:57:13');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3579', '1125', '2', '536776683992a409980e69a9ae0276d9.jpg', '2018-11-12 11:01:32', '2018-11-12 11:01:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3580', '1125', '3', '2b86a9f967d113d1dec7c44ffdb6a925.jpg', '2018-11-12 11:02:05', '2018-11-12 11:02:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3581', '580', '2', '6c959939d9e35cee6f593eec9c0dbe97.jpg', '2018-11-12 11:22:43', '2018-11-12 11:22:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3582', '580', '2', '9d0f88af4128d96504650ef330442779.jpg', '2018-11-12 11:22:43', '2018-11-12 11:22:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3583', '580', '2', '0fb6f9327fa3d67a990d6a4a0223a948.jpg', '2018-11-12 11:22:43', '2018-11-12 11:22:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3584', '580', '3', 'f15f936dfea25ee4b01ed4915668cc1d.jpg', '2018-11-12 11:23:07', '2018-11-12 11:23:07');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3585', '922', '2', '8bf229c5eeaea560c580339f533486d1.jpg', '2018-11-12 11:25:25', '2018-11-12 11:25:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3586', '922', '3', 'e0e6e893fbcad2d9bcf7a565e4b27226.jpg', '2018-11-12 11:25:50', '2018-11-12 11:25:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3587', '1216', '2', 'f2fb973056a101569f912c2a5c451ec6.jpg', '2018-11-12 11:35:45', '2018-11-12 11:35:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3588', '1216', '3', 'be438e51acb10274eeb59b0e22ee4ff1.jpg', '2018-11-12 11:36:11', '2018-11-12 11:36:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3589', '1286', '2', '1fe635cf2d3d1de4ffdf6c9bace495e9.jpg', '2018-11-12 12:02:29', '2018-11-12 12:02:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3590', '1286', '2', 'de27de2f760beceff0f6de4bcbe609f8.jpg', '2018-11-12 12:02:29', '2018-11-12 12:02:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3591', '1286', '3', 'c4df24101e960927944b0444ea81f4d4.jpg', '2018-11-12 12:02:58', '2018-11-12 12:02:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3592', '1077', '2', '1998e6e758b44555d646101d3c14aed8.jpg', '2018-11-12 12:04:57', '2018-11-12 12:04:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3593', '1077', '3', 'e6b066abc6b6c213ea1f4bd87c326279.jpg', '2018-11-12 12:05:18', '2018-11-12 12:05:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3594', '1192', '2', '9c4ab41d068acc741d6d98bd46641040.jpg', '2018-11-12 12:23:33', '2018-11-12 12:23:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3595', '1192', '3', 'bdcdc1783c4bb96a95ed42051e3fe754.jpg', '2018-11-12 12:24:06', '2018-11-12 12:24:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3596', '1221', '2', 'f77701c72560a922577e09cada2ba813.jpg', '2018-11-12 12:25:20', '2018-11-12 12:25:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3597', '1221', '3', 'f5165428af68b9aedbaec30509bf17af.jpg', '2018-11-12 12:25:37', '2018-11-12 12:25:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3598', '1123', '2', 'f1fb5de8d4cb6643774ec94179e6e363.jpg', '2018-11-12 12:29:22', '2018-11-12 12:29:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3599', '1123', '3', 'f203208e5dcf5e85201b6a576403e70f.jpg', '2018-11-12 12:29:47', '2018-11-12 12:29:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3600', '1088', '2', '4af0f727d0220df8b14b82d092d5f308.jpg', '2018-11-12 12:31:28', '2018-11-12 12:31:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3601', '1088', '3', '97b1095bae1513b10a3dacb8a05f5fa2.jpg', '2018-11-12 12:31:54', '2018-11-12 12:31:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3602', '1085', '2', 'd5eae4f011174a60a7d9b15537472def.jpg', '2018-11-12 12:59:34', '2018-11-12 12:59:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3603', '1085', '3', '09ae81a6426ec10f35a256ca0672d81b.jpg', '2018-11-12 13:00:02', '2018-11-12 13:00:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3604', '1079', '2', 'efe685d331c5cd53b4c15d22d3fb5af0.jpg', '2018-11-12 13:03:18', '2018-11-12 13:03:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3605', '1079', '3', '09278ab7881f3947cd46b1a9dde260d8.jpg', '2018-11-12 13:03:38', '2018-11-12 13:03:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3606', '515', '2', 'ca1ed5e96e976cf6207ffe45ccf4de71.jpg', '2018-11-12 13:15:16', '2018-11-12 13:15:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3607', '515', '3', '8ed03288def914b519baaf612c3e9a25.jpg', '2018-11-12 13:15:35', '2018-11-12 13:15:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3608', '1083', '2', 'ec1f52f455e3eca7ee90067c17552964.jpg', '2018-11-12 13:17:38', '2018-11-12 13:17:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3609', '1083', '3', '13b64e39f3c93fd10b46ad0101bea60b.jpg', '2018-11-12 13:17:57', '2018-11-12 13:17:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3610', '1344', '1', 'eb1c6c47abd2272afb93b44c7ffcf6b6.jpg', '2018-11-12 14:29:23', '2018-11-12 14:29:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3611', '1344', '1', '80005e7067b2a96dcdc25495655ff724.jpg', '2018-11-12 14:29:23', '2018-11-12 14:29:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3612', '1344', '2', '7cc1ab37cd9f11647d6e908454f02f46.jpg', '2018-11-12 14:31:19', '2018-11-12 14:31:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3613', '1344', '2', '3f98d5ae56728a22837b7105aec27fb2.jpg', '2018-11-12 14:31:19', '2018-11-12 14:31:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3614', '1344', '3', 'fadafb2de02bc1261c64621fe2a69120.jpg', '2018-11-12 14:32:24', '2018-11-12 14:32:24');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3615', '1343', '1', 'd09e4edffbc99d1a2baa0a73bbf3bcf1.jpg', '2018-11-12 14:36:19', '2018-11-12 14:36:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3616', '1343', '1', '6fc2090690e388c084ad0ee22386b230.jpg', '2018-11-12 14:36:19', '2018-11-12 14:36:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3617', '1343', '1', '6e7bd6ee7ca99eb4eebd4aae6113f60e.jpg', '2018-11-12 14:36:19', '2018-11-12 14:36:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3618', '1343', '1', '8b99d9ca17ce42e96b07090224d132a6.jpg', '2018-11-12 14:36:19', '2018-11-12 14:36:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3619', '1343', '2', '5a56693ea15a78055c609b7fe6e1a065.jpg', '2018-11-12 14:37:15', '2018-11-12 14:37:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3620', '1343', '2', 'e9bd8f896d4e13546d86cdc06b194067.jpg', '2018-11-12 14:37:15', '2018-11-12 14:37:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3621', '1343', '2', '1c2d0fce9f771976ba76fcbdd9e8673c.jpg', '2018-11-12 14:37:15', '2018-11-12 14:37:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3622', '1343', '3', 'b51051a2ba5b881322f2e9a512ab8a1c.jpg', '2018-11-12 14:38:14', '2018-11-12 14:38:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3623', '1338', '1', '4c9efc007d5a525cc400af0857b6af4f.jpg', '2018-11-12 14:46:15', '2018-11-12 14:46:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3624', '1338', '1', '92689b9fb4790e65b0499d42cbe03542.jpg', '2018-11-12 14:46:15', '2018-11-12 14:46:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3625', '1338', '1', '66b323b21c543f315bc7b23a0ec8203e.jpg', '2018-11-12 14:46:15', '2018-11-12 14:46:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3626', '1338', '2', 'b16ff6c4b7720d39ffbdac314e7a2681.jpg', '2018-11-12 14:48:02', '2018-11-12 14:48:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3627', '1338', '2', '18e8d9157defb9241377c3a24d8d0e87.jpg', '2018-11-12 14:48:02', '2018-11-12 14:48:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3628', '1338', '2', 'b711a7599bdfc4f80c08f88e435963db.jpg', '2018-11-12 14:48:02', '2018-11-12 14:48:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3629', '1338', '2', '650ca0c25ae16d52ba18286f6c76aa0c.jpg', '2018-11-12 14:48:02', '2018-11-12 14:48:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3630', '1338', '2', 'cddad6b03d876aa971f78d6de1e3f0d8.jpg', '2018-11-12 14:48:02', '2018-11-12 14:48:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3631', '1338', '3', '7759d6787d1aedf9cd112e414afdbd8d.jpg', '2018-11-12 14:53:32', '2018-11-12 14:53:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3632', '1340', '2', '78b7491df6782cc62159fac528ee8add.jpg', '2018-11-12 15:15:03', '2018-11-12 15:15:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3633', '1340', '2', '1b7a70169d5d8dbe2a05fe1bd4db5a0a.jpg', '2018-11-12 15:15:03', '2018-11-12 15:15:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3634', '1340', '2', '20787b49554fdb93261a40411a6053bd.jpg', '2018-11-12 15:15:03', '2018-11-12 15:15:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3635', '1340', '2', '4acfb536d871d262398ccbacd9a14616.jpg', '2018-11-12 15:15:03', '2018-11-12 15:15:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3636', '1340', '3', '5b8a43a8d47b0179ad1116e67010c0d5.jpg', '2018-11-12 15:19:04', '2018-11-12 15:19:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3637', '1295', '1', '34e83c75a5876b8495d092d62c382dc1.jpg', '2018-11-13 10:47:43', '2018-11-13 10:47:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3638', '1295', '1', 'ee305cb54e83b904289ed7f9fa6a12e5.jpg', '2018-11-13 10:47:43', '2018-11-13 10:47:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3639', '1295', '2', 'b6fad54609ca70f30f2f3e9744dded44.jpg', '2018-11-13 10:48:05', '2018-11-13 10:48:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3640', '1295', '2', 'fea48f7dfa69c814aad5282f33dcc867.jpg', '2018-11-13 10:48:05', '2018-11-13 10:48:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3641', '1295', '2', '5c95ecc685855bf0b50457021b3c41d9.jpg', '2018-11-13 10:48:05', '2018-11-13 10:48:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3642', '1295', '3', 'df70e93ac80b1eb45f7c87a3cb25547e.jpg', '2018-11-13 10:50:52', '2018-11-13 10:50:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3643', '1355', '1', '68460e26a3231b2828ef9f6c422f5c6a.jpg', '2018-11-13 11:08:05', '2018-11-13 11:08:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3644', '1355', '1', '9337f7535b599cb0ecae33cfb933bd9a.jpg', '2018-11-13 11:08:05', '2018-11-13 11:08:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3645', '1355', '1', 'ddfc4c6dc78f3e75f6c4ac068e5c293c.jpg', '2018-11-13 11:08:05', '2018-11-13 11:08:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3646', '1355', '2', '31c3d7623fbe4580de30a13b9d7e6fee.jpg', '2018-11-13 11:08:25', '2018-11-13 11:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3647', '1355', '2', '6ba1430e1f0f07214daca103de62dea1.jpg', '2018-11-13 11:08:25', '2018-11-13 11:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3648', '1355', '2', '29076d6cc00f2afdc2f7c7618e517083.jpg', '2018-11-13 11:08:25', '2018-11-13 11:08:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3649', '1355', '3', 'decdd156594aa20e0b6385ff4dbe9eda.jpg', '2018-11-13 11:14:20', '2018-11-13 11:14:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3650', '1356', '1', '2d4429c90dcc5630a8a75316864a83c7.jpg', '2018-11-13 11:38:10', '2018-11-13 11:38:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3651', '1356', '1', '9a91d6aae40633b9582c904b96d47fd8.jpg', '2018-11-13 11:38:10', '2018-11-13 11:38:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3652', '1356', '1', 'c699fcbe17cd6697ce766e8cdcede5c0.jpg', '2018-11-13 11:38:10', '2018-11-13 11:38:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3653', '1356', '1', '3dd5906507db6f886fcb63c7c4db0614.jpg', '2018-11-13 11:38:10', '2018-11-13 11:38:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3654', '1356', '2', 'f4982ad2222fa35a79ad4d4414db30c5.jpg', '2018-11-13 11:38:35', '2018-11-13 11:38:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3655', '1356', '2', '9e1b310249f5ec49d9c1c0139f606c02.jpg', '2018-11-13 11:38:35', '2018-11-13 11:38:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3656', '1356', '2', 'fcfaacf03243625e2f51cc5e7109bb70.jpg', '2018-11-13 11:38:35', '2018-11-13 11:38:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3657', '1356', '2', 'f5b984f7eb682384f7e2e7043953ff56.jpg', '2018-11-13 11:38:35', '2018-11-13 11:38:35');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3658', '1356', '3', 'ed692fa537ce230a97455bac212b16bb.jpg', '2018-11-13 11:40:05', '2018-11-13 11:40:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3659', '1089', '2', '65fbba97eff265a252f4418958359c62.jpg', '2018-11-13 11:57:25', '2018-11-13 11:57:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3660', '1089', '3', '847c23d10edc5850c3a86d54e953c09d.jpg', '2018-11-13 11:57:54', '2018-11-13 11:57:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3661', '1099', '2', 'dc376df818e0563fc506941cc8535036.jpg', '2018-11-13 12:03:16', '2018-11-13 12:03:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3662', '1099', '3', '183b6dfc2399950d02d50d12d87512d4.jpg', '2018-11-13 12:03:39', '2018-11-13 12:03:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3663', '979', '2', 'b1b1b4d89a05923018d8609abbe18a10.jpg', '2018-11-13 12:15:12', '2018-11-13 12:15:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3664', '979', '3', '758bc110116b244f6cd6c5bd2ad9524c.jpg', '2018-11-13 12:15:32', '2018-11-13 12:15:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3665', '1162', '2', '8660caefef6bf537a5e79cf00385ec5e.jpg', '2018-11-13 12:17:00', '2018-11-13 12:17:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3666', '1162', '3', '2d4d0eeb1832d2df2aab0170ce296d9e.jpg', '2018-11-13 12:17:21', '2018-11-13 12:17:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3667', '1107', '2', '65382812bc04b677bc433e2b09cf527b.jpg', '2018-11-13 12:20:54', '2018-11-13 12:20:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3668', '1107', '3', 'da490cbf50a2b7ffcef073c78bd08e6f.jpg', '2018-11-13 12:21:18', '2018-11-13 12:21:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3669', '156', '2', '2b704ea6b094353010e88415a7fb84d8.jpg', '2018-11-13 12:24:33', '2018-11-13 12:24:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3670', '156', '3', 'cf890823c1b1d853e6abdb4118f4b57f.jpg', '2018-11-13 12:25:19', '2018-11-13 12:25:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3671', '1154', '2', '5371a38f495520529fd06228d79798d3.jpg', '2018-11-13 12:29:02', '2018-11-13 12:29:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3672', '1154', '3', '5bbd28ea1fa9528d4d6b7c17388f6fb5.jpg', '2018-11-13 12:29:23', '2018-11-13 12:29:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3673', '966', '2', '4e3c0815d5d217d893f0a09234583e7e.jpg', '2018-11-13 13:10:26', '2018-11-13 13:10:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3674', '966', '3', '2067c267a597a6260102ded16969b5de.jpg', '2018-11-13 13:10:48', '2018-11-13 13:10:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3675', '1135', '2', 'e56b8268c74c94125e67f82167b52ed7.jpg', '2018-11-13 13:14:04', '2018-11-13 13:14:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3676', '1135', '3', '517536b82d75383690bee6fd80b6bf0f.jpg', '2018-11-13 13:14:19', '2018-11-13 13:14:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3677', '1071', '2', 'bbe0a39a22b89a7d026063c6033d00fe.jpg', '2018-11-13 13:16:46', '2018-11-13 13:16:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3678', '1071', '2', 'c70352d3a060a1af0223a8f918fd57cd.jpg', '2018-11-13 13:16:46', '2018-11-13 13:16:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3679', '1071', '3', '69048dca546f1ab3cd9ef94ca790d745.jpg', '2018-11-13 13:17:04', '2018-11-13 13:17:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3680', '1396', '1', '8ba3c96ccfdf934a6a86eb186e4a83bd.jpg', '2018-11-14 09:53:11', '2018-11-14 09:53:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3681', '1396', '1', 'a122a5c47cf6e0a1d062ad9f20a66a2f.jpg', '2018-11-14 09:53:11', '2018-11-14 09:53:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3682', '1396', '1', '397beec5271f7c879d12cdc28f2b00c5.jpg', '2018-11-14 09:53:11', '2018-11-14 09:53:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3683', '1396', '2', '6dfd47f98c8c9db85a6f3220d8bc8ef4.jpg', '2018-11-14 09:53:29', '2018-11-14 09:53:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3684', '1396', '2', 'd13ec2409d7d7ae23d9be3ba46342fe9.jpg', '2018-11-14 09:53:29', '2018-11-14 09:53:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3685', '1396', '3', '855a571c924e2e593211f1480b23e192.jpg', '2018-11-14 09:55:01', '2018-11-14 09:55:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3686', '1337', '1', '9d930cc02cee445eb7d5174545b2c032.jpg', '2018-11-14 10:02:08', '2018-11-14 10:02:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3687', '1337', '1', '931437d9802df92902d7822c9619e794.jpg', '2018-11-14 10:02:08', '2018-11-14 10:02:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3688', '1337', '2', '79db2a81d4e7916d6e4209110cd2904f.jpg', '2018-11-14 10:02:55', '2018-11-14 10:02:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3689', '1337', '2', '205846be1dc512ad1f75837da94847e0.jpg', '2018-11-14 10:02:55', '2018-11-14 10:02:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3690', '1337', '3', '440bed68505d00c2c496322db5b81a5b.jpg', '2018-11-14 10:03:34', '2018-11-14 10:03:34');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3691', '1172', '2', '07ef2d0e3611fedc756421f0cda28091.jpg', '2018-11-14 11:53:21', '2018-11-14 11:53:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3692', '1172', '3', '7fe2fd3a33fe3a7050a35f693ba55ebe.jpg', '2018-11-14 11:53:46', '2018-11-14 11:53:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3693', '772', '2', 'e0cca91a1ac65f3edaf4d0d0e0502207.jpg', '2018-11-14 11:56:36', '2018-11-14 11:56:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3694', '772', '3', '55298aea2a1722840984ee6a6b99e1e0.jpg', '2018-11-14 11:57:04', '2018-11-14 11:57:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3695', '572', '2', '36287d08d583f11b60a71df846d9458a.jpg', '2018-11-14 11:58:00', '2018-11-14 11:58:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3696', '572', '3', '1d98be081fd4cd3ed65e88b861e34688.jpg', '2018-11-14 11:58:10', '2018-11-14 11:58:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3697', '400', '2', 'b6fc2ef23ba8c22c2cc864dca11b52d1.jpg', '2018-11-14 11:59:01', '2018-11-14 11:59:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3698', '400', '3', 'eafaa568799baa71050a034df681eae3.jpg', '2018-11-14 11:59:11', '2018-11-14 11:59:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3699', '363', '2', 'f8afa04a731869e5a6286a2c8af3beeb.jpg', '2018-11-14 12:04:53', '2018-11-14 12:04:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3700', '363', '3', 'c330485a6e81008463cceb61163ed495.jpg', '2018-11-14 12:05:12', '2018-11-14 12:05:12');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3701', '1225', '2', '067056d57107e27b24d0824ab3658c24.jpg', '2018-11-14 12:11:02', '2018-11-14 12:11:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3702', '1225', '3', 'ec781e12dda02f960b733e88888fee13.jpg', '2018-11-14 12:11:30', '2018-11-14 12:11:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3703', '1389', '2', '67c0aad686dfb92b7b20257a7195cda2.jpg', '2018-11-14 12:13:28', '2018-11-14 12:13:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3704', '1389', '3', 'd9519adc4476c1d7fddc6f7219f425af.jpg', '2018-11-14 12:13:47', '2018-11-14 12:13:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3705', '1388', '2', '473c040d46643587d559671df8f5c569.jpg', '2018-11-14 12:15:54', '2018-11-14 12:15:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3706', '1388', '3', '719309b49776e5e374dd54416473616f.jpg', '2018-11-14 12:16:14', '2018-11-14 12:16:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3707', '1240', '2', '9cf883ad5371377da7365efdbdcf487d.jpg', '2018-11-14 13:39:51', '2018-11-14 13:39:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3708', '1240', '2', '6a4f2f1a8d7eedbf9f2ae45a5f3c6aff.jpg', '2018-11-14 13:39:51', '2018-11-14 13:39:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3709', '1240', '3', 'b3e041af5ece8e0d136f7c34c97b0335.jpg', '2018-11-14 13:40:14', '2018-11-14 13:40:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3710', '1400', '1', 'c7a512d3232acb164d6edf27dbe6eb40.jpg', '2018-11-14 13:40:41', '2018-11-14 13:40:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3711', '1400', '1', 'e92880077a5f6a1d8849dfca36859483.jpg', '2018-11-14 13:40:41', '2018-11-14 13:40:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3712', '1400', '1', '6155368af8fa0eb44a2b8a5ce46183b3.jpg', '2018-11-14 13:40:41', '2018-11-14 13:40:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3713', '1400', '1', '03f6b5ea6161dda2ff3f481b73524529.jpg', '2018-11-14 13:40:41', '2018-11-14 13:40:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3714', '1400', '1', '325ece59678df948770b9b2cd381127e.jpg', '2018-11-14 13:40:41', '2018-11-14 13:40:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3715', '1241', '2', '04eccb438302492bed1466dc330ca289.jpg', '2018-11-14 13:41:11', '2018-11-14 13:41:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3716', '1400', '2', '290fb60599a64d2b3d309315a4f1802f.jpg', '2018-11-14 13:41:18', '2018-11-14 13:41:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3717', '1400', '2', 'ce5abcfa5ba2cdeaa27d6c0f84c36a00.jpg', '2018-11-14 13:41:18', '2018-11-14 13:41:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3718', '1400', '2', '28177f85aa29310afc52e2ea43b8d065.jpg', '2018-11-14 13:41:18', '2018-11-14 13:41:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3719', '1241', '3', '661ef74ea02b9c2695f308db5057bc58.jpg', '2018-11-14 13:41:26', '2018-11-14 13:41:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3720', '1400', '3', '2cef0288272476801a26148ce3a59f9d.jpg', '2018-11-14 13:42:29', '2018-11-14 13:42:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3721', '1226', '2', 'd16a96d58c2de00375b8e51403052435.jpg', '2018-11-14 13:43:23', '2018-11-14 13:43:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3722', '1226', '3', 'b9f51c2e711099bd098f2a1be39197bf.jpg', '2018-11-14 13:43:47', '2018-11-14 13:43:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3723', '1291', '1', '3615d34282e810deb4e85cbf33250a0b.jpg', '2018-11-14 16:39:20', '2018-11-14 16:39:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3724', '1291', '1', 'ee52e4d14f07483c0a1a73d26bf58e64.jpg', '2018-11-14 16:39:20', '2018-11-14 16:39:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3725', '1291', '1', 'efc9b363f9840702893aa3ff3b7043d2.jpg', '2018-11-14 16:39:20', '2018-11-14 16:39:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3726', '1291', '1', 'f9ee770c7c6d285183960577b20fd028.jpg', '2018-11-14 16:39:20', '2018-11-14 16:39:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3727', '1291', '2', '377fcfcec8528782beafbdf060aacbe2.jpg', '2018-11-14 16:39:52', '2018-11-14 16:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3728', '1291', '2', 'b18b4391db80e9b19fb54ec7ee6b91d7.jpg', '2018-11-14 16:39:52', '2018-11-14 16:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3729', '1291', '2', '5421cf8ea59ee1775b6bf42ca7405719.jpg', '2018-11-14 16:39:52', '2018-11-14 16:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3730', '1291', '2', 'b5d90eb5073140f97bd926ebf8ce4c3c.jpg', '2018-11-14 16:39:52', '2018-11-14 16:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3731', '1291', '2', '43b50d69bf7bc62bac62ae291f80bbc0.jpg', '2018-11-14 16:39:52', '2018-11-14 16:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3732', '1291', '3', 'd8de6e5b22abb884f57312d23b037451.jpg', '2018-11-14 16:42:59', '2018-11-14 16:42:59');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3733', '1414', '1', '706b848e5ae2671e4a4df6a88965e462.jpg', '2018-11-14 18:04:02', '2018-11-14 18:04:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3734', '1414', '1', '8bfa940b5850c0423bb88c0e5d9084b6.jpg', '2018-11-14 18:04:02', '2018-11-14 18:04:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3735', '1414', '1', '426e7735e9d74e26096b4c2630f466e0.jpg', '2018-11-14 18:04:02', '2018-11-14 18:04:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3736', '1414', '1', 'efc93b5d621d113dcc3a9b0aef4341e2.jpg', '2018-11-14 18:04:02', '2018-11-14 18:04:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3737', '1414', '2', 'f9afd43f5f5167626ef6b2c47b0710c8.jpg', '2018-11-14 18:05:44', '2018-11-14 18:05:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3738', '1414', '2', '8a2298ac950aff3017fd54d63f25f378.jpg', '2018-11-14 18:05:44', '2018-11-14 18:05:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3739', '1414', '2', 'a95263538915f41b39b14d1500c3940b.jpg', '2018-11-14 18:05:44', '2018-11-14 18:05:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3740', '1414', '2', '9e3b872eee2018617228eff63ff551a5.jpg', '2018-11-14 18:05:44', '2018-11-14 18:05:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3741', '1414', '2', 'ffa5420e1cdc44b1d023bec91d8c9de4.jpg', '2018-11-14 18:05:44', '2018-11-14 18:05:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3742', '1414', '3', '7d134ad444dd238740ee589fa4327ac5.jpg', '2018-11-14 18:13:04', '2018-11-14 18:13:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3743', '291', '1', '9307d5cd71063797ab8d7c9448ad207a.jpg', '2018-11-14 18:14:46', '2018-11-14 18:14:46');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3744', '291', '2', 'a031fb7b045bf56dac63484638ed3986.jpg', '2018-11-14 18:16:54', '2018-11-14 18:16:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3745', '291', '3', '76d3f3b11d7585dd33a821ab2e18655d.jpg', '2018-11-14 18:17:51', '2018-11-14 18:17:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3746', '1220', '1', '14f70ed78fb42da050a78b99e7113d4e.jpg', '2018-11-15 11:28:20', '2018-11-15 11:28:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3747', '1220', '2', 'b8e4ebdf4a555a36e095194ce2d687ff.jpg', '2018-11-15 11:28:38', '2018-11-15 11:28:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3748', '1220', '2', 'ad6bae45310714c64a602950c9893d61.jpg', '2018-11-15 11:28:38', '2018-11-15 11:28:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3749', '1220', '2', 'c6262c94e57e17ead9c9e70181874ac7.jpg', '2018-11-15 11:28:38', '2018-11-15 11:28:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3750', '1220', '2', 'a1772f0ffc742bf8208485bd62aa4f93.jpg', '2018-11-15 11:28:38', '2018-11-15 11:28:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3751', '1220', '3', '968e407e1c02ca77f70ac4247ab2616d.jpg', '2018-11-15 11:29:57', '2018-11-15 11:29:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3752', '1381', '1', 'a2056c044425e4cc12cc6903221f67f0.jpg', '2018-11-15 11:45:27', '2018-11-15 11:45:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3753', '1381', '2', 'b132b39bf999508847acb3a361e585fa.jpg', '2018-11-15 11:46:22', '2018-11-15 11:46:22');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3754', '1381', '3', '658d40a4f8d434b72ae3f8aa8b0a58e4.jpg', '2018-11-15 11:47:44', '2018-11-15 11:47:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3755', '1199', '2', '44d7073c6fbd564427a1c85a5b2fc1dd.jpg', '2018-11-16 13:21:09', '2018-11-16 13:21:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3756', '1199', '2', '851d8fdcef6401b9ea909c676d509e3c.jpg', '2018-11-16 13:21:09', '2018-11-16 13:21:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3757', '1199', '3', '9007c1877428b5acaa07e2e66462fd71.jpg', '2018-11-16 13:21:32', '2018-11-16 13:21:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3758', '1188', '2', '5f1f9df59ad7a89e06c390fe6943dbd9.jpg', '2018-11-16 13:24:16', '2018-11-16 13:24:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3759', '1188', '2', 'aafc3d7f49d8b0dee446ea0e2ee50b3d.jpg', '2018-11-16 13:24:16', '2018-11-16 13:24:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3760', '1188', '3', '6ece4be1da449db42dd16053df1f07cf.jpg', '2018-11-16 13:24:52', '2018-11-16 13:24:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3761', '1300', '2', '51e1de43f869ff8acf84f171697fe5ec.jpg', '2018-11-16 17:11:17', '2018-11-16 17:11:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3762', '1300', '3', 'b3425d76cfd4d696d4ec90a89eeb846d.jpg', '2018-11-16 17:11:41', '2018-11-16 17:11:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3763', '1290', '2', 'b1192400c5b0cf5542d79b53eb12d301.jpg', '2018-11-16 17:19:20', '2018-11-16 17:19:20');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3764', '1290', '3', '1fa5863774e2f5aac015213303867aa0.jpg', '2018-11-16 17:19:39', '2018-11-16 17:19:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3765', '1352', '2', '61f835f1456c35f460980e4e45ddad61.jpg', '2018-11-16 17:23:42', '2018-11-16 17:23:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3766', '1352', '3', '57f49c58c4566d7136f96c2b1113fdb9.jpg', '2018-11-16 17:23:58', '2018-11-16 17:23:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3767', '1360', '2', '34c4503450cb3a5483dcf6d524c2a83c.jpg', '2018-11-16 17:40:11', '2018-11-16 17:40:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3768', '1360', '2', 'ec034717fa69f0fea46d000148c31852.jpg', '2018-11-16 17:40:11', '2018-11-16 17:40:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3769', '1360', '2', '304171ddaeda6c2f4b2853e77aad64d4.jpg', '2018-11-16 17:40:11', '2018-11-16 17:40:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3770', '1360', '2', '8eafb8146b875f5e590887d8292b2b1d.jpg', '2018-11-16 17:40:11', '2018-11-16 17:40:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3771', '1360', '2', 'bf952800cc5dc0b45e1e9ab8c2c40435.jpg', '2018-11-16 17:40:11', '2018-11-16 17:40:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3772', '1360', '3', '23e518d1ac7fa810401559f4e7a33b52.jpg', '2018-11-16 17:40:37', '2018-11-16 17:40:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3773', '1361', '2', '16335d4cca5f5305f03279d9741beb69.jpg', '2018-11-16 17:41:33', '2018-11-16 17:41:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3774', '1361', '3', 'c83d8dbf2abbc64358906a6eee865fb3.jpg', '2018-11-16 17:41:50', '2018-11-16 17:41:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3775', '1362', '2', 'c18f6ca84e502246f8daaa3305afcea0.jpg', '2018-11-16 17:42:38', '2018-11-16 17:42:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3776', '1362', '3', '7ad2d597eed94f412306089c1c7bfe3d.jpg', '2018-11-16 17:42:55', '2018-11-16 17:42:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3777', '1314', '2', '22a7ef70e10b8b4f2c2d80d23da07938.jpg', '2018-11-16 18:03:57', '2018-11-16 18:03:57');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3778', '1314', '3', '0010562feab2f5176f346952c1710886.jpg', '2018-11-16 18:05:03', '2018-11-16 18:05:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3779', '1313', '2', '4a1670e0c9cd4a66e22c7bec24ff73d3.jpg', '2018-11-16 18:15:44', '2018-11-16 18:15:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3780', '1313', '3', 'd6ed71c7c15a36f1beb85cd61b92ee79.jpg', '2018-11-16 18:16:04', '2018-11-16 18:16:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3781', '1195', '2', '158bae2d28d1733cd52ab5cc4043b39b.jpg', '2018-11-16 18:17:17', '2018-11-16 18:17:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3782', '1195', '3', '52cfdfd2e4e3da4c9cf8d25ce3370514.jpg', '2018-11-16 18:17:47', '2018-11-16 18:17:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3783', '1161', '2', '00589a4a7a82c23b11ef1eaddac0cbb2.jpg', '2018-11-16 18:18:45', '2018-11-16 18:18:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3784', '1161', '3', 'd555385534d43936400e582213271ea4.jpg', '2018-11-16 18:19:00', '2018-11-16 18:19:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3785', '1270', '2', '24a4bfe013a4ef3e1f38b1f88006a27d.jpg', '2018-11-16 18:30:18', '2018-11-16 18:30:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3786', '1270', '3', '0432eac8ee90ddc326a45ac0c59da9ad.jpg', '2018-11-16 18:30:43', '2018-11-16 18:30:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3787', '1270', '3', 'ae998b2c5d5f98e477316f1b42a63e3f.jpg', '2018-11-16 18:30:49', '2018-11-16 18:30:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3788', '1271', '2', '43d1dc00869346d0d7936a149906efed.jpg', '2018-11-16 18:32:32', '2018-11-16 18:32:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3789', '1271', '3', '225be08f1c9bdef30c2c4a50b3ba1367.jpg', '2018-11-16 18:33:00', '2018-11-16 18:33:00');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3790', '1395', '2', '828f71f00af0d1bc5cb03f3742b576f0.jpg', '2018-11-16 18:34:45', '2018-11-16 18:34:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3791', '1395', '3', 'a0e8a7989549e534b930531b679f2ac4.jpg', '2018-11-16 18:35:06', '2018-11-16 18:35:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3792', '1153', '2', 'd4a4ced41322a5443fa2a0007dbbe25e.jpg', '2018-11-16 19:00:45', '2018-11-16 19:00:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3793', '1153', '3', '7e6d5c08d0af0691d10fa27f5a131d53.jpg', '2018-11-16 19:01:32', '2018-11-16 19:01:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3794', '1293', '2', 'f18d9e2ce98d946646a16ac68b9c350c.jpg', '2018-11-16 19:02:42', '2018-11-16 19:02:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3795', '1293', '2', '5e0d104eeb8bb05f2e4bdfc10c3f82d3.jpg', '2018-11-16 19:02:42', '2018-11-16 19:02:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3796', '1293', '3', '47f552fb5a4888b9ce7e1c99226349f5.jpg', '2018-11-16 19:03:01', '2018-11-16 19:03:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3797', '1359', '2', 'd74919b1828a3d1baf0cffc9284ec06f.jpg', '2018-11-16 19:11:31', '2018-11-16 19:11:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3798', '1359', '2', 'cbfa3ee8832903bba03d550fbb65b6c2.jpg', '2018-11-16 19:11:31', '2018-11-16 19:11:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3799', '1359', '3', 'd6dafc689d9efee3174a11dff2f47a05.jpg', '2018-11-16 19:12:04', '2018-11-16 19:12:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3800', '1419', '1', '85279838d1f02019ad505492866fb505.jpg', '2018-11-17 12:34:32', '2018-11-17 12:34:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3801', '1419', '1', 'e2cdcf78cb71a6ea42146c6057b4cbff.jpg', '2018-11-17 12:34:32', '2018-11-17 12:34:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3802', '1419', '1', '2fd3ffbdfeaa966e2a8e1bd5c9799d63.jpg', '2018-11-17 12:34:32', '2018-11-17 12:34:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3803', '1419', '1', '032241aa9ca87fd6edb140725fc1e0e0.jpg', '2018-11-17 12:34:32', '2018-11-17 12:34:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3804', '1419', '1', '817d8f8484e610a8ea90eed47ca2729a.jpg', '2018-11-17 12:34:32', '2018-11-17 12:34:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3805', '1419', '1', '94d87a3d120a8afcf8579d1d6389e1db.jpg', '2018-11-17 12:34:32', '2018-11-17 12:34:32');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3806', '1419', '2', '0d29abcd60ec428efedeb54aefa89b0b.jpg', '2018-11-17 12:35:17', '2018-11-17 12:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3807', '1419', '2', 'bd441d7de8f3c9a755522db2f158d01f.jpg', '2018-11-17 12:35:17', '2018-11-17 12:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3808', '1419', '2', '083499945a91f04235f6717609b7c1bf.jpg', '2018-11-17 12:35:17', '2018-11-17 12:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3809', '1419', '2', '0d629e24f53382756a44c6ba31c70b78.jpg', '2018-11-17 12:35:17', '2018-11-17 12:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3810', '1419', '2', 'd9571248f2092665a31593c2fcde47d7.jpg', '2018-11-17 12:35:17', '2018-11-17 12:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3811', '1419', '2', '15457e8c34f4dbfdced81769cf0fcb4f.jpg', '2018-11-17 12:35:17', '2018-11-17 12:35:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3812', '1419', '3', 'da75b8dc52c0dabd6478f87bf2fcee6c.jpg', '2018-11-17 12:39:15', '2018-11-17 12:39:15');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3813', '1055', '2', '298547a6a028b19eba680372ad3dc0fe.jpg', '2018-11-17 14:08:04', '2018-11-17 14:08:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3814', '1055', '2', '72efcad64bee96b188c9d844b77fee64.jpg', '2018-11-17 14:08:04', '2018-11-17 14:08:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3815', '1055', '2', '0bdd8ea178222a0dcd022d24dc684ede.jpg', '2018-11-17 14:08:04', '2018-11-17 14:08:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3816', '1055', '2', '64dc291fd54adaa0258518f481da00e4.jpg', '2018-11-17 14:08:04', '2018-11-17 14:08:04');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3817', '1055', '3', 'a0c7a1a473178ebb5cbe491098953e16.jpg', '2018-11-17 14:09:55', '2018-11-17 14:09:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3818', '1243', '2', '0e3c72ef566a5f4ccc33496d1bad7544.jpg', '2018-11-17 14:33:02', '2018-11-17 14:33:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3819', '1243', '3', '5a5114a27a917ccc19afee7c974008a1.jpg', '2018-11-17 14:33:17', '2018-11-17 14:33:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3820', '1369', '2', '9d40b8d95bb42ec1d6938cd0425d3a4c.jpg', '2018-11-17 14:39:52', '2018-11-17 14:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3821', '1369', '2', '8c710f45e28423070fac74f92817a36a.jpg', '2018-11-17 14:39:52', '2018-11-17 14:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3822', '1369', '2', 'f0dd2b82a03c99130ff25b6897aefd14.jpg', '2018-11-17 14:39:52', '2018-11-17 14:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3823', '1369', '2', '181be3a6b79be13d2bdbebf6c77c2147.jpg', '2018-11-17 14:39:52', '2018-11-17 14:39:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3824', '1369', '3', '30759ebde92804bcf64d59859e6e6c5b.jpg', '2018-11-17 14:40:25', '2018-11-17 14:40:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3825', '1287', '2', '00e1fe00214d88b1a42b025db039ab34.jpg', '2018-11-17 14:45:23', '2018-11-17 14:45:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3826', '1287', '3', '797d6bc763608632b2e12873b17fdd43.jpg', '2018-11-17 14:45:51', '2018-11-17 14:45:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3827', '1060', '2', 'b8ff7caa56fb5b4beb33b857bae8e4a0.jpg', '2018-11-17 19:23:45', '2018-11-17 19:23:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3828', '1060', '3', '898f7eef5f20d4453d7380e4de030684.jpg', '2018-11-17 19:24:09', '2018-11-17 19:24:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3829', '1044', '2', '69be458f6aba0feeeb07de493f10b92e.jpg', '2018-11-17 19:33:27', '2018-11-17 19:33:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3830', '1044', '3', '55c1c2953c3c82bd36b4657e0df9f116.jpg', '2018-11-17 19:33:45', '2018-11-17 19:33:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3831', '1049', '2', 'd3584b2e1e8da8ae87f2dce3f142ed80.jpg', '2018-11-17 19:35:06', '2018-11-17 19:35:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3832', '1049', '3', '87e806480478c0ab5909e43d5353779b.jpg', '2018-11-17 19:35:27', '2018-11-17 19:35:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3833', '1171', '2', 'b71fb78b5df9ae7a3e0b971b0e5b1548.jpg', '2018-11-17 19:44:21', '2018-11-17 19:44:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3834', '1171', '3', 'c8459e4419024887227e27cc8f84cc95.jpg', '2018-11-17 19:44:51', '2018-11-17 19:44:51');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3835', '1277', '2', 'ed15f351f69fe4ae6ecec18540182d64.jpg', '2018-11-17 20:43:44', '2018-11-17 20:43:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3836', '1277', '3', '8e5294459b005d7c4564474f1e8a70e5.jpg', '2018-11-17 20:44:25', '2018-11-17 20:44:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3837', '1438', '2', '6f416e6835b00b5418765318a0c923f9.jpg', '2018-11-17 20:46:17', '2018-11-17 20:46:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3838', '1438', '3', '6edfc5ec49dc388a4676f8046a9309ae.jpg', '2018-11-17 20:46:29', '2018-11-17 20:46:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3839', '1276', '2', 'cdf98959a17a466bffb6c97130987da8.jpg', '2018-11-17 20:52:33', '2018-11-17 20:52:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3840', '1276', '3', 'c84af2bf75e02089a0fad1ce055c326c.jpg', '2018-11-17 20:52:47', '2018-11-17 20:52:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3841', '1312', '2', 'e9333518bce346fc43526799eaa3b71f.jpg', '2018-11-17 20:55:37', '2018-11-17 20:55:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3842', '1312', '3', '1c437c771d9fbe46cb1b4e599d265c73.jpg', '2018-11-17 20:55:56', '2018-11-17 20:55:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3843', '1442', '1', '73b081fea45b1ff31376455cff32902b.jpg', '2018-11-20 09:54:10', '2018-11-20 09:54:10');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3844', '1442', '2', '7903d14cfd1cd22de5f52dd9efb8dcb0.jpg', '2018-11-20 09:54:18', '2018-11-20 09:54:18');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3845', '1442', '2', '297a96607e5192eeec21c424ea31a190.jpg', '2018-11-20 09:54:19', '2018-11-20 09:54:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3846', '1442', '3', 'ee8bdb8ebbc3b96c18a0b69877f02732.jpg', '2018-11-20 09:55:52', '2018-11-20 09:55:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3847', '1441', '2', '3fa5d1efa9bd4d6b0a517eaf79692294.jpg', '2018-11-20 10:08:28', '2018-11-20 10:08:28');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3848', '1441', '3', '643aef56c189cd922b7bd2535f22cd13.jpg', '2018-11-20 10:09:55', '2018-11-20 10:09:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3849', '1127', '2', '26ad8eabb7dffef1d4bcbe56280ec1fd.jpg', '2018-11-20 10:21:42', '2018-11-20 10:21:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3850', '1127', '2', '777235fac083224c8cf0ae00847b749b.jpg', '2018-11-20 10:21:42', '2018-11-20 10:21:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3851', '1127', '2', 'e95b8058b2ee800e7050f9f9fcd2c539.jpg', '2018-11-20 10:21:42', '2018-11-20 10:21:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3852', '1127', '2', '6d8a410bffb883bf050b61592eac2920.jpg', '2018-11-20 10:21:42', '2018-11-20 10:21:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3853', '1127', '2', 'dcb60bae9d66965fd6bffa158cc39109.jpg', '2018-11-20 10:21:42', '2018-11-20 10:21:42');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3854', '1127', '3', '9ee0d0133845d6d8a3e2f6e79e34672a.jpg', '2018-11-20 10:22:08', '2018-11-20 10:22:08');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3855', '1120', '2', 'b9b6db67096d833b8774a8cc49cc34a3.jpg', '2018-11-20 10:44:02', '2018-11-20 10:44:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3856', '1120', '2', '51e7411999e69c4b929c65b3d6420308.jpg', '2018-11-20 10:44:02', '2018-11-20 10:44:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3857', '1120', '2', '356286e507c83db21fddfddd8d079215.jpg', '2018-11-20 10:44:02', '2018-11-20 10:44:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3858', '1120', '2', '40378c041bb8c1d4687202d64afdcc6a.jpg', '2018-11-20 10:44:02', '2018-11-20 10:44:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3859', '1120', '3', '001a8c45cf55f59f5e7bcb009dcec495.jpg', '2018-11-20 10:56:44', '2018-11-20 10:56:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3860', '1445', '1', 'e38129d9e584d155b66ff5ce9b9833f0.jpg', '2018-11-20 11:26:38', '2018-11-20 11:26:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3861', '1445', '1', 'ab4ee7dd8adf486702a8614938a82800.jpg', '2018-11-20 11:26:38', '2018-11-20 11:26:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3862', '1445', '2', '35f331fae667cd4e6326965bfdc219ac.jpg', '2018-11-20 11:26:53', '2018-11-20 11:26:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3863', '1445', '2', 'e825ad2b750d42e5c11d0060373b48e9.jpg', '2018-11-20 11:26:53', '2018-11-20 11:26:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3864', '1445', '2', 'ab9f34055c967209de67a8d09235b377.jpg', '2018-11-20 11:26:53', '2018-11-20 11:26:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3865', '1445', '3', '76b83e8fca6d684d42133382949248b0.jpg', '2018-11-20 11:27:25', '2018-11-20 11:27:25');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3866', '1416', '1', 'd1b15695a638818e3b51709985aeafac.jpg', '2018-11-20 11:29:52', '2018-11-20 11:29:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3867', '1416', '2', 'b93b3273a09880bec672fca0085912dd.jpg', '2018-11-20 11:30:01', '2018-11-20 11:30:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3868', '1416', '2', 'e370a7c8eee0717a3c1375ae08ada614.jpg', '2018-11-20 11:30:01', '2018-11-20 11:30:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3869', '1416', '3', '176f782a622c7fe00fef2be75c30db42.jpg', '2018-11-20 11:30:44', '2018-11-20 11:30:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3870', '955', '2', 'd49f288ccf1ecfe50c21d8b46af4a1c3.jpg', '2018-11-20 11:30:53', '2018-11-20 11:30:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3871', '955', '2', 'd8df30e16aa1eb08a239de5d9674c7ad.jpg', '2018-11-20 11:30:53', '2018-11-20 11:30:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3872', '955', '2', '9dfc6a884a82fd8bb1bf95dc4c006149.jpg', '2018-11-20 11:30:53', '2018-11-20 11:30:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3873', '955', '2', 'f411af169c311d68ca78ff0c3c7b5680.jpg', '2018-11-20 11:30:56', '2018-11-20 11:30:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3874', '955', '2', 'f81289fac7bd218a78eafffb8abd51e1.jpg', '2018-11-20 11:30:56', '2018-11-20 11:30:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3875', '955', '2', 'ca77334f1242f3482008a51d9703c761.jpg', '2018-11-20 11:30:56', '2018-11-20 11:30:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3876', '955', '3', '2b63e2e046b5d38e05d0eeecb8064e21.jpg', '2018-11-20 11:31:19', '2018-11-20 11:31:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3877', '1433', '1', '36c2582b4669ba77af821edc42420029.jpg', '2018-11-20 11:43:16', '2018-11-20 11:43:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3878', '1433', '1', '0d8457b6b7127f6f8f4b23a55b6281a6.jpg', '2018-11-20 11:43:16', '2018-11-20 11:43:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3879', '1433', '1', 'fa1bc41b3fdd0ba6c4854632403c0218.jpg', '2018-11-20 11:43:16', '2018-11-20 11:43:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3880', '1433', '2', 'dff1a3167a4fe3c26a2af73babe18457.jpg', '2018-11-20 11:43:41', '2018-11-20 11:43:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3881', '1433', '2', '3f0f456ed9f2eaa0d0a92291d8131ed3.jpg', '2018-11-20 11:43:41', '2018-11-20 11:43:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3882', '1433', '3', 'dca8c6be977336128a77d2904ed66009.jpg', '2018-11-20 11:44:31', '2018-11-20 11:44:31');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3883', '1296', '1', '8195eab6db0589adfe22a9f110f268ee.jpg', '2018-11-20 12:43:23', '2018-11-20 12:43:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3884', '1296', '1', '8ace9eb4ba1610628b387deb27d7764e.jpg', '2018-11-20 12:43:23', '2018-11-20 12:43:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3885', '1296', '1', '5ca8cc86fd9856d28012189b66b31939.jpg', '2018-11-20 12:43:23', '2018-11-20 12:43:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3886', '1296', '2', '010d2a0707e369a12febc942b98203fc.jpg', '2018-11-20 12:43:44', '2018-11-20 12:43:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3887', '1296', '2', '71522618ed46cf4c2bcafdc9991fface.jpg', '2018-11-20 12:43:44', '2018-11-20 12:43:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3888', '1296', '2', 'c8b926cddadea9c634f7a88cb8e99679.jpg', '2018-11-20 12:43:44', '2018-11-20 12:43:44');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3889', '1296', '3', 'fef751947d3dc01903863450bb1ae0a4.jpg', '2018-11-20 12:44:26', '2018-11-20 12:44:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3890', '1401', '1', '7fac97c04ee49096fa674ebf2867814f.jpg', '2018-11-20 12:45:17', '2018-11-20 12:45:17');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3891', '1401', '2', '314e5c80932d1f2f1a8a8b0eab02d76d.jpg', '2018-11-20 12:45:33', '2018-11-20 12:45:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3892', '1401', '2', '72c0cbb86ab52cadf4bfe3d0ecd88da3.jpg', '2018-11-20 12:45:33', '2018-11-20 12:45:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3893', '1401', '3', '416fa62fc3fbd28109b200ee5db4fdc6.jpg', '2018-11-20 12:46:01', '2018-11-20 12:46:01');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3894', '1447', '2', 'bbb7082007da4a5e957c01b24a8e3aad.jpg', '2018-11-20 13:24:27', '2018-11-20 13:24:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3895', '1447', '2', '4d2c29167b28eeff473a2d30e3272afb.jpg', '2018-11-20 13:24:27', '2018-11-20 13:24:27');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3896', '1447', '3', 'f0f71a0956c0b805fbea43804913c93b.jpg', '2018-11-20 13:24:43', '2018-11-20 13:24:43');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3897', '1446', '1', 'b9a5ec4b91a667ee016670da9d1159be.jpg', '2018-11-20 13:37:37', '2018-11-20 13:37:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3898', '1446', '1', '0ef691d9cc5e08e2a184bc2d0d0cb5d3.jpg', '2018-11-20 13:37:37', '2018-11-20 13:37:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3899', '1446', '2', '6b449a1948570e353ad99ccb32d3cd50.jpg', '2018-11-20 13:37:50', '2018-11-20 13:37:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3900', '1446', '2', 'd9afc0e136edeedeef9544f6b658effd.jpg', '2018-11-20 13:37:50', '2018-11-20 13:37:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3901', '1446', '2', '8f642d6d40db08f71677181f96140846.jpg', '2018-11-20 13:37:50', '2018-11-20 13:37:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3902', '1446', '3', '623f899715e23deb8928f422c9e6b549.jpg', '2018-11-20 13:39:53', '2018-11-20 13:39:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3903', '1444', '1', 'e7a46f8395bd2e76a3cd70bfa6440eb6.jpg', '2018-11-20 14:09:11', '2018-11-20 14:09:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3904', '1444', '2', '0f102b5134b0ac65c7798be6102003f6.jpg', '2018-11-20 14:10:14', '2018-11-20 14:10:14');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3905', '1444', '3', '007a8c797a7f0bceb44817fffb86c4b2.jpg', '2018-11-20 14:11:11', '2018-11-20 14:11:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3906', '1415', '2', '2d057745cb2d2ea416a36dee34ac2ca4.jpg', '2018-11-21 11:35:58', '2018-11-21 11:35:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3907', '1415', '3', '6f12c99aa33929efb314aa2fc95ee296.jpg', '2018-11-21 11:36:19', '2018-11-21 11:36:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3908', '1394', '2', 'a1099a90a5233dc3f65848f4e96926e7.jpg', '2018-11-21 11:40:56', '2018-11-21 11:40:56');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3909', '1394', '3', '11d3291cbf59f494668df1f5e906ee00.jpg', '2018-11-21 11:41:36', '2018-11-21 11:41:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3910', '1200', '2', '8a53e0a8b315a561a80ee8153a1391ac.jpg', '2018-11-21 11:46:54', '2018-11-21 11:46:54');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3911', '1200', '3', '1eca0ff1b239388e0b9a03337f52a495.jpg', '2018-11-21 11:47:09', '2018-11-21 11:47:09');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3912', '1402', '2', '718098e32f302557c9f0e0b05dafa64c.jpg', '2018-11-21 11:48:02', '2018-11-21 11:48:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3913', '1402', '3', 'ac93ed241dec276e2fa36b268dffcd30.jpg', '2018-11-21 11:48:19', '2018-11-21 11:48:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3914', '1399', '2', 'cb8cce0c91fec2cc8b004f70b95aadca.jpg', '2018-11-21 11:59:06', '2018-11-21 11:59:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3915', '1399', '3', 'ec7e337345f84f96559c1abbdb52d77b.jpg', '2018-11-21 11:59:30', '2018-11-21 11:59:30');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3916', '1427', '2', '5ea53704da868643a5a4298172a9159b.jpg', '2018-11-21 12:09:39', '2018-11-21 12:09:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3917', '1427', '2', '478bbf364e2b174c22d7e8c6c564a0ea.jpg', '2018-11-21 12:09:39', '2018-11-21 12:09:39');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3918', '1427', '3', 'd06f0674b4a7b1944cd5ac4cbcbf0ec1.jpg', '2018-11-21 12:10:02', '2018-11-21 12:10:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3919', '1425', '2', 'f2bf116b584703dc304af4eafc44241f.jpg', '2018-11-21 12:11:11', '2018-11-21 12:11:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3920', '1425', '2', '8acd47c10314f1e60a03062e6d99c4d0.jpg', '2018-11-21 12:11:11', '2018-11-21 12:11:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3921', '1425', '3', '54cfb44dffc6d04c7716906ba48707ae.jpg', '2018-11-21 12:11:23', '2018-11-21 12:11:23');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3922', '1342', '1', '9cce56484e3e5181325ef94f63ae7513.jpg', '2018-11-21 12:17:16', '2018-11-21 12:17:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3923', '1342', '1', 'c146f55a47240f5b0f3096ad93f9e782.jpg', '2018-11-21 12:17:16', '2018-11-21 12:17:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3924', '1253', '2', '111c8f861f411a022473d9934a3c3ff4.jpg', '2018-11-21 12:17:36', '2018-11-21 12:17:36');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3925', '1253', '3', 'ae0736a28a694d166cd90186c5505309.jpg', '2018-11-21 12:17:52', '2018-11-21 12:17:52');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3926', '1342', '2', '228d0c4516f18490076bcddfd1e89c24.jpg', '2018-11-21 12:17:55', '2018-11-21 12:17:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3927', '1342', '2', 'd3e906d3f86f1c89461fc45b8b309785.jpg', '2018-11-21 12:17:55', '2018-11-21 12:17:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3928', '1342', '2', '05d64352c69cb7c3975c3ad4c8e50f58.jpg', '2018-11-21 12:17:55', '2018-11-21 12:17:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3929', '1342', '2', 'c3a6b8ca13fe20f036eb20e0fcc3d9bc.jpg', '2018-11-21 12:17:55', '2018-11-21 12:17:55');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3930', '1342', '3', 'b12d857a8c7e2cf5580d1b5e46b12fb7.jpg', '2018-11-21 12:18:47', '2018-11-21 12:18:47');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3931', '1247', '2', '0832dc859085b0ac67637f655706c6e5.jpg', '2018-11-21 12:19:19', '2018-11-21 12:19:19');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3932', '1247', '3', '6342666826ba372c4c069c058e6db894.jpg', '2018-11-21 12:19:37', '2018-11-21 12:19:37');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3933', '1169', '2', '204dafc65664301f58b3c1c52e405e62.jpg', '2018-11-21 12:25:02', '2018-11-21 12:25:02');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3934', '1169', '3', 'd5c46f68f984af036456d61ecabdc02c.jpg', '2018-11-21 12:26:03', '2018-11-21 12:26:03');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3935', '1407', '1', 'b39cebc36849f56d3d14afd34bd62b77.jpg', '2018-11-21 14:11:49', '2018-11-21 14:11:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3936', '1407', '1', '3b1359639b1d6257913e587313e5f872.jpg', '2018-11-21 14:11:49', '2018-11-21 14:11:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3937', '1407', '1', 'ba89fa71ba99500e1a31410a3a5c9c25.jpg', '2018-11-21 14:11:49', '2018-11-21 14:11:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3938', '1407', '2', '54308588be073358c7a91e2e03c14114.jpg', '2018-11-21 14:12:16', '2018-11-21 14:12:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3939', '1407', '2', 'f27543a5fd8765ea053044b3c0461ec4.jpg', '2018-11-21 14:12:16', '2018-11-21 14:12:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3940', '1407', '2', '09095116f9e42154478c5bf8464b508d.jpg', '2018-11-21 14:12:16', '2018-11-21 14:12:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3941', '1407', '2', 'cc0ea0899b10ab0cbeeb25a61caefb5f.jpg', '2018-11-21 14:12:16', '2018-11-21 14:12:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3942', '1407', '3', '9e350976cdd4bbcf7143f7f091847982.jpg', '2018-11-21 14:13:11', '2018-11-21 14:13:11');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3943', '1431', '1', '3530ae89e9af83dcd9fb60b45c170598.jpg', '2018-11-21 15:10:41', '2018-11-21 15:10:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3944', '1431', '1', '26802d15dec351ac472dad1596ddfed9.jpg', '2018-11-21 15:10:41', '2018-11-21 15:10:41');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3945', '1431', '2', '3e98d14aadfc1105d6228b887bd7c1fa.jpg', '2018-11-21 15:11:29', '2018-11-21 15:11:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3946', '1431', '2', '7b3d7497e09f5ddb980166e9e5988676.jpg', '2018-11-21 15:11:29', '2018-11-21 15:11:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3947', '1431', '2', '3b8e221c748d413e1460bf99e2737381.jpg', '2018-11-21 15:11:29', '2018-11-21 15:11:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3948', '1431', '2', '04cee1b122409948301341ec990bcae1.jpg', '2018-11-21 15:11:29', '2018-11-21 15:11:29');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3949', '1431', '3', 'd41ac3b1ea06d2614f4807e389016c36.jpg', '2018-11-21 15:12:26', '2018-11-21 15:12:26');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3950', '1404', '1', '95a7d9cd7dab9e37645177ec699fb1fe.jpg', '2018-11-21 15:30:06', '2018-11-21 15:30:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3951', '1404', '1', '3fc792ea989e38d379aca7cc71b162d8.jpg', '2018-11-21 15:30:06', '2018-11-21 15:30:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3952', '1404', '1', '90f49563b79f3712b640fbadb1ed1f0c.jpg', '2018-11-21 15:30:06', '2018-11-21 15:30:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3953', '1404', '1', '29bcf462b76313f9b28ba422ee72a03e.jpg', '2018-11-21 15:30:06', '2018-11-21 15:30:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3954', '1404', '1', 'd9189fa945d05963752b14981750e648.jpg', '2018-11-21 15:30:06', '2018-11-21 15:30:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3955', '1404', '2', 'fa77351a0315afee4df345a640a52545.jpg', '2018-11-21 15:30:33', '2018-11-21 15:30:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3956', '1404', '2', '6007b4ee6c970c1c331d184a1c5ba84d.jpg', '2018-11-21 15:30:33', '2018-11-21 15:30:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3957', '1404', '2', '2d951163ed5632a3cf72c65cb9db393f.jpg', '2018-11-21 15:30:33', '2018-11-21 15:30:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3958', '1404', '2', 'df4d1cb9d05d39d97824b05c3e79ba16.jpg', '2018-11-21 15:30:33', '2018-11-21 15:30:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3959', '1404', '2', '58f2b1eb929346ac87f2df163600419e.jpg', '2018-11-21 15:30:33', '2018-11-21 15:30:33');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3960', '1404', '3', '32484cb9ae59b440f027545d5e691771.jpg', '2018-11-21 15:33:06', '2018-11-21 15:33:06');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3961', '1408', '1', '1ee796b4658d2a02ddcaae3c6b14d86c.jpg', '2018-11-21 16:08:21', '2018-11-21 16:08:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3962', '1408', '1', '1309c6cc8d292683f8a2cd24a74b2761.jpg', '2018-11-21 16:08:21', '2018-11-21 16:08:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3963', '1408', '1', '7566197c4b045b500673029ccf71b88c.jpg', '2018-11-21 16:08:21', '2018-11-21 16:08:21');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3964', '1408', '2', '8b7bc30ed589465494b2196115049024.jpg', '2018-11-21 16:08:49', '2018-11-21 16:08:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3965', '1408', '2', 'f3365025959ffc9f5eeaa441979391a5.jpg', '2018-11-21 16:08:49', '2018-11-21 16:08:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3966', '1408', '2', '1c87eada6f8bbea1b5edd0ad120a1fe5.jpg', '2018-11-21 16:08:49', '2018-11-21 16:08:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3967', '1408', '2', '7279fa0f399d05ea0ecaa76d949ac562.jpg', '2018-11-21 16:08:49', '2018-11-21 16:08:49');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3968', '1408', '3', '13983d662068cadba6bac0d206f5563e.jpg', '2018-11-21 16:14:45', '2018-11-21 16:14:45');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3969', '1405', '1', '2202f8d0c8a4df3fd89317c06ce28ece.jpg', '2018-11-21 17:25:48', '2018-11-21 17:25:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3970', '1405', '1', '6d858006c6db167a931a4bc4fcde09d9.jpg', '2018-11-21 17:25:48', '2018-11-21 17:25:48');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3971', '1405', '2', 'd42982b527d0c4fd2f3715a6b7976038.jpg', '2018-11-21 17:26:05', '2018-11-21 17:26:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3972', '1405', '2', 'c355d209d062eed2ac633aac7093a334.jpg', '2018-11-21 17:26:05', '2018-11-21 17:26:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3973', '1405', '2', '0f84e6ec7729b074ac0d40971cc72590.jpg', '2018-11-21 17:26:05', '2018-11-21 17:26:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3974', '1405', '2', 'edc4c1f5bbf2adabf66b59ca73279c86.jpg', '2018-11-21 17:26:05', '2018-11-21 17:26:05');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3975', '1405', '3', 'bc017175b65305207667cbd2942843ce.jpg', '2018-11-21 17:27:40', '2018-11-21 17:27:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3976', '1406', '1', 'e1ab8827350cd72c0b035ab0506ce46b.jpg', '2018-11-21 17:50:38', '2018-11-21 17:50:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3977', '1406', '1', '8809538fd7dccb1f41801007db0bc7c9.jpg', '2018-11-21 17:50:38', '2018-11-21 17:50:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3978', '1406', '1', '345cb6dc270c73e90a6161bb00393f7e.jpg', '2018-11-21 17:50:38', '2018-11-21 17:50:38');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3979', '1406', '2', '1b0345a956aa4840aba3fb5409325562.jpg', '2018-11-21 17:50:53', '2018-11-21 17:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3980', '1406', '2', '850cf8332c588ea15e7799a7719acb55.jpg', '2018-11-21 17:50:53', '2018-11-21 17:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3981', '1406', '2', '6f2e21f0eaecf6480c414c447d237d51.jpg', '2018-11-21 17:50:53', '2018-11-21 17:50:53');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3982', '1406', '3', 'cd4bbf53d064c0cecb8107a906096c97.jpg', '2018-11-21 17:52:16', '2018-11-21 17:52:16');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3983', '1424', '1', 'bab07dd16123346c78b2316eadafea9f.jpg', '2018-11-22 09:30:58', '2018-11-22 09:30:58');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3984', '1455', '1', '1174ee1ac2df9c2abc99bf5e75ae0d0c.jpg', '2018-11-22 09:31:40', '2018-11-22 09:31:40');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_Foto`, `Id_Ticket`, `Tipo`, `Ruta_Imagen`, `Fecha_Alta`, `Fecha_Actualiza`) VALUES ('3985', '1455', '2', 'bbdffd3236bf9ef2b31b7894bda2a3c2.jpg', '2018-11-22 09:31:50', '2018-11-22 09:31:50');
INSERT INTO `Evidencia_Fotos` (`Id_Evidencia_F