<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Admin_model");	
	}

	/**
	  * ABRE VISTA DE LOGIN
	  */
	public function index()
	{
		$session = $this->session->userdata();
		// echo "<pre>";
		// print_r($session);
		// echo "</pre>";
		if(!isset($session["Id_Usuario"])){
			$this->load->view("login");
		}else{
			redirect(base_url("dashboards"));
		}
	}

	/**
	 * LOGIN A LA APP
	 */
	public function logIn()
	{		
		$rules = array(
			array("field" => "txtusuario", "label" => "Usuario", "rules" => "trim|required|xss_clean"),
			array("field" => "pswcontrasena", "label" => "Contraseña", "rules" => "trim|required|xss_clean"),
		);
		
		#	Carga las librerias
		$this->load->library("form_validation");
		$this->form_validation->set_rules($rules);
		#	Comprueba validaciones
		if($this->form_validation->run() == false){
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}
        
	    $usuario = $this->input->post("txtusuario");
	    $contrasena = $this->input->post("pswcontrasena");
	    //$usuario = "desarrollo@creeartelo.mx";
	    //$contrasena = 123456;
	    $contrasena = md5($contrasena);
	    $login = $this->Admin_model->Login($usuario, $contrasena);
        
	    if($login){
	    	#Se construye un array con los permisos del usuario
	        $permisos = $this->Admin_model->CNS_Permisos($login["Clave_Rol"]);
	        $login["permisos"] = array();
	        foreach ($permisos as $key => $value){
	        	array_push($login["permisos"], $value["Abreviatura"]);
	        }
        
	        #	Se mandan los datos del login a session
	    	$this->session->set_userdata($login);
	    	$this->session->set_flashdata("msg","Hola " . $login["Nombre"] . " Bienvenid@");
	    	echo json_encode(array("head" => "_ok:","body" => base_url("dashboards")));	        	
	    }else{
	    	echo json_encode(array("head" => "_er:","body" => "Oopps! Tu usuario y/o contraseña no se encuentran"));
	    }    
	}

	/**
	  * LOGOUT
	  */
	public function logOut()
	{
		$sessionarray = array(
			"Id_Empresa",
			"Empresa",
			"Clave_Rol",
			"Usuario",
			"Apellidos",
			"Status",
			"Id_Usuario",
			"Clave",
			"Rol",
			"Nombre",
			"Ruta_Imagen",
			"permisos");
		$this->session->unset_userdata($sessionarray);
		redirect(base_url());
	}
}
