<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proveedores extends MY_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Proveedores_model");
		#	Establece zona Horaria
		date_default_timezone_set("America/Mexico_City");
	}

	/**
	 * CARGA VISTAS DEL MÓDULO
	 * @return HTML
	 */
	public function index()
	{
		$session = $this->session->userdata();
		if(isset($session["Id_Usuario"])){
			$resources = array(
				"session"       => $session,
				"modulojs"      => "proveedores.js",	
			);

			$this->load->view("templates/header",$resources);
			$this->load->view("templates/sidebar",$resources);
			$this->load->view("proveedores",$resources);
			$this->load->view("templates/footer",$resources);
		}else{
			redirect(base_url());
		}
	}


	/**
	  * LISTADO DE USUARIOS SERVICIOS
	  */
	public function listarProveedores()
	{
		$Id_Empresa = $this->session->userdata("Id_Empresa");

		$draw = intval($this->input->post("draw"));
		// Registros a saltar
        $skip = $this->input->post("start");
        // Numero de registros a tomar
        $take = $this->input->post("length");
        // Columnas
        $columns = $this->input->post("columns");
        // Datos del Sort
        $order_data = $this->input->post("order")[0];
        // Nombre de la Columna a Ordenar
        $order_field = $columns[$order_data["column"]]["data"];
        // Dirección del Orden
        $order = $order_data["dir"];
        // Valor de búsqueda
        $busqueda = $this->input->post("search")["value"];
        // Total de registros
        $total =  $this->Proveedores_model->COUNT_Usuarios($Id_Empresa);

        if($busqueda){
            $tickets = $this->Proveedores_model->CNS_Usuarios_Match($Id_Empresa, $skip, $take, $order_field, $order, $busqueda);
            $filtered_rows = sizeof($tickets);
        }else{
            $tickets = $this->Proveedores_model->CNS_Usuarios($Id_Empresa, $skip, $take, $order_field, $order);
            $filtered_rows = $total;
        }

        $data = array(
            "draw" => $draw,
            "recordsTotal" =>  $total,
            "recordsFiltered" =>  $filtered_rows,
            "data" => $tickets   
        );        
        echo json_encode($data);
	}

	/** 
 	  *	 MUESTRA FORMULARIO NUEVO / EDICIÓN	
	  */
	public function muestraFormulario(){
		#	Identificador del usuario
		$Id_Usuario = $this->input->post("Id_Usuario");
		#	Módulo del que se realiza la petición Administradores / Servicios
		$tipo       = $this->input->post("tipo");
		# 	Clave de usuario
		$last_cve  	   = $this->Proveedores_model ->CNS_LastUsuario();
		$consecutivo   = $last_cve ? ($last_cve["Clave"] + 1): 1;
		$data["Clave"] = str_pad($consecutivo, 3, "0", STR_PAD_LEFT);

		$data["conf"]  =  $this->getConfiguration("TOPALRT");
		#	Si se recibe el Id_Usuario es un UPDATE
		if(is_numeric($Id_Usuario)){
			$data["usuario"] = $this->Proveedores_model->CNS_UsuarioByID($Id_Usuario);		
		}

		$this->load->view("templates/formularios/form_proveedor",$data);
	}

	/**
	 * INSERTA / ACUTALIZA USUARIO PROVEEDOR Y EMPRESA
	 * SI RECIBE Id_Usuarios => Actualiza
	 * DE LO CONTRARIO INSERTA
	 */
	public function guardaUsuario(){
		#	Id_Usuario para saber si es UPDATE
		$Id_Usuario = $this->input->post("Id_Usuario");
		#	Identificador de la empresa
		$Id_Empresa = $this->input->post("Id_Empresa");

		#	Array de validaciones
		$rules = array(
			array("field" => "txtcodigo", "label" => "Código", "rules" => "required|max_length[20]|is_unique[Empresas.Codigo.$Id_Empresa]|html_escape|trim"),
			array("field" => "txtrazon_social", "label" => "Razón Social", "rules" => "required|max_length[200]|is_unique[Empresas.Razon_Social.$Id_Empresa]|html_escape|trim"),
			array("field" => "txtclave", "label" => "Clave", "rules" => "required|exact_length[3]|numeric|is_unique[Usuarios.Clave.$Id_Usuario]|html_escape|trim"),
			array("field" => "txtnombre", "label" => "Nombre", "rules" => "required|max_length[100]|html_escape|trim"),
			array("field" => "txtapellidos", "label" => "Apellidos", "rules" => "required|max_length[150]|html_escape|trim"),
			array("field" => "txtusuario", "label" => "Usuario", "rules" => "required|valid_email|max_length[50]|is_unique[Usuarios.Usuario.$Id_Usuario]|html_escape|trim"),
			array("field" => "cmbtiempo1", "label" => "Tiempo alerta 1", "rules" => "required|greater_than_equal_to[1]|less_than_equal_to[365]|html_escape|trim|integer"),
			array("field" => "cmbtiempo2", "label" => "Tiempo alerta 2", "rules" => "required|greater_than_equal_to[1]|less_than_equal_to[365]|html_escape|trim|integer"),
			array("field" => "rdostatus", "label" => "Status", "rules" => "required|html_escape|trim|integer"),
		);

		#	Array de validaciones del file
		$rules_file = array(
				"upload_path"   => "./proveedoreslogos",
				"allowed_types" => "jpg|jpeg|png",
				"max_size"      => 2048,
				"encrypt_name"  => true
			);

		#	Si es un update no se valida que los campo sean requeridos
		if(is_numeric($Id_Usuario)){
			array_push($rules, array("field" => "pswcontrasena", "label" => "Contraseña", "rules" => "min_length[6]|max_length[18]|html_escape|trim"));
			array_push($rules, array("field" => "pswconf_contrasena", "label" => "Confirmar contraseña", "rules" => "matches[pswcontrasena]|html_escape|trim"));
		}else{
			array_push($rules, array("field" => "pswcontrasena", "label" => "Contraseña", "rules" => "required|min_length[6]|max_length[18]|html_escape|trim"));
			array_push($rules, array("field" => "pswconf_contrasena", "label" => "Confirmar contraseña", "rules" => "required|matches[pswcontrasena]|html_escape|trim"));
		}

		#	Carga las librerias
		$this->load->library("form_validation");
		$this->form_validation->set_rules($rules);
		$this->load->library("upload",$rules_file);

		#	Si cumple las validaciones		
		if ($this->form_validation->run() == FALSE) {
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}

		#	Contraseña sin encriptar
		$contrasena = $this->input->post("pswcontrasena");

		#	Datos a guardar de tabla empresas
		$data_empresa = array(
			"Codigo"          => $this->input->post("txtcodigo"),
			"Razon_Social"    => $this->input->post("txtrazon_social"),
			"Status"          => intval($this->input->post("rdostatus")),
			"Usuario_Registra" => $this->session->userdata("Id_Usuario"),
			"Fecha_Actualiza" => date("Y-m-d H:i:s"),
		);

		#	Datos a guardar de tabla usuarios 
		$data_usuario = array(
			"Id_Empresa"	   => $Id_Empresa,
			"Rol"              => "PRVD",
			"Clave"			   => $this->input->post("txtclave"),		
			"Nombre"           => $this->input->post("txtnombre"),
			"Apellidos"        => $this->input->post("txtapellidos"),
			"Usuario"          => $this->input->post("txtusuario"),
			"Status"           => intval($this->input->post("rdostatus")),
			"Usuario_Registra" => $this->session->userdata("Id_Usuario"),
			"Fecha_Actualiza"  => date("Y-m-d H:i:s"),
		);

		#	Datos a guardar de tabla tiempos 
		$data_tiempo = array(
			"Tiempo_1"	 => $this->input->post("cmbtiempo1"),
			"Tiempo_2"	 => $this->input->post("cmbtiempo2"),
			"Usuario_Registra" => $this->session->userdata("Id_Usuario"),
			"Fecha_Actualiza"  => date("Y-m-d H:i:s"),
		);

		#	Si se recibe la contraseña se agrega al array
		if($contrasena){
			$data_usuario["Contrasena"] = md5($contrasena);
		}

		#	Si se cargó una imagen se procesa
		if($_FILES["fleimagen"]["size"] > 0){
			#	Si se subió la imagen
			if($this->upload->do_upload("fleimagen")){
				#	Si se recibe el Id_Usuario (UPDATE), se borra la imagen anterior
				if(is_numeric($Id_Usuario)){
					$usuario = $this->Proveedores_model->CNS_UsuarioByID($Id_Usuario);
					$rutaborrar = "./proveedoreslogos/".$usuario["Logo"];
					if(is_file($rutaborrar) && file_exists($rutaborrar)){
						unlink($rutaborrar);
					}
				}

				$data_empresa["Logo"] = $this->upload->data("file_name");			
			}else{
				echo json_encode(array("head" => "_er:","body" => $this->upload->display_errors(" ","\n")));
				exit();
			}		
		}

		#	Si se recibe Id_Usuario: Acutaliza en base de datos
		if(is_numeric($Id_Usuario)){
			#	Actualiza en tabla empresas y usuarios
			$ar_e = $this->Proveedores_model->UPD_Empresa($Id_Empresa,$data_empresa);
			$ar_u = $this->Proveedores_model->UPD_Usuario($Id_Usuario,$data_usuario);
			$ar_t = $this->Proveedores_model->UPD_Tiempo_Usuario($Id_Usuario,$data_tiempo);
			if($ar_e > 0 && $ar_u > 0 && $ar_t > 0){
				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha agregado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}else{
			#	Si no se recibe Id_Usuario: Inserta en base de datos
			#	Se agregan las fechas alta al array de inserción
			$data_empresa["Fecha_Alta"] = date("Y-m-d H:i:s");
			$data_usuario["Fecha_Alta"] = date("Y-m-d H:i:s");
			$data_tiempo["Fecha_Alta"] =  date("Y-m-d H:i:s");
			
			#	Inserta en tabla empresas
			$last_e = $this->Proveedores_model->INS_Empresa($data_empresa);
			if(!$last_e){
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
				exit();
			}
            
            #	Si se insertó en empresas, se agrega el id al array para unsertar en usuarios
			$data_usuario["Id_Empresa"] = $last_e;
			$last_u = $this->Proveedores_model->INS_Usuario($data_usuario);
			if(!$last_u){
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
				exit();
			}

			#	Inserta en tabla tiempos
			$data_tiempo["Id_Usuario"] = $last_u;
	 		$last_t = $this->Proveedores_model->INS_Tiempos_Usuario($data_tiempo);
			if($last_t){
				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha agregado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}
	}

	/**
	 * ELIMINA USUARIO Y EMPRESA PROVEEDOR
	 * @return JSON
	 */
	public function eliminarUsuario(){
		#	Id_Usuario para eliminar
		$Id_Usuario = $this->input->post("Id_Usuario");

		#	Borra logo del usuario
		$usuario = $this->Proveedores_model->CNS_UsuarioByID($Id_Usuario);
		$rutaborrar = "./proveedoreslogos/".$usuario["Logo"];
		if(is_file($rutaborrar) && file_exists($rutaborrar)){
			unlink($rutaborrar);
		}

		$ar_e =  $this->Proveedores_model->DEL_Empresa($usuario["Id_Empresa"]);
		$ar_u  = $this->Proveedores_model->DEL_Usuarios_Empresa($usuario["Id_Empresa"]);
		$ar_t  = $this->Proveedores_model->DEL_Tiempo_Usuario($Id_Usuario);
		if($ar_e > 0 && $ar_u > 0 && $ar_t > 0){
			echo json_encode(array("head" => "_ok:","body" => "Excelete hemos eliminado tu registro"));
		}else{
			echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al eliminar tu registro, intentalo nuevamente"));
		}	
	}
}