<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuarios extends MY_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("Usuarios_model");
		#	Si no está loggeado o no tiene permisos para este módulo,
		#	regresa al login	
		$session = $this->session->userdata();
		if(!isset($session["permisos"]) || 
		   !in_array("USRS", $session["permisos"])){
			redirect(base_url());
		}
	}

	/**
	 * CARGA VISTAS DEL MÓDULO
	 * @return HTML
	 */
	public function index()
	{
		$resources = array(
			"session"       => $this->session->userdata(),
			"modulojs"      => "usuarios.js",	
		);

		$this->load->view("templates/header",$resources);
		$this->load->view("templates/sidebar",$resources);
		$this->load->view("usuarios",$resources);
		$this->load->view("templates/footer",$resources);
	}

	/**
	  * LISTADO DE USUARIOS DE LA EMPRESA
	  */
	public function listarUsuarios()
	{
		#	Identificador de la empresa
		$Id_Empresa = $this->session->userdata("Id_Empresa"); 
		#	permisos
		$permisos = $this->session->userdata("permisos");

		#	Filtra usuarios que puede visualizar
		$Filtro_Usuarios = array();
		if(in_array("ADMN", $permisos)) $Filtro_Usuarios[] = "ADMN";
		if(in_array("SPVS", $permisos)) $Filtro_Usuarios[] = "SPVS";
		if(in_array("PRVD", $permisos)) $Filtro_Usuarios[] = "PRVD";
		if(in_array("TCNC", $permisos)) $Filtro_Usuarios[] = "TCNC";

		$draw = intval($this->input->post("draw"));
		// Registros a saltar
        $skip = $this->input->post("start");
        // Numero de registros a tomar
        $take = $this->input->post("length");
        // Columnas
        $columns = $this->input->post("columns");
        // Datos del Sort
        $order_data = $this->input->post("order")[0];
        // Nombre de la Columna a Ordenar
        $order_field = $columns[$order_data["column"]]["data"];
        // Dirección del Orden
        $order = $order_data["dir"];
        // Valor de búsqueda
        $busqueda = $this->input->post("search")["value"];
        // Total de registros
        $total =  $this->Usuarios_model->COUNT_Usuarios($Id_Empresa);

        if($busqueda){
            $usuarios = $this->Usuarios_model->CNS_Usuarios_Match($Id_Empresa, $skip, $take, $order_field, $order, $busqueda,$Filtro_Usuarios);
            $filtered_rows = sizeof($usuarios);
        }else{
            $usuarios = $this->Usuarios_model->CNS_Usuarios($Id_Empresa, $skip, $take, $order_field, $order,$Filtro_Usuarios);
            $filtered_rows = $total;
        }

        $data = array(
            "draw" => $draw,
            "recordsTotal" =>  $total,
            "recordsFiltered" =>  $filtered_rows,
            "data" => $usuarios   
        );        
        echo json_encode($data);
	}

	/** 
 	  *	 MUESTRA FORMULARIO NUEVO / EDICIÓN	
	  */
	public function muestraFormulario(){
		#	Variables de sesión: id_usuario y rol
		$Id_Usuario = $this->input->post("Id_Usuario");
		$Rol        = $this->session->userdata("Clave_Rol");

		#	Consulta catálogo de roles
		$data["roles"] = $this->Usuarios_model->CNS_Roles($Rol);
		$data["conf"]  = $this->getConfiguration("TOPALRT");
		$last_cve  	   = $this->Usuarios_model->CNS_LastUsuario();
		$consecutivo   = $last_cve ? ($last_cve["Clave"] + 1): 1;

		$data["Clave"] = str_pad($consecutivo, 3, "0", STR_PAD_LEFT);
		#	Si se recibe el Id_Usuario es un UPDATE
		if(is_numeric($Id_Usuario)){
			$data["usuario"] = $this->Usuarios_model->CNS_UsuarioByID($Id_Usuario);		
		}

		$this->load->view("templates/formularios/form_usuario",$data);
	}


	/**
	 * INSERTA / ACUTALIZA USUARIO DE LA EMPRESA
	 * SI RECIBE Id_Usuarios => Actualiza
	 * DE LO CONTRARIO INSERTA
	 */
	public function guardaUsuario(){
		#	Establece zona Horaria
		date_default_timezone_set("America/Mexico_City");

		#	Id_Usuario para saber si es UPDATE
		$Id_Usuario = $this->input->post("Id_Usuario");
		#	Rol
		$Rol = $this->input->post("cmbrol"); 	
		#	Consulta si tiene el permiso de tiempos
		#	para mostra los input de alertas
		$Tiempos = $this->Usuarios_model->CNS_Permiso_Rol($Rol,"DTEC");

		#	Array de validaciones
		$rules = array(
			array("field" => "txtclave", "label" => "Clave", "rules" => "required|exact_length[3]|numeric|is_unique[Usuarios.Clave.$Id_Usuario]|html_escape|trim"),
			array("field" => "txtnombre", "label" => "Nombre", "rules" => "required|max_length[100]|html_escape|trim"),
			array("field" => "txtapellidos", "label" => "Apellidos", "rules" => "required|max_length[150]|html_escape|trim"),
			array("field" => "txtusuario", "label" => "Usuario", "rules" => "required|valid_email|max_length[50]|is_unique[Usuarios.Usuario.$Id_Usuario]|html_escape|trim"),
			array("field" => "cmbrol", "label" => "Rol", "rules" => "required|html_escape|trim"),
			array("field" => "rdostatus", "label" => "Status", "rules" => "required|html_escape|trim|integer"),
		);

		#	Si el rol tiene permisos de tiempo
		if($Tiempos > 0){
			array_push($rules, array("field" => "cmbtiempo1", "label" => "Tiempo alerta 1", "rules" => "required|greater_than_equal_to[1]|less_than_equal_to[365]|html_escape|trim|integer"));
			array_push($rules, array("field" => "cmbtiempo2", "label" => "Tiempo alerta 2", "rules" => "required|greater_than_equal_to[1]|less_than_equal_to[365]|html_escape|trim|integer"));
		}

		#	Si es un update no se valida que los campo sean requeridos
		if(is_numeric($Id_Usuario)){
			array_push($rules, array("field" => "pswcontrasena", "label" => "Contraseña", "rules" => "min_length[6]|max_length[18]|html_escape|trim"));
			array_push($rules, array("field" => "pswconf_contrasena", "label" => "Confirmar contraseña", "rules" => "matches[pswcontrasena]|html_escape|trim"));
		}else{
			array_push($rules, array("field" => "pswcontrasena", "label" => "Contraseña", "rules" => "required|min_length[6]|max_length[18]|html_escape|trim"));
			array_push($rules, array("field" => "pswconf_contrasena", "label" => "Confirmar contraseña", "rules" => "required|matches[pswcontrasena]|html_escape|trim"));
		}

		#	Carga las librerias
		$this->load->library("form_validation");
		$this->form_validation->set_rules($rules);

		#	Si cumple las validaciones		
		if ($this->form_validation->run() == FALSE) {
			echo json_encode(array("head" => "_er:","body" => validation_errors(" ","\n")));
			exit();
		}

		#	Contraseña sin encriptar
		$contrasena = $this->input->post("pswcontrasena");

		#	Datos a guardar
		$dataarray = array(
			"Id_Empresa"       => $this->session->userdata("Id_Empresa"),
			"Rol"              => $Rol,
			"Clave"            => $this->input->post("txtclave"),
			"Nombre"           => $this->input->post("txtnombre"),
			"Apellidos"        => $this->input->post("txtapellidos"),
			"Usuario"          => $this->input->post("txtusuario"),
			"Status"           => intval($this->input->post("rdostatus")),
			"Usuario_Registra" => $this->session->userdata("Id_Usuario"),
			"Fecha_Actualiza"  => date("Y-m-d H:i:s"),
		);

		#	Datos a guardar de tabla usuarios 
		$dataarray_tmp = array(
			"Tiempo_1"	 => $this->input->post("cmbtiempo1"),
			"Tiempo_2"	 => $this->input->post("cmbtiempo2"),
			"Usuario_Registra" => $this->session->userdata("Id_Usuario"),
			"Fecha_Actualiza"  => date("Y-m-d H:i:s"),
		);
		
		#	Si se recibe la contraseña se agrega al array
		if($contrasena){
			$dataarray["Contrasena"] = md5($contrasena);
		}

		#	Si se recibe Id_Usuario: Acutaliza en base de datos
		if(is_numeric($Id_Usuario)){
			$ar = $this->Usuarios_model->UPD_Usuario($Id_Usuario,$dataarray);
			if($ar){
				#	Se borra el registro del tiempo	
				#	Si insertan los tiempos si el rol tiene permiso 
				$delt = $this->Usuarios_model->DEL_Tiempo_Usuario($Id_Usuario);				
				if($Tiempos > 0){
					$dataarray_tmp["Id_Usuario"] = $Id_Usuario;
	 				$last_t = $this->Usuarios_model->INS_Tiempos_Usuario($dataarray_tmp);
				}
				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha agregado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}else{
		#	Si no se recibe Id_Usuario: Inserta en base de datos
			$dataarray["Fecha_Alta"] = date("Y-m-d H:i:s");
			$last = $this->Usuarios_model->INS_Usuario($dataarray);
			
			#	Si se insertó
			if($last){
				#	Si rol tiene permisos de tiempo						
				if($Tiempos > 0){
					$dataarray_tmp["Fecha_Alta"] =  date("Y-m-d H:i:s");
	 				$dataarray_tmp["Id_Usuario"] = $last;
	 				$last_t = $this->Usuarios_model->INS_Tiempos_Usuario($dataarray_tmp);
				}

				echo json_encode(array("head" => "_ok:","body" => "Excelete el registro se ha agregado exitosamente"));
			}else{
				echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al agregar tu registro, intentalo nuevamente"));
			}
		}
	}

	/**
	 * ELIMINA UN USUARIO
	 */
	public function eliminarUsuario(){
		#	Id_Usuario para eliminar
		$Id_Usuario = $this->input->post("Id_Usuario");

		$delu  = $this->Usuarios_model->DEL_Usuario($Id_Usuario);
		$delt  = $this->Usuarios_model->DEL_Tiempo_Usuario($Id_Usuario);
		if($delu > 0){
			echo json_encode(array("head" => "_ok:","body" => "Excelete hemos eliminado tu registro"));
		}else{
			echo json_encode(array("head" => "_er:","body" => "Ooops! Hubo un error al eliminar tu registro, intentalo nuevamente"));
		}	
	}
}