<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Welcome extends MY_Controller {
	public function __construct()
	{
		parent::__construct();
		$this->load->model("App_model");
		#	Establece zona Horaria
		date_default_timezone_set("America/Mexico_City");
	}

	public function index()
	{
		$this->load->view('welcome_message');
	}

	/**
	 * LOGIN DE LA APP
	 * @return [type] [description]
	 */
	public function login(){
		$Fecha_Actualiza = date("Y-m-d H:i:s");
		$usuario         = $this->input->post("usuario");
		$contrasena      = $this->input->post("contrasena");
		$token           = $this->input->post("token");

		#	Consulta usuario y contraseña
		$result = $this->App_model->CALL_Login($usuario,$contrasena);
		
		$json = array(
			"res" => "ERR",
			"msg" => "Mmm, este usuario y/o contraseña no se encuentran el sistema, revisa la información"
		);

		if($result){
			#	Actualiza Token del FireBase
			$data_array = array($result->Id_Usuario,$token,$Fecha_Actualiza);
			$res = $this->App_model->CALL_SPUPDA_Token_Usuario($data_array);
	
			$json = array(
							"res" => "OK",
							"query" => $result
						);
		}

		echo json_encode($json);
	}

	/**
	 * CONSULTA LOS TICKETS DEL USUARIO
	 */
	public function traeTicketsUsuario(){
		$Id_Usuario	= $this->input->post("Id_Usuario");
		$result = $this->App_model->CALL_SPCNS_TicketsUsuario($Id_Usuario);
        
		$json = array(
							"res" => "OK",
							"query" => $result
						);
		
		echo json_encode($json);
	}

	/**
	 * GUARDA LAS COORDENADAS CUANDO LLEGA PASO 1, STATUS 3
	 * @return [type] [description]
	 */
	public function guardaLlegada(){
		#	Recibe variables post
		$Id_Ticket       = $this->input->post("Id_Ticket");		
		$Fecha_Alta      = date("Y-m-d H:i:s");
		$Fecha_Actualiza = date("Y-m-d H:i:s");
		
		$Latitud         = $this->input->post("Latitud");
		$Longitud        = $this->input->post("Longitud");

		$data_array = array($Id_Ticket, $Latitud, $Longitud, $Fecha_Alta, $Fecha_Actualiza);
		$result     = $this->App_model->CALL_SPINS_Ticket_Coordenadas($data_array);

		$json = array(
			"res" => "ERR",
			"msg" => "Mmm, hubo un error al guardar, verifíque que el código qr sea el correcto"
		);

		if(isset($result->Id)){
			#	Actualiza Status
			//$this->actualizaStatus($Id_Ticket,3);

			$json = array(
							"res" => "OK",
							"query" => $result
						);
		}

		echo json_encode($json);
	}

	/**
	 * GUARDA EL DIAGNOSTICO PASO 2
	 */
	public function guardaDiagnostico(){
		#	Recibe variables post
		$Id_Ticket       = $this->input->post("Id_Ticket");
		$Diagnostico     = $this->input->post("diagnostico");
		$Material        = $this->input->post("material");
		
		#	Guarda Diagnostico
		$data_array = array($Id_Ticket,$Diagnostico,$Material);
		$result = $this->App_model->CALL_SPINS_Ticket_Diagnostico($data_array);
		if(!$result){		
			echo json_encode(array("res" => "ERR", "msg" => "Uh oh! Hubo un error al guardar, intentalo nuevamente"));
			exit();
		}

		#	Array de validaciones del file
		$rules_file = array(
				"upload_path"   => "./ticketsfiles",
				"allowed_types" => "jpg|jpeg|png",
				"max_size"      => 50120,
				"encrypt_name"  => true
			);

		#	Carga la libreria con las configuraciones
		$this->load->library("upload",$rules_file);

		#	Se suben las imagenes y se insertan en b.d.
		foreach ($_FILES as $filek => $filev) {
			if($this->upload->do_upload($filek)){
				$nombre_foto = $this->upload->data("file_name");

				$data_array  = array($Id_Ticket,1,$nombre_foto,);
				$resfoto = $this->App_model->CALL_SPINS_Evidencia_Fotos($data_array);
				if(!$resfoto){
					echo json_encode(array("res" => "ERR", "msg" => "Uh oh! Hubo un error al cargar alguna de las fotos, intentalo nuevamente"));
					exit();
				}
			}else{
				echo json_encode(array("res" => "ERR","msg" => $this->upload->display_errors(" ","\n")));
				exit();
			}		
		}

		#	Actualiza Status
		$this->actualizaStatus($Id_Ticket,3);

		#	Mensaje de exito si llegó hasta aquí
		echo json_encode(array("res" => "OK", "query" => $result));
	}	


	/**
	 * TRAE EN JSON LOS TIEMPOS
	 */
	public function traerTiempos(){
		#	Variables del tiempo	
		$Id_Ticket = $this->input->post("Id_Ticket");
		$fecha = date("Y-m-d H:i:s");
		
		#	Consulta los registros de tiempo en un ticket
		$data_array = array($Id_Ticket,$fecha);
		$tiemposi = $this->App_model->CALL_SPCNS_Tiempos_Ticket($data_array);

		echo json_encode(array("res" => "OK", "query" => $tiemposi));
		
	}

	/**
	 * GUARDA TIEMPOS PASO 3 STATUS 4/5
	 * @return [type] [description]
	 */
	public function guardarTiempo(){
		#	Variables del post
		$terminado = $this->input->post("terminado");
		$Id_Ticket = $this->input->post("Id_Ticket");
		$Tipo      = $this->input->post("tipo");
		$Fecha     = date("Y-m-d H:i:s");
		$Razon     = $this->input->post("razon");
		
		#	Parametros del insert
		$data_array = array($Id_Ticket, $Tipo, $Fecha, $Razon);

		$result = $this->App_model->CALL_SPINS_Tiempo_Ticket($data_array);
		
		$json = array(
			"res" => "ERR",
			"msg" => "Error al guardar tiempo"
		);

		if($result){
			$json = array(
							"res" => "OK",
							"query" => $result
						);
			
			#	Actualiza Status
			if(isset($terminado)){
			 	$this->actualizaStatus($Id_Ticket,7);
			}else{
				if($Tipo == 1){
					$this->actualizaStatus($Id_Ticket,5);
					$Razon = "REANUDADO";
				}else{
					$this->actualizaStatus($Id_Ticket,6);
				}
			}
		}

		echo json_encode($json);
	}

	/**
	 * GUARDA LA EVIDENCIA FOTOGRAFICA
	 * PASO 4 
	 */
	public function guardaEvidencia(){
		#	Recibe variables post
		$Id_Ticket       = $this->input->post("Id_Ticket");

		#	Array de validaciones del file
		$rules_file = array(
				"upload_path"   => "./ticketsfiles",
				"allowed_types" => "jpg|jpeg|png",
				"max_size"      => 50120,
				"encrypt_name"  => true
			);

		#	Carga la libreria con las configuraciones
		$this->load->library("upload",$rules_file);

		#	Se suben las imagenes y se insertan en b.d.
		foreach ($_FILES as $filek => $filev) {
			if($this->upload->do_upload($filek)){
				$nombre_foto = $this->upload->data("file_name");

				$data_array = array($Id_Ticket,2,$nombre_foto);
				$resfoto = $this->App_model->CALL_SPINS_Evidencia_Fotos($data_array);
				if(!$resfoto){
					echo json_encode(array("res" => "ERR", "msg" => "Uh oh! Hubo un error al cargar alguna de las fotos, intentalo nuevamente"));
					exit();
				}
			}else{
				echo json_encode(array("res" => "ERR","body" => $this->upload->display_errors(" ","\n")));
				exit();
			}		
		}

		#	Actualiza Status
		$this->actualizaStatus($Id_Ticket,4);
		
		#	Mensaje de exito si llegó hasta aquí
		echo json_encode(array("res" => "OK", "query" => "Evidencia guardada"));
	}

	/**
	 * GUARDA LA FOTO DE DOCUMENTO FINAL
	 * PASO 5 STATUS 6
	 */
	public function guardaFinal(){
		date_default_timezone_set("America/Mexico_City");

		#	Recibe variables post
		$Id_Ticket         = $this->input->post("Id_Ticket");
		$Costo             = 0.0;
		$Observaciones     = $this->input->post("observaciones");
		$Nombre_Supervisor = $this->input->post("nombre_supervisor");

		#	Array de validaciones del file
		$rules_file = array(
				"upload_path"   => "./ticketsfiles",
				"allowed_types" => "jpg|jpeg|png",
				"max_size"      => 50120,
				"encrypt_name"  => true
			);

		#	Carga la libreria con las configuraciones
		$this->load->library("upload",$rules_file);

		#	Se sube las imagen y se inserta en b.d.
		if($this->upload->do_upload("foto1")){
			$nombre_foto = $this->upload->data("file_name");
        	
        	#	Inserta en tabla de imagenes
        	$data_arrayf = array($Id_Ticket,3,$nombre_foto);
			$resfoto     = $this->App_model->CALL_SPINS_Evidencia_Fotos($data_arrayf);
			if(!$resfoto){
				echo json_encode(array("res" => "ERR", "msg" => "Uh oh! Hubo un error al cargar alguna de las fotos, intentalo nuevamente"));
				exit();
			}

			#	Inserta en tabla de finaliza
			$data_arrayd = array($Id_Ticket,$Costo,$Observaciones, $Nombre_Supervisor);
			$resdata     = $this->App_model->CALL_SPINS_Ticket_Finaliza($data_arrayd);
			if(!$resdata){
				echo json_encode(array("res" => "ERR", "msg" => "Uh oh! Hubo un error al guardar la información"));
				exit();
			}
		}else{
			echo json_encode(array("res" => "ERR","msg" => $this->upload->display_errors(" ","\n")));
			exit();
		}		
		
		#	Actualiza Status
		$this->actualizaStatus($Id_Ticket,5);

		#	Mensaje de exito si llegó hasta aquí
		echo json_encode(array("res" => "OK", "query" => "Evidencia guardada"));
	}

	/**
	 * CONSULTA DETALLE DEL TICKET POR SU ID
	 * @return [JSON] [TIKCET]
	 */
	public function consultaTicket(){
		#	Id_Galeria para saber si es UPDATE
		$Id_Ticket = $this->input->post("Id_Ticket");

		$ticket = $this->App_model->CALL_SPCNS_TicketByID($Id_Ticket);

		$json = array(
			"res" => "ERR",
			"msg" => "Mmm, este ticket no se encuentra mas en el sistema"
		);

		if($ticket){
			$json = array(
							"res" => "OK",
							"query" => $ticket
						);
		}

		echo json_encode($json);
		
	}

	/**
	 * CONSULTA LOS USUARIOS A LOS QUE SE LES PUEDE REASIGNAR EL TICKET
	 * @return [JSON] [USUARIOS]
	 */
	public function consultaUsuariosReasign(){
		$Id_Ticket = $this->input->post("Id_Ticket");
		$usuarios    = $this->App_model->CALL_SPCNS_Otros_Usuarios_Empresa($Id_Ticket);

		$json = array(
			"res" => "ERR",
			"msg" => "No tienes usuarios para reasignar"
		);

		if($usuarios){
			$json = array(
							"res" => "OK",
							"query" => $usuarios
						);
		}

		echo json_encode($json);
	}

	/**
	 * REASIGNA TICKET A OTRO USUARIO
	 * Y NOTIFICA AL NUEVO USUARIO
	 * @return [JSON] [RESULTADO DE LA OPERACIÓN]
	 */
	public function reasignarTicket(){
		#	Recibe variables post
		$Id_Ticket  = $this->input->post("Id_Ticket");
		$Id_Usuario = $this->input->post("Id_Usuario");

		// $Id_Ticket = 1; 
		// $Id_Usuario = 1;
	
		#	Array con las vars para el SP
		$data_array  = array($Id_Ticket, $Id_Usuario);
		$reasigna    = $this->App_model->CALL_SPUPD_Ticket_Usuario($data_array);

		$json = array(
			"res" => "ERR",
			"msg" => "Opps! Hubo un error al guardar, intenta nuevamente"
		);

		if($reasigna){
			$json = array(
							"res" => "OK",
							"msg" => "Registro guardado"
						);

			$datanoty = array(
					"titulo" => "Se te ha asignado un ticket",
					"mensaje" => "Se te ha asignado un ticket, revisalo en tu lista"
				);

			$oknoti = $this->sendNotificacion($Id_Usuario,$datanoty);
			if(!$oknoti){
				$res = array("head" => "WR:","msg" => "Ooops! Hubo un error al notifcar al usuario, itenta nuevamente");
			}
			
		}

		echo json_encode($json);
	}

	public function enviarCosto(){
		#	Recibe variables post
		$Id_Ticket  = $this->input->post("Id_Ticket");
		$Costo      = $this->input->post("Costo");

		#	Array con las vars para el SP
		$data_array  = array($Id_Ticket, $Costo);
		$ar    = $this->App_model->CALL_SPUPD_Finaliza_Ticket($data_array);

		$json = array(
			"res" => "ERR",
			"msg" => "Opps! Hubo un error al guardar, intenta nuevamente"
		);

		if($ar){
			$this->actualizaStatus($Id_Ticket, 6);
			$this->mandaPDFS($Id_Ticket);
			$json = array(
							"res" => "OK",
							"msg" => "Registro guardado"
						);
		}

		echo json_encode($json);
	}


	/**
	 * ACTUALIZA COORDENADAS DEL USUARIO DE LA APP MOVIL
	 */
	public function actualizaUbicacionUsuario(){
		#	Recibe variables post
		$Id_Usuario      = $this->input->post("Id_Usuario");		
		$Fecha_Actualiza = date("Y-m-d H:i:s");
		
		$Latitud         = $this->input->post("Latitud");
		$Longitud        = $this->input->post("Longitud");

		// $Id_Usuario = 5;
		// $Latitud = "54456";
		// $Longitud = "dasd";

		if(!$Latitud && !$Longitud){
			$Latitud  = 0;
			$Longitud = 0;
		}

		$data_array = array($Id_Usuario, $Latitud, $Longitud, $Fecha_Actualiza);
		$result     = $this->App_model->CALL_SPUPD_Ubicacion_Usuario($data_array);

		$json = array(
			"res" => "ERR",
			"msg" => "Error al enviar tu ubicación"
		);

		if($result){
			$json = array(
							"res" => "OK",
							"query" => $result
						);
		}

		echo json_encode($json);
	}
	


	/**
	 * ACTUALIZA STATUS DEL TICKET
	 * @param  INT $Id_Ticket IDENTIFICADOR DEL TICKET
	 * @param  INT $Status    STATUS NUEVO
	 */
	private function actualizaStatus($Id_Ticket, $Status){
		$data_array = array($Id_Ticket,$Status);
		$res = $this->App_model->CALL_SPUPD_Ticket_Status($data_array);
		return $res;
	}

	public function actualizaTokenFCM(){
		date_default_timezone_set("America/Mexico_City");
		
		#	Variables
		$Fecha_Actualiza = date("Y-m-d H:i:s");
		$Id_Usuario      = $this->input->post("Id_Usuario");
		$TokenFCM        = $this->input->post("token");
		
		$data_array = array($Id_Usuario,$TokenFCM,$Fecha_Actualiza);
		$res = $this->App_model->CALL_SPUPDA_Token_Usuario($data_array);

		$json = array(
			"res" => "ERR",
			"msg" => "Hubo un error al actualizar el Token FCM"
		);

		if($res){
			$json = array(
							"res" => "OK",
							"msg" => "Token actualizado"
						);
		}

		echo json_encode($json);
	}

	/**
	 * MANDA UN CORREO A LOS USUARIOS CORRESPONDIENTES 
	 * CON EL PDF ADJUNTO DEL TICKET
	 * @param  [INT] $Id_Ticket [ID DEL TICKET]
	 * @return [BOOLEAN]        [RESULTADO DEL ENVÍO]
	 */
	private function mandaPDFS($Id_Ticket){		
		#	Configuración email
		$mailsitio = $this->getConfiguration("MAIL");	

		$data["ticket"]	= $this->App_model->CALL_SPCNS_TicketByID($Id_Ticket);	
			
		#	Envía correo a usuario
		$mensaje = $this->load->view("templates/correos/ticket-cerrado",$data,true);
		$arraycorreo = array(
			"remitente_mail" => $mailsitio["SMTPUSER"],
			"remitente_name" => $mailsitio["NAMEREMT"],
			"destinatario"   => $this->getCorreosTicket($Id_Ticket),
			"asunto"         => "Ticket cerrado",
			"mensaje"        => $mensaje,
		);

		// echo $mensaje;
		#	Genera pdf y lo guarda temporalmente
		$pdfattach = $this->genPdf($data["ticket"]->Num_Seguimiento);
		if(is_file($pdfattach)){
			$arraycorreo["attach"] = $pdfattach;
		}
		#	Envía correo
		$resmail = $this->enviaCorreo($arraycorreo);
		#	Borrac pdf
		if(is_file($pdfattach)){
			unlink($pdfattach);
		}

		return $resmail;
	}

	/**
	 * GENERA PDF Y LO GUARDA EN temppdfs
	 * @param  [type] $Num_Seguimiento [NUMERO DE SEGUIMIENTO DEL TICKET]
	 * @return [type]                  [RUTA DONDE SE GUARDÓ]
	 */
	private function genPdf($Num_Seguimiento){
		$this->load->model("Tickets_model");
		$ticket = $this->App_model->CNS_TicketByNum($Num_Seguimiento);
		$data = array(
			"ticket"             => $ticket,
			"ticket_diagnostico" => $this->App_model->CNS_TicketDiagnostico($ticket["Id_Ticket"]),
			"ticket_imagenesi"   => $this->App_model->CNS_TicketImagenes($ticket["Id_Ticket"],1),
			"ticket_imagenesf"   => $this->App_model->CNS_TicketImagenes($ticket["Id_Ticket"],2),
			"ticket_finaliza"	 => $this->App_model->CNS_TicketFinaliza($ticket["Id_Ticket"]),
			"reporte"  		 	 => $this->App_model->CNS_TicketImagenes($ticket["Id_Ticket"],3),
		);

		$head = $this->load->view("templates/docs/pdf_header_ticket", null, true);
		$html1 = $this->load->view("templates/docs/pdf_ticket_1", $data, TRUE);
		$html2 = $this->load->view("templates/docs/pdf_ticket_2", $data, TRUE);
			
		$this->load->library("Pdf");
		$pdf = $this->pdf->load("","Letter",12,"helvetica",15,15,35,10,9,9,"P");	
		$pdf->SetHTMLHeader($head);
		$pdf->WriteHtml($html1);
		$pdf->AddPage();
		$pdf->WriteHtml($html2);
		
		$output = "./temppdfs/".$Num_Seguimiento.".pdf";
		$pdf->Output($output);
		return $output;
	}

	/**
	 * TRAE UN ARRAY INDEXADO DE LOS CORREOS A LOS QUE 
	 * SE LES DEBE ENVIAR CC DE UN TICKET
	 * @param  [INT] $Id_Ticket [IDENTIFICADOR DEL TICKET]
	 * @return [ARRAYINDEX]     [ARRAY CON LOS CORREOS]
	 */
	private function getCorreosTicket($Id_Ticket){
		$data_array = array($Id_Ticket);
		$correos = $this->App_model->CALL_SPCNS_Usuarios_CC($data_array);

		$arraycorreos = array();
		foreach ($correos as $key => $value) {
			array_push($arraycorreos, $value["Usuario"]);
		}
		
		return $arraycorreos;
	}
}
// SPNINS_Ticket_Diagnostico