<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proveedores_model extends CI_Model {
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	/**
	  *	CUENTA EL TOTAL DE USUARIOS EN LA TABLA
	  */
	function COUNT_Usuarios($Id_Empresa){
		$this->db->select("Id_Usuario");
		$this->db->from("Usuarios");
		$this->db->where("Rol", "PRVD");
		$this->db->where("Id_Empresa", $Id_Empresa);
		return $this->db->count_all_results();
	}

	/**
	 * CONSULTA USUARIOS PROVEEDORES 
	 * CON PARÁMETRO DE PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_Usuarios($Id_Empresa, $Skip, $Take, $Order_Field, $Order){
		$this->db->select("CONCAT(e.Codigo, ' - ', e.Razon_Social) as Empresa, e.Logo, e.Status, u.Id_Usuario, 
						   Usuario, CONCAT(u.Nombre, ' ', u.Apellidos) AS Nombre");
		$this->db->from("Usuarios as u");
		$this->db->join("Roles as r", "Rol = r.Abreviatura", "inner");
		$this->db->join("Empresas as e", "e.Id_Empresa = u.Id_Empresa", "inner");
		$this->db->where("e.Id_Empresa !=", $Id_Empresa);
		$this->db->where("u.Rol", "PRVD");
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA USUARIOS SERVICIOS 
	 * CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_Usuarios_Match($Id_Empresa, $Skip, $Take, $Order_Field, $Order, $Match){
		$this->db->select("CONCAT(e.Codigo, ' - ', e.Razon_Social) as Empresa, e.Logo, e.Status, u.Id_Usuario, 
						   Usuario, CONCAT(u.Nombre, ' ', u.Apellidos) AS Nombre");
		$this->db->from("Usuarios as u");		
		$this->db->join("Empresas as e", "e.Id_Empresa = u.Id_Empresa", "inner");
		$this->db->like("CONCAT(e.Razon_Social, u.Usuario, ' ', u.Nombre, ' ', u.Apellidos)", $Match);
		$this->db->where("e.Id_Empresa !=", $Id_Empresa);
		$this->db->where("u.Rol", "PRVD");
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA UN USUARIO POR SU ID 
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 */
	function CNS_UsuarioByID($Id_Usuario){
		$this->db->select("e.Id_Empresa,e.Codigo, e.Razon_Social, e.Logo, e.Status, u.Id_Usuario, u.Clave,
						   Usuario, u.Nombre, u.Apellidos, t.Tiempo_1, t.Tiempo_2");
		$this->db->from("Usuarios as u");		
		$this->db->join("Empresas as e", "e.Id_Empresa = u.Id_Empresa", "inner");
		$this->db->join("Tiempos_Usuario as t", "u.Id_Usuario = t.Id_Usuario", "left");	
		$this->db->where("u.Id_Usuario", $Id_Usuario);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA LA CLAVE MÁS ALTA DE LOS
	 * USUARIOS
	 */
	function CNS_LastUsuario(){
		$this->db->select("Id_Usuario,Clave");
		$this->db->from("Usuarios");
		$this->db->order_by("Clave", "DESC");
		$query = $this->db->get();
		return $query->row_array();	
	}

	/**
	 * INSERTA EMPRESA
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Empresa($datarray){
		$this->db->insert("Empresas", $datarray);
		return $this->db->insert_id();
	}

	/**
	 * INSERTA USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Usuario($datarray){
		$this->db->insert("Usuarios", $datarray);
		return $this->db->insert_id();
	}

	/**
	 * ACTUALIZA EN TABLA EMPRESAS
	 * @param INT $Id_Empresa IDENTIFICADOR DEL USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Empresa($Id_Empresa,$datarray){
		$this->db->where("Id_Empresa", $Id_Empresa);
		$this->db->update("Empresas", $datarray);
		return $this->db->affected_rows();
	}

	/**
	 * ACTUALIZA EN TABLA USUARIOS
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Usuario($Id_Usuario,$datarray){
		$this->db->where("Id_Usuario", $Id_Usuario);
		$this->db->update("Usuarios", $datarray);
		return $this->db->affected_rows();
	}

	/**
	 * ELIMINA EMPRESA POR SU ID
	 * @param INT $Id_Empresa IDENTIFICADOR DE LA EMPRESA
	 */
	function DEL_Empresa($Id_Empresa){
		$this->db->where("Id_Empresa", $Id_Empresa);
		$this->db->delete("Empresas");
		return $this->db->affected_rows();
	}

	/**
	 * ELIMINA USUARIO POR ID EMPRESA
	 * @param INT $Id_Empresa IDENTIFICADOR DE LA EMPRESA
	 */
	function DEL_Usuarios_Empresa($Id_Empresa){
		$this->db->where("Id_Empresa", $Id_Empresa);
		$this->db->delete("Usuarios");
		return $this->db->affected_rows();
	}

	/**
	 * INSERTA TIEMPOS USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Tiempos_Usuario($datarray){
		$this->db->insert("Tiempos_Usuario", $datarray);
		return $this->db->insert_id();
	}

	/**
	 * ELIMINA TIEMPO_USUARIO POR ID_USUARIP
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 */
	function DEL_Tiempo_Usuario($Id_Usuario){
		$this->db->where("Id_Usuario", $Id_Usuario);
		$this->db->delete("Tiempos_Usuario");
		return $this->db->affected_rows();
	}

	/**
	 * ACTUALIZA EN TABLA TIEMPOS USUARIO POR ID DE USUARIO
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Tiempo_Usuario($Id_Usuario,$datarray){
		$this->db->where("Id_Usuario", $Id_Usuario);
		$this->db->update("Tiempos_Usuario", $datarray);
		return $this->db->affected_rows();
	}
}

/* End of file Proveedores_model.php */
/* Location: ./application/models/Proveedores_model.php */