<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Clasificacionesticket_model extends CI_Model {
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	
	/**
	  *	CUENTA EL TOTAL DE CLASIFICACIONES EN LA TABLA
	  */
	function COUNT_Clasificaciones(){
		$this->db->select("Id_Clasificacion_Ticket");
		$this->db->from("Clasificaciones_Ticket");
		return $this->db->count_all_results();
	}

	/**
	 * CONSULTA CLASIFICACIONES EN LA TABLA
	 * CON PARÁMETRO DE PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_Clasificaciones($Skip, $Take, $Order_Field, $Order){
		$this->db->select("Id_Clasificacion_Ticket, Clave, Nombre, Descripcion, IF(Status = 1, 'Activo', 'Inactivo') AS Status");
		$this->db->from("Clasificaciones_Ticket");
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA CLASIFICACIONES EN LA TABLA
	 * CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_Clasificaciones_Match($Skip, $Take, $Order_Field, $Order, $Match){
		$this->db->select("Id_Clasificacion_Ticket, Clave, Nombre, Descripcion, IF(Status = 1, 'Activo', 'Inactivo') AS Status");
		$this->db->from("Clasificaciones_Ticket");
		$this->db->like("CONCAT(Clave, ' ', Nombre, ' ', Descripcion)", $Match);
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA UNA CLASIFICACION POR SU ID
	 * @param INT $Id_Clasificacion_Ticket IDENTIFICADOR DE LA TABLA
	 */
	function CNS_ClasificacionByID($Id_Clasificacion_Ticket){
		$this->db->select("Id_Clasificacion_Ticket, Clave, Nombre, Descripcion, Status");
		$this->db->from("Clasificaciones_Ticket");
		$this->db->where("Id_Clasificacion_Ticket", $Id_Clasificacion_Ticket);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA LA CLAVE MÁS ALTA DE LAS CLASIFICACIONES
	 */
	function CNS_LastClasificacion(){
		$this->db->select("SUBSTRING(Clave, '-2', '2') AS Last");
		$this->db->from("Clasificaciones_Ticket");
		$this->db->where("SUBSTRING(Clave, 1, 7) =", "CLASTKT");
		$this->db->order_by("Id_Clasificacion_Ticket", "DESC");
		$query = $this->db->get();
		return $query->row_array();	
	}

	/**
	 * ACTUALIZA EN TABLA CLASIFICACIONES TICKET
	 * @param INT $Id_Clasificacion_Ticket IDENTIFICADOR DEL CLASIFICACIÓN
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Clasificacion($Id_Clasificacion_Ticket,$datarray){
		$this->db->where("Id_Clasificacion_Ticket", $Id_Clasificacion_Ticket);
		$this->db->update("Clasificaciones_Ticket", $datarray);
		return $this->db->affected_rows();
	}

	/**
	 * INSERTA CLASIFICACIÓN
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Clasificacion($datarray){
		$this->db->insert("Clasificaciones_Ticket", $datarray);
		return $this->db->insert_id();
	}

	/**
	 * ELIMINA CLASIFICACIÓN POR SU ID
	 * @param INT $Id_Clasificacion_Ticket IDENTIFICADOR DEL CLASIFICACIÓN
	 */
	function DEL_Clasificacion($Id_Clasificacion_Ticket){
		$this->db->where("Id_Clasificacion_Ticket", $Id_Clasificacion_Ticket);
		$this->db->delete("Clasificaciones_Ticket");
		return $this->db->affected_rows();
	}
}

/* End of file Clasificacionesticket_model.php */
/* Location: ./application/models/Clasificacionesticket_model.php */