<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboards_model extends CI_Model
{
	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	/**
	 *	CUENTA TICKETS ABIERTOS
	 */
	function COUNT_Tickets_Abiertos($Filtro_Usuarios)
	{
		$this->db->select("Id_Ticket");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "inner");
		$this->db->where("s.Orden <=", 7);
		$this->db->where("s.Orden >=", 1);
		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				//$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		return $this->db->count_all_results();
	}

	/**
	 *	CONSULTA TICKETS EN PROCESO
	 */
	function CNS_Tickets_En_Proceso($Filtro_Usuarios)
	{
		$this->db->select("t.Id_Ticket, t.Num_Seguimiento, e.Razon_Social, COALESCE(u.Nombre, 'Indefinido') as Usuario, d.Sucursal,
    					   d.Latitud, d.Longitud, s.Orden, s.Nombre as Status, t.Fecha_Alta,");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->group_by("t.Id_Ticket");
		$this->db->where("s.Orden >", 2);
		$this->db->where("s.Orden <", 7);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				//$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		$data = $this->db->get();
		return $data->result_array();
	}

	/**
	 *	CONSULTA SIN ATENDER
	 */
	function CNS_Tickets_Sin_Atender($Filtro_Usuarios)
	{
		$this->db->select("t.Id_Ticket, t.Num_Seguimiento, e.Razon_Social, COALESCE(u.Nombre, 'Indefinido') as Usuario, d.Sucursal,
    					  d.Latitud, d.Longitud,s.Orden, s.Nombre as Status, t.Fecha_Alta");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->group_by("t.Id_Ticket");
		$this->db->where("s.Orden <", 4);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				//$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		$data = $this->db->get();
		return $data->result_array();
	}

	/**
	 *	CONSULTA ABIERTOS  
	 */
	function CNS_Tickets_Abiertos($Filtro_Usuarios)
	{
		$this->db->select("t.Id_Ticket, t.Num_Seguimiento, e.Razon_Social, COALESCE(u.Nombre, 'Indefinido') as Usuario, d.Sucursal,
    					   d.Latitud, d.Longitud, s.Orden, s.Nombre as Status, t.Fecha_Alta");
		$this->db->from("Tickets as t");
		$this->db->join("Status_Ticket as s", "t.Id_Status_Ticket = s.Id_Status_Ticket", "left");
		$this->db->join("Direcciones as d", "t.Id_Direccion = d.Id_Direccion", "left");
		$this->db->join("Usuarios as u", "t.Id_Usuario = u.Id_Usuario", "left");
		$this->db->join("Empresas as e", "u.Id_Empresa = e.Id_Empresa", "left");
		$this->db->group_by("t.Id_Ticket");
		$this->db->where("s.Orden <", 7);

		#	Filtros
		switch ($Filtro_Usuarios["Referencia"]) {
			case "Registra":
				//$this->db->where("t.Usuario_Registra", $Filtro_Usuarios["ID"]);
				break;
			case "Empresa":
				$this->db->where("u.Id_Empresa", $Filtro_Usuarios["ID"]);
		}

		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA SUCURSALES ACTIVAS / INACTIVAS
	 * @param INT $Status STATUS 1/0
	 */
	function CNS_Sucursales($Status)
	{
		$this->db->select("e.Codigo,e.Razon_Social,d.Sucursal,d.Latitud,d.Longitud");
		$this->db->from("Empresas as e");
		$this->db->join("Direcciones as d", "e.Id_Empresa = d.Id_Empresa", "inner");
		$this->db->where("e.Status", $Status);
		$this->db->where("d.Status", $Status);
		$data = $this->db->get();
		return $data->result_array();
	}

	/**
	 * CONSULTA LAS UBICACIONES DE LOS USUARIOS ACTIVOS
	 */
	function CNS_UbicacionUsuarios()
	{
		$this->db->select("u.Id_Usuario, u.Nombre, d.Latitud, d.Longitud, c.Fecha_Actualiza");
		$this->db->from("Usuarios as u");
		$this->db->join("Ubicacion_Usuarios as c", "u.Id_Usuario = c.Id_Usuario", "inner");
		$this->db->where("u.Status", 1);
		$data = $this->db->get();
		return $data->result_array();
	}
}
