<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Master_model extends CI_Model {
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}
	
	/**
	 * CONSULTA VARIABLES DE CORREO DE LA TABLA CONFIGURADOR
	 */
	function CNS_Configuracion($Grupo){
		$this->db->select("Abreviatura,Valor");
		$this->db->from("Configuracion");
		$this->db->where("Grupo", $Grupo);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA DATA DE USUARIOS ACTIVOS CON CIERTO PERMISO
	 * @param [STRING] $datausuario [DATA QUE SE QUIERE TRAER DEL USUARIO]
	 * @param [STRING] $seccion     [SECCION A LA QUE TIENE PERMISO]
	 */
	function CNS_UsuariosConPermiso($datausuario,$seccion){
		$this->db->select($datausuario . " AS DATO");
		$this->db->from("Secciones as s");
		$this->db->join("Rel_Rol_Seccion AS rel", "s.Id_Seccion = rel.Id_Seccion", "right");
		$this->db->join("Roles as r", "rel.Rol = r.Abreviatura", "right");
		$this->db->join("Usuarios as u", "r.Abreviatura = u.Rol", "right");
		$this->db->join("Cuentas as c", "u.Id_Cuenta = c.Id_Cuenta", "right");
		$this->db->where("s.Abreviatura", $seccion);
		$this->db->where("c.Status", 1);

		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA UN USUARIO POR SU ID
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 */
	function CNS_UsuarioByID($Id_Usuario){
		$this->db->select("u.Id_Usuario, u.Nombre, u.Usuario,u.TokenFCM, r.Nombre as Rol");
		$this->db->from("Usuarios as u");
		$this->db->join("Roles as r", "u.Rol = r.Abreviatura", "inner");
		$this->db->where("u.Id_Usuario", $Id_Usuario);
		$query = $this->db->get();
		return $query->row_array();
	}
}

/* End of file Utilerias_model.php */
/* Location: ./application/models/Utilerias_model.php */