<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Usuarios_model extends CI_Model {
	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	/**
	  *	CUENTA EL TOTAL DE USUARIOS EN LA TABLA
	  */
	function COUNT_Usuarios($Id_Empresa, $Match, $Filtro_Usuarios){
		$this->db->select("u.Id_Usuario");
		$this->db->from("Usuarios as u");
		$this->db->join("Roles as r", "u.Rol = r.Abreviatura", "inner");
		$this->db->like("CONCAT(u.Usuario, ' ', u.Nombre, ' ', u.Apellidos)", $Match);
		$this->db->where("u.Id_Empresa", $Id_Empresa);

		if(sizeof($Filtro_Usuarios) > 0){
			$this->db->where_in("r.Abreviatura", $Filtro_Usuarios);
		}

		return $this->db->count_all_results();
	}


	/**
	 * CONSULTA USUARIOS DE LA EMPRESA 
	 * CON PARÁMETRO DE PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_Usuarios($Id_Empresa, $Skip, $Take, $Order_Field, $Order, $Filtro_Usuarios){
		$this->db->select("u.Id_Usuario, u.Clave, u.Usuario, r.Nombre as Rol, CONCAT(u.Nombre, ' ', u.Apellidos) AS Nombre, u.Status");
		$this->db->from("Usuarios as u");
		$this->db->join("Roles as r", "u.Rol = r.Abreviatura", "inner");
		$this->db->where("u.Id_Empresa", $Id_Empresa);

		if(sizeof($Filtro_Usuarios) > 0){
			$this->db->where_in("r.Abreviatura", $Filtro_Usuarios);
		}
		
		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA USUARIOS DE LA EMPRESA 
	 * CON PARÁMETRO DE BÚSQUEDA, PAGINACIÓN Y ORDENAMIENTO
	 */
	function CNS_Usuarios_Match($Id_Empresa, $Skip, $Take, $Order_Field, $Order, $Match, $Filtro_Usuarios){
		$this->db->select("u.Id_Usuario, u.Clave, u.Usuario, r.Nombre as Rol, CONCAT(u.Nombre, ' ', u.Apellidos) AS Nombre, u.Status");
		$this->db->from("Usuarios as u");
		$this->db->join("Roles as r", "u.Rol = r.Abreviatura", "inner");
		$this->db->like("CONCAT(u.Usuario, ' ', u.Nombre, ' ', u.Apellidos)", $Match);
		$this->db->where("u.Id_Empresa", $Id_Empresa);

		if(sizeof($Filtro_Usuarios) > 0){
			$this->db->where_in("r.Abreviatura", $Filtro_Usuarios);
		}

		$this->db->order_by($Order_Field, $Order);
		$this->db->limit($Take,$Skip);
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA LA CLAVE MÁS ALTA DE LOS
	 * USUARIOS
	 */
	function CNS_LastUsuario(){
		$this->db->select("Id_Usuario,Clave");
		$this->db->from("Usuarios");
		$this->db->order_by("Clave", "DESC");
		$query = $this->db->get();
		return $query->row_array();	
	}

	/**
	 * CONSULTA UN USUARIO POR SU ID 
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 */
	function CNS_UsuarioByID($Id_Usuario){
		$this->db->select("u.Id_Empresa, u.Rol, u.Id_Usuario, u.Clave, u.Usuario, 
						   u.Nombre, u.Apellidos, u.Status, t.Tiempo_1, t.Tiempo_2,
						   (SELECT COUNT(Seccion) FROM Rel_Rol_Seccion WHERE Rol = u.Rol AND Seccion = 'DTEC') AS DTEC");
		$this->db->from("Usuarios as u");	
		$this->db->join("Tiempos_Usuario as t", "u.Id_Usuario = t.Id_Usuario", "left");	
		$this->db->where("u.Id_Usuario", $Id_Usuario);
		$query = $this->db->get();
		return $query->row_array();
	}

	/**
	 * CONSULTA CATÁLOGO DE ROLES 
	 * A LOS QUE TIENE ACCESO EL ROL DE SESIÓN
	 */
	function CNS_Roles($Rol){
		$this->db->select("rol.Abreviatura, 
						   rol.Nombre,
						   (SELECT COUNT(Seccion) FROM Rel_Rol_Seccion WHERE Rol = rol.Abreviatura AND Seccion = 'DTEC') AS DTEC");
		$this->db->from("Rel_Rol_Seccion AS rel");
		$this->db->join("Roles AS rol", "rel.Seccion = rol.Abreviatura", "inner");
		$this->db->where("rel.Rol", $Rol);
		$this->db->order_by("rol.Nombre", "ASC");
		$query = $this->db->get();
		return $query->result_array();
	}

	/**
	 * CONSULTA SI HAY RELACION ENTRE UN ROL Y UN PERMISO
	 * @param [STRING] $Rol     [ROL]
	 * @param [STRING] $Seccion [SECCION]
	 */
	function CNS_Permiso_Rol($Rol, $Seccion){
		$this->db->select("COUNT(Seccion)");
		$this->db->from("Rel_Rol_Seccion");
		$this->db->where("Rol", $Rol);
		$this->db->where("Seccion", $Seccion);
		return $this->db->count_all_results();
	}	

	/**
	 * ACTUALIZA EN TABLA USUARIOS
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function UPD_Usuario($Id_Usuario,$datarray){
		$this->db->where("Id_Usuario", $Id_Usuario);
		$this->db->update("Usuarios", $datarray);
		return $this->db->affected_rows();
	}

	/**
	 * INSERTA USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Usuario($datarray){
		$this->db->insert("Usuarios", $datarray);
		return $this->db->insert_id();
	}

	/**
	 * ELIMINA USUARIO POR SU ID
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 */
	function DEL_Usuario($Id_Usuario){
		$this->db->where("Id_Usuario", $Id_Usuario);
		$this->db->delete("Usuarios");
		return $this->db->affected_rows();
	}

	/**
	 * INSERTA TIEMPOS USUARIO
	 * @param ARRAY $dataarray ARRAY ASOCIATIVO CON 
	 * LOS DATOS A GUARDAR
	 */
	function INS_Tiempos_Usuario($datarray){
		$this->db->insert("Tiempos_Usuario", $datarray);
		return $this->db->insert_id();
	}

	/**
	 * ELIMINA TIEMPO_USUARIO POR ID_USUARIP
	 * @param INT $Id_Usuario IDENTIFICADOR DEL USUARIO
	 */
	function DEL_Tiempo_Usuario($Id_Usuario){
		$this->db->where("Id_Usuario", $Id_Usuario);
		$this->db->delete("Tiempos_Usuario");
		return $this->db->affected_rows();
	}
}

/* End of file Usuarios_model.php */
/* Location: ./application/models/Usuarios_model.php */