rules_validation = {
  txtfecha: {
    required: true,
    dateISO: true
  },
  txtnoseguimiento: {
    required: true,
    maxlength: 20
  },
  cmbclasificacion: {
    required: true,
    digits: true
  },
  cmbcliente: {
    required: true,
    digits: true
  },
  cmbdireccion: {
    required: true,
    digits: true
  },
  txadescripcion: {
    required: true,
    maxlength: 200
  },
  txaobservaciones: {
    maxlength: 500
  },
  cmbasignado: {
    required: true,
    digits: true
  }
};

rules_validation_2 = {
  txadiagnostico: {
    required: true,
    maxlength: 800
  },
  txamaterial: {
    maxlength: 1000
  },
  txaobservaciones: {
    maxlength: 500
  },
  nmbcosto: {
    required: true,
    number: true
  }
};
// INICIALIZA DATATABLE
$("#data-table").DataTable({
  processing: true,
  serverSide: true,
  order: [[0, "desc"]],
  language: {
    url: base_url + "assets/libs/data-tables/json/spanish.json"
  },
  createdRow: function(row, data, dataIndex) {
    switch (
      parseInt(data.Orden)
      // case 1:
      //     $(row).addClass("alert-yellow");
      //     break;
      // case 2:
      //     $(row).addClass("alert-green");
      //     break;
      // case 3:
      //     $(row).addClass("alert-aqua");
      //     break;
      // case 4:
      //     $(row).addClass("alert-pink");
      //     break;
      // case 5:
      //     $(row).addClass("alert-pink");
      //     break;
      // case 6:
      //     $(row).addClass("alert-blue");
      //     break;
    ) {
    }
  },
  responsive: {
    details: {
      display: $.fn.dataTable.Responsive.display.childRowImmediate,
      type: ""
    }
  },
  ajax: {
    url: base_url + "tickets/listarTicketsAbiertos",
    type: "get"
  },
  columns: [
    { data: "Fecha_Alta" },
    { data: "Num_Seguimiento" },
    { data: "Usuario" },
    { data: "Sucursal" },
    { data: "Clasificacion" },
    {
      data: "Prioridad",
      render: function(data, type, row) {
        switch (data) {
          case "Alta":
            return (
              "<span class='badge badge-border-danger'>" + data + "</span>"
            );
            break;
          case "Media":
            return (
              "<span class='badge badge-border-warning'>" + data + "</span>"
            );
            break;
          case "Normal":
            return (
              "<span class='badge badge-border-success'>" + data + "</span>"
            );
            break;
        }
        return data;
      }
    },
    {
      data: "Intervalo",
      render: function(data, type, row) {
        return (
          data +
          "<span class='semaforo' style='background-color:" +
          row.Alerta +
          "'></span>"
        );
      }
    },
    {
      data: "Status",
      render: function(data, type, row) {
        // console.log(row)
        switch (parseInt(row.Orden)) {
          case 1:
          case 2:
            return (
              "<span class='badge badge-warning'>" + row.Status + "</span>"
            );
            break;
          case 3:
            return "<span class='badge badge-info'>" + row.Status + "</span>";
            break;
          case 4:
            return "<span class='badge bg-red'>" + row.Status + "</span>";
            break;
          case 5:
            return "<span class='badge bg-violet'>" + row.Status + "</span>";
            break;
          case 6:
            return "<span class='badge bg-primary'>" + row.Status + "</span>";
            break;
          default:
            return "<span>" + row.Status + "</span>";
            break;
        }
      }
    },
    {
      data: "Id_Ticket",
      render: function(data, type, row) {
        var botones =
          "<div class='btn-group'>\
                <a href='" +
          base_url +
          "tickets/pdf/" +
          row.Num_Seguimiento +
          "' class='btn btn-sm btn-success' title='PDF' target='_blank'><i class='fa fa-file-pdf-o'></i></a>\
                <button type='button' class='btn btn-sm btn-primary btn-edit-reg' title='Editar'><i class='fa fa-pencil'></i></button>\
                <input type='hidden' value='" +
          data +
          "' class='Id_Ticket'/>";

        // si tiene permisos de cancelar
        if (row.CAN == 1) {
          botones +=
            "<button type='button' class='btn btn-sm btn-warning btn-cancel-reg' title='Cancelar'>\
                            <input type='hidden' class='Id_Ticket' value='" +
            data +
            "'>\
                            <i class='fa fa-ban'></i>\
                           </button>";
        }

        // si tiene permisos de eliminar
        if (row.DEL == 1) {
          botones +=
            "<button type='button' class='btn btn-sm btn-danger btn-delete-reg' title='Eliminar'>\
                            <input type='hidden' value='" +
            data +
            "' class='Id_Ticket'/>\
                            <i class='fa fa-trash'></i>\
                           </button>";
        }

        botones += "</div>";
        return botones;
      },
      orderable: false
    }
  ]
});

// ABRE FORMULARIO NUEVO
$(document).on("click", ".abre-formulario", function() {
  $("#show-listado").hide();
  $("#show-formulario").show();
  traerFormulario();
});

// LLAMA TRAER FORMULARIO (EDICIÓN)
$(document).on("click", ".btn-edit-reg", function() {
  Id_Ticket = $(this)
    .next(".Id_Ticket")
    .val();
  $("#show-listado").hide();
  $("#show-formulario").show();
  traerFormulario(Id_Ticket);
});

// CIERRA FORMULARIO NUEVO
$(document).on("click", ".cierra-formulario", function() {
  $("#show-formulario").hide();
  $("#show-listado").show();
});

// REFRESCA TABLA
$(document).on("click", ".refresh-table", function() {
  var table_refresh = $(this).attr("data-refresh");
  $("#" + table_refresh)
    .DataTable()
    .ajax.reload();
});

//  MANDA A A LLAMAR llenaCampoDireccion
$(document).on("change", "select[name='cmbdireccion']", function() {
  Id_Direccion = $(this).val();
  llenaCampoDireccion(Id_Direccion);
});

// ENVIAR FORMULARIO
$(document).on("submit", "#form-crud, #form-crud-2", function(e) {
  e.preventDefault();
  form = $(this);
  var dataString = new FormData(form[0]);
  if (form.valid()) {
    $.ajax({
      url: form.attr("action"),
      data: dataString,
      type: "post",
      processData: false,
      contentType: false,
      dataType: "json",
      beforeSend: function() {
        $("#spinner").show();
      },
      success: function(data) {
        console.log(data);
        $("#spinner").hide();
        if (data.head === "_er:") {
          Lobibox.notify("error", {
            position: "top center",
            size: "mini",
            msg: data.body
          });
        } else if (data.head === "_wr:") {
          $("#show-formulario").hide();
          $("#show-listado").show();
          Lobibox.notify("warning", {
            position: "top center",
            size: "mini",
            msg: data.body
          });
        } else if (data.head == "_ok:") {
          $("#show-formulario").hide();
          $("#show-listado").show();
          Lobibox.notify("success", {
            position: "top center",
            size: "mini",
            msg: data.body
          });
        }
      }
    });
  }
});

// CANCELAR REGISTRO
$(document).on("click", ".btn-cancel-reg", function() {
  Id_Ticket = $(this)
    .prev(".Id_Ticket")
    .val();
  Lobibox.prompt("text", {
    title: "Motivo de cancelación",
    buttons: {
      ok: {
        class: "lobibox-btn lobibox-btn-cancel",
        text: "Cancelar",
        closeOnClick: true
      },
      cancel: {
        class: "lobibox-btn lobibox-btn-default",
        text: "Abortar",
        closeOnClick: true
      }
    },
    callback: function(lobibox, type) {
      if (type === "ok") {
        $.ajax({
          url: base_url + "tickets/cancelarTicket",
          data: {
            Id_Ticket: Id_Ticket,
            observaciones: lobibox.getValue()
          },
          type: "post",
          dataType: "json",
          beforeSend: function() {
            $("#spinner").show();
          },
          success: function(data) {
            lobibox.destroy();
            $("#spinner").hide();
            if (data.head === "_er:") {
              Lobibox.notify("error", {
                position: "top center",
                size: "mini",
                msg: data.body
              });
            } else if (data.head == "_ok:") {
              Lobibox.notify("success", {
                position: "top center",
                size: "mini",
                msg: data.body
              });
            }
          }
        });
      }
    }
  });
});

// ELIMINAR REGISTRO
$(document).on("click", ".btn-delete-reg", function() {
  Id_Ticket = $(this)
    .find(".Id_Ticket")
    .val();
  Lobibox.confirm({
    title: "Espera...",
    msg: "¿Estás seguro de eliminar este registro?",
    callback: function(lobibox, type) {
      if (type == "yes") {
        $.ajax({
          url: base_url + "tickets/eliminarTicket",
          data: "Id_Ticket=" + Id_Ticket,
          type: "post",
          dataType: "json",
          beforeSend: function() {
            $("#spinner").show();
          },
          success: function(data) {
            lobibox.destroy();
            $("#spinner").hide();
            if (data.head === "_er:") {
              Lobibox.notify("error", {
                position: "top center",
                size: "mini",
                msg: data.body
              });
            } else if (data.head == "_ok:") {
              Lobibox.notify("success", {
                position: "top center",
                size: "mini",
                msg: data.body
              });
            }
          }
        });
      } else {
        lobibox.destroy();
      }
    }
  });
});

// FUNCIÓN PARA MOSTRAR FORMULARIO NUEVO / EDICION
function traerFormulario(Id_Ticket) {
  $.ajax({
    url: base_url + "tickets/muestraFormulario",
    data: "Id_Ticket=" + Id_Ticket,
    type: "post",
    beforeSend: function() {
      $("#spinner").show();
    },
    success: function(html) {
      $("#spinner").hide();
      $("#show-formulario .lienzo").html(html);

      // INICIALIZA INPUT FILE
      $("#form-crud input.inputfile").fileinput({
        maxFileSize: 8192,
        showCaption: false,
        browseLabel: "",
        removeLabel: "",
        elErrorContainer: "#kv-avatar-errors-1",
        msgErrorClass: "alert alert-block alert-danger",
        layoutTemplates: { main2: "{preview} {remove} {browse}" },
        allowedFileExtensions: ["jpg", "png", "jpeg"]
      });

      //ASIGNA VALIDACIONES AL FORM
      $("#form-crud").validate({
        rules: rules_validation
      });

      //ASIGNA VALIDACIONES AL
      //FORM DE LA CUADRILLA
      $("#form-crud-2").validate({
        rules: rules_validation_2
      });
    }
  });
}

//  LLENA EL TEXTAREA DE DIRECCIÓN CON LA INFORMACIÓN
//  DE LA SUCURSAL SELECCIONADA EN EL COMBO
function llenaCampoDireccion(Id_Direccion) {
  $.ajax({
    url: base_url + "tickets/muestraDireccion",
    data: "Id_Direccion=" + Id_Direccion,
    type: "post",
    dataType: "json",
    beforeSend: function() {
      $("#spinner").show();
    },
    success: function(data) {
      direccion = data
        ? data.Calle +
          " " +
          data.No_Ext +
          " " +
          data.No_Int +
          " " +
          data.Colonia +
          ", " +
          data.Municipio +
          " " +
          data.Estado
        : "";

      $("#spinner").hide();
      $("#direccion").val(direccion);
    }
  });
}
