rules_validation = {
    rdovalida: {
        required: true
    },
    txaobservaciones:{
        required: true,
        maxlength: 1000
    }
}
// INICIALIZA DATATABLE
$('#data-table').DataTable({
    processing: true,
    serverSide: true,
    order: [[0 , "desc" ]],
    language: {
      url: base_url+"assets/libs/data-tables/json/spanish.json",
    },
    responsive: {
        details: {
            display: $.fn.dataTable.Responsive.display.childRowImmediate,
            type: ''
        }
    },
    ajax: {
        url: base_url+"tickets/listarTicketsPorValidar",
        type: "post",
    },
    columns: [
        {data:"Fecha_Alta"},
        {data:"Num_Seguimiento"},
        {data:"Usuario"},
        {data:"Sucursal"},
        {data:"Clasificacion"},
        {data:"Intervalo",render:function(data, type, row){
                return data + "<span class='semaforo' style='background-color:"+row.Alerta+"'></span>";
        }},
        {data:"Id_Ticket",render:function(data, type, row){
             var botones = "<div class='btn-group'>\
                <a href='"+base_url+"tickets/pdf/"+row.Num_Seguimiento+"' class='btn btn-sm btn-success' title='PDF' target='_blank'><i class='fa fa-file-pdf-o'></i></a>\
                <input type='hidden' value='"+data+"' class='Id_Ticket'/>";
          //  console.log(row)
            // si tiene permisos de validar           
            if(row.VAL == 1){
                botones +="<button type='button' class='btn btn-sm btn-primary btn-edit-reg' title='Dar VoBo'>\
                            <input type='hidden' value='"+data+"' class='Id_Ticket'/>\
                            <i class='fa fa-check-circle'></i>\
                           </button>";            
            }
             // si tiene permisos de eliminar           
            if(row.DEL == 1){
                botones +="<button type='button' class='btn btn-sm btn-danger btn-delete-reg' title='Eliminar'>\
                            <i class='fa fa-trash'></i>\
                           </button>";            
            }
            

            botones  +="</div>";
            return botones;
        },
        orderable:false},
    ]
});


// REFRESCA TABLA
$(document).on("click",".refresh-table", function(){
    var table_refresh = $(this).attr("data-refresh");
    $("#"+table_refresh).DataTable().ajax.reload();
});

// LLAMA TRAER FORMULARIO (EDICIÓN)
$(document).on("click",".btn-edit-reg",function(){
    Id_Ticket = $(this).find(".Id_Ticket").val();
    $("#show-listado").hide();
    $("#show-formulario").show();
    traerFormulario(Id_Ticket);
});

// CIERRA FORMULARIO NUEVO
$(document).on("click",".cierra-formulario",function(){
    $("#show-formulario").hide();
    $("#show-listado").show();
});

// ELIMINAR REGISTRO
$(document).on("click",".btn-delete-reg",function(){
    Id_Ticket = $(this).prev(".Id_Ticket").val();
    Lobibox.confirm({
        title: "Espera...",
        msg: "¿Estás seguro de eliminar este registro?",
        callback: function(lobibox, type){
            if(type =="yes"){                
                $.ajax({
                    url: base_url+"tickets/eliminarTicket",
                    data: "Id_Ticket="+Id_Ticket,
                    type: "post",
                    dataType: "json",
                    beforeSend:function(){
                        $("#spinner").show();
                    },
                    success:function(data){
                        lobibox.destroy();
                        $("#spinner").hide();
                        if(data.head === "_er:"){
                            Lobibox.notify("error",{
                                position:"top center",
                                size:"mini",
                                msg:data.body
                            });
                        }else if(data.head == "_ok:"){
                            Lobibox.notify("success",{
                                position:"top center",
                                size:"mini",
                                msg:data.body
                            });
                        }
                    }
                });
            }else{
                lobibox.destroy();
            }
        }
    }); 
});

// ENVIAR FORMULARIO
$(document).on("submit","#form-crud",function(e){
    e.preventDefault();
    form = $(this);
    var dataString = new FormData(form[0]);
    if(form.valid()){
         $.ajax({
            url: form.attr("action"),
            data: dataString,
            type: "post",
            processData: false,
            contentType: false,
            dataType: "json",
            beforeSend:function(){
                $("#spinner").show();
            },
            success:function(data){
                console.log(data)
                $("#spinner").hide();
                if(data.head === "_er:"){
                    Lobibox.notify("error",{
                        position:"top center",
                        size:"mini",
                        msg:data.body
                    });
                }else if(data.head === "_wr:"){
                    $("#show-formulario").hide();
                    $("#show-listado").show();
                    Lobibox.notify("warning",{
                        position:"top center",
                        size:"mini",
                        msg:data.body
                    });
                }
                else if(data.head == "_ok:"){
                    $("#show-formulario").hide();
                    $("#show-listado").show();
                    Lobibox.notify("success",{
                        position:"top center",
                        size:"mini",
                        msg:data.body
                    });
                }
            }
        })
    }
});


// FUNCIÓN PARA MOSTRAR FORMULARIO NUEVO / EDICION
function traerFormulario(Id_Ticket){
     $.ajax({
        url: base_url+"tickets/muestraFormularioValida",
        data: "Id_Ticket="+Id_Ticket,
        type: "post",
        beforeSend:function(){
            $("#spinner").show();
        },
        success:function(html){
            $("#spinner").hide();
            $("#show-formulario .lienzo").html(html)

            //ASIGNA VALIDACIONES AL FORM
            $("#form-crud").validate({
                rules: rules_validation
            });
        }
    });
}